/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl;

import java.util.Map;
import org.eclipse.birt.data.engine.api.IBaseDataSetDesign;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.impl.CombinedOdaDataSetRuntime;
import org.eclipse.birt.data.engine.impl.DataEngineImpl;
import org.eclipse.birt.data.engine.impl.IQueryContextVisitor;
import org.eclipse.birt.data.engine.impl.PreparedOdaDSQuery;
import org.eclipse.birt.data.engine.impl.QueryExecutor;
import org.eclipse.birt.data.engine.impl.QueryOptimizeHints;
import org.eclipse.birt.data.engine.odi.IQuery;
import org.eclipse.datatools.connectivity.oda.spec.BaseQuery;
import org.eclipse.datatools.connectivity.oda.spec.QuerySpecification;
import org.eclipse.datatools.connectivity.oda.spec.basequery.AtomicQuery;
import org.eclipse.datatools.connectivity.oda.spec.basequery.CombinedQuery;

public class PreparedCombinedOdaDSQuery
extends PreparedOdaDSQuery {
    PreparedCombinedOdaDSQuery(DataEngineImpl dataEngine, IQueryDefinition queryDefn, IBaseDataSetDesign dataSetDesign, Map appContext, IQueryContextVisitor visitor) throws DataException {
        super(dataEngine, queryDefn, dataSetDesign, appContext, visitor);
    }

    @Override
    protected QueryExecutor newExecutor() throws DataException {
        return new CombinedDSQueryExecutor();
    }

    public class CombinedDSQueryExecutor
    extends PreparedOdaDSQuery.OdaDSQueryExecutor {
        public CombinedDSQueryExecutor() {
            super(PreparedCombinedOdaDSQuery.this);
        }

        @Override
        protected IQuery createOdiQuery() throws DataException {
            CombinedOdaDataSetRuntime extDataSet = (CombinedOdaDataSetRuntime)this.dataSet;
            assert (extDataSet != null);
            QueryOptimizeHints queryOptimizeHints = (QueryOptimizeHints)this.getAppContext().get("org.eclipse.birt.data.internal.optimize.hints");
            Map<String, QuerySpecification> optimizedDataSets = queryOptimizeHints.getOptimizedCombinedQuerySpec();
            QuerySpecification combinedQuerySpec = optimizedDataSets.get(extDataSet.getName());
            if (combinedQuerySpec != null) {
                this.reconstructQuerySpec(combinedQuerySpec, queryOptimizeHints, extDataSet);
            }
            return super.createOdiQuery();
        }

        private void reconstructQuerySpec(QuerySpecification querySpec, QueryOptimizeHints optimizeHints, CombinedOdaDataSetRuntime dataSet) {
            String dataSetName;
            String queryText;
            BaseQuery baseQuery = querySpec.getBaseQuery();
            if (baseQuery instanceof CombinedQuery) {
                this.reconstructQuerySpec(((CombinedQuery)baseQuery).getLeftQuery(), optimizeHints, dataSet);
                this.reconstructQuerySpec(((CombinedQuery)baseQuery).getRightQuery(), optimizeHints, dataSet);
            }
            if (baseQuery instanceof AtomicQuery && (queryText = dataSet.getQueryText(dataSetName = optimizeHints.getDataSetForAtomicQuery((AtomicQuery)baseQuery))) != null) {
                querySpec.setBaseQuery((BaseQuery)new AtomicQuery(queryText));
            }
        }
    }
}

