/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.examples.radar.render;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.birt.chart.computation.DataPointHints;
import org.eclipse.birt.chart.computation.DataSetIterator;
import org.eclipse.birt.chart.computation.ValueFormatter;
import org.eclipse.birt.chart.computation.withoutaxes.SeriesRenderingHints;
import org.eclipse.birt.chart.device.IDeviceRenderer;
import org.eclipse.birt.chart.device.IPrimitiveRenderer;
import org.eclipse.birt.chart.event.EventObjectCache;
import org.eclipse.birt.chart.event.LineRenderEvent;
import org.eclipse.birt.chart.event.OvalRenderEvent;
import org.eclipse.birt.chart.event.PolygonRenderEvent;
import org.eclipse.birt.chart.event.RectangleRenderEvent;
import org.eclipse.birt.chart.event.StructureSource;
import org.eclipse.birt.chart.event.TextRenderEvent;
import org.eclipse.birt.chart.event.WrappedStructureSource;
import org.eclipse.birt.chart.examples.radar.i18n.Messages;
import org.eclipse.birt.chart.examples.radar.model.type.RadarSeries;
import org.eclipse.birt.chart.examples.radar.render.RadarScaleHelper;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.chart.model.ChartWithoutAxes;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.ChartDimension;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.FormatSpecifier;
import org.eclipse.birt.chart.model.attribute.LineAttributes;
import org.eclipse.birt.chart.model.attribute.LineStyle;
import org.eclipse.birt.chart.model.attribute.Location;
import org.eclipse.birt.chart.model.attribute.Marker;
import org.eclipse.birt.chart.model.attribute.Palette;
import org.eclipse.birt.chart.model.component.Label;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.layout.ClientArea;
import org.eclipse.birt.chart.model.layout.Legend;
import org.eclipse.birt.chart.model.layout.Plot;
import org.eclipse.birt.chart.render.BaseRenderer;
import org.eclipse.birt.chart.render.ISeriesRenderingHints;
import org.eclipse.birt.chart.script.AbstractScriptHandler;
import org.eclipse.birt.chart.script.ScriptHandler;
import org.eclipse.birt.chart.util.ChartUtil;
import org.eclipse.birt.chart.util.FillUtil;
import org.eclipse.emf.common.util.EList;

public class Radar
extends BaseRenderer {
    public static final String STANDARD_SUBTYPE_LITERAL = "Standard Radar Chart";
    public static final String SPIDER_SUBTYPE_LITERAL = "Spider Radar Chart";
    public static final String BULLSEYE_SUBTYPE_LITERAL = "Bullseye Radar Chart";
    public static final String SCRIPT_KEY_WEB = "Web";
    public static final String SCRIPT_KEY_CATEGORY = "Category";
    static ILogger logger = Logger.getLogger("org.eclipse.birt.chart.examples/render");
    private double percentReduce = 0.2;
    private double dSafeSpacing = 10.0;
    private DataPointHints[] dpha = null;
    private ChartUtil.CacheDecimalFormat dfNumericFormatCache = null;
    private ChartUtil.CacheDateFormat dfDateFormatCache = null;
    private RadarScaleHelper scaleHelper;

    @Override
    public void compute(Bounds bo, Plot p, ISeriesRenderingHints isrh) throws ChartException {
        SeriesRenderingHints srh = (SeriesRenderingHints)isrh;
        this.validateDataSetCount(isrh);
        this.dpha = srh.getDataPoints();
        double[] da = srh.asPrimitiveDoubleValues();
        if (this.dpha == null || da == null || this.dpha.length < 1 || da.length < 1) {
            throw new ChartException("org.eclipse.birt.chart.engine.extension", 11, "exception.invalid.datapoint.dial", org.eclipse.birt.chart.engine.extension.i18n.Messages.getResourceBundle(this.getRunTimeContext().getULocale()));
        }
        if (this.scaleHelper == null) {
            this.scaleHelper = new RadarScaleHelper(this.getFirstSeries(), (ChartWithoutAxes)this.getModel());
        }
        this.scaleHelper.compute();
        double cvr = ((ChartWithoutAxes)this.getModel()).getCoverage();
        if (cvr <= 0.0) {
            cvr = 0.8;
        }
        this.percentReduce = 1.0 - cvr;
        this.dSafeSpacing *= this.getDeviceScale();
    }

    @Override
    public void renderSeries(IPrimitiveRenderer ipr, Plot p, ISeriesRenderingHints isrh) throws ChartException {
        SeriesDefinition sd = this.getSeriesDefinition();
        ChartWithoutAxes cwoa = (ChartWithoutAxes)this.getModel();
        if (cwoa.getDimension() != ChartDimension.TWO_DIMENSIONAL_LITERAL) {
            throw new ChartException("org.eclipse.birt.chart.engine.extension", 11, "exception.dial.dimension", new Object[]{cwoa.getDimension().getName()}, Messages.getResourceBundle(this.getRunTimeContext().getULocale()));
        }
        logger.log(1, Messages.getString("info.render.series", this.getRunTimeContext().getULocale()) + this.getClass().getName() + (this.iSeriesIndex + 1) + this.iSeriesCount);
        this.render(this.getDevice(), this.srh.getClientAreaBounds(true), (RadarSeries)this.getSeries(), sd);
    }

    @Override
    public void renderLegendGraphic(IPrimitiveRenderer ipr, Legend lg, Fill fPaletteEntry, Bounds bo) throws ChartException {
        double height;
        int iThisSeriesIndex;
        if (bo.getWidth() == 0.0 && bo.getHeight() == 0.0) {
            return;
        }
        ClientArea ca = lg.getClientArea();
        LineAttributes lia = ca.getOutline();
        RadarSeries ls = (RadarSeries)this.getSeries();
        if (fPaletteEntry == null) {
            fPaletteEntry = goFactory.RED();
        }
        RectangleRenderEvent rre = ((EventObjectCache)((Object)ipr)).getEventObject(StructureSource.createLegend(lg), RectangleRenderEvent.class);
        rre.setBackground(ca.getBackground());
        rre.setOutline(lia);
        rre.setBounds(bo);
        ipr.fillRectangle(rre);
        LineAttributes liaMarker = ls.getLineAttributes();
        if (!liaMarker.isSetVisible()) {
            throw new ChartException("org.eclipse.birt.chart.engine.extension", 11, "exception.unspecified.marker.linestyle.visibility", Messages.getResourceBundle(this.getRunTimeContext().getULocale()));
        }
        if (liaMarker.isVisible()) {
            LineRenderEvent lre = ((EventObjectCache)((Object)ipr)).getEventObject(StructureSource.createLegend(lg), LineRenderEvent.class);
            if (fPaletteEntry instanceof ColorDefinition && ls.isSetPaletteLineColor() && ls.isPaletteLineColor()) {
                liaMarker = goFactory.copyOf(liaMarker);
                liaMarker.setColor(goFactory.copyOf(FillUtil.getColor(fPaletteEntry)));
            }
            lre.setLineAttributes(liaMarker);
            lre.setStart(goFactory.createLocation(bo.getLeft() + 1.0, bo.getTop() + bo.getHeight() / 2.0));
            lre.setEnd(goFactory.createLocation(bo.getLeft() + bo.getWidth() - 1.0, bo.getTop() + bo.getHeight() / 2.0));
            ipr.drawLine(lre);
        }
        SeriesDefinition sd = this.getSeriesDefinition();
        boolean bPaletteByCategory = this.isPaletteByCategory();
        if (bPaletteByCategory && ls.eContainer() instanceof SeriesDefinition) {
            sd = (SeriesDefinition)ls.eContainer();
        }
        if ((iThisSeriesIndex = sd.getRunTimeSeries().indexOf(ls)) < 0) {
            throw new ChartException("org.eclipse.birt.chart.engine.extension", 11, "exception.missing.series.for.palette.index", new Object[]{ls, sd}, Messages.getResourceBundle(this.getRunTimeContext().getULocale()));
        }
        Marker m = ls.getMarker();
        double width = bo.getWidth() / this.getDeviceScale();
        int markerSize = (int)(((width > (height = bo.getHeight() / this.getDeviceScale()) ? height : width) - 2.0) / 2.0);
        if (markerSize <= 0) {
            markerSize = 1;
        }
        if (m != null && m.isVisible()) {
            this.renderMarker(lg, ipr, m, goFactory.createLocation(bo.getLeft() + bo.getWidth() / 2.0, bo.getTop() + bo.getHeight() / 2.0), ls.getLineAttributes(), fPaletteEntry, null, markerSize, false, false);
        }
    }

    private void renderPolys(IDeviceRenderer idr, Location[] prelo, RadarSeries se, SeriesDefinition sd) throws ChartException {
        int iThisSeriesIndex = sd.getRunTimeSeries().indexOf(se);
        if (iThisSeriesIndex == -1) {
            iThisSeriesIndex = this.getSeriesIndex();
        }
        EList<Fill> elPalette = sd.getSeriesPalette().getEntries();
        Fill fPaletteEntry = FillUtil.getPaletteFill(elPalette, iThisSeriesIndex);
        LineAttributes llia = se.getLineAttributes();
        PolygonRenderEvent pre = ((EventObjectCache)((Object)idr)).getEventObject(StructureSource.createSeries(se), PolygonRenderEvent.class);
        LineRenderEvent lre = ((EventObjectCache)((Object)idr)).getEventObject(StructureSource.createSeries(se), LineRenderEvent.class);
        if (se.isSetTranslucent() && se.isTranslucent() && fPaletteEntry instanceof ColorDefinition) {
            fPaletteEntry = goFactory.translucent((ColorDefinition)fPaletteEntry);
        }
        if (!se.isFillPolys() || !se.isConnectEndpoints()) {
            lre.setLineAttributes(llia);
            int i = 0;
            while (i < prelo.length - 1) {
                if (prelo[i] != null && prelo[i + 1] != null) {
                    lre.setStart(prelo[i]);
                    lre.setEnd(prelo[i + 1]);
                    idr.drawLine(lre);
                }
                ++i;
            }
            if (se.isConnectEndpoints() && prelo[0] != null && prelo[prelo.length - 1] != null) {
                lre.setStart(prelo[0]);
                lre.setEnd(prelo[prelo.length - 1]);
                idr.drawLine(lre);
            }
        } else {
            pre.setBackground(fPaletteEntry);
            pre.setPoints(prelo);
            pre.setOutline(llia);
            idr.drawPolygon(pre);
            idr.fillPolygon(pre);
        }
    }

    private void renderAxes(IDeviceRenderer idr, PolarCoordinate pc, double magnitude) throws ChartException {
        block6: {
            String subType;
            LineRenderEvent lre;
            Location lo;
            int iCount;
            block5: {
                Location center = pc.getCenter();
                iCount = pc.getCount();
                pc = new PolarCoordinate(center, iCount, 1, 0);
                lo = center.copyInstance();
                LineAttributes lia = null;
                RadarSeries rsd = this.getFirstSeries();
                LineAttributes wlia = rsd.getWebLineAttributes();
                lia = wlia == null ? goFactory.createLineAttributes(goFactory.GREY(), LineStyle.SOLID_LITERAL, 1) : wlia;
                StructureSource ss = StructureSource.createPlot(this.getModel().getPlot());
                lre = ((EventObjectCache)((Object)idr)).getEventObject(ss, LineRenderEvent.class);
                OvalRenderEvent ore = ((EventObjectCache)((Object)idr)).getEventObject(ss, OvalRenderEvent.class);
                lre.setLineAttributes(lia);
                lre.setStart(center);
                int i = 0;
                while (i < iCount) {
                    pc.computeLocation(lo, i, magnitude);
                    lre.setEnd(lo);
                    idr.drawLine(lre);
                    DataPointHints dph = this.dpha[i];
                    if (rsd.isSetShowCatLabels() && rsd.isShowCatLabels() || !rsd.isSetShowCatLabels()) {
                        this.drawAxisRadialLabel(idr, pc, lo, i, dph.getBaseValue());
                    }
                    ++i;
                }
                subType = this.getModel().getSubType();
                if (!STANDARD_SUBTYPE_LITERAL.equals(subType) && !BULLSEYE_SUBTYPE_LITERAL.equals(subType)) break block5;
                ore.setBackground(lia.getColor());
                ore.setOutline(lia);
                Bounds bo = goFactory.createBounds(0.0, 0.0, 0.0, 0.0);
                int sc = 1;
                while (sc <= this.scaleHelper.getScaleCount()) {
                    double spiderMag = magnitude * (double)sc / (double)this.scaleHelper.getScaleCount();
                    ore.setBounds(pc.computeBounds(bo, spiderMag));
                    idr.drawOval(ore);
                    ++sc;
                }
                break block6;
            }
            if (!SPIDER_SUBTYPE_LITERAL.equals(subType)) break block6;
            Location lo1 = lo.copyInstance();
            int sc = 1;
            while (sc < this.scaleHelper.getScaleCount() + 1) {
                double spiderMag = magnitude * (double)sc / (double)this.scaleHelper.getScaleCount();
                pc.computeLocation(lo1, 0, spiderMag);
                int index = 1;
                while (index < iCount + 1) {
                    lo.set(lo1.getX(), lo1.getY());
                    pc.computeLocation(lo1, index, spiderMag);
                    lre.setStart(lo);
                    lre.setEnd(lo1);
                    idr.drawLine(lre);
                    ++index;
                }
                ++sc;
            }
        }
    }

    private void renderOvalBackgrounds(IDeviceRenderer idr, Location center, Series se, double magnitude) throws ChartException {
        OvalRenderEvent ore = ((EventObjectCache)((Object)idr)).getEventObject(StructureSource.createPlot(this.cm.getPlot()), OvalRenderEvent.class);
        LineAttributes lia = null;
        LineAttributes wlia = ((RadarSeries)se).getWebLineAttributes();
        lia = wlia == null ? goFactory.createLineAttributes(goFactory.GREY(), LineStyle.SOLID_LITERAL, 1) : wlia;
        ore.setBackground(lia.getColor());
        ore.setOutline(lia);
        int sc = this.scaleHelper.getScaleCount();
        while (sc >= 1) {
            RadarSeries rsd;
            Fill wPaletteEntry;
            double spiderMag = magnitude * (double)sc / (double)this.scaleHelper.getScaleCount();
            ore.setBounds(goFactory.createBounds(center.getX() - spiderMag, center.getY() - spiderMag, spiderMag * 2.0, spiderMag * 2.0));
            Palette pa = this.sd.getSeriesPalette();
            int ps = pa.getEntries().size();
            int tscnt = this.getSeriesCount();
            int palcnt = ps + tscnt + sc;
            if (palcnt > ps) {
                palcnt = 1;
            }
            if ((wPaletteEntry = FillUtil.getPaletteFill(pa.getEntries(), sc + 1)) instanceof ColorDefinition && (rsd = this.getFirstSeries()).isBackgroundOvalTransparent()) {
                wPaletteEntry = goFactory.translucent((ColorDefinition)wPaletteEntry);
            }
            ore.setBackground(wPaletteEntry);
            idr.fillOval(ore);
            --sc;
        }
    }

    private Object getWebLabelDefaultFormat(Object value) {
        if (value instanceof Number) {
            if (this.dfNumericFormatCache == null) {
                this.dfNumericFormatCache = new ChartUtil.CacheDecimalFormat(this.rtc.getULocale());
            }
            return this.dfNumericFormatCache.get(ValueFormatter.getNumericPattern((Number)value));
        }
        return null;
    }

    private Object getCategoryDefaultFormat(Object value) throws ChartException {
        if (value instanceof Number) {
            if (this.dfNumericFormatCache == null) {
                this.dfNumericFormatCache = new ChartUtil.CacheDecimalFormat(this.rtc.getULocale());
            }
            return this.dfNumericFormatCache.get(ValueFormatter.getNumericPattern((Number)value));
        }
        DataSetIterator categoryDSI = new DataSetIterator(((SeriesDefinition)((ChartWithoutAxes)this.getModel()).getSeriesDefinitions().get(0)).getRunTimeSeries().get(0).getDataSet());
        int iDateTimeUnit = ChartUtil.computeDateTimeCategoryUnit(this.getModel(), categoryDSI);
        if (iDateTimeUnit != 0) {
            if (this.dfDateFormatCache == null) {
                this.dfDateFormatCache = new ChartUtil.CacheDateFormat(this.rtc.getULocale());
            }
            return this.dfDateFormatCache.get(iDateTimeUnit);
        }
        return null;
    }

    private final void drawAxisRadialLabel(IDeviceRenderer idr, PolarCoordinate pc, Location lo, int cindex, Object lab) throws ChartException {
        AbstractScriptHandler sh = this.getRunTimeContext().getScriptHandler();
        double space = this.dSafeSpacing / 2.0;
        Label la = null;
        if (this.getFirstSeries().getCatLabel() != null) {
            la = goFactory.copyOf(this.getFirstSeries().getCatLabel());
        } else {
            la = goFactory.copyOf(this.getFirstSeries().getLabel());
            la.setVisible(true);
        }
        if (lab == null) {
            lab = "null";
        }
        FormatSpecifier fs = this.getFirstSeries().getCatLabelFormatSpecifier();
        Object defaultFormat = this.getCategoryDefaultFormat(lab);
        String catlabel = ValueFormatter.format(lab, fs, this.rtc.getULocale(), defaultFormat);
        la.getCaption().setValue(catlabel);
        Location loLabel = lo.copyInstance();
        TextRenderEvent tre = ((EventObjectCache)((Object)idr)).getEventObject(WrappedStructureSource.createAxisLabel(null, la), TextRenderEvent.class);
        tre.setLabel(la);
        ScriptHandler.callFunction(sh, "beforeDrawAxisLabel", SCRIPT_KEY_CATEGORY, la, this.getRunTimeContext().getScriptContext());
        this.getRunTimeContext().notifyStructureChange("beforeDrawAxisLabel", la);
        tre.setAction(2);
        int degree = pc.getDegree(cindex);
        if (Math.abs(degree) > 90) {
            tre.setTextPosition(1);
        } else {
            tre.setTextPosition(2);
        }
        if (Math.abs(degree) == 90) {
            tre.setTextPosition(4);
        }
        if (degree == -90) {
            tre.setTextPosition(8);
        }
        double dX = (double)(-Math.signum(Math.abs(degree) - 90)) * space;
        double dY = (double)(-Math.signum(degree)) * space;
        if (degree == 0 || degree == 180 || degree == -180) {
            dY = 0.0;
        }
        if (degree == 90 || degree == -90 || degree == 270 || degree == -270) {
            dX = 0.0;
        }
        loLabel.translate(dX, dY);
        tre.setLocation(loLabel);
        this.dc.addLabel(tre);
        ScriptHandler.callFunction(sh, "afterDrawAxisLabel", SCRIPT_KEY_CATEGORY, la, this.getRunTimeContext().getScriptContext());
        this.getRunTimeContext().notifyStructureChange("beforeDrawAxisLabel", la);
    }

    private final void drawSeriesLabel(IDeviceRenderer idr, PolarCoordinate pc, DataPointHints dph, Location lopt) throws ChartException {
        AbstractScriptHandler sh = this.getRunTimeContext().getScriptHandler();
        if (this.se.getLabel().isVisible()) {
            double space = this.dSafeSpacing / 2.0;
            Label la = goFactory.copyOf(this.se.getLabel());
            la.getCaption().setValue(dph.getDisplayValue());
            Location loLabel = lopt.copyInstance();
            TextRenderEvent tre = ((EventObjectCache)((Object)idr)).getEventObject(WrappedStructureSource.createSeriesDataPoint(this.se, dph), TextRenderEvent.class);
            tre.setLabel(la);
            ScriptHandler.callFunction(sh, "beforeDrawDataPointLabel", dph, la, this.getRunTimeContext().getScriptContext());
            this.getRunTimeContext().notifyStructureChange("beforeDrawDataPointLabel", la);
            tre.setAction(2);
            int degree = pc.getDegree(dph.getIndex());
            if (Math.abs(degree) > 90) {
                tre.setTextPosition(1);
            } else {
                tre.setTextPosition(2);
            }
            if (Math.abs(degree) == 90) {
                tre.setTextPosition(4);
            }
            if (degree == -90) {
                tre.setTextPosition(8);
            }
            double dX = (double)(-Math.signum(Math.abs(degree) - 90)) * space;
            double dY = (double)(-Math.signum(degree)) * space;
            loLabel.translate(dX, dY);
            tre.setLocation(loLabel);
            this.dc.addLabel(tre);
            ScriptHandler.callFunction(sh, "afterDrawDataPointLabel", dph, la, this.getRunTimeContext().getScriptContext());
            this.getRunTimeContext().notifyStructureChange("beforeDrawDataPointLabel", la);
        }
    }

    private final void render(IDeviceRenderer idr, Bounds bo, RadarSeries se, SeriesDefinition sd) throws ChartException {
        List<Series> rts = sd.getRunTimeSeries();
        int iThisSeriesIndex = rts.indexOf(se);
        if (iThisSeriesIndex == -1) {
            iThisSeriesIndex = this.getSeriesIndex();
        }
        int totalSeriesCnt = this.getSeriesCount();
        int currSeriesIdx = this.getSeriesIndex();
        EList<Fill> elPalette = sd.getSeriesPalette().getEntries();
        AbstractScriptHandler sh = this.getRunTimeContext().getScriptHandler();
        this.dc = this.getDeferredCache();
        Bounds boCA = goFactory.copyOf(bo);
        double dh = boCA.getHeight() - boCA.getHeight() * this.percentReduce;
        double dl = boCA.getLeft() + boCA.getWidth() * this.percentReduce / 2.0;
        double dt = boCA.getTop() + boCA.getHeight() * this.percentReduce / 2.0;
        double dw = boCA.getWidth() - boCA.getWidth() * this.percentReduce;
        double centrePointX = Math.round(dl + dw / 2.0);
        double centrePointY = Math.round(dt + dh / 2.0);
        double mag = dh / 2.0;
        Location cntpt = goFactory.createLocation(centrePointX, centrePointY);
        if (currSeriesIdx == 1 && BULLSEYE_SUBTYPE_LITERAL.equals(this.getModel().getSubType())) {
            this.renderOvalBackgrounds(idr, cntpt, se, mag);
        }
        PolarCoordinate pc = new PolarCoordinate(cntpt, this.dpha.length, this.getSeriesCount() - 1, this.getSeriesIndex() - 1);
        boolean bPaletteByCategory = this.isPaletteByCategory();
        Fill fPaletteEntry = null;
        if (!bPaletteByCategory) {
            fPaletteEntry = FillUtil.getPaletteFill(elPalette, iThisSeriesIndex);
            this.updateTranslucency(fPaletteEntry, se);
        }
        Location loAxis = goFactory.createLocation(centrePointX, centrePointY);
        LinkedList<Location> loList = new LinkedList<Location>();
        int index = 0;
        while (index < this.dpha.length) {
            DataPointHints dph = this.dpha[index];
            if (Radar.isNaN(dph.getOrthogonalValue())) {
                if (!se.isFillPolys()) {
                    loList.add(null);
                }
            } else {
                Marker m;
                double currval = ((Number)dph.getOrthogonalValue()).doubleValue();
                if (!this.scaleHelper.getAutoScale()) {
                    if (currval < this.scaleHelper.getAxisMin()) {
                        currval = this.scaleHelper.getAxisMin();
                    }
                    if (currval > this.scaleHelper.getAxisMax()) {
                        currval = this.scaleHelper.getAxisMax();
                    }
                }
                pc.computeLocation(loAxis, index, mag);
                Location lo = pc.createLocation(index, mag * (1.0 - (this.scaleHelper.getAxisMax() - currval) / (this.scaleHelper.getAxisMax() - this.scaleHelper.getAxisMin())));
                loList.add(lo);
                if (bPaletteByCategory) {
                    fPaletteEntry = FillUtil.getPaletteFill(elPalette, index);
                    this.updateTranslucency(fPaletteEntry, se);
                }
                LineAttributes llia = se.getLineAttributes();
                if (se.isPaletteLineColor() && index == 0) {
                    llia.setColor(goFactory.copyOf(FillUtil.getColor(fPaletteEntry)));
                }
                if ((m = se.getMarker()) != null) {
                    ScriptHandler.callFunction(sh, "beforeDrawDataPoint", dph, fPaletteEntry, this.getRunTimeContext().getScriptContext());
                    this.getRunTimeContext().notifyStructureChange("beforeDrawDataPoint", dph);
                    this.renderMarker(se, idr, m, lo, llia, fPaletteEntry, dph, null, true, false);
                    ScriptHandler.callFunction(sh, "afterDrawDataPoint", dph, fPaletteEntry, this.getRunTimeContext().getScriptContext());
                    this.getRunTimeContext().notifyStructureChange("afterDrawDataPoint", dph);
                }
                this.drawSeriesLabel(idr, pc, dph, lo);
            }
            ++index;
        }
        this.renderPolys(idr, loList.toArray(new Location[loList.size()]), se, sd);
        if (currSeriesIdx == totalSeriesCnt - 1) {
            RadarSeries rsd;
            if (se.getWebLineAttributes() != null && se.getWebLineAttributes().isVisible()) {
                this.renderAxes(idr, pc, mag);
            }
            if ((rsd = this.getFirstSeries()).isShowWebLabels()) {
                Location loLabel = goFactory.createLocation(0.0, 0.0);
                int sc = 0;
                while (sc <= this.scaleHelper.getScaleCount()) {
                    TextRenderEvent stre = ((EventObjectCache)((Object)idr)).getEventObject(StructureSource.createPlot(this.cm.getPlot()), TextRenderEvent.class);
                    Label la = null;
                    la = rsd.getWebLabel() != null ? goFactory.copyOf(rsd.getWebLabel()) : goFactory.copyOf(rsd.getLabel());
                    la.setVisible(true);
                    stre.setTextPosition(2);
                    double lblperc = sc == 0 ? this.scaleHelper.getAxisMin() : (sc == this.scaleHelper.getScaleCount() ? this.scaleHelper.getAxisMax() : (double)sc / (double)this.scaleHelper.getScaleCount() * (this.scaleHelper.getAxisMax() - this.scaleHelper.getAxisMin()) + this.scaleHelper.getAxisMin());
                    String weblabel = ValueFormatter.format(lblperc, rsd.getWebLabelFormatSpecifier(), this.rtc.getULocale(), this.getWebLabelDefaultFormat(lblperc));
                    la.getCaption().setValue(weblabel);
                    ScriptHandler.callFunction(sh, "beforeDrawAxisLabel", SCRIPT_KEY_WEB, la, this.getRunTimeContext().getScriptContext());
                    this.getRunTimeContext().notifyStructureChange("beforeDrawAxisLabel", la);
                    stre.setLabel(la);
                    stre.setAction(2);
                    double ycord = mag * (double)sc / (double)this.scaleHelper.getScaleCount();
                    ycord = Math.round(centrePointY - ycord);
                    double xcord = Math.round(centrePointX - mag * 0.25);
                    loLabel.set(xcord, ycord);
                    stre.setLocation(loLabel);
                    this.dc.addLabel(stre);
                    ScriptHandler.callFunction(sh, "afterDrawAxisLabel", SCRIPT_KEY_WEB, la, this.getRunTimeContext().getScriptContext());
                    this.getRunTimeContext().notifyStructureChange("afterDrawAxisLabel", la);
                    ++sc;
                }
            }
        }
    }

    private RadarSeries getFirstSeries() {
        return (RadarSeries)((SeriesDefinition)((SeriesDefinition)((ChartWithoutAxes)this.getModel()).getSeriesDefinitions().get(0)).getSeriesDefinitions().get(0)).getSeries().get(0);
    }

    private static class PolarCoordinate {
        private final Location center;
        private final int iCount;
        private final double delta;

        public PolarCoordinate(Location center, int iCount, int iSeriesCount, int iSeriesIndex) {
            this.center = center;
            this.iCount = iCount;
            this.delta = Math.PI * 2 / (double)iCount;
        }

        public Location getCenter() {
            return this.center;
        }

        public int getCount() {
            return this.iCount;
        }

        public double getAngle(int index, int iSeriesIndex) {
            return (double)index * this.delta * -1.0 + 1.5707963267948966;
        }

        public double getAngle(int index) {
            return this.getAngle(index, 0);
        }

        public int getDegree(int index) {
            double degree = Math.toDegrees(this.getAngle(index)) % 360.0;
            if (degree < 0.0) {
                degree += 360.0;
            }
            if (degree > 180.0) {
                degree -= 360.0;
            }
            return (int)Math.round(degree);
        }

        public Location computeLocation(Location lo, int index, double magnitude) {
            double angle = this.getAngle(index, 0);
            double x = Math.cos(angle) * magnitude;
            double y = Math.sin(angle) * magnitude;
            lo.set(this.center.getX() + x, this.center.getY() - y);
            return lo;
        }

        public Location createLocation(int index, double magnitude) {
            double angle = this.getAngle(index);
            double x = Math.cos(angle) * magnitude;
            double y = Math.sin(angle) * magnitude;
            return goFactory.createLocation(this.center.getX() + x, this.center.getY() - y);
        }

        public Bounds computeBounds(Bounds bo, double magnitude) {
            bo.set(this.center.getX() - magnitude, this.center.getY() - magnitude, magnitude * 2.0, magnitude * 2.0);
            return bo;
        }
    }
}

