/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.pdf;

import java.net.URI;
import java.net.URISyntaxException;
import org.apache.fop.apps.io.InternalResourceResolver;
import org.apache.fop.pdf.PDFAMode;
import org.apache.fop.pdf.PDFUAMode;
import org.apache.fop.pdf.PDFVTMode;
import org.apache.fop.pdf.PDFXMode;
import org.apache.fop.pdf.Version;
import org.apache.fop.render.RendererConfigOption;

public enum PDFRendererOption implements RendererConfigOption
{
    FILTER_LIST("filterList", (Object)null){

        @Override
        Object deserialize(String value) {
            throw new UnsupportedOperationException();
        }
    }
    ,
    PDF_A_MODE("pdf-a-mode", (Object)((Object)PDFAMode.DISABLED)){

        PDFAMode deserialize(String value) {
            return PDFAMode.getValueOf(value);
        }
    }
    ,
    PDF_UA_MODE("pdf-ua-mode", (Object)((Object)PDFUAMode.DISABLED)){

        PDFUAMode deserialize(String value) {
            return PDFUAMode.getValueOf(value);
        }
    }
    ,
    PDF_X_MODE("pdf-x-mode", (Object)((Object)PDFXMode.DISABLED)){

        PDFXMode deserialize(String value) {
            return PDFXMode.getValueOf(value);
        }
    }
    ,
    PDF_VT_MODE("pdf-vt-mode", (Object)((Object)PDFVTMode.DISABLED)){

        PDFVTMode deserialize(String value) {
            return PDFVTMode.getValueOf(value);
        }
    }
    ,
    VERSION("version"){

        Version deserialize(String value) {
            return Version.getValueOf(value);
        }
    }
    ,
    DISABLE_SRGB_COLORSPACE("disable-srgb-colorspace", false){

        @Override
        Boolean deserialize(String value) {
            return Boolean.valueOf(value);
        }
    }
    ,
    MERGE_FONTS("merge-fonts", false){

        @Override
        Boolean deserialize(String value) {
            return Boolean.valueOf(value);
        }
    }
    ,
    MERGE_FORM_FIELDS("merge-form-fields", false){

        @Override
        Boolean deserialize(String value) {
            return Boolean.valueOf(value);
        }
    }
    ,
    LINEARIZATION("linearization", false){

        @Override
        Boolean deserialize(String value) {
            return Boolean.valueOf(value);
        }
    }
    ,
    FORM_XOBJECT("form-xobject", false){

        @Override
        Boolean deserialize(String value) {
            return Boolean.valueOf(value);
        }
    }
    ,
    OBJECT_STREAMS("use-object-streams", false){

        @Override
        Boolean deserialize(String value) {
            return Boolean.valueOf(value);
        }
    }
    ,
    OUTPUT_PROFILE("output-profile"){

        @Override
        URI deserialize(String value) {
            try {
                return InternalResourceResolver.cleanURI(value);
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
    }
    ,
    SIGN_PARAMS("sign-params", (Object)null){

        @Override
        Object deserialize(String value) {
            throw new UnsupportedOperationException();
        }
    };

    private final String name;
    private final Object defaultValue;

    private PDFRendererOption(String name, Object defaultValue) {
        this.name = name;
        this.defaultValue = defaultValue;
    }

    private PDFRendererOption(String name) {
        this(name, (Object)null);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public Object parse(Object object) {
        if (object instanceof String) {
            return this.deserialize((String)object);
        }
        return object;
    }

    abstract Object deserialize(String var1);
}

