/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.reportitem;

import com.ibm.icu.util.ULocale;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.birt.chart.computation.DataPointHints;
import org.eclipse.birt.chart.computation.LegendItemHints;
import org.eclipse.birt.chart.computation.ValueFormatter;
import org.eclipse.birt.chart.event.StructureSource;
import org.eclipse.birt.chart.event.StructureType;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.factory.IDataRowExpressionEvaluator;
import org.eclipse.birt.chart.factory.RunTimeContext;
import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.chart.model.attribute.ActionType;
import org.eclipse.birt.chart.model.attribute.FormatSpecifier;
import org.eclipse.birt.chart.model.attribute.MultiURLValues;
import org.eclipse.birt.chart.model.attribute.ScriptValue;
import org.eclipse.birt.chart.model.attribute.TooltipValue;
import org.eclipse.birt.chart.model.attribute.URLValue;
import org.eclipse.birt.chart.model.data.Action;
import org.eclipse.birt.chart.model.data.MultipleActions;
import org.eclipse.birt.chart.render.ActionRendererAdapter;
import org.eclipse.birt.chart.util.ChartUtil;
import org.eclipse.birt.core.data.ExpressionUtil;
import org.eclipse.birt.report.engine.api.IAction;
import org.eclipse.birt.report.engine.api.IHTMLActionHandler;
import org.eclipse.birt.report.engine.api.script.IReportContext;
import org.eclipse.birt.report.model.api.ActionHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ExpressionHandle;
import org.eclipse.birt.report.model.api.MemberHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ModuleUtil;
import org.eclipse.birt.report.model.api.ParamBindingHandle;
import org.eclipse.birt.report.model.api.SearchKeyHandle;

public class BIRTActionRenderer
extends ActionRendererAdapter {
    protected IHTMLActionHandler handler;
    protected DesignElementHandle eih;
    protected IReportContext context;
    protected IDataRowExpressionEvaluator evaluator;
    protected static final String REPORT_VARIABLE_INDICATOR = "vars";
    private Map<String, String> cacheScriptEvaluator;
    private static ILogger logger = Logger.getLogger((String)"org.eclipse.birt.chart.reportitem/trace");

    public BIRTActionRenderer(DesignElementHandle eih, IHTMLActionHandler handler, IDataRowExpressionEvaluator evaluator, IReportContext context) {
        this.eih = eih;
        this.handler = handler;
        this.evaluator = evaluator;
        this.context = context;
    }

    protected Map<String, Object> getParameterBindings(ChartHyperlinkActionBase chAction, ActionHandle handle) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        MemberHandle params = handle.getParamBindings();
        if (params != null) {
            for (ParamBindingHandle pbh : params) {
                map.put(pbh.getParamName(), chAction.evaluate(pbh.getExpression()));
            }
        }
        return map;
    }

    protected Map<String, Object> getSearchCriteria(ChartHyperlinkActionBase chAction, ActionHandle handle) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        MemberHandle searches = handle.getSearch();
        if (searches != null) {
            for (SearchKeyHandle skh : searches) {
                map.put(skh.getExpression(), chAction.evaluate(skh.getExpression()));
            }
        }
        return map;
    }

    protected int getType(ActionHandle handle) {
        if ("hyperlink".equals(handle.getLinkType())) {
            return 1;
        }
        if ("bookmark-link".equals(handle.getLinkType())) {
            return 2;
        }
        if ("drill-through".equals(handle.getLinkType())) {
            return 3;
        }
        return 0;
    }

    protected String getActionString(ChartHyperlinkActionBase chAction, ActionHandle handle) {
        if ("hyperlink".equals(handle.getLinkType())) {
            ExpressionHandle urlExpr = handle.getExpressionProperty("uri");
            String text = urlExpr.getStringExpression();
            if ("constant".equals(urlExpr.getType())) {
                return text;
            }
            return ChartUtil.stringValue((Object)chAction.evaluate(text));
        }
        if ("bookmark-link".equals(handle.getLinkType())) {
            return ChartUtil.stringValue((Object)chAction.evaluate(handle.getTargetBookmark()));
        }
        return null;
    }

    protected boolean isBookmark(ActionHandle handle) {
        return "bookmark".equals(handle.getTargetBookmarkType());
    }

    public void processAction(Action action, StructureSource source, RunTimeContext rtc) {
        if (action instanceof MultipleActions) {
            for (Action subAction : ((MultipleActions)action).getActions()) {
                this.processActionImpl(subAction, source, rtc);
            }
        } else {
            this.processActionImpl(action, source, rtc);
        }
    }

    private void processActionImpl(Action action, StructureSource source, RunTimeContext rtc) {
        if (ActionType.URL_REDIRECT_LITERAL.equals((Object)action.getType())) {
            if (action.getValue() instanceof URLValue) {
                URLValue uv = (URLValue)action.getValue();
                this.generateURLValue(source, uv);
            } else if (action.getValue() instanceof MultiURLValues) {
                for (URLValue uv : ((MultiURLValues)action.getValue()).getURLValues()) {
                    this.generateURLValue(source, uv);
                }
            }
        } else if (ActionType.SHOW_TOOLTIP_LITERAL.equals((Object)action.getType())) {
            BIRTActionRenderer.processTooltipAction(action, source, rtc);
        } else if (ActionType.INVOKE_SCRIPT_LITERAL.equals((Object)action.getType())) {
            String evaluatResult;
            ScriptValue sv = (ScriptValue)action.getValue();
            if (this.cacheScriptEvaluator == null) {
                this.cacheScriptEvaluator = new HashMap<String, String>();
            }
            if ((evaluatResult = this.cacheScriptEvaluator.get(sv.getScript())) == null) {
                evaluatResult = this.evaluateExpression(sv.getScript());
                this.cacheScriptEvaluator.put(sv.getScript(), evaluatResult);
            }
            sv.setScript(evaluatResult);
        }
    }

    public static void processTooltipAction(Action action, StructureSource source, RunTimeContext rtc) {
        TooltipValue tv = (TooltipValue)action.getValue();
        FormatSpecifier fs = tv.getFormatSpecifier();
        if (StructureType.SERIES_DATA_POINT.equals(source.getType())) {
            DataPointHints dph = (DataPointHints)source.getSource();
            if (!dph.isVirtual()) {
                if ("categoryData".equals(tv.getText())) {
                    tv.setText(dph.getBaseDisplayValue(fs));
                } else if ("valueData".equals(tv.getText())) {
                    tv.setText(dph.getOrthogonalDisplayValue(fs));
                } else if ("valueSeriesName".equals(tv.getText())) {
                    tv.setText(dph.getSeriesDisplayValue(fs));
                } else {
                    Object value = dph.getUserValue(tv.getText());
                    if (fs != null) {
                        try {
                            tv.setText(ValueFormatter.format((Object)value, (FormatSpecifier)fs, (ULocale)rtc.getULocale(), null));
                        }
                        catch (ChartException e) {
                            logger.log((Exception)((Object)e));
                        }
                    } else if (value instanceof Number) {
                        tv.setText(ChartUtil.getDefaultNumberFormat().format(value));
                    } else {
                        tv.setText(ChartUtil.stringValue((Object)value));
                    }
                }
            } else {
                tv.setText(null);
            }
        } else if (StructureType.LEGEND_ENTRY.equals(source.getType())) {
            LegendItemHints lih = (LegendItemHints)source.getSource();
            if (tv.getText() == null || tv.getText().equals("")) {
                tv.setText(lih.getItemText());
            }
        }
    }

    protected ActionHandle getActionHandleInstance(String sa) {
        ActionHandle handle = null;
        try {
            handle = ModuleUtil.deserializeAction((String)sa);
        }
        catch (Exception e) {
            sa = "";
            logger.log(e);
        }
        return handle;
    }

    protected void generateURLValue(StructureSource source, URLValue uv) {
        String sa = uv.getBaseUrl();
        String target = null;
        ActionHandle handle = this.getActionHandleInstance(sa);
        if (handle != null) {
            this.setTooltip(uv, handle);
            target = handle.getTargetWindow();
            if (StructureType.SERIES_DATA_POINT.equals(source.getType())) {
                final DataPointHints dph = (DataPointHints)source.getSource();
                sa = this.handler.getURL((IAction)new ChartHyperlinkActionBase(this, handle){

                    @Override
                    public Object evaluate(String expr) {
                        return dph.getUserValue(expr);
                    }
                }, this.context);
            } else if (StructureType.LEGEND_ENTRY.equals(source.getType())) {
                final LegendItemHints lih = (LegendItemHints)source.getSource();
                sa = this.handler.getURL((IAction)new ChartHyperlinkActionBase(this, handle){

                    @Override
                    public Object evaluate(String expr) {
                        if (expr != null) {
                            if (expr.indexOf("legendItemText") >= 0) {
                                String legendItemText = BIRTActionRenderer.wrapQuotation(lih.getItemText());
                                expr = Pattern.compile("legendItemText", 16).matcher(expr).replaceAll(legendItemText);
                            }
                            if (expr.indexOf("legendItemValue") >= 0) {
                                String legendItemValue = BIRTActionRenderer.wrapQuotation(lih.getValueText());
                                expr = Pattern.compile("legendItemValue", 16).matcher(expr).replaceAll(legendItemValue);
                            }
                        }
                        return evaluator.evaluate(expr);
                    }
                }, this.context);
            } else {
                sa = this.handler.getURL((IAction)new ChartHyperlinkActionBase(this, handle){

                    @Override
                    public Object evaluate(String expr) {
                        return evaluator.evaluate(expr);
                    }
                }, this.context);
            }
        } else {
            sa = "";
        }
        uv.setBaseUrl(sa);
        uv.setTarget(target);
    }

    protected void setTooltip(URLValue uv, ActionHandle handle) {
        if (handle.getToolTip() != null && handle.getToolTip().trim().length() > 0) {
            uv.setTooltip(handle.getToolTip());
        }
    }

    protected String evaluateExpression(String script) {
        Object evaluateResult;
        if (script == null || script.trim().length() == 0) {
            return "";
        }
        String expression = BIRTActionRenderer.findParameterExp(script, 0);
        while (expression != null) {
            evaluateResult = this.evaluator.evaluate(expression);
            if (evaluateResult instanceof String) {
                evaluateResult = "\"" + String.valueOf(evaluateResult) + "\"";
            } else if (evaluateResult instanceof Date) {
                evaluateResult = "\"" + evaluateResult.toString() + "\"";
            } else if (evaluateResult == null) {
                evaluateResult = "null";
            }
            script = Pattern.compile(expression, 16).matcher(script).replaceAll(evaluateResult.toString());
            expression = BIRTActionRenderer.findParameterExp(script, 0);
        }
        expression = BIRTActionRenderer.findVariableExp(script, 0);
        while (expression != null) {
            evaluateResult = this.evaluator.evaluate(expression);
            if (evaluateResult instanceof String) {
                evaluateResult = "\"" + String.valueOf(evaluateResult) + "\"";
            } else if (evaluateResult == null) {
                evaluateResult = "null";
            }
            script = Pattern.compile(expression, 16).matcher(script).replaceAll(evaluateResult.toString());
            expression = BIRTActionRenderer.findVariableExp(script, 0);
        }
        return script;
    }

    private static String findVariableExp(String script, int fromIndex) {
        int iStart = script.indexOf("vars[", fromIndex);
        if (iStart < fromIndex) {
            return null;
        }
        int iEnd = script.indexOf(93, iStart);
        if (iEnd < iStart + REPORT_VARIABLE_INDICATOR.length()) {
            return null;
        }
        return script.substring(iStart, iEnd + 1);
    }

    private static String findParameterExp(String script, int fromIndex) {
        int iStart = script.indexOf("params[", fromIndex);
        if (iStart < fromIndex) {
            return null;
        }
        int iEnd = script.indexOf(93, iStart);
        if (iEnd < iStart + "params".length()) {
            return null;
        }
        return script.substring(iStart, iEnd + 1 + ExpressionUtil.EXPRESSION_VALUE_SUFFIX.length());
    }

    private static String wrapQuotation(String value) {
        if (value == null) {
            return "";
        }
        try {
            Double.parseDouble((String)value);
        }
        catch (RuntimeException e) {
            value = "\"" + (String)value + "\"";
        }
        return value;
    }

    protected abstract class ChartHyperlinkActionBase
    implements IAction {
        private ActionHandle handle;

        protected ChartHyperlinkActionBase(ActionHandle handle) {
            this.handle = handle;
        }

        public abstract Object evaluate(String var1);

        public int getType() {
            return BIRTActionRenderer.this.getType(this.handle);
        }

        public String getBookmark() {
            Object value = this.evaluate(this.handle.getTargetBookmark());
            if (value instanceof Number) {
                return ChartUtil.getDefaultNumberFormat().format(value);
            }
            return ChartUtil.stringValue((Object)value);
        }

        public String getActionString() {
            return BIRTActionRenderer.this.getActionString(this, this.handle);
        }

        public String getReportName() {
            return this.handle.getReportName();
        }

        public Map getParameterBindings() {
            return BIRTActionRenderer.this.getParameterBindings(this, this.handle);
        }

        public Map getSearchCriteria() {
            return BIRTActionRenderer.this.getSearchCriteria(this, this.handle);
        }

        public String getTargetWindow() {
            return this.handle.getTargetWindow();
        }

        public String getFormat() {
            return this.handle.getFormatType();
        }

        public boolean isBookmark() {
            return BIRTActionRenderer.this.isBookmark(this.handle);
        }

        public String getSystemId() {
            ModuleHandle mod = BIRTActionRenderer.this.eih.getRoot();
            if (mod != null) {
                return mod.getFileName();
            }
            return null;
        }

        public String getTargetFileType() {
            return this.handle.getTargetFileType();
        }

        public String getTooltip() {
            return this.handle.getToolTip();
        }
    }
}

