/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.actions;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.birt.report.designer.core.commands.CreateCommand;
import org.eclipse.birt.report.designer.core.mediator.IMediatorRequest;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.core.model.schematic.ListBandProxy;
import org.eclipse.birt.report.designer.core.util.mediator.request.ReportRequest;
import org.eclipse.birt.report.designer.internal.ui.dnd.InsertInLayoutUtil;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.Policy;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.internal.ui.views.actions.AbstractViewAction;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.jface.viewers.IStructuredSelection;

public class InsertInLayoutAction
extends AbstractViewAction {
    public static final String DISPLAY_TEXT = Messages.getString((String)"InsertInLayoutAction.action.text");
    private EditPart targetPart;

    public InsertInLayoutAction(Object selectedObject) {
        this(selectedObject, DISPLAY_TEXT);
    }

    public InsertInLayoutAction(Object selectedObject, String text) {
        super(selectedObject, text);
    }

    public boolean isEnabled() {
        return this.isTypeAvailable() && this.getTargetEditPart() != null && InsertInLayoutUtil.handleValidateInsertToLayout(this.getSelection(), this.getTargetEditPart());
    }

    public boolean isTypeAvailable() {
        return InsertInLayoutUtil.handleValidateInsert(this.getSelection());
    }

    protected EditPart getTargetEditPart() {
        if (this.targetPart == null) {
            EditPartViewer viewer = UIUtil.getLayoutEditPartViewer();
            if (viewer == null) {
                return null;
            }
            IStructuredSelection targets = (IStructuredSelection)viewer.getSelection();
            if (targets.isEmpty() && targets.size() > 1) {
                return null;
            }
            this.targetPart = (EditPart)targets.getFirstElement();
        }
        return this.targetPart;
    }

    public void run() {
        CommandStack stack = SessionHandleAdapter.getInstance().getCommandStack();
        stack.startTrans(DISPLAY_TEXT);
        try {
            DesignElementHandle newElement;
            if (Policy.TRACING_ACTIONS) {
                System.out.println("Insert layout action >> Runs ...");
            }
            if ((newElement = InsertInLayoutUtil.performInsert(this.getSelection(), this.getTargetEditPart())) != null) {
                this.runCreate(newElement, this.targetPart.getModel());
            }
            stack.commit();
            this.fireCreateRequest(newElement, this.getSelection());
        }
        catch (SemanticException e) {
            ExceptionHandler.handle(e);
            stack.rollback();
        }
    }

    private void fireCreateRequest(Object newElement, Object source) {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(newElement);
        ReportRequest r = new ReportRequest(source);
        r.setType((Object)"create element");
        r.setSelectionObject(list);
        SessionHandleAdapter.getInstance().getMediator().notifyRequest((IMediatorRequest)r);
    }

    private void runCreate(Object insertedObj, Object container) {
        if (container instanceof ListBandProxy) {
            container = ((ListBandProxy)container).getSlotHandle();
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("newObject", insertedObj);
        CreateCommand command = new CreateCommand(map);
        command.setParent(container);
        command.execute();
    }
}

