/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.area.impl;

import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.content.impl.ReportContent;
import org.eclipse.birt.report.engine.css.dom.AbstractStyle;
import org.eclipse.birt.report.engine.css.dom.AreaStyle;
import org.eclipse.birt.report.engine.css.dom.ComputedStyle;
import org.eclipse.birt.report.engine.css.engine.BIRTCSSEngine;
import org.eclipse.birt.report.engine.css.engine.value.css.CSSValueConstants;
import org.eclipse.birt.report.engine.layout.area.IArea;
import org.eclipse.birt.report.engine.layout.pdf.util.PropertyUtil;
import org.w3c.dom.css.CSSValue;

public abstract class AbstractArea
implements IArea {
    protected IStyle style;
    protected int x;
    protected int y;
    protected int width;
    protected int height;
    protected IContent content;
    protected boolean hasBoxProperty = true;
    protected int baseLine = 0;
    private static BIRTCSSEngine emptyCssEngine = new BIRTCSSEngine();
    protected float scale = 1.0f;

    AbstractArea(IContent content) {
        this.content = content;
        if (content != null) {
            this.style = new AreaStyle((ComputedStyle)content.getComputedStyle());
            IStyle contentStyle = content.getStyle();
            if (contentStyle == null || contentStyle.isEmpty()) {
                this.hasBoxProperty = false;
            }
        } else {
            this.style = new AreaStyle(emptyCssEngine);
            this.hasBoxProperty = false;
        }
    }

    AbstractArea(IContent content, IStyle style) {
        this.content = content;
        this.style = style;
    }

    AbstractArea(IReportContent report) {
        if (report != null) {
            assert (report instanceof ReportContent);
            this.style = new AreaStyle(((ReportContent)report).getCSSEngine());
        } else {
            this.style = new AreaStyle(emptyCssEngine);
        }
        this.hasBoxProperty = false;
    }

    public void setScale(float scale) {
        this.scale = scale;
    }

    @Override
    public float getScale() {
        return this.scale;
    }

    public void setAllocatedPosition(int ax, int ay) {
        if (this.hasBoxProperty) {
            this.x = ax + PropertyUtil.getDimensionValue(this.style.getProperty(0));
            this.y = ay + PropertyUtil.getDimensionValue(this.style.getProperty(6));
        } else {
            this.x = ax;
            this.y = ay;
        }
    }

    public void setAllocatedHeight(int aHeight) {
        this.height = this.hasBoxProperty ? aHeight - PropertyUtil.getDimensionValue(this.style.getProperty(6)) - PropertyUtil.getDimensionValue(this.style.getProperty(2)) : aHeight;
    }

    public void setAllocatedWidth(int aWidth) {
        if (this.hasBoxProperty) {
            int totalMarginWidth = PropertyUtil.getDimensionValue(this.style.getProperty(0)) + PropertyUtil.getDimensionValue(this.style.getProperty(1));
            if (totalMarginWidth >= aWidth) {
                this.style.setProperty(0, CSSValueConstants.NUMBER_0);
                this.style.setProperty(1, CSSValueConstants.NUMBER_0);
                this.width = aWidth;
            } else {
                this.width = aWidth - totalMarginWidth;
            }
        } else {
            this.width = aWidth;
        }
    }

    public void setContentHeight(int cHeight) {
        this.height = this.hasBoxProperty ? cHeight + PropertyUtil.getDimensionValue(this.style.getProperty(35)) + PropertyUtil.getDimensionValue(this.style.getProperty(10)) + PropertyUtil.getDimensionValue(this.style.getProperty(19)) + PropertyUtil.getDimensionValue(this.style.getProperty(13)) : cHeight;
    }

    public void setContentWidth(int cWidth) {
        this.width = this.hasBoxProperty ? cWidth + PropertyUtil.getDimensionValue(this.style.getProperty(59)) + PropertyUtil.getDimensionValue(this.style.getProperty(9)) + PropertyUtil.getDimensionValue(this.style.getProperty(12)) + PropertyUtil.getDimensionValue(this.style.getProperty(16)) : cWidth;
    }

    public int getAllocatedX() {
        if (this.hasBoxProperty) {
            return this.x - PropertyUtil.getDimensionValue(this.style.getProperty(0));
        }
        return this.x;
    }

    public int getAllocatedY() {
        if (this.hasBoxProperty) {
            return this.y - PropertyUtil.getDimensionValue(this.style.getProperty(6));
        }
        return this.y;
    }

    public int getContentWidth() {
        if (this.hasBoxProperty) {
            int totalPaddngWidth = PropertyUtil.getDimensionValue(this.style.getProperty(12)) + PropertyUtil.getDimensionValue(this.style.getProperty(16));
            int totalBorderWidth = PropertyUtil.getDimensionValue(this.style.getProperty(59)) + PropertyUtil.getDimensionValue(this.style.getProperty(9));
            if (this.width <= totalPaddngWidth) {
                this.style.setProperty(12, CSSValueConstants.NUMBER_0);
                this.style.setProperty(16, CSSValueConstants.NUMBER_0);
                return this.width - totalBorderWidth;
            }
            return this.width - totalPaddngWidth - totalBorderWidth;
        }
        return this.width;
    }

    public int getContentHeight() {
        if (this.hasBoxProperty) {
            return this.height - PropertyUtil.getDimensionValue(this.style.getProperty(35)) - PropertyUtil.getDimensionValue(this.style.getProperty(10)) - PropertyUtil.getDimensionValue(this.style.getProperty(19)) - PropertyUtil.getDimensionValue(this.style.getProperty(13));
        }
        return this.height;
    }

    public int getAllocatedWidth() {
        if (this.hasBoxProperty) {
            return this.width + PropertyUtil.getDimensionValue(this.style.getProperty(0)) + PropertyUtil.getDimensionValue(this.style.getProperty(1));
        }
        return this.width;
    }

    public int getAllocatedHeight() {
        if (this.hasBoxProperty) {
            return this.height + PropertyUtil.getDimensionValue(this.style.getProperty(6)) + PropertyUtil.getDimensionValue(this.style.getProperty(2));
        }
        return this.height;
    }

    @Override
    public IStyle getStyle() {
        return new WrappedAreaStyle((AbstractStyle)this.style);
    }

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    public int getY() {
        return this.y;
    }

    public void setPosition(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void setBaseLine(int baseLine) {
        this.baseLine = baseLine;
    }

    public int getBaseLine() {
        if (this.baseLine == 0) {
            return this.height;
        }
        return this.baseLine;
    }

    @Override
    public IContent getContent() {
        return this.content;
    }

    protected void removeMargin() {
        this.style.setProperty(0, CSSValueConstants.NUMBER_0);
        this.style.setProperty(1, CSSValueConstants.NUMBER_0);
        this.style.setProperty(6, CSSValueConstants.NUMBER_0);
        this.style.setProperty(2, CSSValueConstants.NUMBER_0);
    }

    protected void removeBorder() {
        this.style.setProperty(35, CSSValueConstants.NUMBER_0);
        this.style.setProperty(10, CSSValueConstants.NUMBER_0);
        this.style.setProperty(59, CSSValueConstants.NUMBER_0);
        this.style.setProperty(9, CSSValueConstants.NUMBER_0);
    }

    protected void removePadding() {
        this.style.setProperty(12, CSSValueConstants.NUMBER_0);
        this.style.setProperty(16, CSSValueConstants.NUMBER_0);
        this.style.setProperty(19, CSSValueConstants.NUMBER_0);
        this.style.setProperty(13, CSSValueConstants.NUMBER_0);
    }

    class WrappedAreaStyle
    extends AbstractStyle
    implements IStyle {
        IStyle style;

        WrappedAreaStyle(AbstractStyle style) {
            super(style.getCSSEngine());
            this.style = style;
        }

        @Override
        public CSSValue getProperty(int index) {
            return this.style.getProperty(index);
        }

        @Override
        public boolean isEmpty() {
            return this.style.isEmpty();
        }

        @Override
        public void setProperty(int index, CSSValue value) {
            this.style.setProperty(index, value);
            AbstractArea.this.hasBoxProperty = true;
        }
    }
}

