/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.fieldassist;

import com.ibm.icu.text.DecimalFormatSymbols;
import org.eclipse.birt.chart.ui.swt.fieldassist.TextAssistField;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class TextNumberEditorAssistField
extends TextAssistField {
    public TextNumberEditorAssistField(Text text, Composite composite) {
        this(text, composite, null);
    }

    public TextNumberEditorAssistField(Text text, Composite composite, String[] values) {
        super(text, composite, values);
    }

    @Override
    public boolean isValid() {
        String contents = this.getContents();
        if (contents == null || "".equals(contents.trim())) {
            return true;
        }
        char groupingSeparator = DecimalFormatSymbols.getInstance().getGroupingSeparator();
        int length = contents.length();
        int i = 0;
        while (i < length) {
            char ch;
            if (Character.isDigit(ch = contents.charAt(i++)) || ch == '.' || ch == groupingSeparator) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean hasQuickFix() {
        return true;
    }

    @Override
    public void quickFix() {
        String contents = this.getContents();
        StringBuilder numbersOnly = new StringBuilder();
        int length = contents.length();
        char groupingSeparator = DecimalFormatSymbols.getInstance().getGroupingSeparator();
        int i = 0;
        while (i < length) {
            char ch;
            if (!Character.isDigit(ch = contents.charAt(i++)) && ch != '.' && ch != groupingSeparator) continue;
            numbersOnly.append(ch);
        }
        this.setContents(numbersOnly.toString());
    }
}

