/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.elements.strategy;

import java.util.List;
import org.eclipse.birt.report.model.core.ContainerSlot;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.PropertySearchStrategy;
import org.eclipse.birt.report.model.elements.Cell;
import org.eclipse.birt.report.model.elements.GridItem;
import org.eclipse.birt.report.model.elements.TableColumn;
import org.eclipse.birt.report.model.elements.TableItem;
import org.eclipse.birt.report.model.elements.TableRow;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;

public class CellPropSearchStrategy
extends PropertySearchStrategy {
    private static final CellPropSearchStrategy instance = new CellPropSearchStrategy();

    protected CellPropSearchStrategy() {
    }

    public static PropertySearchStrategy getInstance() {
        return instance;
    }

    @Override
    public Object getPropertyRelatedToContainer(Module module, DesignElement cell, ElementPropertyDefn prop) {
        if ("width".equals(prop.getName()) || "height".equals(prop.getName())) {
            return super.getPropertyRelatedToContainer(module, cell, prop);
        }
        DesignElement e = cell.getContainer();
        while (e != null) {
            DesignElement tmpContainer = e.getContainer();
            if (tmpContainer instanceof TableItem || tmpContainer instanceof GridItem) {
                return this.getColumnProperty(module, tmpContainer, (Cell)cell, prop);
            }
            e = tmpContainer;
        }
        return super.getPropertyRelatedToContainer(module, cell, prop);
    }

    public Object getColumnProperty(Module module, DesignElement container, Cell cell, ElementPropertyDefn prop) {
        Object value = null;
        if (container instanceof TableItem) {
            TableItem table = (TableItem)container;
            value = this.getPropertyFromColumn(module, table, cell, prop);
        } else if (container instanceof GridItem) {
            GridItem grid = (GridItem)container;
            value = this.getPropertyFromColumn(module, grid, cell, prop);
        }
        return value;
    }

    private Object getPropertyFromColumn(Module module, TableItem table, Cell target, ElementPropertyDefn prop) {
        assert (prop.isStyleProperty());
        ContainerSlot columnSlot = table.getSlot(4);
        if (columnSlot.getCount() == 0) {
            return null;
        }
        TableColumn column = table.getColumn(module, columnSlot, target);
        return this.getPropertyFromColumn(module, column, prop);
    }

    protected Object getPropertyFromColumn(Module module, GridItem grid, Cell target, ElementPropertyDefn prop) {
        assert (prop.isStyleProperty());
        ContainerSlot columnSlot = grid.getSlot(0);
        if (columnSlot.getCount() == 0) {
            return null;
        }
        TableColumn column = grid.getColumn(module, columnSlot, target);
        return this.getPropertyFromColumn(module, column, prop);
    }

    @Override
    protected boolean isInheritableProperty(DesignElement element, ElementPropertyDefn prop) {
        assert (prop != null);
        if ("verticalAlign".equalsIgnoreCase(prop.getName()) && element.getContainer() instanceof TableRow) {
            return true;
        }
        return super.isInheritableProperty(element, prop);
    }

    @Override
    public Object getPropertyFromSelfSelector(Module module, DesignElement element, ElementPropertyDefn prop, PropertySearchStrategy.PropertyValueInfo valueInfo) {
        assert (element instanceof Cell);
        List<String> list = element.getElementSelectors();
        Object value = null;
        int i = 0;
        while (i < list.size()) {
            String selector = list.get(i);
            Object selectValue = this.getPropertyFromSelector(module, element, prop, selector, valueInfo);
            if (selectValue != null) {
                if (value == null) {
                    value = selectValue;
                }
                if (valueInfo == null) {
                    return value;
                }
            }
            ++i;
        }
        return value;
    }

    private Object getPropertyFromColumn(Module module, TableColumn column, ElementPropertyDefn prop) {
        if (prop.getName().equals("width")) {
            return null;
        }
        if (column != null) {
            return column.getStrategy().getPropertyFromElement(module, column, prop);
        }
        return null;
    }
}

