/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.utility;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.Vector;
import org.eclipse.birt.report.context.ScalarParameterBean;
import org.eclipse.birt.report.service.api.ParameterDefinition;
import org.eclipse.birt.report.service.api.ParameterSelectionChoice;
import org.eclipse.birt.report.soapengine.api.SelectItemChoice;
import org.eclipse.birt.report.utility.DataUtil;

public class ParameterUtility {
    public static List<ParameterSelectionChoice> makeSelectionList(Collection<ParameterSelectionChoice> selectionList, ScalarParameterBean parameterBean, Locale locale, TimeZone timeZone, boolean processDefault) {
        boolean nullValueFound = false;
        Vector processedList = parameterBean.getSelectionList();
        ParameterDefinition paramDef = parameterBean.getParameter();
        ArrayList<String> defaultValues = null;
        if (parameterBean.getDefaultValues() != null) {
            defaultValues = new ArrayList<String>(parameterBean.getDefaultValues());
        }
        parameterBean.setValueInList(false);
        if (selectionList != null) {
            boolean isDisplayTextInList = false;
            for (ParameterSelectionChoice selectionItem : selectionList) {
                if (selectionItem == null) continue;
                Object value = selectionItem.getValue();
                try {
                    value = DataUtil.convert(value, paramDef.getDataType());
                }
                catch (Exception e) {
                    value = null;
                }
                String displayValue = DataUtil.getDisplayValue(value, timeZone);
                String label = selectionItem.getLabel();
                if (label == null || label.length() <= 0) {
                    label = DataUtil.getDisplayValue(null, paramDef.getPattern(), value, locale, timeZone);
                }
                if (paramDef.isRequired() && (value == null || "".equals(value) && paramDef.getDataType() == 1)) continue;
                if (value == null) {
                    nullValueFound = true;
                    if (label == null) {
                        label = "Null Value";
                    }
                }
                selectionItem.setLabel(label);
                selectionItem.setValue(displayValue);
                processedList.add(selectionItem);
                if (!processDefault) continue;
                if (!paramDef.isMultiValue() && DataUtil.equals(displayValue, parameterBean.getValue())) {
                    parameterBean.setValueInList(true);
                    if (!DataUtil.equals(label, parameterBean.getDisplayText())) {
                        if (parameterBean.getParameter().isDistinct() && parameterBean.isDisplayTextInReq()) {
                            selectionItem.setLabel(parameterBean.getDisplayText());
                            isDisplayTextInList = true;
                        }
                    } else {
                        isDisplayTextInList = true;
                    }
                }
                if (paramDef.isMultiValue() && defaultValues != null) {
                    if (!DataUtil.contain(defaultValues, displayValue, true)) continue;
                    parameterBean.setDefaultValueInList(true);
                    defaultValues.remove(displayValue);
                    continue;
                }
                if (!DataUtil.equals(displayValue, parameterBean.getDefaultValue())) continue;
                parameterBean.setDefaultValueInList(true);
                if (defaultValues == null) continue;
                defaultValues.remove(displayValue);
            }
            if (processDefault) {
                if (parameterBean.isValueInList() && parameterBean.isDisplayTextInReq() && !isDisplayTextInList) {
                    processedList.add(new ParameterSelectionChoice(parameterBean.getDisplayText(), parameterBean.getValue()));
                    isDisplayTextInList = true;
                }
                if (defaultValues != null && defaultValues.size() > 0) {
                    int i = 0;
                    while (i < defaultValues.size()) {
                        processedList.add(i, new ParameterSelectionChoice((String)defaultValues.get(i), defaultValues.get(i)));
                        ++i;
                    }
                }
                parameterBean.setDisplayTextInList(isDisplayTextInList);
            }
        }
        if (!nullValueFound && !parameterBean.isRequired()) {
            ParameterSelectionChoice selectionItem = new ParameterSelectionChoice("Null Value", null);
            processedList.add(0, selectionItem);
        }
        return processedList;
    }

    public static List<SelectItemChoice> toSelectItemChoice(List<ParameterSelectionChoice> paramChoices) {
        ArrayList<SelectItemChoice> soapChoices = new ArrayList<SelectItemChoice>();
        soapChoices.add(SelectItemChoice.EMPTY_VALUE);
        for (ParameterSelectionChoice element : paramChoices) {
            SelectItemChoice itemChoice = new SelectItemChoice((String)element.getValue(), element.getLabel());
            if (itemChoice.getValue() == null) {
                itemChoice.setValue("$${{((null))}}$$");
            }
            soapChoices.add(itemChoice);
        }
        return soapChoices;
    }
}

