/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.ide.wizards;

import org.eclipse.birt.report.designer.internal.ui.wizards.WizardReportSettingPage;
import org.eclipse.birt.report.designer.internal.ui.wizards.WizardTemplateChoicePage;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlugin;
import org.eclipse.birt.report.designer.ui.util.UIUtil;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;

public class WizardNewReportCreationPage
extends WizardNewFileCreationPage {
    String fileExtension = "rptdesign";
    private WizardTemplateChoicePage templateChoicePage;

    public WizardNewReportCreationPage(String pageName, IStructuredSelection selection) {
        super(pageName, selection);
    }

    public WizardNewReportCreationPage(String pageName, IStructuredSelection selection, String fileType) {
        this(pageName, selection);
        super.setFileExtension(fileType);
        this.fileExtension = fileType;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        if (this.fileExtension.equals("rpttemplate")) {
            UIUtil.bindHelp((Control)this.getControl(), (String)"org.eclipse.birt.cshelp.NewTemplateWizard_ID");
        } else if (this.fileExtension.equals("rptdesign")) {
            UIUtil.bindHelp((Control)this.getControl(), (String)"org.eclipse.birt.cshelp.NewReportWizard_ID");
        }
    }

    protected void createAdvancedControls(Composite parent) {
    }

    protected IStatus validateLinkedResource() {
        return new Status(0, ReportPlugin.getDefault().getBundle().getSymbolicName(), 0, "", null);
    }

    protected boolean validatePage() {
        boolean rt = super.validatePage();
        if (rt) {
            if (this.isInValidFilePath()) {
                return false;
            }
            String fn = this.getFileName();
            if (!Platform.getOS().equals("win32")) {
                IPath resourcePath = !fn.endsWith("." + this.fileExtension) ? this.getContainerFullPath().append(this.getFileName() + "." + this.fileExtension) : this.getContainerFullPath().append(this.getFileName());
                if (resourcePath.lastSegment().equals("." + this.fileExtension)) {
                    this.setErrorMessage(Messages.getString((String)"WizardNewReportCreationPage.Errors.nameEmpty"));
                    return false;
                }
                IWorkspace workspace = ResourcesPlugin.getWorkspace();
                if (workspace.getRoot().getFolder(resourcePath).exists() || workspace.getRoot().getFile(resourcePath).exists()) {
                    this.setErrorMessage(Messages.getString((String)"WizardNewReportCreationPage.Errors.nameExists"));
                    rt = false;
                }
            } else {
                IPath resourcePath = !fn.toLowerCase().endsWith(("." + this.fileExtension).toLowerCase()) ? this.getContainerFullPath().append(this.getFileName() + "." + this.fileExtension) : this.getContainerFullPath().append(this.getFileName());
                if (resourcePath.lastSegment().equals("." + this.fileExtension)) {
                    this.setErrorMessage(Messages.getString((String)"WizardNewReportCreationPage.Errors.nameEmpty"));
                    return false;
                }
                IWorkspace workspace = ResourcesPlugin.getWorkspace();
                if (workspace.getRoot().getFolder(resourcePath).getLocation().toFile().exists() || workspace.getRoot().getFile(resourcePath).getLocation().toFile().exists()) {
                    this.setErrorMessage(Messages.getString((String)"WizardNewReportCreationPage.Errors.nameExists"));
                    rt = false;
                }
            }
            if (this.templateChoicePage != null) {
                this.templateChoicePage.setLTRDirection(ReportPlugin.getDefault().getLTRReportDirection(ResourcesPlugin.getWorkspace().getRoot().getProject(this.getContainerFullPath().lastSegment())));
            }
        }
        return rt;
    }

    private boolean isInValidFilePath() {
        String fn = this.getFileName();
        IPath resourcePath = !fn.endsWith("." + this.fileExtension) ? this.getContainerFullPath().append(this.getFileName() + "." + this.fileExtension) : this.getContainerFullPath().append(this.getFileName());
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IStatus result = workspace.validatePath(resourcePath.removeFileExtension().toString(), 2);
        if (!result.isOK()) {
            this.setErrorMessage(result.getMessage());
            return true;
        }
        return false;
    }

    public String getFileExtension() {
        return this.fileExtension;
    }

    public IWizardPage getNextPage() {
        IWizardPage page = super.getNextPage();
        if (page instanceof WizardReportSettingPage) {
            ((WizardReportSettingPage)page).setContainerFullPath(this.getContainerFullPath());
        }
        return page;
    }

    public void setFileExtension(String fileExtension) {
        this.fileExtension = fileExtension;
    }

    public void setTemplateChoicePage(WizardTemplateChoicePage templateChoicePage) {
        this.templateChoicePage = templateChoicePage;
    }
}

