/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqlbuilder.views;

import org.eclipse.datatools.modelbase.sql.query.QueryValueExpression;
import org.eclipse.datatools.sqltools.sqlbuilder.expressionbuilder.caseexpr.CaseSearchTable;
import org.eclipse.datatools.sqltools.sqlbuilder.expressionbuilder.caseexpr.CaseSimpleTable;
import org.eclipse.datatools.sqltools.sqlbuilder.expressionbuilder.function.ParamTable;
import org.eclipse.datatools.sqltools.sqlbuilder.expressionbuilder.multiexpr.ExpressionElement;
import org.eclipse.datatools.sqltools.sqlbuilder.expressionbuilder.multiexpr.ExpressionsTable;
import org.eclipse.datatools.sqltools.sqlbuilder.model.ExpressionHelper;
import org.eclipse.datatools.sqltools.sqlbuilder.util.LabelValuePair;
import org.eclipse.datatools.sqltools.sqlbuilder.views.EditComboBoxCellEditor;
import org.eclipse.datatools.sqltools.sqlbuilder.views.ITextProvider;
import org.eclipse.datatools.sqltools.sqlbuilder.views.criteria.CriteriaElement;
import org.eclipse.datatools.sqltools.sqlbuilder.views.criteria.CriteriaGridViewer;
import org.eclipse.datatools.sqltools.sqlbuilder.views.insert.InsertGridViewer;
import org.eclipse.datatools.sqltools.sqlbuilder.views.select.SelectGridViewer;
import org.eclipse.datatools.sqltools.sqlbuilder.views.select.SelectTableElement;
import org.eclipse.datatools.sqltools.sqlbuilder.views.update.UpdateTreeViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Composite;

public class DynamicComboBoxCellEditor
extends EditComboBoxCellEditor {
    TableViewer tableViewer = null;
    TableViewer TableViewer = null;
    private ITextProvider fTextProvider;

    public DynamicComboBoxCellEditor(Composite parent, LabelValuePair[] items, Object viewer) {
        super(parent, items, true);
        if (viewer instanceof TableViewer) {
            this.tableViewer = (TableViewer)viewer;
        } else if (viewer instanceof UpdateTreeViewer) {
            this.TableViewer = (UpdateTreeViewer)((Object)viewer);
        }
    }

    public void addItemsToStart(LabelValuePair[] newItemsToAdd) {
        LabelValuePair[] fItemsNew = new LabelValuePair[newItemsToAdd.length + this.fItems.length];
        int i = 0;
        i = 0;
        while (i < newItemsToAdd.length) {
            fItemsNew[i] = newItemsToAdd[i];
            ++i;
        }
        int j = 0;
        while (j < this.fItems.length) {
            fItemsNew[i] = this.fItems[j];
            ++i;
            ++j;
        }
        this.fItems = new LabelValuePair[fItemsNew.length];
        this.fItems = fItemsNew;
    }

    public ITextProvider getTextProvider() {
        return this.fTextProvider;
    }

    public void setTextProvider(ITextProvider textProvider) {
        this.fTextProvider = textProvider;
    }

    @Override
    protected void doSetFocus() {
        String text;
        ITextProvider textProvider;
        String valStr = "";
        Object valObj = this.getValue();
        if (valObj instanceof CriteriaElement && (textProvider = this.getTextProvider()) != null && (text = textProvider.getText(valObj)) != null) {
            valStr = text;
        }
        if (valObj instanceof ExpressionElement) {
            ExpressionElement exprElem = (ExpressionElement)valObj;
            QueryValueExpression expr = exprElem.getExpression();
            if (expr != null) {
                valStr = expr.getSQL();
            }
        } else if (valObj instanceof SelectTableElement) {
            SelectTableElement tableElem = (SelectTableElement)valObj;
            valStr = tableElem.getColumnText(0);
        } else if (valObj instanceof String) {
            valStr = valObj.toString();
        }
        this.combo.setText(valStr);
        this.combo.setFocus();
    }

    @Override
    protected LabelValuePair createComboBoxItem(String newValue) {
        return new LabelValuePair(newValue, ExpressionHelper.createExpression(newValue));
    }

    @Override
    protected void refreshComboItems() {
        int row = -1;
        if (this.tableViewer != null) {
            InsertGridViewer igv;
            if (this.tableViewer instanceof CriteriaGridViewer) {
                CriteriaGridViewer cgv = (CriteriaGridViewer)this.tableViewer;
                row = cgv.getTable().getSelectionIndex();
                if (row >= 0) {
                    cgv.refreshCellEditor(row);
                }
            } else if (this.tableViewer instanceof SelectGridViewer) {
                SelectGridViewer sgv = (SelectGridViewer)this.tableViewer;
                row = sgv.getTable().getSelectionIndex();
                if (row >= 0) {
                    sgv.refreshCellEditor(row);
                }
            } else if (this.tableViewer instanceof ParamTable) {
                ParamTable ptv = (ParamTable)this.tableViewer;
                row = ptv.getTable().getSelectionIndex();
                if (row >= 0) {
                    ptv.refreshCellEditor(row);
                }
            } else if (this.tableViewer instanceof ExpressionsTable) {
                ExpressionsTable expTable = (ExpressionsTable)this.tableViewer;
                row = expTable.getTable().getSelectionIndex();
                if (row >= 0) {
                    expTable.refreshCellEditor(row);
                }
            } else if (this.tableViewer instanceof CaseSearchTable) {
                CaseSearchTable caseSearchTable = (CaseSearchTable)this.tableViewer;
                row = caseSearchTable.getTable().getSelectionIndex();
                if (row >= 0) {
                    caseSearchTable.refreshCellEditor(row);
                }
            } else if (this.tableViewer instanceof CaseSimpleTable) {
                CaseSimpleTable caseSimpleTable = (CaseSimpleTable)this.tableViewer;
                row = caseSimpleTable.getTable().getSelectionIndex();
                if (row >= 0) {
                    caseSimpleTable.refreshCellEditor(row);
                }
            } else if (this.tableViewer instanceof InsertGridViewer && (row = (igv = (InsertGridViewer)this.tableViewer).getTable().getSelectionIndex()) >= 0) {
                igv.refreshCellEditor(row);
            }
        } else if (this.TableViewer != null && this.TableViewer instanceof UpdateTreeViewer) {
            UpdateTreeViewer utv = (UpdateTreeViewer)this.TableViewer;
            if (row >= 0) {
                utv.refresh();
            }
        }
    }
}

