/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ds.core.text;

import org.eclipse.pde.internal.core.text.IDocumentAttributeNode;
import org.eclipse.pde.internal.core.text.IDocumentTextNode;
import org.eclipse.pde.internal.ds.core.IDSSingleProperty;
import org.eclipse.pde.internal.ds.core.text.DSModel;
import org.eclipse.pde.internal.ds.core.text.DSObject;

public abstract class DSSingleProperty
extends DSObject
implements IDSSingleProperty {
    private static final long serialVersionUID = 1L;
    private final int type;

    public DSSingleProperty(DSModel model, String element, int type) {
        super(model, element);
        this.type = type;
        this.setPropertyType("String");
        int property_count = model.getDSComponent().getPropertyElements().length + 1;
        this.setPropertyName("property" + property_count);
        this.setPropertyValue("value");
    }

    @Override
    public boolean canAddChild(int objectType) {
        return false;
    }

    @Override
    public boolean canBeParent() {
        return false;
    }

    @Override
    public String getName() {
        return this.getPropertyName();
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public String getPropertyName() {
        return this.getXMLAttributeValue("name");
    }

    @Override
    public void setPropertyName(String name) {
        this.setXMLAttribute("name", name);
    }

    @Override
    public String getPropertyValue() {
        return this.getXMLAttributeValue("value");
    }

    @Override
    public void setPropertyValue(String value) {
        this.setXMLAttribute("value", value);
    }

    @Override
    public String getPropertyType() {
        return this.getXMLAttributeValue("type");
    }

    @Override
    public void setPropertyType(String type) {
        this.setXMLAttribute("type", type);
    }

    @Override
    public String getPropertyElemBody() {
        return this.getXMLContent();
    }

    @Override
    public void setPropertyElemBody(String body) {
        this.setXMLContent(body);
    }

    @Override
    public String[] getAttributesNames() {
        return new String[]{"name", "type", "value"};
    }

    public boolean isLeafNode() {
        return true;
    }

    protected boolean isDefined(IDocumentAttributeNode attribute) {
        if ("value".equals(attribute.getAttributeName())) {
            return this.getTextNode() == null;
        }
        return super.isDefined(attribute);
    }

    protected boolean isDefined(IDocumentTextNode node) {
        if (node == this.getTextNode() && this.getDocumentAttribute("value") == null) {
            return true;
        }
        return super.isDefined(node);
    }
}

