/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.composites;

import java.util.Collection;
import org.eclipse.birt.chart.api.ChartEngine;
import org.eclipse.birt.chart.device.IDeviceRenderer;
import org.eclipse.birt.chart.device.IPrimitiveRenderer;
import org.eclipse.birt.chart.event.StructureSource;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.LineAttributes;
import org.eclipse.birt.chart.model.attribute.LineStyle;
import org.eclipse.birt.chart.model.attribute.Location;
import org.eclipse.birt.chart.model.attribute.Marker;
import org.eclipse.birt.chart.model.attribute.MarkerType;
import org.eclipse.birt.chart.model.attribute.impl.AttributeFactoryImpl;
import org.eclipse.birt.chart.model.attribute.impl.ColorDefinitionImpl;
import org.eclipse.birt.chart.model.attribute.impl.ImageImpl;
import org.eclipse.birt.chart.model.attribute.impl.LineAttributesImpl;
import org.eclipse.birt.chart.model.attribute.impl.LocationImpl;
import org.eclipse.birt.chart.model.attribute.impl.MarkerImpl;
import org.eclipse.birt.chart.model.type.LineSeries;
import org.eclipse.birt.chart.model.util.ChartElementUtil;
import org.eclipse.birt.chart.render.MarkerRenderer;
import org.eclipse.birt.chart.ui.extension.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.ChartCheckbox;
import org.eclipse.birt.chart.ui.swt.ChartSpinner;
import org.eclipse.birt.chart.ui.swt.composites.ImageDialog;
import org.eclipse.birt.chart.ui.swt.wizard.ChartAdapter;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizard;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizardContext;
import org.eclipse.birt.chart.ui.util.ChartUIUtil;
import org.eclipse.birt.chart.ui.util.UIHelper;
import org.eclipse.birt.chart.util.LiteralHelper;
import org.eclipse.birt.chart.util.NameSet;
import org.eclipse.birt.core.ui.frameworks.taskwizard.WizardBase;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class MarkerEditorComposite
extends Composite
implements MouseListener {
    private static final int MARKER_BLOCK_WIDTH = 20;
    private static final int MARKER_BLOCK_HEIGHT = 20;
    private static final int MARKER_ROW_MAX_NUMBER = 6;
    private transient Marker editingMarker;
    private transient IDeviceRenderer idrSWT = null;
    private transient Canvas cnvMarker;
    private transient Button btnDropDown;
    private transient Composite cmpDropDown;
    private NameSet markerTypeSet = LiteralHelper.markerTypeSet;
    private String outlineText = null;
    private Marker defaultMarker;
    private ChartWizardContext context;

    public MarkerEditorComposite(Composite parent, Marker marker, ChartWizardContext context, Marker defaultMarker) {
        super(parent, 2048);
        this.editingMarker = marker;
        this.context = context;
        this.defaultMarker = defaultMarker;
        this.placeComponents();
        this.initAccessible();
        this.updateMarkerPreview();
    }

    private void placeComponents() {
        GridLayout layout = new GridLayout(2, false);
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.setLayout((Layout)layout);
        this.cnvMarker = new Canvas((Composite)this, 0x20000000);
        GridData gd = new GridData();
        gd.heightHint = 20;
        gd.widthHint = 20;
        gd.verticalAlignment = 0x1000000;
        gd.grabExcessVerticalSpace = true;
        this.cnvMarker.setLayoutData((Object)gd);
        this.cnvMarker.addMouseListener((MouseListener)this);
        this.cnvMarker.setToolTipText(this.getMarker().getType().getName());
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                MarkerEditorComposite.this.canvasEvent(event);
            }
        };
        int[] textEvents = new int[]{1, 2, 31, 15, 16, 9};
        int i = 0;
        while (i < textEvents.length) {
            this.cnvMarker.addListener(textEvents[i], listener);
            ++i;
        }
        this.btnDropDown = new Button((Composite)this, 1028);
        gd = new GridData();
        gd.heightHint = 20;
        gd.widthHint = 16;
        this.btnDropDown.setLayoutData((Object)gd);
        this.btnDropDown.addMouseListener((MouseListener)this);
        try {
            this.idrSWT = ChartEngine.instance().getRenderer("dv.SWT");
        }
        catch (ChartException pex) {
            WizardBase.displayException((Throwable)pex);
        }
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (MarkerEditorComposite.this.idrSWT != null) {
                    MarkerEditorComposite.this.idrSWT.dispose();
                    MarkerEditorComposite.this.idrSWT = null;
                }
            }
        });
    }

    private void canvasEvent(Event event) {
        switch (event.type) {
            case 15: {
                this.cnvMarker.redraw();
                break;
            }
            case 16: {
                this.cnvMarker.redraw();
                break;
            }
            case 1: {
                if (this.isDisposed() || event.keyCode != 0x1000002 && event.keyCode != 13 && event.keyCode != 0x1000050) break;
                event.doit = true;
                this.toggleDropDown();
                break;
            }
            case 31: {
                switch (event.detail) {
                    case 4: 
                    case 8: 
                    case 16: 
                    case 32: 
                    case 64: {
                        event.doit = true;
                        this.cnvMarker.redraw();
                    }
                }
                break;
            }
            case 9: {
                this.paintMarker(event.gc, this.getMarker(), LocationImpl.create((double)10.0, (double)10.0));
            }
        }
    }

    public void setMarker(Marker marker) {
        this.editingMarker = marker;
        this.updateMarkerPreview();
    }

    private void updateMarkerPreview() {
        this.cnvMarker.setToolTipText(this.getMarker().getType().getName());
        this.cnvMarker.redraw();
    }

    public Marker getMarker() {
        return this.editingMarker;
    }

    private void toggleDropDown() {
        if (this.cmpDropDown == null || this.cmpDropDown.isDisposed()) {
            this.createDropDownComponent();
        } else {
            this.cmpDropDown.getShell().close();
        }
    }

    private void createDropDownComponent() {
        Point pLoc = UIHelper.getScreenLocation((Composite)this.btnDropDown.getParent());
        int iXLoc = pLoc.x;
        int iYLoc = pLoc.y + this.btnDropDown.getParent().getSize().y;
        int iShellWidth = 135;
        if ((this.getStyle() & 0x4000000) != 0) {
            iXLoc -= iShellWidth;
        }
        if (iXLoc + iShellWidth > this.getDisplay().getClientArea().width) {
            iXLoc = this.getDisplay().getClientArea().width - iShellWidth;
        }
        Shell shell = new Shell(this.getShell(), 0);
        shell.setLayout((Layout)new FillLayout());
        shell.setLocation(iXLoc, iYLoc);
        this.cmpDropDown = new MarkerDropDownEditorComposite((Composite)shell, 0);
        shell.layout();
        shell.pack();
        shell.setFocus();
        shell.open();
        this.cmpDropDown.setFocus();
    }

    public void mouseDoubleClick(MouseEvent e) {
    }

    public void mouseDown(MouseEvent e) {
        this.toggleDropDown();
    }

    public void mouseUp(MouseEvent e) {
    }

    private void paintMarker(GC gc, Marker currentMarker, Location location) {
        Marker renderMarker = currentMarker;
        int markerSize = 4;
        if (currentMarker.getType() == MarkerType.ICON_LITERAL) {
            renderMarker = currentMarker.copyInstance();
            renderMarker.setFill((Fill)ImageImpl.create((String)UIHelper.getURL((String)"icons/obj16/marker_icon.gif").toString()));
            markerSize = 0;
        }
        this.idrSWT.setProperty("device.output.context", (Object)gc);
        MarkerRenderer mr = new MarkerRenderer(this.idrSWT, (Object)StructureSource.createUnknown(null), location, LineAttributesImpl.create((ColorDefinition)(this.getMarker().isSetVisible() && this.getMarker().isVisible() ? ColorDefinitionImpl.BLUE() : ColorDefinitionImpl.GREY()), (LineStyle)LineStyle.SOLID_LITERAL, (int)1), (Fill)(this.isMarkerTypeEnabled() ? ColorDefinitionImpl.create((int)80, (int)168, (int)218) : ColorDefinitionImpl.GREY()), renderMarker, Integer.valueOf(markerSize), null, false, false);
        try {
            mr.draw((IPrimitiveRenderer)this.idrSWT);
            ChartWizard.removeException((String)"MarkerEditorComposite");
        }
        catch (ChartException ex) {
            ChartWizard.showException((String)"MarkerEditorComposite", (String)ex.getLocalizedMessage());
        }
        if (this.cnvMarker.isFocusControl()) {
            gc.setLineStyle(3);
            gc.setForeground(Display.getCurrent().getSystemColor(2));
            gc.drawRectangle(0, 0, this.getSize().x - 21, this.getSize().y - 5);
        }
    }

    void initAccessible() {
        this.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getHelp(AccessibleEvent e) {
                e.result = MarkerEditorComposite.this.getToolTipText();
            }
        });
        this.getAccessible().addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

            public void getChildAtPoint(AccessibleControlEvent e) {
                Point testPoint = MarkerEditorComposite.this.toControl(new Point(e.x, e.y));
                if (MarkerEditorComposite.this.getBounds().contains(testPoint)) {
                    e.childID = -1;
                }
            }

            public void getLocation(AccessibleControlEvent e) {
                Rectangle location = MarkerEditorComposite.this.getBounds();
                Point pt = MarkerEditorComposite.this.toDisplay(new Point(location.x, location.y));
                e.x = pt.x;
                e.y = pt.y;
                e.width = location.width;
                e.height = location.height;
            }

            public void getChildCount(AccessibleControlEvent e) {
                e.detail = 0;
            }

            public void getRole(AccessibleControlEvent e) {
                e.detail = 46;
            }

            public void getState(AccessibleControlEvent e) {
                e.detail = 0;
            }
        });
        ChartUIUtil.addScreenReaderAccessibility((Control)this, (Control)this.cnvMarker);
    }

    public void setSupportedMarkerTypes(NameSet markerTypeSet) {
        this.markerTypeSet = markerTypeSet;
    }

    public void setOutlineText(String text) {
        this.outlineText = text;
    }

    private boolean isMarkerTypeEnabled() {
        return this.getMarker().isSetVisible() && this.getMarker().isVisible() && this.getMarker().isSetType();
    }

    private class MarkerDropDownEditorComposite
    extends Composite
    implements PaintListener,
    Listener {
        private ChartSpinner iscMarkerSize;
        private ChartCheckbox btnMarkerVisible;
        private ChartCheckbox btnOutline;
        private Composite cmpType;
        private Group grpSize;
        boolean isPressingKey;
        private Widget focusedComposite;
        private final String[] typeDisplayNameSet;
        private final String[] typeNameSet;
        private int markerTypeIndex;
        private Button btnAutotype;

        MarkerDropDownEditorComposite(Composite parent, int style) {
            super(parent, style);
            this.isPressingKey = false;
            this.typeDisplayNameSet = MarkerEditorComposite.this.markerTypeSet.getDisplayNames();
            this.typeNameSet = MarkerEditorComposite.this.markerTypeSet.getNames();
            this.markerTypeIndex = -1;
            this.placeComponents();
            this.pack();
        }

        private void placeComponents() {
            GridLayout glDropDown = new GridLayout(2, false);
            this.setLayout((Layout)glDropDown);
            this.btnMarkerVisible = MarkerEditorComposite.this.context.getUIFactory().createChartCheckbox((Composite)this, 0, MarkerEditorComposite.this.defaultMarker.isVisible());
            this.btnMarkerVisible.setText(Messages.getString("LineSeriesAttributeComposite.Lbl.IsVisible"));
            GridData gd = new GridData(768);
            gd.horizontalSpan = 2;
            this.btnMarkerVisible.setLayoutData((Object)gd);
            this.btnMarkerVisible.setSelectionState(MarkerEditorComposite.this.getMarker().isSetVisible() ? (MarkerEditorComposite.this.getMarker().isVisible() ? 1 : 2) : 0);
            this.btnMarkerVisible.addListener(13, (Listener)this);
            this.btnMarkerVisible.addListener(16, (Listener)this);
            this.btnMarkerVisible.addListener(1, (Listener)this);
            this.btnMarkerVisible.addListener(31, (Listener)this);
            this.btnMarkerVisible.addListener(15, (Listener)this);
            this.btnMarkerVisible.setFocus();
            Group grpType = new Group((Composite)this, 0);
            grpType.setLayout((Layout)new GridLayout(1, false));
            GridData gd2 = new GridData(768);
            gd2.horizontalSpan = 2;
            grpType.setLayoutData((Object)gd2);
            grpType.setText(Messages.getString("MarkerEditorComposite.Label.MarkerType"));
            this.btnAutotype = new Button((Composite)grpType, 32);
            this.btnAutotype.setText(Messages.getString("ItemLabel.Auto"));
            this.btnAutotype.setSelection(!MarkerEditorComposite.this.getMarker().isSetType());
            this.btnAutotype.addListener(13, (Listener)this);
            this.btnAutotype.addListener(16, (Listener)this);
            this.btnAutotype.addListener(31, (Listener)this);
            this.btnAutotype.addListener(15, (Listener)this);
            this.btnAutotype.setVisible(MarkerEditorComposite.this.context.getUIFactory().supportAutoUI());
            this.cmpType = new Composite((Composite)grpType, 0);
            GridLayout layout = new GridLayout();
            layout.numColumns = 6;
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            layout.horizontalSpacing = 0;
            layout.verticalSpacing = 0;
            this.cmpType.setLayout((Layout)layout);
            GridData gd3 = new GridData(1808);
            gd3.horizontalSpan = 2;
            this.cmpType.setLayoutData((Object)gd3);
            this.cmpType.addListener(31, (Listener)this);
            this.cmpType.addListener(1, (Listener)this);
            this.cmpType.addListener(16, (Listener)this);
            this.cmpType.addListener(15, (Listener)this);
            int modifiedSize = (this.typeDisplayNameSet.length / 6 + 1) * 6;
            int i = 0;
            while (i < modifiedSize) {
                Canvas cnvType = new Canvas(this.cmpType, 0x20000000);
                GridData gd4 = new GridData();
                gd4.heightHint = 20;
                gd4.widthHint = 20;
                cnvType.setLayoutData((Object)gd4);
                cnvType.setData((Object)i);
                cnvType.addPaintListener((PaintListener)this);
                if (i < this.typeDisplayNameSet.length) {
                    cnvType.setToolTipText(this.typeDisplayNameSet[i]);
                    cnvType.addListener(3, (Listener)this);
                }
                ++i;
            }
            this.grpSize = new Group((Composite)this, 0);
            this.grpSize.setLayout((Layout)new GridLayout(2, false));
            gd = new GridData(768);
            gd.horizontalSpan = 2;
            this.grpSize.setLayoutData((Object)gd);
            this.grpSize.addListener(31, (Listener)this);
            this.grpSize.setText(Messages.getString("LineSeriesAttributeComposite.Lbl.Size"));
            this.iscMarkerSize = MarkerEditorComposite.this.context.getUIFactory().createChartSpinner((Composite)this.grpSize, 2048, (EObject)MarkerEditorComposite.this.getMarker(), "size", MarkerEditorComposite.this.context.getUIFactory().canEnableUI(this.btnMarkerVisible));
            gd = new GridData(768);
            gd.horizontalSpan = 2;
            this.iscMarkerSize.setLayoutData((Object)gd);
            this.iscMarkerSize.getWidget().setMinimum(0);
            this.iscMarkerSize.getWidget().setMaximum(100);
            this.iscMarkerSize.getWidget().setSelection(MarkerEditorComposite.this.getMarker().getSize());
            this.iscMarkerSize.addListener(13, (Listener)this);
            this.iscMarkerSize.addListener(16, (Listener)this);
            this.iscMarkerSize.addListener(15, (Listener)this);
            this.iscMarkerSize.addListener(31, (Listener)this);
            this.btnOutline = MarkerEditorComposite.this.context.getUIFactory().createChartCheckbox((Composite)this, 0, MarkerEditorComposite.this.defaultMarker.getOutline().isVisible());
            gd = new GridData(768);
            gd.horizontalSpan = 2;
            this.btnOutline.setLayoutData((Object)gd);
            if (MarkerEditorComposite.this.outlineText != null) {
                this.btnOutline.setText(MarkerEditorComposite.this.outlineText + ":");
            } else {
                this.btnOutline.setText(Messages.getString("MarkerEditorComposite.Button.Outline") + ":");
            }
            this.btnOutline.addListener(13, (Listener)this);
            this.btnOutline.addListener(16, (Listener)this);
            this.btnOutline.addListener(15, (Listener)this);
            this.btnOutline.addListener(1, (Listener)this);
            this.btnOutline.addListener(31, (Listener)this);
            LineAttributes la = MarkerEditorComposite.this.getMarker().getOutline();
            if (la == null) {
                ChartAdapter.beginIgnoreNotifications();
                la = AttributeFactoryImpl.eINSTANCE.createLineAttributes();
                la.eAdapters().addAll((Collection)MarkerEditorComposite.this.getMarker().eAdapters());
                Marker o = MarkerEditorComposite.this.getMarker();
                while (!(o instanceof LineSeries)) {
                    if ((o = o.eContainer()) == null) break;
                }
                if (o instanceof LineSeries) {
                    la.setVisible(((LineSeries)o).getLineAttributes().isVisible());
                }
                ChartAdapter.endIgnoreNotifications();
            }
            MarkerEditorComposite.this.getMarker().setOutline(la);
            this.btnOutline.setSelectionState(la.isSetVisible() ? (la.isVisible() ? 1 : 2) : 0);
            this.updateOutlineBtn();
            this.setEnabledState(MarkerEditorComposite.this.context.getUIFactory().canEnableUI(this.btnMarkerVisible));
            if (this.btnAutotype.isVisible()) {
                this.setMarkerTypesState(MarkerEditorComposite.this.context.getUIFactory().canEnableUI(this.btnMarkerVisible) && !this.btnAutotype.getSelection());
            } else {
                this.setMarkerTypesState(MarkerEditorComposite.this.context.getUIFactory().canEnableUI(this.btnMarkerVisible));
            }
        }

        void widgetSelected(SelectionEvent e) {
            if (e.widget.equals(this.btnMarkerVisible)) {
                ChartElementUtil.setEObjectAttribute((EObject)MarkerEditorComposite.this.getMarker(), (String)"visible", (Object)(this.btnMarkerVisible.getSelectionState() == 1 ? 1 : 0), (this.btnMarkerVisible.getSelectionState() == 0 ? 1 : 0) != 0);
                this.setEnabledState(MarkerEditorComposite.this.context.getUIFactory().canEnableUI(this.btnMarkerVisible));
                MarkerEditorComposite.this.cnvMarker.redraw();
                this.updateOutlineBtn();
            } else if (e.widget == this.btnOutline) {
                LineAttributes la = MarkerEditorComposite.this.getMarker().getOutline();
                ChartElementUtil.setEObjectAttribute((EObject)la, (String)"visible", (Object)(this.btnOutline.getSelectionState() == 1 ? 1 : 0), (this.btnOutline.getSelectionState() == 0 ? 1 : 0) != 0);
                MarkerEditorComposite.this.cnvMarker.redraw();
            } else if (e.widget == this.btnAutotype) {
                if (this.btnAutotype.getSelection()) {
                    MarkerEditorComposite.this.getMarker().unsetType();
                    this.setMarkerTypesState(false);
                } else {
                    if (MarkerEditorComposite.this.defaultMarker != null && MarkerEditorComposite.this.defaultMarker.isSetType()) {
                        this.switchMarkerTypeImpl(MarkerEditorComposite.this.defaultMarker.getType());
                    } else {
                        this.switchMarkerType(0);
                    }
                    this.setMarkerTypesState(true);
                }
                MarkerEditorComposite.this.cnvMarker.redraw();
            }
        }

        private void setEnabledState(boolean isEnabled) {
            this.grpSize.setEnabled(isEnabled);
            this.btnAutotype.setEnabled(isEnabled);
            this.iscMarkerSize.setEnabled(isEnabled);
            this.setMarkerTypesState(isEnabled);
        }

        protected void setMarkerTypesState(boolean isEnabled) {
            this.cmpType.setEnabled(isEnabled);
            Control[] cnvTypes = this.cmpType.getChildren();
            int i = 0;
            while (i < cnvTypes.length) {
                cnvTypes[i].setEnabled(isEnabled);
                cnvTypes[i].redraw();
                ++i;
            }
        }

        void focusLost(FocusEvent e) {
            Control currentControl = this.isPressingKey ? Display.getCurrent().getFocusControl() : Display.getCurrent().getCursorControl();
            this.isPressingKey = false;
            if (currentControl != MarkerEditorComposite.this.btnDropDown && currentControl != MarkerEditorComposite.this.cnvMarker && !this.isChildrenOfThis(currentControl)) {
                this.getShell().close();
            }
        }

        private boolean isChildrenOfThis(Control control) {
            while (control != null) {
                if (control == this) {
                    return true;
                }
                control = control.getParent();
            }
            return false;
        }

        public void paintControl(PaintEvent e) {
            GC gc = e.gc;
            int markerIndex = (Integer)e.widget.getData();
            int markerLength = this.typeNameSet.length;
            String typeName = null;
            if (markerIndex < markerLength) {
                typeName = this.typeNameSet[markerIndex];
                gc.setBackground(Display.getDefault().getSystemColor(29));
                gc.fillRectangle(0, 0, 20, 20);
            }
            int lineWidth = 1;
            if (MarkerEditorComposite.this.isMarkerTypeEnabled()) {
                gc.setForeground(Display.getDefault().getSystemColor(2));
            } else {
                gc.setForeground(Display.getDefault().getSystemColor(15));
            }
            gc.setLineWidth(lineWidth);
            int x = lineWidth - 1;
            int y = lineWidth - 1;
            int width = 21 - 2 * lineWidth;
            int height = 21 - 2 * lineWidth;
            if (markerIndex / 6 < markerLength / 6) {
                ++height;
            }
            if ((markerIndex + 1) % 6 != 0) {
                ++width;
            }
            if (typeName == null) {
                if (markerIndex > markerLength) {
                    x = -1;
                    width += 2;
                }
                ++height;
            }
            gc.drawRectangle(x, y, width, height);
            if (MarkerEditorComposite.this.getMarker().getType().getName().equals(typeName)) {
                this.markerTypeIndex = markerIndex;
                gc.setForeground(Display.getDefault().getSystemColor(3));
                gc.drawRectangle(1, 1, 18, 18);
            }
            if (typeName != null) {
                MarkerEditorComposite.this.paintMarker(gc, MarkerImpl.create((MarkerType)MarkerType.getByName((String)typeName), (int)4), LocationImpl.create((double)10.0, (double)10.0));
            }
        }

        private void switchMarkerType(int newMarkerTypeIndex) {
            MarkerType newType = MarkerType.getByName((String)this.typeNameSet[newMarkerTypeIndex]);
            this.switchMarkerTypeImpl(newType);
        }

        private void switchMarkerTypeImpl(MarkerType newType) {
            if (newType == MarkerType.ICON_LITERAL) {
                ImageDialog iconDialog = (ImageDialog)MarkerEditorComposite.this.context.getUIFactory().createChartMarkerIconDialog(new Shell(), MarkerEditorComposite.this.getMarker().getFill(), MarkerEditorComposite.this.context);
                if (iconDialog.open() == 0) {
                    Fill resultFill = iconDialog.getResult();
                    if (resultFill.eAdapters().isEmpty()) {
                        resultFill.eAdapters().addAll((Collection)MarkerEditorComposite.this.getMarker().eAdapters());
                    }
                    MarkerEditorComposite.this.getMarker().setFill(resultFill);
                } else {
                    return;
                }
            }
            MarkerEditorComposite.this.getMarker().setType(newType);
            MarkerEditorComposite.this.updateMarkerPreview();
        }

        private void redrawMarkers(int newMarkerTypeIndex) {
            if (this.cmpType != null && !this.cmpType.isDisposed()) {
                Control[] children = this.cmpType.getChildren();
                if (children == null || children[newMarkerTypeIndex] == null || children[this.markerTypeIndex] == null) {
                    return;
                }
                children[newMarkerTypeIndex].redraw();
                children[this.markerTypeIndex].redraw();
            }
        }

        void mouseDown(MouseEvent e) {
            if (e.widget instanceof Canvas && e.widget.getData() != null) {
                int markerIndex = (Integer)e.widget.getData();
                this.switchMarkerType(markerIndex);
                if (!this.isDisposed() && !this.getShell().isDisposed()) {
                    this.getShell().close();
                }
            }
        }

        public void handleEvent(Event event) {
            switch (event.type) {
                case 16: {
                    this.focusLost(new FocusEvent(event));
                    break;
                }
                case 15: {
                    this.focusedComposite = event.widget;
                    break;
                }
                case 3: {
                    this.mouseDown(new MouseEvent(event));
                    break;
                }
                case 13: {
                    this.widgetSelected(new SelectionEvent(event));
                    break;
                }
                case 1: {
                    if (event.keyCode == 27) {
                        this.getShell().close();
                        break;
                    }
                    if (event.widget != this.cmpType) break;
                    if (event.keyCode == 0x1000003) {
                        if (this.markerTypeIndex - 1 < 0) break;
                        int newIndex = this.markerTypeIndex - 1;
                        this.switchMarkerType(newIndex);
                        this.redrawMarkers(newIndex);
                        break;
                    }
                    if (event.keyCode == 0x1000004) {
                        if (this.markerTypeIndex + 1 >= this.typeNameSet.length) break;
                        int newIndex = this.markerTypeIndex + 1;
                        this.switchMarkerType(newIndex);
                        this.redrawMarkers(newIndex);
                        break;
                    }
                    if (event.keyCode == 0x1000001) {
                        if (this.markerTypeIndex - 6 < 0) break;
                        int newIndex = this.markerTypeIndex - 6;
                        this.switchMarkerType(newIndex);
                        this.redrawMarkers(newIndex);
                        break;
                    }
                    if (event.keyCode != 0x1000002 || this.markerTypeIndex + 6 >= this.typeNameSet.length) break;
                    int newIndex = this.markerTypeIndex + 6;
                    this.switchMarkerType(newIndex);
                    this.redrawMarkers(newIndex);
                    break;
                }
                case 31: {
                    if (event.detail == 16 || event.detail == 8) {
                        event.doit = true;
                        this.isPressingKey = true;
                        break;
                    }
                    if (event.keyCode == this.getMnemonicByText(this.grpSize.getText())) {
                        this.updateIsPressingKey((Widget)this.iscMarkerSize);
                        break;
                    }
                    if (event.keyCode == this.getMnemonicByText(this.btnOutline.getButton().getText())) {
                        this.updateIsPressingKey((Widget)this.btnOutline);
                        break;
                    }
                    if (event.keyCode != this.getMnemonicByText(this.btnMarkerVisible.getButton().getText())) break;
                    this.updateIsPressingKey((Widget)this.btnMarkerVisible);
                }
            }
        }

        private char getMnemonicByText(String string) {
            int index = 0;
            int length = string.length();
            while (true) {
                if (index < length && string.charAt(index) != '&') {
                    ++index;
                    continue;
                }
                if (++index >= length) {
                    return '\u0000';
                }
                if (string.charAt(index) != '&') {
                    return string.toLowerCase().charAt(index);
                }
                if (++index >= length) break;
            }
            return '\u0000';
        }

        private void updateIsPressingKey(Widget widget) {
            if (widget != this.focusedComposite) {
                this.isPressingKey = true;
            }
        }

        private void updateOutlineBtn() {
            this.btnOutline.setEnabled(MarkerEditorComposite.this.context.getUIFactory().canEnableUI(this.btnMarkerVisible));
        }
    }
}

