/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.render;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.chart.computation.GObjectFactory;
import org.eclipse.birt.chart.computation.IGObjectFactory;
import org.eclipse.birt.chart.device.IPrimitiveRenderer;
import org.eclipse.birt.chart.event.EventObjectCache;
import org.eclipse.birt.chart.event.Line3DRenderEvent;
import org.eclipse.birt.chart.event.LineRenderEvent;
import org.eclipse.birt.chart.event.OvalRenderEvent;
import org.eclipse.birt.chart.event.Polygon3DRenderEvent;
import org.eclipse.birt.chart.event.PolygonRenderEvent;
import org.eclipse.birt.chart.event.StructureSource;
import org.eclipse.birt.chart.event.WrappedInstruction;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.LineAttributes;
import org.eclipse.birt.chart.model.attribute.Location;
import org.eclipse.birt.chart.model.attribute.Location3D;
import org.eclipse.birt.chart.model.attribute.impl.Location3DImpl;
import org.eclipse.birt.chart.model.attribute.impl.LocationImpl;
import org.eclipse.birt.chart.render.AxesRenderer;
import org.eclipse.birt.chart.render.BaseRenderer;
import org.eclipse.birt.chart.render.DeferredCache;
import org.eclipse.birt.chart.util.FillUtil;

public final class CurveRenderer {
    private static final double kError = 0.5;
    private static final IGObjectFactory goFactory = GObjectFactory.instance();
    private int iNumberOfPoints = 0;
    private Spline spX = null;
    private Spline spY = null;
    private double[] fa;
    private double[] faX;
    private double[] faY;
    private double[] faZ;
    private final double zeroLocation;
    private final Object oSource;
    private LineAttributes lia;
    private final Location loStart;
    private final Location loEnd;
    private final DeferredCache dc;
    private final ChartWithAxes cwa;
    private final boolean bShowAsTape;
    private final boolean bFillArea;
    private final boolean bUseLastState;
    private final boolean bKeepState;
    private final boolean bTranslucent;
    private final boolean bDeferred;
    private final boolean bConnectMissingValue;
    private final Location[] loa;
    private final Location3D[] loa3d;
    private final Location[] loPoints;
    private Location[] tempPoints;
    private final double dTapeWidth;
    private ColorDefinition fillColor;
    private ColorDefinition sideColor;
    private ColorDefinition tapeColor;
    private final BaseRenderer iRender;
    private final boolean bRendering3D;

    public CurveRenderer(ChartWithAxes _cwa, BaseRenderer _render, LineAttributes _lia, Location[] _lo, boolean _bShowAsTape, double _tapeWidth, boolean _bDeferred, boolean _bKeepState, Fill paletteEntry, boolean usePaletteLineColor, boolean connectMissingValue) {
        this(_cwa, _render, _lia, _lo, 0.0, _bShowAsTape, _tapeWidth, false, false, false, _bDeferred, _bKeepState, paletteEntry, usePaletteLineColor, connectMissingValue);
    }

    public CurveRenderer(ChartWithAxes _cwa, BaseRenderer _render, LineAttributes _lia, Location[] _lo, double _zeroLocation, boolean _bShowAsTape, double _tapeWidth, boolean _bFillArea, boolean _bTranslucent, boolean _bUseLastState, boolean _bDeferred, boolean _bKeepState, Fill paletteEntry, boolean usePaletteLineColor, boolean connectMissingValue) {
        int i;
        this.cwa = _cwa;
        this.bRendering3D = _lo instanceof Location3D[];
        this.loPoints = _lo;
        this.tempPoints = _lo;
        this.bConnectMissingValue = connectMissingValue;
        this.bFillArea = _bFillArea;
        this.bShowAsTape = _bShowAsTape;
        this.bDeferred = _bDeferred;
        this.loa = this.bShowAsTape || this.bFillArea ? new Location[4] : null;
        this.loa3d = this.bRendering3D ? new Location3D[4] : null;
        this.dTapeWidth = _tapeWidth == -1.0 ? _cwa.getSeriesThickness() * _render.getDeviceScale() : _tapeWidth;
        if (this.loa != null) {
            i = 0;
            while (i < 4) {
                this.loa[i] = goFactory.createLocation(0.0, 0.0);
                ++i;
            }
        }
        if (this.loa3d != null) {
            i = 0;
            while (i < 4) {
                this.loa3d[i] = goFactory.createLocation3D(0.0, 0.0, 0.0);
                ++i;
            }
        }
        this.lia = _lia;
        this.zeroLocation = _zeroLocation;
        this.bTranslucent = _bTranslucent;
        this.oSource = StructureSource.createSeries(_render.getSeries());
        this.dc = _render.getDeferredCache();
        if (this.bShowAsTape) {
            this.dc.setPlanesComparator(WrappedInstruction.getDefaultComarator());
        }
        this.iRender = _render;
        this.loStart = goFactory.createLocation(0.0, 0.0);
        this.loEnd = goFactory.createLocation(0.0, 0.0);
        this.bUseLastState = _bUseLastState;
        this.bKeepState = _bKeepState;
        if (usePaletteLineColor) {
            this.lia = goFactory.copyOf(this.lia);
            this.lia.setColor(FillUtil.getColor(paletteEntry));
        }
        if (this.bFillArea) {
            this.fillColor = FillUtil.getColor(paletteEntry);
            this.tapeColor = this.fillColor.brighter();
            this.sideColor = this.fillColor.darker();
        } else {
            this.fillColor = this.lia.getColor();
            this.tapeColor = this.lia.getColor().brighter();
            this.sideColor = this.lia.getColor().darker();
        }
        if (this.bTranslucent) {
            this.fillColor = this.fillColor.translucent();
            this.tapeColor = this.tapeColor.translucent();
            this.sideColor = this.sideColor.translucent();
        }
    }

    public void draw(IPrimitiveRenderer ipr) throws ChartException {
        if (!this.bFillArea && !this.lia.isVisible()) {
            return;
        }
        if (!this.bConnectMissingValue) {
            int i = 0;
            while (i < this.loPoints.length) {
                if (!Double.isNaN(this.loPoints[i].getX()) && !Double.isNaN(this.loPoints[i].getY())) {
                    ArrayList<Location> al = new ArrayList<Location>();
                    while (i < this.loPoints.length && !Double.isNaN(this.loPoints[i].getX()) && !Double.isNaN(this.loPoints[i].getY())) {
                        al.add(this.loPoints[i]);
                        ++i;
                    }
                    --i;
                    this.tempPoints = this.loPoints instanceof Location3D[] ? (Location[])al.toArray(new Location3D[al.size()]) : al.toArray(new Location[al.size()]);
                    this.faX = LocationImpl.getXArray(this.tempPoints);
                    this.faY = LocationImpl.getYArray(this.tempPoints);
                    this.faZ = (double[])(this.bRendering3D ? Location3DImpl.getZArray((Location3D[])this.tempPoints) : null);
                    this.iNumberOfPoints = this.faX.length;
                    if (this.iNumberOfPoints < 1) {
                        return;
                    }
                    if (this.iNumberOfPoints == 1) {
                        double iSize = this.lia.getThickness();
                        if (this.bRendering3D) {
                            Line3DRenderEvent lre3dValue = ((EventObjectCache)((Object)ipr)).getEventObject(this.oSource, Line3DRenderEvent.class);
                            Location3D[] loa3dValue = new Location3D[]{goFactory.createLocation3D(this.faX[0], this.faY[0], this.faZ[0]), goFactory.createLocation3D(this.faX[0], this.faY[0], this.faZ[0] - this.dTapeWidth)};
                            lre3dValue.setStart3D(loa3dValue[0]);
                            lre3dValue.setEnd3D(loa3dValue[1]);
                            lre3dValue.setLineAttributes(this.lia);
                            this.dc.addLine(lre3dValue);
                        } else {
                            OvalRenderEvent ore = ((EventObjectCache)((Object)ipr)).getEventObject(this.oSource, OvalRenderEvent.class);
                            ore.setBounds(goFactory.createBounds(this.faX[0] - iSize, this.faY[0] - iSize, 2.0 * iSize, 2.0 * iSize));
                            ore.setOutline(this.lia);
                            ipr.drawOval(ore);
                        }
                    } else {
                        this.spX = new Spline(this.faX);
                        this.spY = new Spline(this.faY);
                        this.fa = new double[this.iNumberOfPoints];
                        int j = 0;
                        while (j < this.iNumberOfPoints) {
                            this.fa[j] = j;
                            ++j;
                        }
                        this.renderCurve(ipr, 0.0, 0.0);
                    }
                }
                ++i;
            }
        } else {
            this.tempPoints = this.iRender.filterNull(this.loPoints);
            this.faX = LocationImpl.getXArray(this.tempPoints);
            this.faY = LocationImpl.getYArray(this.tempPoints);
            this.faZ = (double[])(this.bRendering3D ? Location3DImpl.getZArray((Location3D[])this.tempPoints) : null);
            this.iNumberOfPoints = this.faX.length;
            if (this.iNumberOfPoints <= 1) {
                return;
            }
            this.spX = new Spline(this.faX);
            this.spY = new Spline(this.faY);
            this.fa = new double[this.iNumberOfPoints];
            int i = 0;
            while (i < this.iNumberOfPoints) {
                this.fa[i] = i;
                ++i;
            }
            this.renderCurve(ipr, 0.0, 0.0);
        }
    }

    private void plotPlane(IPrimitiveRenderer ipr, double x1, double y1, double x2, double y2, double z1, double z2, boolean drawSide, boolean leftSide) throws ChartException {
        if (this.bRendering3D) {
            Polygon3DRenderEvent pre = ((EventObjectCache)((Object)ipr)).getEventObject(this.oSource, Polygon3DRenderEvent.class);
            pre.setOutline(null);
            pre.setDoubleSided(true);
            pre.setBackground(this.tapeColor);
            if (!leftSide) {
                this.loa3d[0].set(x1 + 0.5, y1 + 0.5, z1);
                this.loa3d[1].set(x2 + 0.5, y2 + 0.5, z2);
                this.loa3d[2].set(x2 + 0.5, y2 + 0.5, z2 - this.dTapeWidth);
                this.loa3d[3].set(x1 + 0.5, y1 + 0.5, z1 - this.dTapeWidth);
                pre.setPoints3D(this.loa3d);
                this.dc.addPlane(pre, 2);
            }
            if (drawSide) {
                pre.setBackground(this.sideColor);
                if (leftSide) {
                    if (y1 + 0.5 > this.zeroLocation) {
                        this.loa3d[0].set(x1 + 0.5, y1 + 0.5, z1);
                        this.loa3d[1].set(x1 + 0.5, y1 + 0.5, z1 - this.dTapeWidth);
                        this.loa3d[2].set(x1 + 0.5, this.zeroLocation, z1 - this.dTapeWidth);
                        this.loa3d[3].set(x1 + 0.5, this.zeroLocation, z1);
                    } else {
                        this.loa3d[0].set(x1 + 0.5, y1 + 0.5, z1);
                        this.loa3d[1].set(x1 + 0.5, this.zeroLocation, z1);
                        this.loa3d[2].set(x1 + 0.5, this.zeroLocation, z1 - this.dTapeWidth);
                        this.loa3d[3].set(x1 + 0.5, y1 + 0.5, z1 - this.dTapeWidth);
                    }
                } else if (y2 + 0.5 > this.zeroLocation) {
                    this.loa3d[0].set(x2 + 0.5, y2 + 0.5, z2);
                    this.loa3d[1].set(x2 + 0.5, this.zeroLocation, z2);
                    this.loa3d[2].set(x2 + 0.5, this.zeroLocation, z2 - this.dTapeWidth);
                    this.loa3d[3].set(x2 + 0.5, y2 + 0.5, z2 - this.dTapeWidth);
                } else {
                    this.loa3d[0].set(x2 + 0.5, y2 + 0.5, z2);
                    this.loa3d[1].set(x2 + 0.5, y2 + 0.5, z2 - this.dTapeWidth);
                    this.loa3d[2].set(x2 + 0.5, this.zeroLocation, z2 - this.dTapeWidth);
                    this.loa3d[3].set(x2 + 0.5, this.zeroLocation, z2);
                }
                pre.setPoints3D(this.loa3d);
                this.dc.addPlane(pre, 2);
            }
        } else {
            PolygonRenderEvent pre = ((EventObjectCache)((Object)ipr)).getEventObject(this.oSource, PolygonRenderEvent.class);
            pre.setOutline(null);
            pre.setBackground(this.tapeColor);
            this.loa[0].set(x1 + 0.5, y1 + 0.5);
            this.loa[1].set(x2 + 0.5, y2 + 0.5);
            this.loa[2].set(x2 + 0.5 + this.dTapeWidth, y2 + 0.5 - this.dTapeWidth);
            this.loa[3].set(x1 + 0.5 + this.dTapeWidth, y1 + 0.5 - this.dTapeWidth);
            pre.setPoints(this.loa);
            if (this.bDeferred) {
                this.dc.addPlane(pre, 2);
            } else {
                ipr.fillPolygon(pre);
            }
            if (drawSide) {
                pre.setBackground(this.sideColor);
                if (leftSide) {
                    this.loa[0].set(x1 + 0.5, y1 + 0.5);
                    this.loa[1].set(x1 + 0.5 + this.dTapeWidth, y1 + 0.5 - this.dTapeWidth);
                    if (this.cwa.isTransposed()) {
                        this.loa[2].set(this.zeroLocation + this.dTapeWidth, y1 + 0.5 - this.dTapeWidth);
                        this.loa[3].set(this.zeroLocation, y1 + 0.5);
                    } else {
                        this.loa[2].set(x1 + 0.5 + this.dTapeWidth, this.zeroLocation - this.dTapeWidth);
                        this.loa[3].set(x1 + 0.5, this.zeroLocation);
                    }
                } else {
                    Object obj = this.iRender.getRunTimeContext().getState("stacked_series_location_key");
                    double[] last = new double[]{this.zeroLocation, this.zeroLocation};
                    if (obj instanceof List) {
                        List lst = (List)obj;
                        int index = lst.size() - 1;
                        if (index > 0) {
                            obj = lst.get(index);
                        }
                        if (obj instanceof double[]) {
                            last = (double[])obj;
                        }
                    }
                    this.loa[0].set(x2 + 0.5, y2 + 0.5);
                    this.loa[1].set(x2 + 0.5 + this.dTapeWidth, y2 + 0.5 - this.dTapeWidth);
                    if (this.cwa.isTransposed()) {
                        this.loa[2].set(last[0] + this.dTapeWidth, y2 + 0.5 - this.dTapeWidth);
                        this.loa[3].set(last[0], y2 + 0.5);
                    } else {
                        this.loa[2].set(x2 + 0.5 + this.dTapeWidth, last[1] - this.dTapeWidth);
                        this.loa[3].set(x2 + 0.5, last[1]);
                    }
                }
                pre.setPoints(this.loa);
                if (this.bDeferred) {
                    this.dc.addPlane(pre, 2);
                } else {
                    ipr.fillPolygon(pre);
                }
            }
        }
    }

    private void plotLine(IPrimitiveRenderer ipr, double x1, double y1, double x2, double y2, double z1, double z2) throws ChartException {
        if (this.bRendering3D) {
            Line3DRenderEvent lre = ((EventObjectCache)((Object)ipr)).getEventObject(this.oSource, Line3DRenderEvent.class);
            lre.setLineAttributes(this.lia);
            lre.setStart3D(goFactory.createLocation3D(x1 + 0.5, y1 + 0.5, z1));
            lre.setEnd3D(goFactory.createLocation3D(x2 + 0.5, y2 + 0.5, z2));
            this.dc.addLine(lre);
        } else {
            LineRenderEvent lre = ((EventObjectCache)((Object)ipr)).getEventObject(this.oSource, LineRenderEvent.class);
            lre.setLineAttributes(this.lia);
            this.loStart.set(x1 + 0.5, y1 + 0.5);
            this.loEnd.set(x2 + 0.5, y2 + 0.5);
            lre.setStart(this.loStart);
            lre.setEnd(this.loEnd);
            if (this.bDeferred) {
                this.dc.addLine(lre);
            } else {
                ipr.drawLine(lre);
            }
        }
    }

    private boolean computeSpline(double t, double[] faXY) {
        if (this.spX == null || this.spY == null) {
            return false;
        }
        faXY[0] = this.spX.computeValue(t);
        faXY[1] = this.spY.computeValue(t);
        return true;
    }

    private void plotArea(IPrimitiveRenderer ipr, List<double[]> points) throws ChartException {
        block41: {
            Location[] pa;
            PolygonRenderEvent pre;
            LineRenderEvent lre;
            block40: {
                int i;
                Polygon3DRenderEvent pre3d;
                if (points == null || points.size() < 1) {
                    return;
                }
                lre = ((EventObjectCache)((Object)ipr)).getEventObject(this.oSource, LineRenderEvent.class);
                lre.setLineAttributes(this.lia);
                Line3DRenderEvent lre3d = ((EventObjectCache)((Object)ipr)).getEventObject(this.oSource, Line3DRenderEvent.class);
                lre3d.setLineAttributes(this.lia);
                pre = this.bRendering3D ? null : ((EventObjectCache)((Object)ipr)).getEventObject(this.oSource, PolygonRenderEvent.class);
                Polygon3DRenderEvent polygon3DRenderEvent = pre3d = this.bRendering3D ? ((EventObjectCache)((Object)ipr)).getEventObject(this.oSource, Polygon3DRenderEvent.class) : null;
                if (this.bUseLastState) {
                    int i2;
                    List<Location> lst;
                    Object obj = this.iRender.getRunTimeContext().getState("fixed_stacked_series_index_key");
                    double[] lastFixedX = null;
                    double[] lastFixedY = null;
                    int lastVisbileSeriesIndex = this.iRender.getSeriesIndex() - 1;
                    if (this.iRender instanceof AxesRenderer) {
                        lastVisbileSeriesIndex = ((AxesRenderer)this.iRender).getPrevVisibleSiblingSeriesIndex(this.iRender.getSeriesIndex());
                    }
                    if (obj instanceof Integer && (Integer)obj == lastVisbileSeriesIndex && (obj = this.iRender.getRunTimeContext().getState("fixed_stacked_series_location_key")) instanceof List && ((List)obj).size() > 0) {
                        List lst2 = (List)obj;
                        int i3 = 0;
                        while (i3 < lst2.size()) {
                            Object o = lst2.get(i3);
                            if (o instanceof double[]) {
                                if (lastFixedX == null) {
                                    lastFixedX = new double[lst2.size()];
                                    lastFixedY = new double[lastFixedX.length];
                                }
                            } else {
                                lastFixedX = null;
                                lastFixedY = null;
                                break;
                            }
                            lastFixedX[i3] = ((double[])o)[0];
                            lastFixedY[i3] = ((double[])o)[1];
                            ++i3;
                        }
                    }
                    obj = this.iRender.getRunTimeContext().getState("stacked_series_location_key");
                    double[] lastX = null;
                    double[] lastY = null;
                    if (obj instanceof List && ((List)obj).size() > 0) {
                        lst = (List)obj;
                        i2 = 0;
                        while (i2 < lst.size()) {
                            Object o = lst.get(i2);
                            if (o instanceof double[]) {
                                if (lastX == null) {
                                    lastX = new double[lst.size()];
                                    lastY = new double[lastX.length];
                                }
                            } else {
                                lastX = null;
                                lastY = null;
                                break;
                            }
                            lastX[i2] = ((double[])o)[0];
                            lastY[i2] = ((double[])o)[1];
                            ++i2;
                        }
                    }
                    if (lastX != null) {
                        lst = new ArrayList();
                        i2 = 0;
                        while (i2 < points.size()) {
                            double[] pt = points.get(i2);
                            lst.add(goFactory.createLocation(pt[0], pt[1]));
                            ++i2;
                        }
                        if (lastFixedX != null) {
                            i2 = lastFixedX.length - 1;
                            while (i2 >= 0) {
                                lst.add(goFactory.createLocation(lastFixedX[i2], (double)lastFixedY[i2]));
                                --i2;
                            }
                        } else {
                            i2 = lastX.length - 1;
                            while (i2 >= 0) {
                                lst.add(goFactory.createLocation(lastX[i2], lastY[i2]));
                                --i2;
                            }
                        }
                        Location[] pa2 = lst.toArray(new Location[lst.size()]);
                        pre.setOutline(null);
                        pre.setPoints(pa2);
                        pre.setBackground(this.fillColor);
                        if (this.bDeferred) {
                            this.dc.addPlane(pre, 2);
                        } else {
                            ipr.fillPolygon(pre);
                        }
                        if (this.lia.isVisible()) {
                            int i4 = 0;
                            while (i4 < points.size() - 1) {
                                lre.setStart(pa2[i4]);
                                lre.setEnd(pa2[i4 + 1]);
                                if (this.bDeferred) {
                                    this.dc.addLine(lre);
                                } else {
                                    ipr.drawLine(lre);
                                }
                                ++i4;
                            }
                        }
                        return;
                    }
                }
                if (!this.bRendering3D) break block40;
                pa = new Location3D[points.size() + 2];
                double[] pt0 = points.get(0);
                if (pt0[1] > this.zeroLocation) {
                    i = 1;
                    while (i < points.size()) {
                        double[] pt = points.get(i);
                        pa[pa.length - i] = goFactory.createLocation3D(pt[0], pt[1], pt[2]);
                        ++i;
                    }
                    pa[0] = goFactory.createLocation3D(pt0[0], pt0[1], pt0[2]);
                    pa[1] = goFactory.createLocation3D(pt0[0], this.zeroLocation, pt0[2]);
                    pa[2] = goFactory.createLocation3D(pa[3].getX(), this.zeroLocation, pa[3].getZ());
                } else {
                    i = 0;
                    while (i < points.size()) {
                        double[] pt = points.get(i);
                        pa[i + 2] = goFactory.createLocation3D(pt[0], pt[1], pt[2]);
                        ++i;
                    }
                    pa[0] = goFactory.createLocation3D(pa[pa.length - 1].getX(), this.zeroLocation, pa[pa.length - 1].getZ());
                    pa[1] = goFactory.createLocation3D(pt0[0], this.zeroLocation, pt0[2]);
                }
                pre3d.setOutline(null);
                pre3d.setPoints3D((Location3D[])pa);
                pre3d.setBackground(this.fillColor);
                this.dc.addPlane(pre3d, 2);
                i = 0;
                while (i < pa.length) {
                    pa[i].setZ(pa[i].getZ() - this.dTapeWidth);
                    ++i;
                }
                this.dc.addPlane(pre3d, 2);
                double[] pte = points.get(points.size() - 1);
                this.loa3d[0].set(pt0[0], this.zeroLocation, pt0[2]);
                this.loa3d[1].set(pt0[0], this.zeroLocation, pt0[2] - this.dTapeWidth);
                this.loa3d[2].set(pte[0], this.zeroLocation, pte[2] - this.dTapeWidth);
                this.loa3d[3].set(pte[0], this.zeroLocation, pte[2]);
                pre3d.setPoints3D(this.loa3d);
                this.dc.addPlane(pre3d, 2);
                if (!this.lia.isVisible() || points.size() <= 1) break block41;
                double[] ptp = points.get(0);
                int i5 = 1;
                while (i5 < points.size()) {
                    double[] pta = points.get(i5);
                    lre3d.setStart3D(ptp[0], ptp[1], ptp[2]);
                    lre3d.setEnd3D(pta[0], pta[1], pta[2]);
                    ptp = pta;
                    this.dc.addLine(lre3d);
                    ++i5;
                }
                break block41;
            }
            pa = new Location[points.size() + 2];
            int i = 0;
            while (i < points.size()) {
                double[] pt = points.get(i);
                pa[i] = goFactory.createLocation(pt[0], pt[1]);
                ++i;
            }
            if (this.cwa.isTransposed()) {
                pa[pa.length - 2] = goFactory.createLocation(this.zeroLocation, pa[pa.length - 3].getY());
                pa[pa.length - 1] = goFactory.createLocation(this.zeroLocation, pa[0].getY());
            } else {
                pa[pa.length - 2] = goFactory.createLocation(pa[pa.length - 3].getX(), this.zeroLocation);
                pa[pa.length - 1] = goFactory.createLocation(pa[0].getX(), this.zeroLocation);
            }
            pre.setOutline(null);
            pre.setPoints(pa);
            pre.setBackground(this.fillColor);
            if (this.bDeferred) {
                this.dc.addPlane(pre, 2);
            } else {
                ipr.fillPolygon(pre);
            }
            if (this.lia.isVisible()) {
                i = 0;
                while (i < points.size() - 1) {
                    lre.setStart(pa[i]);
                    lre.setEnd(pa[i + 1]);
                    if (this.bDeferred) {
                        this.dc.addLine(lre);
                    } else {
                        ipr.drawLine(lre);
                    }
                    ++i;
                }
            }
        }
    }

    private void renderCurve(IPrimitiveRenderer ipr, double fXOffset, double fYOffset) throws ChartException {
        double[] faKnotXY1 = new double[2];
        double[] faKnotXY2 = new double[2];
        if (!this.computeSpline(this.fa[0], faKnotXY1)) {
            return;
        }
        ArrayList<double[]> stateList = new ArrayList<double[]>();
        int i = 0;
        while (i < this.iNumberOfPoints - 1) {
            if (this.computeSpline(this.fa[i + 1], faKnotXY2)) {
                double fX = faKnotXY2[0] - faKnotXY1[0];
                double fY = faKnotXY2[1] - faKnotXY1[1];
                int iNumberOfDivisions = (int)(Math.sqrt(fX * fX + fY * fY) / 5.0) + 1;
                double[] faXY1 = new double[2];
                double[] faXY2 = new double[2];
                if (this.computeSpline(this.fa[i], faXY1)) {
                    int j = 0;
                    while (j < iNumberOfDivisions) {
                        double fT = this.fa[i] + (this.fa[i + 1] - this.fa[i]) * (double)(j + 1) / (double)iNumberOfDivisions;
                        if (this.computeSpline(fT, faXY2)) {
                            if (this.bShowAsTape) {
                                boolean drawLeftSide;
                                boolean bl = drawLeftSide = i == 0 && j == 0 && this.bRendering3D && this.bFillArea;
                                if (drawLeftSide) {
                                    this.plotPlane(ipr, faXY1[0] + fXOffset, faXY1[1] + fYOffset, faXY2[0] + fXOffset, faXY2[1] + fYOffset, this.bRendering3D ? this.faZ[i] : 0.0, this.bRendering3D ? this.faZ[i] : 0.0, true, true);
                                }
                                boolean drawRightSide = this.bFillArea && (!this.iRender.isRightToLeft() && i == this.iNumberOfPoints - 2 && j == iNumberOfDivisions - 1 || this.iRender.isRightToLeft() && i == 0 && j == 0);
                                this.plotPlane(ipr, faXY1[0] + fXOffset, faXY1[1] + fYOffset, faXY2[0] + fXOffset, faXY2[1] + fYOffset, this.bRendering3D ? this.faZ[i] : 0.0, this.bRendering3D ? this.faZ[i] : 0.0, drawRightSide, this.iRender.isRightToLeft());
                            }
                            if (!this.bFillArea) {
                                this.plotLine(ipr, faXY1[0] + fXOffset, faXY1[1] + fYOffset, faXY2[0] + fXOffset, faXY2[1] + fYOffset, this.bRendering3D ? this.faZ[i] : 0.0, this.bRendering3D ? this.faZ[i] : 0.0);
                            }
                            if (this.bRendering3D) {
                                stateList.add(new double[]{faXY1[0] + fXOffset, faXY1[1] + fYOffset, this.faZ[i]});
                                stateList.add(new double[]{faXY2[0] + fXOffset, faXY2[1] + fYOffset, this.faZ[i]});
                            } else {
                                stateList.add(new double[]{faXY1[0] + fXOffset, faXY1[1] + fYOffset});
                                stateList.add(new double[]{faXY2[0] + fXOffset, faXY2[1] + fYOffset});
                            }
                            faXY1[0] = faXY2[0];
                            faXY1[1] = faXY2[1];
                        }
                        ++j;
                    }
                    faKnotXY1[0] = faKnotXY2[0];
                    faKnotXY1[1] = faKnotXY2[1];
                }
            }
            ++i;
        }
        if (this.bFillArea) {
            this.plotArea(ipr, stateList);
        }
        if (this.bKeepState) {
            if (this.iRender instanceof AxesRenderer && ((AxesRenderer)this.iRender).isLastRuntimeSeriesInAxis()) {
                this.iRender.getRunTimeContext().putState("stacked_series_location_key", null);
            } else {
                this.iRender.getRunTimeContext().putState("stacked_series_location_key", stateList);
            }
        }
    }

    private static boolean computeSpline(double t, double[] faXY, Spline spx, Spline spy) {
        if (spx == null || spy == null) {
            return false;
        }
        faXY[0] = spx.computeValue(t);
        faXY[1] = spy.computeValue(t);
        return true;
    }

    public static List<double[]> generateCurvePoints(BaseRenderer _render, Location[] loPoints, boolean connectMissingValue, double fXOffset, double fYOffset) {
        double[] faKnotXY1 = new double[2];
        double[] faKnotXY2 = new double[2];
        int iNumberOfPoints = 0;
        double[] fa = null;
        Spline spX = null;
        Spline spY = null;
        if (!connectMissingValue) {
            i = 0;
            while (i < loPoints.length) {
                if (!Double.isNaN(loPoints[i].getX()) && !Double.isNaN(loPoints[i].getY())) {
                    ArrayList<Location> al = new ArrayList<Location>();
                    while (i < loPoints.length && !Double.isNaN(loPoints[i].getX()) && !Double.isNaN(loPoints[i].getY())) {
                        al.add(loPoints[i]);
                        ++i;
                    }
                    --i;
                    tempPoints = al.toArray(new Location[al.size()]);
                    faX = LocationImpl.getXArray(tempPoints);
                    faY = LocationImpl.getYArray(tempPoints);
                    iNumberOfPoints = faX.length;
                    if (iNumberOfPoints > 1) {
                        spX = new Spline(faX);
                        spY = new Spline(faY);
                        fa = new double[iNumberOfPoints];
                        int j = 0;
                        while (j < iNumberOfPoints) {
                            fa[j] = j;
                            ++j;
                        }
                    } else {
                        return null;
                    }
                }
                ++i;
            }
        } else {
            tempPoints = _render.filterNull(loPoints);
            faX = LocationImpl.getXArray(tempPoints);
            faY = LocationImpl.getYArray(tempPoints);
            iNumberOfPoints = faX.length;
            if (iNumberOfPoints <= 1) {
                return null;
            }
            spX = new Spline(faX);
            spY = new Spline(faY);
            fa = new double[iNumberOfPoints];
            i = 0;
            while (i < iNumberOfPoints) {
                fa[i] = i;
                ++i;
            }
        }
        if (!CurveRenderer.computeSpline((double)fa[0], faKnotXY1, spX, spY)) {
            return null;
        }
        ArrayList<double[]> stateList = new ArrayList<double[]>();
        int i = 0;
        while (i < iNumberOfPoints - 1) {
            if (CurveRenderer.computeSpline(fa[i + 1], faKnotXY2, spX, spY)) {
                double fX = faKnotXY2[0] - faKnotXY1[0];
                double fY = faKnotXY2[1] - faKnotXY1[1];
                int iNumberOfDivisions = (int)(Math.sqrt(fX * fX + fY * fY) / 5.0) + 1;
                double[] faXY1 = new double[2];
                double[] faXY2 = new double[2];
                if (CurveRenderer.computeSpline(fa[i], faXY1, spX, spY)) {
                    int j = 0;
                    while (j < iNumberOfDivisions) {
                        double fT = fa[i] + (fa[i + 1] - fa[i]) * (double)(j + 1) / (double)iNumberOfDivisions;
                        if (CurveRenderer.computeSpline(fT, faXY2, spX, spY)) {
                            stateList.add(new double[]{faXY1[0] + fXOffset, faXY1[1] + fYOffset});
                            stateList.add(new double[]{faXY2[0] + fXOffset, faXY2[1] + fYOffset});
                            faXY1[0] = faXY2[0];
                            faXY1[1] = faXY2[1];
                        }
                        ++j;
                    }
                    faKnotXY1[0] = faKnotXY2[0];
                    faKnotXY1[1] = faKnotXY2[1];
                }
            }
            ++i;
        }
        return stateList;
    }

    private static class Spline {
        private final int iNumberOfPoints;
        private final double[] fa;
        private final double[] faA;
        private final double[] faB;
        private final double[] faC;

        public Spline(double[] _fa) {
            this.iNumberOfPoints = _fa.length;
            this.fa = new double[this.iNumberOfPoints];
            this.faA = new double[this.iNumberOfPoints - 1];
            this.faB = new double[this.iNumberOfPoints - 1];
            this.faC = new double[this.iNumberOfPoints - 1];
            int i = 0;
            while (i < this.iNumberOfPoints) {
                this.fa[i] = _fa[i];
                ++i;
            }
            this.computeCoefficients();
        }

        private final void computeCoefficients() {
            double dy2;
            double dy1 = this.fa[1] - this.fa[0];
            int i = 1;
            while (i < this.iNumberOfPoints - 1) {
                dy2 = this.fa[i + 1] - this.fa[i];
                this.faC[i] = 0.5;
                this.faB[i] = 1.0 - this.faC[i];
                this.faA[i] = 3.0 * (dy2 - dy1);
                dy1 = dy2;
                ++i;
            }
            this.faC[0] = 0.0;
            this.faB[0] = 0.0;
            this.faA[0] = 0.0;
            i = 1;
            while (i < this.iNumberOfPoints - 1) {
                double p = this.faB[i] * this.faC[i - 1] + 2.0;
                this.faC[i] = -this.faC[i] / p;
                this.faB[i] = (this.faA[i] - this.faB[i] * this.faB[i - 1]) / p;
                ++i;
            }
            dy1 = 0.0;
            i = this.iNumberOfPoints - 2;
            while (i >= 0) {
                dy2 = this.faC[i] * dy1 + this.faB[i];
                this.faA[i] = (dy1 - dy2) / 6.0;
                this.faB[i] = dy2 / 2.0;
                this.faC[i] = this.fa[i + 1] - this.fa[i] - 1.0 * (this.faB[i] + this.faA[i]);
                dy1 = dy2;
                --i;
            }
        }

        private final double computeValue(double x) {
            if (this.iNumberOfPoints < 2) {
                return 0.0;
            }
            int i = 0;
            int iRight = this.iNumberOfPoints - 1;
            while (i + 1 < iRight) {
                int iMiddle = (i + iRight) / 2;
                if ((double)iMiddle <= x) {
                    i = iMiddle;
                    continue;
                }
                iRight = iMiddle;
            }
            double t = x - (double)i;
            return this.faA[i] * t * t * t + this.faB[i] * t * t + this.faC[i] * t + this.fa[i];
        }
    }
}

