/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.doc.internal;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.util.List;
import org.eclipse.acceleo.annotations.api.documentation.ServiceProvider;
import org.eclipse.acceleo.query.doc.internal.AQLHelpContentUtils;
import org.eclipse.acceleo.query.services.AnyServices;
import org.eclipse.acceleo.query.services.BooleanServices;
import org.eclipse.acceleo.query.services.CollectionServices;
import org.eclipse.acceleo.query.services.ComparableServices;
import org.eclipse.acceleo.query.services.EObjectServices;
import org.eclipse.acceleo.query.services.NumberServices;
import org.eclipse.acceleo.query.services.PromptServices;
import org.eclipse.acceleo.query.services.PropertiesServices;
import org.eclipse.acceleo.query.services.ResourceServices;
import org.eclipse.acceleo.query.services.StringServices;
import org.eclipse.acceleo.query.services.XPathServices;

public final class DocumentationGenerator {
    private static final String SERVICES_START_ASCIIDOC_TAG = "// SERVICES START";
    private static final String SERVICES_END_ASCIIDOC_TAG = "// SERVICES END";
    private static final String UTF8 = "UTF-8";
    private static final Class<?>[] STANDARD_SERVICE_PROVIDERS = new Class[]{AnyServices.class, BooleanServices.class, CollectionServices.class, ComparableServices.class, EObjectServices.class, NumberServices.class, PropertiesServices.class, ResourceServices.class, StringServices.class, XPathServices.class, PromptServices.class};

    private DocumentationGenerator() {
    }

    public static void main(String[] args) {
        File pluginFolder = new File(args[0]);
        System.out.println("Prepare the generation of the documentation for " + pluginFolder.getAbsolutePath());
        File pagesFolder = new File(pluginFolder, "pages");
        File indexAsciidocFile = new File(pagesFolder, "index.adoc");
        StringBuffer aggregated = new StringBuffer();
        Class<?>[] classArray = STANDARD_SERVICE_PROVIDERS;
        int n = STANDARD_SERVICE_PROVIDERS.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> serviceProviderClass = classArray[n2];
            if (serviceProviderClass.isAnnotationPresent(ServiceProvider.class)) {
                List<StringBuffer> sectionsForAggregatedServices = AQLHelpContentUtils.computeServiceSections(serviceProviderClass, AQLHelpContentUtils.METHOD_SIGNATURE_GENERATOR_2016);
                for (StringBuffer b : sectionsForAggregatedServices) {
                    aggregated.append(b);
                }
            }
            ++n2;
        }
        try {
            String inputAsciidocContent = DocumentationGenerator.read(indexAsciidocFile, Charset.forName(UTF8));
            StringBuffer buffer = new StringBuffer(inputAsciidocContent.length());
            int serviceSectionStartIndex = inputAsciidocContent.indexOf(SERVICES_START_ASCIIDOC_TAG) + SERVICES_START_ASCIIDOC_TAG.length();
            int serviceSectionEndIndex = inputAsciidocContent.indexOf(SERVICES_END_ASCIIDOC_TAG);
            buffer.append(inputAsciidocContent.substring(0, serviceSectionStartIndex));
            buffer.append(AQLHelpContentUtils.LS);
            buffer.append(AQLHelpContentUtils.LS);
            buffer.append(aggregated);
            buffer.append(inputAsciidocContent.substring(serviceSectionEndIndex, inputAsciidocContent.length()));
            String out = buffer.toString();
            System.out.println("Writing content of " + indexAsciidocFile.getAbsolutePath());
            DocumentationGenerator.write(out, indexAsciidocFile, Charset.forName(UTF8));
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
    }

    private static void write(String content, File file, Charset charset) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), charset);){
            writer.write(content);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static String read(File file, Charset charset) throws IOException {
        return new String(Files.readAllBytes(file.toPath()), charset);
    }
}

