/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.splitter;

import org.eclipse.mylyn.wikitext.parser.outline.OutlineItem;
import org.eclipse.mylyn.wikitext.parser.outline.OutlineParser;
import org.eclipse.mylyn.wikitext.splitter.SplitOutlineItem;
import org.eclipse.mylyn.wikitext.splitter.SplittingStrategy;

public class SplittingOutlineParser
extends OutlineParser {
    private SplittingStrategy splittingStrategy;

    @Override
    protected OutlineItem createOutlineItem(OutlineItem current, int level, String id, int offset, int length, String label) {
        if (this.splittingStrategy == null) {
            throw new IllegalStateException();
        }
        this.splittingStrategy.heading(level, id, label);
        SplitOutlineItem outlineItem = new SplitOutlineItem(current, level, id, offset, length, label);
        if (this.splittingStrategy.isSplit()) {
            outlineItem.setSplitTarget(this.splittingStrategy.getSplitTarget());
        }
        return outlineItem;
    }

    public SplittingStrategy getSplittingStrategy() {
        return this.splittingStrategy;
    }

    public void setSplittingStrategy(SplittingStrategy splittingStrategy) {
        this.splittingStrategy = splittingStrategy;
    }

    @Override
    public SplitOutlineItem parse(String markup) {
        SplitOutlineItem rootItem = (SplitOutlineItem)super.parse(markup);
        if (!rootItem.getChildren().isEmpty()) {
            SplitOutlineItem firstChild = (SplitOutlineItem)rootItem.getChildren().get(0);
            if (firstChild.getSplitTarget() == null || firstChild.getSplitTarget().equals(rootItem.getSplitTarget())) {
                rootItem.setLabel(firstChild.getLabel());
            } else {
                rootItem.setLabel("");
            }
        }
        return rootItem;
    }
}

