/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.aql.ide.ui.handlers;

import java.util.Collections;
import org.eclipse.acceleo.aql.ide.ui.AcceleoUIPlugin;
import org.eclipse.acceleo.aql.ls.services.workspace.command.DocumentRangeParams;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServers;
import org.eclipse.lsp4j.ExecuteCommandParams;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.texteditor.ITextEditor;

public abstract class DocumentRangeCommandHandler
extends AbstractHandler {
    protected Object execute(ExecutionEvent event, String lsCommand) throws ExecutionException {
        ITextSelection selection = (ITextSelection)HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        ITextEditor editorPart = (ITextEditor)HandlerUtil.getActiveEditor((ExecutionEvent)event);
        try {
            IDocument document = LSPEclipseUtils.getDocument((ITextEditor)editorPart);
            TextDocumentIdentifier textIdentifier = LSPEclipseUtils.toTextDocumentIdentifier((IDocument)document);
            Position startPosition = LSPEclipseUtils.toPosition((int)selection.getOffset(), (IDocument)document);
            Position endPosition = LSPEclipseUtils.toPosition((int)(selection.getOffset() + selection.getLength()), (IDocument)document);
            Range range = new Range(startPosition, endPosition);
            DocumentRangeParams documentRangeParams = new DocumentRangeParams(textIdentifier, range);
            LanguageServers.LanguageServerDocumentExecutor executor = LanguageServers.forDocument((IDocument)document);
            ExecuteCommandParams executionCommandParams = new ExecuteCommandParams(lsCommand, Collections.singletonList(documentRangeParams));
            executor.computeFirst(ls -> ls.getWorkspaceService().executeCommand(executionCommandParams));
        }
        catch (BadLocationException e) {
            AcceleoUIPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.acceleo.aql.ide.ui", "unable to run LS command " + lsCommand, (Throwable)e));
        }
        return null;
    }
}

