/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.sirius;

import java.util.Collections;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;

public final class AqlSiriusUtils {
    public static final String PLUGIN_ID = "org.eclipse.acceleo.query.sirius";
    public static final String SIRIUS_SESSION_OPTION = "SiriusSession";

    private AqlSiriusUtils() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Session getSession(Map<String, String> options, IProgressMonitor monitor) {
        String sessionURIStr = options.get(SIRIUS_SESSION_OPTION);
        if (sessionURIStr == null) return null;
        if (sessionURIStr.isEmpty()) return null;
        URI sessionURI = URI.createURI((String)sessionURIStr, (boolean)false);
        String baseURIStr = options.get("BaseURI");
        if (baseURIStr != null) {
            sessionURI = sessionURI.resolve(URI.createURI((String)baseURIStr));
        }
        if (!URIConverter.INSTANCE.exists(sessionURI, Collections.emptyMap())) throw new IllegalArgumentException("The Sirius session doesn't exist: " + String.valueOf(sessionURI));
        return SessionManager.INSTANCE.getSession(sessionURI, monitor);
    }
}

