/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.operations.typeHierarchy;

import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.LanguageServerWrapper;
import org.eclipse.lsp4e.LanguageServers;
import org.eclipse.lsp4e.LanguageServersRegistry;
import org.eclipse.lsp4e.internal.NullSafetyHelper;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.TypeHierarchyItem;
import org.eclipse.lsp4j.TypeHierarchyPrepareParams;
import org.eclipse.lsp4j.TypeHierarchySubtypesParams;
import org.eclipse.lsp4j.TypeHierarchySupertypesParams;
import org.eclipse.lsp4j.services.TextDocumentService;

public class TypeHierarchyContentProvider
implements ITreeContentProvider {
    private final LanguageServersRegistry.LanguageServerDefinition lsDefinition;
    private final IDocument document;
    private boolean showSuperTypes;
    private LanguageServerWrapper wrapper = (LanguageServerWrapper)NullSafetyHelper.lateNonNull();

    public TypeHierarchyContentProvider(LanguageServersRegistry.LanguageServerDefinition lsDefinition, IDocument document, boolean showSuperTypes) {
        this.lsDefinition = lsDefinition;
        this.document = document;
        this.showSuperTypes = showSuperTypes;
    }

    public Object[] getElements(@Nullable Object inputElement) {
        if (inputElement instanceof ITextSelection) {
            ITextSelection textSelection = (ITextSelection)inputElement;
            try {
                TextDocumentIdentifier identifier = LSPEclipseUtils.toTextDocumentIdentifier(this.document);
                if (identifier == null) {
                    return new Object[0];
                }
                Position position = LSPEclipseUtils.toPosition(textSelection.getOffset(), this.document);
                TypeHierarchyPrepareParams prepare = new TypeHierarchyPrepareParams(identifier, position);
                return (Object[])((CompletableFuture)((LanguageServers.LanguageServerDocumentExecutor)LanguageServers.forDocument(this.document).withPreferredServer(this.lsDefinition)).computeFirst((wrapper, ls) -> ls.getTextDocumentService().prepareTypeHierarchy(prepare).thenApply(items -> new AbstractMap.SimpleEntry<LanguageServerWrapper, List>((LanguageServerWrapper)wrapper, (List)items))).thenApply(entry -> {
                    this.wrapper = entry.map(Map.Entry::getKey).orElse(null);
                    return entry.map(Map.Entry::getValue).map(list -> list.toArray()).orElse(new Object[0]);
                })).get(500L, TimeUnit.MILLISECONDS);
            }
            catch (Exception e) {
                LanguageServerPlugin.logError(e);
            }
        }
        return new Object[0];
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof TypeHierarchyItem) {
            TypeHierarchyItem parentItem = (TypeHierarchyItem)parentElement;
            try {
                return (Object[])((CompletableFuture)this.wrapper.execute(ls -> {
                    TextDocumentService textDocumentService = ls.getTextDocumentService();
                    return this.showSuperTypes ? textDocumentService.typeHierarchySupertypes(new TypeHierarchySupertypesParams(parentItem)) : textDocumentService.typeHierarchySubtypes(new TypeHierarchySubtypesParams(parentItem));
                }).thenApply(list -> list == null ? new Object[]{} : list.toArray())).get(500L, TimeUnit.MILLISECONDS);
            }
            catch (Exception e) {
                LanguageServerPlugin.logError(e);
            }
        }
        return new Object[0];
    }

    public @Nullable Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        return true;
    }
}

