/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.aql.validation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.acceleo.AcceleoASTNode;
import org.eclipse.acceleo.Variable;
import org.eclipse.acceleo.aql.parser.AcceleoAstResult;
import org.eclipse.acceleo.aql.validation.IAcceleoValidationResult;
import org.eclipse.acceleo.query.ast.ASTNode;
import org.eclipse.acceleo.query.ast.Call;
import org.eclipse.acceleo.query.ast.Declaration;
import org.eclipse.acceleo.query.ast.Expression;
import org.eclipse.acceleo.query.ast.VarRef;
import org.eclipse.acceleo.query.parser.AstResult;
import org.eclipse.acceleo.query.runtime.IService;
import org.eclipse.acceleo.query.runtime.IValidationMessage;
import org.eclipse.acceleo.query.runtime.IValidationResult;
import org.eclipse.acceleo.query.validation.type.IType;

public class AcceleoValidationResult
implements IAcceleoValidationResult {
    private final AcceleoAstResult astResult;
    private final Map<AcceleoASTNode, List<IValidationMessage>> messages = new LinkedHashMap<AcceleoASTNode, List<IValidationMessage>>();
    private Map<AstResult, IValidationResult> aqlValidationResults = new LinkedHashMap<AstResult, IValidationResult>();
    private final Map<Variable, List<VarRef>> variableResolvedVarRef = new HashMap<Variable, List<VarRef>>();
    private final Map<VarRef, Variable> variableDeclarations = new HashMap<VarRef, Variable>();

    public AcceleoValidationResult(AcceleoAstResult astResult) {
        this.astResult = astResult;
    }

    @Override
    public AcceleoAstResult getAcceleoAstResult() {
        return this.astResult;
    }

    @Override
    public List<IValidationMessage> getValidationMessages() {
        return this.messages.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    @Override
    public List<IValidationMessage> getValidationMessages(ASTNode node) {
        ArrayList<IValidationMessage> res = new ArrayList<IValidationMessage>();
        if (node instanceof AcceleoASTNode) {
            res.addAll(this.messages.getOrDefault(node, new LinkedList()));
        } else {
            res.addAll(this.aqlValidationResults.values().stream().map(vr -> vr.getMessages(node)).flatMap(Collection::stream).collect(Collectors.toList()));
        }
        return res;
    }

    @Override
    public IValidationResult getValidationResult(AstResult aqlAst) {
        return this.aqlValidationResults.get(aqlAst);
    }

    void addMessage(AcceleoASTNode node, IValidationMessage newMessage) {
        this.messages.computeIfAbsent(node, key -> new LinkedList()).add(newMessage);
    }

    void addMessages(AcceleoASTNode node, Collection<IValidationMessage> newMessages) {
        this.messages.computeIfAbsent(node, key -> new LinkedList()).addAll(newMessages);
    }

    public Map<AstResult, IValidationResult> getAqlValidationResults() {
        return this.aqlValidationResults;
    }

    @Override
    public List<Call> getResolvedCalls(IService<?> service) {
        return this.aqlValidationResults.values().stream().map(vr -> vr.getResolvedCalls(service)).flatMap(Collection::stream).collect(Collectors.toList());
    }

    @Override
    public List<VarRef> getResolvedVarRef(Declaration declaration) {
        Optional<List> res = this.aqlValidationResults.values().stream().map(vr -> vr.getResolvedVarRef(declaration)).filter(db -> db != null).findFirst();
        return res.orElse(Collections.emptyList());
    }

    public void putBindingResolvedVarRef(Variable variable, VarRef varRef) {
        this.variableResolvedVarRef.computeIfAbsent(variable, s -> new ArrayList()).add(varRef);
        this.variableDeclarations.put(varRef, variable);
    }

    @Override
    public List<VarRef> getResolvedVarRef(Variable variable) {
        return this.variableResolvedVarRef.getOrDefault(variable, Collections.emptyList());
    }

    @Override
    public Declaration getDeclaration(VarRef varRef) {
        Optional<Declaration> res = this.aqlValidationResults.values().stream().map(vr -> vr.getDeclaration(varRef)).filter(db -> db != null).findFirst();
        return res.orElse(null);
    }

    @Override
    public List<IService<?>> getDeclarationIService(Call call) {
        Optional<List> res = this.aqlValidationResults.values().stream().map(vr -> vr.getDeclarationIService(call)).filter(db -> !db.isEmpty()).findFirst();
        return res.orElse(Collections.emptyList());
    }

    @Override
    public Variable getDeclarationVariable(VarRef varRef) {
        return this.variableDeclarations.get(varRef);
    }

    @Override
    public Set<IType> getPossibleTypes(Expression expression) {
        Optional<Set> res = this.aqlValidationResults.values().stream().map(vr -> vr.getPossibleTypes(expression)).filter(pt -> pt != null).findFirst();
        return res.orElse(null);
    }
}

