/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.value;

import java.text.MessageFormat;
import java.util.Scanner;
import java.util.regex.Pattern;
import org.eclipse.fordiac.ide.model.Messages;
import org.eclipse.fordiac.ide.model.value.ValueConverter;

public final class BoolValueConverter
implements ValueConverter<Boolean> {
    public static final BoolValueConverter INSTANCE = new BoolValueConverter();
    private static final String TRUE = "TRUE";
    private static final String FALSE = "FALSE";
    private static final Pattern SCANNER_PATTERN = Pattern.compile("\\G(?:TRUE|FALSE|0|1)", 2);

    private BoolValueConverter() {
    }

    @Override
    public Boolean toValue(String string) throws IllegalArgumentException {
        if (TRUE.equalsIgnoreCase(string) || "1".equals(string)) {
            return Boolean.TRUE;
        }
        if (FALSE.equalsIgnoreCase(string) || "0".equals(string)) {
            return Boolean.FALSE;
        }
        throw new IllegalArgumentException(MessageFormat.format(Messages.VALIDATOR_INVALID_BOOL_LITERAL, string));
    }

    @Override
    public Boolean toValue(Scanner scanner) throws IllegalArgumentException {
        return (Boolean)this.toValue(scanner, SCANNER_PATTERN);
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

