/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.export.forte_lua.st;

import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.export.ExportException;
import org.eclipse.fordiac.ide.export.forte_lua.st.StructuredTextSupport;
import org.eclipse.fordiac.ide.model.libraryElement.BaseFBType;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.FB;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.structuredtextalgorithm.stalgorithm.STMethod;
import org.eclipse.fordiac.ide.structuredtextalgorithm.util.StructuredTextParseUtil;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STCaseStatement;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STContinue;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STExit;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STExpression;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STForStatement;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STIfStatement;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STNop;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STRepeatStatement;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STReturn;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STStandardFunction;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STStatement;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STVarDeclaration;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STVarDeclarationBlock;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STVarInOutDeclarationBlock;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STVarInputDeclarationBlock;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STVarOutputDeclarationBlock;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STVarTempDeclarationBlock;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STWhileStatement;
import org.eclipse.fordiac.ide.structuredtextfunctioneditor.stfunction.STFunction;
import org.eclipse.xtend.lib.annotations.FinalFieldsConstructor;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.XbaseGenerated;

@FinalFieldsConstructor
public class STMethodSupport
extends StructuredTextSupport {
    private final org.eclipse.fordiac.ide.model.libraryElement.STMethod method;
    private STMethod parseResult;
    private CharSequence outReturn;

    public boolean prepare() {
        if (this.parseResult == null && this.getErrors().isEmpty()) {
            this.parseResult = StructuredTextParseUtil.parse((org.eclipse.fordiac.ide.model.libraryElement.STMethod)this.method, this.getErrors(), this.getWarnings(), this.getInfos());
        }
        return this.parseResult != null;
    }

    public CharSequence generate(Map<?, ?> options) throws ExportException {
        CharSequence _xblockexpression = null;
        this.prepare();
        CharSequence _generateStructuredTextMethod = null;
        if (this.parseResult != null) {
            _generateStructuredTextMethod = this.generateStructuredTextMethod(this.parseResult);
        }
        _xblockexpression = _generateStructuredTextMethod;
        return _xblockexpression;
    }

    private CharSequence generateStructuredTextMethod(STMethod method) {
        this.outReturn = this.generateOutReturn(method);
        EObject _rootContainer = EcoreUtil.getRootContainer((EObject)this.method);
        if (_rootContainer instanceof BaseFBType) {
            EObject _rootContainer_1 = EcoreUtil.getRootContainer((EObject)this.method);
            BaseFBType container = (BaseFBType)_rootContainer_1;
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("local function method_");
            String _name = method.getName();
            _builder.append(_name);
            _builder.append("(fb, ");
            CharSequence _generateStructuredTextMethodParameters = this.generateStructuredTextMethodParameters(method);
            _builder.append((Object)_generateStructuredTextMethodParameters);
            _builder.append(")");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("local ENV = {}");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("st_ret_val = nil");
            _builder.newLine();
            _builder.append("\t");
            CharSequence _generateFBVariablePrefix = this.generateFBVariablePrefix(container.getInterfaceList());
            _builder.append((Object)_generateFBVariablePrefix, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            CharSequence _generateInternalVariablePrefix = this.generateInternalVariablePrefix((Iterable<? extends VarDeclaration>)container.getInternalVars());
            _builder.append((Object)_generateInternalVariablePrefix, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            CharSequence _generateInParameterPrefix = this.generateInParameterPrefix(Iterables.filter((Iterable)method.getBody().getVarDeclarations(), STVarInputDeclarationBlock.class));
            _builder.append((Object)_generateInParameterPrefix, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            CharSequence _generateInParameterPrefix_1 = this.generateInParameterPrefix(Iterables.filter((Iterable)method.getBody().getVarDeclarations(), STVarInOutDeclarationBlock.class));
            _builder.append((Object)_generateInParameterPrefix_1, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            CharSequence _generateLocalVariables = this.generateLocalVariables(Iterables.filter((Iterable)method.getBody().getVarDeclarations(), STVarTempDeclarationBlock.class));
            _builder.append((Object)_generateLocalVariables, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.newLine();
            _builder.append("\t");
            CharSequence _generateStatementList = this.generateStatementList((List<STStatement>)method.getBody().getStatements());
            _builder.append((Object)_generateStatementList, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            CharSequence _generateInternalVariableSuffix = this.generateInternalVariableSuffix((Iterable<? extends VarDeclaration>)container.getInternalVars());
            _builder.append((Object)_generateInternalVariableSuffix, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            CharSequence _generateFBVariableSuffix = this.generateFBVariableSuffix(container.getInterfaceList());
            _builder.append((Object)_generateFBVariableSuffix, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("return st_ret_val");
            _builder.append((Object)this.outReturn, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append("end");
            _builder.newLine();
            return _builder;
        }
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("local function method_");
        String _name_1 = method.getName();
        _builder_1.append(_name_1);
        _builder_1.append("(fb, ");
        CharSequence _generateStructuredTextMethodParameters_1 = this.generateStructuredTextMethodParameters(method);
        _builder_1.append((Object)_generateStructuredTextMethodParameters_1);
        _builder_1.append(")");
        _builder_1.newLineIfNotEmpty();
        _builder_1.append("\t");
        _builder_1.append("local ENV = {}");
        _builder_1.newLine();
        _builder_1.append("\t");
        _builder_1.append("st_ret_val = nil");
        _builder_1.newLine();
        _builder_1.append("\t");
        CharSequence _generateInParameterPrefix_2 = this.generateInParameterPrefix(Iterables.filter((Iterable)method.getBody().getVarDeclarations(), STVarInputDeclarationBlock.class));
        _builder_1.append((Object)_generateInParameterPrefix_2, "\t");
        _builder_1.newLineIfNotEmpty();
        _builder_1.append("\t");
        CharSequence _generateInParameterPrefix_3 = this.generateInParameterPrefix(Iterables.filter((Iterable)method.getBody().getVarDeclarations(), STVarInOutDeclarationBlock.class));
        _builder_1.append((Object)_generateInParameterPrefix_3, "\t");
        _builder_1.newLineIfNotEmpty();
        _builder_1.append("\t");
        CharSequence _generateLocalVariables_1 = this.generateLocalVariables(Iterables.filter((Iterable)method.getBody().getVarDeclarations(), STVarTempDeclarationBlock.class));
        _builder_1.append((Object)_generateLocalVariables_1, "\t");
        _builder_1.newLineIfNotEmpty();
        _builder_1.append("\t");
        _builder_1.newLine();
        _builder_1.append("\t");
        CharSequence _generateStatementList_1 = this.generateStatementList((List<STStatement>)method.getBody().getStatements());
        _builder_1.append((Object)_generateStatementList_1, "\t");
        _builder_1.newLineIfNotEmpty();
        _builder_1.append("\t");
        _builder_1.newLine();
        _builder_1.append("\t");
        _builder_1.append("return st_ret_val");
        _builder_1.append((Object)this.outReturn, "\t");
        _builder_1.newLineIfNotEmpty();
        _builder_1.append("end");
        _builder_1.newLine();
        return _builder_1;
    }

    private CharSequence generateStructuredTextMethodParameters(STMethod method) {
        StringConcatenation _builder = new StringConcatenation();
        Iterable<STVarDeclaration> _structuredTextMethodParameters = this.getStructuredTextMethodParameters(method);
        boolean _hasElements = false;
        for (STVarDeclaration param : _structuredTextMethodParameters) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)", ", "");
            }
            _builder.append("par_");
            String _name = param.getName();
            _builder.append(_name);
        }
        return _builder;
    }

    private Iterable<STVarDeclaration> getStructuredTextMethodParameters(STMethod method) {
        Functions.Function1 _function = it -> it.getVarDeclarations();
        Iterable _flatMap = IterableExtensions.flatMap((Iterable)Iterables.filter((Iterable)method.getBody().getVarDeclarations(), STVarInputDeclarationBlock.class), (Functions.Function1)_function);
        Functions.Function1 _function_1 = it -> it.getVarDeclarations();
        Iterable _flatMap_1 = IterableExtensions.flatMap((Iterable)Iterables.filter((Iterable)method.getBody().getVarDeclarations(), STVarInOutDeclarationBlock.class), (Functions.Function1)_function_1);
        return Iterables.concat((Iterable)_flatMap, (Iterable)_flatMap_1);
    }

    private Iterable<STVarDeclaration> getStructuredTextOutParameters(STMethod method) {
        Functions.Function1 _function = it -> it.getVarDeclarations();
        Iterable _flatMap = IterableExtensions.flatMap((Iterable)Iterables.filter((Iterable)method.getBody().getVarDeclarations(), STVarInOutDeclarationBlock.class), (Functions.Function1)_function);
        Functions.Function1 _function_1 = it -> it.getVarDeclarations();
        Iterable _flatMap_1 = IterableExtensions.flatMap((Iterable)Iterables.filter((Iterable)method.getBody().getVarDeclarations(), STVarOutputDeclarationBlock.class), (Functions.Function1)_function_1);
        return Iterables.concat((Iterable)_flatMap, (Iterable)_flatMap_1);
    }

    protected CharSequence generateInParameterPrefix(Iterable<? extends STVarDeclarationBlock> blocks) {
        StringConcatenation _builder = new StringConcatenation();
        for (STVarDeclarationBlock sTVarDeclarationBlock : blocks) {
            CharSequence _generateInParameterBlock = this.generateInParameterBlock(sTVarDeclarationBlock);
            _builder.append((Object)_generateInParameterBlock);
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    protected CharSequence generateInParameterBlock(STVarDeclarationBlock block) {
        StringConcatenation _builder = new StringConcatenation();
        Iterable _filter = Iterables.filter((Iterable)block.getVarDeclarations(), STVarDeclaration.class);
        for (STVarDeclaration variable : _filter) {
            CharSequence _generateInParameter = this.generateInParameter(variable);
            _builder.append((Object)_generateInParameter);
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    protected CharSequence generateInParameter(STVarDeclaration variable) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("ENV.st_lv_");
        String _name = variable.getName();
        _builder.append(_name);
        _builder.append(" = par_");
        String _name_1 = variable.getName();
        _builder.append(_name_1);
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    protected CharSequence generateOutParameterSuffix(Iterable<? extends STVarDeclarationBlock> blocks) {
        StringConcatenation _builder = new StringConcatenation();
        for (STVarDeclarationBlock sTVarDeclarationBlock : blocks) {
            CharSequence _generateOutParameterBlock = this.generateOutParameterBlock(sTVarDeclarationBlock);
            _builder.append((Object)_generateOutParameterBlock);
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    protected CharSequence generateOutParameterBlock(STVarDeclarationBlock block) {
        StringConcatenation _builder = new StringConcatenation();
        Iterable _filter = Iterables.filter((Iterable)block.getVarDeclarations(), STVarDeclaration.class);
        for (STVarDeclaration variable : _filter) {
            CharSequence _generateOutParameter = this.generateOutParameter(variable);
            _builder.append((Object)_generateOutParameter);
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    protected CharSequence generateOutParameter(STVarDeclaration variable) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("par_");
        String _name = variable.getName();
        _builder.append(_name);
        _builder.append(" = ENV.st_lv_");
        String _name_1 = variable.getName();
        _builder.append(_name_1);
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    @Override
    protected CharSequence _generateFeatureName(STMethod feature, boolean call) {
        if (call) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("method_");
            String _name = feature.getName();
            _builder.append(_name);
            return _builder;
        }
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("st_ret_val");
        return _builder_1;
    }

    @Override
    protected CharSequence _generateStatement(STReturn stmt) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("return st_ret_val");
        _builder.append((Object)this.outReturn);
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    private CharSequence generateOutReturn(STMethod method) {
        StringConcatenation _builder = new StringConcatenation();
        Iterable<STVarDeclaration> _structuredTextOutParameters = this.getStructuredTextOutParameters(method);
        boolean _hasElements = false;
        for (STVarDeclaration param : _structuredTextOutParameters) {
            if (!_hasElements) {
                _hasElements = true;
                _builder.append(", ");
            } else {
                _builder.appendImmediate((Object)", ", "");
            }
            CharSequence _generateFeatureName = this.generateFeatureName((INamedElement)param, false);
            _builder.append((Object)_generateFeatureName);
        }
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public Set<INamedElement> getDependencies(Map<?, ?> options) {
        Set<INamedElement> _xblockexpression = null;
        this.prepare();
        Set<INamedElement> _xifexpression = null;
        _xifexpression = this.parseResult != null ? this.getContainedDependencies((EObject)this.parseResult) : CollectionLiterals.emptySet();
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    @Override
    @XbaseGenerated
    protected CharSequence generateFeatureName(INamedElement feature, boolean call) {
        if (feature instanceof FB) {
            return this._generateFeatureName((FB)feature, call);
        }
        if (feature instanceof Event) {
            return this._generateFeatureName((Event)feature, call);
        }
        if (feature instanceof VarDeclaration) {
            return this._generateFeatureName((VarDeclaration)feature, call);
        }
        if (feature instanceof STMethod) {
            return this._generateFeatureName((STMethod)feature, call);
        }
        if (feature instanceof STStandardFunction) {
            return this._generateFeatureName((STStandardFunction)feature, call);
        }
        if (feature instanceof STVarDeclaration) {
            return this._generateFeatureName((STVarDeclaration)feature, call);
        }
        if (feature instanceof STFunction) {
            return this._generateFeatureName((STFunction)feature, call);
        }
        if (feature != null) {
            return this._generateFeatureName(feature, call);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(feature, call).toString());
    }

    @Override
    @XbaseGenerated
    protected CharSequence generateStatement(STStatement stmt) {
        if (stmt instanceof STCaseStatement) {
            return this._generateStatement((STCaseStatement)stmt);
        }
        if (stmt instanceof STContinue) {
            return this._generateStatement((STContinue)stmt);
        }
        if (stmt instanceof STExit) {
            return this._generateStatement((STExit)stmt);
        }
        if (stmt instanceof STExpression) {
            return this._generateStatement((STExpression)stmt);
        }
        if (stmt instanceof STForStatement) {
            return this._generateStatement((STForStatement)stmt);
        }
        if (stmt instanceof STIfStatement) {
            return this._generateStatement((STIfStatement)stmt);
        }
        if (stmt instanceof STNop) {
            return this._generateStatement((STNop)stmt);
        }
        if (stmt instanceof STRepeatStatement) {
            return this._generateStatement((STRepeatStatement)stmt);
        }
        if (stmt instanceof STReturn) {
            return this._generateStatement((STReturn)stmt);
        }
        if (stmt instanceof STWhileStatement) {
            return this._generateStatement((STWhileStatement)stmt);
        }
        if (stmt != null) {
            return this._generateStatement(stmt);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(stmt).toString());
    }

    public STMethodSupport(org.eclipse.fordiac.ide.model.libraryElement.STMethod method) {
        this.method = method;
    }
}

