/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.deployment.debug.ui;

import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.fordiac.ide.deployment.debug.DeploymentLaunchConfigurationAttributes;
import org.eclipse.fordiac.ide.deployment.debug.ui.Messages;
import org.eclipse.fordiac.ide.model.libraryElement.AutomationSystem;
import org.eclipse.fordiac.ide.model.libraryElement.Device;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.Resource;
import org.eclipse.fordiac.ide.model.typelibrary.SystemEntry;
import org.eclipse.fordiac.ide.model.typelibrary.TypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibraryManager;
import org.eclipse.fordiac.ide.ui.FordiacLogHelper;
import org.eclipse.fordiac.ide.ui.imageprovider.FordiacImage;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class DeploymentLaunchConfigurationTab
extends AbstractLaunchConfigurationTab {
    public static final String ID = "org.eclipse.fordiac.ide.deployment.debug.ui.deployTab";
    private Text systemText;
    private CheckboxTreeViewer selectionTree;
    private Text pollingIntervalText;
    private Combo allowTerminateCombo;

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        GridLayoutFactory.swtDefaults().applyTo(comp);
        this.setControl((Control)comp);
        Composite selectionComponent = this.createSelectionComponent(comp);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)selectionComponent);
        Composite optionsComponent = this.createOptionsComponent(comp);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)optionsComponent);
    }

    protected Composite createSelectionComponent(Composite parent) {
        Group group = new Group(parent, 2048);
        GridLayoutFactory.swtDefaults().applyTo((Composite)group);
        group.setText(Messages.DeploymentLaunchConfigurationTab_SelectionLabel);
        Composite comp = new Composite((Composite)group, 0);
        GridLayoutFactory.swtDefaults().numColumns(3).applyTo(comp);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)comp);
        Label systemLabel = new Label(comp, 0);
        systemLabel.setText(Messages.DeploymentLaunchConfigurationTab_SystemLabel);
        GridDataFactory.swtDefaults().applyTo((Control)systemLabel);
        this.systemText = new Text(comp, 2048);
        this.systemText.setEnabled(false);
        this.systemText.setMessage(Messages.DeploymentLaunchConfigurationTab_SystemMessage);
        this.systemText.addModifyListener(e -> this.scheduleUpdateJob());
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.systemText);
        Button systemButton = new Button(comp, 2048);
        systemButton.setText(Messages.DeploymentLaunchConfigurationTab_BrowseLabel);
        systemButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.handleSystemButtonSelected()));
        GridDataFactory.swtDefaults().applyTo((Control)systemButton);
        this.selectionTree = new CheckboxTreeViewer(comp, 68354);
        this.selectionTree.setContentProvider((IContentProvider)new SelectionContentProvider());
        this.selectionTree.setLabelProvider((IBaseLabelProvider)new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new SelectionLabelProvider()));
        this.selectionTree.addCheckStateListener((ICheckStateListener)new SelectionCheckStateListener());
        this.selectionTree.setAutoExpandLevel(2);
        GridDataFactory.fillDefaults().span(3, 1).grab(true, true).applyTo((Control)this.selectionTree.getTree());
        return group;
    }

    private void handleSystemButtonSelected() {
        Object object;
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        IResource initialResource = this.getSystemResource();
        if (initialResource != null) {
            dialog.setInitialSelection((Object)initialResource);
        }
        dialog.setAllowMultiple(false);
        dialog.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                IResource resource = (IResource)Adapters.adapt((Object)element, IResource.class);
                try {
                    return DeploymentLaunchConfigurationTab.this.filterTargetResource(resource);
                }
                catch (CoreException e) {
                    return false;
                }
            }
        });
        dialog.open();
        Object[] result = dialog.getResult();
        if (result != null && result.length > 0 && (object = result[0]) instanceof IResource) {
            IResource resource = (IResource)object;
            String resourceString = resource.getFullPath().toString();
            this.systemText.setText(resourceString);
            this.handleSystemUpdated();
        }
    }

    private Composite createOptionsComponent(Composite parent) {
        Group group = new Group(parent, 2048);
        GridLayoutFactory.swtDefaults().applyTo((Composite)group);
        group.setText(Messages.DeploymentLaunchConfigurationTab_OptionsLabel);
        Composite comp = new Composite((Composite)group, 0);
        GridLayoutFactory.swtDefaults().numColumns(3).applyTo(comp);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)comp);
        Label pollingIntervalLabel = new Label(comp, 0);
        pollingIntervalLabel.setText(Messages.DeploymentLaunchConfigurationTab_PollingIntervalLabel);
        GridDataFactory.swtDefaults().applyTo((Control)pollingIntervalLabel);
        this.pollingIntervalText = new Text(comp, 2048);
        this.pollingIntervalText.setMessage(Messages.DeploymentLaunchConfigurationTab_PollingIntervalMessage);
        this.pollingIntervalText.addModifyListener(e -> this.scheduleUpdateJob());
        GridDataFactory.fillDefaults().grab(false, false).applyTo((Control)this.pollingIntervalText);
        Label pollingIntervalUnitLabel = new Label(comp, 0);
        pollingIntervalUnitLabel.setText(Messages.DeploymentLaunchConfigurationTab_PollingIntervalUnitLabel);
        GridDataFactory.swtDefaults().applyTo((Control)pollingIntervalUnitLabel);
        Label allowTerminateLabel = new Label(comp, 0);
        allowTerminateLabel.setText(Messages.DeploymentLaunchConfigurationTab_AllowTerminateLabel);
        GridDataFactory.swtDefaults().applyTo((Control)allowTerminateLabel);
        this.allowTerminateCombo = new Combo(comp, 12);
        DeploymentLaunchConfigurationAttributes.AllowTerminate[] allowTerminateArray = DeploymentLaunchConfigurationAttributes.AllowTerminate.values();
        int n = allowTerminateArray.length;
        int n2 = 0;
        while (n2 < n) {
            DeploymentLaunchConfigurationAttributes.AllowTerminate value = allowTerminateArray[n2];
            this.allowTerminateCombo.add(value.getDisplayString());
            ++n2;
        }
        this.allowTerminateCombo.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.scheduleUpdateJob()));
        GridDataFactory.swtDefaults().span(2, 1).applyTo((Control)this.allowTerminateCombo);
        return group;
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.removeAttribute("org.eclipse.fordiac.ide.deployment.debug.system");
        configuration.removeAttribute("org.eclipse.fordiac.ide.deployment.debug.selection");
        configuration.removeAttribute("org.eclipse.fordiac.ide.deployment.debug.pollingInterval");
        configuration.removeAttribute("org.eclipse.fordiac.ide.deployment.debug.allowTerminate");
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            this.systemText.setText(configuration.getAttribute("org.eclipse.fordiac.ide.deployment.debug.system", ""));
            AutomationSystem system = DeploymentLaunchConfigurationAttributes.getSystem((ILaunchConfiguration)configuration);
            this.selectionTree.setInput((Object)system);
            this.selectionTree.setCheckedElements(DeploymentLaunchConfigurationAttributes.getSelection((ILaunchConfiguration)configuration, (AutomationSystem)system).toArray());
            this.pollingIntervalText.setText(Integer.toString(configuration.getAttribute("org.eclipse.fordiac.ide.deployment.debug.pollingInterval", 300)));
            this.allowTerminateCombo.select(DeploymentLaunchConfigurationAttributes.getAllowTerminate((ILaunchConfiguration)configuration).ordinal());
        }
        catch (CoreException e) {
            FordiacLogHelper.logWarning((String)e.getMessage(), (Exception)((Object)e));
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.eclipse.fordiac.ide.deployment.debug.system", this.systemText.getText());
        configuration.setAttribute("org.eclipse.fordiac.ide.deployment.debug.selection", Stream.of(this.selectionTree.getCheckedElements()).filter(INamedElement.class::isInstance).map(INamedElement.class::cast).map(INamedElement::getQualifiedName).collect(Collectors.toSet()));
        try {
            configuration.setAttribute("org.eclipse.fordiac.ide.deployment.debug.pollingInterval", Integer.parseInt(this.pollingIntervalText.getText()));
        }
        catch (NumberFormatException e) {
            configuration.removeAttribute("org.eclipse.fordiac.ide.deployment.debug.pollingInterval");
        }
        if (this.allowTerminateCombo.getSelectionIndex() >= 0) {
            configuration.setAttribute("org.eclipse.fordiac.ide.deployment.debug.allowTerminate", DeploymentLaunchConfigurationAttributes.AllowTerminate.values()[this.allowTerminateCombo.getSelectionIndex()].name());
        } else {
            configuration.removeAttribute("org.eclipse.fordiac.ide.deployment.debug.allowTerminate");
        }
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        try {
            if (Integer.parseInt(this.pollingIntervalText.getText()) <= 0) {
                this.setErrorMessage(Messages.DeploymentLaunchConfigurationTab_NegativePollingIntervalError);
                return false;
            }
        }
        catch (IllegalArgumentException e) {
            this.setErrorMessage(Messages.DeploymentLaunchConfigurationTab_InvalidPollingIntervalError);
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    protected void handleSystemUpdated() {
        this.updateLaunchConfigurationDialog();
        AutomationSystem system = this.getSystem();
        this.selectionTree.setInput((Object)system);
        system.getSystemConfiguration().getDevices().forEach(device -> {
            boolean bl = this.selectionTree.setSubtreeChecked(device, true);
        });
    }

    protected boolean filterTargetResource(IResource resource) throws CoreException {
        if (resource instanceof IFile) {
            IFile file = (IFile)resource;
            return "SYS".equalsIgnoreCase(file.getFileExtension());
        }
        if (resource instanceof IContainer) {
            IContainer container = (IContainer)resource;
            IResource[] iResourceArray = container.members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource child = iResourceArray[n2];
                if (this.filterTargetResource(child)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
        return true;
    }

    public String getName() {
        return Messages.DeploymentLaunchConfigurationTab_Name;
    }

    public String getId() {
        return ID;
    }

    public AutomationSystem getSystem() {
        IFile systemFile;
        TypeEntry typeEntry;
        IResource iResource = this.getSystemResource();
        if (iResource instanceof IFile && (typeEntry = TypeLibraryManager.INSTANCE.getTypeEntryForFile(systemFile = (IFile)iResource)) instanceof SystemEntry) {
            SystemEntry systemEntry = (SystemEntry)typeEntry;
            return systemEntry.getSystem();
        }
        return null;
    }

    public IResource getSystemResource() {
        String systemString = this.systemText.getText();
        if (systemString != null && !systemString.isEmpty()) {
            return ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(systemString));
        }
        return null;
    }

    private class SelectionCheckStateListener
    implements ICheckStateListener {
        private SelectionCheckStateListener() {
        }

        public void checkStateChanged(CheckStateChangedEvent event) {
            Object element = event.getElement();
            DeploymentLaunchConfigurationTab.this.selectionTree.setSubtreeChecked(element, event.getChecked());
            if (element instanceof Resource) {
                Resource resource = (Resource)element;
                if (!event.getChecked()) {
                    DeploymentLaunchConfigurationTab.this.selectionTree.setChecked((Object)resource.eContainer(), false);
                }
            }
            DeploymentLaunchConfigurationTab.this.updateLaunchConfigurationDialog();
        }
    }

    public static class SelectionContentProvider
    implements ITreeContentProvider {
        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof AutomationSystem) {
                AutomationSystem system = (AutomationSystem)inputElement;
                return system.getSystemConfiguration().getDevices().toArray();
            }
            return new Object[0];
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof Device) {
                Device device = (Device)parentElement;
                return device.getResource().toArray();
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            if (element instanceof Resource) {
                Resource resource = (Resource)element;
                return resource.eContainer();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            Device device;
            return element instanceof Device && !(device = (Device)element).getResource().isEmpty();
        }
    }

    private static class SelectionLabelProvider
    extends LabelProvider
    implements DelegatingStyledCellLabelProvider.IStyledLabelProvider {
        private static final StyledString.Styler ERROR_STYLER = new StyledString.Styler(){

            public void applyStyles(TextStyle textStyle) {
                textStyle.strikeout = true;
            }
        };

        private SelectionLabelProvider() {
        }

        public StyledString getStyledText(Object element) {
            if (element instanceof INamedElement) {
                INamedElement namedElement = (INamedElement)element;
                return new StyledString(namedElement.getName(), (StyledString.Styler)(namedElement.eResource() == null ? ERROR_STYLER : null));
            }
            return null;
        }

        public Image getImage(Object element) {
            if (element instanceof Device) {
                return FordiacImage.ICON_DEVICE.getImage();
            }
            if (element instanceof Resource) {
                Resource resource = (Resource)element;
                if (resource.isDeviceTypeResource()) {
                    return FordiacImage.ICON_FIRMWARE_RESOURCE.getImage();
                }
                return FordiacImage.ICON_RESOURCE.getImage();
            }
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_ELEMENTS");
        }
    }
}

