/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.debug;

import java.time.Clock;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;
import org.eclipse.fordiac.ide.debug.EvaluatorDebugTarget;
import org.eclipse.fordiac.ide.debug.EvaluatorProcess;
import org.eclipse.fordiac.ide.debug.LaunchConfigurationAttributes;
import org.eclipse.fordiac.ide.model.eval.Evaluator;

public abstract class CommonLaunchConfigurationDelegate
extends LaunchConfigurationDelegate {
    protected void launch(Evaluator evaluator, ILaunchConfiguration configuration, String mode, ILaunch launch, IResource resource, IProgressMonitor monitor) throws CoreException {
        this.launch(evaluator, null, null, configuration, mode, launch, resource, monitor);
    }

    protected void launch(Evaluator evaluator, Clock realtimeClock, Clock monotonicClock, ILaunchConfiguration configuration, String mode, ILaunch launch, IResource resource, IProgressMonitor monitor) throws CoreException {
        if ("run".equals(mode)) {
            EvaluatorProcess process = new EvaluatorProcess(configuration.getName(), evaluator, launch);
            process.getExecutor().setRealtimeClock(realtimeClock);
            process.getExecutor().setMonotonicClock(monotonicClock);
            process.start();
        } else if ("debug".equals(mode)) {
            EvaluatorDebugTarget debugTarget = new EvaluatorDebugTarget(configuration.getName(), evaluator, launch, resource);
            debugTarget.getProcess().getExecutor().setRealtimeClock(realtimeClock);
            debugTarget.getProcess().getExecutor().setMonotonicClock(monotonicClock);
            if (LaunchConfigurationAttributes.isStopOnFirstLine(configuration)) {
                debugTarget.getDebugger().setSuspendOnFirstLine(true);
            }
            debugTarget.start();
        } else {
            throw new CoreException(Status.error((String)("Illegal launch mode: " + mode)));
        }
    }

    protected IProject[] getBuildOrder(ILaunchConfiguration configuration, String mode) throws CoreException {
        IProject project;
        IResource resource = LaunchConfigurationAttributes.getResource(configuration);
        if (resource != null && (project = resource.getProject()) != null) {
            return this.computeReferencedBuildOrder(new IProject[]{project});
        }
        return super.getBuildOrder(configuration, mode);
    }

    protected IProject[] getProjectsForProblemSearch(ILaunchConfiguration configuration, String mode) throws CoreException {
        return this.getBuildOrder(configuration, mode);
    }
}

