/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.value;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.MessageFormat;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.fordiac.ide.model.Messages;
import org.eclipse.fordiac.ide.model.data.AnyBitType;
import org.eclipse.fordiac.ide.model.data.AnyDateType;
import org.eclipse.fordiac.ide.model.data.AnyDurationType;
import org.eclipse.fordiac.ide.model.data.AnyNumType;
import org.eclipse.fordiac.ide.model.data.BoolType;
import org.eclipse.fordiac.ide.model.data.ByteType;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.data.DateAndTimeType;
import org.eclipse.fordiac.ide.model.data.DateType;
import org.eclipse.fordiac.ide.model.data.DintType;
import org.eclipse.fordiac.ide.model.data.DwordType;
import org.eclipse.fordiac.ide.model.data.IntType;
import org.eclipse.fordiac.ide.model.data.LdateType;
import org.eclipse.fordiac.ide.model.data.LdtType;
import org.eclipse.fordiac.ide.model.data.LintType;
import org.eclipse.fordiac.ide.model.data.LrealType;
import org.eclipse.fordiac.ide.model.data.LtimeType;
import org.eclipse.fordiac.ide.model.data.LtodType;
import org.eclipse.fordiac.ide.model.data.LwordType;
import org.eclipse.fordiac.ide.model.data.RealType;
import org.eclipse.fordiac.ide.model.data.SintType;
import org.eclipse.fordiac.ide.model.data.TimeOfDayType;
import org.eclipse.fordiac.ide.model.data.TimeType;
import org.eclipse.fordiac.ide.model.data.UdintType;
import org.eclipse.fordiac.ide.model.data.UintType;
import org.eclipse.fordiac.ide.model.data.UlintType;
import org.eclipse.fordiac.ide.model.data.UsintType;
import org.eclipse.fordiac.ide.model.data.WordType;
import org.eclipse.fordiac.ide.model.datatype.helper.IecTypes;
import org.eclipse.fordiac.ide.model.helpers.PackageNameHelper;
import org.eclipse.fordiac.ide.model.typelibrary.DataTypeLibrary;
import org.eclipse.fordiac.ide.model.value.TypedValue;
import org.eclipse.fordiac.ide.model.value.ValueConverter;
import org.eclipse.fordiac.ide.model.value.ValueConverterFactory;

public final class TypedValueConverter
implements ValueConverter<Object> {
    public static final TypedValueConverter INSTANCE_TIME = new TypedValueConverter(IecTypes.ElementaryTypes.TIME);
    public static final TypedValueConverter INSTANCE_LTIME = new TypedValueConverter(IecTypes.ElementaryTypes.LTIME);
    public static final TypedValueConverter INSTANCE_DATE = new TypedValueConverter(IecTypes.ElementaryTypes.DATE);
    public static final TypedValueConverter INSTANCE_LDATE = new TypedValueConverter(IecTypes.ElementaryTypes.LDATE);
    public static final TypedValueConverter INSTANCE_TIME_OF_DAY = new TypedValueConverter(IecTypes.ElementaryTypes.TIME_OF_DAY);
    public static final TypedValueConverter INSTANCE_LTIME_OF_DAY = new TypedValueConverter(IecTypes.ElementaryTypes.LTIME_OF_DAY);
    public static final TypedValueConverter INSTANCE_DATE_AND_TIME = new TypedValueConverter(IecTypes.ElementaryTypes.DATE_AND_TIME);
    public static final TypedValueConverter INSTANCE_LDATE_AND_TIME = new TypedValueConverter(IecTypes.ElementaryTypes.LDATE_AND_TIME);
    private static final String TYPE_PREFIX_FORMAT = "%s#%s";
    private static final Pattern TYPE_PREFIX_PATTERN = Pattern.compile("\\G([_a-zA-Z][a-zA-Z_0-9:]*+)#");
    private static final String TIME_SHORT_FORM = "T";
    private static final String LTIME_SHORT_FORM = "LT";
    private static final String DATE_SHORT_FORM = "D";
    private static final String LDATE_SHORT_FORM = "LD";
    private static final String TIME_OF_DAY_SHORT_FORM = "TOD";
    private static final String LTIME_OF_DAY_SHORT_FORM = "LTOD";
    private static final String DATE_AND_TIME_SHORT_FORM = "DT";
    private static final String LDATE_AND_TIME_SHORT_FORM = "LDT";
    private static final Map<String, DataType> SHORT_FORM_TRANSLATIONS = Map.of("T", IecTypes.ElementaryTypes.TIME, "LT", IecTypes.ElementaryTypes.LTIME, "D", IecTypes.ElementaryTypes.DATE, "LD", IecTypes.ElementaryTypes.LDATE, "TOD", IecTypes.ElementaryTypes.TIME_OF_DAY, "LTOD", IecTypes.ElementaryTypes.LTIME_OF_DAY, "DT", IecTypes.ElementaryTypes.DATE_AND_TIME, "LDT", IecTypes.ElementaryTypes.LDATE_AND_TIME);
    private final DataType type;
    private final DataTypeLibrary typeLibrary;
    private final boolean strict;

    public TypedValueConverter(DataType type) {
        this(type, null, false);
    }

    public TypedValueConverter(DataType type, boolean strict) {
        this(type, null, strict);
    }

    public TypedValueConverter(DataType type, DataTypeLibrary typeLibrary) {
        this(type, typeLibrary, false);
    }

    public TypedValueConverter(DataType type, DataTypeLibrary typeLibrary, boolean strict) {
        this.type = type;
        this.typeLibrary = typeLibrary;
        this.strict = strict;
    }

    @Override
    public Object toValue(String string) throws IllegalArgumentException {
        return this.toTypedValue(string).value();
    }

    public TypedValue toTypedValue(String string) throws IllegalArgumentException {
        String value = string;
        DataType valueType = this.type;
        Matcher matcher = TYPE_PREFIX_PATTERN.matcher(string);
        if (matcher.lookingAt()) {
            valueType = this.getTypeFromPrefix(matcher.group(1));
            if (!this.type.isAssignableFrom(valueType)) {
                throw new IllegalArgumentException(MessageFormat.format(Messages.VALIDATOR_LITERAL_TYPE_INCOMPATIBLE_WITH_INPUT_TYPE, valueType.getName(), this.type.getName()));
            }
            value = string.substring(matcher.end());
        } else if (TypedValueConverter.isTypePrefixRequired(this.type)) {
            throw new IllegalArgumentException(MessageFormat.format(Messages.VALIDATOR_DatatypeRequiresTypeSpecifier, this.type.getName()));
        }
        ValueConverter<?> delegate = TypedValueConverter.getValueConverter(valueType);
        return new TypedValue(valueType, TypedValueConverter.checkValue(valueType, string, delegate.toValue(value), this.strict));
    }

    @Override
    public Object toValue(Scanner scanner) throws IllegalArgumentException, NoSuchElementException, IllegalStateException {
        return this.toTypedValue(scanner).value();
    }

    public TypedValue toTypedValue(Scanner scanner) throws IllegalArgumentException, NoSuchElementException, IllegalStateException {
        DataType valueType = this.type;
        if (scanner.findWithinHorizon(TYPE_PREFIX_PATTERN, 0) != null) {
            valueType = this.getTypeFromPrefix(scanner.match().group(1));
            if (!this.type.isAssignableFrom(valueType)) {
                throw new IllegalArgumentException(MessageFormat.format(Messages.VALIDATOR_LITERAL_TYPE_INCOMPATIBLE_WITH_INPUT_TYPE, valueType.getName(), this.type.getName()));
            }
        } else if (TypedValueConverter.isTypePrefixRequired(this.type)) {
            throw new IllegalArgumentException(MessageFormat.format(Messages.VALIDATOR_DatatypeRequiresTypeSpecifier, this.type.getName()));
        }
        ValueConverter<?> delegate = TypedValueConverter.getValueConverter(valueType);
        return new TypedValue(valueType, TypedValueConverter.checkValue(valueType, "<scanner>", delegate.toValue(scanner), this.strict));
    }

    @Override
    public String toString(Object value) {
        ValueConverter<?> delegate = TypedValueConverter.getValueConverter(this.type);
        String result = delegate.toString(value);
        String prefix = TypedValueConverter.getPrefixFromType(this.type);
        if (!prefix.isEmpty()) {
            return String.format(TYPE_PREFIX_FORMAT, prefix, result);
        }
        return result;
    }

    private DataType getTypeFromPrefix(String prefix) throws IllegalArgumentException {
        DataType result = SHORT_FORM_TRANSLATIONS.get(prefix);
        if (result == null) {
            result = IecTypes.ElementaryTypes.getTypeByName(prefix);
        }
        if (result == null && PackageNameHelper.getFullTypeName(this.type).equalsIgnoreCase(prefix)) {
            result = this.type;
        }
        if (result == null && this.typeLibrary != null) {
            result = this.typeLibrary.getTypeIfExists(prefix);
        }
        if (result == null) {
            throw new IllegalArgumentException(MessageFormat.format(Messages.VALIDATOR_UNKNOWN_LITERAL_TYPE, prefix));
        }
        return result;
    }

    private static String getPrefixFromType(DataType type) throws IllegalArgumentException {
        if (type instanceof TimeType) {
            return TIME_SHORT_FORM;
        }
        if (type instanceof LtimeType) {
            return LTIME_SHORT_FORM;
        }
        if (type instanceof DateType) {
            return DATE_SHORT_FORM;
        }
        if (type instanceof LdateType) {
            return LDATE_SHORT_FORM;
        }
        if (type instanceof TimeOfDayType) {
            return TIME_OF_DAY_SHORT_FORM;
        }
        if (type instanceof LtodType) {
            return LTIME_OF_DAY_SHORT_FORM;
        }
        if (type instanceof DateAndTimeType) {
            return DATE_AND_TIME_SHORT_FORM;
        }
        if (type instanceof LdtType) {
            return LDATE_AND_TIME_SHORT_FORM;
        }
        return "";
    }

    private static ValueConverter<?> getValueConverter(DataType type) throws IllegalArgumentException {
        ValueConverter<?> valueConverter = ValueConverterFactory.createValueConverter(type);
        if (valueConverter == null) {
            throw new IllegalArgumentException(MessageFormat.format(Messages.VALIDATOR_TypeNotSupported, type.getName()));
        }
        return valueConverter;
    }

    private static boolean isTypePrefixRequired(DataType type) {
        return IecTypes.GenericTypes.isAnyType(type) || type instanceof AnyDurationType || type instanceof AnyDateType;
    }

    private static Object checkValue(DataType type, String string, Object value, boolean strict) {
        if ((type instanceof AnyNumType || type instanceof AnyBitType) && !TypedValueConverter.isNumericValueValid(type, value, strict)) {
            throw new IllegalArgumentException(MessageFormat.format(Messages.VALIDATOR_INVALID_NUMBER_LITERAL, string));
        }
        return value;
    }

    private static boolean isNumericValueValid(DataType type, Object value, boolean strict) {
        if (value instanceof Boolean) {
            return type instanceof BoolType;
        }
        if (value instanceof Double) {
            return type instanceof RealType || type instanceof LrealType;
        }
        if (value instanceof BigDecimal) {
            BigDecimal bigDecimal = (BigDecimal)value;
            if (type instanceof RealType) {
                return Float.isFinite(bigDecimal.floatValue());
            }
            if (type instanceof LrealType) {
                return Double.isFinite(bigDecimal.doubleValue());
            }
        }
        if (value instanceof BigInteger) {
            BigInteger bigInteger = (BigInteger)value;
            if (type instanceof RealType && !strict) {
                return Float.isFinite(bigInteger.floatValue());
            }
            if (type instanceof LrealType && !strict) {
                return Double.isFinite(bigInteger.doubleValue());
            }
            if (type instanceof SintType) {
                return TypedValueConverter.checkRange(bigInteger, -128L, 127L);
            }
            if (type instanceof IntType) {
                return TypedValueConverter.checkRange(bigInteger, -32768L, 32767L);
            }
            if (type instanceof DintType) {
                return TypedValueConverter.checkRange(bigInteger, Integer.MIN_VALUE, Integer.MAX_VALUE);
            }
            if (type instanceof LintType) {
                return TypedValueConverter.checkRange(bigInteger, Long.MIN_VALUE, Long.MAX_VALUE);
            }
            if (type instanceof UsintType) {
                return TypedValueConverter.checkRangeUnsigned(bigInteger, BigInteger.valueOf(255L));
            }
            if (type instanceof UintType) {
                return TypedValueConverter.checkRangeUnsigned(bigInteger, BigInteger.valueOf(65535L));
            }
            if (type instanceof UdintType) {
                return TypedValueConverter.checkRangeUnsigned(bigInteger, BigInteger.valueOf(0xFFFFFFFFL));
            }
            if (type instanceof UlintType) {
                return TypedValueConverter.checkRangeUnsigned(bigInteger, new BigInteger("ffffffffffffffff", 16));
            }
            if (type instanceof BoolType) {
                return TypedValueConverter.checkRangeUnsigned(bigInteger, BigInteger.ONE);
            }
            if (type instanceof ByteType) {
                return TypedValueConverter.checkRangeUnsigned(bigInteger, BigInteger.valueOf(255L));
            }
            if (type instanceof WordType) {
                return TypedValueConverter.checkRangeUnsigned(bigInteger, BigInteger.valueOf(65535L));
            }
            if (type instanceof DwordType) {
                return TypedValueConverter.checkRangeUnsigned(bigInteger, BigInteger.valueOf(0xFFFFFFFFL));
            }
            if (type instanceof LwordType) {
                return TypedValueConverter.checkRangeUnsigned(bigInteger, new BigInteger("ffffffffffffffff", 16));
            }
        }
        return false;
    }

    private static boolean checkRange(BigInteger value, long lower, long upper) {
        return value.compareTo(BigInteger.valueOf(lower)) >= 0 && value.compareTo(BigInteger.valueOf(upper)) <= 0;
    }

    private static boolean checkRangeUnsigned(BigInteger value, BigInteger upper) {
        return value.signum() >= 0 && value.compareTo(upper) <= 0;
    }

    public String toString() {
        if (this.strict) {
            return String.format("%s [type=%s, strict]", this.getClass().getSimpleName(), this.type.getName());
        }
        return String.format("%s [type=%s]", this.getClass().getSimpleName(), this.type.getName());
    }
}

