/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.commands.change;

import java.util.Objects;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.model.commands.ScopedCommand;
import org.eclipse.fordiac.ide.model.helpers.FBNetworkHelper;
import org.eclipse.fordiac.ide.model.libraryElement.FB;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementPackage;
import org.eclipse.fordiac.ide.model.typelibrary.FBTypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.TypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibrary;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibraryManager;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;

public class ChangeFbTypeCommand
extends Command
implements ScopedCommand {
    private final FB fb;
    private FBTypeEntry oldEntry;
    private final FBTypeEntry newType;
    private final CompoundCommand additionalCommands = new CompoundCommand();

    public ChangeFbTypeCommand(FB fb, FBTypeEntry newType) {
        this.fb = Objects.requireNonNull(fb);
        this.newType = Objects.requireNonNull(newType);
    }

    public static ChangeFbTypeCommand forTypeName(FB fb, String typeName) {
        TypeLibrary typeLibrary = TypeLibraryManager.INSTANCE.getTypeLibraryFromContext((EObject)fb);
        FBTypeEntry typeEntry = typeLibrary.getFBTypeEntry(typeName);
        if (typeEntry == null) {
            typeEntry = (FBTypeEntry)typeLibrary.createErrorTypeEntry(typeName, LibraryElementPackage.eINSTANCE.getFBType());
        }
        return ChangeFbTypeCommand.forDataType(fb, typeEntry);
    }

    public static ChangeFbTypeCommand forDataType(FB fb, FBTypeEntry typeEntry) {
        return new ChangeFbTypeCommand(fb, typeEntry);
    }

    public boolean canExecute() {
        return FBNetworkHelper.isTypeInsertionSafe((FBType)this.newType.getType(), (EObject)this.fb);
    }

    public void execute() {
        this.oldEntry = (FBTypeEntry)this.fb.getTypeEntry();
        this.setFBType(this.newType);
        this.additionalCommands.execute();
    }

    private void setFBType(FBTypeEntry entry) {
        this.fb.setTypeEntry((TypeEntry)entry);
        this.fb.setInterface(entry.getInterface().copy());
    }

    public void redo() {
        this.setFBType(this.newType);
        this.additionalCommands.redo();
    }

    public void undo() {
        this.additionalCommands.undo();
        this.setFBType(this.oldEntry);
    }

    public CompoundCommand getAdditionalCommands() {
        return this.additionalCommands;
    }

    @Override
    public Set<EObject> getAffectedObjects() {
        return Set.of(this.fb);
    }
}

