/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.commands.change;

import java.util.NoSuchElementException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.model.commands.change.AbstractChangeInterfaceElementCommand;
import org.eclipse.fordiac.ide.model.commands.change.ChangeAdapterFBCommand;
import org.eclipse.fordiac.ide.model.commands.change.ChangeArraySizeCommand;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.helpers.ImportHelper;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.BlockFBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.CompositeFBType;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.fordiac.ide.model.libraryElement.SubAppType;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.typelibrary.AdapterTypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.DataTypeLibrary;
import org.eclipse.fordiac.ide.model.typelibrary.EventTypeLibrary;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibrary;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibraryManager;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;

public final class ChangeDataTypeCommand
extends AbstractChangeInterfaceElementCommand {
    private static final Pattern ARRAY_TYPE_DECLARATION_PATTERN = Pattern.compile("ARRAY\\s*\\[(.*)\\]\\s*OF\\s+(.+)", 2);
    private final DataType dataType;
    private DataType oldDataType;
    private final CompoundCommand additionalCommands = new CompoundCommand();

    private ChangeDataTypeCommand(IInterfaceElement interfaceElement, DataType dataType) {
        super(interfaceElement);
        this.dataType = dataType;
    }

    public static ChangeDataTypeCommand forTypeName(IInterfaceElement interfaceElement, String typeName) {
        TypeLibrary typeLibrary = TypeLibraryManager.INSTANCE.getTypeLibraryFromContext((EObject)interfaceElement);
        Object dataType = interfaceElement instanceof Event ? (DataType)ImportHelper.resolveImport((String)typeName, (EObject)interfaceElement, arg_0 -> ((EventTypeLibrary)EventTypeLibrary.getInstance()).getType(arg_0), name -> {
            throw new NoSuchElementException((String)name);
        }) : (interfaceElement instanceof AdapterDeclaration ? ((AdapterTypeEntry)ImportHelper.resolveImport((String)typeName, (EObject)interfaceElement, arg_0 -> ((TypeLibrary)typeLibrary).getAdapterTypeEntry(arg_0), name -> {
            throw new NoSuchElementException((String)name);
        })).getType() : (DataType)ImportHelper.resolveImport((String)typeName, (EObject)interfaceElement, arg_0 -> ((DataTypeLibrary)typeLibrary.getDataTypeLibrary()).getTypeIfExists(arg_0), arg_0 -> ((DataTypeLibrary)typeLibrary.getDataTypeLibrary()).getType(arg_0)));
        return ChangeDataTypeCommand.forDataType(interfaceElement, dataType);
    }

    public static ChangeDataTypeCommand forDataType(IInterfaceElement interfaceElement, DataType dataType) {
        SubApp subApp;
        BlockFBNetworkElement blockFBNetworkElement;
        ChangeDataTypeCommand result = new ChangeDataTypeCommand(interfaceElement, dataType);
        if (interfaceElement != null && (blockFBNetworkElement = interfaceElement.getBlockFBNetworkElement()) instanceof SubApp && (subApp = (SubApp)blockFBNetworkElement).isMapped()) {
            result.getAdditionalCommands().add((Command)new ChangeDataTypeCommand(subApp.getOpposite().getInterfaceElement(interfaceElement.getName()), dataType));
        }
        if (interfaceElement instanceof AdapterDeclaration) {
            CompositeFBType compositeFBType;
            AdapterDeclaration adapterDeclaration = (AdapterDeclaration)interfaceElement;
            FBType fBType = interfaceElement.getFBType();
            if (fBType instanceof CompositeFBType && !((compositeFBType = (CompositeFBType)fBType) instanceof SubAppType)) {
                result.getAdditionalCommands().add((Command)new ChangeAdapterFBCommand(adapterDeclaration));
            }
        }
        return result;
    }

    public static ChangeDataTypeCommand forTypeDeclaration(IInterfaceElement interfaceElement, String typeDeclaration) {
        if (interfaceElement instanceof VarDeclaration) {
            String dataTypeName;
            String arraySize;
            VarDeclaration varDeclaration = (VarDeclaration)interfaceElement;
            Matcher matcher = ARRAY_TYPE_DECLARATION_PATTERN.matcher(typeDeclaration.trim());
            if (matcher.matches()) {
                arraySize = matcher.group(1);
                dataTypeName = matcher.group(2);
            } else {
                arraySize = null;
                dataTypeName = typeDeclaration;
            }
            ChangeDataTypeCommand result = ChangeDataTypeCommand.forTypeName((IInterfaceElement)varDeclaration, dataTypeName);
            result.getAdditionalCommands().add((Command)ChangeArraySizeCommand.forArraySize(varDeclaration, arraySize));
            return result;
        }
        return ChangeDataTypeCommand.forTypeName(interfaceElement, typeDeclaration);
    }

    @Override
    protected void doExecute() {
        this.oldDataType = this.getInterfaceElement().getType();
        this.setNewType();
        this.additionalCommands.execute();
    }

    @Override
    protected void doUndo() {
        this.additionalCommands.undo();
        this.getInterfaceElement().setType(this.oldDataType);
    }

    @Override
    protected void doRedo() {
        this.setNewType();
        this.additionalCommands.redo();
    }

    private void setNewType() {
        this.getInterfaceElement().setType(this.dataType);
    }

    public CompoundCommand getAdditionalCommands() {
        return this.additionalCommands;
    }
}

