/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.edit.helper;

import java.text.MessageFormat;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.fordiac.ide.model.data.provider.FordiacEditPlugin;
import org.eclipse.fordiac.ide.model.edit.helper.InitialValueHelper;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.swt.widgets.Display;

public class InitialValueRefreshJob
extends Job {
    private final AtomicReference<IInterfaceElement> interfaceElementRef;
    private final Consumer<String> consumer;
    private final boolean initialOrDefaultValue;
    private final boolean runConsumerInUIThread;
    private final AtomicBoolean interruptible = new AtomicBoolean();

    public InitialValueRefreshJob(IInterfaceElement interfaceElement, Consumer<String> consumer) {
        this(interfaceElement, consumer, true);
    }

    public InitialValueRefreshJob(IInterfaceElement interfaceElement, Consumer<String> consumer, boolean initialOrDefaultValue) {
        this(interfaceElement, consumer, initialOrDefaultValue, true);
    }

    public InitialValueRefreshJob(IInterfaceElement interfaceElement, Consumer<String> consumer, boolean initialOrDefaultValue, boolean runConsumerInUIThread) {
        super(InitialValueRefreshJob.generateName(interfaceElement));
        this.interfaceElementRef = new AtomicReference<IInterfaceElement>(interfaceElement);
        this.consumer = consumer;
        this.initialOrDefaultValue = initialOrDefaultValue;
        this.runConsumerInUIThread = runConsumerInUIThread;
        this.setPriority(20);
    }

    protected IStatus run(IProgressMonitor monitor) {
        IInterfaceElement interfaceElement = this.interfaceElementRef.get();
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        this.interruptible.set(true);
        String value = this.initialOrDefaultValue ? InitialValueHelper.getInitialOrDefaultValue(interfaceElement) : InitialValueHelper.getDefaultValue(interfaceElement);
        this.interruptible.set(false);
        if (monitor.isCanceled() || Thread.interrupted()) {
            return Status.CANCEL_STATUS;
        }
        if (this.runConsumerInUIThread) {
            Display.getDefault().asyncExec(() -> this.consumer.accept(value));
        } else {
            this.consumer.accept(value);
        }
        return Status.OK_STATUS;
    }

    protected void canceling() {
        Thread thread;
        if (this.interruptible.get() && (thread = this.getThread()) != null) {
            thread.interrupt();
        }
    }

    public void refresh() {
        this.cancel();
        this.schedule();
    }

    public IInterfaceElement getInterfaceElement() {
        return this.interfaceElementRef.get();
    }

    public void setInterfaceElement(IInterfaceElement interfaceElement) {
        this.interfaceElementRef.set(interfaceElement);
        this.setName(InitialValueRefreshJob.generateName(interfaceElement));
    }

    private static String generateName(IInterfaceElement interfaceElement) {
        return MessageFormat.format(FordiacEditPlugin.INSTANCE.getString("_UI_InitialValueRefreshJob_name"), interfaceElement != null ? interfaceElement.getQualifiedName() : "null");
    }
}

