; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 4
; Test long double atomic exchange.
;
; RUN: llc < %s -mtriple=s390x-linux-gnu | FileCheck -check-prefixes=CHECK,HARDFP %s
; RUN: llc < %s -mtriple=s390x-linux-gnu -mattr=+soft-float | FileCheck -check-prefixes=CHECK,SOFTFP %s

define void @f1(ptr align 16 %ret, ptr align 16 %src, ptr align 16 %b) {
; CHECK-LABEL: f1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    stmg %r12, %r15, 96(%r15)
; CHECK-NEXT:    .cfi_offset %r12, -64
; CHECK-NEXT:    .cfi_offset %r13, -56
; CHECK-NEXT:    .cfi_offset %r15, -40
; CHECK-NEXT:    lg %r1, 8(%r4)
; CHECK-NEXT:    lg %r0, 0(%r4)
; CHECK-NEXT:    lg %r4, 8(%r3)
; CHECK-NEXT:    lg %r5, 0(%r3)
; CHECK-NEXT:  .LBB0_1: # %atomicrmw.start
; CHECK-NEXT:    # =>This Inner Loop Header: Depth=1
; CHECK-NEXT:    lgr %r12, %r5
; CHECK-NEXT:    lgr %r13, %r4
; CHECK-NEXT:    cdsg %r12, %r0, 0(%r3)
; CHECK-NEXT:    lgr %r4, %r13
; CHECK-NEXT:    lgr %r5, %r12
; CHECK-NEXT:    jl .LBB0_1
; CHECK-NEXT:  # %bb.2: # %atomicrmw.end
; CHECK-NEXT:    stg %r5, 0(%r2)
; CHECK-NEXT:    stg %r4, 8(%r2)
; CHECK-NEXT:    lmg %r12, %r15, 96(%r15)
; CHECK-NEXT:    br %r14
  %val = load fp128, ptr %b, align 16
  %res = atomicrmw xchg ptr %src, fp128 %val seq_cst
  store fp128 %res, ptr %ret, align 16
  ret void
}

define void @f1_fpuse(ptr align 16 %ret, ptr align 16 %src, ptr align 16 %b) {
; HARDFP-LABEL: f1_fpuse:
; HARDFP:       # %bb.0:
; HARDFP-NEXT:    stmg %r12, %r15, 96(%r15)
; HARDFP-NEXT:    .cfi_offset %r12, -64
; HARDFP-NEXT:    .cfi_offset %r13, -56
; HARDFP-NEXT:    .cfi_offset %r15, -40
; HARDFP-NEXT:    aghi %r15, -176
; HARDFP-NEXT:    .cfi_def_cfa_offset 336
; HARDFP-NEXT:    ld %f0, 0(%r4)
; HARDFP-NEXT:    ld %f2, 8(%r4)
; HARDFP-NEXT:    lg %r0, 8(%r3)
; HARDFP-NEXT:    lg %r1, 0(%r3)
; HARDFP-NEXT:    axbr %f0, %f0
; HARDFP-NEXT:    lgdr %r5, %f2
; HARDFP-NEXT:    lgdr %r4, %f0
; HARDFP-NEXT:  .LBB1_1: # %atomicrmw.start
; HARDFP-NEXT:    # =>This Inner Loop Header: Depth=1
; HARDFP-NEXT:    lgr %r12, %r1
; HARDFP-NEXT:    lgr %r13, %r0
; HARDFP-NEXT:    cdsg %r12, %r4, 0(%r3)
; HARDFP-NEXT:    lgr %r0, %r13
; HARDFP-NEXT:    lgr %r1, %r12
; HARDFP-NEXT:    jl .LBB1_1
; HARDFP-NEXT:  # %bb.2: # %atomicrmw.end
; HARDFP-NEXT:    stg %r1, 160(%r15)
; HARDFP-NEXT:    stg %r0, 168(%r15)
; HARDFP-NEXT:    ld %f0, 160(%r15)
; HARDFP-NEXT:    ld %f2, 168(%r15)
; HARDFP-NEXT:    axbr %f0, %f0
; HARDFP-NEXT:    std %f0, 0(%r2)
; HARDFP-NEXT:    std %f2, 8(%r2)
; HARDFP-NEXT:    lmg %r12, %r15, 272(%r15)
; HARDFP-NEXT:    br %r14
;
; SOFTFP-LABEL: f1_fpuse:
; SOFTFP:       # %bb.0:
; SOFTFP-NEXT:    stmg %r12, %r15, 96(%r15)
; SOFTFP-NEXT:    .cfi_offset %r12, -64
; SOFTFP-NEXT:    .cfi_offset %r13, -56
; SOFTFP-NEXT:    .cfi_offset %r14, -48
; SOFTFP-NEXT:    .cfi_offset %r15, -40
; SOFTFP-NEXT:    aghi %r15, -256
; SOFTFP-NEXT:    .cfi_def_cfa_offset 416
; SOFTFP-NEXT:    lg %r0, 8(%r4)
; SOFTFP-NEXT:    lg %r1, 0(%r4)
; SOFTFP-NEXT:    lgr %r12, %r3
; SOFTFP-NEXT:    lgr %r13, %r2
; SOFTFP-NEXT:    stg %r0, 216(%r15)
; SOFTFP-NEXT:    stg %r1, 208(%r15)
; SOFTFP-NEXT:    stg %r0, 232(%r15)
; SOFTFP-NEXT:    la %r2, 240(%r15)
; SOFTFP-NEXT:    la %r3, 224(%r15)
; SOFTFP-NEXT:    la %r4, 208(%r15)
; SOFTFP-NEXT:    stg %r1, 224(%r15)
; SOFTFP-NEXT:    brasl %r14, __addtf3@PLT
; SOFTFP-NEXT:    lg %r3, 248(%r15)
; SOFTFP-NEXT:    lg %r2, 240(%r15)
; SOFTFP-NEXT:    lg %r0, 8(%r12)
; SOFTFP-NEXT:    lg %r1, 0(%r12)
; SOFTFP-NEXT:  .LBB1_1: # %atomicrmw.start
; SOFTFP-NEXT:    # =>This Inner Loop Header: Depth=1
; SOFTFP-NEXT:    lgr %r4, %r1
; SOFTFP-NEXT:    lgr %r5, %r0
; SOFTFP-NEXT:    cdsg %r4, %r2, 0(%r12)
; SOFTFP-NEXT:    lgr %r0, %r5
; SOFTFP-NEXT:    lgr %r1, %r4
; SOFTFP-NEXT:    jl .LBB1_1
; SOFTFP-NEXT:  # %bb.2: # %atomicrmw.end
; SOFTFP-NEXT:    stg %r1, 160(%r15)
; SOFTFP-NEXT:    stg %r1, 176(%r15)
; SOFTFP-NEXT:    stg %r0, 168(%r15)
; SOFTFP-NEXT:    la %r2, 192(%r15)
; SOFTFP-NEXT:    la %r3, 176(%r15)
; SOFTFP-NEXT:    la %r4, 160(%r15)
; SOFTFP-NEXT:    stg %r0, 184(%r15)
; SOFTFP-NEXT:    brasl %r14, __addtf3@PLT
; SOFTFP-NEXT:    lg %r0, 200(%r15)
; SOFTFP-NEXT:    lg %r1, 192(%r15)
; SOFTFP-NEXT:    stg %r0, 8(%r13)
; SOFTFP-NEXT:    stg %r1, 0(%r13)
; SOFTFP-NEXT:    lmg %r12, %r15, 352(%r15)
; SOFTFP-NEXT:    br %r14
  %val = load fp128, ptr %b, align 16
  %add.src = fadd fp128 %val, %val
  %res = atomicrmw xchg ptr %src, fp128 %add.src seq_cst
  %res.x2 = fadd fp128 %res, %res
  store fp128 %res.x2, ptr %ret, align 16
  ret void
}
