; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 4
; RUN: llc -mtriple=amdgcn-amd-amdhsa -mcpu=gfx900 %s -o - | FileCheck -check-prefix=GCN %s

; The si-mode-register pass is changing the default mode for FP constrained  operations.
; It must ignore for strictfp functions.

define double @ignoreStrictfp(double noundef %a, double noundef %b) #0 {
; GCN-LABEL: ignoreStrictfp:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 2, 2), 1
; GCN-NEXT:    v_add_f64 v[0:1], v[0:1], v[2:3]
; GCN-NEXT:    s_setpc_b64 s[30:31]
  tail call void @llvm.amdgcn.s.setreg(i32 2177, i32 1)
  %val = tail call double @llvm.experimental.constrained.fadd.f64(double %a, double %b, metadata !"round.dynamic", metadata !"fpexcept.strict") #0
  ret double %val
}

define double @set_fpenv(double noundef %a, double noundef %b) #0 {
; GCN-LABEL: set_fpenv:
; GCN:       ; %bb.0: ; %entry
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 0, 23), 4
; GCN-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_TRAPSTS, 0, 5), 0
; GCN-NEXT:    v_add_f64 v[0:1], v[0:1], v[2:3]
; GCN-NEXT:    s_setpc_b64 s[30:31]
entry:
  call void @llvm.set.fpenv.i64(i64 4)
  %val = tail call double @llvm.experimental.constrained.fadd.f64(double %a, double %b, metadata !"round.dynamic", metadata !"fpexcept.strict") #0
  ret double %val
}

declare void @llvm.amdgcn.s.setreg(i32 immarg, i32)

declare double @llvm.experimental.constrained.fadd.f64(double, double, metadata, metadata)

declare void @llvm.set.fpenv.i64(i64)

attributes #0 = { strictfp }
