dnl Check for LDAP
dnl Copyright (C) 2005 Free Software Foundation, Inc.
dnl
dnl This file is free software, distributed under the terms of the GNU
dnl General Public License.  As a special exception to the GNU General
dnl Public License, this file may be distributed as part of a program
dnl that contains a configuration script generated by Autoconf, under
dnl the same distribution terms as the rest of that program.
dnl
dnl Defines @GPGKEYS_LDAP@ to a executable name if a working ldap
dnl setup is found, and sets @LDAPLIBS@ to the necessary libraries.

AC_DEFUN([GNUPG_CHECK_LDAP],
[
# Try and link a LDAP test program to weed out unusable LDAP
# libraries.  -lldap [-llber [-lresolv]] is for older OpenLDAPs.
# OpenLDAP, circa 1999, was terrible with creating weird dependencies.
# If all else fails, the user can play guess-the-dependency by using
# something like ./configure LDAPLIBS="-Lfoo -lbar"
gnupg_have_ldap=no
AC_ARG_WITH(ldap,
  AS_HELP_STRING([--with-ldap=DIR],[look for the LDAP library in DIR]),
  [_ldap_with=$withval])

if test x$_ldap_with != xno ; then

  if test -d "$withval" ; then
     LDAP_CPPFLAGS="-I$withval/include"
     LDAP_LDFLAGS="-L$withval/lib"
  fi

  _ldap_save_cppflags=$CPPFLAGS
  CPPFLAGS="${LDAP_CPPFLAGS} ${CPPFLAGS}"
  _ldap_save_ldflags=$LDFLAGS
  LDFLAGS="${LDAP_LDFLAGS} ${LDFLAGS}"

  for MY_LDAPLIBS in ${LDAPLIBS+"$LDAPLIBS"} "-lldap" "-lldap -llber" "-lldap -llber -lresolv" "-lwldap32"; do
    _ldap_save_libs=$LIBS
    LIBS="$MY_LDAPLIBS $1 $LIBS"

    AC_MSG_CHECKING([whether LDAP via "$MY_LDAPLIBS" is present and sane])
    AC_LINK_IFELSE([AC_LANG_PROGRAM([[
#ifdef _WIN32
#include <winsock2.h>
#include <winldap.h>
#else
#define LDAP_DEPRECATED 1
#include <ldap.h>
#endif
]],[[ldap_open("foobar",1234);]])],
                [gnupg_cv_func_ldap_init=yes],[gnupg_cv_func_ldap_init=no])
    AC_MSG_RESULT([$gnupg_cv_func_ldap_init])

    if test $gnupg_cv_func_ldap_init = no; then
      AC_MSG_CHECKING([whether I can make LDAP be sane with lber.h])
      AC_LINK_IFELSE([AC_LANG_PROGRAM([[#include <lber.h>
#define LDAP_DEPRECATED 1
#include <ldap.h>]],[[ldap_open("foobar",1234);]])],
         [gnupg_cv_func_ldaplber_init=yes],[gnupg_cv_func_ldaplber_init=no])
      AC_MSG_RESULT([$gnupg_cv_func_ldaplber_init])
    fi

    if test "$gnupg_cv_func_ldaplber_init" = yes ; then
       AC_DEFINE(NEED_LBER_H,1,[Define if the LDAP library requires including lber.h before ldap.h])
    fi

    if test "$gnupg_cv_func_ldap_init" = yes || \
        test "$gnupg_cv_func_ldaplber_init" = yes ; then
       LDAPLIBS="$LDAP_LDFLAGS $MY_LDAPLIBS"
       GPGKEYS_LDAP="gpg2keys_ldap$EXEEXT"
       gnupg_have_ldap=yes

       AC_CHECK_FUNCS(ldap_get_option ldap_set_option)
       # The extra test for ldap_start_tls_sA is for W32 because 
       # that is the actual function in the library.
       AC_CHECK_FUNCS(ldap_start_tls_s ldap_start_tls_sA)

       if test "$ac_cv_func_ldap_get_option" != yes ; then
          AC_MSG_CHECKING([whether LDAP supports ld_errno])
	  AC_LINK_IFELSE([AC_LANG_PROGRAM([[#include <ldap.h>]],
             [[LDAP *ldap; ldap->ld_errno;]])],
	     [gnupg_cv_func_ldap_ld_errno=yes],
	     [gnupg_cv_func_ldap_ld_errno=no])
          AC_MSG_RESULT([$gnupg_cv_func_ldap_ld_errno])

	  if test "$gnupg_cv_func_ldap_ld_errno" = yes ; then
	     AC_DEFINE(HAVE_LDAP_LD_ERRNO,1,[Define if the LDAP library supports ld_errno])
          fi
       fi
    fi

    LIBS=$_ldap_save_libs

    if test "$GPGKEYS_LDAP" != "" ; then break; fi
  done

  AC_SUBST(GPGKEYS_LDAP)
  AC_SUBST(LDAPLIBS)
  AC_SUBST(LDAP_CPPFLAGS)

  CPPFLAGS=$_ldap_save_cppflags
  LDFLAGS=$_ldap_save_ldflags
fi
])dnl
