# Generated by default/object.tt
package Paws::EMRContainers::MonitoringConfiguration;
  use Moose;
  has CloudWatchMonitoringConfiguration => (is => 'ro', isa => 'Paws::EMRContainers::CloudWatchMonitoringConfiguration', request_name => 'cloudWatchMonitoringConfiguration', traits => ['NameInRequest']);
  has PersistentAppUI => (is => 'ro', isa => 'Str', request_name => 'persistentAppUI', traits => ['NameInRequest']);
  has S3MonitoringConfiguration => (is => 'ro', isa => 'Paws::EMRContainers::S3MonitoringConfiguration', request_name => 's3MonitoringConfiguration', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::EMRContainers::MonitoringConfiguration

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::EMRContainers::MonitoringConfiguration object:

  $service_obj->Method(Att1 => { CloudWatchMonitoringConfiguration => $value, ..., S3MonitoringConfiguration => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::EMRContainers::MonitoringConfiguration object:

  $result = $service_obj->Method(...);
  $result->Att1->CloudWatchMonitoringConfiguration

=head1 DESCRIPTION

Configuration setting for monitoring.

=head1 ATTRIBUTES


=head2 CloudWatchMonitoringConfiguration => L<Paws::EMRContainers::CloudWatchMonitoringConfiguration>

Monitoring configurations for CloudWatch.


=head2 PersistentAppUI => Str

Monitoring configurations for the persistent application UI.


=head2 S3MonitoringConfiguration => L<Paws::EMRContainers::S3MonitoringConfiguration>

Amazon S3 configuration for monitoring log publishing.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::EMRContainers>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

