#!/usr/bin/env python

# This file is part of Window-Switch.
# Copyright (c) 2009-2013 Antoine Martin <antoine@nagafix.co.uk>
# Window-Switch is released under the terms of the GNU GPL v3

#@PydevCodeAnalysisIgnore

import os
import sys
import gtk

from winswitch.util.simple_logger import Logger
from winswitch.util.common import csv_list, load_binary_file
from winswitch.util.paths import ANIM_DIR
from winswitch.util.icon_util import get_icon_from_data, HAS_PIXBUFLOADER

logger=Logger("anims", log_colour=Logger.HIGHLIGHTED_BLUE)

init_done = False

def init_anims():
	if not HAS_PIXBUFLOADER:
		return
	files = os.listdir(ANIM_DIR)
	if 'Thumbs.db' in files:
		files.remove('Thumbs.db')
	logger.sdebug("will try to load all animations found in '%s': %s" % (ANIM_DIR, csv_list(files)))
	for filename in files:
		anim_path = os.path.join(ANIM_DIR, filename)
		try:
			import gtk.gdk
			anim = gtk.gdk.PixbufAnimation(anim_path)
			pos = filename.find(".")
			if pos>0:
				key = filename[:pos]
			else:
				key = filename
			globals()[key] = anim
		except Exception, e:
			logger.serr("error loading animation from '%s'" % anim_path, e)

def try_get(name):
	if name in globals():
		return	globals()[name]
	return	None

def get(name):
	i = try_get(name)
	if i:
		return	i
	logger.serror("missing! anim_dir=%s" % ANIM_DIR, name)
	raise Exception("Missing anim '%s', anim_dir=%s" % (name, ANIM_DIR))


if not init_done:
	init_anims()
	init_done = True
