/* WhySynth DSSI software synthesizer plugin
 *
 * Copyright (C) 2008, 2010 Sean Bolton.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301 USA.
 */

#include "whysynth_voice.h"

/* minBLEP tables
 *
 * sincm dilation: 0.9
 * oversampling: 64
 * zero crossings: 32
 * Blackman window width: 4553
 *
 * run-time phase calculation simplified by shifting minBLEP discontinuity
 * center from 3.4105655325823 samples forward to 4 samples (using 3rd-order
 * B-spline interpolation)
 *
 * forward-shifted discontinuity deltas truncated after the 64th sample
 *
 * For more information, see:
 *
 *    Stilson and Smith, "Alias Free Digital Synthesis of Classic Analog
 *        Waveforms" (1996)
 *
 *    Brandt, "Hard Sync Without Aliasing" (2001)
 */

float_value_delta
y_step_dd_table[MINBLEP_PHASES * DD_PULSE_LENGTH + 1] =
{
 { 0.000000e+00, 0.000000e+00},{ 0.000000e+00, 0.000000e+00},{ 0.000000e+00, 0.000000e+00},{ 0.000000e+00, 0.000000e+00},
 { 0.000000e+00, 0.000000e+00},{ 0.000000e+00, 0.000000e+00},{ 0.000000e+00, 0.000000e+00},{ 0.000000e+00, 0.000000e+00},
 { 0.000000e+00, 0.000000e+00},{ 0.000000e+00, 0.000000e+00},{ 0.000000e+00, 0.000000e+00},{ 0.000000e+00, 0.000000e+00},
 { 0.000000e+00, 0.000000e+00},{ 0.000000e+00, 0.000000e+00},{ 0.000000e+00, 0.000000e+00},{ 0.000000e+00, 0.000000e+00},
 { 0.000000e+00, 0.000000e+00},{ 0.000000e+00, 0.000000e+00},{ 0.000000e+00, 0.000000e+00},{ 0.000000e+00, 0.000000e+00},
 { 0.000000e+00, 0.000000e+00},{ 0.000000e+00, 0.000000e+00},{ 0.000000e+00, 0.000000e+00},{ 0.000000e+00, 0.000000e+00},
 { 0.000000e+00, 0.000000e+00},{ 0.000000e+00, 0.000000e+00},{ 0.000000e+00, 0.000000e+00},{ 0.000000e+00, 0.000000e+00},
 { 0.000000e+00, 0.000000e+00},{ 0.000000e+00, 0.000000e+00},{ 0.000000e+00, 0.000000e+00},{ 0.000000e+00, 0.000000e+00},
 { 0.000000e+00, 0.000000e+00},{ 0.000000e+00, 0.000000e+00},{ 0.000000e+00, 0.000000e+00},{ 0.000000e+00, 4.153209e-13},
 { 4.153209e-13, 3.982154e-11},{ 4.023686e-11, 1.200895e-10},{ 1.603264e-10, 1.619764e-10},{ 3.223028e-10, 2.284543e-10},
 { 5.507571e-10, 3.438502e-10},{ 8.946073e-10, 5.304112e-10},{ 1.425018e-09, 8.155980e-10},{ 2.240616e-09, 1.232804e-09},
 { 3.473421e-09, 1.822139e-09},{ 5.295559e-09, 2.631270e-09},{ 7.926830e-09, 3.716341e-09},{ 1.164317e-08, 5.142951e-09},
 { 1.678612e-08, 6.987212e-09},{ 2.377333e-08, 9.336883e-09},{ 3.311022e-08, 1.229258e-08},{ 4.540280e-08, 1.596907e-08},
 { 6.137187e-08, 2.049667e-08},{ 8.186854e-08, 2.602266e-08},{ 1.078912e-07, 3.271292e-08},{ 1.406041e-07, 4.075351e-08},
 { 1.813576e-07, 5.035247e-08},{ 2.317101e-07, 6.174165e-08},{ 2.934517e-07, 7.517865e-08},{ 3.686304e-07, 9.094890e-08},
 { 4.595793e-07, 1.093678e-07},{ 5.689471e-07, 1.307831e-07},{ 6.997302e-07, 1.555770e-07},{ 8.553072e-07, 1.841690e-07},
 { 1.039476e-06, 2.170183e-07},{ 1.256494e-06, 2.546266e-07},{ 1.511121e-06, 2.975411e-07},{ 1.808662e-06, 3.463570e-07},
 { 2.155019e-06, 4.017212e-07},{ 2.556740e-06, 4.643352e-07},{ 3.021075e-06, 5.349584e-07},{ 3.556034e-06, 6.144118e-07},
 { 4.170446e-06, 7.035815e-07},{ 4.874027e-06, 8.034221e-07},{ 5.677449e-06, 9.149614e-07},{ 6.592411e-06, 1.039303e-06},
 { 7.631714e-06, 1.177633e-06},{ 8.809347e-06, 1.331220e-06},{ 1.014057e-05, 1.501424e-06},{ 1.164199e-05, 1.689697e-06},
 { 1.333169e-05, 1.897593e-06},{ 1.522928e-05, 2.126764e-06},{ 1.735604e-05, 2.378974e-06},{ 1.973502e-05, 2.656099e-06},
 { 2.239112e-05, 2.960133e-06},{ 2.535125e-05, 3.293192e-06},{ 2.864444e-05, 3.657522e-06},{ 3.230196e-05, 4.055504e-06},
 { 3.635747e-05, 4.489655e-06},{ 4.084712e-05, 4.962642e-06},{ 4.580976e-05, 5.477277e-06},{ 5.128704e-05, 6.036533e-06},
 { 5.732357e-05, 6.643544e-06},{ 6.396712e-05, 7.301610e-06},{ 7.126873e-05, 8.014209e-06},{ 7.928294e-05, 8.784995e-06},
 { 8.806793e-05, 9.617811e-06},{ 9.768574e-05, 1.051669e-05},{ 1.082024e-04, 1.148587e-05},{ 1.196883e-04, 1.252978e-05},
 { 1.322181e-04, 1.365308e-05},{ 1.458712e-04, 1.486062e-05},{ 1.607318e-04, 1.615750e-05},{ 1.768893e-04, 1.754904e-05},
 { 1.944383e-04, 1.904078e-05},{ 2.134791e-04, 2.063851e-05},{ 2.341176e-04, 2.234829e-05},{ 2.564659e-04, 2.417640e-05},
 { 2.806423e-04, 2.612940e-05},{ 3.067717e-04, 2.821410e-05},{ 3.349858e-04, 3.043760e-05},{ 3.654234e-04, 3.280726e-05},
 { 3.982307e-04, 3.533071e-05},{ 4.335614e-04, 3.801591e-05},{ 4.715773e-04, 4.087106e-05},{ 5.124484e-04, 4.390470e-05},
 { 5.563531e-04, 4.712563e-05},{ 6.034787e-04, 5.054300e-05},{ 6.540217e-04, 5.416623e-05},{ 7.081879e-04, 5.800509e-05},
 { 7.661930e-04, 6.206963e-05},{ 8.282626e-04, 6.637025e-05},{ 8.946329e-04, 7.091766e-05},{ 9.655505e-04, 7.572291e-05},
 { 1.041273e-03, 8.079737e-05},{ 1.122071e-03, 8.615274e-05},{ 1.208224e-03, 9.180106e-05},{ 1.300025e-03, 9.775470e-05},
 { 1.397779e-03, 1.040264e-04},{ 1.501806e-03, 1.106291e-04},{ 1.612435e-03, 1.175763e-04},{ 1.730011e-03, 1.248817e-04},
 { 1.854893e-03, 1.325593e-04},{ 1.987452e-03, 1.406235e-04},{ 2.128076e-03, 1.490891e-04},{ 2.277165e-03, 1.579711e-04},
 { 2.435136e-03, 1.672848e-04},{ 2.602421e-03, 1.770460e-04},{ 2.779467e-03, 1.872707e-04},{ 2.966737e-03, 1.979753e-04},
 { 3.164713e-03, 2.091763e-04},{ 3.373889e-03, 2.208908e-04},{ 3.594780e-03, 2.331360e-04},{ 3.827916e-03, 2.459294e-04},
 { 4.073845e-03, 2.592889e-04},{ 4.333134e-03, 2.732326e-04},{ 4.606367e-03, 2.877788e-04},{ 4.894146e-03, 3.029461e-04},
 { 5.197092e-03, 3.187535e-04},{ 5.515845e-03, 3.352200e-04},{ 5.851065e-03, 3.523649e-04},{ 6.203430e-03, 3.702079e-04},
 { 6.573638e-03, 3.887685e-04},{ 6.962406e-03, 4.080668e-04},{ 7.370473e-03, 4.281228e-04},{ 7.798596e-03, 4.489567e-04},
 { 8.247553e-03, 4.705888e-04},{ 8.718141e-03, 4.930398e-04},{ 9.211181e-03, 5.163301e-04},{ 9.727511e-03, 5.404803e-04},
 { 1.026799e-02, 5.655113e-04},{ 1.083350e-02, 5.914438e-04},{ 1.142495e-02, 6.182984e-04},{ 1.204325e-02, 6.460961e-04},
 { 1.268934e-02, 6.748575e-04},{ 1.336420e-02, 7.046034e-04},{ 1.406880e-02, 7.353543e-04},{ 1.480416e-02, 7.671307e-04},
 { 1.557129e-02, 7.999531e-04},{ 1.637124e-02, 8.338417e-04},{ 1.720508e-02, 8.688165e-04},{ 1.807390e-02, 9.048974e-04},
 { 1.897880e-02, 9.421040e-04},{ 1.992090e-02, 9.804556e-04},{ 2.090136e-02, 1.019971e-03},{ 2.192133e-02, 1.060670e-03},
 { 2.298200e-02, 1.102570e-03},{ 2.408457e-02, 1.145689e-03},{ 2.523025e-02, 1.190044e-03},{ 2.642030e-02, 1.235654e-03},
 { 2.765595e-02, 1.282533e-03},{ 2.893849e-02, 1.330700e-03},{ 3.026919e-02, 1.380168e-03},{ 3.164935e-02, 1.430954e-03},
 { 3.308031e-02, 1.483071e-03},{ 3.456338e-02, 1.536532e-03},{ 3.609991e-02, 1.591352e-03},{ 3.769126e-02, 1.647542e-03},
 { 3.933880e-02, 1.705113e-03},{ 4.104392e-02, 1.764077e-03},{ 4.280799e-02, 1.824443e-03},{ 4.463244e-02, 1.886220e-03},
 { 4.651866e-02, 1.949416e-03},{ 4.846807e-02, 2.014038e-03},{ 5.048211e-02, 2.080093e-03},{ 5.256220e-02, 2.147584e-03},
 { 5.470979e-02, 2.216517e-03},{ 5.692631e-02, 2.286894e-03},{ 5.921320e-02, 2.358717e-03},{ 6.157192e-02, 2.431986e-03},
 { 6.400390e-02, 2.506702e-03},{ 6.651061e-02, 2.582861e-03},{ 6.909347e-02, 2.660462e-03},{ 7.175393e-02, 2.739499e-03},
 { 7.449343e-02, 2.819966e-03},{ 7.731339e-02, 2.901858e-03},{ 8.021525e-02, 2.985164e-03},{ 8.320042e-02, 3.069876e-03},
 { 8.627029e-02, 3.155981e-03},{ 8.942627e-02, 3.243467e-03},{ 9.266974e-02, 3.332319e-03},{ 9.600206e-02, 3.422522e-03},
 { 9.942458e-02, 3.514057e-03},{ 1.029386e-01, 3.606906e-03},{ 1.065455e-01, 3.701047e-03},{ 1.102466e-01, 3.796458e-03},
 { 1.140430e-01, 3.893116e-03},{ 1.179362e-01, 3.990994e-03},{ 1.219272e-01, 4.090065e-03},{ 1.260172e-01, 4.190299e-03},
 { 1.302075e-01, 4.291665e-03},{ 1.344992e-01, 4.394132e-03},{ 1.388933e-01, 4.497663e-03},{ 1.433910e-01, 4.602223e-03},
 { 1.479932e-01, 4.707774e-03},{ 1.527010e-01, 4.814276e-03},{ 1.575153e-01, 4.921687e-03},{ 1.624369e-01, 5.029964e-03},
 { 1.674669e-01, 5.139061e-03},{ 1.726060e-01, 5.248932e-03},{ 1.778549e-01, 5.359526e-03},{ 1.832144e-01, 5.470795e-03},
 { 1.886852e-01, 5.582684e-03},{ 1.942679e-01, 5.695141e-03},{ 1.999630e-01, 5.808108e-03},{ 2.057712e-01, 5.921528e-03},
 { 2.116927e-01, 6.035342e-03},{ 2.177280e-01, 6.149488e-03},{ 2.238775e-01, 6.263903e-03},{ 2.301414e-01, 6.378523e-03},
 { 2.365199e-01, 6.493281e-03},{ 2.430132e-01, 6.608110e-03},{ 2.496213e-01, 6.722939e-03},{ 2.563443e-01, 6.837698e-03},
 { 2.631820e-01, 6.952315e-03},{ 2.701343e-01, 7.066714e-03},{ 2.772010e-01, 7.180822e-03},{ 2.843818e-01, 7.294560e-03},
 { 2.916764e-01, 7.407850e-03},{ 2.990842e-01, 7.520613e-03},{ 3.066048e-01, 7.632768e-03},{ 3.142376e-01, 7.744233e-03},
 { 3.219818e-01, 7.854925e-03},{ 3.298368e-01, 7.964759e-03},{ 3.378015e-01, 8.073649e-03},{ 3.458752e-01, 8.181511e-03},
 {-6.459433e-01, 8.288256e-03},{-6.376551e-01, 8.393796e-03},{-6.292613e-01, 8.498043e-03},{-6.207632e-01, 8.600907e-03},
 {-6.121623e-01, 8.702298e-03},{-6.034600e-01, 8.802124e-03},{-5.946579e-01, 8.900296e-03},{-5.857576e-01, 8.996721e-03},
 {-5.767609e-01, 9.091308e-03},{-5.676696e-01, 9.183964e-03},{-5.584856e-01, 9.274597e-03},{-5.492110e-01, 9.363115e-03},
 {-5.398479e-01, 9.449425e-03},{-5.303985e-01, 9.533437e-03},{-5.208650e-01, 9.615056e-03},{-5.112500e-01, 9.694193e-03},
 {-5.015558e-01, 9.770756e-03},{-4.917850e-01, 9.844654e-03},{-4.819404e-01, 9.915798e-03},{-4.720246e-01, 9.984097e-03},
 {-4.620405e-01, 1.004946e-02},{-4.519910e-01, 1.011181e-02},{-4.418792e-01, 1.017105e-02},{-4.317081e-01, 1.022710e-02},
 {-4.214810e-01, 1.027987e-02},{-4.112012e-01, 1.032928e-02},{-4.008719e-01, 1.037526e-02},{-3.904966e-01, 1.041771e-02},
 {-3.800789e-01, 1.045656e-02},{-3.696224e-01, 1.049174e-02},{-3.591306e-01, 1.052316e-02},{-3.486075e-01, 1.055077e-02},
 {-3.380567e-01, 1.057448e-02},{-3.274822e-01, 1.059422e-02},{-3.168880e-01, 1.060994e-02},{-3.062781e-01, 1.062157e-02},
 {-2.956565e-01, 1.062904e-02},{-2.850274e-01, 1.063230e-02},{-2.743951e-01, 1.063129e-02},{-2.637639e-01, 1.062596e-02},
 {-2.531379e-01, 1.061626e-02},{-2.425216e-01, 1.060213e-02},{-2.319195e-01, 1.058354e-02},{-2.213360e-01, 1.056044e-02},
 {-2.107755e-01, 1.053280e-02},{-2.002427e-01, 1.050058e-02},{-1.897421e-01, 1.046374e-02},{-1.792784e-01, 1.042227e-02},
 {-1.688561e-01, 1.037613e-02},{-1.584800e-01, 1.032530e-02},{-1.481547e-01, 1.026978e-02},{-1.378849e-01, 1.020953e-02},
 {-1.276754e-01, 1.014456e-02},{-1.175308e-01, 1.007486e-02},{-1.074560e-01, 1.000043e-02},{-9.745552e-02, 9.921261e-03},
 {-8.753426e-02, 9.837369e-03},{-7.769690e-02, 9.748762e-03},{-6.794813e-02, 9.655455e-03},{-5.829268e-02, 9.557467e-03},
 {-4.873521e-02, 9.454819e-03},{-3.928039e-02, 9.347540e-03},{-2.993285e-02, 9.235661e-03},{-2.069719e-02, 9.119218e-03},
 {-1.157797e-02, 8.998250e-03},{-2.579721e-03, 8.872803e-03},{ 6.293082e-03, 8.742924e-03},{ 1.503601e-02, 8.608668e-03},
 { 2.364467e-02, 8.470092e-03},{ 3.211477e-02, 8.327257e-03},{ 4.044202e-02, 8.180230e-03},{ 4.862225e-02, 8.029082e-03},
 { 5.665133e-02, 7.873887e-03},{ 6.452522e-02, 7.714724e-03},{ 7.223994e-02, 7.551678e-03},{ 7.979162e-02, 7.384836e-03},
 { 8.717646e-02, 7.214289e-03},{ 9.439075e-02, 7.040134e-03},{ 1.014309e-01, 6.862471e-03},{ 1.082934e-01, 6.681403e-03},
 { 1.149748e-01, 6.497040e-03},{ 1.214718e-01, 6.309493e-03},{ 1.277813e-01, 6.118878e-03},{ 1.339002e-01, 5.925314e-03},
 { 1.398255e-01, 5.728925e-03},{ 1.455544e-01, 5.529837e-03},{ 1.510842e-01, 5.328182e-03},{ 1.564124e-01, 5.124093e-03},
 { 1.615365e-01, 4.917707e-03},{ 1.664542e-01, 4.709164e-03},{ 1.711634e-01, 4.498608e-03},{ 1.756620e-01, 4.286185e-03},
 { 1.799482e-01, 4.072044e-03},{ 1.840202e-01, 3.856338e-03},{ 1.878766e-01, 3.639220e-03},{ 1.915158e-01, 3.420847e-03},
 { 1.949366e-01, 3.201380e-03},{ 1.981380e-01, 2.980979e-03},{ 2.011190e-01, 2.759809e-03},{ 2.038788e-01, 2.538033e-03},
 { 2.064168e-01, 2.315820e-03},{ 2.087327e-01, 2.093338e-03},{ 2.108260e-01, 1.870758e-03},{ 2.126967e-01, 1.648250e-03},
 { 2.143450e-01, 1.425987e-03},{ 2.157710e-01, 1.204142e-03},{ 2.169751e-01, 9.828903e-04},{ 2.179580e-01, 7.624054e-04},
 { 2.187204e-01, 5.428626e-04},{ 2.192633e-01, 3.244372e-04},{ 2.195877e-01, 1.073044e-04},{ 2.196950e-01,-1.083607e-04},
 { 2.195867e-01,-3.223834e-04},{ 2.192643e-01,-5.345893e-04},{ 2.187297e-01,-7.448051e-04},{ 2.179849e-01,-9.528581e-04},
 { 2.170320e-01,-1.158577e-03},{ 2.158735e-01,-1.361791e-03},{ 2.145117e-01,-1.562332e-03},{ 2.129493e-01,-1.760033e-03},
 { 2.111893e-01,-1.954728e-03},{ 2.092346e-01,-2.146254e-03},{ 2.070883e-01,-2.334451e-03},{ 2.047539e-01,-2.519159e-03},
 { 2.022347e-01,-2.700223e-03},{ 1.995345e-01,-2.877490e-03},{ 1.966570e-01,-3.050809e-03},{ 1.936062e-01,-3.220034e-03},
 { 1.903862e-01,-3.385020e-03},{ 1.870011e-01,-3.545628e-03},{ 1.834555e-01,-3.701720e-03},{ 1.797538e-01,-3.853165e-03},
 { 1.759006e-01,-3.999833e-03},{ 1.719008e-01,-4.141601e-03},{ 1.677592e-01,-4.278347e-03},{ 1.634808e-01,-4.409957e-03},
 { 1.590709e-01,-4.536318e-03},{ 1.545346e-01,-4.657326e-03},{ 1.498772e-01,-4.772878e-03},{ 1.451044e-01,-4.882878e-03},
 { 1.402215e-01,-4.987236e-03},{ 1.352342e-01,-5.085865e-03},{ 1.301484e-01,-5.178686e-03},{ 1.249697e-01,-5.265624e-03},
 { 1.197041e-01,-5.346610e-03},{ 1.143575e-01,-5.421580e-03},{ 1.089359e-01,-5.490478e-03},{ 1.034454e-01,-5.553252e-03},
 { 9.789215e-02,-5.609856e-03},{ 9.228230e-02,-5.660253e-03},{ 8.662204e-02,-5.704409e-03},{ 8.091763e-02,-5.742298e-03},
 { 7.517534e-02,-5.773899e-03},{ 6.940144e-02,-5.799198e-03},{ 6.360224e-02,-5.818190e-03},{ 5.778405e-02,-5.830871e-03},
 { 5.195318e-02,-5.837249e-03},{ 4.611593e-02,-5.837336e-03},{ 4.027859e-02,-5.831150e-03},{ 3.444744e-02,-5.818717e-03},
 { 2.862873e-02,-5.800068e-03},{ 2.282866e-02,-5.775243e-03},{ 1.705341e-02,-5.744286e-03},{ 1.130913e-02,-5.707249e-03},
 { 5.601879e-03,-5.664190e-03},{-6.231132e-05,-5.615174e-03},{-5.677485e-03,-5.560270e-03},{-1.123776e-02,-5.499557e-03},
 {-1.673731e-02,-5.433119e-03},{-2.217043e-02,-5.361043e-03},{-2.753147e-02,-5.283428e-03},{-3.281490e-02,-5.200373e-03},
 {-3.801528e-02,-5.111988e-03},{-4.312726e-02,-5.018385e-03},{-4.814565e-02,-4.919685e-03},{-5.306533e-02,-4.816011e-03},
 {-5.788134e-02,-4.707495e-03},{-6.258884e-02,-4.594272e-03},{-6.718311e-02,-4.476483e-03},{-7.165960e-02,-4.354274e-03},
 {-7.601387e-02,-4.227797e-03},{-8.024167e-02,-4.097205e-03},{-8.433887e-02,-3.962661e-03},{-8.830153e-02,-3.824328e-03},
 {-9.212586e-02,-3.682375e-03},{-9.580824e-02,-3.536976e-03},{-9.934521e-02,-3.388306e-03},{-1.027335e-01,-3.236546e-03},
 {-1.059701e-01,-3.081880e-03},{-1.090519e-01,-2.924495e-03},{-1.119764e-01,-2.764580e-03},{-1.147410e-01,-2.602329e-03},
 {-1.173433e-01,-2.437937e-03},{-1.197813e-01,-2.271602e-03},{-1.220529e-01,-2.103523e-03},{-1.241564e-01,-1.933902e-03},
 {-1.260903e-01,-1.762942e-03},{-1.278533e-01,-1.590848e-03},{-1.294441e-01,-1.417827e-03},{-1.308619e-01,-1.244084e-03},
 {-1.321060e-01,-1.069828e-03},{-1.331758e-01,-8.952654e-04},{-1.340711e-01,-7.206053e-04},{-1.347917e-01,-5.460555e-04},
 {-1.353378e-01,-3.718236e-04},{-1.357096e-01,-1.981166e-04},{-1.359077e-01,-2.514079e-05},{-1.359328e-01, 1.468987e-04},
 {-1.357859e-01, 3.177981e-04},{-1.354682e-01, 4.873551e-04},{-1.349808e-01, 6.553695e-04},{-1.343254e-01, 8.216429e-04},
 {-1.335038e-01, 9.859795e-04},{-1.325178e-01, 1.148186e-03},{-1.313696e-01, 1.308071e-03},{-1.300615e-01, 1.465449e-03},
 {-1.285961e-01, 1.620134e-03},{-1.269760e-01, 1.771946e-03},{-1.252040e-01, 1.920708e-03},{-1.232833e-01, 2.066247e-03},
 {-1.212171e-01, 2.208395e-03},{-1.190087e-01, 2.346986e-03},{-1.166617e-01, 2.481863e-03},{-1.141798e-01, 2.612869e-03},
 {-1.115670e-01, 2.739854e-03},{-1.088271e-01, 2.862675e-03},{-1.059644e-01, 2.981192e-03},{-1.029832e-01, 3.095272e-03},
 {-9.988796e-02, 3.204785e-03},{-9.668317e-02, 3.309611e-03},{-9.337356e-02, 3.409634e-03},{-8.996393e-02, 3.504744e-03},
 {-8.645918e-02, 3.594837e-03},{-8.286435e-02, 3.679817e-03},{-7.918453e-02, 3.759594e-03},{-7.542493e-02, 3.834084e-03},
 {-7.159085e-02, 3.903211e-03},{-6.768764e-02, 3.966904e-03},{-6.372073e-02, 4.025103e-03},{-5.969563e-02, 4.077750e-03},
 {-5.561788e-02, 4.124798e-03},{-5.149308e-02, 4.166205e-03},{-4.732688e-02, 4.201939e-03},{-4.312494e-02, 4.231973e-03},
 {-3.889297e-02, 4.256287e-03},{-3.463668e-02, 4.274871e-03},{-3.036181e-02, 4.287720e-03},{-2.607409e-02, 4.294838e-03},
 {-2.177925e-02, 4.296236e-03},{-1.748302e-02, 4.291932e-03},{-1.319108e-02, 4.281951e-03},{-8.909133e-03, 4.266326e-03},
 {-4.642807e-03, 4.245099e-03},{-3.977078e-04, 4.218316e-03},{ 3.820608e-03, 4.186033e-03},{ 8.006641e-03, 4.148311e-03},
 { 1.215495e-02, 4.105219e-03},{ 1.626017e-02, 4.056833e-03},{ 2.031700e-02, 4.003237e-03},{ 2.432024e-02, 3.944518e-03},
 { 2.826476e-02, 3.880775e-03},{ 3.214553e-02, 3.812109e-03},{ 3.595764e-02, 3.738629e-03},{ 3.969627e-02, 3.660451e-03},
 { 4.335672e-02, 3.577695e-03},{ 4.693442e-02, 3.490489e-03},{ 5.042491e-02, 3.398965e-03},{ 5.382387e-02, 3.303263e-03},
 { 5.712713e-02, 3.203525e-03},{ 6.033066e-02, 3.099900e-03},{ 6.343056e-02, 2.992542e-03},{ 6.642310e-02, 2.881609e-03},
 { 6.930471e-02, 2.767264e-03},{ 7.207197e-02, 2.649675e-03},{ 7.472165e-02, 2.529013e-03},{ 7.725066e-02, 2.405453e-03},
 { 7.965612e-02, 2.279173e-03},{ 8.193529e-02, 2.150355e-03},{ 8.408564e-02, 2.019185e-03},{ 8.610483e-02, 1.885851e-03},
 { 8.799068e-02, 1.750542e-03},{ 8.974122e-02, 1.613451e-03},{ 9.135467e-02, 1.474774e-03},{ 9.282945e-02, 1.334707e-03},
 { 9.416415e-02, 1.193447e-03},{ 9.535760e-02, 1.051195e-03},{ 9.640880e-02, 9.081496e-04},{ 9.731695e-02, 7.645123e-04},
 { 9.808146e-02, 6.204842e-04},{ 9.870194e-02, 4.762668e-04},{ 9.917821e-02, 3.320610e-04},{ 9.951027e-02, 1.880676e-04},
 { 9.969834e-02, 4.448659e-05},{ 9.974282e-02,-9.848313e-05},{ 9.964434e-02,-2.406439e-04},{ 9.940370e-02,-3.817996e-04},
 { 9.902190e-02,-5.217560e-04},{ 9.850014e-02,-6.603209e-04},{ 9.783982e-02,-7.973046e-04},{ 9.704252e-02,-9.325199e-04},
 { 9.611000e-02,-1.065783e-03},{ 9.504421e-02,-1.196911e-03},{ 9.384730e-02,-1.325729e-03},{ 9.252157e-02,-1.452061e-03},
 { 9.106951e-02,-1.575738e-03},{ 8.949378e-02,-1.696593e-03},{ 8.779718e-02,-1.814464e-03},{ 8.598272e-02,-1.929196e-03},
 { 8.405352e-02,-2.040635e-03},{ 8.201289e-02,-2.148634e-03},{ 7.986425e-02,-2.253052e-03},{ 7.761120e-02,-2.353751e-03},
 { 7.525745e-02,-2.450601e-03},{ 7.280685e-02,-2.543476e-03},{ 7.026337e-02,-2.632258e-03},{ 6.763112e-02,-2.716832e-03},
 { 6.491428e-02,-2.797093e-03},{ 6.211719e-02,-2.872940e-03},{ 5.924425e-02,-2.944278e-03},{ 5.629997e-02,-3.011021e-03},
 { 5.328895e-02,-3.073089e-03},{ 5.021586e-02,-3.130407e-03},{ 4.708546e-02,-3.182910e-03},{ 4.390255e-02,-3.230537e-03},
 { 4.067201e-02,-3.273237e-03},{ 3.739877e-02,-3.310965e-03},{ 3.408781e-02,-3.343684e-03},{ 3.074412e-02,-3.371361e-03},
 { 2.737276e-02,-3.393976e-03},{ 2.397879e-02,-3.411512e-03},{ 2.056727e-02,-3.423961e-03},{ 1.714331e-02,-3.431321e-03},
 { 1.371199e-02,-3.433601e-03},{ 1.027839e-02,-3.430814e-03},{ 6.847576e-03,-3.422981e-03},{ 3.424596e-03,-3.410130e-03},
 { 1.446513e-05,-3.392299e-03},{-3.377834e-03,-3.369530e-03},{-6.747363e-03,-3.341872e-03},{-1.008924e-02,-3.309385e-03},
 {-1.339862e-02,-3.272131e-03},{-1.667075e-02,-3.230181e-03},{-1.990093e-02,-3.183615e-03},{-2.308455e-02,-3.132515e-03},
 {-2.621706e-02,-3.076974e-03},{-2.929404e-02,-3.017087e-03},{-3.231112e-02,-2.952959e-03},{-3.526408e-02,-2.884698e-03},
 {-3.814878e-02,-2.812421e-03},{-4.096120e-02,-2.736248e-03},{-4.369745e-02,-2.656305e-03},{-4.635375e-02,-2.572723e-03},
 {-4.892648e-02,-2.485641e-03},{-5.141212e-02,-2.395198e-03},{-5.380732e-02,-2.301542e-03},{-5.610886e-02,-2.204823e-03},
 {-5.831368e-02,-2.105196e-03},{-6.041888e-02,-2.002819e-03},{-6.242170e-02,-1.897856e-03},{-6.431955e-02,-1.790471e-03},
 {-6.611002e-02,-1.680835e-03},{-6.779086e-02,-1.569119e-03},{-6.935998e-02,-1.455498e-03},{-7.081548e-02,-1.340149e-03},
 {-7.215563e-02,-1.223252e-03},{-7.337888e-02,-1.104988e-03},{-7.448387e-02,-9.855400e-04},{-7.546941e-02,-8.650916e-04},
 {-7.633450e-02,-7.438283e-04},{-7.707833e-02,-6.219361e-04},{-7.770026e-02,-4.996015e-04},{-7.819986e-02,-3.770112e-04},
 {-7.857688e-02,-2.543517e-04},{-7.883123e-02,-1.318093e-04},{-7.896304e-02,-9.569588e-06},{-7.897261e-02, 1.121828e-04},
 {-7.886042e-02, 2.332644e-04},{-7.862716e-02, 3.534933e-04},{-7.827367e-02, 4.726891e-04},{-7.780098e-02, 5.906737e-04},
 {-7.721030e-02, 7.072711e-04},{-7.650303e-02, 8.223081e-04},{-7.568072e-02, 9.356139e-04},{-7.474511e-02, 1.047021e-03},
 {-7.369809e-02, 1.156366e-03},{-7.254172e-02, 1.263487e-03},{-7.127824e-02, 1.368228e-03},{-6.991001e-02, 1.470436e-03},
 {-6.843957e-02, 1.569962e-03},{-6.686961e-02, 1.666663e-03},{-6.520295e-02, 1.760399e-03},{-6.344255e-02, 1.851036e-03},
 {-6.159151e-02, 1.938444e-03},{-5.965307e-02, 2.022500e-03},{-5.763057e-02, 2.103084e-03},{-5.552748e-02, 2.180084e-03},
 {-5.334740e-02, 2.253393e-03},{-5.109401e-02, 2.322908e-03},{-4.877110e-02, 2.388537e-03},{-4.638256e-02, 2.450188e-03},
 {-4.393237e-02, 2.507781e-03},{-4.142459e-02, 2.561239e-03},{-3.886335e-02, 2.610492e-03},{-3.625286e-02, 2.655478e-03},
 {-3.359738e-02, 2.696141e-03},{-3.090124e-02, 2.732432e-03},{-2.816881e-02, 2.764308e-03},{-2.540450e-02, 2.791735e-03},
 {-2.261277e-02, 2.814683e-03},{-1.979808e-02, 2.833133e-03},{-1.696495e-02, 2.847069e-03},{-1.411788e-02, 2.856484e-03},
 {-1.126140e-02, 2.861379e-03},{-8.400018e-03, 2.861761e-03},{-5.538257e-03, 2.857643e-03},{-2.680614e-03, 2.849046e-03},
 { 1.684323e-04, 2.835999e-03},{ 3.004431e-03, 2.818536e-03},{ 5.822968e-03, 2.796699e-03},{ 8.619667e-03, 2.770536e-03},
 { 1.139020e-02, 2.740103e-03},{ 1.413031e-02, 2.705460e-03},{ 1.683577e-02, 2.666676e-03},{ 1.950244e-02, 2.623826e-03},
 { 2.212627e-02, 2.576989e-03},{ 2.470326e-02, 2.526252e-03},{ 2.722951e-02, 2.471709e-03},{ 2.970122e-02, 2.413456e-03},
 { 3.211467e-02, 2.351599e-03},{ 3.446627e-02, 2.286246e-03},{ 3.675252e-02, 2.217511e-03},{ 3.897003e-02, 2.145515e-03},
 { 4.111555e-02, 2.070382e-03},{ 4.318593e-02, 1.992240e-03},{ 4.517817e-02, 1.911223e-03},{ 4.708939e-02, 1.827469e-03},
 { 4.891686e-02, 1.741120e-03},{ 5.065798e-02, 1.652320e-03},{ 5.231030e-02, 1.561219e-03},{ 5.387152e-02, 1.467968e-03},
 { 5.533949e-02, 1.372723e-03},{ 5.671221e-02, 1.275642e-03},{ 5.798785e-02, 1.176886e-03},{ 5.916474e-02, 1.076616e-03},
 { 6.024135e-02, 9.749974e-04},{ 6.121635e-02, 8.721971e-04},{ 6.208855e-02, 7.683826e-04},{ 6.285693e-02, 6.637229e-04},
 { 6.352065e-02, 5.583879e-04},{ 6.407904e-02, 4.525483e-04},{ 6.453159e-02, 3.463750e-04},{ 6.487796e-02, 2.400389e-04},
 { 6.511800e-02, 1.337111e-04},{ 6.525171e-02, 2.756183e-05},{ 6.527928e-02,-7.823919e-05},{ 6.520104e-02,-1.835233e-04},
 { 6.501751e-02,-2.881230e-04},{ 6.472939e-02,-3.918725e-04},{ 6.433752e-02,-4.946077e-04},{ 6.384291e-02,-5.961665e-04},
 { 6.324674e-02,-6.963891e-04},{ 6.255036e-02,-7.951184e-04},{ 6.175524e-02,-8.922001e-04},{ 6.086304e-02,-9.874827e-04},
 { 5.987555e-02,-1.080818e-03},{ 5.879474e-02,-1.172062e-03},{ 5.762267e-02,-1.261074e-03},{ 5.636160e-02,-1.347716e-03},
 { 5.501388e-02,-1.431857e-03},{ 5.358203e-02,-1.513367e-03},{ 5.206866e-02,-1.592124e-03},{ 5.047653e-02,-1.668008e-03},
 { 4.880853e-02,-1.740905e-03},{ 4.706762e-02,-1.810707e-03},{ 4.525691e-02,-1.877310e-03},{ 4.337960e-02,-1.940615e-03},
 { 4.143899e-02,-2.000530e-03},{ 3.943846e-02,-2.056969e-03},{ 3.738149e-02,-2.109851e-03},{ 3.527164e-02,-2.159100e-03},
 { 3.311254e-02,-2.204648e-03},{ 3.090789e-02,-2.246432e-03},{ 2.866146e-02,-2.284395e-03},{ 2.637707e-02,-2.318488e-03},
 { 2.405858e-02,-2.348667e-03},{ 2.170991e-02,-2.374895e-03},{ 1.933501e-02,-2.397141e-03},{ 1.693787e-02,-2.415382e-03},
 { 1.452249e-02,-2.429599e-03},{ 1.209289e-02,-2.439782e-03},{ 9.653112e-03,-2.445926e-03},{ 7.207186e-03,-2.448035e-03},
 { 4.759151e-03,-2.446117e-03},{ 2.313034e-03,-2.440187e-03},{-1.271528e-04,-2.430268e-03},{-2.557420e-03,-2.416387e-03},
 {-4.973808e-03,-2.398581e-03},{-7.372389e-03,-2.376890e-03},{-9.749278e-03,-2.351361e-03},{-1.210064e-02,-2.322049e-03},
 {-1.442269e-02,-2.289013e-03},{-1.671170e-02,-2.252318e-03},{-1.896402e-02,-2.212037e-03},{-2.117606e-02,-2.168246e-03},
 {-2.334430e-02,-2.121028e-03},{-2.546533e-02,-2.070472e-03},{-2.753580e-02,-2.016671e-03},{-2.955247e-02,-1.959723e-03},
 {-3.151220e-02,-1.899731e-03},{-3.341193e-02,-1.836806e-03},{-3.524873e-02,-1.771057e-03},{-3.701979e-02,-1.702604e-03},
 {-3.872239e-02,-1.631568e-03},{-4.035396e-02,-1.558073e-03},{-4.191203e-02,-1.482248e-03},{-4.339428e-02,-1.404226e-03},
 {-4.479851e-02,-1.324144e-03},{-4.612265e-02,-1.242139e-03},{-4.736479e-02,-1.158353e-03},{-4.852314e-02,-1.072931e-03},
 {-4.959608e-02,-9.860185e-04},{-5.058209e-02,-8.977650e-04},{-5.147986e-02,-8.083209e-04},{-5.228818e-02,-7.178380e-04},
 {-5.300602e-02,-6.264698e-04},{-5.363249e-02,-5.343709e-04},{-5.416686e-02,-4.416964e-04},{-5.460855e-02,-3.486023e-04},
 {-5.495716e-02,-2.552447e-04},{-5.521240e-02,-1.617797e-04},{-5.537418e-02,-6.836333e-05},{-5.544254e-02, 2.484897e-05},
 {-5.541770e-02, 1.177025e-04},{-5.529999e-02, 2.100434e-04},{-5.508995e-02, 3.017194e-04},{-5.478823e-02, 3.925794e-04},
 {-5.439565e-02, 4.824741e-04},{-5.391318e-02, 5.712564e-04},{-5.334192e-02, 6.587812e-04},{-5.268314e-02, 7.449060e-04},
 {-5.193823e-02, 8.294910e-04},{-5.110874e-02, 9.123993e-04},{-5.019634e-02, 9.934971e-04},{-4.920285e-02, 1.072654e-03},
 {-4.813019e-02, 1.149744e-03},{-4.698045e-02, 1.224642e-03},{-4.575581e-02, 1.297232e-03},{-4.445857e-02, 1.367396e-03},
 {-4.309118e-02, 1.435026e-03},{-4.165615e-02, 1.500015e-03},{-4.015614e-02, 1.562261e-03},{-3.859388e-02, 1.621669e-03},
 {-3.697221e-02, 1.678147e-03},{-3.529406e-02, 1.731609e-03},{-3.356245e-02, 1.781973e-03},{-3.178048e-02, 1.829165e-03},
 {-2.995131e-02, 1.873114e-03},{-2.807820e-02, 1.913756e-03},{-2.616444e-02, 1.951032e-03},{-2.421341e-02, 1.984890e-03},
 {-2.222852e-02, 2.015281e-03},{-2.021324e-02, 2.042166e-03},{-1.817107e-02, 2.065510e-03},{-1.610556e-02, 2.085283e-03},
 {-1.402028e-02, 2.101462e-03},{-1.191882e-02, 2.114031e-03},{-9.804787e-03, 2.122980e-03},{-7.681807e-03, 2.128303e-03},
 {-5.553504e-03, 2.130003e-03},{-3.423501e-03, 2.128086e-03},{-1.295415e-03, 2.122568e-03},{ 8.271530e-04, 2.113468e-03},
 { 2.940621e-03, 2.100811e-03},{ 5.041432e-03, 2.084631e-03},{ 7.126063e-03, 2.064963e-03},{ 9.191026e-03, 2.041853e-03},
 { 1.123288e-02, 2.015349e-03},{ 1.324823e-02, 1.985506e-03},{ 1.523373e-02, 1.952385e-03},{ 1.718612e-02, 1.916051e-03},
 { 1.910217e-02, 1.876575e-03},{ 2.097874e-02, 1.834034e-03},{ 2.281278e-02, 1.788509e-03},{ 2.460129e-02, 1.740086e-03},
 { 2.634137e-02, 1.688855e-03},{ 2.803023e-02, 1.634912e-03},{ 2.966514e-02, 1.578357e-03},{ 3.124350e-02, 1.519294e-03},
 { 3.276279e-02, 1.457830e-03},{ 3.422062e-02, 1.394077e-03},{ 3.561470e-02, 1.328150e-03},{ 3.694285e-02, 1.260168e-03},
 { 3.820302e-02, 1.190253e-03},{ 3.939327e-02, 1.118530e-03},{ 4.051180e-02, 1.045126e-03},{ 4.155693e-02, 9.701710e-04},
 { 4.252710e-02, 8.937982e-04},{ 4.342089e-02, 8.161417e-04},{ 4.423704e-02, 7.373380e-04},{ 4.497437e-02, 6.575250e-04},
 { 4.563190e-02, 5.768421e-04},{ 4.620874e-02, 4.954298e-04},{ 4.670417e-02, 4.134294e-04},{ 4.711760e-02, 3.309829e-04},
 { 4.744858e-02, 2.482327e-04},{ 4.769682e-02, 1.653214e-04},{ 4.786214e-02, 8.239146e-05},{ 4.794453e-02,-4.149821e-07},
 { 4.794411e-02,-8.295637e-05},{ 4.786116e-02,-1.650920e-04},{ 4.769607e-02,-2.466821e-04},{ 4.744938e-02,-3.275883e-04},
 { 4.712180e-02,-4.076738e-04},{ 4.671412e-02,-4.868034e-04},{ 4.622732e-02,-5.648441e-04},{ 4.566247e-02,-6.416648e-04},
 { 4.502081e-02,-7.171372e-04},{ 4.430367e-02,-7.911353e-04},{ 4.351254e-02,-8.635361e-04},{ 4.264900e-02,-9.342198e-04},
 { 4.171478e-02,-1.003070e-03},{ 4.071171e-02,-1.069972e-03},{ 3.964174e-02,-1.134819e-03},{ 3.850692e-02,-1.197502e-03},
 { 3.730942e-02,-1.257922e-03},{ 3.605150e-02,-1.315979e-03},{ 3.473552e-02,-1.371582e-03},{ 3.336393e-02,-1.424640e-03},
 { 3.193929e-02,-1.475071e-03},{ 3.046422e-02,-1.522793e-03},{ 2.894143e-02,-1.567733e-03},{ 2.737370e-02,-1.609822e-03},
 { 2.576388e-02,-1.648993e-03},{ 2.411488e-02,-1.685189e-03},{ 2.242969e-02,-1.718355e-03},{ 2.071134e-02,-1.748443e-03},
 { 1.896289e-02,-1.775408e-03},{ 1.718749e-02,-1.799214e-03},{ 1.538827e-02,-1.819828e-03},{ 1.356844e-02,-1.837224e-03},
 { 1.173122e-02,-1.851380e-03},{ 9.879840e-03,-1.862282e-03},{ 8.017558e-03,-1.869920e-03},{ 6.147638e-03,-1.874289e-03},
 { 4.273349e-03,-1.875392e-03},{ 2.397957e-03,-1.873236e-03},{ 5.247212e-04,-1.867833e-03},{-1.343112e-03,-1.859203e-03},
 {-3.202315e-03,-1.847369e-03},{-5.049684e-03,-1.832361e-03},{-6.882045e-03,-1.814215e-03},{-8.696260e-03,-1.792970e-03},
 {-1.048923e-02,-1.768672e-03},{-1.225790e-02,-1.741372e-03},{-1.399927e-02,-1.711126e-03},{-1.571040e-02,-1.677995e-03},
 {-1.738839e-02,-1.642044e-03},{-1.903044e-02,-1.603344e-03},{-2.063378e-02,-1.561971e-03},{-2.219575e-02,-1.518003e-03},
 {-2.371375e-02,-1.471524e-03},{-2.518528e-02,-1.422623e-03},{-2.660790e-02,-1.371391e-03},{-2.797929e-02,-1.317925e-03},
 {-2.929722e-02,-1.262323e-03},{-3.055954e-02,-1.204689e-03},{-3.176423e-02,-1.145129e-03},{-3.290936e-02,-1.083751e-03},
 {-3.399311e-02,-1.020669e-03},{-3.501378e-02,-9.559966e-04},{-3.596978e-02,-8.898517e-04},{-3.685963e-02,-8.223538e-04},
 {-3.768198e-02,-7.536244e-04},{-3.843561e-02,-6.837871e-04},{-3.911939e-02,-6.129670e-04},{-3.973236e-02,-5.412906e-04},
 {-4.027365e-02,-4.688855e-04},{-4.074254e-02,-3.958804e-04},{-4.113842e-02,-3.224046e-04},{-4.146082e-02,-2.485880e-04},
 {-4.170941e-02,-1.745606e-04},{-4.188397e-02,-1.004526e-04},{-4.198442e-02,-2.639401e-05},{-4.201082e-02, 4.748572e-05},
 {-4.196333e-02, 1.210577e-04},{-4.184227e-02, 1.941938e-04},{-4.164808e-02, 2.667673e-04},{-4.138131e-02, 3.386523e-04},
 {-4.104266e-02, 4.097249e-04},{-4.063293e-02, 4.798627e-04},{-4.015307e-02, 5.489453e-04},{-3.960413e-02, 6.168543e-04},
 {-3.898727e-02, 6.834740e-04},{-3.830380e-02, 7.486909e-04},{-3.755511e-02, 8.123945e-04},{-3.674271e-02, 8.744771e-04},
 {-3.586824e-02, 9.348341e-04},{-3.493340e-02, 9.933644e-04},{-3.394004e-02, 1.049970e-03},{-3.289007e-02, 1.104557e-03},
 {-3.178551e-02, 1.157035e-03},{-3.062848e-02, 1.207317e-03},{-2.942116e-02, 1.255322e-03},{-2.816584e-02, 1.300971e-03},
 {-2.686487e-02, 1.344189e-03},{-2.552068e-02, 1.384909e-03},{-2.413577e-02, 1.423065e-03},{-2.271270e-02, 1.458596e-03},
 {-2.125411e-02, 1.491449e-03},{-1.976266e-02, 1.521571e-03},{-1.824109e-02, 1.548919e-03},{-1.669217e-02, 1.573450e-03},
 {-1.511872e-02, 1.595131e-03},{-1.352359e-02, 1.613929e-03},{-1.190966e-02, 1.629821e-03},{-1.027983e-02, 1.642787e-03},
 {-8.637048e-03, 1.652810e-03},{-6.984238e-03, 1.659883e-03},{-5.324356e-03, 1.664000e-03},{-3.660356e-03, 1.665162e-03},
 {-1.995194e-03, 1.663376e-03},{-3.318177e-04, 1.658653e-03},{ 1.326835e-03, 1.651009e-03},{ 2.977844e-03, 1.640466e-03},
 { 4.618311e-03, 1.627051e-03},{ 6.245362e-03, 1.610795e-03},{ 7.856157e-03, 1.591734e-03},{ 9.447891e-03, 1.569911e-03},
 { 1.101780e-02, 1.545372e-03},{ 1.256317e-02, 1.518166e-03},{ 1.408134e-02, 1.488351e-03},{ 1.556969e-02, 1.455986e-03},
 { 1.702568e-02, 1.421134e-03},{ 1.844681e-02, 1.383866e-03},{ 1.983068e-02, 1.344253e-03},{ 2.117493e-02, 1.302373e-03},
 { 2.247730e-02, 1.258305e-03},{ 2.373561e-02, 1.212134e-03},{ 2.494774e-02, 1.163947e-03},{ 2.611169e-02, 1.113836e-03},
 { 2.722553e-02, 1.061895e-03},{ 2.828742e-02, 1.008220e-03},{ 2.929564e-02, 9.529131e-04},{ 3.024855e-02, 8.960754e-04},
 { 3.114463e-02, 8.378124e-04},{ 3.198244e-02, 7.782317e-04},{ 3.276067e-02, 7.174425e-04},{ 3.347812e-02, 6.555564e-04},
 { 3.413367e-02, 5.926862e-04},{ 3.472636e-02, 5.289465e-04},{ 3.525530e-02, 4.644529e-04},{ 3.571976e-02, 3.993223e-04},
 { 3.611908e-02, 3.336722e-04},{ 3.645275e-02, 2.676207e-04},{ 3.672037e-02, 2.012867e-04},{ 3.692166e-02, 1.347889e-04},
 { 3.705645e-02, 6.824612e-05},{ 3.712469e-02, 1.776987e-06},{ 3.712647e-02,-6.450032e-05},{ 3.706197e-02,-1.304683e-04},
 { 3.693150e-02,-1.960102e-04},{ 3.673549e-02,-2.610104e-04},{ 3.647448e-02,-3.253546e-04},{ 3.614913e-02,-3.889298e-04},
 { 3.576020e-02,-4.516248e-04},{ 3.530857e-02,-5.133301e-04},{ 3.479524e-02,-5.739385e-04},{ 3.422130e-02,-6.333447e-04},
 { 3.358796e-02,-6.914461e-04},{ 3.289651e-02,-7.481425e-04},{ 3.214837e-02,-8.033364e-04},{ 3.134504e-02,-8.569336e-04},
 { 3.048810e-02,-9.088426e-04},{ 2.957926e-02,-9.589752e-04},{ 2.862028e-02,-1.007247e-03},{ 2.761304e-02,-1.053576e-03},
 { 2.655946e-02,-1.097886e-03},{ 2.546157e-02,-1.140102e-03},{ 2.432147e-02,-1.180155e-03},{ 2.314132e-02,-1.217979e-03},
 { 2.192334e-02,-1.253513e-03},{ 2.066982e-02,-1.286699e-03},{ 1.938313e-02,-1.317484e-03},{ 1.806564e-02,-1.345819e-03},
 { 1.671982e-02,-1.371661e-03},{ 1.534816e-02,-1.394970e-03},{ 1.395319e-02,-1.415712e-03},{ 1.253748e-02,-1.433855e-03},
 { 1.110362e-02,-1.449376e-03},{ 9.654249e-03,-1.462252e-03},{ 8.191997e-03,-1.472468e-03},{ 6.719529e-03,-1.480013e-03},
 { 5.239516e-03,-1.484881e-03},{ 3.754635e-03,-1.487070e-03},{ 2.267565e-03,-1.486584e-03},{ 7.809807e-04,-1.483431e-03},
 {-7.024502e-04,-1.477623e-03},{-2.180073e-03,-1.469179e-03},{-3.649252e-03,-1.458120e-03},{-5.107373e-03,-1.444474e-03},
 {-6.551847e-03,-1.428272e-03},{-7.980119e-03,-1.409550e-03},{-9.389669e-03,-1.388349e-03},{-1.077802e-02,-1.364714e-03},
 {-1.214273e-02,-1.338692e-03},{-1.348142e-02,-1.310339e-03},{-1.479176e-02,-1.279710e-03},{-1.607147e-02,-1.246868e-03},
 {-1.731834e-02,-1.211877e-03},{-1.853022e-02,-1.174806e-03},{-1.970502e-02,-1.135727e-03},{-2.084075e-02,-1.094717e-03},
 {-2.193547e-02,-1.051853e-03},{-2.298732e-02,-1.007219e-03},{-2.399454e-02,-9.608996e-04},{-2.495544e-02,-9.129822e-04},
 {-2.586842e-02,-8.635577e-04},{-2.673198e-02,-8.127192e-04},{-2.754470e-02,-7.605621e-04},{-2.830526e-02,-7.071840e-04},
 {-2.901245e-02,-6.526843e-04},{-2.966513e-02,-5.971642e-04},{-3.026229e-02,-5.407265e-04},{-3.080302e-02,-4.834756e-04},
 {-3.128650e-02,-4.255168e-04},{-3.171201e-02,-3.669564e-04},{-3.207897e-02,-3.079019e-04},{-3.238687e-02,-2.484610e-04},
 {-3.263533e-02,-1.887420e-04},{-3.282407e-02,-1.288533e-04},{-3.295293e-02,-6.890368e-05},{-3.302183e-02,-9.001346e-06},
 {-3.303083e-02, 5.074565e-05},{-3.298009e-02, 1.102299e-04},{-3.286986e-02, 1.693446e-04},{-3.270051e-02, 2.279840e-04},
 {-3.247253e-02, 2.860435e-04},{-3.218649e-02, 3.434197e-04},{-3.184307e-02, 4.000109e-04},{-3.144306e-02, 4.557167e-04},
 {-3.098734e-02, 5.104391e-04},{-3.047690e-02, 5.640816e-04},{-2.991282e-02, 6.165501e-04},{-2.929627e-02, 6.677531e-04},
 {-2.862851e-02, 7.176012e-04},{-2.791091e-02, 7.660079e-04},{-2.714491e-02, 8.128896e-04},{-2.633202e-02, 8.581655e-04},
 {-2.547385e-02, 9.017580e-04},{-2.457209e-02, 9.435927e-04},{-2.362850e-02, 9.835987e-04},{-2.264490e-02, 1.021708e-03},
 {-2.162319e-02, 1.057858e-03},{-2.056533e-02, 1.091987e-03},{-1.947335e-02, 1.124039e-03},{-1.834931e-02, 1.153963e-03},
 {-1.719535e-02, 1.181708e-03},{-1.601364e-02, 1.207231e-03},{-1.480641e-02, 1.230492e-03},{-1.357591e-02, 1.251455e-03},
 {-1.232446e-02, 1.270087e-03},{-1.105437e-02, 1.286361e-03},{-9.768010e-03, 1.300255e-03},{-8.467755e-03, 1.311749e-03},
 {-7.156007e-03, 1.320828e-03},{-5.835178e-03, 1.327484e-03},{-4.507695e-03, 1.331709e-03},{-3.175986e-03, 1.333504e-03},
 {-1.842481e-03, 1.332872e-03},{-5.096091e-04, 1.329820e-03},{ 8.202106e-04, 1.324360e-03},{ 2.144571e-03, 1.316509e-03},
 { 3.461079e-03, 1.306287e-03},{ 4.767366e-03, 1.293719e-03},{ 6.061085e-03, 1.278835e-03},{ 7.339921e-03, 1.261668e-03},
 { 8.601589e-03, 1.242255e-03},{ 9.843844e-03, 1.220638e-03},{ 1.106448e-02, 1.196861e-03},{ 1.226134e-02, 1.170974e-03},
 { 1.343232e-02, 1.143030e-03},{ 1.457535e-02, 1.113085e-03},{ 1.568843e-02, 1.081198e-03},{ 1.676963e-02, 1.047434e-03},
 { 1.781706e-02, 1.011858e-03},{ 1.882892e-02, 9.745404e-04},{ 1.980346e-02, 9.355536e-04},{ 2.073902e-02, 8.949732e-04},
 { 2.163399e-02, 8.528773e-04},{ 2.248687e-02, 8.093467e-04},{ 2.329621e-02, 7.644645e-04},{ 2.406068e-02, 7.183161e-04},
 { 2.477899e-02, 6.709890e-04},{ 2.544998e-02, 6.225726e-04},{ 2.607256e-02, 5.731582e-04},{ 2.664571e-02, 5.228384e-04},
 { 2.716855e-02, 4.717074e-04},{ 2.764026e-02, 4.198606e-04},{ 2.806012e-02, 3.673946e-04},{ 2.842751e-02, 3.144067e-04},
 { 2.874192e-02, 2.609948e-04},{ 2.900292e-02, 2.072577e-04},{ 2.921017e-02, 1.532942e-04},{ 2.936347e-02, 9.920342e-05},
 { 2.946267e-02, 4.508440e-05},{ 2.950776e-02,-8.963992e-06},{ 2.949879e-02,-6.284327e-05},{ 2.943595e-02,-1.164555e-04},
 { 2.931949e-02,-1.697036e-04},{ 2.914979e-02,-2.224911e-04},{ 2.892730e-02,-2.747230e-04},{ 2.865258e-02,-3.263054e-04},
 { 2.832627e-02,-3.771456e-04},{ 2.794912e-02,-4.271529e-04},{ 2.752197e-02,-4.762381e-04},{ 2.704573e-02,-5.243139e-04},
 { 2.652142e-02,-5.712952e-04},{ 2.595012e-02,-6.170990e-04},{ 2.533303e-02,-6.616447e-04},{ 2.467138e-02,-7.048543e-04},
 { 2.396653e-02,-7.466524e-04},{ 2.321987e-02,-7.869662e-04},{ 2.243291e-02,-8.257260e-04},{ 2.160718e-02,-8.628651e-04},
 { 2.074432e-02,-8.983199e-04},{ 1.984600e-02,-9.320300e-04},{ 1.891397e-02,-9.639385e-04},{ 1.795003e-02,-9.939917e-04},
 { 1.695604e-02,-1.022140e-03},{ 1.593390e-02,-1.048336e-03},{ 1.488556e-02,-1.072538e-03},{ 1.381302e-02,-1.094706e-03},
 { 1.271832e-02,-1.114806e-03},{ 1.160351e-02,-1.132806e-03},{ 1.047071e-02,-1.148679e-03},{ 9.322026e-03,-1.162402e-03},
 { 8.159624e-03,-1.173955e-03},{ 6.985670e-03,-1.183322e-03},{ 5.802347e-03,-1.190494e-03},{ 4.611853e-03,-1.195461e-03},
 { 3.416392e-03,-1.198222e-03},{ 2.218170e-03,-1.198777e-03},{ 1.019393e-03,-1.197131e-03},{-1.777379e-04,-1.193293e-03},
 {-1.371030e-03,-1.187275e-03},{-2.558306e-03,-1.179096e-03},{-3.737401e-03,-1.168775e-03},{-4.906176e-03,-1.156337e-03},
 {-6.062513e-03,-1.141811e-03},{-7.204324e-03,-1.125230e-03},{-8.329554e-03,-1.106628e-03},{-9.436182e-03,-1.086047e-03},
 {-1.052223e-02,-1.063528e-03},{-1.158576e-02,-1.039118e-03},{-1.262487e-02,-1.012869e-03},{-1.363774e-02,-9.848312e-04},
 {-1.462257e-02,-9.550628e-04},{-1.557764e-02,-9.236227e-04},{-1.650126e-02,-8.905732e-04},{-1.739183e-02,-8.559794e-04},
 {-1.824781e-02,-8.199090e-04},{-1.906772e-02,-7.824324e-04},{-1.985015e-02,-7.436222e-04},{-2.059378e-02,-7.035534e-04},
 {-2.129733e-02,-6.623031e-04},{-2.195963e-02,-6.199503e-04},{-2.257958e-02,-5.765760e-04},{-2.315616e-02,-5.322627e-04},
 {-2.368842e-02,-4.870945e-04},{-2.417552e-02,-4.411567e-04},{-2.461667e-02,-3.945362e-04},{-2.501121e-02,-3.473203e-04},
 {-2.535853e-02,-2.995979e-04},{-2.565813e-02,-2.514579e-04},{-2.590959e-02,-2.029903e-04},{-2.611258e-02,-1.542851e-04},
 {-2.626686e-02,-1.054328e-04},{-2.637229e-02,-5.652358e-05},{-2.642882e-02,-7.647852e-06},{-2.643646e-02, 4.110447e-05},
 {-2.639536e-02, 8.964389e-05},{-2.630572e-02, 1.378815e-04},{-2.616784e-02, 1.857293e-04},{-2.598211e-02, 2.331001e-04},
 {-2.574901e-02, 2.799078e-04},{-2.546910e-02, 3.260676e-04},{-2.514303e-02, 3.714963e-04},{-2.477153e-02, 4.161120e-04},
 {-2.435542e-02, 4.598346e-04},{-2.389559e-02, 5.025859e-04},{-2.339300e-02, 5.442896e-04},{-2.284871e-02, 5.848716e-04},
 {-2.226384e-02, 6.242601e-04},{-2.163958e-02, 6.623857e-04},{-2.097719e-02, 6.991813e-04},{-2.027801e-02, 7.345827e-04},
 {-1.954343e-02, 7.685283e-04},{-1.877490e-02, 8.009593e-04},{-1.797394e-02, 8.318200e-04},{-1.714212e-02, 8.610576e-04},
 {-1.628107e-02, 8.886225e-04},{-1.539244e-02, 9.144684e-04},{-1.447797e-02, 9.385521e-04},{-1.353942e-02, 9.608340e-04},
 {-1.257859e-02, 9.812776e-04},{-1.159731e-02, 9.998503e-04},{-1.059746e-02, 1.016523e-03},{-9.580937e-03, 1.031269e-03},
 {-8.549668e-03, 1.044068e-03},{-7.505600e-03, 1.054900e-03},{-6.450699e-03, 1.063752e-03},{-5.386948e-03, 1.070611e-03},
 {-4.316337e-03, 1.075471e-03},{-3.240865e-03, 1.078328e-03},{-2.162537e-03, 1.079183e-03},{-1.083354e-03, 1.078038e-03},
 {-5.316064e-06, 1.074903e-03},{ 1.069586e-03, 1.069787e-03},{ 2.139373e-03, 1.062705e-03},{ 3.202079e-03, 1.053677e-03},
 { 4.255756e-03, 1.042724e-03},{ 5.298480e-03, 1.029872e-03},{ 6.328353e-03, 1.015149e-03},{ 7.343502e-03, 9.985886e-04},
 { 8.342091e-03, 9.802253e-04},{ 9.322316e-03, 9.600985e-04},{ 1.028241e-02, 9.382502e-04},{ 1.122066e-02, 9.147256e-04},
 { 1.213539e-02, 8.895727e-04},{ 1.302496e-02, 8.628426e-04},{ 1.388781e-02, 8.345892e-04},{ 1.472239e-02, 8.048689e-04},
 { 1.552726e-02, 7.737407e-04},{ 1.630100e-02, 7.412662e-04},{ 1.704227e-02, 7.075092e-04},{ 1.774978e-02, 6.725359e-04},
 { 1.842232e-02, 6.364142e-04},{ 1.905873e-02, 5.992144e-04},{ 1.965794e-02, 5.610083e-04},{ 2.021895e-02, 5.218696e-04},
 { 2.074082e-02, 4.818733e-04},{ 2.122270e-02, 4.410960e-04},{ 2.166379e-02, 3.996154e-04},{ 2.206341e-02, 3.575104e-04},
 { 2.242092e-02, 3.148608e-04},{ 2.273578e-02, 2.717473e-04},{ 2.300753e-02, 2.282511e-04},{ 2.323578e-02, 1.844540e-04},
 { 2.342023e-02, 1.404380e-04},{ 2.356067e-02, 9.628561e-05},{ 2.365695e-02, 5.207902e-05},{ 2.370903e-02, 7.900475e-06},
 { 2.371693e-02,-3.616805e-05},{ 2.368077e-02,-8.004503e-05},{ 2.360072e-02,-1.236495e-04},{ 2.347707e-02,-1.669012e-04},
 { 2.331017e-02,-2.097207e-04},{ 2.310045e-02,-2.520298e-04},{ 2.284842e-02,-2.937511e-04},{ 2.255467e-02,-3.348088e-04},
 { 2.221986e-02,-3.751284e-04},{ 2.184473e-02,-4.146369e-04},{ 2.143009e-02,-4.532631e-04},{ 2.097683e-02,-4.909377e-04},
 { 2.048589e-02,-5.275932e-04},{ 1.995830e-02,-5.631643e-04},{ 1.939514e-02,-5.975877e-04},{ 1.879755e-02,-6.308027e-04},
 { 1.816675e-02,-6.627507e-04},{ 1.750399e-02,-6.933757e-04},{ 1.681062e-02,-7.226245e-04},{ 1.608799e-02,-7.504464e-04},
 { 1.533755e-02,-7.767935e-04},{ 1.456075e-02,-8.016208e-04},{ 1.375913e-02,-8.248864e-04},{ 1.293425e-02,-8.465511e-04},
 { 1.208770e-02,-8.665791e-04},{ 1.122112e-02,-8.849376e-04},{ 1.033618e-02,-9.015969e-04},{ 9.434583e-03,-9.165307e-04},
 { 8.518052e-03,-9.297159e-04},{ 7.588336e-03,-9.411328e-04},{ 6.647203e-03,-9.507649e-04},{ 5.696438e-03,-9.585993e-04},
 { 4.737839e-03,-9.646262e-04},{ 3.773213e-03,-9.688394e-04},{ 2.804373e-03,-9.712359e-04},{ 1.833138e-03,-9.718164e-04},
 { 8.613211e-04,-9.705848e-04},{-1.092636e-04,-9.675482e-04},{-1.076812e-03,-9.627173e-04},{-2.039529e-03,-9.561061e-04},
 {-2.995635e-03,-9.477318e-04},{-3.943367e-03,-9.376147e-04},{-4.880982e-03,-9.257786e-04},{-5.806760e-03,-9.122503e-04},
 {-6.719011e-03,-8.970596e-04},{-7.616070e-03,-8.802394e-04},{-8.496310e-03,-8.618256e-04},{-9.358135e-03,-8.418568e-04},
 {-1.019999e-02,-8.203748e-04},{-1.102037e-02,-7.974235e-04},{-1.181779e-02,-7.730500e-04},{-1.259084e-02,-7.473036e-04},
 {-1.333814e-02,-7.202361e-04},{-1.405838e-02,-6.919017e-04},{-1.475028e-02,-6.623568e-04},{-1.541264e-02,-6.316597e-04},
 {-1.604430e-02,-5.998711e-04},{-1.664417e-02,-5.670532e-04},{-1.721122e-02,-5.332702e-04},{-1.774449e-02,-4.985877e-04},
 {-1.824308e-02,-4.630730e-04},{-1.870615e-02,-4.267948e-04},{-1.913295e-02,-3.898229e-04},{-1.952277e-02,-3.522282e-04},
 {-1.987500e-02,-3.140827e-04},{-2.018908e-02,-2.754592e-04},{-2.046454e-02,-2.364311e-04},{-2.070097e-02,-1.970725e-04},
 {-2.089804e-02,-1.574578e-04},{-2.105550e-02,-1.176618e-04},{-2.117316e-02,-7.775928e-05},{-2.125092e-02,-3.782518e-05},
 {-2.128875e-02, 2.065783e-06},{-2.128668e-02, 4.183918e-05},{-2.124484e-02, 8.142098e-05},{-2.116342e-02, 1.207377e-04},
 {-2.104269e-02, 1.597166e-04},{-2.088297e-02, 1.982857e-04},{-2.068468e-02, 2.363740e-04},{-2.044831e-02, 2.739116e-04},
 {-2.017440e-02, 3.108299e-04},{-1.986357e-02, 3.470615e-04},{-1.951651e-02, 3.825405e-04},{-1.913397e-02, 4.172026e-04},
 {-1.871676e-02, 4.509853e-04},{-1.826578e-02, 4.838278e-04},{-1.778195e-02, 5.156712e-04},{-1.726628e-02, 5.464588e-04},
 {-1.671982e-02, 5.761358e-04},{-1.614368e-02, 6.046498e-04},{-1.553903e-02, 6.319506e-04},{-1.490708e-02, 6.579905e-04},
 {-1.424909e-02, 6.827242e-04},{-1.356637e-02, 7.061092e-04},{-1.286026e-02, 7.281052e-04},{-1.213215e-02, 7.486751e-04},
 {-1.138348e-02, 7.677843e-04},{-1.061569e-02, 7.854010e-04},{-9.830294e-03, 8.014963e-04},{-9.028798e-03, 8.160445e-04},
 {-8.212753e-03, 8.290225e-04},{-7.383730e-03, 8.404105e-04},{-6.543320e-03, 8.501914e-04},{-5.693129e-03, 8.583515e-04},
 {-4.834777e-03, 8.648799e-04},{-3.969897e-03, 8.697691e-04},{-3.100128e-03, 8.730144e-04},{-2.227114e-03, 8.746143e-04},
 {-1.352499e-03, 8.745704e-04},{-4.779290e-04, 8.728874e-04},{ 3.949584e-04, 8.695730e-04},{ 1.264531e-03, 8.646381e-04},
 { 2.129169e-03, 8.580963e-04},{ 2.987266e-03, 8.499644e-04},{ 3.837230e-03, 8.402622e-04},{ 4.677492e-03, 8.290123e-04},
 { 5.506505e-03, 8.162400e-04},{ 6.322745e-03, 8.019736e-04},{ 7.124718e-03, 7.862440e-04},{ 7.910962e-03, 7.690849e-04},
 { 8.680047e-03, 7.505324e-04},{ 9.430580e-03, 7.306254e-04},{ 1.016121e-02, 7.094048e-04},{ 1.087061e-02, 6.869143e-04},
 { 1.155752e-02, 6.631995e-04},{ 1.222072e-02, 6.383086e-04},{ 1.285903e-02, 6.122914e-04},{ 1.347132e-02, 5.852000e-04},
 { 1.405652e-02, 5.570883e-04},{ 1.461361e-02, 5.280119e-04},{ 1.514162e-02, 4.980282e-04},{ 1.563965e-02, 4.671959e-04},
 { 1.610685e-02, 4.355754e-04},{ 1.654242e-02, 4.032283e-04},{ 1.694565e-02, 3.702174e-04},{ 1.731587e-02, 3.366066e-04},
 { 1.765248e-02, 3.024607e-04},{ 1.795494e-02, 2.678453e-04},{ 1.822278e-02, 2.328268e-04},{ 1.845561e-02, 1.974722e-04},
 { 1.865308e-02, 1.618488e-04},{ 1.881493e-02, 1.260244e-04},{ 1.894095e-02, 9.006684e-05},{ 1.903102e-02, 5.404407e-05},
 { 1.908506e-02, 1.802401e-05},{ 1.910309e-02,-1.792565e-05},{ 1.908516e-02,-5.373750e-05},{ 1.903143e-02,-8.934462e-05},
 { 1.894208e-02,-1.246806e-04},{ 1.881740e-02,-1.596798e-04},{ 1.865772e-02,-1.942774e-04},{ 1.846344e-02,-2.284093e-04},
 { 1.823503e-02,-2.620128e-04},{ 1.797302e-02,-2.950261e-04},{ 1.767800e-02,-3.273888e-04},{ 1.735061e-02,-3.590419e-04},
 { 1.699156e-02,-3.899277e-04},{ 1.660164e-02,-4.199904e-04},{ 1.618165e-02,-4.491757e-04},{ 1.573247e-02,-4.774312e-04},
 { 1.525504e-02,-5.047064e-04},{ 1.475033e-02,-5.309527e-04},{ 1.421938e-02,-5.561236e-04},{ 1.366326e-02,-5.801747e-04},
 { 1.308308e-02,-6.030641e-04},{ 1.248002e-02,-6.247519e-04},{ 1.185527e-02,-6.452007e-04},{ 1.121007e-02,-6.643755e-04},
 { 1.054569e-02,-6.822438e-04},{ 9.863446e-03,-6.987757e-04},{ 9.164670e-03,-7.139438e-04},{ 8.450726e-03,-7.277236e-04},
 { 7.723003e-03,-7.400929e-04},{ 6.982910e-03,-7.510324e-04},{ 6.231878e-03,-7.605257e-04},{ 5.471352e-03,-7.685591e-04},
 { 4.702793e-03,-7.751214e-04},{ 3.927671e-03,-7.802045e-04},{ 3.147467e-03,-7.838032e-04},{ 2.363664e-03,-7.859147e-04},
 { 1.577749e-03,-7.865395e-04},{ 7.912095e-04,-7.856805e-04},{ 5.529013e-06,-7.833437e-04},{-7.778147e-04,-7.795376e-04},
 {-1.557352e-03,-7.742736e-04},{-2.331626e-03,-7.675659e-04},{-3.099192e-03,-7.594311e-04},{-3.858623e-03,-7.498888e-04},
 {-4.608512e-03,-7.389608e-04},{-5.347472e-03,-7.266719e-04},{-6.074144e-03,-7.130491e-04},{-6.787194e-03,-6.981219e-04},
 {-7.485315e-03,-6.819221e-04},{-8.167237e-03,-6.644840e-04},{-8.831721e-03,-6.458441e-04},{-9.477566e-03,-6.260409e-04},
 {-1.010361e-02,-6.051152e-04},{-1.070872e-02,-5.831096e-04},{-1.129183e-02,-5.600688e-04},{-1.185190e-02,-5.360392e-04},
 {-1.238794e-02,-5.110690e-04},{-1.289901e-02,-4.852081e-04},{-1.338422e-02,-4.585078e-04},{-1.384272e-02,-4.310209e-04},
 {-1.427374e-02,-4.028016e-04},{-1.467655e-02,-3.739052e-04},{-1.505045e-02,-3.443883e-04},{-1.539484e-02,-3.143084e-04},
 {-1.570915e-02,-2.837238e-04},{-1.599287e-02,-2.526939e-04},{-1.624557e-02,-2.212785e-04},{-1.646684e-02,-1.895379e-04},
 {-1.665638e-02,-1.575332e-04},{-1.681392e-02,-1.253255e-04},{-1.693924e-02,-9.297619e-05},{-1.703222e-02,-6.054687e-05},
 {-1.709276e-02,-2.809900e-05},{-1.712086e-02, 4.306060e-06},{-1.711656e-02, 3.660721e-05},{-1.707995e-02, 6.874372e-05},
 {-1.701121e-02, 1.006553e-04},{-1.691055e-02, 1.322824e-04},{-1.677827e-02, 1.635660e-04},{-1.661470e-02, 1.944479e-04},
 {-1.642025e-02, 2.248711e-04},{-1.619538e-02, 2.547792e-04},{-1.594060e-02, 2.841173e-04},{-1.565649e-02, 3.128315e-04},
 {-1.534366e-02, 3.408693e-04},{-1.500279e-02, 3.681798e-04},{-1.463461e-02, 3.947134e-04},{-1.423989e-02, 4.204222e-04},
 {-1.381947e-02, 4.452599e-04},{-1.337421e-02, 4.691821e-04},{-1.290503e-02, 4.921462e-04},{-1.241288e-02, 5.141116e-04},
 {-1.189877e-02, 5.350397e-04},{-1.136373e-02, 5.548938e-04},{-1.080884e-02, 5.736396e-04},{-1.023520e-02, 5.912448e-04},
 {-9.643953e-03, 6.076793e-04},{-9.036274e-03, 6.229157e-04},{-8.413358e-03, 6.369284e-04},{-7.776430e-03, 6.496946e-04},
 {-7.126735e-03, 6.611937e-04},{-6.465542e-03, 6.714076e-04},{-5.794134e-03, 6.803209e-04},{-5.113813e-03, 6.879204e-04},
 {-4.425893e-03, 6.941955e-04},{-3.731697e-03, 6.991383e-04},{-3.032559e-03, 7.027434e-04},{-2.329815e-03, 7.050077e-04},
 {-1.624808e-03, 7.059309e-04},{-9.188768e-04, 7.055153e-04},{-2.133615e-04, 7.037655e-04},{ 4.904040e-04, 7.006888e-04},
 { 1.191093e-03, 6.962948e-04},{ 1.887388e-03, 6.905957e-04},{ 2.577983e-03, 6.836063e-04},{ 3.261590e-03, 6.753435e-04},
 { 3.936933e-03, 6.658266e-04},{ 4.602760e-03, 6.550775e-04},{ 5.257837e-03, 6.431200e-04},{ 5.900957e-03, 6.299805e-04},
 { 6.530938e-03, 6.156873e-04},{ 7.146625e-03, 6.002708e-04},{ 7.746896e-03, 5.837636e-04},{ 8.330659e-03, 5.662002e-04},
 { 8.896860e-03, 5.476169e-04},{ 9.444476e-03, 5.280521e-04},{ 9.972529e-03, 5.075457e-04},{ 1.048007e-02, 4.861392e-04},
 { 1.096621e-02, 4.638761e-04},{ 1.143009e-02, 4.408009e-04},{ 1.187089e-02, 4.169599e-04},{ 1.228785e-02, 3.924005e-04},
 { 1.268025e-02, 3.671715e-04},{ 1.304742e-02, 3.413225e-04},{ 1.338874e-02, 3.149046e-04},{ 1.370365e-02, 2.879694e-04},
 { 1.399162e-02, 2.605696e-04},{ 1.425219e-02, 2.327585e-04},{ 1.448495e-02, 2.045901e-04},{ 1.468954e-02, 1.761189e-04},
 { 1.486566e-02, 1.473999e-04},{ 1.501306e-02, 1.184881e-04},{ 1.513154e-02, 8.943908e-05},{ 1.522098e-02, 6.030834e-05},
 { 1.528129e-02, 3.115139e-05},{ 1.531244e-02, 2.023638e-06},{ 1.531447e-02,-2.701973e-05},{ 1.528745e-02,-5.592384e-05},
 { 1.523152e-02,-8.463426e-05},{ 1.514689e-02,-1.130971e-04},{ 1.503379e-02,-1.412590e-04},{ 1.489253e-02,-1.690674e-04},
 { 1.472347e-02,-1.964706e-04},{ 1.452699e-02,-2.234178e-04},{ 1.430358e-02,-2.498592e-04},{ 1.405372e-02,-2.757460e-04},
 { 1.377797e-02,-3.010309e-04},{ 1.347694e-02,-3.256675e-04},{ 1.315127e-02,-3.496110e-04},{ 1.280166e-02,-3.728180e-04},
 { 1.242884e-02,-3.952467e-04},{ 1.203360e-02,-4.168567e-04},{ 1.161674e-02,-4.376095e-04},{ 1.117913e-02,-4.574682e-04},
 { 1.072166e-02,-4.763978e-04},{ 1.024527e-02,-4.943651e-04},{ 9.750900e-03,-5.113388e-04},{ 9.239561e-03,-5.272896e-04},
 { 8.712272e-03,-5.421904e-04},{ 8.170081e-03,-5.560159e-04},{ 7.614065e-03,-5.687431e-04},{ 7.045322e-03,-5.803511e-04},
 { 6.464971e-03,-5.908213e-04},{ 5.874150e-03,-6.001371e-04},{ 5.274013e-03,-6.082843e-04},{ 4.665729e-03,-6.152509e-04},
 { 4.050478e-03,-6.210273e-04},{ 3.429450e-03,-6.256059e-04},{ 2.803844e-03,-6.289819e-04},{ 2.174863e-03,-6.311522e-04},
 { 1.543710e-03,-6.321165e-04},{ 9.115938e-04,-6.318766e-04},{ 2.797172e-04,-6.304365e-04},{-3.507192e-04,-6.278026e-04},
 {-9.785218e-04,-6.239835e-04},{-1.602505e-03,-6.189900e-04},{-2.221495e-03,-6.128353e-04},{-2.834331e-03,-6.055344e-04},
 {-3.439865e-03,-5.971049e-04},{-4.036970e-03,-5.875660e-04},{-4.624536e-03,-5.769393e-04},{-5.201475e-03,-5.652484e-04},
 {-5.766724e-03,-5.525187e-04},{-6.319242e-03,-5.387775e-04},{-6.858020e-03,-5.240541e-04},{-7.382074e-03,-5.083795e-04},
 {-7.890454e-03,-4.917864e-04},{-8.382240e-03,-4.743091e-04},{-8.856549e-03,-4.559836e-04},{-9.312533e-03,-4.368473e-04},
 {-9.749380e-03,-4.169392e-04},{-1.016632e-02,-3.962995e-04},{-1.056262e-02,-3.749697e-04},{-1.093759e-02,-3.529924e-04},
 {-1.129058e-02,-3.304116e-04},{-1.162099e-02,-3.072720e-04},{-1.192826e-02,-2.836195e-04},{-1.221188e-02,-2.595005e-04},
 {-1.247138e-02,-2.349625e-04},{-1.270635e-02,-2.100534e-04},{-1.291640e-02,-1.848219e-04},{-1.310122e-02,-1.593170e-04},
 {-1.326054e-02,-1.335880e-04},{-1.339413e-02,-1.076847e-04},{-1.350181e-02,-8.165692e-05},{-1.358347e-02,-5.555467e-05},
 {-1.363902e-02,-2.942787e-05},{-1.366845e-02,-3.326381e-06},{-1.367178e-02, 2.270015e-05},{-1.364908e-02, 4.860236e-05},
 {-1.360048e-02, 7.433128e-05},{-1.352614e-02, 9.983841e-05},{-1.342631e-02, 1.250758e-04},{-1.330123e-02, 1.499963e-04},
 {-1.315123e-02, 1.745532e-04},{-1.297668e-02, 1.987010e-04},{-1.277798e-02, 2.223948e-04},{-1.255558e-02, 2.455908e-04},
 {-1.230999e-02, 2.682465e-04},{-1.204175e-02, 2.903203e-04},{-1.175143e-02, 3.117718e-04},{-1.143965e-02, 3.325621e-04},
 {-1.110709e-02, 3.526536e-04},{-1.075444e-02, 3.720102e-04},{-1.038243e-02, 3.905971e-04},{-9.991832e-03, 4.083814e-04},
 {-9.583450e-03, 4.253316e-04},{-9.158119e-03, 4.414180e-04},{-8.716701e-03, 4.566125e-04},{-8.260088e-03, 4.708889e-04},
 {-7.789199e-03, 4.842228e-04},{-7.304977e-03, 4.965917e-04},{-6.808385e-03, 5.079750e-04},{-6.300410e-03, 5.183541e-04},
 {-5.782056e-03, 5.277122e-04},{-5.254344e-03, 5.360347e-04},{-4.718309e-03, 5.433088e-04},{-4.175000e-03, 5.495240e-04},
 {-3.625476e-03, 5.546718e-04},{-3.070804e-03, 5.587454e-04},{-2.512059e-03, 5.617407e-04},{-1.950318e-03, 5.636551e-04},
 {-1.386663e-03, 5.644884e-04},{-8.221748e-04, 5.642423e-04},{-2.579324e-04, 5.629208e-04},{ 3.049883e-04, 5.605296e-04},
 { 8.655179e-04, 5.570766e-04},{ 1.422595e-03, 5.525718e-04},{ 1.975166e-03, 5.470271e-04},{ 2.522193e-03, 5.404562e-04},
 { 3.062650e-03, 5.328749e-04},{ 3.595524e-03, 5.243008e-04},{ 4.119825e-03, 5.147535e-04},{ 4.634579e-03, 5.042542e-04},
 { 5.138833e-03, 4.928258e-04},{ 5.631659e-03, 4.804932e-04},{ 6.112152e-03, 4.672828e-04},{ 6.579435e-03, 4.532224e-04},
 { 7.032657e-03, 4.383417e-04},{ 7.470999e-03, 4.226715e-04},{ 7.893670e-03, 4.062444e-04},{ 8.299915e-03, 3.890941e-04},
 { 8.689009e-03, 3.712556e-04},{ 9.060264e-03, 3.527651e-04},{ 9.413030e-03, 3.336601e-04},{ 9.746690e-03, 3.139789e-04},
 { 1.006067e-02, 2.937610e-04},{ 1.035443e-02, 2.730466e-04},{ 1.062748e-02, 2.518771e-04},{ 1.087935e-02, 2.302941e-04},
 { 1.110965e-02, 2.083404e-04},{ 1.131799e-02, 1.860589e-04},{ 1.150405e-02, 1.634934e-04},{ 1.166754e-02, 1.406878e-04},
 { 1.180823e-02, 1.176866e-04},{ 1.192591e-02, 9.453417e-05},{ 1.202045e-02, 7.127542e-05},{ 1.209172e-02, 4.795510e-05},
 { 1.213968e-02, 2.461798e-05},{ 1.216430e-02, 1.308746e-06},{ 1.216561e-02,-2.192813e-05},{ 1.214368e-02,-4.504845e-05},
 { 1.209863e-02,-6.800836e-05},{ 1.203062e-02,-9.076447e-05},{ 1.193986e-02,-1.132739e-04},{ 1.182658e-02,-1.354944e-04},
 { 1.169109e-02,-1.573844e-04},{ 1.153370e-02,-1.789030e-04},{ 1.135480e-02,-2.000103e-04},{ 1.115479e-02,-2.206672e-04},
 { 1.093412e-02,-2.408357e-04},{ 1.069329e-02,-2.604786e-04},{ 1.043281e-02,-2.795602e-04},{ 1.015325e-02,-2.980456e-04},
 { 9.855203e-03,-3.159014e-04},{ 9.539302e-03,-3.330954e-04},{ 9.206206e-03,-3.495969e-04},{ 8.856609e-03,-3.653765e-04},
 { 8.491233e-03,-3.804063e-04},{ 8.110826e-03,-3.946599e-04},{ 7.716166e-03,-4.081126e-04},{ 7.308054e-03,-4.207410e-04},
 { 6.887313e-03,-4.325238e-04},{ 6.454789e-03,-4.434410e-04},{ 6.011348e-03,-4.534745e-04},{ 5.557874e-03,-4.626080e-04},
 { 5.095266e-03,-4.708268e-04},{ 4.624439e-03,-4.781182e-04},{ 4.146321e-03,-4.844711e-04},{ 3.661849e-03,-4.898764e-04},
 { 3.171973e-03,-4.943268e-04},{ 2.677646e-03,-4.978169e-04},{ 2.179829e-03,-5.003430e-04},{ 1.679486e-03,-5.019034e-04},
 { 1.177583e-03,-5.024982e-04},{ 6.750848e-04,-5.021293e-04},{ 1.729555e-04,-5.008007e-04},{-3.278452e-04,-4.985179e-04},
 {-8.263632e-04,-4.952884e-04},{-1.321652e-03,-4.911214e-04},{-1.812773e-03,-4.860279e-04},{-2.298801e-03,-4.800206e-04},
 {-2.778821e-03,-4.731141e-04},{-3.251935e-03,-4.653244e-04},{-3.717260e-03,-4.566694e-04},{-4.173929e-03,-4.471684e-04},
 {-4.621098e-03,-4.368423e-04},{-5.057940e-03,-4.257136e-04},{-5.483654e-03,-4.138063e-04},{-5.897460e-03,-4.011456e-04},
 {-6.298606e-03,-3.877584e-04},{-6.686364e-03,-3.736725e-04},{-7.060036e-03,-3.589172e-04},{-7.418954e-03,-3.435231e-04},
 {-7.762477e-03,-3.275217e-04},{-8.089998e-03,-3.109456e-04},{-8.400944e-03,-2.938284e-04},{-8.694772e-03,-2.762048e-04},
 {-8.970977e-03,-2.581102e-04},{-9.229087e-03,-2.395808e-04},{-9.468668e-03,-2.206536e-04},{-9.689322e-03,-2.013661e-04},
 {-9.890688e-03,-1.817565e-04},{-1.007244e-02,-1.618634e-04},{-1.023431e-02,-1.417259e-04},{-1.037603e-02,-1.213835e-04},
 {-1.049742e-02,-1.008758e-04},{-1.059829e-02,-8.024271e-05},{-1.067854e-02,-5.952417e-05},{-1.073806e-02,-3.876022e-05},
 {-1.077682e-02,-1.799083e-05},{-1.079481e-02, 2.744132e-06},{-1.079207e-02, 2.340501e-05},{-1.076866e-02, 4.395240e-05},
 {-1.072471e-02, 6.434726e-05},{-1.066036e-02, 8.455097e-05},{-1.057581e-02, 1.045254e-04},{-1.047129e-02, 1.242329e-04},
 {-1.034705e-02, 1.436367e-04},{-1.020342e-02, 1.627004e-04},{-1.004072e-02, 1.813886e-04},{-9.859327e-03, 1.996666e-04},
 {-9.659661e-03, 2.175009e-04},{-9.442160e-03, 2.348584e-04},{-9.207301e-03, 2.517076e-04},{-8.955594e-03, 2.680178e-04},
 {-8.687576e-03, 2.837594e-04},{-8.403816e-03, 2.989041e-04},{-8.104912e-03, 3.134248e-04},{-7.791488e-03, 3.272956e-04},
 {-7.464192e-03, 3.404922e-04},{-7.123700e-03, 3.529914e-04},{-6.770708e-03, 3.647714e-04},{-6.405937e-03, 3.758121e-04},
 {-6.030125e-03, 3.860947e-04},{-5.644030e-03, 3.956020e-04},{-5.248428e-03, 4.043182e-04},{-4.844110e-03, 4.122294e-04},
 {-4.431881e-03, 4.193229e-04},{-4.012558e-03, 4.255878e-04},{-3.586970e-03, 4.310149e-04},{-3.155955e-03, 4.355965e-04},
 {-2.720359e-03, 4.393266e-04},{-2.281032e-03, 4.422009e-04},{-1.838831e-03, 4.442167e-04},{-1.394614e-03, 4.453731e-04},
 {-9.492413e-04, 4.456706e-04},{-5.035708e-04, 4.451115e-04},{-5.845924e-05, 4.436998e-04},{ 3.852406e-04, 4.414411e-04},
 { 8.266816e-04, 4.383424e-04},{ 1.265024e-03, 4.344125e-04},{ 1.699437e-03, 4.296619e-04},{ 2.129098e-03, 4.241023e-04},
 { 2.553201e-03, 4.177472e-04},{ 2.970948e-03, 4.106113e-04},{ 3.381559e-03, 4.027111e-04},{ 3.784270e-03, 3.940644e-04},
 { 4.178335e-03, 3.846901e-04},{ 4.563025e-03, 3.746088e-04},{ 4.937634e-03, 3.638422e-04},{ 5.301476e-03, 3.524133e-04},
 { 5.653889e-03, 3.403464e-04},{ 5.994235e-03, 3.276667e-04},{ 6.321902e-03, 3.144007e-04},{ 6.636303e-03, 3.005758e-04},
 { 6.936879e-03, 2.862206e-04},{ 7.223099e-03, 2.713644e-04},{ 7.494464e-03, 2.560375e-04},{ 7.750501e-03, 2.402710e-04},
 { 7.990772e-03, 2.240965e-04},{ 8.214869e-03, 2.075467e-04},{ 8.422416e-03, 1.906546e-04},{ 8.613070e-03, 1.734539e-04},
 { 8.786524e-03, 1.559786e-04},{ 8.942503e-03, 1.382634e-04},{ 9.080766e-03, 1.203430e-04},{ 9.201109e-03, 1.022528e-04},
 { 9.303362e-03, 8.402801e-05},{ 9.387390e-03, 6.570419e-05},{ 9.453094e-03, 4.731692e-05},{ 9.500411e-03, 2.890180e-05},
 { 9.529313e-03, 1.049436e-05},{ 9.539807e-03,-7.870025e-06},{ 9.531937e-03,-2.615615e-05},{ 9.505781e-03,-4.432910e-05},
 { 9.461452e-03,-6.235429e-05},{ 9.399098e-03,-8.019754e-05},{ 9.318900e-03,-9.782511e-05},{ 9.221075e-03,-1.152038e-04},
 { 9.105871e-03,-1.323011e-04},{ 8.973570e-03,-1.490849e-04},{ 8.824485e-03,-1.655242e-04},{ 8.658961e-03,-1.815883e-04},
 { 8.477373e-03,-1.972476e-04},{ 8.280125e-03,-2.124734e-04},{ 8.067652e-03,-2.272379e-04},{ 7.840414e-03,-2.415142e-04},
 { 7.598899e-03,-2.552765e-04},{ 7.343623e-03,-2.685001e-04},{ 7.075123e-03,-2.811612e-04},{ 6.793962e-03,-2.932376e-04},
 { 6.500724e-03,-3.047079e-04},{ 6.196016e-03,-3.155521e-04},{ 5.880464e-03,-3.257515e-04},{ 5.554712e-03,-3.352887e-04},
 { 5.219424e-03,-3.441475e-04},{ 4.875276e-03,-3.523133e-04},{ 4.522963e-03,-3.597727e-04},{ 4.163190e-03,-3.665137e-04},
 { 3.796677e-03,-3.725259e-04},{ 3.424151e-03,-3.778001e-04},{ 3.046351e-03,-3.823288e-04},{ 2.664022e-03,-3.861058e-04},
 { 2.277916e-03,-3.891264e-04},{ 1.888790e-03,-3.913874e-04},{ 1.497402e-03,-3.928870e-04},{ 1.104515e-03,-3.936251e-04},
 { 7.108902e-04,-3.936028e-04},{ 3.172874e-04,-3.928228e-04},{-7.553536e-05,-3.912892e-04},{-4.668246e-04,-3.890076e-04},
 {-8.558321e-04,-3.859849e-04},{-1.241817e-03,-3.822296e-04},{-1.624047e-03,-3.777515e-04},{-2.001798e-03,-3.725616e-04},
 {-2.374360e-03,-3.666725e-04},{-2.741032e-03,-3.600979e-04},{-3.101130e-03,-3.528528e-04},{-3.453983e-03,-3.449537e-04},
 {-3.798937e-03,-3.364179e-04},{-4.135355e-03,-3.272642e-04},{-4.462619e-03,-3.175123e-04},{-4.780131e-03,-3.071832e-04},
 {-5.087314e-03,-2.962987e-04},{-5.383613e-03,-2.848818e-04},{-5.668495e-03,-2.729563e-04},{-5.941451e-03,-2.605471e-04},
 {-6.201998e-03,-2.476797e-04},{-6.449678e-03,-2.343806e-04},{-6.684058e-03,-2.206768e-04},{-6.904735e-03,-2.065964e-04},
 {-7.111332e-03,-1.921676e-04},{-7.303499e-03,-1.774196e-04},{-7.480919e-03,-1.623820e-04},{-7.643301e-03,-1.470848e-04},
 {-7.790386e-03,-1.315583e-04},{-7.921944e-03,-1.158333e-04},{-8.037777e-03,-9.994094e-05},{-8.137718e-03,-8.391237e-05},
 {-8.221631e-03,-6.777901e-05},{-8.289410e-03,-5.157237e-05},{-8.340982e-03,-3.532396e-05},{-8.376306e-03,-1.906529e-05},
 {-8.395371e-03,-2.827755e-06},{-8.398199e-03, 1.335738e-05},{-8.384842e-03, 2.945906e-05},{-8.355383e-03, 4.544651e-05},
 {-8.309936e-03, 6.128929e-05},{-8.248647e-03, 7.695733e-05},{-8.171689e-03, 9.242101e-05},{-8.079268e-03, 1.076512e-04},
 {-7.971617e-03, 1.226193e-04},{-7.848998e-03, 1.372974e-04},{-7.711700e-03, 1.516582e-04},{-7.560042e-03, 1.656751e-04},
 {-7.394367e-03, 1.793222e-04},{-7.215045e-03, 1.925745e-04},{-7.022470e-03, 2.054078e-04},{-6.817063e-03, 2.177988e-04},
 {-6.599264e-03, 2.297252e-04},{-6.369539e-03, 2.411656e-04},{-6.128373e-03, 2.520996e-04},{-5.876274e-03, 2.625080e-04},
 {-5.613766e-03, 2.723724e-04},{-5.341393e-03, 2.816758e-04},{-5.059717e-03, 2.904023e-04},{-4.769315e-03, 2.985369e-04},
 {-4.470778e-03, 3.060662e-04},{-4.164712e-03, 3.129777e-04},{-3.851734e-03, 3.192603e-04},{-3.532474e-03, 3.249040e-04},
 {-3.207570e-03, 3.299004e-04},{-2.877670e-03, 3.342420e-04},{-2.543428e-03, 3.379228e-04},{-2.205505e-03, 3.409381e-04},
 {-1.864567e-03, 3.432844e-04},{-1.521282e-03, 3.449595e-04},{-1.176323e-03, 3.459628e-04},{-8.303600e-04, 3.462945e-04},
 {-4.840655e-04, 3.459565e-04},{-1.381090e-04, 3.449519e-04},{ 2.068428e-04, 3.432849e-04},{ 5.501277e-04, 3.409612e-04},
 { 8.910890e-04, 3.379877e-04},{ 1.229077e-03, 3.343724e-04},{ 1.563449e-03, 3.301246e-04},{ 1.893574e-03, 3.252548e-04},
 { 2.218828e-03, 3.197747e-04},{ 2.538603e-03, 3.136970e-04},{ 2.852300e-03, 3.070358e-04},{ 3.159336e-03, 2.998058e-04},
 { 3.459142e-03, 2.920232e-04},{ 3.751165e-03, 2.837051e-04},{ 4.034870e-03, 2.748693e-04},{ 4.309739e-03, 2.655350e-04},
 { 4.575274e-03, 2.557219e-04},{ 4.830996e-03, 2.454508e-04},{ 5.076447e-03, 2.347431e-04},{ 5.311190e-03, 2.236212e-04},
 { 5.534811e-03, 2.121080e-04},{ 5.746919e-03, 2.002273e-04},{ 5.947147e-03, 1.880033e-04},{ 6.135150e-03, 1.754610e-04},
 { 6.310611e-03, 1.626258e-04},{ 6.473237e-03, 1.495235e-04},{ 6.622760e-03, 1.361805e-04},{ 6.758941e-03, 1.226234e-04},
 { 6.881564e-03, 1.088792e-04},{ 6.990443e-03, 9.497530e-05},{ 7.085419e-03, 8.093907e-05},{ 7.166358e-03, 6.679817e-05},
 { 7.233156e-03, 5.258035e-05},{ 7.285736e-03, 3.831337e-05},{ 7.324050e-03, 2.402504e-05},{ 7.348075e-03, 9.743070e-06},
 { 7.357818e-03,-4.504930e-06},{ 7.353313e-03,-1.869151e-05},{ 7.334621e-03,-3.278946e-05},{ 7.301832e-03,-4.677180e-05},
 { 7.255060e-03,-6.061192e-05},{ 7.194448e-03,-7.428354e-05},{ 7.120165e-03,-8.776083e-05},{ 7.032404e-03,-1.010184e-04},
 { 6.931385e-03,-1.140314e-04},{ 6.817354e-03,-1.267756e-04},{ 6.690578e-03,-1.392273e-04},{ 6.551351e-03,-1.513634e-04},
 { 6.399987e-03,-1.631617e-04},{ 6.236826e-03,-1.746005e-04},{ 6.062225e-03,-1.856590e-04},{ 5.876566e-03,-1.963172e-04},
 { 5.680249e-03,-2.065559e-04},{ 5.473693e-03,-2.163570e-04},{ 5.257336e-03,-2.257029e-04},{ 5.031633e-03,-2.345774e-04},
 { 4.797056e-03,-2.429649e-04},{ 4.554091e-03,-2.508511e-04},{ 4.303240e-03,-2.582224e-04},{ 4.045018e-03,-2.650666e-04},
 { 3.779951e-03,-2.713724e-04},{ 3.508579e-03,-2.771294e-04},{ 3.231449e-03,-2.823287e-04},{ 2.949120e-03,-2.869622e-04},
 { 2.662158e-03,-2.910231e-04},{ 2.371135e-03,-2.945055e-04},{ 2.076630e-03,-2.974050e-04},{ 1.779225e-03,-2.997180e-04},
 { 1.479507e-03,-3.014423e-04},{ 1.178064e-03,-3.025767e-04},{ 8.754875e-04,-3.031213e-04},{ 5.723662e-04,-3.030771e-04},
 { 2.692892e-04,-3.024464e-04},{-3.315724e-05,-3.012327e-04},{-3.343899e-04,-2.994405e-04},{-6.338305e-04,-2.970754e-04},
 {-9.309059e-04,-2.941442e-04},{-1.225050e-03,-2.906546e-04},{-1.515705e-03,-2.866155e-04},{-1.802320e-03,-2.820368e-04},
 {-2.084357e-03,-2.769293e-04},{-2.361286e-03,-2.713051e-04},{-2.632591e-03,-2.651768e-04},{-2.897768e-03,-2.585583e-04},
 {-3.156326e-03,-2.514642e-04},{-3.407791e-03,-2.439101e-04},{-3.651701e-03,-2.359124e-04},{-3.887613e-03,-2.274881e-04},
 {-4.115101e-03,-2.186554e-04},{-4.333756e-03,-2.094327e-04},{-4.543189e-03,-1.998395e-04},{-4.743029e-03,-1.898958e-04},
 {-4.932925e-03,-1.796222e-04},{-5.112547e-03,-1.690397e-04},{-5.281586e-03,-1.581702e-04},{-5.439757e-03,-1.470358e-04},
 {-5.586792e-03,-1.356590e-04},{-5.722451e-03,-1.240629e-04},{-5.846514e-03,-1.122707e-04},{-5.958785e-03,-1.003062e-04},
 {-6.059091e-03,-8.819303e-05},{-6.147284e-03,-7.595538e-05},{-6.223240e-03,-6.361743e-05},{-6.286857e-03,-5.120349e-05},
 {-6.338061e-03,-3.873792e-05},{-6.376799e-03,-2.624511e-05},{-6.403044e-03,-1.374939e-05},{-6.416793e-03,-1.275020e-06},
 {-6.418068e-03, 1.115389e-05},{-6.406914e-03, 2.351340e-05},{-6.383401e-03, 3.577980e-05},{-6.347621e-03, 4.792963e-05},
 {-6.299691e-03, 5.993977e-05},{-6.239752e-03, 7.178746e-05},{-6.167964e-03, 8.345031e-05},{-6.084514e-03, 9.490641e-05},
 {-5.989607e-03, 1.061343e-04},{-5.883473e-03, 1.171131e-04},{-5.766360e-03, 1.278224e-04},{-5.638538e-03, 1.382425e-04},
 {-5.500295e-03, 1.483543e-04},{-5.351941e-03, 1.581393e-04},{-5.193801e-03, 1.675798e-04},{-5.026222e-03, 1.766587e-04},
 {-4.849563e-03, 1.853599e-04},{-4.664203e-03, 1.936679e-04},{-4.470535e-03, 2.015681e-04},{-4.268967e-03, 2.090467e-04},
 {-4.059920e-03, 2.160909e-04},{-3.843829e-03, 2.226885e-04},{-3.621141e-03, 2.288286e-04},{-3.392312e-03, 2.345009e-04},
 {-3.157811e-03, 2.396963e-04},{-2.918115e-03, 2.444066e-04},{-2.673708e-03, 2.486243e-04},{-2.425084e-03, 2.523433e-04},
 {-2.172741e-03, 2.555583e-04},{-1.917183e-03, 2.582649e-04},{-1.658918e-03, 2.604599e-04},{-1.398458e-03, 2.621410e-04},
 {-1.136317e-03, 2.633069e-04},{-8.730098e-04, 2.639573e-04},{-6.090525e-04, 2.640930e-04},{-3.449595e-04, 2.637157e-04},
 {-8.124377e-05, 2.628282e-04},{ 1.815844e-04, 2.614341e-04},{ 4.430185e-04, 2.595381e-04},{ 7.025567e-04, 2.571459e-04},
 { 9.597026e-04, 2.542640e-04},{ 1.213967e-03, 2.508999e-04},{ 1.464867e-03, 2.470621e-04},{ 1.711929e-03, 2.427599e-04},
 { 1.954689e-03, 2.380033e-04},{ 2.192692e-03, 2.328035e-04},{ 2.425495e-03, 2.271723e-04},{ 2.652668e-03, 2.211223e-04},
 { 2.873790e-03, 2.146668e-04},{ 3.088457e-03, 2.078201e-04},{ 3.296277e-03, 2.005969e-04},{ 3.496874e-03, 1.930129e-04},
 { 3.689887e-03, 1.850840e-04},{ 3.874971e-03, 1.768271e-04},{ 4.051798e-03, 1.682596e-04},{ 4.220057e-03, 1.593992e-04},
 { 4.379457e-03, 1.502644e-04},{ 4.529721e-03, 1.408740e-04},{ 4.670595e-03, 1.312473e-04},{ 4.801842e-03, 1.214039e-04},
 { 4.923246e-03, 1.113638e-04},{ 5.034610e-03, 1.011472e-04},{ 5.135757e-03, 9.077486e-05},{ 5.226532e-03, 8.026742e-05},
 { 5.306799e-03, 6.964587e-05},{ 5.376445e-03, 5.893132e-05},{ 5.435377e-03, 4.814497e-05},{ 5.483522e-03, 3.730809e-05},
 { 5.520830e-03, 2.644194e-05},{ 5.547272e-03, 1.556778e-05},{ 5.562839e-03, 4.706787e-06},{ 5.567546e-03,-6.119970e-06},
 { 5.561426e-03,-1.689157e-05},{ 5.544535e-03,-2.758727e-05},{ 5.516947e-03,-3.818657e-05},{ 5.478761e-03,-4.866925e-05},
 { 5.430092e-03,-5.901535e-05},{ 5.371076e-03,-6.920532e-05},{ 5.301871e-03,-7.921992e-05},{ 5.222651e-03,-8.904040e-05},
 { 5.133611e-03,-9.864840e-05},{ 5.034962e-03,-1.080261e-04},{ 4.926936e-03,-1.171561e-04},{ 4.809780e-03,-1.260217e-04},
 { 4.683758e-03,-1.346067e-04},{ 4.549152e-03,-1.428954e-04},{ 4.406256e-03,-1.508731e-04},{ 4.255383e-03,-1.585252e-04},
 { 4.096858e-03,-1.658383e-04},{ 3.931020e-03,-1.727996e-04},{ 3.758220e-03,-1.793967e-04},{ 3.578823e-03,-1.856184e-04},
 { 3.393205e-03,-1.914541e-04},{ 3.201751e-03,-1.968940e-04},{ 3.004857e-03,-2.019289e-04},{ 2.802928e-03,-2.065509e-04},
 { 2.596377e-03,-2.107524e-04},{ 2.385625e-03,-2.145271e-04},{ 2.171097e-03,-2.178693e-04},{ 1.953228e-03,-2.207742e-04},
 { 1.732454e-03,-2.232379e-04},{ 1.509216e-03,-2.252575e-04},{ 1.283959e-03,-2.268307e-04},{ 1.057128e-03,-2.279564e-04},
 { 8.291715e-04,-2.286340e-04},{ 6.005374e-04,-2.288642e-04},{ 3.716733e-04,-2.286482e-04},{ 1.430251e-04,-2.279883e-04},
 {-8.496315e-05,-2.268875e-04},{-3.118507e-04,-2.253498e-04},{-5.372005e-04,-2.233800e-04},{-7.605805e-04,-2.209836e-04},
 {-9.815641e-04,-2.181671e-04},{-1.199731e-03,-2.149375e-04},{-1.414669e-03,-2.113030e-04},{-1.625972e-03,-2.072721e-04},
 {-1.833244e-03,-2.028544e-04},{-2.036098e-03,-1.980601e-04},{-2.234158e-03,-1.928999e-04},{-2.427058e-03,-1.873855e-04},
 {-2.614444e-03,-1.815291e-04},{-2.795973e-03,-1.753434e-04},{-2.971316e-03,-1.688418e-04},{-3.140158e-03,-1.620383e-04},
 {-3.302196e-03,-1.549474e-04},{-3.457144e-03,-1.475840e-04},{-3.604728e-03,-1.399637e-04},{-3.744691e-03,-1.321023e-04},
 {-3.876794e-03,-1.240162e-04},{-4.000810e-03,-1.157219e-04},{-4.116532e-03,-1.072366e-04},{-4.223768e-03,-9.857758e-05},
 {-4.322346e-03,-8.976237e-05},{-4.412108e-03,-8.080882e-05},{-4.492917e-03,-7.173495e-05},{-4.564652e-03,-6.255895e-05},
 {-4.627211e-03,-5.329913e-05},{-4.680510e-03,-4.397388e-05},{-4.724484e-03,-3.460165e-05},{-4.759086e-03,-2.520090e-05},
 {-4.784287e-03,-1.579009e-05},{-4.800077e-03,-6.387600e-06},{-4.806464e-03, 2.988264e-06},{-4.803476e-03, 1.231933e-05},
 {-4.791157e-03, 2.158759e-05},{-4.769569e-03, 3.077523e-05},{-4.738794e-03, 3.986466e-05},{-4.698929e-03, 4.883856e-05},
 {-4.650091e-03, 5.767991e-05},{-4.592411e-03, 6.637201e-05},{-4.526039e-03, 7.489852e-05},{-4.451140e-03, 8.324351e-05},
 {-4.367897e-03, 9.139143e-05},{-4.276505e-03, 9.932722e-05},{-4.177178e-03, 1.070363e-04},{-4.070142e-03, 1.145045e-04},
 {-3.955637e-03, 1.217183e-04},{-3.833919e-03, 1.286647e-04},{-3.705254e-03, 1.353312e-04},{-3.569923e-03, 1.417061e-04},
 {-3.428217e-03, 1.477780e-04},{-3.280439e-03, 1.535363e-04},{-3.126903e-03, 1.589713e-04},{-2.967931e-03, 1.640735e-04},
 {-2.803858e-03, 1.688344e-04},{-2.635023e-03, 1.732462e-04},{-2.461777e-03, 1.773017e-04},{-2.284476e-03, 1.809945e-04},
 {-2.103481e-03, 1.843189e-04},{-1.919162e-03, 1.872699e-04},{-1.731892e-03, 1.898433e-04},{-1.542049e-03, 1.920357e-04},
 {-1.350013e-03, 1.938445e-04},{-1.156169e-03, 1.952676e-04},{-9.609011e-04, 1.963040e-04},{-7.645971e-04, 1.969532e-04},
 {-5.676440e-04, 1.972155e-04},{-3.704284e-04, 1.970922e-04},{-1.733362e-04, 1.965850e-04},{ 2.324886e-05, 1.956966e-04},
 { 2.189455e-04, 1.944303e-04},{ 4.133758e-04, 1.927902e-04},{ 6.061660e-04, 1.907810e-04},{ 7.969470e-04, 1.884082e-04},
 { 9.853552e-04, 1.856780e-04},{ 1.171033e-03, 1.825972e-04},{ 1.353630e-03, 1.791734e-04},{ 1.532804e-03, 1.754146e-04},
 { 1.708218e-03, 1.713296e-04},{ 1.879548e-03, 1.669278e-04},{ 2.046476e-03, 1.622191e-04},{ 2.208695e-03, 1.572140e-04},
 { 2.365909e-03, 1.519236e-04},{ 2.517832e-03, 1.463593e-04},{ 2.664192e-03, 1.405333e-04},{ 2.804725e-03, 1.344579e-04},
 { 2.939183e-03, 1.281462e-04},{ 3.067329e-03, 1.216115e-04},{ 3.188941e-03, 1.148674e-04},{ 3.303808e-03, 1.079281e-04},
 { 3.411736e-03, 1.008080e-04},{ 3.512544e-03, 9.352166e-05},{ 3.606066e-03, 8.608411e-05},{ 3.692150e-03, 7.851050e-05},
 { 3.770660e-03, 7.081623e-05},{ 3.841477e-03, 6.301684e-05},{ 3.904494e-03, 5.512802e-05},{ 3.959622e-03, 4.716558e-05},
 { 4.006787e-03, 3.914540e-05},{ 4.045933e-03, 3.108338e-05},{ 4.077016e-03, 2.299549e-05},{ 4.100011e-03, 1.489762e-05},
 { 4.114909e-03, 6.805659e-06},{ 4.121715e-03,-1.264601e-06},{ 4.120450e-03,-9.297479e-06},{ 4.111153e-03,-1.727743e-05},
 { 4.093875e-03,-2.518908e-05},{ 4.068686e-03,-3.301725e-05},{ 4.035669e-03,-4.074700e-05},{ 3.994922e-03,-4.836364e-05},
 { 3.946558e-03,-5.585275e-05},{ 3.890705e-03,-6.320025e-05},{ 3.827505e-03,-7.039238e-05},{ 3.757113e-03,-7.741573e-05},
 { 3.679697e-03,-8.425731e-05},{ 3.595440e-03,-9.090452e-05},{ 3.504535e-03,-9.734520e-05},{ 3.407190e-03,-1.035676e-04},
 { 3.303622e-03,-1.095606e-04},{ 3.194062e-03,-1.153134e-04},{ 3.078748e-03,-1.208157e-04},{ 2.957933e-03,-1.260580e-04},
 { 2.831875e-03,-1.310311e-04},{ 2.700844e-03,-1.357264e-04},{ 2.565117e-03,-1.401359e-04},{ 2.424981e-03,-1.442523e-04},
 { 2.280729e-03,-1.480688e-04},{ 2.132660e-03,-1.515791e-04},{ 1.981081e-03,-1.547779e-04},{ 1.826303e-03,-1.576601e-04},
 { 1.668643e-03,-1.602215e-04},{ 1.508422e-03,-1.624585e-04},{ 1.345963e-03,-1.643682e-04},{ 1.181595e-03,-1.659481e-04},
 { 1.015647e-03,-1.671967e-04},{ 8.484501e-04,-1.681130e-04},{ 6.803371e-04,-1.686966e-04},{ 5.116404e-04,-1.689479e-04},
 { 3.426925e-04,-1.688677e-04},{ 1.738248e-04,-1.684578e-04},{ 5.367026e-06,-1.677203e-04},{-1.623533e-04,-1.666581e-04},
 {-3.290114e-04,-1.652748e-04},{-4.942862e-04,-1.635744e-04},{-6.578606e-04,-1.615617e-04},{-8.194222e-04,-1.592419e-04},
 {-9.786642e-04,-1.566211e-04},{-1.135285e-03,-1.537055e-04},{-1.288991e-03,-1.505023e-04},{-1.439493e-03,-1.470189e-04},
 {-1.586512e-03,-1.432635e-04},{-1.729775e-03,-1.392445e-04},{-1.869020e-03,-1.349711e-04},{-2.003991e-03,-1.304526e-04},
 {-2.134444e-03,-1.256991e-04},{-2.260143e-03,-1.207209e-04},{-2.380864e-03,-1.155287e-04},{-2.496392e-03,-1.101336e-04},
 {-2.606526e-03,-1.045471e-04},{-2.711073e-03,-9.878098e-05},{-2.809854e-03,-9.284736e-05},{-2.902701e-03,-8.675859e-05},
 {-2.989460e-03,-8.052729e-05},{-3.069987e-03,-7.416629e-05},{-3.144154e-03,-6.768864e-05},{-3.211842e-03,-6.110753e-05},
 {-3.272950e-03,-5.443633e-05},{-3.327386e-03,-4.768851e-05},{-3.375075e-03,-4.087764e-05},{-3.415952e-03,-3.401733e-05},
 {-3.449969e-03,-2.712126e-05},{-3.477091e-03,-2.020309e-05},{-3.497294e-03,-1.327648e-05},{-3.510570e-03,-6.355058e-06},
 {-3.516925e-03, 5.476502e-07},{-3.516378e-03, 7.418193e-06},{-3.508960e-03, 1.424325e-05},{-3.494716e-03, 2.100964e-05},
 {-3.473707e-03, 2.770437e-05},{-3.446002e-03, 3.431463e-05},{-3.411688e-03, 4.082784e-05},{-3.370860e-03, 4.723167e-05},
 {-3.323628e-03, 5.351405e-05},{-3.270114e-03, 5.966322e-05},{-3.210451e-03, 6.566771e-05},{-3.144783e-03, 7.151640e-05},
 {-3.073267e-03, 7.719852e-05},{-2.996068e-03, 8.270367e-05},{-2.913365e-03, 8.802187e-05},{-2.825343e-03, 9.314352e-05},
 {-2.732199e-03, 9.805946e-05},{-2.634140e-03, 1.027610e-04},{-2.531379e-03, 1.072398e-04},{-2.424139e-03, 1.114882e-04},
 {-2.312651e-03, 1.154989e-04},{-2.197152e-03, 1.192650e-04},{-2.077887e-03, 1.227802e-04},{-1.955107e-03, 1.260389e-04},
 {-1.829068e-03, 1.290358e-04},{-1.700032e-03, 1.317662e-04},{-1.568266e-03, 1.342259e-04},{-1.434040e-03, 1.364114e-04},
 {-1.297628e-03, 1.383195e-04},{-1.159309e-03, 1.399479e-04},{-1.019361e-03, 1.412946e-04},{-8.780663e-04, 1.423582e-04},
 {-7.357082e-04, 1.431379e-04},{-5.925703e-04, 1.436335e-04},{-4.489368e-04, 1.438453e-04},{-3.050915e-04, 1.437742e-04},
 {-1.613174e-04, 1.434216e-04},{-1.789579e-05, 1.427895e-04},{ 1.248937e-04, 1.418804e-04},{ 2.667741e-04, 1.406973e-04},
 { 4.074714e-04, 1.392439e-04},{ 5.467153e-04, 1.375242e-04},{ 6.842395e-04, 1.355428e-04},{ 8.197823e-04, 1.333048e-04},
 { 9.530871e-04, 1.308158e-04},{ 1.083903e-03, 1.280817e-04},{ 1.211985e-03, 1.251092e-04},{ 1.337094e-03, 1.219050e-04},
 { 1.458999e-03, 1.184767e-04},{ 1.577476e-03, 1.148319e-04},{ 1.692307e-03, 1.109787e-04},{ 1.803286e-03, 1.069258e-04},
 { 1.910212e-03, 1.026820e-04},{ 2.012894e-03, 9.825643e-05},{ 2.111150e-03, 9.365873e-05},{ 2.204809e-03, 8.889867e-05},
 { 2.293708e-03, 8.398636e-05},{ 2.377694e-03, 7.893215e-05},{ 2.456626e-03, 7.374663e-05},{ 2.530373e-03, 6.844057e-05},
 { 2.598813e-03, 6.302497e-05},{ 2.661838e-03, 5.751097e-05},{ 2.719349e-03, 5.190986e-05},{ 2.771259e-03, 4.623304e-05},
 { 2.817492e-03, 4.049202e-05},{ 2.857984e-03, 3.469837e-05},{ 2.892683e-03, 2.886372e-05},{ 2.921546e-03, 2.299973e-05},
 { 2.944546e-03, 1.711806e-05},{ 2.961664e-03, 1.123034e-05},{ 2.972895e-03, 5.348169e-06},{ 2.978243e-03,-5.169117e-07},
 { 2.977726e-03,-6.353458e-06},{ 2.971372e-03,-1.215013e-05},{ 2.959222e-03,-1.789573e-05},{ 2.941326e-03,-2.357919e-05},
 { 2.917747e-03,-2.918964e-05},{ 2.888558e-03,-3.471638e-05},{ 2.853841e-03,-4.014895e-05},{ 2.813692e-03,-4.547710e-05},
 { 2.768215e-03,-5.069085e-05},{ 2.717524e-03,-5.578048e-05},{ 2.661744e-03,-6.073657e-05},{ 2.601007e-03,-6.555000e-05},
 { 2.535457e-03,-7.021197e-05},{ 2.465245e-03,-7.471402e-05},{ 2.390531e-03,-7.904806e-05},{ 2.311483e-03,-8.320635e-05},
 { 2.228277e-03,-8.718153e-05},{ 2.141095e-03,-9.096666e-05},{ 2.050129e-03,-9.455518e-05},{ 1.955574e-03,-9.794095e-05},
 { 1.857633e-03,-1.011183e-04},{ 1.756514e-03,-1.040819e-04},{ 1.652432e-03,-1.068270e-04},{ 1.545606e-03,-1.093491e-04},
 { 1.436256e-03,-1.116445e-04},{ 1.324612e-03,-1.137095e-04},{ 1.210902e-03,-1.155414e-04},{ 1.095361e-03,-1.171375e-04},
 { 9.782235e-04,-1.184958e-04},{ 8.597277e-04,-1.196149e-04},{ 7.401128e-04,-1.204935e-04},{ 6.196193e-04,-1.211312e-04},
 { 4.984880e-04,-1.215278e-04},{ 3.769602e-04,-1.216837e-04},{ 2.552765e-04,-1.215997e-04},{ 1.336768e-04,-1.212771e-04},
 { 1.239974e-05,-1.207177e-04},{-1.083180e-04,-1.199237e-04},{-2.282417e-04,-1.188978e-04},{-3.471395e-04,-1.176431e-04},
 {-4.647826e-04,-1.161632e-04},{-5.809459e-04,-1.144621e-04},{-6.954080e-04,-1.125441e-04},{-8.079521e-04,-1.104141e-04},
 {-9.183662e-04,-1.080773e-04},{-1.026443e-03,-1.055392e-04},{-1.131983e-03,-1.028059e-04},{-1.234789e-03,-9.988360e-05},
 {-1.334672e-03,-9.677901e-05},{-1.431451e-03,-9.349910e-05},{-1.524950e-03,-9.005118e-05},{-1.615002e-03,-8.644283e-05},
 {-1.701444e-03,-8.268193e-05},{-1.784126e-03,-7.877663e-05},{-1.862903e-03,-7.473530e-05},{-1.937638e-03,-7.056656e-05},
 {-2.008205e-03,-6.627923e-05},{-2.074484e-03,-6.188232e-05},{-2.136366e-03,-5.738503e-05},{-2.193751e-03,-5.279670e-05},
 {-2.246548e-03,-4.812680e-05},{-2.294675e-03,-4.338493e-05},{-2.338060e-03,-3.858077e-05},{-2.376641e-03,-3.372409e-05},
 {-2.410365e-03,-2.882472e-05},{-2.439189e-03,-2.389251e-05},{-2.463082e-03,-1.893733e-05},{-2.482019e-03,-1.396907e-05},
 {-2.495988e-03,-8.997583e-06},{-2.504986e-03,-4.032671e-06},{-2.509019e-03, 9.159088e-07},{-2.508103e-03, 5.838483e-06},
 {-2.502264e-03, 1.072548e-05},{-2.491539e-03, 1.556743e-05},{-2.475971e-03, 2.035502e-05},{-2.455616e-03, 2.507907e-05},
 {-2.430537e-03, 2.973059e-05},{-2.400807e-03, 3.430075e-05},{-2.366506e-03, 3.878094e-05},{-2.327725e-03, 4.316276e-05},
 {-2.284562e-03, 4.743807e-05},{-2.237124e-03, 5.159895e-05},{-2.185525e-03, 5.563775e-05},{-2.129887e-03, 5.954711e-05},
 {-2.070340e-03, 6.331995e-05},{-2.007020e-03, 6.694950e-05},{-1.940071e-03, 7.042931e-05},{-1.869641e-03, 7.375324e-05},
 {-1.795888e-03, 7.691551e-05},{-1.718973e-03, 7.991067e-05},{-1.639062e-03, 8.273363e-05},{-1.556328e-03, 8.537967e-05},
 {-1.470949e-03, 8.784444e-05},{-1.383104e-03, 9.012396e-05},{-1.292980e-03, 9.221467e-05},{-1.200766e-03, 9.411335e-05},
 {-1.106652e-03, 9.581721e-05},{-1.010835e-03, 9.732385e-05},{-9.135112e-04, 9.863126e-05},{-8.148800e-04, 9.973786e-05},
 {-7.151421e-04, 1.006424e-04},{-6.144997e-04, 1.013442e-04},{-5.131555e-04, 1.018428e-04},{-4.113126e-04, 1.021383e-04},
 {-3.091743e-04, 1.022310e-04},{-2.069434e-04, 1.021218e-04},{-1.048216e-04, 1.018119e-04},{-3.009721e-06, 1.013029e-04},
 { 9.829314e-05, 1.005968e-04},{ 1.988899e-04, 9.969592e-05},{ 2.985858e-04, 9.860311e-05},{ 3.971889e-04, 9.732142e-05},
 { 4.945104e-04, 9.585433e-05},{ 5.903647e-04, 9.420566e-05},{ 6.845703e-04, 9.237956e-05},{ 7.769499e-04, 9.038053e-05},
 { 8.673304e-04, 8.821338e-05},{ 9.555438e-04, 8.588322e-05},{ 1.041427e-03, 8.339547e-05},{ 1.124823e-03, 8.075583e-05},
 { 1.205578e-03, 7.797027e-05},{ 1.283549e-03, 7.504503e-05},{ 1.358594e-03, 7.198657e-05},{ 1.430580e-03, 6.880161e-05},
 { 1.499382e-03, 6.549708e-05},{ 1.564879e-03, 6.208010e-05},{ 1.626959e-03, 5.855798e-05},{ 1.685517e-03, 5.493821e-05},
 { 1.740455e-03, 5.122844e-05},{ 1.791684e-03, 4.743644e-05},{ 1.839120e-03, 4.357013e-05},{ 1.882690e-03, 3.963751e-05},
 { 1.922328e-03, 3.564669e-05},{ 1.957974e-03, 3.160585e-05},{ 1.989580e-03, 2.752323e-05},{ 2.017103e-03, 2.340711e-05},
 { 2.040511e-03, 1.926579e-05},{ 2.059776e-03, 1.510758e-05},{ 2.074884e-03, 1.094080e-05},{ 2.085825e-03, 6.773711e-06},
 { 2.092598e-03, 2.614567e-06},{ 2.095213e-03,-1.528455e-06},{ 2.093685e-03,-5.647246e-06},{ 2.088037e-03,-9.733785e-06},
 { 2.078304e-03,-1.378015e-05},{ 2.064523e-03,-1.777856e-05},{ 2.046745e-03,-2.172133e-05},{ 2.025024e-03,-2.560096e-05},
 { 1.999423e-03,-2.941009e-05},{ 1.970012e-03,-3.314156e-05},{ 1.936871e-03,-3.678836e-05},{ 1.900083e-03,-4.034373e-05},
 { 1.859739e-03,-4.380110e-05},{ 1.815938e-03,-4.715412e-05},{ 1.768784e-03,-5.039669e-05},{ 1.718387e-03,-5.352297e-05},
 { 1.664864e-03,-5.652736e-05},{ 1.608337e-03,-5.940454e-05},{ 1.548932e-03,-6.214947e-05},{ 1.486783e-03,-6.475739e-05},
 { 1.422025e-03,-6.722384e-05},{ 1.354801e-03,-6.954467e-05},{ 1.285257e-03,-7.171604e-05},{ 1.213541e-03,-7.373440e-05},
 { 1.139806e-03,-7.559655e-05},{ 1.064210e-03,-7.729960e-05},{ 9.869101e-04,-7.884101e-05},{ 9.080690e-04,-8.021855e-05},
 { 8.278505e-04,-8.143034e-05},{ 7.464202e-04,-8.247483e-05},{ 6.639453e-04,-8.335081e-05},{ 5.805945e-04,-8.405742e-05},
 { 4.965371e-04,-8.459413e-05},{ 4.119430e-04,-8.496076e-05},{ 3.269822e-04,-8.515745e-05},{ 2.418248e-04,-8.518470e-05},
 { 1.566401e-04,-8.504333e-05},{ 7.159674e-05,-8.473449e-05},{-1.313775e-05,-8.425965e-05},{-9.739740e-05,-8.362062e-05},
 {-1.810180e-04,-8.281952e-05},{-2.638375e-04,-8.185876e-05},{-3.456963e-04,-8.074109e-05},{-4.264374e-04,-7.946952e-05},
 {-5.059069e-04,-7.804739e-05},{-5.839543e-04,-7.647828e-05},{-6.604326e-04,-7.476608e-05},{-7.351987e-04,-7.291491e-05},
 {-8.081136e-04,-7.092918e-05},{-8.790427e-04,-6.881351e-05},{-9.478563e-04,-6.657278e-05},{-1.014429e-03,-6.421208e-05},
 {-1.078641e-03,-6.173671e-05},{-1.140378e-03,-5.915219e-05},{-1.199530e-03,-5.646420e-05},{-1.255994e-03,-5.367862e-05},
 {-1.309673e-03,-5.080147e-05},{-1.360474e-03,-4.783894e-05},{-1.408313e-03,-4.479736e-05},{-1.453111e-03,-4.168317e-05},
 {-1.494794e-03,-3.850291e-05},{-1.533297e-03,-3.526326e-05},{-1.568560e-03,-3.197094e-05},{-1.600531e-03,-2.863277e-05},
 {-1.629164e-03,-2.525560e-05},{-1.654419e-03,-2.184633e-05},{-1.676266e-03,-1.841191e-05},{-1.694677e-03,-1.495927e-05},
 {-1.709637e-03,-1.149537e-05},{-1.721132e-03,-8.027127e-06},{-1.729159e-03,-4.561457e-06},{-1.733721e-03,-1.105219e-06},
 {-1.734826e-03, 2.334775e-06},{-1.732491e-03, 5.751785e-06},{-1.726739e-03, 9.139151e-06},{-1.717600e-03, 1.249031e-05},
 {-1.705110e-03, 1.579879e-05},{-1.689311e-03, 1.905826e-05},{-1.670253e-03, 2.226250e-05},{-1.647990e-03, 2.540545e-05},
 {-1.622585e-03, 2.848118e-05},{-1.594104e-03, 3.148396e-05},{-1.562620e-03, 3.440820e-05},{-1.528212e-03, 3.724851e-05},
 {-1.490963e-03, 3.999970e-05},{-1.450963e-03, 4.265677e-05},{-1.408307e-03, 4.521496e-05},{-1.363092e-03, 4.766969e-05},
 {-1.315422e-03, 5.001666e-05},{-1.265405e-03, 5.225177e-05},{-1.213154e-03, 5.437116e-05},{-1.158782e-03, 5.637126e-05},
 {-1.102411e-03, 5.824872e-05},{-1.044162e-03, 6.000047e-05},{-9.841619e-04, 6.162369e-05},{-9.225382e-04, 6.311584e-05},
 {-8.594224e-04, 6.447467e-05},{-7.949477e-04, 6.569817e-05},{-7.292495e-04, 6.678465e-05},{-6.624649e-04, 6.773268e-05},
 {-5.947322e-04, 6.854110e-05},{-5.261911e-04, 6.920907e-05},{-4.569820e-04, 6.973601e-05},{-3.872460e-04, 7.012161e-05},
 {-3.171244e-04, 7.036589e-05},{-2.467585e-04, 7.046910e-05},{-1.762894e-04, 7.043181e-05},{-1.058576e-04, 7.025483e-05},
 {-3.560280e-05, 6.993927e-05},{ 3.433647e-05, 6.948650e-05},{ 1.038230e-04, 6.889817e-05},{ 1.727211e-04, 6.817616e-05},
 { 2.408973e-04, 6.732264e-05},{ 3.082199e-04, 6.634001e-05},{ 3.745599e-04, 6.523093e-05},{ 4.397909e-04, 6.399827e-05},
 { 5.037891e-04, 6.264516e-05},{ 5.664343e-04, 6.117495e-05},{ 6.276093e-04, 5.959118e-05},{ 6.872004e-04, 5.789762e-05},
 { 7.450981e-04, 5.609824e-05},{ 8.011963e-04, 5.419720e-05},{ 8.553935e-04, 5.219881e-05},{ 9.075923e-04, 5.010759e-05},
 { 9.576999e-04, 4.792820e-05},{ 1.005628e-03, 4.566546e-05},{ 1.051294e-03, 4.332433e-05},{ 1.094618e-03, 4.090988e-05},
 { 1.135528e-03, 3.842733e-05},{ 1.173955e-03, 3.588198e-05},{ 1.209837e-03, 3.327925e-05},{ 1.243116e-03, 3.062463e-05},
 { 1.273741e-03, 2.792369e-05},{ 1.301665e-03, 2.518206e-05},{ 1.326847e-03, 2.240541e-05},{ 1.349252e-03, 1.959948e-05},
 { 1.368852e-03, 1.677001e-05},{ 1.385622e-03, 1.392276e-05},{ 1.399544e-03, 1.106351e-05},{ 1.410608e-03, 8.198007e-06},
 { 1.418806e-03, 5.332003e-06},{ 1.424138e-03, 2.471210e-06},{ 1.426609e-03,-3.787026e-07},{ 1.426230e-03,-3.212114e-06},
 { 1.423018e-03,-6.023468e-06},{ 1.416995e-03,-8.807283e-06},{ 1.408188e-03,-1.155816e-05},{ 1.396629e-03,-1.427080e-05},
 { 1.382359e-03,-1.694001e-05},{ 1.365419e-03,-1.956069e-05},{ 1.345858e-03,-2.212790e-05},{ 1.323730e-03,-2.463681e-05},
 { 1.299093e-03,-2.708273e-05},{ 1.272010e-03,-2.946114e-05},{ 1.242549e-03,-3.176767e-05},{ 1.210782e-03,-3.399810e-05},
 { 1.176784e-03,-3.614842e-05},{ 1.140635e-03,-3.821477e-05},{ 1.102420e-03,-4.019349e-05},{ 1.062227e-03,-4.208113e-05},
 { 1.020146e-03,-4.387441e-05},{ 9.762713e-04,-4.557028e-05},{ 9.307010e-04,-4.716589e-05},{ 8.835351e-04,-4.865862e-05},
 { 8.348765e-04,-5.004605e-05},{ 7.848305e-04,-5.132600e-05},{ 7.335045e-04,-5.249651e-05},{ 6.810080e-04,-5.355584e-05},
 { 6.274521e-04,-5.450249e-05},{ 5.729496e-04,-5.533521e-05},{ 5.176144e-04,-5.605296e-05},{ 4.615615e-04,-5.665493e-05},
 { 4.049065e-04,-5.714059e-05},{ 3.477659e-04,-5.750958e-05},{ 2.902564e-04,-5.776184e-05},{ 2.324945e-04,-5.789749e-05},
 { 1.745970e-04,-5.791693e-05},{ 1.166801e-04,-5.782074e-05},{ 5.885935e-05,-5.760978e-05},{ 1.249573e-06,-5.728509e-05},
 {-5.603552e-05,-5.684796e-05},{-1.128835e-04,-5.629988e-05},{-1.691833e-04,-5.564257e-05},{-2.248259e-04,-5.487795e-05},
 {-2.797039e-04,-5.400813e-05},{-3.337120e-04,-5.303546e-05},{-3.867475e-04,-5.196244e-05},{-4.387099e-04,-5.079177e-05},
 {-4.895017e-04,-4.952634e-05},{-5.390280e-04,-4.816920e-05},{-5.871972e-04,-4.672358e-05},{-6.339208e-04,-4.519287e-05},
 {-6.791137e-04,-4.358059e-05},{-7.226942e-04,-4.189042e-05},{-7.645847e-04,-4.012618e-05},{-8.047108e-04,-3.829181e-05},
 {-8.430027e-04,-3.639137e-05},{-8.793940e-04,-3.442902e-05},{-9.138230e-04,-3.240903e-05},{-9.462321e-04,-3.033577e-05},
 {-9.765678e-04,-2.821368e-05},{-1.004782e-03,-2.604727e-05},{-1.030829e-03,-2.384113e-05},{-1.054670e-03,-2.159988e-05},
 {-1.076270e-03,-1.932822e-05},{-1.095598e-03,-1.703085e-05},{-1.112629e-03,-1.471251e-05},{-1.127341e-03,-1.237795e-05},
 {-1.139719e-03,-1.003194e-05},{-1.149751e-03,-7.679236e-06},{-1.157430e-03,-5.324576e-06},{-1.162755e-03,-2.972684e-06},
 {-1.165728e-03,-6.282492e-07},{-1.166356e-03, 1.704080e-06},{-1.164652e-03, 4.019706e-06},{-1.160632e-03, 6.314089e-06},
 {-1.154318e-03, 8.582758e-06},{-1.145735e-03, 1.082132e-05},{-1.134914e-03, 1.302546e-05},{-1.121889e-03, 1.519097e-05},
 {-1.106698e-03, 1.731373e-05},{-1.089384e-03, 1.938974e-05},{-1.069994e-03, 2.141509e-05},{-1.048579e-03, 2.338603e-05},
 {-1.025193e-03, 2.529892e-05},{-9.998941e-04, 2.715026e-05},{-9.727438e-04, 2.893668e-05},{-9.438072e-04, 3.065499e-05},
 {-9.131522e-04, 3.230213e-05},{-8.808500e-04, 3.387519e-05},{-8.469749e-04, 3.537147e-05},{-8.116034e-04, 3.678838e-05},
 {-7.748150e-04, 3.812356e-05},{-7.366915e-04, 3.937478e-05},{-6.973167e-04, 4.054002e-05},{-6.567767e-04, 4.161743e-05},
 {-6.151592e-04, 4.260537e-05},{-5.725539e-04, 4.350235e-05},{-5.290515e-04, 4.430709e-05},{-4.847444e-04, 4.501853e-05},
 {-4.397259e-04, 4.563575e-05},{-3.940901e-04, 4.615806e-05},{-3.479321e-04, 4.658495e-05},{-3.013471e-04, 4.691612e-05},
 {-2.544310e-04, 4.715145e-05},{-2.072796e-04, 4.729101e-05},{-1.599885e-04, 4.733508e-05},{-1.126535e-04, 4.728411e-05},
 {-6.536936e-05, 4.713874e-05},{-1.823062e-05, 4.689981e-05},{ 2.866919e-05, 4.656834e-05},{ 7.523753e-05, 4.614551e-05},
 { 1.213830e-04, 4.563270e-05},{ 1.670157e-04, 4.503146e-05},{ 2.120472e-04, 4.434350e-05},{ 2.563907e-04, 4.357069e-05},
 { 2.999614e-04, 4.271507e-05},{ 3.426765e-04, 4.177884e-05},{ 3.844553e-04, 4.076433e-05},{ 4.252196e-04, 3.967403e-05},
 { 4.648936e-04, 3.851056e-05},{ 5.034042e-04, 3.727669e-05},{ 5.406809e-04, 3.597528e-05},{ 5.766562e-04, 3.460934e-05},
 { 6.112655e-04, 3.318198e-05},{ 6.444475e-04, 3.169642e-05},{ 6.761439e-04, 3.015598e-05},{ 7.062999e-04, 2.856406e-05},
 { 7.348640e-04, 2.692416e-05},{ 7.617881e-04, 2.523984e-05},{ 7.870280e-04, 2.351474e-05},{ 8.105427e-04, 2.175256e-05},
 { 8.322953e-04, 1.995705e-05},{ 8.522523e-04, 1.813201e-05},{ 8.703843e-04, 1.628127e-05},{ 8.866656e-04, 1.440869e-05},
 { 9.010743e-04, 1.251817e-05},{ 9.135924e-04, 1.061360e-05},{ 9.242060e-04, 8.698889e-06},{ 9.329049e-04, 6.777939e-06},
 { 9.396829e-04, 4.854644e-06},{ 9.445375e-04, 2.932880e-06},{ 9.474704e-04, 1.016499e-06},{ 9.484869e-04,-8.906835e-07},
 { 9.475962e-04,-2.784889e-06},{ 9.448113e-04,-4.662387e-06},{ 9.401489e-04,-6.519505e-06},{ 9.336294e-04,-8.352629e-06},
 { 9.252768e-04,-1.015822e-05},{ 9.151186e-04,-1.193280e-05},{ 9.031858e-04,-1.367300e-05},{ 8.895128e-04,-1.537551e-05},
 { 8.741373e-04,-1.703713e-05},{ 8.571001e-04,-1.865477e-05},{ 8.384454e-04,-2.022542e-05},{ 8.182200e-04,-2.174621e-05},
 { 7.964737e-04,-2.321437e-05},{ 7.732594e-04,-2.462726e-05},{ 7.486321e-04,-2.598235e-05},{ 7.226498e-04,-2.727727e-05},
 { 6.953725e-04,-2.850976e-05},{ 6.668627e-04,-2.967771e-05},{ 6.371850e-04,-3.077915e-05},{ 6.064059e-04,-3.181225e-05},
 { 5.745936e-04,-3.277534e-05},{ 5.418183e-04,-3.366688e-05},{ 5.081514e-04,-3.448551e-05},{ 4.736659e-04,-3.523001e-05},
 { 4.384359e-04,-3.589932e-05},{ 4.025366e-04,-3.649252e-05},{ 3.660440e-04,-3.700888e-05},{ 3.290352e-04,-3.744780e-05},
 { 2.915874e-04,-3.780886e-05},{ 2.537785e-04,-3.809179e-05},{ 2.156867e-04,-3.829648e-05},{ 1.773902e-04,-3.842298e-05},
 { 1.389673e-04,-3.847149e-05},{ 1.004958e-04,-3.844237e-05},{ 6.205339e-05,-3.833615e-05},{ 2.371724e-05,-3.815349e-05},
 {-1.443624e-05,-3.789520e-05},{-5.233144e-05,-3.756225e-05},{-8.989369e-05,-3.715576e-05},{-1.270495e-04,-3.667698e-05},
 {-1.637264e-04,-3.612729e-05},{-1.998537e-04,-3.550823e-05},{-2.353620e-04,-3.482144e-05},{-2.701834e-04,-3.406871e-05},
 {-3.042521e-04,-3.325195e-05},{-3.375041e-04,-3.237318e-05},{-3.698772e-04,-3.143454e-05},{-4.013118e-04,-3.043827e-05},
 {-4.317501e-04,-2.938672e-05},{-4.611368e-04,-2.828233e-05},{-4.894191e-04,-2.712764e-05},{-5.165467e-04,-2.592528e-05},
 {-5.424720e-04,-2.467795e-05},{-5.671500e-04,-2.338844e-05},{-5.905384e-04,-2.205958e-05},{-6.125980e-04,-2.069429e-05},
 {-6.332923e-04,-1.929553e-05},{-6.525878e-04,-1.786633e-05},{-6.704541e-04,-1.640975e-05},{-6.868639e-04,-1.492887e-05},
 {-7.017928e-04,-1.342684e-05},{-7.152196e-04,-1.190681e-05},{-7.271264e-04,-1.037194e-05},{-7.374984e-04,-8.825415e-06},
 {-7.463238e-04,-7.270426e-06},{-7.535942e-04,-5.710156e-06},{-7.593044e-04,-4.147782e-06},{-7.634521e-04,-2.586466e-06},
 {-7.660386e-04,-1.029349e-06},{-7.670680e-04, 5.204537e-07},{-7.665475e-04, 2.059862e-06},{-7.644876e-04, 3.585833e-06},
 {-7.609018e-04, 5.095370e-06},{-7.558064e-04, 6.585528e-06},{-7.492209e-04, 8.053417e-06},{-7.411675e-04, 9.496210e-06},
 {-7.316713e-04, 1.091115e-05},{-7.207601e-04, 1.229554e-05},{-7.084646e-04, 1.364678e-05},{-6.948178e-04, 1.496235e-05},
 {-6.798555e-04, 1.623979e-05},{-6.636157e-04, 1.747677e-05},{-6.461389e-04, 1.867102e-05},{-6.274679e-04, 1.982040e-05},
 {-6.076475e-04, 2.092286e-05},{-5.867246e-04, 2.197645e-05},{-5.647482e-04, 2.297935e-05},{-5.417688e-04, 2.392982e-05},
 {-5.178390e-04, 2.482628e-05},{-4.930127e-04, 2.566723e-05},{-4.673455e-04, 2.645131e-05},{-4.408942e-04, 2.717729e-05},
 {-4.137169e-04, 2.784404e-05},{-3.858729e-04, 2.845058e-05},{-3.574223e-04, 2.899605e-05},{-3.284262e-04, 2.947971e-05},
 {-2.989465e-04, 2.990096e-05},{-2.690455e-04, 3.025933e-05},{-2.387862e-04, 3.055447e-05},{-2.082317e-04, 3.078617e-05},
 {-1.774456e-04, 3.095434e-05},{-1.464912e-04, 3.105903e-05},{-1.154322e-04, 3.110042e-05},{-8.433179e-05, 3.107879e-05},
 {-5.325300e-05, 3.099458e-05},{-2.225841e-05, 3.084834e-05},{ 8.589927e-06, 3.064073e-05},{ 3.923066e-05, 3.037255e-05},
 { 6.960322e-05, 3.004471e-05},{ 9.964793e-05, 2.965824e-05},{ 1.293062e-04, 2.921425e-05},{ 1.585204e-04, 2.871402e-05},
 { 1.872344e-04, 2.815888e-05},{ 2.153933e-04, 2.755030e-05},{ 2.429436e-04, 2.688982e-05},{ 2.698334e-04, 2.617910e-05},
 { 2.960125e-04, 2.541988e-05},{ 3.214324e-04, 2.461400e-05},{ 3.460464e-04, 2.376335e-05},{ 3.698098e-04, 2.286994e-05},
 { 3.926797e-04, 2.193584e-05},{ 4.146156e-04, 2.096317e-05},{ 4.355787e-04, 1.995415e-05},{ 4.555329e-04, 1.891103e-05},
 { 4.744439e-04, 1.783613e-05},{ 4.922800e-04, 1.673182e-05},{ 5.090119e-04, 1.560051e-05},{ 5.246124e-04, 1.444465e-05},
 { 5.390570e-04, 1.326673e-05},{ 5.523237e-04, 1.206928e-05},{ 5.643930e-04, 1.085483e-05},{ 5.752479e-04, 9.625936e-06},
 { 5.848738e-04, 8.385182e-06},{ 5.932590e-04, 7.135147e-06},{ 6.003941e-04, 5.878418e-06},{ 6.062725e-04, 4.617578e-06},
 { 6.108901e-04, 3.355203e-06},{ 6.142453e-04, 2.093858e-06},{ 6.163392e-04, 8.360894e-07},{ 6.171753e-04,-4.155802e-07},
 { 6.167597e-04,-1.658655e-06},{ 6.151010e-04,-2.890671e-06},{ 6.122104e-04,-4.109202e-06},{ 6.081012e-04,-5.311866e-06},
 { 6.027893e-04,-6.496326e-06},{ 5.962930e-04,-7.660294e-06},{ 5.886327e-04,-8.801541e-06},{ 5.798311e-04,-9.917897e-06},
 { 5.699132e-04,-1.100725e-05},{ 5.589060e-04,-1.206757e-05},{ 5.468384e-04,-1.309688e-05},{ 5.337415e-04,-1.409330e-05},
 { 5.196482e-04,-1.505499e-05},{ 5.045932e-04,-1.598024e-05},{ 4.886130e-04,-1.686739e-05},{ 4.717456e-04,-1.771489e-05},
 { 4.540307e-04,-1.852125e-05},{ 4.355095e-04,-1.928510e-05},{ 4.162244e-04,-2.000516e-05},{ 3.962192e-04,-2.068023e-05},
 { 3.755390e-04,-2.130924e-05},{ 3.542297e-04,-2.189118e-05},{ 3.323386e-04,-2.242517e-05},{ 3.099134e-04,-2.291043e-05},
 { 2.870029e-04,-2.334628e-05},{ 2.636567e-04,-2.373213e-05},{ 2.399245e-04,-2.406752e-05},{ 2.158570e-04,-2.435208e-05},
 { 1.915049e-04,-2.458554e-05},{ 1.669194e-04,-2.476776e-05},{ 1.421517e-04,-2.489867e-05},{ 1.172530e-04,-2.497835e-05},
 { 9.227463e-05,-2.500693e-05},{ 6.726770e-05,-2.498468e-05},{ 4.228302e-05,-2.491197e-05},{ 1.737105e-05,-2.478925e-05},
 {-7.418200e-06,-2.461708e-05},{-3.203528e-05,-2.439613e-05},{-5.643141e-05,-2.412714e-05},{-8.055855e-05,-2.381095e-05},
 {-1.043695e-04,-2.344851e-05},{-1.278180e-04,-2.304084e-05},{-1.508588e-04,-2.258904e-05},{-1.734479e-04,-2.209431e-05},
 {-1.955422e-04,-2.155793e-05},{-2.171001e-04,-2.098123e-05},{-2.380814e-04,-2.036564e-05},{-2.584470e-04,-1.971266e-05},
 {-2.781597e-04,-1.902383e-05},{-2.971835e-04,-1.830079e-05},{-3.154843e-04,-1.754522e-05},{-3.330295e-04,-1.675885e-05},
 {-3.497884e-04,-1.594347e-05},{-3.657318e-04,-1.510092e-05},{-3.808327e-04,-1.423307e-05},{-3.950658e-04,-1.334186e-05},
 {-4.084077e-04,-1.242923e-05},{-4.208369e-04,-1.149717e-05},{-4.323341e-04,-1.054770e-05},{-4.428818e-04,-9.582849e-06},
 {-4.524646e-04,-8.604679e-06},{-4.610693e-04,-7.615258e-06},{-4.686846e-04,-6.616666e-06},{-4.753012e-04,-5.610988e-06},
 {-4.809122e-04,-4.600311e-06},{-4.855125e-04,-3.586720e-06},{-4.890992e-04,-2.572291e-06},{-4.916715e-04,-1.559091e-06},
 {-4.932306e-04,-5.491691e-07},{-4.937798e-04, 4.554428e-07},{-4.933243e-04, 1.452738e-06},{-4.918716e-04, 2.440735e-06},
 {-4.894309e-04, 3.417487e-06},{-4.860134e-04, 4.381080e-06},{-4.816323e-04, 5.329638e-06},{-4.763027e-04, 6.261329e-06},
 {-4.700413e-04, 7.174367e-06},{-4.628670e-04, 8.067014e-06},{-4.548000e-04, 8.937584e-06},{-4.458624e-04, 9.784448e-06},
 {-4.360779e-04, 1.060603e-05},{-4.254719e-04, 1.140083e-05},{-4.140711e-04, 1.216740e-05},{-4.019037e-04, 1.290435e-05},
 {-3.889993e-04, 1.361038e-05},{-3.753889e-04, 1.428425e-05},{-3.611047e-04, 1.492478e-05},{-3.461799e-04, 1.553090e-05},
 {-3.306490e-04, 1.610158e-05},{-3.145474e-04, 1.663590e-05},{-2.979115e-04, 1.713299e-05},{-2.807785e-04, 1.759208e-05},
 {-2.631864e-04, 1.801248e-05},{-2.451740e-04, 1.839358e-05},{-2.267804e-04, 1.873485e-05},{-2.080455e-04, 1.903586e-05},
 {-1.890097e-04, 1.929625e-05},{-1.697134e-04, 1.951574e-05},{-1.501977e-04, 1.969415e-05},{-1.305035e-04, 1.983139e-05},
 {-1.106721e-04, 1.992743e-05},{-9.074472e-05, 1.998234e-05},{-7.076238e-05, 1.999627e-05},{-5.076611e-05, 1.996946e-05},
 {-3.079666e-05, 1.990221e-05},{-1.089444e-05, 1.979494e-05},{ 8.900493e-06, 1.964810e-05},{ 2.854859e-05, 1.946225e-05},
 { 4.801085e-05, 1.923803e-05},{ 6.724887e-05, 1.897612e-05},{ 8.622500e-05, 1.867732e-05},{ 1.049023e-04, 1.834245e-05},
 { 1.232448e-04, 1.797244e-05},{ 1.412172e-04, 1.756826e-05},{ 1.587855e-04, 1.713096e-05},{ 1.759164e-04, 1.666163e-05},
 { 1.925780e-04, 1.616144e-05},{ 2.087395e-04, 1.563162e-05},{ 2.243711e-04, 1.507341e-05},{ 2.394445e-04, 1.448816e-05},
 { 2.539327e-04, 1.387721e-05},{ 2.678099e-04, 1.324199e-05},{ 2.810519e-04, 1.258393e-05},{ 2.936358e-04, 1.190454e-05},
 { 3.055403e-04, 1.120533e-05},{ 3.167457e-04, 1.048786e-05},{ 3.272335e-04, 9.753693e-06},{ 3.369872e-04, 9.004447e-06},
 { 3.459917e-04, 8.241742e-06},{ 3.542334e-04, 7.467221e-06},{ 3.617006e-04, 6.682537e-06},{ 3.683832e-04, 5.889356e-06},
 { 3.742725e-04, 5.089350e-06},{ 3.793619e-04, 4.284194e-06},{ 3.836461e-04, 3.475562e-06},{ 3.871216e-04, 2.665126e-06},
 { 3.897868e-04, 1.854549e-06},{ 3.916413e-04, 1.045486e-06},{ 3.926868e-04, 2.395762e-07},{ 3.929264e-04,-5.615568e-07},
 { 3.923648e-04,-1.356310e-06},{ 3.910085e-04,-2.143105e-06},{ 3.888654e-04,-2.920387e-06},{ 3.859450e-04,-3.686632e-06},
 { 3.822584e-04,-4.440350e-06},{ 3.778180e-04,-5.180085e-06},{ 3.726379e-04,-5.904417e-06},{ 3.667335e-04,-6.611968e-06},
 { 3.601216e-04,-7.301405e-06},{ 3.528202e-04,-7.971438e-06},{ 3.448487e-04,-8.620827e-06},{ 3.362279e-04,-9.248379e-06},
 { 3.269795e-04,-9.852956e-06},{ 3.171266e-04,-1.043348e-05},{ 3.066931e-04,-1.098891e-05},{ 2.957042e-04,-1.151828e-05},
 { 2.841859e-04,-1.202069e-05},{ 2.721652e-04,-1.249527e-05},{ 2.596699e-04,-1.294126e-05},{ 2.467287e-04,-1.335791e-05},
 { 2.333708e-04,-1.374457e-05},{ 2.196262e-04,-1.410065e-05},{ 2.055255e-04,-1.442562e-05},{ 1.910999e-04,-1.471902e-05},
 { 1.763809e-04,-1.498046e-05},{ 1.614004e-04,-1.520961e-05},{ 1.461908e-04,-1.540621e-05},{ 1.307846e-04,-1.557008e-05},
 { 1.152145e-04,-1.570110e-05},{ 9.951343e-05,-1.579921e-05},{ 8.371422e-05,-1.586443e-05},{ 6.784980e-05,-1.589683e-05},
 { 5.195296e-05,-1.589658e-05},{ 3.605638e-05,-1.586388e-05},{ 2.019250e-05,-1.579902e-05},{ 4.393479e-06,-1.570233e-05},
 {-1.130885e-05,-1.557423e-05},{-2.688308e-05,-1.541518e-05},{-4.229826e-05,-1.522571e-05},{-5.752397e-05,-1.500640e-05},
 {-7.253037e-05,-1.475791e-05},{-8.728828e-05,-1.448094e-05},{-1.017692e-04,-1.417622e-05},{-1.159454e-04,-1.384458e-05},
 {-1.297900e-04,-1.348687e-05},{-1.432769e-04,-1.310398e-05},{-1.563809e-04,-1.269688e-05},{-1.690778e-04,-1.226654e-05},
 {-1.813443e-04,-1.181401e-05},{-1.931583e-04,-1.134036e-05},{-2.044987e-04,-1.084669e-05},{-2.153454e-04,-1.033414e-05},
 {-2.256795e-04,-9.803900e-06},{-2.354834e-04,-9.257157e-06},{-2.447406e-04,-8.695142e-06},{-2.534357e-04,-8.119106e-06},
 {-2.615548e-04,-7.530322e-06},{-2.690851e-04,-6.930077e-06},{-2.760152e-04,-6.319677e-06},{-2.823349e-04,-5.700437e-06},
 {-2.880353e-04,-5.073683e-06},{-2.931090e-04,-4.440748e-06},{-2.975497e-04,-3.802968e-06},{-3.013527e-04,-3.161682e-06},
 {-3.045144e-04,-2.518224e-06},{-3.070326e-04,-1.873927e-06},{-3.089066e-04,-1.230115e-06},{-3.101367e-04,-5.881038e-07},
 {-3.107248e-04, 5.080507e-08},{-3.106740e-04, 6.853235e-07},{-3.099886e-04, 1.314181e-06},{-3.086745e-04, 1.936128e-06},
 {-3.067383e-04, 2.549937e-06},{-3.041884e-04, 3.154404e-06},{-3.010340e-04, 3.748354e-06},{-2.972856e-04, 4.330639e-06},
 {-2.929550e-04, 4.900145e-06},{-2.880549e-04, 5.455791e-06},{-2.825991e-04, 5.996530e-06},{-2.766025e-04, 6.521354e-06},
 {-2.700812e-04, 7.029294e-06},{-2.630519e-04, 7.519421e-06},{-2.555325e-04, 7.990851e-06},{-2.475416e-04, 8.442741e-06},
 {-2.390989e-04, 8.874297e-06},{-2.302246e-04, 9.284770e-06},{-2.209398e-04, 9.673459e-06},{-2.112663e-04, 1.003971e-05},
 {-2.012266e-04, 1.038293e-05},{-1.908437e-04, 1.070257e-05},{-1.801411e-04, 1.099812e-05},{-1.691430e-04, 1.126915e-05},
 {-1.578739e-04, 1.151526e-05},{-1.463586e-04, 1.173611e-05},{-1.346225e-04, 1.193142e-05},{-1.226911e-04, 1.210097e-05},
 {-1.105901e-04, 1.224457e-05},{-9.834554e-05, 1.236211e-05},{-8.598342e-05, 1.245352e-05},{-7.352990e-05, 1.251879e-05},
 {-6.101111e-05, 1.255797e-05},{-4.845314e-05, 1.257113e-05},{-3.588201e-05, 1.255844e-05},{-2.332356e-05, 1.252010e-05},
 {-1.080347e-05, 1.245635e-05},{ 1.652884e-06, 1.236750e-05},{ 1.402038e-05, 1.225390e-05},{ 2.627428e-05, 1.211594e-05},
 { 3.839022e-05, 1.195409e-05},{ 5.034431e-05, 1.176882e-05},{ 6.211313e-05, 1.156068e-05},{ 7.367382e-05, 1.133026e-05},
 { 8.500407e-05, 1.107816e-05},{ 9.608223e-05, 1.080507e-05},{ 1.068873e-04, 1.051167e-05},{ 1.173990e-04, 1.019872e-05},
 { 1.275977e-04, 9.866977e-06},{ 1.374647e-04, 9.517262e-06},{ 1.469819e-04, 9.150410e-06},{ 1.561323e-04, 8.767292e-06},
 { 1.648996e-04, 8.368804e-06},{ 1.732684e-04, 7.955870e-06},{ 1.812243e-04, 7.529435e-06},{ 1.887537e-04, 7.090468e-06},
 { 1.958442e-04, 6.639956e-06},{ 2.024842e-04, 6.178902e-06},{ 2.086631e-04, 5.708325e-06},{ 2.143714e-04, 5.229258e-06},
 { 2.196006e-04, 4.742742e-06},{ 2.243434e-04, 4.249829e-06},{ 2.285932e-04, 3.751574e-06},{ 2.323448e-04, 3.249039e-06},
 { 2.355938e-04, 2.743286e-06},{ 2.383371e-04, 2.235376e-06},{ 2.405725e-04, 1.726369e-06},{ 2.422989e-04, 1.217318e-06},
 { 2.435162e-04, 7.092703e-07},{ 2.442255e-04, 2.032644e-07},{ 2.444287e-04,-2.996734e-07},{ 2.441290e-04,-7.985295e-07},
 { 2.433305e-04,-1.292306e-06},{ 2.420382e-04,-1.780021e-06},{ 2.402582e-04,-2.260714e-06},{ 2.379975e-04,-2.733443e-06},
 { 2.352640e-04,-3.197290e-06},{ 2.320667e-04,-3.651361e-06},{ 2.284154e-04,-4.094790e-06},{ 2.243206e-04,-4.526736e-06},
 { 2.197939e-04,-4.946389e-06},{ 2.148475e-04,-5.352970e-06},{ 2.094945e-04,-5.745731e-06},{ 2.037488e-04,-6.123959e-06},
 { 1.976248e-04,-6.486975e-06},{ 1.911378e-04,-6.834135e-06},{ 1.843037e-04,-7.164834e-06},{ 1.771389e-04,-7.478505e-06},
 { 1.696604e-04,-7.774617e-06},{ 1.618857e-04,-8.052682e-06},{ 1.538331e-04,-8.312251e-06},{ 1.455208e-04,-8.552917e-06},
 { 1.369679e-04,-8.774314e-06},{ 1.281936e-04,-8.976119e-06},{ 1.192175e-04,-9.158051e-06},{ 1.100594e-04,-9.319872e-06},
 { 1.007395e-04,-9.461386e-06},{ 9.127814e-05,-9.582443e-06},{ 8.169570e-05,-9.682934e-06},{ 7.201277e-05,-9.762794e-06},
 { 6.224997e-05,-9.822001e-06},{ 5.242797e-05,-9.860574e-06},{ 4.256740e-05,-9.878577e-06},{ 3.268882e-05,-9.876115e-06},
 { 2.281271e-05,-9.853334e-06},{ 1.295937e-05,-9.810422e-06},{ 3.148951e-06,-9.747606e-06},{-6.598654e-06,-9.665153e-06},
 {-1.626381e-05,-9.563370e-06},{-2.582718e-05,-9.442600e-06},{-3.526978e-05,-9.303224e-06},{-4.457300e-05,-9.145657e-06},
 {-5.371866e-05,-8.970351e-06},{-6.268901e-05,-8.777790e-06},{-7.146680e-05,-8.568492e-06},{-8.003529e-05,-8.343003e-06},
 {-8.837829e-05,-8.101902e-06},{-9.648020e-05,-7.845795e-06},{-1.043260e-04,-7.575314e-06},{-1.119013e-04,-7.291116e-06},
 {-1.191924e-04,-6.993885e-06},{-1.261863e-04,-6.684323e-06},{-1.328706e-04,-6.363156e-06},{-1.392338e-04,-6.031127e-06},
 {-1.452649e-04,-5.688998e-06},{-1.509539e-04,-5.337544e-06},{-1.562915e-04,-4.977556e-06},{-1.612690e-04,-4.609837e-06},
 {-1.658788e-04,-4.235200e-06},{-1.701140e-04,-3.854468e-06},{-1.739685e-04,-3.468468e-06},{-1.774370e-04,-3.078035e-06},
 {-1.805150e-04,-2.684006e-06},{-1.831990e-04,-2.287220e-06},{-1.854862e-04,-1.888515e-06},{-1.873748e-04,-1.488730e-06},
 {-1.888635e-04,-1.088698e-06},{-1.899522e-04,-6.892462e-07},{-1.906414e-04,-2.911966e-07},{-1.909326e-04, 1.046381e-07},
 {-1.908280e-04, 4.974554e-07},{-1.903305e-04, 8.864645e-07},{-1.894441e-04, 1.270888e-06},{-1.881732e-04, 1.649964e-06},
 {-1.865232e-04, 2.022945e-06},{-1.845003e-04, 2.389104e-06},{-1.821112e-04, 2.747732e-06},{-1.793634e-04, 3.098139e-06},
 {-1.762653e-04, 3.439659e-06},{-1.728256e-04, 3.771648e-06},{-1.690540e-04, 4.093486e-06},{-1.649605e-04, 4.404580e-06},
 {-1.605559e-04, 4.704361e-06},{-1.558516e-04, 4.992288e-06},{-1.508593e-04, 5.267850e-06},{-1.455914e-04, 5.530563e-06},
 {-1.400609e-04, 5.779974e-06},{-1.342809e-04, 6.015661e-06},{-1.282652e-04, 6.237233e-06},{-1.220280e-04, 6.444332e-06},
 {-1.155837e-04, 6.636629e-06},{-1.089470e-04, 6.813832e-06},{-1.021332e-04, 6.975681e-06},{-9.515752e-05, 7.121948e-06},
 {-8.803558e-05, 7.252442e-06},{-8.078313e-05, 7.367002e-06},{-7.341613e-05, 7.465506e-06},{-6.595063e-05, 7.547862e-06},
 {-5.840276e-05, 7.614014e-06},{-5.078875e-05, 7.663940e-06},{-4.312481e-05, 7.697651e-06},{-3.542716e-05, 7.715192e-06},
 {-2.771197e-05, 7.716642e-06},{-1.999532e-05, 7.702111e-06},{-1.229321e-05, 7.671743e-06},{-4.621470e-06, 7.625713e-06},
 { 3.004243e-06, 7.564228e-06},{ 1.056847e-05, 7.487525e-06},{ 1.805600e-05, 7.395870e-06},{ 2.545187e-05, 7.289561e-06},
 { 3.274143e-05, 7.168921e-06},{ 3.991035e-05, 7.034303e-06},{ 4.694465e-05, 6.886085e-06},{ 5.383074e-05, 6.724671e-06},
 { 6.055541e-05, 6.550489e-06},{ 6.710590e-05, 6.363993e-06},{ 7.346989e-05, 6.165655e-06},{ 7.963554e-05, 5.955973e-06},
 { 8.559152e-05, 5.735462e-06},{ 9.132698e-05, 5.504656e-06},{ 9.683164e-05, 5.264108e-06},{ 1.020957e-04, 5.014386e-06},
 { 1.071101e-04, 4.756074e-06},{ 1.118662e-04, 4.489770e-06},{ 1.163560e-04, 4.216082e-06},{ 1.205721e-04, 3.935633e-06},
 { 1.245077e-04, 3.649052e-06},{ 1.281567e-04, 3.356977e-06},{ 1.315137e-04, 3.060055e-06},{ 1.345738e-04, 2.758937e-06},
 { 1.373327e-04, 2.454278e-06},{ 1.397870e-04, 2.146736e-06},{ 1.419337e-04, 1.836971e-06},{ 1.437707e-04, 1.525640e-06},
 { 1.452963e-04, 1.213403e-06},{ 1.465097e-04, 9.009148e-07},{ 1.474107e-04, 5.888256e-07},{ 1.479995e-04, 2.777813e-07},
 { 1.482773e-04,-3.157945e-08},{ 1.482457e-04,-3.386259e-07},{ 1.479071e-04,-6.427366e-07},{ 1.472643e-04,-9.433007e-07},
 { 1.463210e-04,-1.239719e-06},{ 1.450813e-04,-1.531405e-06},{ 1.435499e-04,-1.817787e-06},{ 1.417321e-04,-2.098307e-06},
 { 1.396338e-04,-2.372425e-06},{ 1.372614e-04,-2.639616e-06},{ 1.346218e-04,-2.899376e-06},{ 1.317224e-04,-3.151216e-06},
 { 1.285712e-04,-3.394672e-06},{ 1.251765e-04,-3.629296e-06},{ 1.215472e-04,-3.854664e-06},{ 1.176925e-04,-4.070375e-06},
 { 1.136222e-04,-4.276050e-06},{ 1.093461e-04,-4.471332e-06},{ 1.048748e-04,-4.655891e-06},{ 1.002189e-04,-4.829420e-06},
 { 9.538947e-05,-4.991638e-06},{ 9.039783e-05,-5.142289e-06},{ 8.525554e-05,-5.281143e-06},{ 7.997440e-05,-5.407997e-06},
 { 7.456640e-05,-5.522673e-06},{ 6.904373e-05,-5.625020e-06},{ 6.341871e-05,-5.714916e-06},{ 5.770379e-05,-5.792262e-06},
 { 5.191153e-05,-5.856990e-06},{ 4.605454e-05,-5.909056e-06},{ 4.014548e-05,-5.948442e-06},{ 3.419704e-05,-5.975160e-06},
 { 2.822188e-05,-5.989246e-06},{ 2.223264e-05,-5.990761e-06},{ 1.624187e-05,-5.979795e-06},{ 1.026208e-05,-5.956461e-06},
 { 4.305618e-06,-5.920897e-06},{-1.615279e-06,-5.873267e-06},{-7.488547e-06,-5.813758e-06},{-1.330230e-05,-5.742580e-06},
 {-1.904489e-05,-5.659967e-06},{-2.470485e-05,-5.566174e-06},{-3.027103e-05,-5.461479e-06},{-3.573251e-05,-5.346179e-06},
 {-4.107869e-05,-5.220593e-06},{-4.629928e-05,-5.085057e-06},{-5.138434e-05,-4.939926e-06},{-5.632426e-05,-4.785574e-06},
 {-6.110984e-05,-4.622390e-06},{-6.573223e-05,-4.450779e-06},{-7.018300e-05,-4.271161e-06},{-7.445417e-05,-4.083970e-06},
 {-7.853814e-05,-3.889650e-06},{-8.242779e-05,-3.688661e-06},{-8.611645e-05,-3.481471e-06},{-8.959792e-05,-3.268558e-06},
 {-9.286648e-05,-3.050408e-06},{-9.591688e-05,-2.827515e-06},{-9.874440e-05,-2.600380e-06},{-1.013448e-04,-2.369508e-06},
 {-1.037143e-04,-2.135408e-06},{-1.058497e-04,-1.898595e-06},{-1.077483e-04,-1.659581e-06},{-1.094079e-04,-1.418884e-06},
 {-1.108268e-04,-1.177018e-06},{-1.120038e-04,-9.344966e-07},{-1.129383e-04,-6.918328e-07},{-1.136301e-04,-4.495343e-07},
 {-1.140796e-04,-2.081051e-07},{-1.142877e-04, 3.195650e-08},{-1.142558e-04, 2.701586e-07},{-1.139856e-04, 5.060168e-07},
 {-1.134796e-04, 7.390551e-07},{-1.127406e-04, 9.688068e-07},{-1.117717e-04, 1.194816e-06},{-1.105769e-04, 1.416636e-06},
 {-1.091603e-04, 1.633836e-06},{-1.075265e-04, 1.845994e-06},{-1.056805e-04, 2.052703e-06},{-1.036278e-04, 2.253572e-06},
 {-1.013742e-04, 2.448223e-06},{-9.892597e-05, 2.636294e-06},{-9.628967e-05, 2.817441e-06},{-9.347223e-05, 2.991335e-06},
 {-9.048090e-05, 3.157667e-06},{-8.732323e-05, 3.316143e-06},{-8.400709e-05, 3.466490e-06},{-8.054060e-05, 3.608454e-06},
 {-7.693214e-05, 3.741799e-06},{-7.319035e-05, 3.866309e-06},{-6.932404e-05, 3.981790e-06},{-6.534225e-05, 4.088067e-06},
 {-6.125418e-05, 4.184985e-06},{-5.706919e-05, 4.272410e-06},{-5.279678e-05, 4.350230e-06},{-4.844655e-05, 4.418353e-06},
 {-4.402820e-05, 4.476708e-06},{-3.955149e-05, 4.525246e-06},{-3.502625e-05, 4.563938e-06},{-3.046231e-05, 4.592777e-06},
 {-2.586953e-05, 4.611774e-06},{-2.125776e-05, 4.620963e-06},{-1.663679e-05, 4.620399e-06},{-1.201640e-05, 4.610155e-06},
 {-7.406240e-06, 4.590325e-06},{-2.815915e-06, 4.561023e-06},{ 1.745108e-06, 4.522379e-06},{ 6.267487e-06, 4.474545e-06},
 { 1.074203e-05, 4.417691e-06},{ 1.515972e-05, 4.352002e-06},{ 1.951173e-05, 4.277684e-06},{ 2.378941e-05, 4.194956e-06},
 { 2.798437e-05, 4.104055e-06},{ 3.208842e-05, 4.005234e-06},{ 3.609365e-05, 3.898758e-06},{ 3.999241e-05, 3.784910e-06},
 { 4.377732e-05, 3.663983e-06},{ 4.744131e-05, 3.536286e-06},{ 5.097759e-05, 3.402136e-06},{ 5.437973e-05, 3.261864e-06},
 { 5.764159e-05, 3.115812e-06},{ 6.075740e-05, 2.964329e-06},{ 6.372173e-05, 2.807775e-06},{ 6.652951e-05, 2.646517e-06},
 { 6.917602e-05, 2.480929e-06},{ 7.165695e-05, 2.311393e-06},{ 7.396835e-05, 2.138295e-06},{ 7.610664e-05, 1.962025e-06},
 { 7.806867e-05, 1.782979e-06},{ 7.985164e-05, 1.601554e-06},{ 8.145320e-05, 1.418150e-06},{ 8.287135e-05, 1.233168e-06},
 { 8.410452e-05, 1.047008e-06},{ 8.515152e-05, 8.600728e-07},{ 8.601160e-05, 6.727606e-07},{ 8.668436e-05, 4.854690e-07},
 { 8.716983e-05, 2.985923e-07},{ 8.746842e-05, 1.125209e-07},{ 8.758094e-05,-7.235920e-08},{ 8.750858e-05,-2.556676e-07},
 { 8.725291e-05,-4.370299e-07},{ 8.681588e-05,-6.160786e-07},{ 8.619980e-05,-7.924539e-07},{ 8.540735e-05,-9.658042e-07},
 { 8.444155e-05,-1.135787e-06},{ 8.330576e-05,-1.302070e-06},{ 8.200369e-05,-1.464329e-06},{ 8.053936e-05,-1.622254e-06},
 { 7.891711e-05,-1.775544e-06},{ 7.714156e-05,-1.923911e-06},{ 7.521765e-05,-2.067079e-06},{ 7.315057e-05,-2.204785e-06},
 { 7.094579e-05,-2.336782e-06},{ 6.860901e-05,-2.462832e-06},{ 6.614618e-05,-2.582716e-06},{ 6.356346e-05,-2.696228e-06},
 { 6.086723e-05,-2.803175e-06},{ 5.806406e-05,-2.903383e-06},{ 5.516067e-05,-2.996690e-06},{ 5.216398e-05,-3.082953e-06},
 { 4.908103e-05,-3.162042e-06},{ 4.591899e-05,-3.233846e-06},{ 4.268514e-05,-3.298268e-06},{ 3.938687e-05,-3.355228e-06},
 { 3.603165e-05,-3.404664e-06},{ 3.262698e-05,-3.446527e-06},{ 2.918046e-05,-3.480787e-06},{ 2.569967e-05,-3.507429e-06},
 { 2.219224e-05,-3.526457e-06},{ 1.866578e-05,-3.537887e-06},{ 1.512790e-05,-3.541753e-06},{ 1.158614e-05,-3.538105e-06},
 { 8.048038e-06,-3.527009e-06},{ 4.521029e-06,-3.508545e-06},{ 1.012484e-06,-3.482807e-06},{-2.470323e-06,-3.449908e-06},
 {-5.920231e-06,-3.409970e-06},{-9.330201e-06,-3.363133e-06},{-1.269333e-05,-3.309548e-06},{-1.600288e-05,-3.249381e-06},
 {-1.925226e-05,-3.182810e-06},{-2.243507e-05,-3.110025e-06},{-2.554510e-05,-3.031228e-06},{-2.857633e-05,-2.946631e-06},
 {-3.152296e-05,-2.856460e-06},{-3.437942e-05,-2.760947e-06},{-3.714036e-05,-2.660337e-06},{-3.980070e-05,-2.554882e-06},
 {-4.235558e-05,-2.444842e-06},{-4.480042e-05,-2.330487e-06},{-4.713091e-05,-2.212092e-06},{-4.934300e-05,-2.089939e-06},
 {-5.143294e-05,-1.964317e-06},{-5.339726e-05,-1.835519e-06},{-5.523278e-05,-1.703843e-06},{-5.693662e-05,-1.569589e-06},
 {-5.850621e-05,-1.433064e-06},{-5.993928e-05,-1.294575e-06},{-6.123385e-05,-1.154431e-06},{-6.238828e-05,-1.012941e-06},
 {-6.340122e-05,-8.704180e-07},{-6.427164e-05,-7.271716e-07},{-6.499881e-05,-5.835120e-07},{-6.558232e-05,-4.397475e-07},
 {-6.602207e-05,-2.961845e-07},{-6.631826e-05,-1.531265e-07},{-6.647138e-05,-1.087377e-08},{-6.648226e-05, 1.302776e-07},
 {-6.635198e-05, 2.700361e-07},{-6.608194e-05, 4.081152e-07},{-6.567383e-05, 5.442344e-07},{-6.512959e-05, 6.781194e-07},
 {-6.445147e-05, 8.095025e-07},{-6.364197e-05, 9.381238e-07},{-6.270385e-05, 1.063731e-06},{-6.164012e-05, 1.186080e-06},
 {-6.045404e-05, 1.304937e-06},{-5.914910e-05, 1.420074e-06},{-5.772903e-05, 1.531276e-06},{-5.619775e-05, 1.638337e-06},
 {-5.455941e-05, 1.741061e-06},{-5.281835e-05, 1.839263e-06},{-5.097909e-05, 1.932769e-06},{-4.904632e-05, 2.021416e-06},
 {-4.702490e-05, 2.105054e-06},{-4.491985e-05, 2.183544e-06},{-4.273631e-05, 2.256757e-06},{-4.047955e-05, 2.324580e-06},
 {-3.815497e-05, 2.386910e-06},{-3.576806e-05, 2.443656e-06},{-3.332440e-05, 2.494743e-06},{-3.082966e-05, 2.540104e-06},
 {-2.828956e-05, 2.579688e-06},{-2.570987e-05, 2.613456e-06},{-2.309641e-05, 2.641382e-06},{-2.045503e-05, 2.663451e-06},
 {-1.779158e-05, 2.679662e-06},{-1.511192e-05, 2.690028e-06},{-1.242189e-05, 2.694571e-06},{-9.727318e-06, 2.693327e-06},
 {-7.033991e-06, 2.686345e-06},{-4.347646e-06, 2.673686e-06},{-1.673960e-06, 2.655420e-06},{ 9.814593e-07, 2.631630e-06},
 { 3.613090e-06, 2.602412e-06},{ 6.215502e-06, 2.567870e-06},{ 8.783372e-06, 2.528121e-06},{ 1.131149e-05, 2.483290e-06},
 { 1.379478e-05, 2.433513e-06},{ 1.622830e-05, 2.378936e-06},{ 1.860723e-05, 2.319714e-06},{ 2.092695e-05, 2.256010e-06},
 { 2.318296e-05, 2.187996e-06},{ 2.537095e-05, 2.115851e-06},{ 2.748680e-05, 2.039764e-06},{ 2.952657e-05, 1.959927e-06},
 { 3.148649e-05, 1.876542e-06},{ 3.336304e-05, 1.789815e-06},{ 3.515285e-05, 1.699959e-06},{ 3.685281e-05, 1.607191e-06},
 { 3.846000e-05, 1.511734e-06},{ 3.997173e-05, 1.413812e-06},{ 4.138555e-05, 1.313656e-06},{ 4.269920e-05, 1.211499e-06},
 { 4.391070e-05, 1.107575e-06},{ 4.501828e-05, 1.002122e-06},{ 4.602040e-05, 8.953768e-07},{ 4.691577e-05, 7.875804e-07},
 { 4.770336e-05, 6.789719e-07},{ 4.838233e-05, 5.697912e-07},{ 4.895212e-05, 4.602772e-07},{ 4.941240e-05, 3.506678e-07},
 { 4.976306e-05, 2.411993e-07},{ 5.000426e-05, 1.321057e-07},{ 5.013637e-05, 2.361853e-08},{ 5.015999e-05,-8.403391e-08},
 { 5.007595e-05,-1.906268e-07},{ 4.988533e-05,-2.959395e-07},{ 4.958939e-05,-3.997557e-07},{ 4.918963e-05,-5.018641e-07},
 { 4.868777e-05,-6.020586e-07},{ 4.808571e-05,-7.001390e-07},{ 4.738557e-05,-7.959111e-07},{ 4.658966e-05,-8.891873e-07},
 { 4.570047e-05,-9.797867e-07},{ 4.472068e-05,-1.067536e-06},{ 4.365315e-05,-1.152268e-06},{ 4.250088e-05,-1.233826e-06},
 { 4.126705e-05,-1.312059e-06},{ 3.995499e-05,-1.386825e-06},{ 3.856817e-05,-1.457991e-06},{ 3.711018e-05,-1.525432e-06},
 { 3.558475e-05,-1.589033e-06},{ 3.399571e-05,-1.648688e-06},{ 3.234703e-05,-1.704299e-06},{ 3.064273e-05,-1.755780e-06},
 { 2.888695e-05,-1.803053e-06},{ 2.708389e-05,-1.846049e-06},{ 2.523784e-05,-1.884711e-06},{ 2.335313e-05,-1.918989e-06},
 { 2.143414e-05,-1.948845e-06},{ 1.948530e-05,-1.974250e-06},{ 1.751105e-05,-1.995186e-06},{ 1.551586e-05,-2.011644e-06},
 { 1.350422e-05,-2.023623e-06},{ 1.148060e-05,-2.031135e-06},{ 9.449461e-06,-2.034199e-06},{ 7.415262e-06,-2.032845e-06},
 { 5.382417e-06,-2.027111e-06},{ 3.355305e-06,-2.017046e-06},{ 1.338259e-06,-2.002706e-06},{-6.644469e-07,-1.984157e-06},
 {-2.648604e-06,-1.961474e-06},{-4.610078e-06,-1.934739e-06},{-6.544817e-06,-1.904043e-06},{-8.448860e-06,-1.869484e-06},
 {-1.031834e-05,-1.831169e-06},{-1.214951e-05,-1.789212e-06},{-1.393872e-05,-1.743733e-06},{-1.568246e-05,-1.694859e-06},
 {-1.737732e-05,-1.642724e-06},{-1.902004e-05,-1.587468e-06},{-2.060751e-05,-1.529236e-06},{-2.213675e-05,-1.468179e-06},
 {-2.360493e-05,-1.404452e-06},{-2.500938e-05,-1.338215e-06},{-2.634759e-05,-1.269632e-06},{-2.761722e-05,-1.198872e-06},
 {-2.881610e-05,-1.126106e-06},{-2.994220e-05,-1.051509e-06},{-3.099371e-05,-9.752571e-07},{-3.196897e-05,-8.975301e-07},
 {-3.286650e-05,-8.185090e-07},{-3.368501e-05,-7.383761e-07},{-3.442338e-05,-6.573148e-07},{-3.508070e-05,-5.755088e-07},
 {-3.565621e-05,-4.931424e-07},{-3.614935e-05,-4.103992e-07},{-3.655975e-05,-3.274625e-07},{-3.688721e-05,-2.445142e-07},
 {-3.713172e-05,-1.617351e-07},{-3.729346e-05,-7.930408e-08},{-3.737276e-05, 2.602339e-09},{-3.737016e-05, 8.381001e-08},
 {-3.728635e-05, 1.641478e-07},{-3.712220e-05, 2.434477e-07},{-3.687876e-05, 3.215456e-07},{-3.655721e-05, 3.982811e-07},
 {-3.615893e-05, 4.734981e-07},{-3.568543e-05, 5.470452e-07},{-3.513839e-05, 6.187756e-07},{-3.451961e-05, 6.885480e-07},
 {-3.383106e-05, 7.562262e-07},{-3.307484e-05, 8.216799e-07},{-3.225316e-05, 8.847847e-07},{-3.136837e-05, 9.454221e-07},
 {-3.042295e-05, 1.003480e-06},{-2.941947e-05, 1.058854e-06},{-2.836062e-05, 1.111444e-06},{-2.724917e-05, 1.161158e-06},
 {-2.608801e-05, 1.207913e-06},{-2.488010e-05, 1.251630e-06},{-2.362847e-05, 1.292239e-06},{-2.233623e-05, 1.329677e-06},
 {-2.100655e-05, 1.363889e-06},{-1.964266e-05, 1.394826e-06},{-1.824784e-05, 1.422449e-06},{-1.682539e-05, 1.446724e-06},
 {-1.537867e-05, 1.467625e-06},{-1.391104e-05, 1.485137e-06},{-1.242590e-05, 1.499248e-06},{-1.092666e-05, 1.509956e-06},
 {-9.416701e-06, 1.517265e-06},{-7.899435e-06, 1.521190e-06},{-6.378246e-06, 1.521748e-06},{-4.856497e-06, 1.518968e-06},
 {-3.337530e-06, 1.512883e-06},{-1.824647e-06, 1.503534e-06},{-3.211131e-07, 1.490969e-06},{ 1.169856e-06, 1.475244e-06},
 { 2.645100e-06, 1.456418e-06},{ 4.101519e-06, 1.434560e-06},{ 5.536079e-06, 1.409743e-06},{ 6.945822e-06, 1.382046e-06},
 { 8.327868e-06, 1.351555e-06},{ 9.679424e-06, 1.318361e-06},{ 1.099778e-05, 1.282558e-06},{ 1.228034e-05, 1.244248e-06},
 { 1.352459e-05, 1.203536e-06},{ 1.472813e-05, 1.160533e-06},{ 1.588866e-05, 1.115352e-06},{ 1.700401e-05, 1.068111e-06},
 { 1.807212e-05, 1.018932e-06},{ 1.909105e-05, 9.679397e-07},{ 2.005899e-05, 9.152616e-07},{ 2.097426e-05, 8.610281e-07},
 { 2.183528e-05, 8.053722e-07},{ 2.264066e-05, 7.484287e-07},{ 2.338909e-05, 6.903341e-07},{ 2.407942e-05, 6.312265e-07},
 { 2.471065e-05, 5.712449e-07},{ 2.528189e-05, 5.105292e-07},{ 2.579242e-05, 4.492198e-07},{ 2.624164e-05, 3.874571e-07},
 { 2.662910e-05, 3.253815e-07},{ 2.695448e-05, 2.631330e-07},{ 2.721761e-05, 2.008505e-07},{ 2.741846e-05, 1.386721e-07},
 { 2.755713e-05, 7.673457e-08},{ 2.763387e-05, 1.517279e-08},{ 2.764904e-05,-4.588017e-08},{ 2.760316e-05,-1.062935e-07},
 { 2.749687e-05,-1.659388e-07},{ 2.733093e-05,-2.246907e-07},{ 2.710624e-05,-2.824266e-07},{ 2.682381e-05,-3.390271e-07},
 { 2.648478e-05,-3.943767e-07},{ 2.609041e-05,-4.483633e-07},{ 2.564204e-05,-5.008788e-07},{ 2.514117e-05,-5.518194e-07},
 { 2.458935e-05,-6.010856e-07},{ 2.398826e-05,-6.485824e-07},{ 2.333968e-05,-6.942196e-07},{ 2.264546e-05,-7.379119e-07},
 { 2.190755e-05,-7.795788e-07},{ 2.112797e-05,-8.191454e-07},{ 2.030882e-05,-8.565418e-07},{ 1.945228e-05,-8.917035e-07},
 { 1.856058e-05,-9.245716e-07},{ 1.763601e-05,-9.550929e-07},{ 1.668091e-05,-9.832198e-07},{ 1.569769e-05,-1.008910e-06},
 { 1.468878e-05,-1.032128e-06},{ 1.365665e-05,-1.052844e-06},{ 1.260381e-05,-1.071032e-06},{ 1.153278e-05,-1.086674e-06},
 { 1.044610e-05,-1.099758e-06},{ 9.346347e-06,-1.110276e-06},{ 8.236071e-06,-1.118227e-06},{ 7.117844e-06,-1.123617e-06},
 { 5.994227e-06,-1.126454e-06},{ 4.867773e-06,-1.126756e-06},{ 3.741018e-06,-1.124542e-06},{ 2.616475e-06,-1.119842e-06},
 { 1.496634e-06,-1.112685e-06},{ 3.839482e-07,-1.103111e-06},{-7.191626e-07,-1.091161e-06},{-1.810323e-06,-1.076883e-06},
 {-2.887206e-06,-1.060329e-06},{-3.947535e-06,-1.041556e-06},{-4.989090e-06,-1.020625e-06},{-6.009716e-06,-9.976031e-07},
 {-7.007319e-06,-9.725591e-07},{-7.979878e-06,-9.455670e-07},{-8.925445e-06,-9.167045e-07},{-9.842149e-06,-8.860526e-07},
 {-1.072820e-05,-8.536958e-07},{-1.158190e-05,-8.197216e-07},{-1.240162e-05,-7.842205e-07},{-1.318584e-05,-7.472856e-07},
 {-1.393313e-05,-7.090124e-07},{-1.464214e-05,-6.694987e-07},{-1.531164e-05,-6.288440e-07},{-1.594048e-05,-5.871500e-07},
 {-1.652763e-05,-5.445193e-07},{-1.707215e-05,-5.010563e-07},{-1.757321e-05,-4.568658e-07},{-1.803007e-05,-4.120539e-07},
 {-1.844213e-05,-3.667268e-07},{-1.880885e-05,-3.209912e-07},{-1.912984e-05,-2.749535e-07},{-1.940480e-05,-2.287203e-07},
 {-1.963352e-05,-1.823975e-07},{-1.981592e-05,-1.360901e-07},{-1.995201e-05,-8.990263e-08},{-2.004191e-05,-4.393803e-08},
 {-2.008585e-05, 1.701929e-09},{-2.008414e-05, 4.691713e-08},{-2.003723e-05, 9.160928e-08},{-1.994562e-05, 1.356821e-07},
 {-1.980994e-05, 1.790416e-07},{-1.963089e-05, 2.215961e-07},{-1.940930e-05, 2.632565e-07},{-1.914604e-05, 3.039368e-07},
 {-1.884210e-05, 3.435535e-07},{-1.849855e-05, 3.820267e-07},{-1.811652e-05, 4.192793e-07},{-1.769725e-05, 4.552381e-07},
 {-1.724201e-05, 4.898331e-07},{-1.675217e-05, 5.229981e-07},{-1.622918e-05, 5.546709e-07},{-1.567450e-05, 5.847929e-07},
 {-1.508971e-05, 6.133099e-07},{-1.447640e-05, 6.401714e-07},{-1.383623e-05, 6.653315e-07},{-1.317090e-05, 6.887483e-07},
 {-1.248215e-05, 7.103844e-07},{-1.177177e-05, 7.302065e-07},{-1.104156e-05, 7.481861e-07},{-1.029337e-05, 7.642988e-07},
 {-9.529075e-06, 7.785248e-07},{-8.750550e-06, 7.908490e-07},{-7.959701e-06, 8.012603e-07},{-7.158441e-06, 8.097524e-07},
 {-6.348689e-06, 8.163234e-07},{-5.532365e-06, 8.209756e-07},{-4.711390e-06, 8.237159e-07},{-3.887674e-06, 8.245555e-07},
 {-3.063118e-06, 8.235095e-07},{-2.239609e-06, 8.205976e-07},{-1.419011e-06, 8.158434e-07},{-6.031676e-07, 8.092745e-07},
 { 2.061068e-07, 8.009224e-07},{ 1.007029e-06, 7.908225e-07},{ 1.797852e-06, 7.790138e-07},{ 2.576866e-06, 7.655389e-07},
 { 3.342404e-06, 7.504439e-07},{ 4.092848e-06, 7.337780e-07},{ 4.826626e-06, 7.155939e-07},{ 5.542220e-06, 6.959470e-07},
 { 6.238167e-06, 6.748959e-07},{ 6.913063e-06, 6.525015e-07},{ 7.565565e-06, 6.288276e-07},{ 8.194392e-06, 6.039403e-07},
 { 8.798332e-06, 5.779077e-07},{ 9.376240e-06, 5.508002e-07},{ 9.927040e-06, 5.226900e-07},{ 1.044973e-05, 4.936507e-07},
 { 1.094338e-05, 4.637578e-07},{ 1.140714e-05, 4.330878e-07},{ 1.184023e-05, 4.017184e-07},{ 1.224195e-05, 3.697283e-07},
 { 1.261167e-05, 3.371968e-07},{ 1.294887e-05, 3.042039e-07},{ 1.325307e-05, 2.708298e-07},{ 1.352390e-05, 2.371550e-07},
 { 1.376106e-05, 2.032599e-07},{ 1.396432e-05, 1.692247e-07},{ 1.413354e-05, 1.351293e-07},{ 1.426867e-05, 1.010529e-07},
 { 1.436973e-05, 6.707407e-08},{ 1.443680e-05, 3.327034e-08},{ 1.447007e-05,-2.817695e-10},{ 1.446979e-05,-3.350703e-08},
 { 1.443628e-05,-6.633165e-08},{ 1.436995e-05,-9.868339e-08},{ 1.427127e-05,-1.304918e-07},{ 1.414077e-05,-1.616883e-07},
 { 1.397909e-05,-1.922063e-07},{ 1.378688e-05,-2.219815e-07},{ 1.356490e-05,-2.509517e-07},{ 1.331395e-05,-2.790574e-07},
 { 1.303489e-05,-3.062414e-07},{ 1.272865e-05,-3.324492e-07},{ 1.239620e-05,-3.576292e-07},{ 1.203857e-05,-3.817326e-07},
 { 1.165684e-05,-4.047134e-07},{ 1.125212e-05,-4.265287e-07},{ 1.082559e-05,-4.471388e-07},{ 1.037846e-05,-4.665071e-07},
 { 9.911949e-06,-4.846003e-07},{ 9.427349e-06,-5.013881e-07},{ 8.925960e-06,-5.168439e-07},{ 8.409117e-06,-5.309441e-07},
 { 7.878172e-06,-5.436688e-07},{ 7.334504e-06,-5.550012e-07},{ 6.779503e-06,-5.649281e-07},{ 6.214574e-06,-5.734397e-07},
 { 5.641135e-06,-5.805294e-07},{ 5.060605e-06,-5.861944e-07},{ 4.474411e-06,-5.904347e-07},{ 3.883976e-06,-5.932542e-07},
 { 3.290722e-06,-5.946597e-07},{ 2.696062e-06,-5.946613e-07},{ 2.101401e-06,-5.932726e-07},{ 1.508128e-06,-5.905100e-07},
 { 9.176184e-07,-5.863931e-07},{ 3.312253e-07,-5.809446e-07},{-2.497193e-07,-5.741900e-07},{-8.239093e-07,-5.661575e-07},
 {-1.390067e-06,-5.568785e-07},{-1.946945e-06,-5.463866e-07},{-2.493332e-06,-5.347182e-07},{-3.028050e-06,-5.219120e-07},
 {-3.549962e-06,-5.080091e-07},{-4.057971e-06,-4.930529e-07},{-4.551024e-06,-4.770886e-07},{-5.028113e-06,-4.601637e-07},
 {-5.488277e-06,-4.423274e-07},{-5.930604e-06,-4.236305e-07},{-6.354234e-06,-4.041254e-07},{-6.758360e-06,-3.838662e-07},
 {-7.142226e-06,-3.629079e-07},{-7.505134e-06,-3.413069e-07},{-7.846441e-06,-3.191205e-07},{-8.165561e-06,-2.964068e-07},
 {-8.461968e-06,-2.732249e-07},{-8.735193e-06,-2.496341e-07},{-8.984827e-06,-2.256943e-07},{-9.210521e-06,-2.014658e-07},
 {-9.411987e-06,-1.770087e-07},{-9.588996e-06,-1.523833e-07},{-9.741379e-06,-1.276499e-07},{-9.869029e-06,-1.028682e-07},
 {-9.971897e-06,-7.809756e-08},{-1.004999e-05,-5.339684e-08},{-1.010339e-05,-2.882413e-08},{-1.013222e-05,-4.436669e-09},
 {-1.013665e-05, 1.970925e-08},{-1.011694e-05, 4.355845e-08},{-1.007338e-05, 6.705697e-08},{-1.000633e-05, 9.015219e-08},
 {-9.916176e-06, 1.127929e-07},{-9.803383e-06, 1.349296e-07},{-9.668453e-06, 1.565144e-07},{-9.511939e-06, 1.775009e-07},
 {-9.334438e-06, 1.978450e-07},{-9.136593e-06, 2.175044e-07},{-8.919088e-06, 2.364387e-07},{-8.682650e-06, 2.546097e-07},
 {-8.428040e-06, 2.719815e-07},{-8.156058e-06, 2.885203e-07},{-7.867538e-06, 3.041948e-07},{-7.563343e-06, 3.189758e-07},
 {-7.244367e-06, 3.328368e-07},{-6.911531e-06, 3.457536e-07},{-6.565777e-06, 3.577046e-07},{-6.208073e-06, 3.686706e-07},
 {-5.839402e-06, 3.786352e-07},{-5.460767e-06, 3.875843e-07},{-5.073182e-06, 3.955066e-07},{-4.677676e-06, 4.023933e-07},
 {-4.275282e-06, 4.082380e-07},{-3.867044e-06, 4.130373e-07},{-3.454007e-06, 4.167900e-07},{-3.037217e-06, 4.194976e-07},
 {-2.617719e-06, 4.211641e-07},{-2.196555e-06, 4.217960e-07},{-1.774759e-06, 4.214022e-07},{-1.353357e-06, 4.199941e-07},
 {-9.333630e-07, 4.175853e-07},{-5.157777e-07, 4.141918e-07},{-1.015860e-07, 4.098318e-07},{ 3.082459e-07, 4.045259e-07},
 { 7.127718e-07, 3.982964e-07},{ 1.111068e-06, 3.911679e-07},{ 1.502236e-06, 3.831670e-07},{ 1.885403e-06, 3.743221e-07},
 { 2.259725e-06, 3.646632e-07},{ 2.624388e-06, 3.542223e-07},{ 2.978611e-06, 3.430328e-07},{ 3.321643e-06, 3.311297e-07},
 { 3.652773e-06, 3.185495e-07},{ 3.971323e-06, 3.053298e-07},{ 4.276652e-06, 2.915095e-07},{ 4.568162e-06, 2.771287e-07},
 { 4.845291e-06, 2.622283e-07},{ 5.107519e-06, 2.468501e-07},{ 5.354369e-06, 2.310369e-07},{ 5.585406e-06, 2.148319e-07},
 { 0.000000e+00, 0.000000e+00},
};

float
y_slope_dd_table [MINBLEP_PHASES * DD_PULSE_LENGTH + 1] =
{
  0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00,
  0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00,
  0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00,
  0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00,
  0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 4.153209e-13, 4.023686e-11, 1.603264e-10, 8.176271e-12,
  1.678185e-11, 3.076009e-11, 5.302600e-11, 8.803563e-11, 1.423078e-10, 2.250510e-10, 3.489077e-10, 5.308322e-10,
  7.931154e-10, 1.164574e-09, 1.681921e-09, 2.391340e-09, 3.350275e-09, 4.629471e-09, 6.315271e-09, 8.512210e-09,
  1.134592e-08, 1.496639e-08, 1.955158e-08, 2.531143e-08, 3.249235e-08, 4.138215e-08, 5.231544e-08, 6.567961e-08,
  8.192142e-08, 1.015541e-07, 1.251654e-07, 1.534258e-07, 1.870979e-07, 2.270470e-07, 2.742513e-07, 3.298143e-07,
  3.949776e-07, 4.711342e-07, 5.598444e-07, 6.628508e-07, 7.820963e-07, 9.197424e-07, 1.078189e-06, 1.260095e-06,
  1.468402e-06, 1.706360e-06, 1.977548e-06, 2.285908e-06, 2.635769e-06, 3.031882e-06, 3.479452e-06, 3.984170e-06,
  4.552255e-06, 5.190492e-06, 5.906269e-06, 6.707629e-06, 7.603310e-06, 8.602796e-06, 9.716370e-06, 1.095517e-05,
  1.233123e-05, 1.385757e-05, 1.554823e-05, 1.741836e-05, 1.948427e-05, 2.176350e-05, 2.427494e-05, 2.703883e-05,
  3.007693e-05, 3.341254e-05, 3.707063e-05, 4.107791e-05, 4.546295e-05, 5.025626e-05, 5.549041e-05, 6.120015e-05,
  6.742251e-05, 7.419690e-05, 8.156530e-05, 8.957230e-05, 9.826532e-05, 1.076947e-04, 1.179138e-04, 1.289792e-04,
  1.409510e-04, 1.538926e-04, 1.678712e-04, 1.829579e-04, 1.992278e-04, 2.167602e-04, 2.356387e-04, 2.559516e-04,
  2.777919e-04, 3.012576e-04, 3.264519e-04, 3.534833e-04, 3.824660e-04, 4.135199e-04, 4.467711e-04, 4.823518e-04,
  5.204008e-04, 5.610636e-04, 6.044928e-04, 6.508481e-04, 7.002967e-04, 7.530137e-04, 8.091822e-04, 8.689934e-04,
  9.326472e-04, 1.000352e-03, 1.072327e-03, 1.148798e-03, 1.230002e-03, 1.316188e-03, 1.407610e-03, 1.504539e-03,
  1.607252e-03, 1.716040e-03, 1.831203e-03, 1.953056e-03, 2.081924e-03, 2.218145e-03, 2.362070e-03, 2.514062e-03,
  2.674500e-03, 2.843773e-03, 3.022288e-03, 3.210464e-03, 3.408735e-03, 3.617550e-03, 3.837375e-03, 4.068690e-03,
  4.311992e-03, 4.567792e-03, 4.836622e-03, 5.119026e-03, 5.415570e-03, 5.726834e-03, 6.053418e-03, 6.395939e-03,
  6.755032e-03, 7.131354e-03, 7.525576e-03, 7.938394e-03, 8.370518e-03, 8.822682e-03, 9.295638e-03, 9.790159e-03,
  1.030704e-02, 1.084709e-02, 1.141115e-02, 1.200008e-02, 1.261475e-02, 1.325606e-02, 1.392493e-02, 1.462232e-02,
  1.534917e-02, 1.610648e-02, 1.689527e-02, 1.771655e-02, 1.857139e-02, 1.946086e-02, 2.038607e-02, 2.134813e-02,
  2.234819e-02, 2.338742e-02, 2.446701e-02, 2.558816e-02, 2.675212e-02, 2.796014e-02, 2.921351e-02, 3.051351e-02,
  3.186149e-02, 3.325877e-02, 3.470674e-02, 3.620677e-02, 3.776028e-02, 3.936869e-02, 4.103347e-02, 4.275607e-02,
  4.453799e-02, 4.638075e-02, 4.828586e-02, 5.025488e-02, 5.228937e-02, 5.439092e-02, 5.656113e-02, 5.880161e-02,
  6.111401e-02, 6.349996e-02, 6.596113e-02, 6.849921e-02, 7.111588e-02, 7.381285e-02, 7.659183e-02, 7.945456e-02,
  8.240276e-02, 8.543820e-02, 8.856262e-02, 9.177780e-02, 9.508550e-02, 9.848750e-02, 1.019856e-01, 1.055815e-01,
  1.092772e-01, 1.130742e-01, 1.169746e-01, 1.209800e-01, 1.250922e-01, 1.293130e-01, 1.336443e-01, 1.380878e-01,
  1.426452e-01, 1.473184e-01, 1.521091e-01, 1.570191e-01, 1.620500e-01, 1.672037e-01, 1.724819e-01, 1.778862e-01,
  1.834183e-01, 1.734549e-01, 1.636227e-01, 1.539233e-01, 1.443583e-01, 1.349292e-01, 1.256377e-01, 1.164852e-01,
  1.074733e-01, 9.860350e-02, 8.987716e-02, 8.129574e-02, 7.286061e-02, 6.457314e-02, 5.643462e-02, 4.844634e-02,
  4.060953e-02, 3.292539e-02, 2.539507e-02, 1.801969e-02, 1.080030e-02, 3.737945e-03,-3.166417e-03,-9.911857e-03,
 -1.649750e-02,-2.292252e-02,-2.918614e-02,-3.528765e-02,-4.122638e-02,-4.700173e-02,-5.261315e-02,-5.806014e-02,
 -6.334228e-02,-6.845919e-02,-7.341056e-02,-7.819616e-02,-8.281579e-02,-8.726934e-02,-9.155677e-02,-9.567808e-02,
 -9.963336e-02,-1.034228e-01,-1.070465e-01,-1.105049e-01,-1.137982e-01,-1.169270e-01,-1.198918e-01,-1.226930e-01,
 -1.253314e-01,-1.278076e-01,-1.301225e-01,-1.322770e-01,-1.342719e-01,-1.361083e-01,-1.377873e-01,-1.393101e-01,
 -1.406778e-01,-1.418918e-01,-1.429535e-01,-1.438643e-01,-1.446258e-01,-1.452396e-01,-1.457073e-01,-1.460307e-01,
 -1.462116e-01,-1.462519e-01,-1.461535e-01,-1.459186e-01,-1.455491e-01,-1.450474e-01,-1.444154e-01,-1.436557e-01,
 -1.427706e-01,-1.417623e-01,-1.406336e-01,-1.393869e-01,-1.380247e-01,-1.365499e-01,-1.349650e-01,-1.332729e-01,
 -1.314764e-01,-1.295784e-01,-1.275819e-01,-1.254897e-01,-1.233049e-01,-1.210306e-01,-1.186699e-01,-1.162260e-01,
 -1.137020e-01,-1.111011e-01,-1.084267e-01,-1.056820e-01,-1.028703e-01,-9.999497e-02,-9.705940e-02,-9.406696e-02,
 -9.102108e-02,-8.792517e-02,-8.478269e-02,-8.159708e-02,-7.837182e-02,-7.511037e-02,-7.181621e-02,-6.849283e-02,
 -6.514369e-02,-6.177226e-02,-5.838203e-02,-5.497643e-02,-5.155893e-02,-4.813294e-02,-4.470188e-02,-4.126914e-02,
 -3.783810e-02,-3.441210e-02,-3.099445e-02,-2.758843e-02,-2.419731e-02,-2.082429e-02,-1.747254e-02,-1.414521e-02,
 -1.084537e-02,-7.576084e-03,-4.340329e-03,-1.141050e-03, 2.018867e-03, 5.136594e-03, 8.209359e-03, 1.123446e-02,
  1.420924e-02, 1.713113e-02, 1.999762e-02, 2.280628e-02, 2.555472e-02, 2.824067e-02, 3.086191e-02, 3.341630e-02,
  3.590178e-02, 3.831639e-02, 4.065822e-02, 4.292547e-02, 4.511643e-02, 4.722947e-02, 4.926304e-02, 5.121569e-02,
  5.308606e-02, 5.487290e-02, 5.657502e-02, 5.819136e-02, 5.972092e-02, 6.116283e-02, 6.251630e-02, 6.378064e-02,
  6.495526e-02, 6.603965e-02, 6.703344e-02, 6.793631e-02, 6.874808e-02, 6.946864e-02, 7.009800e-02, 7.063624e-02,
  7.108356e-02, 7.144026e-02, 7.170672e-02, 7.188342e-02, 7.197095e-02, 7.196998e-02, 7.188127e-02, 7.170568e-02,
  7.144416e-02, 7.109775e-02, 7.066757e-02, 7.015483e-02, 6.956084e-02, 6.888698e-02, 6.813471e-02, 6.730556e-02,
  6.640116e-02, 6.542321e-02, 6.437348e-02, 6.325380e-02, 6.206608e-02, 6.081230e-02, 5.949451e-02, 5.811480e-02,
  5.667533e-02, 5.517833e-02, 5.362606e-02, 5.202085e-02, 5.036506e-02, 4.866113e-02, 4.691150e-02, 4.511867e-02,
  4.328518e-02, 4.141359e-02, 3.950652e-02, 3.756657e-02, 3.559641e-02, 3.359871e-02, 3.157614e-02, 2.953142e-02,
  2.746727e-02, 2.538640e-02, 2.329153e-02, 2.118541e-02, 1.907076e-02, 1.695030e-02, 1.482674e-02, 1.270279e-02,
  1.058113e-02, 8.464445e-03, 6.355370e-03, 4.256535e-03, 2.170539e-03, 9.994788e-05,-1.952702e-03,-3.984914e-03,
 -5.994228e-03,-7.978228e-03,-9.934540e-03,-1.186084e-02,-1.375486e-02,-1.561437e-02,-1.743721e-02,-1.922127e-02,
 -2.096450e-02,-2.266492e-02,-2.432062e-02,-2.592973e-02,-2.749048e-02,-2.900116e-02,-3.046012e-02,-3.186580e-02,
 -3.321673e-02,-3.451148e-02,-3.574874e-02,-3.692726e-02,-3.804586e-02,-3.910348e-02,-4.009912e-02,-4.103186e-02,
 -4.190089e-02,-4.270547e-02,-4.344496e-02,-4.411878e-02,-4.472649e-02,-4.526768e-02,-4.574209e-02,-4.614949e-02,
 -4.648980e-02,-4.676297e-02,-4.696908e-02,-4.710828e-02,-4.718083e-02,-4.718704e-02,-4.712734e-02,-4.700224e-02,
 -4.681232e-02,-4.655825e-02,-4.624080e-02,-4.586080e-02,-4.541916e-02,-4.491689e-02,-4.435505e-02,-4.373479e-02,
 -4.305735e-02,-4.232399e-02,-4.153611e-02,-4.069511e-02,-3.980250e-02,-3.885983e-02,-3.786873e-02,-3.683087e-02,
 -3.574798e-02,-3.462186e-02,-3.345433e-02,-3.224729e-02,-3.100266e-02,-2.972242e-02,-2.840858e-02,-2.706320e-02,
 -2.568834e-02,-2.428614e-02,-2.285872e-02,-2.140826e-02,-1.993694e-02,-1.844698e-02,-1.694059e-02,-1.542002e-02,
 -1.388749e-02,-1.234528e-02,-1.079562e-02,-9.240768e-03,-7.682982e-03,-6.124500e-03,-4.567557e-03,-3.014374e-03,
 -1.467157e-03, 7.190752e-05, 1.600655e-03, 3.116944e-03, 4.618663e-03, 6.103729e-03, 7.570093e-03, 9.015742e-03,
  1.043870e-02, 1.183704e-02, 1.320887e-02, 1.455235e-02, 1.586569e-02, 1.714714e-02, 1.839502e-02, 1.960770e-02,
  2.078359e-02, 2.192120e-02, 2.301907e-02, 2.407580e-02, 2.509009e-02, 2.606067e-02, 2.698636e-02, 2.786605e-02,
  2.869869e-02, 2.948331e-02, 3.021902e-02, 3.090500e-02, 3.154050e-02, 3.212485e-02, 3.265748e-02, 3.313785e-02,
  3.356555e-02, 3.394022e-02, 3.426158e-02, 3.452945e-02, 3.474370e-02, 3.490430e-02, 3.501129e-02, 3.506480e-02,
  3.506503e-02, 3.501225e-02, 3.490682e-02, 3.474918e-02, 3.453982e-02, 3.427934e-02, 3.396839e-02, 3.360769e-02,
  3.319805e-02, 3.274033e-02, 3.223547e-02, 3.168447e-02, 3.108840e-02, 3.044838e-02, 2.976560e-02, 2.904133e-02,
  2.827685e-02, 2.747354e-02, 2.663280e-02, 2.575610e-02, 2.484495e-02, 2.390090e-02, 2.292556e-02, 2.192057e-02,
  2.088760e-02, 1.982837e-02, 1.874462e-02, 1.763813e-02, 1.651069e-02, 1.536415e-02, 1.420034e-02, 1.302113e-02,
  1.182840e-02, 1.062405e-02, 9.409987e-03, 8.188114e-03, 6.960351e-03, 5.728613e-03, 4.494815e-03, 3.260868e-03,
  2.028674e-03, 8.001248e-04,-4.229012e-04,-1.638541e-03,-2.844952e-03,-4.040312e-03,-5.222824e-03,-6.390716e-03,
 -7.542249e-03,-8.675713e-03,-9.789435e-03,-1.088178e-02,-1.195115e-02,-1.299599e-02,-1.401478e-02,-1.500607e-02,
 -1.596844e-02,-1.690052e-02,-1.780100e-02,-1.866861e-02,-1.950217e-02,-2.030051e-02,-2.106256e-02,-2.178729e-02,
 -2.247373e-02,-2.312099e-02,-2.372823e-02,-2.429468e-02,-2.481964e-02,-2.530247e-02,-2.574261e-02,-2.613955e-02,
 -2.649288e-02,-2.680222e-02,-2.706730e-02,-2.728789e-02,-2.746385e-02,-2.759510e-02,-2.768164e-02,-2.772352e-02,
 -2.772089e-02,-2.767394e-02,-2.758296e-02,-2.744828e-02,-2.727031e-02,-2.704952e-02,-2.678646e-02,-2.648174e-02,
 -2.613601e-02,-2.575002e-02,-2.532456e-02,-2.486048e-02,-2.435869e-02,-2.382015e-02,-2.324590e-02,-2.263699e-02,
 -2.199456e-02,-2.131978e-02,-2.061387e-02,-1.987810e-02,-1.911377e-02,-1.832224e-02,-1.750489e-02,-1.666315e-02,
 -1.579847e-02,-1.491234e-02,-1.400628e-02,-1.308183e-02,-1.214056e-02,-1.118406e-02,-1.021392e-02,-9.231784e-03,
 -8.239274e-03,-7.238039e-03,-6.229733e-03,-5.216015e-03,-4.198546e-03,-3.178988e-03,-2.158999e-03,-1.140233e-03,
 -1.243345e-04, 8.870622e-04, 1.892336e-03, 2.889881e-03, 3.878112e-03, 4.855461e-03, 5.820387e-03, 6.771372e-03,
  7.706927e-03, 8.625595e-03, 9.525949e-03, 1.040660e-02, 1.126619e-02, 1.210341e-02, 1.291698e-02, 1.370568e-02,
  1.446831e-02, 1.520374e-02, 1.591088e-02, 1.658869e-02, 1.723617e-02, 1.785240e-02, 1.843649e-02, 1.898760e-02,
  1.950499e-02, 1.998792e-02, 2.043576e-02, 2.084790e-02, 2.122382e-02, 2.156303e-02, 2.186514e-02, 2.212980e-02,
  2.235671e-02, 2.254566e-02, 2.269649e-02, 2.280910e-02, 2.288347e-02, 2.291961e-02, 2.291762e-02, 2.287766e-02,
  2.279995e-02, 2.268475e-02, 2.253242e-02, 2.234335e-02, 2.211799e-02, 2.185687e-02, 2.156056e-02, 2.122968e-02,
  2.086493e-02, 2.046703e-02, 2.003679e-02, 1.957503e-02, 1.908265e-02, 1.856059e-02, 1.800983e-02, 1.743139e-02,
  1.682636e-02, 1.619583e-02, 1.554095e-02, 1.486291e-02, 1.416294e-02, 1.344227e-02, 1.270220e-02, 1.194402e-02,
  1.116908e-02, 1.037874e-02, 9.574366e-03, 8.757363e-03, 7.929144e-03, 7.091136e-03, 6.244779e-03, 5.391520e-03,
  4.532815e-03, 3.670121e-03, 2.804899e-03, 1.938610e-03, 1.072708e-03, 2.086458e-04,-6.521347e-04,-1.508201e-03,
 -2.358133e-03,-3.200526e-03,-4.033994e-03,-4.857168e-03,-5.668703e-03,-6.467277e-03,-7.251595e-03,-8.020389e-03,
 -8.772423e-03,-9.506493e-03,-1.022143e-02,-1.091609e-02,-1.158939e-02,-1.224027e-02,-1.286771e-02,-1.347074e-02,
 -1.404843e-02,-1.459990e-02,-1.512431e-02,-1.562088e-02,-1.608887e-02,-1.652759e-02,-1.693641e-02,-1.731475e-02,
 -1.766207e-02,-1.797790e-02,-1.826182e-02,-1.851347e-02,-1.873254e-02,-1.891877e-02,-1.907197e-02,-1.919200e-02,
 -1.927877e-02,-1.933226e-02,-1.935251e-02,-1.933958e-02,-1.929363e-02,-1.921486e-02,-1.910352e-02,-1.895991e-02,
 -1.878439e-02,-1.857739e-02,-1.833936e-02,-1.807083e-02,-1.777236e-02,-1.744457e-02,-1.708812e-02,-1.670372e-02,
 -1.629214e-02,-1.585416e-02,-1.539065e-02,-1.490247e-02,-1.439055e-02,-1.385585e-02,-1.329937e-02,-1.272214e-02,
 -1.212522e-02,-1.150970e-02,-1.087670e-02,-1.022737e-02,-9.562887e-03,-8.884436e-03,-8.193232e-03,-7.490508e-03,
 -6.777509e-03,-6.055498e-03,-5.325745e-03,-4.589532e-03,-3.848148e-03,-3.102886e-03,-2.355040e-03,-1.605906e-03,
 -8.567797e-04,-1.089491e-04, 6.363019e-04, 1.377699e-03, 2.113977e-03, 2.843885e-03, 3.566187e-03, 4.279663e-03,
  4.983113e-03, 5.675358e-03, 6.355241e-03, 7.021632e-03, 7.673425e-03, 8.309546e-03, 8.928948e-03, 9.530618e-03,
  1.011358e-02, 1.067688e-02, 1.121963e-02, 1.174094e-02, 1.223999e-02, 1.271599e-02, 1.316820e-02, 1.359592e-02,
  1.399848e-02, 1.437527e-02, 1.472573e-02, 1.504935e-02, 1.534564e-02, 1.561420e-02, 1.585464e-02, 1.606665e-02,
  1.624995e-02, 1.640432e-02, 1.652960e-02, 1.662565e-02, 1.669242e-02, 1.672989e-02, 1.673809e-02, 1.671710e-02,
  1.666707e-02, 1.658817e-02, 1.648063e-02, 1.634476e-02, 1.618086e-02, 1.598933e-02, 1.577059e-02, 1.552512e-02,
  1.525342e-02, 1.495607e-02, 1.463367e-02, 1.428686e-02, 1.391633e-02, 1.352281e-02, 1.310707e-02, 1.266989e-02,
  1.221212e-02, 1.173463e-02, 1.123831e-02, 1.072410e-02, 1.019296e-02, 9.645870e-03, 9.083843e-03, 8.507911e-03,
  7.919130e-03, 7.318574e-03, 6.707333e-03, 6.086515e-03, 5.457239e-03, 4.820637e-03, 4.177849e-03, 3.530024e-03,
  2.878314e-03, 2.223877e-03, 1.567871e-03, 9.114518e-04, 2.557748e-04,-3.980107e-04,-1.048762e-03,-1.695345e-03,
 -2.336636e-03,-2.971526e-03,-3.598918e-03,-4.217732e-03,-4.826908e-03,-5.425405e-03,-6.012204e-03,-6.586309e-03,
 -7.146750e-03,-7.692584e-03,-8.222897e-03,-8.736805e-03,-9.233453e-03,-9.712023e-03,-1.017173e-02,-1.061182e-02,
 -1.103158e-02,-1.143034e-02,-1.180747e-02,-1.216235e-02,-1.249445e-02,-1.280324e-02,-1.308826e-02,-1.334907e-02,
 -1.358530e-02,-1.379661e-02,-1.398269e-02,-1.414332e-02,-1.427827e-02,-1.438740e-02,-1.447059e-02,-1.452779e-02,
 -1.455896e-02,-1.456415e-02,-1.454341e-02,-1.449688e-02,-1.442472e-02,-1.432714e-02,-1.420439e-02,-1.405676e-02,
 -1.388461e-02,-1.368831e-02,-1.346829e-02,-1.322501e-02,-1.295899e-02,-1.267076e-02,-1.236090e-02,-1.203004e-02,
 -1.167884e-02,-1.130797e-02,-1.091816e-02,-1.051016e-02,-1.008476e-02,-9.642774e-03,-9.185029e-03,-8.712396e-03,
 -8.225761e-03,-7.726035e-03,-7.214150e-03,-6.691054e-03,-6.157715e-03,-5.615116e-03,-5.064252e-03,-4.506131e-03,
 -3.941770e-03,-3.372196e-03,-2.798440e-03,-2.221539e-03,-1.642532e-03,-1.062459e-03,-4.823576e-04, 9.673565e-05,
  6.737904e-04, 1.247782e-03, 1.817696e-03, 2.382526e-03, 2.941279e-03, 3.492976e-03, 4.036652e-03, 4.571359e-03,
  5.096171e-03, 5.610179e-03, 6.112498e-03, 6.602264e-03, 7.078640e-03, 7.540816e-03, 7.988008e-03, 8.419462e-03,
  8.834454e-03, 9.232291e-03, 9.612314e-03, 9.973897e-03, 1.031645e-02, 1.063941e-02, 1.094228e-02, 1.122455e-02,
  1.148580e-02, 1.172561e-02, 1.194363e-02, 1.213953e-02, 1.231303e-02, 1.246387e-02, 1.259187e-02, 1.269687e-02,
  1.277873e-02, 1.283740e-02, 1.287283e-02, 1.288503e-02, 1.287406e-02, 1.283999e-02, 1.278297e-02, 1.270317e-02,
  1.260080e-02, 1.247611e-02, 1.232940e-02, 1.216099e-02, 1.197126e-02, 1.176061e-02, 1.152949e-02, 1.127837e-02,
  1.100777e-02, 1.071824e-02, 1.041035e-02, 1.008471e-02, 9.741970e-03, 9.382793e-03, 9.007878e-03, 8.617950e-03,
  8.213755e-03, 7.796068e-03, 7.365682e-03, 6.923413e-03, 6.470093e-03, 6.006575e-03, 5.533727e-03, 5.052430e-03,
  4.563578e-03, 4.068078e-03, 3.566844e-03, 3.060799e-03, 2.550872e-03, 2.037996e-03, 1.523107e-03, 1.007140e-03,
  4.910337e-04,-2.428016e-05,-5.378717e-04,-1.048817e-03,-1.556200e-03,-2.059114e-03,-2.556662e-03,-3.047960e-03,
 -3.532137e-03,-4.008339e-03,-4.475726e-03,-4.933481e-03,-5.380801e-03,-5.816909e-03,-6.241048e-03,-6.652486e-03,
 -7.050515e-03,-7.434454e-03,-7.803649e-03,-8.157476e-03,-8.495338e-03,-8.816672e-03,-9.120943e-03,-9.407651e-03,
 -9.676328e-03,-9.926541e-03,-1.015789e-02,-1.037001e-02,-1.056258e-02,-1.073531e-02,-1.088793e-02,-1.102024e-02,
 -1.113206e-02,-1.122323e-02,-1.129366e-02,-1.134329e-02,-1.137208e-02,-1.138004e-02,-1.136722e-02,-1.133371e-02,
 -1.127963e-02,-1.120514e-02,-1.111044e-02,-1.099575e-02,-1.086135e-02,-1.070754e-02,-1.053466e-02,-1.034308e-02,
 -1.013320e-02,-9.905458e-03,-9.660327e-03,-9.398301e-03,-9.119909e-03,-8.825708e-03,-8.516278e-03,-8.192231e-03,
 -7.854200e-03,-7.502843e-03,-7.138840e-03,-6.762892e-03,-6.375720e-03,-5.978064e-03,-5.570680e-03,-5.154341e-03,
 -4.729832e-03,-4.297953e-03,-3.859514e-03,-3.415334e-03,-2.966241e-03,-2.513071e-03,-2.056662e-03,-1.597858e-03,
 -1.137503e-03,-6.764447e-04,-2.155261e-04, 2.444106e-04, 7.025277e-04, 1.157993e-03, 1.609982e-03, 2.057679e-03,
  2.500277e-03, 2.936982e-03, 3.367013e-03, 3.789602e-03, 4.203999e-03, 4.609470e-03, 5.005298e-03, 5.390789e-03,
  5.765266e-03, 6.128076e-03, 6.478590e-03, 6.816203e-03, 7.140333e-03, 7.450426e-03, 7.745957e-03, 8.026426e-03,
  8.291364e-03, 8.540331e-03, 8.772918e-03, 8.988747e-03, 9.187471e-03, 9.368775e-03, 9.532380e-03, 9.678037e-03,
  9.805531e-03, 9.914682e-03, 1.000534e-02, 1.007740e-02, 1.013079e-02, 1.016544e-02, 1.018137e-02, 1.017859e-02,
  1.015717e-02, 1.011720e-02, 1.005880e-02, 9.982143e-03, 9.887416e-03, 9.774849e-03, 9.644699e-03, 9.497259e-03,
  9.332849e-03, 9.151822e-03, 8.954558e-03, 8.741468e-03, 8.512991e-03, 8.269590e-03, 8.011758e-03, 7.740011e-03,
  7.454888e-03, 7.156955e-03, 6.846797e-03, 6.525019e-03, 6.192248e-03, 5.849129e-03, 5.496323e-03, 5.134508e-03,
  4.764376e-03, 4.386634e-03, 4.001998e-03, 3.611198e-03, 3.214971e-03, 2.814063e-03, 2.409226e-03, 2.001217e-03,
  1.590797e-03, 1.178730e-03, 7.657796e-04, 3.527098e-04,-5.971767e-05,-4.707445e-04,-8.796169e-04,-1.285587e-03,
 -1.687916e-03,-2.085870e-03,-2.478730e-03,-2.865785e-03,-3.246339e-03,-3.619707e-03,-3.985223e-03,-4.342234e-03,
 -4.690107e-03,-5.028225e-03,-5.355994e-03,-5.672838e-03,-5.978204e-03,-6.271562e-03,-6.552404e-03,-6.820250e-03,
 -7.074642e-03,-7.315149e-03,-7.541367e-03,-7.752920e-03,-7.949461e-03,-8.130669e-03,-8.296254e-03,-8.445956e-03,
 -8.579545e-03,-8.696820e-03,-8.797612e-03,-8.881783e-03,-8.949226e-03,-8.999864e-03,-9.033654e-03,-9.050581e-03,
 -9.050665e-03,-9.033952e-03,-9.000525e-03,-8.950492e-03,-8.883996e-03,-8.801207e-03,-8.702327e-03,-8.587584e-03,
 -8.457239e-03,-8.311578e-03,-8.150915e-03,-7.975592e-03,-7.785977e-03,-7.582462e-03,-7.365465e-03,-7.135428e-03,
 -6.892814e-03,-6.638111e-03,-6.371825e-03,-6.094485e-03,-5.806636e-03,-5.508844e-03,-5.201688e-03,-4.885767e-03,
 -4.561692e-03,-4.230087e-03,-3.891591e-03,-3.546850e-03,-3.196523e-03,-2.841276e-03,-2.481784e-03,-2.118725e-03,
 -1.752784e-03,-1.384648e-03,-1.015008e-03,-6.445548e-04,-2.739777e-04, 9.603427e-05, 4.647955e-04, 8.316248e-04,
  1.195846e-03, 1.556791e-03, 1.913797e-03, 2.266214e-03, 2.613399e-03, 2.954723e-03, 3.289568e-03, 3.617331e-03,
  3.937423e-03, 4.249272e-03, 4.552321e-03, 4.846033e-03, 5.129888e-03, 5.403388e-03, 5.666054e-03, 5.917429e-03,
  6.157078e-03, 6.384590e-03, 6.599576e-03, 6.801674e-03, 6.990544e-03, 7.165874e-03, 7.327377e-03, 7.474792e-03,
  7.607887e-03, 7.726454e-03, 7.830317e-03, 7.919324e-03, 7.993353e-03, 8.052309e-03, 8.096127e-03, 8.124770e-03,
  8.138228e-03, 8.136521e-03, 8.119696e-03, 8.087828e-03, 8.041021e-03, 7.979406e-03, 7.903141e-03, 7.812410e-03,
  7.707426e-03, 7.588425e-03, 7.455670e-03, 7.309449e-03, 7.150074e-03, 6.977881e-03, 6.793228e-03, 6.596496e-03,
  6.388088e-03, 6.168425e-03, 5.937952e-03, 5.697130e-03, 5.446438e-03, 5.186372e-03, 4.917447e-03, 4.640189e-03,
  4.355141e-03, 4.062858e-03, 3.763905e-03, 3.458862e-03, 3.148315e-03, 2.832861e-03, 2.513102e-03, 2.189650e-03,
  1.863118e-03, 1.534125e-03, 1.203295e-03, 8.712490e-04, 5.386123e-04, 2.060079e-04,-1.259428e-04,-4.566213e-04,
 -7.854133e-04,-1.111710e-03,-1.434908e-03,-1.754413e-03,-2.069638e-03,-2.380006e-03,-2.684951e-03,-2.983919e-03,
 -3.276369e-03,-3.561772e-03,-3.839615e-03,-4.109400e-03,-4.370647e-03,-4.622892e-03,-4.865690e-03,-5.098613e-03,
 -5.321255e-03,-5.533230e-03,-5.734171e-03,-5.923736e-03,-6.101603e-03,-6.267473e-03,-6.421071e-03,-6.562146e-03,
 -6.690471e-03,-6.805841e-03,-6.908081e-03,-6.997036e-03,-7.072579e-03,-7.134609e-03,-7.183049e-03,-7.217847e-03,
 -7.238980e-03,-7.246448e-03,-7.240276e-03,-7.220518e-03,-7.187250e-03,-7.140574e-03,-7.080617e-03,-7.007531e-03,
 -6.921492e-03,-6.822699e-03,-6.711376e-03,-6.587767e-03,-6.452141e-03,-6.304788e-03,-6.146019e-03,-5.976166e-03,
 -5.795580e-03,-5.604631e-03,-5.403709e-03,-5.193219e-03,-4.973586e-03,-4.745248e-03,-4.508660e-03,-4.264291e-03,
 -4.012621e-03,-3.754146e-03,-3.489370e-03,-3.218810e-03,-2.942990e-03,-2.662444e-03,-2.377713e-03,-2.089344e-03,
 -1.797890e-03,-1.503906e-03,-1.207954e-03,-9.105943e-04,-6.123901e-04,-3.139043e-04,-1.569867e-05, 2.816674e-04,
  5.776374e-04, 8.716593e-04, 1.163186e-03, 1.451677e-03, 1.736600e-03, 2.017428e-03, 2.293647e-03, 2.564750e-03,
  2.830243e-03, 3.089644e-03, 3.342482e-03, 3.588302e-03, 3.826662e-03, 4.057136e-03, 4.279314e-03, 4.492802e-03,
  4.697225e-03, 4.892226e-03, 5.077464e-03, 5.252621e-03, 5.417398e-03, 5.571514e-03, 5.714712e-03, 5.846755e-03,
  5.967427e-03, 6.076535e-03, 6.173908e-03, 6.259398e-03, 6.332879e-03, 6.394249e-03, 6.443428e-03, 6.480360e-03,
  6.505012e-03, 6.517375e-03, 6.517461e-03, 6.505308e-03, 6.480974e-03, 6.444543e-03, 6.396118e-03, 6.335827e-03,
  6.263819e-03, 6.180265e-03, 6.085356e-03, 5.979306e-03, 5.862348e-03, 5.734735e-03, 5.596739e-03, 5.448652e-03,
  5.290784e-03, 5.123460e-03, 4.947025e-03, 4.761839e-03, 4.568278e-03, 4.366731e-03, 4.157602e-03, 3.941310e-03,
  3.718282e-03, 3.488961e-03, 3.253798e-03, 3.013254e-03, 2.767798e-03, 2.517910e-03, 2.264073e-03, 2.006778e-03,
  1.746522e-03, 1.483805e-03, 1.219129e-03, 9.530006e-04, 6.859262e-04, 4.184127e-04, 1.509665e-04,-1.159077e-04,
 -3.817078e-04,-6.459352e-04,-9.080956e-04,-1.167700e-03,-1.424267e-03,-1.677320e-03,-1.926392e-03,-2.171024e-03,
 -2.410769e-03,-2.645187e-03,-2.873853e-03,-3.096351e-03,-3.312281e-03,-3.521253e-03,-3.722894e-03,-3.916845e-03,
 -4.102763e-03,-4.280322e-03,-4.449210e-03,-4.609135e-03,-4.759822e-03,-4.901013e-03,-5.032472e-03,-5.153979e-03,
 -5.265334e-03,-5.366358e-03,-5.456891e-03,-5.536795e-03,-5.605949e-03,-5.664257e-03,-5.711641e-03,-5.748044e-03,
 -5.773432e-03,-5.787789e-03,-5.791123e-03,-5.783460e-03,-5.764850e-03,-5.735359e-03,-5.695078e-03,-5.644116e-03,
 -5.582601e-03,-5.510683e-03,-5.428529e-03,-5.336327e-03,-5.234281e-03,-5.122615e-03,-5.001570e-03,-4.871403e-03,
 -4.732390e-03,-4.584820e-03,-4.428999e-03,-4.265248e-03,-4.093901e-03,-3.915306e-03,-3.729823e-03,-3.537825e-03,
 -3.339697e-03,-3.135831e-03,-2.926631e-03,-2.712512e-03,-2.493893e-03,-2.271202e-03,-2.044875e-03,-1.815351e-03,
 -1.583075e-03,-1.348496e-03,-1.112066e-03,-8.742380e-04,-6.354678e-04,-3.962109e-04,-1.569223e-04, 8.194403e-05,
  3.199366e-04, 5.566067e-04, 7.915097e-04, 1.024206e-03, 1.254260e-03, 1.481244e-03, 1.704737e-03, 1.924327e-03,
  2.139607e-03, 2.350185e-03, 2.555673e-03, 2.755699e-03, 2.949900e-03, 3.137925e-03, 3.319437e-03, 3.494110e-03,
  3.661636e-03, 3.821719e-03, 3.974077e-03, 4.118445e-03, 4.254574e-03, 4.382231e-03, 4.501201e-03, 4.611284e-03,
  4.712300e-03, 4.804083e-03, 4.886490e-03, 4.959392e-03, 5.022680e-03, 5.076265e-03, 5.120076e-03, 5.154058e-03,
  5.178178e-03, 5.192422e-03, 5.196792e-03, 5.191312e-03, 5.176023e-03, 5.150984e-03, 5.116273e-03, 5.071987e-03,
  5.018239e-03, 4.955161e-03, 4.882903e-03, 4.801630e-03, 4.711525e-03, 4.612786e-03, 4.505630e-03, 4.390285e-03,
  4.266997e-03, 4.136024e-03, 3.997641e-03, 3.852132e-03, 3.699798e-03, 3.540949e-03, 3.375909e-03, 3.205009e-03,
  3.028593e-03, 2.847015e-03, 2.660636e-03, 2.469826e-03, 2.274960e-03, 2.076424e-03, 1.874605e-03, 1.669898e-03,
  1.462702e-03, 1.253419e-03, 1.042453e-03, 8.302115e-04, 6.171018e-04, 4.035323e-04, 1.899107e-04,-2.335610e-05,
 -2.358635e-04,-4.472095e-04,-6.569955e-04,-8.648273e-04,-1.070315e-03,-1.273076e-03,-1.472732e-03,-1.668913e-03,
 -1.861256e-03,-2.049409e-03,-2.233025e-03,-2.411769e-03,-2.585318e-03,-2.753356e-03,-2.915581e-03,-3.071704e-03,
 -3.221445e-03,-3.364541e-03,-3.500739e-03,-3.629803e-03,-3.751509e-03,-3.865650e-03,-3.972031e-03,-4.070474e-03,
 -4.160819e-03,-4.242918e-03,-4.316642e-03,-4.381876e-03,-4.438524e-03,-4.486506e-03,-4.525756e-03,-4.556230e-03,
 -4.577897e-03,-4.590743e-03,-4.594773e-03,-4.590008e-03,-4.576484e-03,-4.554256e-03,-4.523394e-03,-4.483985e-03,
 -4.436131e-03,-4.379951e-03,-4.315579e-03,-4.243163e-03,-4.162869e-03,-4.074875e-03,-3.979372e-03,-3.876569e-03,
 -3.766683e-03,-3.649949e-03,-3.526610e-03,-3.396924e-03,-3.261158e-03,-3.119592e-03,-2.972513e-03,-2.820221e-03,
 -2.663023e-03,-2.501235e-03,-2.335181e-03,-2.165191e-03,-1.991603e-03,-1.814759e-03,-1.635008e-03,-1.452703e-03,
 -1.268200e-03,-1.081857e-03,-8.940377e-04,-7.051045e-04,-5.154220e-04,-3.253549e-04,-1.352673e-04, 5.447769e-05,
  2.435188e-04, 4.314972e-04, 6.180575e-04, 8.028478e-04, 9.855211e-04, 1.165735e-03, 1.343154e-03, 1.517448e-03,
  1.688293e-03, 1.855376e-03, 2.018388e-03, 2.177033e-03, 2.331021e-03, 2.480072e-03, 2.623919e-03, 2.762304e-03,
  2.894979e-03, 3.021711e-03, 3.142276e-03, 3.256464e-03, 3.364079e-03, 3.464935e-03, 3.558862e-03, 3.645704e-03,
  3.725317e-03, 3.797574e-03, 3.862360e-03, 3.919577e-03, 3.969139e-03, 4.010977e-03, 4.045037e-03, 4.071279e-03,
  4.089679e-03, 4.100227e-03, 4.102929e-03, 4.097807e-03, 4.084895e-03, 4.064244e-03, 4.035919e-03, 4.000001e-03,
  3.956581e-03, 3.905770e-03, 3.847688e-03, 3.782470e-03, 3.710265e-03, 3.631235e-03, 3.545553e-03, 3.453405e-03,
  3.354990e-03, 3.250515e-03, 3.140202e-03, 3.024281e-03, 2.902992e-03, 2.776586e-03, 2.645321e-03, 2.509465e-03,
  2.369294e-03, 2.225089e-03, 2.077141e-03, 1.925746e-03, 1.771204e-03, 1.613822e-03, 1.453911e-03, 1.291785e-03,
  1.127763e-03, 9.621648e-04, 7.953127e-04, 6.275305e-04, 4.591427e-04, 2.904738e-04, 1.218477e-04,-4.641261e-05,
 -2.139862e-04,-3.805544e-04,-5.458014e-04,-7.094152e-04,-8.710880e-04,-1.030516e-03,-1.187403e-03,-1.341455e-03,
 -1.492387e-03,-1.639920e-03,-1.783785e-03,-1.923716e-03,-2.059459e-03,-2.190769e-03,-2.317408e-03,-2.439150e-03,
 -2.555778e-03,-2.667086e-03,-2.772878e-03,-2.872971e-03,-2.967192e-03,-3.055380e-03,-3.137386e-03,-3.213075e-03,
 -3.282324e-03,-3.345020e-03,-3.401066e-03,-3.450378e-03,-3.492884e-03,-3.528525e-03,-3.557256e-03,-3.579047e-03,
 -3.593879e-03,-3.601747e-03,-3.602661e-03,-3.596642e-03,-3.583725e-03,-3.563959e-03,-3.537405e-03,-3.504138e-03,
 -3.464244e-03,-3.417823e-03,-3.364986e-03,-3.305857e-03,-3.240570e-03,-3.169273e-03,-3.092123e-03,-3.009287e-03,
 -2.920945e-03,-2.827285e-03,-2.728505e-03,-2.624813e-03,-2.516424e-03,-2.403563e-03,-2.286462e-03,-2.165361e-03,
 -2.040505e-03,-1.912148e-03,-1.780547e-03,-1.645968e-03,-1.508679e-03,-1.368952e-03,-1.227065e-03,-1.083298e-03,
 -9.379329e-04,-7.912549e-04,-6.435503e-04,-4.951064e-04,-3.462109e-04,-1.971514e-04,-4.821491e-05, 1.003129e-04,
  2.481481e-04, 3.950090e-04, 5.406168e-04, 6.846961e-04, 8.269753e-04, 9.671874e-04, 1.105070e-03, 1.240366e-03,
  1.372825e-03, 1.502202e-03, 1.628259e-03, 1.750766e-03, 1.869498e-03, 1.984243e-03, 2.094791e-03, 2.200947e-03,
  2.302521e-03, 2.399334e-03, 2.491216e-03, 2.578008e-03, 2.659562e-03, 2.735738e-03, 2.806409e-03, 2.871459e-03,
  2.930782e-03, 2.984284e-03, 3.031884e-03, 3.073509e-03, 3.109101e-03, 3.138614e-03, 3.162011e-03, 3.179269e-03,
  3.190376e-03, 3.195334e-03, 3.194154e-03, 3.186860e-03, 3.173487e-03, 3.154084e-03, 3.128708e-03, 3.097430e-03,
  3.060331e-03, 3.017502e-03, 2.969047e-03, 2.915078e-03, 2.855720e-03, 2.791105e-03, 2.721377e-03, 2.646687e-03,
  2.567198e-03, 2.483079e-03, 2.394509e-03, 2.301673e-03, 2.204767e-03, 2.103991e-03, 1.999553e-03, 1.891666e-03,
  1.780552e-03, 1.666434e-03, 1.549545e-03, 1.430118e-03, 1.308394e-03, 1.184613e-03, 1.059023e-03, 9.318712e-04,
  8.034082e-04, 6.738862e-04, 5.435584e-04, 4.126786e-04, 2.815009e-04, 1.502791e-04, 1.926591e-05,-1.112869e-04,
 -2.411297e-04,-3.700148e-04,-4.976974e-04,-6.239360e-04,-7.484925e-04,-8.711331e-04,-9.916284e-04,-1.109754e-03,
 -1.225291e-03,-1.338026e-03,-1.447752e-03,-1.554269e-03,-1.657382e-03,-1.756906e-03,-1.852662e-03,-1.944479e-03,
 -2.032194e-03,-2.115653e-03,-2.194711e-03,-2.269232e-03,-2.339088e-03,-2.404162e-03,-2.464345e-03,-2.519540e-03,
 -2.569658e-03,-2.614622e-03,-2.654363e-03,-2.688824e-03,-2.717958e-03,-2.741728e-03,-2.760108e-03,-2.773082e-03,
 -2.780646e-03,-2.782804e-03,-2.779572e-03,-2.770976e-03,-2.757053e-03,-2.737848e-03,-2.713419e-03,-2.683832e-03,
 -2.649163e-03,-2.609497e-03,-2.564930e-03,-2.515566e-03,-2.461517e-03,-2.402905e-03,-2.339860e-03,-2.272520e-03,
 -2.201031e-03,-2.125547e-03,-2.046228e-03,-1.963240e-03,-1.876759e-03,-1.786963e-03,-1.694039e-03,-1.598177e-03,
 -1.499574e-03,-1.398430e-03,-1.294949e-03,-1.189341e-03,-1.081816e-03,-9.725905e-04,-8.618808e-04,-7.499065e-04,
 -6.368884e-04,-5.230488e-04,-4.086105e-04,-2.937968e-04,-1.788309e-04,-6.393543e-05, 5.066802e-05, 1.647591e-04,
  2.781195e-04, 3.905327e-04, 5.017853e-04, 6.116666e-04, 7.199695e-04, 8.264906e-04, 9.310309e-04, 1.033396e-03,
  1.133396e-03, 1.230846e-03, 1.325568e-03, 1.417390e-03, 1.506144e-03, 1.591670e-03, 1.673816e-03, 1.752435e-03,
  1.827389e-03, 1.898547e-03, 1.965785e-03, 2.028988e-03, 2.088050e-03, 2.142872e-03, 2.193363e-03, 2.239443e-03,
  2.281039e-03, 2.318088e-03, 2.350536e-03, 2.378336e-03, 2.401453e-03, 2.419860e-03, 2.433540e-03, 2.442483e-03,
  2.446691e-03, 2.446173e-03, 2.440948e-03, 2.431044e-03, 2.416499e-03, 2.397357e-03, 2.373675e-03, 2.345513e-03,
  2.312945e-03, 2.276050e-03, 2.234916e-03, 2.189638e-03, 2.140321e-03, 2.087074e-03, 2.030016e-03, 1.969272e-03,
  1.904974e-03, 1.837259e-03, 1.766271e-03, 1.692162e-03, 1.615085e-03, 1.535201e-03, 1.452676e-03, 1.367680e-03,
  1.280387e-03, 1.190973e-03, 1.099621e-03, 1.006515e-03, 9.118421e-04, 8.157908e-04, 7.185527e-04, 6.203205e-04,
  5.212883e-04, 4.216509e-04, 3.216033e-04, 2.213409e-04, 1.210586e-04, 2.095056e-05,-7.879007e-05,-1.779716e-04,
 -2.764043e-04,-3.739004e-04,-4.702749e-04,-5.653454e-04,-6.589330e-04,-7.508623e-04,-8.409617e-04,-9.290638e-04,
 -1.015006e-03,-1.098630e-03,-1.179783e-03,-1.258318e-03,-1.334092e-03,-1.406970e-03,-1.476823e-03,-1.543525e-03,
 -1.606961e-03,-1.667021e-03,-1.723602e-03,-1.776606e-03,-1.825947e-03,-1.871543e-03,-1.913320e-03,-1.951211e-03,
 -1.985161e-03,-2.015116e-03,-2.041037e-03,-2.062888e-03,-2.080643e-03,-2.094284e-03,-2.103800e-03,-2.109190e-03,
 -2.110460e-03,-2.107622e-03,-2.100700e-03,-2.089723e-03,-2.074727e-03,-2.055759e-03,-2.032871e-03,-2.006122e-03,
 -1.975580e-03,-1.941319e-03,-1.903421e-03,-1.861973e-03,-1.817070e-03,-1.768812e-03,-1.717308e-03,-1.662670e-03,
 -1.605015e-03,-1.544469e-03,-1.481159e-03,-1.415221e-03,-1.346792e-03,-1.276015e-03,-1.203037e-03,-1.128008e-03,
 -1.051082e-03,-9.724166e-04,-8.921704e-04,-8.105059e-04,-7.275871e-04,-6.435802e-04,-5.586524e-04,-4.729724e-04,
 -3.867094e-04,-3.000333e-04,-2.131139e-04,-1.261210e-04,-3.922375e-05, 4.740960e-05, 1.336119e-04, 2.192175e-04,
  3.040627e-04, 3.879858e-04, 4.708275e-04, 5.524314e-04, 6.326441e-04, 7.113154e-04, 7.882988e-04, 8.634516e-04,
  9.366353e-04, 1.007716e-03, 1.076564e-03, 1.143054e-03, 1.207067e-03, 1.268490e-03, 1.327212e-03, 1.383131e-03,
  1.436150e-03, 1.486177e-03, 1.533128e-03, 1.576924e-03, 1.617492e-03, 1.654767e-03, 1.688691e-03, 1.719210e-03,
  1.746280e-03, 1.769861e-03, 1.789923e-03, 1.806441e-03, 1.819396e-03, 1.828780e-03, 1.834587e-03, 1.836822e-03,
  1.835494e-03, 1.830622e-03, 1.822228e-03, 1.810344e-03, 1.795007e-03, 1.776261e-03, 1.754157e-03, 1.728751e-03,
  1.700107e-03, 1.668293e-03, 1.633384e-03, 1.595461e-03, 1.554610e-03, 1.510923e-03, 1.464497e-03, 1.415432e-03,
  1.363835e-03, 1.309817e-03, 1.253493e-03, 1.194982e-03, 1.134407e-03, 1.071895e-03, 1.007574e-03, 9.415775e-04,
  8.740409e-04, 8.051017e-04, 7.348998e-04, 6.635772e-04, 5.912770e-04, 5.181440e-04, 4.443240e-04, 3.699632e-04,
  2.952088e-04, 2.202076e-04, 1.451066e-04, 7.005225e-05,-4.809575e-06,-7.933409e-05,-1.533777e-04,-2.267985e-04,
 -2.994562e-04,-3.712126e-04,-4.419320e-04,-5.114810e-04,-5.797294e-04,-6.465498e-04,-7.118182e-04,-7.754142e-04,
 -8.372210e-04,-8.971260e-04,-9.550206e-04,-1.010801e-03,-1.064367e-03,-1.115623e-03,-1.164481e-03,-1.210855e-03,
 -1.254665e-03,-1.295838e-03,-1.334303e-03,-1.369998e-03,-1.402865e-03,-1.432852e-03,-1.459912e-03,-1.484007e-03,
 -1.505101e-03,-1.523166e-03,-1.538180e-03,-1.550127e-03,-1.558996e-03,-1.564784e-03,-1.567493e-03,-1.567130e-03,
 -1.563708e-03,-1.557249e-03,-1.547778e-03,-1.535326e-03,-1.519930e-03,-1.501632e-03,-1.480482e-03,-1.456532e-03,
 -1.429841e-03,-1.400473e-03,-1.368497e-03,-1.333986e-03,-1.297019e-03,-1.257677e-03,-1.216049e-03,-1.172226e-03,
 -1.126301e-03,-1.078374e-03,-1.028547e-03,-9.769246e-04,-9.236162e-04,-8.687327e-04,-8.123880e-04,-7.546981e-04,
 -6.957815e-04,-6.357585e-04,-5.747508e-04,-5.128817e-04,-4.502756e-04,-3.870579e-04,-3.233546e-04,-2.592919e-04,
 -1.949964e-04,-1.305946e-04,-6.621260e-05,-1.975846e-06, 6.199095e-05, 1.255642e-04, 1.886215e-04, 2.510422e-04,
  3.127071e-04, 3.734994e-04, 4.333042e-04, 4.920091e-04, 5.495043e-04, 6.056831e-04, 6.604414e-04, 7.136788e-04,
  7.652979e-04, 8.152051e-04, 8.633105e-04, 9.095282e-04, 9.537763e-04, 9.959770e-04, 1.036057e-03, 1.073947e-03,
  1.109584e-03, 1.142906e-03, 1.173861e-03, 1.202397e-03, 1.228469e-03, 1.252038e-03, 1.273069e-03, 1.291532e-03,
  1.307401e-03, 1.320658e-03, 1.331288e-03, 1.339283e-03, 1.344637e-03, 1.347353e-03, 1.347437e-03, 1.344900e-03,
  1.339760e-03, 1.332036e-03, 1.321757e-03, 1.308954e-03, 1.293662e-03, 1.275923e-03, 1.255783e-03, 1.233291e-03,
  1.208502e-03, 1.181474e-03, 1.152270e-03, 1.120958e-03, 1.087607e-03, 1.052293e-03, 1.015092e-03, 9.760855e-04,
  9.353585e-04, 8.929980e-04, 8.490940e-04, 8.037393e-04, 7.570290e-04, 7.090605e-04, 6.599331e-04, 6.097480e-04,
  5.586082e-04, 5.066178e-04, 4.538822e-04, 4.005080e-04, 3.466022e-04, 2.922727e-04, 2.376275e-04, 1.827748e-04,
  1.278228e-04, 7.287944e-05, 1.805195e-05,-3.655299e-05,-9.082966e-05,-1.446734e-04,-1.979811e-04,-2.506507e-04,
 -3.025824e-04,-3.536780e-04,-4.038413e-04,-4.529785e-04,-5.009983e-04,-5.478119e-04,-5.933332e-04,-6.374792e-04,
 -6.801698e-04,-7.213282e-04,-7.608810e-04,-7.987582e-04,-8.348933e-04,-8.692238e-04,-9.016908e-04,-9.322394e-04,
 -9.608185e-04,-9.873815e-04,-1.011886e-03,-1.034293e-03,-1.054568e-03,-1.072682e-03,-1.088610e-03,-1.102330e-03,
 -1.113825e-03,-1.123084e-03,-1.130098e-03,-1.134866e-03,-1.137386e-03,-1.137666e-03,-1.135714e-03,-1.131546e-03,
 -1.125179e-03,-1.116637e-03,-1.105946e-03,-1.093136e-03,-1.078244e-03,-1.061308e-03,-1.042371e-03,-1.021479e-03,
 -9.986823e-04,-9.740342e-04,-9.475919e-04,-9.194156e-04,-8.895685e-04,-8.581170e-04,-8.251303e-04,-7.906802e-04,
 -7.548410e-04,-7.176895e-04,-6.793047e-04,-6.397676e-04,-5.991612e-04,-5.575700e-04,-5.150801e-04,-4.717792e-04,
 -4.277559e-04,-3.830999e-04,-3.379017e-04,-2.922525e-04,-2.462440e-04,-1.999680e-04,-1.535165e-04,-1.069815e-04,
 -6.045452e-05,-1.402683e-05, 3.221102e-05, 7.816924e-05, 1.237590e-04, 1.688928e-04, 2.134840e-04, 2.574480e-04,
  3.007013e-04, 3.431627e-04, 3.847524e-04, 4.253931e-04, 4.650097e-04, 5.035291e-04, 5.408812e-04, 5.769981e-04,
  6.118149e-04, 6.452695e-04, 6.773028e-04, 7.078586e-04, 7.368842e-04, 7.643297e-04, 7.901489e-04, 8.142990e-04,
  8.367405e-04, 8.574376e-04, 8.763580e-04, 8.934730e-04, 9.087577e-04, 9.221910e-04, 9.337552e-04, 9.434368e-04,
  9.512256e-04, 9.571156e-04, 9.611043e-04, 9.631930e-04, 9.633868e-04, 9.616943e-04, 9.581280e-04, 9.527040e-04,
  9.454418e-04, 9.363645e-04, 9.254987e-04, 9.128745e-04, 8.985250e-04, 8.824868e-04, 8.647996e-04, 8.455060e-04,
  8.246518e-04, 8.022853e-04, 7.784580e-04, 7.532236e-04, 7.266385e-04, 6.987616e-04, 6.696537e-04, 6.393781e-04,
  6.079999e-04, 5.755861e-04, 5.422054e-04, 5.079280e-04, 4.728257e-04, 4.369714e-04, 4.004392e-04, 3.633042e-04,
  3.256423e-04, 2.875299e-04, 2.490443e-04, 2.102627e-04, 1.712629e-04, 1.321225e-04, 9.291909e-05, 5.372999e-05,
  1.463211e-05,-2.429818e-05,-6.298523e-05,-1.013542e-04,-1.393314e-04,-1.768440e-04,-2.138206e-04,-2.501913e-04,
 -2.858876e-04,-3.208427e-04,-3.549915e-04,-3.882710e-04,-4.206201e-04,-4.519798e-04,-4.822934e-04,-5.115065e-04,
 -5.395673e-04,-5.664262e-04,-5.920366e-04,-6.163542e-04,-6.393378e-04,-6.609488e-04,-6.811516e-04,-6.999135e-04,
 -7.172050e-04,-7.329993e-04,-7.472729e-04,-7.600054e-04,-7.711795e-04,-7.807810e-04,-7.887991e-04,-7.952259e-04,
 -8.000567e-04,-8.032902e-04,-8.049280e-04,-8.049751e-04,-8.034392e-04,-8.003316e-04,-7.956662e-04,-7.894601e-04,
 -7.817334e-04,-7.725089e-04,-7.618125e-04,-7.496727e-04,-7.361206e-04,-7.211903e-04,-7.049180e-04,-6.873426e-04,
 -6.685055e-04,-6.484500e-04,-6.272220e-04,-6.048692e-04,-5.814413e-04,-5.569901e-04,-5.315689e-04,-5.052327e-04,
 -4.780380e-04,-4.500430e-04,-4.213067e-04,-3.918897e-04,-3.618533e-04,-3.312600e-04,-3.001728e-04,-2.686555e-04,
 -2.367726e-04,-2.045886e-04,-1.721685e-04,-1.395775e-04,-1.068806e-04,-7.414293e-05,-4.142911e-05,-8.803527e-06,
  2.366997e-05, 5.592814e-05, 8.790853e-05, 1.195495e-04, 1.507905e-04, 1.815719e-04, 2.118356e-04, 2.415243e-04,
  2.705828e-04, 2.989568e-04, 3.265940e-04, 3.534438e-04, 3.794573e-04, 4.045876e-04, 4.287896e-04, 4.520206e-04,
  4.742398e-04, 4.954085e-04, 5.154907e-04, 5.344522e-04, 5.522617e-04, 5.688900e-04, 5.843105e-04, 5.984990e-04,
  6.114342e-04, 6.230970e-04, 6.334712e-04, 6.425430e-04, 6.503013e-04, 6.567380e-04, 6.618471e-04, 6.656256e-04,
  6.680731e-04, 6.691918e-04, 6.689865e-04, 6.674647e-04, 6.646362e-04, 6.605138e-04, 6.551123e-04, 6.484492e-04,
  6.405444e-04, 6.314201e-04, 6.211009e-04, 6.096134e-04, 5.969866e-04, 5.832516e-04, 5.684413e-04, 5.525909e-04,
  5.357371e-04, 5.179187e-04, 4.991760e-04, 4.795511e-04, 4.590875e-04, 4.378301e-04, 4.158252e-04, 3.931203e-04,
  3.697642e-04, 3.458064e-04, 3.212977e-04, 2.962894e-04, 2.708337e-04, 2.449834e-04, 2.187917e-04, 1.923124e-04,
  1.655993e-04, 1.387066e-04, 1.116885e-04, 8.459913e-05, 5.749248e-05, 3.042230e-05, 3.441998e-06,-2.339551e-05,
 -5.003785e-05,-7.643333e-05,-1.025310e-04,-1.282809e-04,-1.536338e-04,-1.785416e-04,-2.029576e-04,-2.268359e-04,
 -2.501322e-04,-2.728035e-04,-2.948083e-04,-3.161066e-04,-3.366601e-04,-3.564320e-04,-3.753875e-04,-3.934935e-04,
 -4.107187e-04,-4.270337e-04,-4.424113e-04,-4.568259e-04,-4.702544e-04,-4.826754e-04,-4.940700e-04,-5.044210e-04,
 -5.137137e-04,-5.219354e-04,-5.290758e-04,-5.351265e-04,-5.400815e-04,-5.439371e-04,-5.466917e-04,-5.483457e-04,
 -5.489020e-04,-5.483655e-04,-5.467432e-04,-5.440445e-04,-5.402805e-04,-5.354645e-04,-5.296120e-04,-5.227403e-04,
 -5.148686e-04,-5.060180e-04,-4.962117e-04,-4.854741e-04,-4.738320e-04,-4.613133e-04,-4.479478e-04,-4.337666e-04,
 -4.188026e-04,-4.030896e-04,-3.866632e-04,-3.695598e-04,-3.518172e-04,-3.334741e-04,-3.145704e-04,-2.951467e-04,
 -2.752445e-04,-2.549060e-04,-2.341740e-04,-2.130920e-04,-1.917036e-04,-1.700533e-04,-1.481854e-04,-1.261447e-04,
 -1.039758e-04,-8.172368e-05,-5.943291e-05,-3.714806e-05,-1.491340e-05, 7.227141e-06, 2.923007e-05, 5.105241e-05,
  7.265176e-05, 9.398642e-05, 1.150155e-04, 1.356987e-04, 1.559971e-04, 1.758722e-04, 1.952871e-04, 2.142055e-04,
  2.325928e-04, 2.504152e-04, 2.676405e-04, 2.842378e-04, 3.001776e-04, 3.154318e-04, 3.299740e-04, 3.437793e-04,
  3.568242e-04, 3.690872e-04, 3.805482e-04, 3.911889e-04, 4.009929e-04, 4.099452e-04, 4.180329e-04, 4.252448e-04,
  4.315715e-04, 4.370053e-04, 4.415406e-04, 4.451733e-04, 4.479014e-04, 4.497245e-04, 4.506442e-04, 4.506637e-04,
  4.497882e-04, 4.480244e-04, 4.453809e-04, 4.418680e-04, 4.374976e-04, 4.322834e-04, 4.262404e-04, 4.193856e-04,
  4.117371e-04, 4.033148e-04, 3.941399e-04, 3.842348e-04, 3.736237e-04, 3.623316e-04, 3.503850e-04, 3.378114e-04,
  3.246394e-04, 3.108989e-04, 2.966204e-04, 2.818355e-04, 2.665767e-04, 2.508770e-04, 2.347703e-04, 2.182910e-04,
  2.014743e-04, 1.843556e-04, 1.669708e-04, 1.493561e-04, 1.315480e-04, 1.135831e-04, 9.549824e-05, 7.733019e-05,
  5.911570e-05, 4.089138e-05, 2.269370e-05, 4.558819e-06,-1.347740e-05,-3.137952e-05,-4.911255e-05,-6.664206e-05,
 -8.393421e-05,-1.009558e-04,-1.176745e-04,-1.340585e-04,-1.500772e-04,-1.657005e-04,-1.808996e-04,-1.956466e-04,
 -2.099146e-04,-2.236779e-04,-2.369119e-04,-2.495932e-04,-2.616997e-04,-2.732105e-04,-2.841061e-04,-2.943682e-04,
 -3.039801e-04,-3.129262e-04,-3.211926e-04,-3.287668e-04,-3.356375e-04,-3.417952e-04,-3.472316e-04,-3.519401e-04,
 -3.559156e-04,-3.591544e-04,-3.616542e-04,-3.634144e-04,-3.644358e-04,-3.647207e-04,-3.642727e-04,-3.630971e-04,
 -3.612005e-04,-3.585909e-04,-3.552776e-04,-3.512715e-04,-3.465846e-04,-3.412303e-04,-3.352232e-04,-3.285791e-04,
 -3.213152e-04,-3.134495e-04,-3.050014e-04,-2.959911e-04,-2.864401e-04,-2.763706e-04,-2.658058e-04,-2.547699e-04,
 -2.432877e-04,-2.313847e-04,-2.190874e-04,-2.064227e-04,-1.934181e-04,-1.801016e-04,-1.665019e-04,-1.526477e-04,
 -1.385684e-04,-1.242935e-04,-1.098528e-04,-9.527619e-05,-8.059364e-05,-6.583524e-05,-5.103102e-05,-3.621091e-05,
 -2.140472e-05,-6.642041e-06, 8.047786e-06, 2.263575e-05, 3.709320e-05, 5.139192e-05, 6.550420e-05, 7.940284e-05,
  9.306123e-05, 1.064534e-04, 1.195541e-04, 1.323388e-04, 1.447837e-04, 1.568659e-04, 1.685633e-04, 1.798547e-04,
  1.907199e-04, 2.011396e-04, 2.110956e-04, 2.205707e-04, 2.295487e-04, 2.380146e-04, 2.459545e-04, 2.533555e-04,
  2.602061e-04, 2.664957e-04, 2.722152e-04, 2.773563e-04, 2.819124e-04, 2.858777e-04, 2.892478e-04, 2.920195e-04,
  2.941909e-04, 2.957611e-04, 2.967307e-04, 2.971013e-04, 2.968757e-04, 2.960580e-04, 2.946535e-04, 2.926683e-04,
  2.901101e-04, 2.869874e-04, 2.833098e-04, 2.790882e-04, 2.743343e-04, 2.690608e-04, 2.632815e-04, 2.570110e-04,
  2.502649e-04, 2.430596e-04, 2.354124e-04, 2.273414e-04, 2.188653e-04, 2.100035e-04, 2.007764e-04, 1.912045e-04,
  1.813093e-04, 1.711127e-04, 1.606368e-04, 1.499046e-04, 1.389391e-04, 1.277637e-04, 1.164024e-04, 1.048790e-04,
  9.321767e-05, 8.144276e-05, 6.957863e-05, 5.764969e-05, 4.568034e-05, 3.369490e-05, 2.171760e-05, 9.772479e-06,
 -2.116612e-06,-1.392609e-05,-2.563266e-05,-3.721341e-05,-4.864577e-05,-5.990765e-05,-7.097741e-05,-8.183393e-05,
 -9.245668e-05,-1.028257e-04,-1.129216e-04,-1.227258e-04,-1.322203e-04,-1.413878e-04,-1.502120e-04,-1.586772e-04,
 -1.667684e-04,-1.744717e-04,-1.817740e-04,-1.886630e-04,-1.951273e-04,-2.011566e-04,-2.067413e-04,-2.118729e-04,
 -2.165440e-04,-2.207478e-04,-2.244789e-04,-2.277325e-04,-2.305051e-04,-2.327940e-04,-2.345976e-04,-2.359153e-04,
 -2.367474e-04,-2.370952e-04,-2.369609e-04,-2.363480e-04,-2.352604e-04,-2.337034e-04,-2.316830e-04,-2.292061e-04,
 -2.262806e-04,-2.229151e-04,-2.191191e-04,-2.149029e-04,-2.102777e-04,-2.052554e-04,-1.998484e-04,-1.940701e-04,
 -1.879345e-04,-1.814561e-04,-1.746502e-04,-1.675325e-04,-1.601193e-04,-1.524274e-04,-1.444741e-04,-1.362771e-04,
 -1.278543e-04,-1.192242e-04,-1.104056e-04,-1.014173e-04,-9.227869e-05,-8.300902e-05,-7.362786e-05,-6.415485e-05,
 -5.460969e-05,-4.501211e-05,-3.538181e-05,-2.573845e-05,-1.610158e-05,-6.490622e-06, 3.075165e-06, 1.257675e-05,
  2.199533e-05, 3.131241e-05, 4.050979e-05, 4.956965e-05, 5.847455e-05, 6.720745e-05, 7.575180e-05, 8.409151e-05,
  9.221102e-05, 1.000953e-04, 1.077299e-04, 1.151009e-04, 1.221951e-04, 1.290000e-04, 1.355035e-04, 1.416944e-04,
  1.475622e-04, 1.530970e-04, 1.582898e-04, 1.631322e-04, 1.676166e-04, 1.717363e-04, 1.754851e-04, 1.788579e-04,
  1.818501e-04, 1.844582e-04, 1.866794e-04, 1.885114e-04, 1.899532e-04, 1.910043e-04, 1.916650e-04, 1.919364e-04,
  1.918205e-04, 1.913199e-04, 1.904382e-04, 1.891794e-04, 1.875487e-04, 1.855515e-04, 1.831943e-04, 1.804842e-04,
  1.774289e-04, 1.740367e-04, 1.703167e-04, 1.662784e-04, 1.619322e-04, 1.572887e-04, 1.523593e-04, 1.471557e-04,
  1.416902e-04, 1.359757e-04, 1.300252e-04, 1.238522e-04, 1.174709e-04, 1.108953e-04, 1.041401e-04, 9.722005e-05,
  9.015029e-05, 8.294609e-05, 7.562289e-05, 6.819631e-05, 6.068206e-05, 5.309592e-05, 4.545375e-05, 3.777138e-05,
  3.006465e-05, 2.234934e-05, 1.464115e-05, 6.955656e-06,-6.917018e-07,-8.285661e-06,-1.581117e-05,-2.325339e-05,
 -3.059779e-05,-3.783009e-05,-4.493634e-05,-5.190294e-05,-5.871665e-05,-6.536465e-05,-7.183451e-05,-7.811426e-05,
 -8.419237e-05,-9.005782e-05,-9.570008e-05,-1.011091e-04,-1.062755e-04,-1.111903e-04,-1.158452e-04,-1.202324e-04,
 -1.243447e-04,-1.281755e-04,-1.317189e-04,-1.349697e-04,-1.379229e-04,-1.405747e-04,-1.429215e-04,-1.449607e-04,
 -1.466899e-04,-1.481078e-04,-1.492135e-04,-1.500067e-04,-1.504879e-04,-1.506581e-04,-1.505190e-04,-1.500730e-04,
 -1.493228e-04,-1.482720e-04,-1.469248e-04,-1.452857e-04,-1.433600e-04,-1.411534e-04,-1.386724e-04,-1.359237e-04,
 -1.329147e-04,-1.296531e-04,-1.261473e-04,-1.224060e-04,-1.184383e-04,-1.142538e-04,-1.098624e-04,-1.052743e-04,
 -1.005002e-04,-9.555109e-05,-9.043806e-05,-8.517264e-05,-7.976652e-05,-7.423162e-05,-6.858005e-05,-6.282406e-05,
 -5.697605e-05,-5.104852e-05,-4.505405e-05,-3.900528e-05,-3.291486e-05,-2.679546e-05,-2.065973e-05,-1.452026e-05,
 -8.389557e-06,-2.280050e-06, 3.795972e-06, 9.826363e-06, 1.579915e-05, 2.170256e-05, 2.752503e-05, 3.325524e-05,
  3.888214e-05, 4.439495e-05, 4.978321e-05, 5.503677e-05, 6.014583e-05, 6.510093e-05, 6.989301e-05, 7.451339e-05,
  7.895379e-05, 8.320637e-05, 8.726372e-05, 9.111885e-05, 9.476527e-05, 9.819693e-05, 1.014083e-04, 1.043942e-04,
  1.071502e-04, 1.096720e-04, 1.119563e-04, 1.139998e-04, 1.158000e-04, 1.173549e-04, 1.186629e-04, 1.197231e-04,
  1.205349e-04, 1.210982e-04, 1.214137e-04, 1.214824e-04, 1.213057e-04, 1.208856e-04, 1.202247e-04, 1.193259e-04,
  1.181926e-04, 1.168288e-04, 1.152386e-04, 1.134270e-04, 1.113990e-04, 1.091603e-04, 1.067168e-04, 1.040750e-04,
  1.012415e-04, 9.822340e-05, 9.502811e-05, 9.166333e-05, 8.813709e-05, 8.445766e-05, 8.063359e-05, 7.667366e-05,
  7.258687e-05, 6.838241e-05, 6.406967e-05, 5.965819e-05, 5.515764e-05, 5.057781e-05, 4.592860e-05, 4.121996e-05,
  3.646192e-05, 3.166454e-05, 2.683787e-05, 2.199199e-05, 1.713691e-05, 1.228263e-05, 7.439059e-06, 2.616021e-06,
 -2.176765e-06,-6.929709e-06,-1.163337e-05,-1.627845e-05,-2.085588e-05,-2.535673e-05,-2.977234e-05,-3.409426e-05,
 -3.831428e-05,-4.242446e-05,-4.641716e-05,-5.028499e-05,-5.402091e-05,-5.761817e-05,-6.107036e-05,-6.437139e-05,
 -6.751556e-05,-7.049749e-05,-7.331220e-05,-7.595506e-05,-7.842184e-05,-8.070869e-05,-8.281217e-05,-8.472921e-05,
 -8.645718e-05,-8.799383e-05,-8.933732e-05,-9.048623e-05,-9.143953e-05,-9.219661e-05,-9.275726e-05,-9.312170e-05,
 -9.329050e-05,-9.326467e-05,-9.304560e-05,-9.263507e-05,-9.203522e-05,-9.124859e-05,-9.027807e-05,-8.912692e-05,
 -8.779873e-05,-8.629745e-05,-8.462733e-05,-8.279297e-05,-8.079926e-05,-7.865137e-05,-7.635478e-05,-7.391521e-05,
 -7.133866e-05,-6.863134e-05,-6.579971e-05,-6.285043e-05,-5.979037e-05,-5.662655e-05,-5.336619e-05,-5.001664e-05,
 -4.658538e-05,-4.308001e-05,-3.950824e-05,-3.587786e-05,-3.219670e-05,-2.847268e-05,-2.471374e-05,-2.092782e-05,
 -1.712288e-05,-1.330686e-05,-9.487658e-06,-5.673141e-06,-1.871102e-06, 1.910745e-06, 5.664779e-06, 9.383490e-06,
  1.305949e-05, 1.668553e-05, 2.025452e-05, 2.375953e-05, 2.719381e-05, 3.055080e-05, 3.382415e-05, 3.700773e-05,
  4.009562e-05, 4.308214e-05, 4.596189e-05, 4.872968e-05, 5.138063e-05, 5.391009e-05, 5.631373e-05, 5.858750e-05,
  6.072762e-05, 6.273064e-05, 6.459342e-05, 6.631309e-05, 6.788715e-05, 6.931337e-05, 7.058987e-05, 7.171507e-05,
  7.268772e-05, 7.350691e-05, 7.417202e-05, 7.468279e-05, 7.503924e-05, 7.524173e-05, 7.529093e-05, 7.518782e-05,
  7.493370e-05, 7.453015e-05, 7.397906e-05, 7.328261e-05, 7.244326e-05, 7.146374e-05, 7.034707e-05, 6.909652e-05,
  6.771561e-05, 6.620811e-05, 6.457801e-05, 6.282955e-05, 6.096717e-05, 5.899551e-05, 5.691941e-05, 5.474388e-05,
  5.247412e-05, 5.011546e-05, 4.767341e-05, 4.515358e-05, 4.256172e-05, 3.990369e-05, 3.718543e-05, 3.441298e-05,
  3.159243e-05, 2.872995e-05, 2.583172e-05, 2.290399e-05, 1.995300e-05, 1.698500e-05, 1.400623e-05, 1.102290e-05,
  8.041216e-06, 5.067301e-06, 2.107238e-06,-8.329681e-07,-3.747393e-06,-6.630210e-06,-9.475697e-06,-1.227825e-05,
 -1.503240e-05,-1.773280e-05,-2.037427e-05,-2.295177e-05,-2.546046e-05,-2.789564e-05,-3.025282e-05,-3.252768e-05,
 -3.471613e-05,-3.681427e-05,-3.881842e-05,-4.072510e-05,-4.253110e-05,-4.423340e-05,-4.582923e-05,-4.731606e-05,
 -4.869162e-05,-4.995386e-05,-5.110098e-05,-5.213146e-05,-5.304401e-05,-5.383758e-05,-5.451140e-05,-5.506495e-05,
 -5.549795e-05,-5.581038e-05,-5.600246e-05,-5.607467e-05,-5.602773e-05,-5.586260e-05,-5.558047e-05,-5.518279e-05,
 -5.467120e-05,-5.404760e-05,-5.331409e-05,-5.247299e-05,-5.152681e-05,-5.047828e-05,-4.933031e-05,-4.808601e-05,
 -4.674864e-05,-4.532166e-05,-4.380866e-05,-4.221342e-05,-4.053982e-05,-3.879191e-05,-3.697385e-05,-3.508991e-05,
 -3.314448e-05,-3.114203e-05,-2.908713e-05,-2.698441e-05,-2.483859e-05,-2.265442e-05,-2.043670e-05,-1.819029e-05,
 -1.592003e-05,-1.363082e-05,-1.132752e-05,-9.015032e-06,-6.698200e-06,-4.381861e-06,-2.070813e-06, 2.301920e-07,
  2.516458e-06, 4.783353e-06, 7.026320e-06, 9.240885e-06, 1.142266e-05, 1.356737e-05, 1.567084e-05, 1.772900e-05,
  1.973792e-05, 2.169381e-05, 2.359298e-05, 2.543193e-05, 2.720727e-05, 2.891581e-05, 3.055447e-05, 3.212039e-05,
  3.361086e-05, 3.502332e-05, 3.635544e-05, 3.760504e-05, 3.877014e-05, 3.984895e-05, 4.083986e-05, 4.174149e-05,
  4.255260e-05, 4.327221e-05, 4.389948e-05, 4.443381e-05, 4.487478e-05, 4.522216e-05, 4.547594e-05, 4.563628e-05,
  4.570356e-05, 4.567832e-05, 4.556131e-05, 4.535346e-05, 4.505589e-05, 4.466987e-05, 4.419689e-05, 4.363857e-05,
  4.299671e-05, 4.227329e-05, 4.147041e-05, 4.059034e-05, 3.963550e-05, 3.860843e-05, 3.751183e-05, 3.634848e-05,
  3.512132e-05, 3.383339e-05, 3.248782e-05, 3.108785e-05, 2.963681e-05, 2.813811e-05, 2.659523e-05, 2.501172e-05,
  2.339118e-05, 2.173728e-05, 2.005371e-05, 1.834421e-05, 1.661255e-05, 1.486249e-05, 1.309783e-05, 1.132236e-05,
  9.539862e-06, 7.754116e-06, 5.968869e-06, 4.187844e-06, 2.414725e-06, 6.531534e-07,-1.093280e-06,-2.821045e-06,
 -4.526674e-06,-6.206775e-06,-7.858033e-06,-9.477216e-06,-1.106119e-05,-1.260691e-05,-1.411143e-05,-1.557194e-05,
 -1.698570e-05,-1.835013e-05,-1.966274e-05,-2.092118e-05,-2.212325e-05,-2.326685e-05,-2.435004e-05,-2.537101e-05,
 -2.632810e-05,-2.721981e-05,-2.804476e-05,-2.880174e-05,-2.948968e-05,-3.010767e-05,-3.065496e-05,-3.113093e-05,
 -3.153514e-05,-3.186729e-05,-3.212724e-05,-3.231500e-05,-3.243072e-05,-3.247472e-05,-3.244745e-05,-3.234952e-05,
 -3.218168e-05,-3.194481e-05,-3.163994e-05,-3.126823e-05,-3.083097e-05,-3.032959e-05,-2.976563e-05,-2.914075e-05,
 -2.845673e-05,-2.771546e-05,-2.691893e-05,-2.606925e-05,-2.516860e-05,-2.421926e-05,-2.322361e-05,-2.218409e-05,
 -2.110321e-05,-1.998357e-05,-1.882782e-05,-1.763865e-05,-1.641883e-05,-1.517115e-05,-1.389844e-05,-1.260357e-05,
 -1.128944e-05,-9.958949e-06,-8.615018e-06,-7.260575e-06,-5.898546e-06,-4.531852e-06,-3.163400e-06,-1.796078e-06,
 -4.327515e-07, 9.237467e-07, 2.270619e-06, 3.605108e-06, 4.924508e-06, 6.226160e-06, 7.507468e-06, 8.765895e-06,
  9.998975e-06, 1.120431e-05, 1.237959e-05, 1.352257e-05, 1.463109e-05, 1.570311e-05, 1.673664e-05, 1.772982e-05,
  1.868087e-05, 1.958812e-05, 2.045001e-05, 2.126507e-05, 2.203196e-05, 2.274945e-05, 2.341640e-05, 2.403182e-05,
  2.459482e-05, 2.510461e-05, 2.556056e-05, 2.596212e-05, 2.630887e-05, 2.660052e-05, 2.683690e-05, 2.701793e-05,
  2.714368e-05, 2.721432e-05, 2.723014e-05, 2.719154e-05, 2.709904e-05, 2.695325e-05, 2.675492e-05, 2.650488e-05,
  2.620406e-05, 2.585351e-05, 2.545437e-05, 2.500786e-05, 2.451532e-05, 2.397814e-05, 2.339782e-05, 2.277593e-05,
  2.211413e-05, 2.141412e-05, 2.067770e-05, 1.990672e-05, 1.910308e-05, 1.826875e-05, 1.740573e-05, 1.651610e-05,
  1.560194e-05, 1.466539e-05, 1.370861e-05, 1.273379e-05, 1.174315e-05, 1.073890e-05, 9.723297e-06, 8.698573e-06,
  7.666978e-06, 6.630755e-06, 5.592140e-06, 4.553355e-06, 3.516605e-06, 2.484075e-06, 1.457921e-06, 4.402712e-07,
 -5.667831e-07,-1.561189e-06,-2.540936e-06,-3.504063e-06,-4.448658e-06,-5.372862e-06,-6.274878e-06,-7.152968e-06,
 -8.005459e-06,-8.830746e-06,-9.627294e-06,-1.039364e-05,-1.112841e-05,-1.183028e-05,-1.249803e-05,-1.313053e-05,
 -1.372670e-05,-1.428557e-05,-1.480627e-05,-1.528798e-05,-1.573001e-05,-1.613172e-05,-1.649260e-05,-1.681221e-05,
 -1.709021e-05,-1.732633e-05,-1.752042e-05,-1.767241e-05,-1.778232e-05,-1.785025e-05,-1.787641e-05,-1.786107e-05,
 -1.780462e-05,-1.770750e-05,-1.757026e-05,-1.739352e-05,-1.717797e-05,-1.692441e-05,-1.663367e-05,-1.630668e-05,
 -1.594445e-05,-1.554803e-05,-1.511855e-05,-1.465720e-05,-1.416522e-05,-1.364392e-05,-1.309466e-05,-1.251883e-05,
 -1.191790e-05,-1.129334e-05,-1.064669e-05,-9.979514e-06,-9.293409e-06,-8.589998e-06,-7.870930e-06,-7.137871e-06,
 -6.392506e-06,-5.636532e-06,-4.871655e-06,-4.099586e-06,-3.322039e-06,-2.540722e-06,-1.757341e-06,-9.735914e-07,
 -1.911546e-07, 5.883036e-07, 1.363138e-06, 2.131726e-06, 2.892472e-06, 3.643811e-06, 4.384211e-06, 5.112174e-06,
  5.826244e-06, 6.525005e-06, 7.207085e-06, 7.871162e-06, 8.515959e-06, 9.140256e-06, 9.742884e-06, 1.032273e-05,
  1.087874e-05, 1.140992e-05, 1.191535e-05, 1.239414e-05, 1.284550e-05, 1.326868e-05, 1.366303e-05, 1.402792e-05,
  1.436283e-05, 1.466728e-05, 1.494089e-05, 1.518333e-05, 1.539433e-05, 1.557372e-05, 1.572137e-05, 1.583723e-05,
  1.592133e-05, 1.597376e-05, 1.599467e-05, 1.598428e-05, 1.594290e-05, 1.587087e-05, 1.576860e-05, 1.563659e-05,
  1.547537e-05, 1.528553e-05, 1.506774e-05, 1.482270e-05, 1.455118e-05, 1.425399e-05, 1.393200e-05, 1.358611e-05,
  1.321729e-05, 1.282651e-05, 1.241483e-05, 1.198331e-05, 1.153306e-05, 1.106522e-05, 1.058094e-05, 1.008142e-05,
  9.567884e-06, 9.041556e-06, 8.503691e-06, 7.955555e-06, 7.398427e-06, 6.833593e-06, 6.262347e-06, 5.685984e-06,
  5.105801e-06, 4.523091e-06, 3.939141e-06, 3.355233e-06, 2.772633e-06, 2.192599e-06, 1.616368e-06, 1.045162e-06,
  4.801786e-07,-7.740623e-08,-6.264435e-07,-1.165812e-06,-1.694423e-06,-2.211217e-06,-2.715173e-06,-3.205303e-06,
 -3.680662e-06,-4.140341e-06,-4.583476e-06,-5.009244e-06,-5.416869e-06,-5.805621e-06,-6.174816e-06,-6.523819e-06,
 -6.852047e-06,-7.158963e-06,-7.444086e-06,-7.706983e-06,-7.947274e-06,-8.164634e-06,-8.358789e-06,-8.529518e-06,
 -8.676654e-06,-8.800083e-06,-8.899743e-06,-8.975626e-06,-9.027774e-06,-9.056285e-06,-9.061302e-06,-9.043023e-06,
 -9.001693e-06,-8.937607e-06,-8.851106e-06,-8.742577e-06,-8.612454e-06,-8.461213e-06,-8.289373e-06,-8.097493e-06,
 -7.886171e-06,-7.656044e-06,-7.407784e-06,-7.142096e-06,-6.859719e-06,-6.561421e-06,-6.248000e-06,-5.920277e-06,
 -5.579100e-06,-5.225340e-06,-4.859886e-06,-4.483645e-06,-4.097541e-06,-3.702511e-06,-3.299505e-06,-2.889479e-06,
 -2.473400e-06,-2.052236e-06,-1.626961e-06,-1.198547e-06,-7.679671e-07,-3.361879e-07, 9.582834e-08, 5.271277e-07,
  9.567663e-07, 1.383812e-06, 1.807347e-06, 2.226469e-06, 2.640294e-06, 3.047956e-06, 3.448613e-06, 3.841444e-06,
  4.225653e-06, 4.600469e-06, 4.965152e-06, 5.318987e-06, 5.661292e-06, 5.991417e-06, 6.308742e-06, 6.612684e-06,
  6.902693e-06, 7.178256e-06, 7.438895e-06, 7.684171e-06, 7.913684e-06, 8.127069e-06, 8.324003e-06, 8.504203e-06,
  8.667423e-06, 8.813460e-06, 8.942149e-06, 9.053365e-06, 9.147025e-06, 9.223084e-06, 9.281537e-06, 9.322420e-06,
  9.345804e-06, 9.351804e-06, 9.340567e-06, 9.312280e-06, 9.267168e-06, 9.205488e-06, 9.127533e-06, 9.033631e-06,
  8.924142e-06, 8.799456e-06, 8.659996e-06, 8.506213e-06, 8.338584e-06, 8.157617e-06, 7.963842e-06, 7.757813e-06,
  7.540108e-06, 7.311325e-06, 7.072080e-06, 6.823010e-06, 6.564766e-06, 6.298014e-06, 6.023433e-06, 5.741713e-06,
  5.453554e-06, 5.159666e-06, 4.860762e-06, 4.557562e-06, 4.250789e-06, 3.941165e-06, 3.629415e-06, 3.316260e-06,
  3.002419e-06, 2.688604e-06, 2.375522e-06, 2.063872e-06, 1.754342e-06, 1.447609e-06, 1.144339e-06, 8.451819e-07,
  5.507740e-07, 2.617341e-07,-2.133656e-08,-2.978560e-07,-5.672624e-07,-8.290151e-07,-1.082596e-06,-1.327510e-06,
 -1.563287e-06,-1.789481e-06,-2.005672e-06,-2.211467e-06,-2.406501e-06,-2.590434e-06,-2.762959e-06,-2.923793e-06,
 -3.072685e-06,-3.209412e-06,-3.333782e-06,-3.445633e-06,-3.544831e-06,-3.631274e-06,-3.704890e-06,-3.765635e-06,
 -3.813496e-06,-3.848490e-06,-3.870662e-06,-3.880086e-06,-3.876866e-06,-3.861131e-06,-3.833040e-06,-3.792776e-06,
 -3.740551e-06,-3.676600e-06,-3.601184e-06,-3.514587e-06,-3.417116e-06,-3.309099e-06,-3.190887e-06,-3.062850e-06,
 -2.925376e-06,-2.778872e-06,-2.623762e-06,-2.460485e-06,-2.289495e-06,-2.111258e-06,-1.926255e-06,-1.734974e-06,
 -1.537917e-06,-1.335591e-06,-1.128512e-06,-9.172005e-07,-7.021840e-07,-4.839915e-07,-2.631549e-07,-4.020688e-08,
  1.843201e-07, 4.098951e-07, 6.359899e-07, 8.620804e-07, 1.087647e-06, 1.312178e-06, 1.535166e-06, 1.756116e-06,
  1.974539e-06, 2.189959e-06, 2.401911e-06, 2.609941e-06, 2.813611e-06, 3.012496e-06, 3.206187e-06, 3.394290e-06,
  3.576428e-06, 3.752242e-06, 3.921392e-06, 4.083555e-06, 4.238430e-06, 4.385732e-06, 4.525200e-06, 4.656592e-06,
  4.779689e-06, 4.894291e-06, 5.000220e-06, 5.097323e-06, 5.185466e-06, 5.264538e-06, 5.334450e-06, 5.395137e-06,
  5.446555e-06, 5.488681e-06, 5.521515e-06, 5.545080e-06, 5.559418e-06, 5.564593e-06, 5.560691e-06, 5.547818e-06,
  5.526098e-06, 5.495677e-06, 5.456718e-06, 5.409405e-06, 5.353937e-06, 5.290531e-06, 5.219421e-06, 5.140857e-06,
  5.055103e-06, 4.962437e-06, 4.863152e-06, 4.757553e-06, 4.645956e-06, 4.528688e-06, 4.406087e-06, 4.278500e-06,
  4.146282e-06, 4.009795e-06, 3.869407e-06, 3.725492e-06, 3.578430e-06, 3.428602e-06, 3.276393e-06, 3.122189e-06,
  2.966379e-06, 2.809347e-06, 2.651482e-06, 2.493166e-06, 2.334781e-06, 2.176704e-06, 2.019307e-06, 1.862958e-06,
  1.708018e-06, 1.554840e-06, 1.403770e-06, 1.255146e-06, 1.109296e-06, 9.665365e-07, 8.271757e-07, 6.915093e-07,
  5.598212e-07, 4.323828e-07, 3.094525e-07, 1.912753e-07, 7.808205e-08,-2.991061e-08,-1.325009e-07,-2.295020e-07,
 -3.207427e-07,-4.060672e-07,-4.853356e-07,-5.584243e-07,-6.252256e-07,-6.856482e-07,-7.396170e-07,-7.870735e-07,
 -8.279754e-07,-8.622966e-07,-8.900272e-07,-9.111734e-07,-9.257572e-07,-9.338162e-07,-9.354035e-07,-9.305872e-07,
 -9.194501e-07,-9.020897e-07,-8.786172e-07,-8.491578e-07,-8.138496e-07,-7.728435e-07,-7.263027e-07,-6.744021e-07,
 -6.173275e-07,-5.552756e-07,-4.884529e-07,-4.170753e-07,-3.413677e-07,-2.615627e-07,-1.779007e-07,-9.062871e-08,
  0.000000e+00,};
