/*******************************************************************************
 * Part of "Intel(R) Active Management Technology (Intel(R) AMT)
 *                   User Notification Service (UNS)"
 *
 * Copyright (c) 2007 Intel Corp.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification.
 * 2. Redistributions in binary form must reproduce at minimum a disclaimer
 *    substantially similar to the "NO WARRANTY" disclaimer below
 *    ("Disclaimer") and any redistribution must be conditioned upon
 *    including a substantially similar Disclaimer requirement for further
 *    binary redistribution.
 * 3. Neither the names of the above-listed copyright holders nor the names
 *    of any contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * Alternatively, this software may be distributed under the terms of the
 * GNU General Public License ("GPL") version 2 as published by the Free
 * Software Foundation.
 *
 * NO WARRANTY
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * HOLDERS OR CONTRIBUTORS BE LIABLE FOR SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGES.
 *******************************************************************************/

#ifndef _POSTURE_RETRIEVAL_THREAD_H
#define _POSTURE_RETRIEVAL_THREAD_H

#include <string>
#include "PeriodicActionThread.h"
#include "EACWSManClient.h"

// Forward declaration of the Credentials structure
struct Credentials;

// Forward declaration of the UNSEventLogger.
class UNSEventLogger;

class UNSConfig;

class PostureRetrievalThread : public PeriodicActionThread
{
public:

	// Constructor and Destructor.
	PostureRetrievalThread(UNSEventLogger *pLogger = NULL);

	// Initialize this thread with a given action interval time.
	bool init(const UNSConfig &Config);

	// Set the cresentials to be used to connect to AMT.
	void SetCredentials(const Credentials &cred);

	// Set IP
	void SetIP(const string &ip); // For debug only

	// Set a pointer to the Logger.
	void SetLogger(UNSEventLogger *pLogger);

protected:
	virtual void action();

private:
	enum State {
		INITIAL_CLEANUP_STATE,
		CHECK_EAC_ENABLEMENT_STATE,
		CHECK_EAC_ENABLEMENT_FAILURE_STATE,
		GETTING_POSTURE_STATE};

	/*These functions return the next state into which we should go.*/
	void cleanup();
	State InitialCleanup();
	State CheckEACEnablement(bool bLogFailure = true);
	State CheckEACEnablementFailure();
	State GetPosture();

	// Data members.
	State			m_State;
	EACWSManClient m_EACWsmanClient;
	UNSEventLogger *m_pLogger;

	// Static constants.
	static const unsigned long DEFAULT_RETRIEVAL_INTERVAL;
	static const unsigned long HECI_DOWNTIME_ON_RESUME;

	static const unsigned long MIN_GET_POSTURE_INTERVAL;
	static const unsigned long MAX_GET_POSTURE_INTERVAL;
};

#endif //_POSTURE_RETRIEVAL_THREAD_H
