/*
 * Copyright 2021 KylinSoft Co., Ltd.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef NETDETAIL_H
#define NETDETAIL_H

#include <QWidget>
#include <QFrame>
#include <QFormLayout>
#include <QLabel>

class NetDetail : public QFrame
{
    Q_OBJECT
public:
    NetDetail(bool isWlan, QWidget *parent = nullptr);

    void setSSID(const QString &ssid);
    void setSpeed(const QString &speed);
    void setProtocol(const QString &protocol);
    void setSecType(const QString &secType);
    void setHz(const QString &hz);
    void setChan(const QString &chan);
    void setBandWidth(const QString &chan);
    void setIPV4(const QString &ipv4);
    void setIPV4Dns(const QString &ipv4Dns);
    void setIPV4Mask(const QString &netMask);
    void setIPV4Gateway(const QString &gateWay);
    void setIPV6(const QString &ipv6);
    void setIPV6Prefix(const QString &prefix);
    void setIPV6Gt(const QString &gateWay);
    void setMac(const QString &mac);

private:
    void initUI();

public:
    QLabel *mSSID;
    QLabel *mSpeed;
    QLabel *mProtocol;
    QLabel *mSecType;
    QLabel *mHz;
    QLabel *mChan;
    QLabel *mBandWidth;
    QLabel *mIPV4;
    QLabel *mIPV4Gt;
    QLabel *mIPV4Dns;
    QLabel *mIPV4Mask;

    QLabel *mIPV6;
    QLabel *mIPV6Prefix;
    QLabel *mIPV6Gt;

    QLabel *mMac;

private:
    QFormLayout *mDetailLayout;
    bool mIsWlan;
};

#endif // NETDETAIL_H
