; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-- -mattr=+sse2 | FileCheck %s --check-prefixes=SSE
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx  | FileCheck %s --check-prefixes=AVX1
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx2 | FileCheck --check-prefixes=AVX2 %s
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx2,+fast-variable-crosslane-shuffle,+fast-variable-perlane-shuffle | FileCheck --check-prefixes=AVX2 %s
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx2,+fast-variable-perlane-shuffle | FileCheck --check-prefixes=AVX2 %s
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512bw,+avx512vl | FileCheck %s --check-prefixes=AVX512

; These patterns are produced by LoopVectorizer for interleaved loads.

define void @load_i8_stride6_vf2(ptr %in.vec, ptr %out.vec0, ptr %out.vec1, ptr %out.vec2, ptr %out.vec3, ptr %out.vec4, ptr %out.vec5) nounwind {
; SSE-LABEL: load_i8_stride6_vf2:
; SSE:       # %bb.0:
; SSE-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; SSE-NEXT:    movdqa (%rdi), %xmm1
; SSE-NEXT:    movdqa {{.*#+}} xmm3 = [255,255,255,255,255,255,255,255]
; SSE-NEXT:    pand %xmm1, %xmm3
; SSE-NEXT:    pshuflw {{.*#+}} xmm2 = xmm3[0,3,2,3,4,5,6,7]
; SSE-NEXT:    packuswb %xmm2, %xmm2
; SSE-NEXT:    pxor %xmm4, %xmm4
; SSE-NEXT:    movdqa %xmm1, %xmm0
; SSE-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0],xmm4[0],xmm0[1],xmm4[1],xmm0[2],xmm4[2],xmm0[3],xmm4[3],xmm0[4],xmm4[4],xmm0[5],xmm4[5],xmm0[6],xmm4[6],xmm0[7],xmm4[7]
; SSE-NEXT:    pshufd {{.*#+}} xmm5 = xmm0[0,3,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm5 = xmm5[1,3,2,3,4,5,6,7]
; SSE-NEXT:    packuswb %xmm5, %xmm5
; SSE-NEXT:    pshufd {{.*#+}} xmm6 = xmm3[0,2,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm6 = xmm6[1,2,2,3,4,5,6,7]
; SSE-NEXT:    packuswb %xmm6, %xmm6
; SSE-NEXT:    punpckhbw {{.*#+}} xmm1 = xmm1[8],xmm4[8],xmm1[9],xmm4[9],xmm1[10],xmm4[10],xmm1[11],xmm4[11],xmm1[12],xmm4[12],xmm1[13],xmm4[13],xmm1[14],xmm4[14],xmm1[15],xmm4[15]
; SSE-NEXT:    movdqa %xmm0, %xmm4
; SSE-NEXT:    punpcklwd {{.*#+}} xmm4 = xmm4[0],xmm1[0],xmm4[1],xmm1[1],xmm4[2],xmm1[2],xmm4[3],xmm1[3]
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[3,1,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm4 = xmm4[0,3,2,3,4,5,6,7]
; SSE-NEXT:    packuswb %xmm4, %xmm4
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[2,1,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm3 = xmm3[2,1,2,3,4,5,6,7]
; SSE-NEXT:    packuswb %xmm3, %xmm3
; SSE-NEXT:    psrlq $48, %xmm1
; SSE-NEXT:    psrldq {{.*#+}} xmm0 = xmm0[10,11,12,13,14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; SSE-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1],xmm0[2],xmm1[2],xmm0[3],xmm1[3]
; SSE-NEXT:    packuswb %xmm0, %xmm0
; SSE-NEXT:    movd %xmm2, %edi
; SSE-NEXT:    movw %di, (%rsi)
; SSE-NEXT:    movd %xmm5, %esi
; SSE-NEXT:    movw %si, (%rdx)
; SSE-NEXT:    movd %xmm6, %edx
; SSE-NEXT:    movw %dx, (%rcx)
; SSE-NEXT:    movd %xmm4, %ecx
; SSE-NEXT:    movw %cx, (%r8)
; SSE-NEXT:    movd %xmm3, %ecx
; SSE-NEXT:    movw %cx, (%r9)
; SSE-NEXT:    movd %xmm0, %ecx
; SSE-NEXT:    movw %cx, (%rax)
; SSE-NEXT:    retq
;
; AVX1-LABEL: load_i8_stride6_vf2:
; AVX1:       # %bb.0:
; AVX1-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX1-NEXT:    vmovdqa (%rdi), %xmm0
; AVX1-NEXT:    vpshufb {{.*#+}} xmm1 = xmm0[0,6,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX1-NEXT:    vpshufb {{.*#+}} xmm2 = xmm0[1,7,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX1-NEXT:    vpshufb {{.*#+}} xmm3 = xmm0[2,8,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX1-NEXT:    vpshufb {{.*#+}} xmm4 = xmm0[3,9,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX1-NEXT:    vpshufb {{.*#+}} xmm5 = xmm0[4,10,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX1-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[5,11,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX1-NEXT:    vpextrw $0, %xmm1, (%rsi)
; AVX1-NEXT:    vpextrw $0, %xmm2, (%rdx)
; AVX1-NEXT:    vpextrw $0, %xmm3, (%rcx)
; AVX1-NEXT:    vpextrw $0, %xmm4, (%r8)
; AVX1-NEXT:    vpextrw $0, %xmm5, (%r9)
; AVX1-NEXT:    vpextrw $0, %xmm0, (%rax)
; AVX1-NEXT:    retq
;
; AVX2-LABEL: load_i8_stride6_vf2:
; AVX2:       # %bb.0:
; AVX2-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-NEXT:    vmovdqa (%rdi), %xmm0
; AVX2-NEXT:    vpshufb {{.*#+}} xmm1 = xmm0[0,6,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX2-NEXT:    vpshufb {{.*#+}} xmm2 = xmm0[1,7,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX2-NEXT:    vpshufb {{.*#+}} xmm3 = xmm0[2,8,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX2-NEXT:    vpshufb {{.*#+}} xmm4 = xmm0[3,9,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX2-NEXT:    vpshufb {{.*#+}} xmm5 = xmm0[4,10,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX2-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[5,11,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX2-NEXT:    vpextrw $0, %xmm1, (%rsi)
; AVX2-NEXT:    vpextrw $0, %xmm2, (%rdx)
; AVX2-NEXT:    vpextrw $0, %xmm3, (%rcx)
; AVX2-NEXT:    vpextrw $0, %xmm4, (%r8)
; AVX2-NEXT:    vpextrw $0, %xmm5, (%r9)
; AVX2-NEXT:    vpextrw $0, %xmm0, (%rax)
; AVX2-NEXT:    retq
;
; AVX512-LABEL: load_i8_stride6_vf2:
; AVX512:       # %bb.0:
; AVX512-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512-NEXT:    vmovdqa (%rdi), %xmm0
; AVX512-NEXT:    vpshufb {{.*#+}} xmm1 = xmm0[0,6,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512-NEXT:    vpshufb {{.*#+}} xmm2 = xmm0[1,7,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512-NEXT:    vpshufb {{.*#+}} xmm3 = xmm0[2,8,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512-NEXT:    vpshufb {{.*#+}} xmm4 = xmm0[3,9,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512-NEXT:    vpshufb {{.*#+}} xmm5 = xmm0[4,10,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[5,11,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512-NEXT:    vpextrw $0, %xmm1, (%rsi)
; AVX512-NEXT:    vpextrw $0, %xmm2, (%rdx)
; AVX512-NEXT:    vpextrw $0, %xmm3, (%rcx)
; AVX512-NEXT:    vpextrw $0, %xmm4, (%r8)
; AVX512-NEXT:    vpextrw $0, %xmm5, (%r9)
; AVX512-NEXT:    vpextrw $0, %xmm0, (%rax)
; AVX512-NEXT:    retq
  %wide.vec = load <12 x i8>, ptr %in.vec, align 32

  %strided.vec0 = shufflevector <12 x i8> %wide.vec, <12 x i8> poison, <2 x i32> <i32 0, i32 6>
  %strided.vec1 = shufflevector <12 x i8> %wide.vec, <12 x i8> poison, <2 x i32> <i32 1, i32 7>
  %strided.vec2 = shufflevector <12 x i8> %wide.vec, <12 x i8> poison, <2 x i32> <i32 2, i32 8>
  %strided.vec3 = shufflevector <12 x i8> %wide.vec, <12 x i8> poison, <2 x i32> <i32 3, i32 9>
  %strided.vec4 = shufflevector <12 x i8> %wide.vec, <12 x i8> poison, <2 x i32> <i32 4, i32 10>
  %strided.vec5 = shufflevector <12 x i8> %wide.vec, <12 x i8> poison, <2 x i32> <i32 5, i32 11>

  store <2 x i8> %strided.vec0, ptr %out.vec0, align 32
  store <2 x i8> %strided.vec1, ptr %out.vec1, align 32
  store <2 x i8> %strided.vec2, ptr %out.vec2, align 32
  store <2 x i8> %strided.vec3, ptr %out.vec3, align 32
  store <2 x i8> %strided.vec4, ptr %out.vec4, align 32
  store <2 x i8> %strided.vec5, ptr %out.vec5, align 32

  ret void
}

define void @load_i8_stride6_vf4(ptr %in.vec, ptr %out.vec0, ptr %out.vec1, ptr %out.vec2, ptr %out.vec3, ptr %out.vec4, ptr %out.vec5) nounwind {
; SSE-LABEL: load_i8_stride6_vf4:
; SSE:       # %bb.0:
; SSE-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; SSE-NEXT:    movdqa (%rdi), %xmm3
; SSE-NEXT:    movdqa 16(%rdi), %xmm0
; SSE-NEXT:    movdqa {{.*#+}} xmm1 = [65535,0,65535,65535,65535,65535,65535,65535]
; SSE-NEXT:    movdqa %xmm3, %xmm2
; SSE-NEXT:    pand %xmm1, %xmm2
; SSE-NEXT:    pandn %xmm0, %xmm1
; SSE-NEXT:    por %xmm2, %xmm1
; SSE-NEXT:    movdqa {{.*#+}} xmm2 = [255,255,255,255,255,255,255,255]
; SSE-NEXT:    pand %xmm2, %xmm1
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,2,1,3]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,6,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,2,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[0,3,2,1,4,5,6,7]
; SSE-NEXT:    packuswb %xmm1, %xmm1
; SSE-NEXT:    pxor %xmm4, %xmm4
; SSE-NEXT:    movdqa %xmm3, %xmm6
; SSE-NEXT:    movdqa {{.*#+}} xmm5 = [255,255,255,0,255,255,255,255,255,255,255,255,255,255,255,255]
; SSE-NEXT:    pandn %xmm0, %xmm5
; SSE-NEXT:    movdqa %xmm0, %xmm7
; SSE-NEXT:    shufps {{.*#+}} xmm7 = xmm7[1,0],xmm3[0,0]
; SSE-NEXT:    shufps {{.*#+}} xmm7 = xmm7[2,0],xmm3[2,3]
; SSE-NEXT:    movdqa {{.*#+}} xmm8 = [65535,65535,0,65535,65535,0,65535,65535]
; SSE-NEXT:    pand %xmm8, %xmm0
; SSE-NEXT:    pandn %xmm3, %xmm8
; SSE-NEXT:    punpckhbw {{.*#+}} xmm3 = xmm3[8],xmm4[8],xmm3[9],xmm4[9],xmm3[10],xmm4[10],xmm3[11],xmm4[11],xmm3[12],xmm4[12],xmm3[13],xmm4[13],xmm3[14],xmm4[14],xmm3[15],xmm4[15]
; SSE-NEXT:    movdqa %xmm3, %xmm9
; SSE-NEXT:    psrld $16, %xmm9
; SSE-NEXT:    punpcklbw {{.*#+}} xmm6 = xmm6[0],xmm4[0],xmm6[1],xmm4[1],xmm6[2],xmm4[2],xmm6[3],xmm4[3],xmm6[4],xmm4[4],xmm6[5],xmm4[5],xmm6[6],xmm4[6],xmm6[7],xmm4[7]
; SSE-NEXT:    pshufd {{.*#+}} xmm6 = xmm6[0,1,0,3]
; SSE-NEXT:    pshufhw {{.*#+}} xmm6 = xmm6[0,1,2,3,5,7,6,7]
; SSE-NEXT:    punpckhdq {{.*#+}} xmm6 = xmm6[2],xmm9[2],xmm6[3],xmm9[3]
; SSE-NEXT:    packuswb %xmm6, %xmm6
; SSE-NEXT:    por %xmm6, %xmm5
; SSE-NEXT:    movaps %xmm7, %xmm6
; SSE-NEXT:    andps %xmm2, %xmm6
; SSE-NEXT:    pshuflw {{.*#+}} xmm6 = xmm6[2,1,2,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm6 = xmm6[0,1,2,3,4,7,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm6 = xmm6[0,2,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm6 = xmm6[1,2,3,0,4,5,6,7]
; SSE-NEXT:    packuswb %xmm6, %xmm6
; SSE-NEXT:    punpcklbw {{.*#+}} xmm7 = xmm7[0],xmm4[0],xmm7[1],xmm4[1],xmm7[2],xmm4[2],xmm7[3],xmm4[3],xmm7[4],xmm4[4],xmm7[5],xmm4[5],xmm7[6],xmm4[6],xmm7[7],xmm4[7]
; SSE-NEXT:    shufps {{.*#+}} xmm7 = xmm7[1,2],xmm3[0,3]
; SSE-NEXT:    shufps {{.*#+}} xmm7 = xmm7[2,0,1,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm7 = xmm7[3,1,2,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm7 = xmm7[0,1,2,3,7,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm7 = xmm7[0,2,2,3]
; SSE-NEXT:    packuswb %xmm7, %xmm7
; SSE-NEXT:    por %xmm0, %xmm8
; SSE-NEXT:    pand %xmm8, %xmm2
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm2[3,1,2,0]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,6,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[2,1,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[2,1,0,3,4,5,6,7]
; SSE-NEXT:    packuswb %xmm0, %xmm0
; SSE-NEXT:    punpcklbw {{.*#+}} xmm8 = xmm8[0],xmm4[0],xmm8[1],xmm4[1],xmm8[2],xmm4[2],xmm8[3],xmm4[3],xmm8[4],xmm4[4],xmm8[5],xmm4[5],xmm8[6],xmm4[6],xmm8[7],xmm4[7]
; SSE-NEXT:    shufps {{.*#+}} xmm3 = xmm3[1,0],xmm8[0,0]
; SSE-NEXT:    shufps {{.*#+}} xmm3 = xmm3[2,0],xmm8[2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm2 = xmm3[3,1,2,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm2 = xmm2[0,1,2,3,7,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,2,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm2 = xmm2[3,0,1,2,4,5,6,7]
; SSE-NEXT:    packuswb %xmm2, %xmm2
; SSE-NEXT:    movd %xmm1, (%rsi)
; SSE-NEXT:    movd %xmm5, (%rdx)
; SSE-NEXT:    movd %xmm6, (%rcx)
; SSE-NEXT:    movd %xmm7, (%r8)
; SSE-NEXT:    movd %xmm0, (%r9)
; SSE-NEXT:    movd %xmm2, (%rax)
; SSE-NEXT:    retq
;
; AVX1-LABEL: load_i8_stride6_vf4:
; AVX1:       # %bb.0:
; AVX1-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX1-NEXT:    vmovdqa (%rdi), %xmm0
; AVX1-NEXT:    vmovdqa 16(%rdi), %xmm1
; AVX1-NEXT:    vpshufb {{.*#+}} xmm2 = zero,zero,zero,xmm1[2,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX1-NEXT:    vpshufb {{.*#+}} xmm3 = xmm0[0,6,12],zero,xmm0[u,u,u,u,u,u,u,u,u,u,u,u]
; AVX1-NEXT:    vpor %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpshufb {{.*#+}} xmm3 = zero,zero,zero,xmm1[3,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX1-NEXT:    vpshufb {{.*#+}} xmm4 = xmm0[1,7,13],zero,xmm0[u,u,u,u,u,u,u,u,u,u,u,u]
; AVX1-NEXT:    vpor %xmm3, %xmm4, %xmm3
; AVX1-NEXT:    vpshufb {{.*#+}} xmm4 = zero,zero,zero,xmm1[4,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX1-NEXT:    vpshufb {{.*#+}} xmm5 = xmm0[2,8,14],zero,xmm0[u,u,u,u,u,u,u,u,u,u,u,u]
; AVX1-NEXT:    vpor %xmm4, %xmm5, %xmm4
; AVX1-NEXT:    vpshufb {{.*#+}} xmm5 = zero,zero,zero,xmm1[5,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX1-NEXT:    vpshufb {{.*#+}} xmm6 = xmm0[3,9,15],zero,xmm0[u,u,u,u,u,u,u,u,u,u,u,u]
; AVX1-NEXT:    vpor %xmm5, %xmm6, %xmm5
; AVX1-NEXT:    vpshufb {{.*#+}} xmm6 = xmm1[0,6,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX1-NEXT:    vpshufb {{.*#+}} xmm7 = xmm0[4,10,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX1-NEXT:    vpunpcklwd {{.*#+}} xmm6 = xmm7[0],xmm6[0],xmm7[1],xmm6[1],xmm7[2],xmm6[2],xmm7[3],xmm6[3]
; AVX1-NEXT:    vpshufb {{.*#+}} xmm1 = xmm1[1,7,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX1-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[5,11,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX1-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1],xmm0[2],xmm1[2],xmm0[3],xmm1[3]
; AVX1-NEXT:    vmovd %xmm2, (%rsi)
; AVX1-NEXT:    vmovd %xmm3, (%rdx)
; AVX1-NEXT:    vmovd %xmm4, (%rcx)
; AVX1-NEXT:    vmovd %xmm5, (%r8)
; AVX1-NEXT:    vmovd %xmm6, (%r9)
; AVX1-NEXT:    vmovd %xmm0, (%rax)
; AVX1-NEXT:    retq
;
; AVX2-LABEL: load_i8_stride6_vf4:
; AVX2:       # %bb.0:
; AVX2-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-NEXT:    vmovdqa (%rdi), %xmm0
; AVX2-NEXT:    vmovdqa 16(%rdi), %xmm1
; AVX2-NEXT:    vpshufb {{.*#+}} xmm2 = zero,zero,zero,xmm1[2,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX2-NEXT:    vpshufb {{.*#+}} xmm3 = xmm0[0,6,12],zero,xmm0[u,u,u,u,u,u,u,u,u,u,u,u]
; AVX2-NEXT:    vpor %xmm2, %xmm3, %xmm2
; AVX2-NEXT:    vpshufb {{.*#+}} xmm3 = zero,zero,zero,xmm1[3,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX2-NEXT:    vpshufb {{.*#+}} xmm4 = xmm0[1,7,13],zero,xmm0[u,u,u,u,u,u,u,u,u,u,u,u]
; AVX2-NEXT:    vpor %xmm3, %xmm4, %xmm3
; AVX2-NEXT:    vpshufb {{.*#+}} xmm4 = zero,zero,zero,xmm1[4,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX2-NEXT:    vpshufb {{.*#+}} xmm5 = xmm0[2,8,14],zero,xmm0[u,u,u,u,u,u,u,u,u,u,u,u]
; AVX2-NEXT:    vpor %xmm4, %xmm5, %xmm4
; AVX2-NEXT:    vpshufb {{.*#+}} xmm5 = zero,zero,zero,xmm1[5,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX2-NEXT:    vpshufb {{.*#+}} xmm6 = xmm0[3,9,15],zero,xmm0[u,u,u,u,u,u,u,u,u,u,u,u]
; AVX2-NEXT:    vpor %xmm5, %xmm6, %xmm5
; AVX2-NEXT:    vpshufb {{.*#+}} xmm6 = xmm1[0,6,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX2-NEXT:    vpshufb {{.*#+}} xmm7 = xmm0[4,10,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX2-NEXT:    vpunpcklwd {{.*#+}} xmm6 = xmm7[0],xmm6[0],xmm7[1],xmm6[1],xmm7[2],xmm6[2],xmm7[3],xmm6[3]
; AVX2-NEXT:    vpshufb {{.*#+}} xmm1 = xmm1[1,7,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX2-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[5,11,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX2-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1],xmm0[2],xmm1[2],xmm0[3],xmm1[3]
; AVX2-NEXT:    vmovd %xmm2, (%rsi)
; AVX2-NEXT:    vmovd %xmm3, (%rdx)
; AVX2-NEXT:    vmovd %xmm4, (%rcx)
; AVX2-NEXT:    vmovd %xmm5, (%r8)
; AVX2-NEXT:    vmovd %xmm6, (%r9)
; AVX2-NEXT:    vmovd %xmm0, (%rax)
; AVX2-NEXT:    retq
;
; AVX512-LABEL: load_i8_stride6_vf4:
; AVX512:       # %bb.0:
; AVX512-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512-NEXT:    vmovdqa (%rdi), %xmm0
; AVX512-NEXT:    vmovdqa 16(%rdi), %xmm1
; AVX512-NEXT:    vpshufb {{.*#+}} xmm2 = zero,zero,zero,xmm1[2,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512-NEXT:    vpshufb {{.*#+}} xmm3 = xmm0[0,6,12],zero,xmm0[u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512-NEXT:    vpor %xmm2, %xmm3, %xmm2
; AVX512-NEXT:    vpshufb {{.*#+}} xmm3 = zero,zero,zero,xmm1[3,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512-NEXT:    vpshufb {{.*#+}} xmm4 = xmm0[1,7,13],zero,xmm0[u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512-NEXT:    vpor %xmm3, %xmm4, %xmm3
; AVX512-NEXT:    vpshufb {{.*#+}} xmm4 = zero,zero,zero,xmm1[4,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512-NEXT:    vpshufb {{.*#+}} xmm5 = xmm0[2,8,14],zero,xmm0[u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512-NEXT:    vpor %xmm4, %xmm5, %xmm4
; AVX512-NEXT:    vpshufb {{.*#+}} xmm5 = zero,zero,zero,xmm1[5,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512-NEXT:    vpshufb {{.*#+}} xmm6 = xmm0[3,9,15],zero,xmm0[u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512-NEXT:    vpor %xmm5, %xmm6, %xmm5
; AVX512-NEXT:    vpshufb {{.*#+}} xmm6 = xmm1[0,6,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512-NEXT:    vpshufb {{.*#+}} xmm7 = xmm0[4,10,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512-NEXT:    vpunpcklwd {{.*#+}} xmm6 = xmm7[0],xmm6[0],xmm7[1],xmm6[1],xmm7[2],xmm6[2],xmm7[3],xmm6[3]
; AVX512-NEXT:    vpshufb {{.*#+}} xmm1 = xmm1[1,7,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[5,11,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1],xmm0[2],xmm1[2],xmm0[3],xmm1[3]
; AVX512-NEXT:    vmovd %xmm2, (%rsi)
; AVX512-NEXT:    vmovd %xmm3, (%rdx)
; AVX512-NEXT:    vmovd %xmm4, (%rcx)
; AVX512-NEXT:    vmovd %xmm5, (%r8)
; AVX512-NEXT:    vmovd %xmm6, (%r9)
; AVX512-NEXT:    vmovd %xmm0, (%rax)
; AVX512-NEXT:    retq
  %wide.vec = load <24 x i8>, ptr %in.vec, align 32

  %strided.vec0 = shufflevector <24 x i8> %wide.vec, <24 x i8> poison, <4 x i32> <i32 0, i32 6, i32 12, i32 18>
  %strided.vec1 = shufflevector <24 x i8> %wide.vec, <24 x i8> poison, <4 x i32> <i32 1, i32 7, i32 13, i32 19>
  %strided.vec2 = shufflevector <24 x i8> %wide.vec, <24 x i8> poison, <4 x i32> <i32 2, i32 8, i32 14, i32 20>
  %strided.vec3 = shufflevector <24 x i8> %wide.vec, <24 x i8> poison, <4 x i32> <i32 3, i32 9, i32 15, i32 21>
  %strided.vec4 = shufflevector <24 x i8> %wide.vec, <24 x i8> poison, <4 x i32> <i32 4, i32 10, i32 16, i32 22>
  %strided.vec5 = shufflevector <24 x i8> %wide.vec, <24 x i8> poison, <4 x i32> <i32 5, i32 11, i32 17, i32 23>

  store <4 x i8> %strided.vec0, ptr %out.vec0, align 32
  store <4 x i8> %strided.vec1, ptr %out.vec1, align 32
  store <4 x i8> %strided.vec2, ptr %out.vec2, align 32
  store <4 x i8> %strided.vec3, ptr %out.vec3, align 32
  store <4 x i8> %strided.vec4, ptr %out.vec4, align 32
  store <4 x i8> %strided.vec5, ptr %out.vec5, align 32

  ret void
}

define void @load_i8_stride6_vf8(ptr %in.vec, ptr %out.vec0, ptr %out.vec1, ptr %out.vec2, ptr %out.vec3, ptr %out.vec4, ptr %out.vec5) nounwind {
; SSE-LABEL: load_i8_stride6_vf8:
; SSE:       # %bb.0:
; SSE-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; SSE-NEXT:    movdqa (%rdi), %xmm4
; SSE-NEXT:    movdqa 16(%rdi), %xmm3
; SSE-NEXT:    movdqa 32(%rdi), %xmm0
; SSE-NEXT:    movdqa {{.*#+}} xmm8 = [65535,0,65535,65535,0,65535,65535,0]
; SSE-NEXT:    movdqa %xmm4, %xmm1
; SSE-NEXT:    pand %xmm8, %xmm1
; SSE-NEXT:    pandn %xmm3, %xmm8
; SSE-NEXT:    por %xmm1, %xmm8
; SSE-NEXT:    movdqa {{.*#+}} xmm5 = [255,255,255,255,255,255,255,255]
; SSE-NEXT:    movdqa %xmm8, %xmm1
; SSE-NEXT:    pand %xmm5, %xmm1
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,2,1,3]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,6,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,2,1,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[0,3,2,1,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm6 = xmm1[0,1,2,3,4,7,6,7]
; SSE-NEXT:    packuswb %xmm6, %xmm6
; SSE-NEXT:    movdqa {{.*#+}} xmm1 = [65535,65535,65535,0,65535,65535,65535,65535]
; SSE-NEXT:    pand %xmm1, %xmm6
; SSE-NEXT:    movdqa %xmm0, %xmm7
; SSE-NEXT:    pand %xmm5, %xmm7
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm7[0,1,2,1]
; SSE-NEXT:    pshufhw {{.*#+}} xmm9 = xmm2[0,1,2,3,4,5,6,5]
; SSE-NEXT:    packuswb %xmm9, %xmm9
; SSE-NEXT:    movdqa %xmm1, %xmm2
; SSE-NEXT:    pandn %xmm9, %xmm2
; SSE-NEXT:    por %xmm6, %xmm2
; SSE-NEXT:    pxor %xmm6, %xmm6
; SSE-NEXT:    movdqa %xmm8, %xmm9
; SSE-NEXT:    punpckhbw {{.*#+}} xmm9 = xmm9[8],xmm6[8],xmm9[9],xmm6[9],xmm9[10],xmm6[10],xmm9[11],xmm6[11],xmm9[12],xmm6[12],xmm9[13],xmm6[13],xmm9[14],xmm6[14],xmm9[15],xmm6[15]
; SSE-NEXT:    pshufd {{.*#+}} xmm9 = xmm9[2,1,0,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm9 = xmm9[1,1,1,1,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm9 = xmm9[0,1,2,3,5,7,6,7]
; SSE-NEXT:    movdqa {{.*#+}} xmm10 = [65535,65535,0,65535,0,0,65535,65535]
; SSE-NEXT:    punpcklbw {{.*#+}} xmm8 = xmm8[0],xmm6[0],xmm8[1],xmm6[1],xmm8[2],xmm6[2],xmm8[3],xmm6[3],xmm8[4],xmm6[4],xmm8[5],xmm6[5],xmm8[6],xmm6[6],xmm8[7],xmm6[7]
; SSE-NEXT:    pshuflw {{.*#+}} xmm8 = xmm8[3,1,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm8 = xmm8[0,3,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm8 = xmm8[1,3,2,0,4,5,6,7]
; SSE-NEXT:    pand %xmm10, %xmm8
; SSE-NEXT:    pandn %xmm9, %xmm10
; SSE-NEXT:    por %xmm8, %xmm10
; SSE-NEXT:    packuswb %xmm10, %xmm10
; SSE-NEXT:    pand %xmm1, %xmm10
; SSE-NEXT:    movdqa %xmm0, %xmm8
; SSE-NEXT:    punpckhbw {{.*#+}} xmm8 = xmm8[8],xmm6[8],xmm8[9],xmm6[9],xmm8[10],xmm6[10],xmm8[11],xmm6[11],xmm8[12],xmm6[12],xmm8[13],xmm6[13],xmm8[14],xmm6[14],xmm8[15],xmm6[15]
; SSE-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0],xmm6[0],xmm0[1],xmm6[1],xmm0[2],xmm6[2],xmm0[3],xmm6[3],xmm0[4],xmm6[4],xmm0[5],xmm6[5],xmm0[6],xmm6[6],xmm0[7],xmm6[7]
; SSE-NEXT:    pshufd {{.*#+}} xmm9 = xmm0[2,2,3,3]
; SSE-NEXT:    punpcklwd {{.*#+}} xmm9 = xmm9[0],xmm8[0],xmm9[1],xmm8[1],xmm9[2],xmm8[2],xmm9[3],xmm8[3]
; SSE-NEXT:    packuswb %xmm9, %xmm9
; SSE-NEXT:    pandn %xmm9, %xmm1
; SSE-NEXT:    por %xmm10, %xmm1
; SSE-NEXT:    movdqa {{.*#+}} xmm11 = [65535,65535,0,65535,65535,0,65535,65535]
; SSE-NEXT:    movdqa %xmm11, %xmm9
; SSE-NEXT:    pandn %xmm3, %xmm9
; SSE-NEXT:    movdqa %xmm4, %xmm12
; SSE-NEXT:    pand %xmm11, %xmm12
; SSE-NEXT:    por %xmm9, %xmm12
; SSE-NEXT:    movdqa %xmm12, %xmm9
; SSE-NEXT:    pand %xmm5, %xmm9
; SSE-NEXT:    pshuflw {{.*#+}} xmm9 = xmm9[2,1,2,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm9 = xmm9[0,1,2,3,4,5,4,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm9 = xmm9[0,3,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm9 = xmm9[1,2,3,0,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm13 = xmm9[0,1,2,3,5,5,5,5]
; SSE-NEXT:    packuswb %xmm13, %xmm13
; SSE-NEXT:    movdqa {{.*#+}} xmm9 = [255,255,255,255,255,0,0,0,255,255,255,255,255,255,255,255]
; SSE-NEXT:    pand %xmm9, %xmm13
; SSE-NEXT:    pshuflw {{.*#+}} xmm10 = xmm7[0,3,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm10 = xmm10[0,1,0,3]
; SSE-NEXT:    pshufhw {{.*#+}} xmm14 = xmm10[0,1,2,3,4,4,5,6]
; SSE-NEXT:    packuswb %xmm14, %xmm14
; SSE-NEXT:    movdqa %xmm9, %xmm10
; SSE-NEXT:    pandn %xmm14, %xmm10
; SSE-NEXT:    por %xmm13, %xmm10
; SSE-NEXT:    movdqa %xmm12, %xmm13
; SSE-NEXT:    punpcklbw {{.*#+}} xmm13 = xmm13[0],xmm6[0],xmm13[1],xmm6[1],xmm13[2],xmm6[2],xmm13[3],xmm6[3],xmm13[4],xmm6[4],xmm13[5],xmm6[5],xmm13[6],xmm6[6],xmm13[7],xmm6[7]
; SSE-NEXT:    pshufd {{.*#+}} xmm13 = xmm13[2,1,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm13 = xmm13[3,1,2,1,4,5,6,7]
; SSE-NEXT:    movdqa {{.*#+}} xmm14 = [0,65535,65535,0,65535,65535,65535,65535]
; SSE-NEXT:    punpckhbw {{.*#+}} xmm12 = xmm12[8],xmm6[8],xmm12[9],xmm6[9],xmm12[10],xmm6[10],xmm12[11],xmm6[11],xmm12[12],xmm6[12],xmm12[13],xmm6[13],xmm12[14],xmm6[14],xmm12[15],xmm6[15]
; SSE-NEXT:    pshufd {{.*#+}} xmm12 = xmm12[0,3,2,1]
; SSE-NEXT:    pshuflw {{.*#+}} xmm12 = xmm12[0,1,3,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm12 = xmm12[0,1,2,3,7,7,7,7]
; SSE-NEXT:    pand %xmm14, %xmm12
; SSE-NEXT:    pandn %xmm13, %xmm14
; SSE-NEXT:    por %xmm12, %xmm14
; SSE-NEXT:    packuswb %xmm14, %xmm14
; SSE-NEXT:    pand %xmm9, %xmm14
; SSE-NEXT:    movdqa %xmm8, %xmm12
; SSE-NEXT:    shufps {{.*#+}} xmm12 = xmm12[2,0],xmm0[3,0]
; SSE-NEXT:    movaps %xmm0, %xmm13
; SSE-NEXT:    shufps {{.*#+}} xmm13 = xmm13[0,1],xmm12[0,2]
; SSE-NEXT:    pshufhw {{.*#+}} xmm12 = xmm13[0,1,2,3,7,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm13 = xmm12[0,1,0,2]
; SSE-NEXT:    packuswb %xmm13, %xmm13
; SSE-NEXT:    movdqa %xmm9, %xmm12
; SSE-NEXT:    pandn %xmm13, %xmm12
; SSE-NEXT:    por %xmm14, %xmm12
; SSE-NEXT:    pand %xmm11, %xmm3
; SSE-NEXT:    pandn %xmm4, %xmm11
; SSE-NEXT:    por %xmm3, %xmm11
; SSE-NEXT:    pand %xmm11, %xmm5
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm5[3,1,2,0]
; SSE-NEXT:    pshufhw {{.*#+}} xmm3 = xmm3[0,1,2,3,6,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[2,1,0,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm4 = xmm3[2,1,0,3,4,5,6,7]
; SSE-NEXT:    packuswb %xmm4, %xmm4
; SSE-NEXT:    pand %xmm9, %xmm4
; SSE-NEXT:    pshufhw {{.*#+}} xmm3 = xmm7[0,1,2,3,4,7,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm5 = xmm3[0,1,0,2]
; SSE-NEXT:    packuswb %xmm5, %xmm5
; SSE-NEXT:    movdqa %xmm9, %xmm3
; SSE-NEXT:    pandn %xmm5, %xmm3
; SSE-NEXT:    por %xmm4, %xmm3
; SSE-NEXT:    movdqa %xmm11, %xmm4
; SSE-NEXT:    punpckhbw {{.*#+}} xmm4 = xmm4[8],xmm6[8],xmm4[9],xmm6[9],xmm4[10],xmm6[10],xmm4[11],xmm6[11],xmm4[12],xmm6[12],xmm4[13],xmm6[13],xmm4[14],xmm6[14],xmm4[15],xmm6[15]
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[1,1,2,3]
; SSE-NEXT:    pshufhw {{.*#+}} xmm4 = xmm4[0,1,2,3,5,5,5,5]
; SSE-NEXT:    movdqa {{.*#+}} xmm5 = [65535,0,65535,65535,0,65535,65535,65535]
; SSE-NEXT:    punpcklbw {{.*#+}} xmm11 = xmm11[0],xmm6[0],xmm11[1],xmm6[1],xmm11[2],xmm6[2],xmm11[3],xmm6[3],xmm11[4],xmm6[4],xmm11[5],xmm6[5],xmm11[6],xmm6[6],xmm11[7],xmm6[7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm6 = xmm11[0,1,2,3,7,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm6 = xmm6[0,2,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm6 = xmm6[3,1,1,2,4,5,6,7]
; SSE-NEXT:    pand %xmm5, %xmm6
; SSE-NEXT:    pandn %xmm4, %xmm5
; SSE-NEXT:    por %xmm6, %xmm5
; SSE-NEXT:    packuswb %xmm5, %xmm5
; SSE-NEXT:    pand %xmm9, %xmm5
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,0],xmm8[0,0]
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[2,0],xmm8[2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[3,1,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,1,0,3]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,4,4,5,7]
; SSE-NEXT:    packuswb %xmm0, %xmm0
; SSE-NEXT:    pandn %xmm0, %xmm9
; SSE-NEXT:    por %xmm5, %xmm9
; SSE-NEXT:    movq %xmm2, (%rsi)
; SSE-NEXT:    movq %xmm1, (%rdx)
; SSE-NEXT:    movq %xmm10, (%rcx)
; SSE-NEXT:    movq %xmm12, (%r8)
; SSE-NEXT:    movq %xmm3, (%r9)
; SSE-NEXT:    movq %xmm9, (%rax)
; SSE-NEXT:    retq
;
; AVX1-LABEL: load_i8_stride6_vf8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX1-NEXT:    vmovdqa (%rdi), %xmm1
; AVX1-NEXT:    vmovdqa 16(%rdi), %xmm2
; AVX1-NEXT:    vmovdqa 32(%rdi), %xmm0
; AVX1-NEXT:    vpshufb {{.*#+}} xmm3 = zero,zero,zero,xmm2[2,8,14,u,u,u,u,u,u,u,u,u,u]
; AVX1-NEXT:    vpshufb {{.*#+}} xmm4 = xmm1[0,6,12],zero,zero,zero,xmm1[u,u,u,u,u,u,u,u,u,u]
; AVX1-NEXT:    vpor %xmm3, %xmm4, %xmm3
; AVX1-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX1-NEXT:    vpblendw {{.*#+}} xmm3 = xmm3[0,1,2],xmm4[3],xmm3[4,5,6,7]
; AVX1-NEXT:    vpshufb {{.*#+}} xmm5 = zero,zero,zero,zero,zero,zero,xmm0[4,10,u,u,u,u,u,u,u,u]
; AVX1-NEXT:    vpor %xmm5, %xmm3, %xmm3
; AVX1-NEXT:    vpshufb {{.*#+}} xmm5 = zero,zero,zero,xmm2[3,9,15,u,u,u,u,u,u,u,u,u,u]
; AVX1-NEXT:    vpshufb {{.*#+}} xmm6 = xmm1[1,7,13],zero,zero,zero,xmm1[u,u,u,u,u,u,u,u,u,u]
; AVX1-NEXT:    vpor %xmm5, %xmm6, %xmm5
; AVX1-NEXT:    vpblendw {{.*#+}} xmm4 = xmm5[0,1,2],xmm4[3],xmm5[4,5,6,7]
; AVX1-NEXT:    vpshufb {{.*#+}} xmm5 = zero,zero,zero,zero,zero,zero,xmm0[5,11,u,u,u,u,u,u,u,u]
; AVX1-NEXT:    vpor %xmm5, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb {{.*#+}} xmm5 = zero,zero,zero,xmm2[4,10,u,u,u,u,u,u,u,u,u,u,u]
; AVX1-NEXT:    vpshufb {{.*#+}} xmm6 = xmm1[2,8,14],zero,zero,xmm1[u,u,u,u,u,u,u,u,u,u,u]
; AVX1-NEXT:    vpor %xmm5, %xmm6, %xmm5
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm6 = <0,1,2,3,4,128,128,128,u,u,u,u,u,u,u,u>
; AVX1-NEXT:    vpshufb %xmm6, %xmm5, %xmm5
; AVX1-NEXT:    vpshufb {{.*#+}} xmm7 = zero,zero,zero,zero,zero,xmm0[0,6,12,u,u,u,u,u,u,u,u]
; AVX1-NEXT:    vpor %xmm7, %xmm5, %xmm5
; AVX1-NEXT:    vpshufb {{.*#+}} xmm7 = zero,zero,zero,xmm2[5,11,u,u,u,u,u,u,u,u,u,u,u]
; AVX1-NEXT:    vpshufb {{.*#+}} xmm8 = xmm1[3,9,15],zero,zero,xmm1[u,u,u,u,u,u,u,u,u,u,u]
; AVX1-NEXT:    vpor %xmm7, %xmm8, %xmm7
; AVX1-NEXT:    vpshufb %xmm6, %xmm7, %xmm7
; AVX1-NEXT:    vpshufb {{.*#+}} xmm8 = zero,zero,zero,zero,zero,xmm0[1,7,13,u,u,u,u,u,u,u,u]
; AVX1-NEXT:    vpor %xmm7, %xmm8, %xmm7
; AVX1-NEXT:    vpshufb {{.*#+}} xmm8 = xmm1[4,10],zero,zero,zero,xmm1[u,u,u,u,u,u,u,u,u,u,u]
; AVX1-NEXT:    vpshufb {{.*#+}} xmm9 = zero,zero,xmm2[0,6,12,u,u,u,u,u,u,u,u,u,u,u]
; AVX1-NEXT:    vpor %xmm8, %xmm9, %xmm8
; AVX1-NEXT:    vpshufb %xmm6, %xmm8, %xmm8
; AVX1-NEXT:    vpshufb {{.*#+}} xmm9 = zero,zero,zero,zero,zero,xmm0[2,8,14,u,u,u,u,u,u,u,u]
; AVX1-NEXT:    vpor %xmm9, %xmm8, %xmm8
; AVX1-NEXT:    vpshufb {{.*#+}} xmm1 = xmm1[5,11],zero,zero,zero,xmm1[u,u,u,u,u,u,u,u,u,u,u]
; AVX1-NEXT:    vpshufb {{.*#+}} xmm2 = zero,zero,xmm2[1,7,13,u,u,u,u,u,u,u,u,u,u,u]
; AVX1-NEXT:    vpor %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vpshufb %xmm6, %xmm1, %xmm1
; AVX1-NEXT:    vpshufb {{.*#+}} xmm0 = zero,zero,zero,zero,zero,xmm0[3,9,15,u,u,u,u,u,u,u,u]
; AVX1-NEXT:    vpor %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vmovq %xmm3, (%rsi)
; AVX1-NEXT:    vmovq %xmm4, (%rdx)
; AVX1-NEXT:    vmovq %xmm5, (%rcx)
; AVX1-NEXT:    vmovq %xmm7, (%r8)
; AVX1-NEXT:    vmovq %xmm8, (%r9)
; AVX1-NEXT:    vmovq %xmm0, (%rax)
; AVX1-NEXT:    retq
;
; AVX2-LABEL: load_i8_stride6_vf8:
; AVX2:       # %bb.0:
; AVX2-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-NEXT:    vmovdqa (%rdi), %ymm0
; AVX2-NEXT:    vmovdqa 32(%rdi), %ymm1
; AVX2-NEXT:    vpblendw {{.*#+}} ymm2 = ymm0[0,1],ymm1[2],ymm0[3,4],ymm1[5],ymm0[6,7,8,9],ymm1[10],ymm0[11,12],ymm1[13],ymm0[14,15]
; AVX2-NEXT:    vextracti128 $1, %ymm2, %xmm3
; AVX2-NEXT:    vpshufb {{.*#+}} xmm4 = zero,zero,zero,xmm3[2,8,14],zero,zero,xmm3[u,u,u,u,u,u,u,u]
; AVX2-NEXT:    vpshufb {{.*#+}} xmm5 = xmm2[0,6,12],zero,zero,zero,xmm2[4,10,u,u,u,u,u,u,u,u]
; AVX2-NEXT:    vpor %xmm4, %xmm5, %xmm4
; AVX2-NEXT:    vpshufb {{.*#+}} xmm3 = zero,zero,zero,xmm3[3,9,15],zero,zero,xmm3[u,u,u,u,u,u,u,u]
; AVX2-NEXT:    vpshufb {{.*#+}} xmm2 = xmm2[1,7,13],zero,zero,zero,xmm2[5,11,u,u,u,u,u,u,u,u]
; AVX2-NEXT:    vpor %xmm3, %xmm2, %xmm2
; AVX2-NEXT:    vpblendw {{.*#+}} ymm3 = ymm1[0],ymm0[1,2],ymm1[3],ymm0[4,5],ymm1[6],ymm0[7],ymm1[8],ymm0[9,10],ymm1[11],ymm0[12,13],ymm1[14],ymm0[15]
; AVX2-NEXT:    vextracti128 $1, %ymm3, %xmm5
; AVX2-NEXT:    vpshufb {{.*#+}} xmm6 = zero,zero,zero,xmm5[4,10],zero,zero,zero,xmm5[u,u,u,u,u,u,u,u]
; AVX2-NEXT:    vpshufb {{.*#+}} xmm7 = xmm3[2,8,14],zero,zero,xmm3[0,6,12,u,u,u,u,u,u,u,u]
; AVX2-NEXT:    vpor %xmm6, %xmm7, %xmm6
; AVX2-NEXT:    vpshufb {{.*#+}} xmm5 = zero,zero,zero,xmm5[5,11],zero,zero,zero,xmm5[u,u,u,u,u,u,u,u]
; AVX2-NEXT:    vpshufb {{.*#+}} xmm3 = xmm3[3,9,15],zero,zero,xmm3[1,7,13,u,u,u,u,u,u,u,u]
; AVX2-NEXT:    vpor %xmm5, %xmm3, %xmm3
; AVX2-NEXT:    vpblendw {{.*#+}} ymm0 = ymm0[0],ymm1[1],ymm0[2,3],ymm1[4],ymm0[5,6],ymm1[7],ymm0[8],ymm1[9],ymm0[10,11],ymm1[12],ymm0[13,14],ymm1[15]
; AVX2-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX2-NEXT:    vpshufb {{.*#+}} xmm5 = zero,zero,xmm1[0,6,12],zero,zero,zero,xmm1[u,u,u,u,u,u,u,u]
; AVX2-NEXT:    vpshufb {{.*#+}} xmm7 = xmm0[4,10],zero,zero,zero,xmm0[2,8,14,u,u,u,u,u,u,u,u]
; AVX2-NEXT:    vpor %xmm5, %xmm7, %xmm5
; AVX2-NEXT:    vpshufb {{.*#+}} xmm1 = zero,zero,xmm1[1,7,13],zero,zero,zero,xmm1[u,u,u,u,u,u,u,u]
; AVX2-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[5,11],zero,zero,zero,xmm0[3,9,15,u,u,u,u,u,u,u,u]
; AVX2-NEXT:    vpor %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vmovq %xmm4, (%rsi)
; AVX2-NEXT:    vmovq %xmm2, (%rdx)
; AVX2-NEXT:    vmovq %xmm6, (%rcx)
; AVX2-NEXT:    vmovq %xmm3, (%r8)
; AVX2-NEXT:    vmovq %xmm5, (%r9)
; AVX2-NEXT:    vmovq %xmm0, (%rax)
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: load_i8_stride6_vf8:
; AVX512:       # %bb.0:
; AVX512-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512-NEXT:    vmovdqa (%rdi), %ymm0
; AVX512-NEXT:    vmovdqa 32(%rdi), %ymm1
; AVX512-NEXT:    vpblendw {{.*#+}} ymm2 = ymm0[0,1],ymm1[2],ymm0[3,4],ymm1[5],ymm0[6,7,8,9],ymm1[10],ymm0[11,12],ymm1[13],ymm0[14,15]
; AVX512-NEXT:    vextracti128 $1, %ymm2, %xmm3
; AVX512-NEXT:    vpshufb {{.*#+}} xmm4 = zero,zero,zero,xmm3[2,8,14],zero,zero,xmm3[u,u,u,u,u,u,u,u]
; AVX512-NEXT:    vpshufb {{.*#+}} xmm5 = xmm2[0,6,12],zero,zero,zero,xmm2[4,10,u,u,u,u,u,u,u,u]
; AVX512-NEXT:    vpor %xmm4, %xmm5, %xmm4
; AVX512-NEXT:    vpshufb {{.*#+}} xmm3 = zero,zero,zero,xmm3[3,9,15],zero,zero,xmm3[u,u,u,u,u,u,u,u]
; AVX512-NEXT:    vpshufb {{.*#+}} xmm2 = xmm2[1,7,13],zero,zero,zero,xmm2[5,11,u,u,u,u,u,u,u,u]
; AVX512-NEXT:    vpor %xmm3, %xmm2, %xmm2
; AVX512-NEXT:    vpblendw {{.*#+}} ymm3 = ymm1[0],ymm0[1,2],ymm1[3],ymm0[4,5],ymm1[6],ymm0[7],ymm1[8],ymm0[9,10],ymm1[11],ymm0[12,13],ymm1[14],ymm0[15]
; AVX512-NEXT:    vextracti128 $1, %ymm3, %xmm5
; AVX512-NEXT:    vpshufb {{.*#+}} xmm6 = zero,zero,zero,xmm5[4,10],zero,zero,zero,xmm5[u,u,u,u,u,u,u,u]
; AVX512-NEXT:    vpshufb {{.*#+}} xmm7 = xmm3[2,8,14],zero,zero,xmm3[0,6,12,u,u,u,u,u,u,u,u]
; AVX512-NEXT:    vpor %xmm6, %xmm7, %xmm6
; AVX512-NEXT:    vpshufb {{.*#+}} xmm5 = zero,zero,zero,xmm5[5,11],zero,zero,zero,xmm5[u,u,u,u,u,u,u,u]
; AVX512-NEXT:    vpshufb {{.*#+}} xmm3 = xmm3[3,9,15],zero,zero,xmm3[1,7,13,u,u,u,u,u,u,u,u]
; AVX512-NEXT:    vpor %xmm5, %xmm3, %xmm3
; AVX512-NEXT:    vpblendw {{.*#+}} ymm0 = ymm0[0],ymm1[1],ymm0[2,3],ymm1[4],ymm0[5,6],ymm1[7],ymm0[8],ymm1[9],ymm0[10,11],ymm1[12],ymm0[13,14],ymm1[15]
; AVX512-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX512-NEXT:    vpshufb {{.*#+}} xmm5 = zero,zero,xmm1[0,6,12],zero,zero,zero,xmm1[u,u,u,u,u,u,u,u]
; AVX512-NEXT:    vpshufb {{.*#+}} xmm7 = xmm0[4,10],zero,zero,zero,xmm0[2,8,14,u,u,u,u,u,u,u,u]
; AVX512-NEXT:    vpor %xmm5, %xmm7, %xmm5
; AVX512-NEXT:    vpshufb {{.*#+}} xmm1 = zero,zero,xmm1[1,7,13],zero,zero,zero,xmm1[u,u,u,u,u,u,u,u]
; AVX512-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[5,11],zero,zero,zero,xmm0[3,9,15,u,u,u,u,u,u,u,u]
; AVX512-NEXT:    vpor %xmm1, %xmm0, %xmm0
; AVX512-NEXT:    vmovq %xmm4, (%rsi)
; AVX512-NEXT:    vmovq %xmm2, (%rdx)
; AVX512-NEXT:    vmovq %xmm6, (%rcx)
; AVX512-NEXT:    vmovq %xmm3, (%r8)
; AVX512-NEXT:    vmovq %xmm5, (%r9)
; AVX512-NEXT:    vmovq %xmm0, (%rax)
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %wide.vec = load <48 x i8>, ptr %in.vec, align 32

  %strided.vec0 = shufflevector <48 x i8> %wide.vec, <48 x i8> poison, <8 x i32> <i32 0, i32 6, i32 12, i32 18, i32 24, i32 30, i32 36, i32 42>
  %strided.vec1 = shufflevector <48 x i8> %wide.vec, <48 x i8> poison, <8 x i32> <i32 1, i32 7, i32 13, i32 19, i32 25, i32 31, i32 37, i32 43>
  %strided.vec2 = shufflevector <48 x i8> %wide.vec, <48 x i8> poison, <8 x i32> <i32 2, i32 8, i32 14, i32 20, i32 26, i32 32, i32 38, i32 44>
  %strided.vec3 = shufflevector <48 x i8> %wide.vec, <48 x i8> poison, <8 x i32> <i32 3, i32 9, i32 15, i32 21, i32 27, i32 33, i32 39, i32 45>
  %strided.vec4 = shufflevector <48 x i8> %wide.vec, <48 x i8> poison, <8 x i32> <i32 4, i32 10, i32 16, i32 22, i32 28, i32 34, i32 40, i32 46>
  %strided.vec5 = shufflevector <48 x i8> %wide.vec, <48 x i8> poison, <8 x i32> <i32 5, i32 11, i32 17, i32 23, i32 29, i32 35, i32 41, i32 47>

  store <8 x i8> %strided.vec0, ptr %out.vec0, align 32
  store <8 x i8> %strided.vec1, ptr %out.vec1, align 32
  store <8 x i8> %strided.vec2, ptr %out.vec2, align 32
  store <8 x i8> %strided.vec3, ptr %out.vec3, align 32
  store <8 x i8> %strided.vec4, ptr %out.vec4, align 32
  store <8 x i8> %strided.vec5, ptr %out.vec5, align 32

  ret void
}

define void @load_i8_stride6_vf16(ptr %in.vec, ptr %out.vec0, ptr %out.vec1, ptr %out.vec2, ptr %out.vec3, ptr %out.vec4, ptr %out.vec5) nounwind {
; SSE-LABEL: load_i8_stride6_vf16:
; SSE:       # %bb.0:
; SSE-NEXT:    movdqa 64(%rdi), %xmm1
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa (%rdi), %xmm5
; SSE-NEXT:    movdqa 16(%rdi), %xmm11
; SSE-NEXT:    movdqa 32(%rdi), %xmm10
; SSE-NEXT:    movdqa 48(%rdi), %xmm6
; SSE-NEXT:    movdqa {{.*#+}} xmm3 = [65535,65535,0,65535,65535,0,65535,65535]
; SSE-NEXT:    movdqa %xmm3, %xmm7
; SSE-NEXT:    pandn %xmm10, %xmm7
; SSE-NEXT:    movdqa {{.*#+}} xmm8 = [65535,0,65535,65535,0,65535,65535,0]
; SSE-NEXT:    movdqa %xmm8, %xmm0
; SSE-NEXT:    pandn %xmm6, %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm3, %xmm0
; SSE-NEXT:    pandn %xmm6, %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pand %xmm3, %xmm6
; SSE-NEXT:    por %xmm7, %xmm6
; SSE-NEXT:    movdqa {{.*#+}} xmm7 = [255,255,255,255,255,255,255,255]
; SSE-NEXT:    movdqa %xmm6, %xmm0
; SSE-NEXT:    pand %xmm7, %xmm0
; SSE-NEXT:    pshuflw {{.*#+}} xmm2 = xmm0[0,3,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,3,2,3]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,1,2,1]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,4,5,6,5]
; SSE-NEXT:    packuswb %xmm2, %xmm0
; SSE-NEXT:    movdqa {{.*#+}} xmm4 = [65535,65535,65535,0,0,0,65535,65535]
; SSE-NEXT:    pandn %xmm0, %xmm4
; SSE-NEXT:    movdqa %xmm8, %xmm9
; SSE-NEXT:    movdqa %xmm11, %xmm0
; SSE-NEXT:    pandn %xmm11, %xmm9
; SSE-NEXT:    movdqa %xmm1, %xmm11
; SSE-NEXT:    pand %xmm3, %xmm11
; SSE-NEXT:    movdqa %xmm3, %xmm2
; SSE-NEXT:    pandn %xmm0, %xmm2
; SSE-NEXT:    movdqa %xmm0, %xmm1
; SSE-NEXT:    movdqa %xmm5, %xmm14
; SSE-NEXT:    pand %xmm3, %xmm14
; SSE-NEXT:    movdqa 80(%rdi), %xmm0
; SSE-NEXT:    movdqa %xmm0, %xmm13
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pand %xmm3, %xmm13
; SSE-NEXT:    movdqa %xmm10, %xmm15
; SSE-NEXT:    pand %xmm3, %xmm10
; SSE-NEXT:    pand %xmm3, %xmm1
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm3, %xmm1
; SSE-NEXT:    movdqa %xmm3, %xmm12
; SSE-NEXT:    pandn %xmm5, %xmm3
; SSE-NEXT:    pand %xmm8, %xmm5
; SSE-NEXT:    por %xmm9, %xmm5
; SSE-NEXT:    movdqa %xmm5, %xmm9
; SSE-NEXT:    pand %xmm7, %xmm9
; SSE-NEXT:    pshufd {{.*#+}} xmm9 = xmm9[0,2,1,3]
; SSE-NEXT:    pshufhw {{.*#+}} xmm9 = xmm9[0,1,2,3,6,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm9 = xmm9[0,2,1,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm9 = xmm9[0,3,2,1,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm9 = xmm9[0,1,2,3,4,7,6,7]
; SSE-NEXT:    packuswb %xmm9, %xmm9
; SSE-NEXT:    pand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm9
; SSE-NEXT:    por %xmm4, %xmm9
; SSE-NEXT:    pandn %xmm0, %xmm1
; SSE-NEXT:    por %xmm1, %xmm11
; SSE-NEXT:    movdqa %xmm11, %xmm1
; SSE-NEXT:    pand %xmm7, %xmm1
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[3,1,2,0]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[2,1,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,3,2,0]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,4,7,6,5]
; SSE-NEXT:    packuswb %xmm1, %xmm0
; SSE-NEXT:    movdqa {{.*#+}} xmm4 = [255,255,255,255,255,255,255,255,255,255,255,0,0,0,0,0]
; SSE-NEXT:    movdqa %xmm4, %xmm1
; SSE-NEXT:    pandn %xmm0, %xmm1
; SSE-NEXT:    pand %xmm4, %xmm9
; SSE-NEXT:    por %xmm9, %xmm1
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pxor %xmm9, %xmm9
; SSE-NEXT:    movdqa %xmm6, %xmm0
; SSE-NEXT:    punpckhbw {{.*#+}} xmm0 = xmm0[8],xmm9[8],xmm0[9],xmm9[9],xmm0[10],xmm9[10],xmm0[11],xmm9[11],xmm0[12],xmm9[12],xmm0[13],xmm9[13],xmm0[14],xmm9[14],xmm0[15],xmm9[15]
; SSE-NEXT:    punpcklbw {{.*#+}} xmm6 = xmm6[0],xmm9[0],xmm6[1],xmm9[1],xmm6[2],xmm9[2],xmm6[3],xmm9[3],xmm6[4],xmm9[4],xmm6[5],xmm9[5],xmm6[6],xmm9[6],xmm6[7],xmm9[7]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm6[2,2,3,3]
; SSE-NEXT:    punpcklwd {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3]
; SSE-NEXT:    psrld $16, %xmm0
; SSE-NEXT:    pshufd {{.*#+}} xmm6 = xmm6[0,1,0,3]
; SSE-NEXT:    pshufhw {{.*#+}} xmm6 = xmm6[0,1,2,3,5,7,6,7]
; SSE-NEXT:    punpckhdq {{.*#+}} xmm6 = xmm6[2],xmm0[2],xmm6[3],xmm0[3]
; SSE-NEXT:    packuswb %xmm6, %xmm1
; SSE-NEXT:    movdqa %xmm5, %xmm0
; SSE-NEXT:    punpckhbw {{.*#+}} xmm0 = xmm0[8],xmm9[8],xmm0[9],xmm9[9],xmm0[10],xmm9[10],xmm0[11],xmm9[11],xmm0[12],xmm9[12],xmm0[13],xmm9[13],xmm0[14],xmm9[14],xmm0[15],xmm9[15]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[2,1,0,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[1,1,1,1,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,5,7,6,7]
; SSE-NEXT:    punpcklbw {{.*#+}} xmm5 = xmm5[0],xmm9[0],xmm5[1],xmm9[1],xmm5[2],xmm9[2],xmm5[3],xmm9[3],xmm5[4],xmm9[4],xmm5[5],xmm9[5],xmm5[6],xmm9[6],xmm5[7],xmm9[7]
; SSE-NEXT:    pshuflw {{.*#+}} xmm5 = xmm5[3,1,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm5 = xmm5[0,3,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm5 = xmm5[1,3,2,0,4,5,6,7]
; SSE-NEXT:    movdqa {{.*#+}} xmm6 = [65535,65535,0,65535,0,0,65535,65535]
; SSE-NEXT:    pand %xmm6, %xmm5
; SSE-NEXT:    pandn %xmm0, %xmm6
; SSE-NEXT:    por %xmm5, %xmm6
; SSE-NEXT:    packuswb %xmm6, %xmm6
; SSE-NEXT:    movdqa {{.*#+}} xmm8 = [65535,65535,65535,0,0,0,65535,65535]
; SSE-NEXT:    pand %xmm8, %xmm6
; SSE-NEXT:    pandn %xmm1, %xmm8
; SSE-NEXT:    por %xmm8, %xmm6
; SSE-NEXT:    movdqa %xmm11, %xmm0
; SSE-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0],xmm9[0],xmm0[1],xmm9[1],xmm0[2],xmm9[2],xmm0[3],xmm9[3],xmm0[4],xmm9[4],xmm0[5],xmm9[5],xmm0[6],xmm9[6],xmm0[7],xmm9[7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,5,5,5,5]
; SSE-NEXT:    punpckhbw {{.*#+}} xmm11 = xmm11[8],xmm9[8],xmm11[9],xmm9[9],xmm11[10],xmm9[10],xmm11[11],xmm9[11],xmm11[12],xmm9[12],xmm11[13],xmm9[13],xmm11[14],xmm9[14],xmm11[15],xmm9[15]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm11[3,1,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,1,0,3]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,5,7,6,4]
; SSE-NEXT:    movdqa {{.*#+}} xmm5 = [65535,65535,65535,0,65535,65535,0,65535]
; SSE-NEXT:    pand %xmm5, %xmm1
; SSE-NEXT:    pandn %xmm0, %xmm5
; SSE-NEXT:    por %xmm1, %xmm5
; SSE-NEXT:    packuswb %xmm5, %xmm0
; SSE-NEXT:    movdqa %xmm4, %xmm11
; SSE-NEXT:    pandn %xmm0, %xmm11
; SSE-NEXT:    pand %xmm4, %xmm6
; SSE-NEXT:    por %xmm6, %xmm11
; SSE-NEXT:    pand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm15
; SSE-NEXT:    por {{[-0-9]+}}(%r{{[sb]}}p), %xmm15 # 16-byte Folded Reload
; SSE-NEXT:    movdqa %xmm15, %xmm0
; SSE-NEXT:    pand %xmm7, %xmm0
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm0[0,1,2,3,4,7,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,2,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[1,2,3,3,4,5,6,7]
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[0,3,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,1,0,3]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,4,4,5,6]
; SSE-NEXT:    packuswb %xmm1, %xmm0
; SSE-NEXT:    por %xmm2, %xmm14
; SSE-NEXT:    movdqa %xmm14, %xmm1
; SSE-NEXT:    pand %xmm7, %xmm1
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[2,1,2,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,4,5,4,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,3,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[1,2,3,0,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,5,5,5,5]
; SSE-NEXT:    packuswb %xmm1, %xmm1
; SSE-NEXT:    movdqa {{.*#+}} xmm2 = [0,0,0,0,0,255,255,255,255,255,255,255,255,255,255,255]
; SSE-NEXT:    movdqa %xmm2, %xmm5
; SSE-NEXT:    pandn %xmm1, %xmm5
; SSE-NEXT:    pand %xmm2, %xmm0
; SSE-NEXT:    por %xmm0, %xmm5
; SSE-NEXT:    pandn {{[-0-9]+}}(%r{{[sb]}}p), %xmm12 # 16-byte Folded Reload
; SSE-NEXT:    por %xmm12, %xmm13
; SSE-NEXT:    movdqa %xmm13, %xmm0
; SSE-NEXT:    pand %xmm7, %xmm0
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[0,3,2,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,6,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,1,2,0]
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[2,2,2,2,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,5,6,7,4]
; SSE-NEXT:    packuswb %xmm0, %xmm0
; SSE-NEXT:    movdqa %xmm4, %xmm8
; SSE-NEXT:    pandn %xmm0, %xmm8
; SSE-NEXT:    pand %xmm4, %xmm5
; SSE-NEXT:    por %xmm5, %xmm8
; SSE-NEXT:    movdqa %xmm15, %xmm0
; SSE-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0],xmm9[0],xmm0[1],xmm9[1],xmm0[2],xmm9[2],xmm0[3],xmm9[3],xmm0[4],xmm9[4],xmm0[5],xmm9[5],xmm0[6],xmm9[6],xmm0[7],xmm9[7]
; SSE-NEXT:    punpckhbw {{.*#+}} xmm15 = xmm15[8],xmm9[8],xmm15[9],xmm9[9],xmm15[10],xmm9[10],xmm15[11],xmm9[11],xmm15[12],xmm9[12],xmm15[13],xmm9[13],xmm15[14],xmm9[14],xmm15[15],xmm9[15]
; SSE-NEXT:    movdqa %xmm15, %xmm1
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[2,0],xmm0[3,0]
; SSE-NEXT:    movaps %xmm0, %xmm5
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[0,1],xmm1[0,2]
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,0],xmm15[0,0]
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[2,0],xmm15[2,3]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm5[0,1,2,3,7,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,1,0,2]
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[3,1,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,3,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[0,1,3,3,4,5,6,7]
; SSE-NEXT:    packuswb %xmm0, %xmm1
; SSE-NEXT:    movdqa %xmm14, %xmm0
; SSE-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0],xmm9[0],xmm0[1],xmm9[1],xmm0[2],xmm9[2],xmm0[3],xmm9[3],xmm0[4],xmm9[4],xmm0[5],xmm9[5],xmm0[6],xmm9[6],xmm0[7],xmm9[7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[2,1,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[3,1,2,1,4,5,6,7]
; SSE-NEXT:    punpckhbw {{.*#+}} xmm14 = xmm14[8],xmm9[8],xmm14[9],xmm9[9],xmm14[10],xmm9[10],xmm14[11],xmm9[11],xmm14[12],xmm9[12],xmm14[13],xmm9[13],xmm14[14],xmm9[14],xmm14[15],xmm9[15]
; SSE-NEXT:    pshufd {{.*#+}} xmm5 = xmm14[0,3,2,1]
; SSE-NEXT:    pshuflw {{.*#+}} xmm5 = xmm5[0,1,3,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm5 = xmm5[0,1,2,3,7,7,7,7]
; SSE-NEXT:    movdqa {{.*#+}} xmm6 = [0,65535,65535,0,65535,65535,65535,65535]
; SSE-NEXT:    pand %xmm6, %xmm5
; SSE-NEXT:    pandn %xmm0, %xmm6
; SSE-NEXT:    por %xmm5, %xmm6
; SSE-NEXT:    pand %xmm2, %xmm1
; SSE-NEXT:    packuswb %xmm6, %xmm6
; SSE-NEXT:    pandn %xmm6, %xmm2
; SSE-NEXT:    por %xmm1, %xmm2
; SSE-NEXT:    movdqa %xmm13, %xmm0
; SSE-NEXT:    punpckhbw {{.*#+}} xmm0 = xmm0[8],xmm9[8],xmm0[9],xmm9[9],xmm0[10],xmm9[10],xmm0[11],xmm9[11],xmm0[12],xmm9[12],xmm0[13],xmm9[13],xmm0[14],xmm9[14],xmm0[15],xmm9[15]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,1,2,1]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,7,5,6,5]
; SSE-NEXT:    punpcklbw {{.*#+}} xmm13 = xmm13[0],xmm9[0],xmm13[1],xmm9[1],xmm13[2],xmm9[2],xmm13[3],xmm9[3],xmm13[4],xmm9[4],xmm13[5],xmm9[5],xmm13[6],xmm9[6],xmm13[7],xmm9[7]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm13[0,2,0,3]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,4,5,7,7]
; SSE-NEXT:    movdqa {{.*#+}} xmm5 = [65535,65535,65535,65535,0,65535,65535,0]
; SSE-NEXT:    pand %xmm5, %xmm1
; SSE-NEXT:    pandn %xmm0, %xmm5
; SSE-NEXT:    por %xmm1, %xmm5
; SSE-NEXT:    pand %xmm4, %xmm2
; SSE-NEXT:    packuswb %xmm5, %xmm0
; SSE-NEXT:    pandn %xmm0, %xmm4
; SSE-NEXT:    por %xmm2, %xmm4
; SSE-NEXT:    por {{[-0-9]+}}(%r{{[sb]}}p), %xmm10 # 16-byte Folded Reload
; SSE-NEXT:    movdqa %xmm10, %xmm0
; SSE-NEXT:    pand %xmm7, %xmm0
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm0[2,1,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[2,1,2,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,4,7,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,1,0,2]
; SSE-NEXT:    packuswb %xmm1, %xmm0
; SSE-NEXT:    movdqa {{.*#+}} xmm2 = [255,255,255,255,255,0,0,0,0,0,255,255,255,255,255,255]
; SSE-NEXT:    movdqa %xmm2, %xmm1
; SSE-NEXT:    pandn %xmm0, %xmm1
; SSE-NEXT:    por {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Folded Reload
; SSE-NEXT:    movdqa %xmm3, %xmm0
; SSE-NEXT:    pand %xmm7, %xmm0
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[3,1,2,0]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,6,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[2,1,0,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm5 = xmm0[2,1,0,3,4,5,6,7]
; SSE-NEXT:    packuswb %xmm5, %xmm5
; SSE-NEXT:    pand %xmm2, %xmm5
; SSE-NEXT:    por %xmm1, %xmm5
; SSE-NEXT:    movdqa {{.*#+}} xmm12 = [65535,0,65535,65535,0,65535,65535,0]
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    pand %xmm12, %xmm1
; SSE-NEXT:    pandn {{[-0-9]+}}(%r{{[sb]}}p), %xmm12 # 16-byte Folded Reload
; SSE-NEXT:    movdqa {{.*#+}} xmm0 = [65535,65535,65535,65535,65535,0,0,0]
; SSE-NEXT:    pand %xmm0, %xmm5
; SSE-NEXT:    por %xmm1, %xmm12
; SSE-NEXT:    pand %xmm12, %xmm7
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm7[0,2,1,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[0,1,2,1,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,2,1,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[0,1,0,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,6,5,4,7]
; SSE-NEXT:    packuswb %xmm1, %xmm1
; SSE-NEXT:    movdqa %xmm0, %xmm7
; SSE-NEXT:    pandn %xmm1, %xmm7
; SSE-NEXT:    por %xmm5, %xmm7
; SSE-NEXT:    movdqa %xmm10, %xmm1
; SSE-NEXT:    punpckhbw {{.*#+}} xmm1 = xmm1[8],xmm9[8],xmm1[9],xmm9[9],xmm1[10],xmm9[10],xmm1[11],xmm9[11],xmm1[12],xmm9[12],xmm1[13],xmm9[13],xmm1[14],xmm9[14],xmm1[15],xmm9[15]
; SSE-NEXT:    punpcklbw {{.*#+}} xmm10 = xmm10[0],xmm9[0],xmm10[1],xmm9[1],xmm10[2],xmm9[2],xmm10[3],xmm9[3],xmm10[4],xmm9[4],xmm10[5],xmm9[5],xmm10[6],xmm9[6],xmm10[7],xmm9[7]
; SSE-NEXT:    movdqa %xmm10, %xmm5
; SSE-NEXT:    shufps {{.*#+}} xmm10 = xmm10[1,0],xmm1[0,0]
; SSE-NEXT:    shufps {{.*#+}} xmm10 = xmm10[2,0],xmm1[2,3]
; SSE-NEXT:    psrlq $48, %xmm1
; SSE-NEXT:    psrldq {{.*#+}} xmm5 = xmm5[10,11,12,13,14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; SSE-NEXT:    punpcklwd {{.*#+}} xmm5 = xmm5[0],xmm1[0],xmm5[1],xmm1[1],xmm5[2],xmm1[2],xmm5[3],xmm1[3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm10[3,1,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,1,0,3]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,4,4,5,7]
; SSE-NEXT:    packuswb %xmm5, %xmm1
; SSE-NEXT:    movdqa %xmm3, %xmm5
; SSE-NEXT:    punpckhbw {{.*#+}} xmm5 = xmm5[8],xmm9[8],xmm5[9],xmm9[9],xmm5[10],xmm9[10],xmm5[11],xmm9[11],xmm5[12],xmm9[12],xmm5[13],xmm9[13],xmm5[14],xmm9[14],xmm5[15],xmm9[15]
; SSE-NEXT:    pshufd {{.*#+}} xmm5 = xmm5[1,1,2,3]
; SSE-NEXT:    pshufhw {{.*#+}} xmm5 = xmm5[0,1,2,3,5,5,5,5]
; SSE-NEXT:    movdqa {{.*#+}} xmm6 = [65535,0,65535,65535,0,65535,65535,65535]
; SSE-NEXT:    punpcklbw {{.*#+}} xmm3 = xmm3[0],xmm9[0],xmm3[1],xmm9[1],xmm3[2],xmm9[2],xmm3[3],xmm9[3],xmm3[4],xmm9[4],xmm3[5],xmm9[5],xmm3[6],xmm9[6],xmm3[7],xmm9[7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm3 = xmm3[0,1,2,3,7,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[0,2,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm3 = xmm3[3,1,1,2,4,5,6,7]
; SSE-NEXT:    pand %xmm6, %xmm3
; SSE-NEXT:    pandn %xmm5, %xmm6
; SSE-NEXT:    por %xmm3, %xmm6
; SSE-NEXT:    packuswb %xmm6, %xmm6
; SSE-NEXT:    pand %xmm2, %xmm6
; SSE-NEXT:    pandn %xmm1, %xmm2
; SSE-NEXT:    por %xmm2, %xmm6
; SSE-NEXT:    movdqa %xmm12, %xmm1
; SSE-NEXT:    punpcklbw {{.*#+}} xmm1 = xmm1[0],xmm9[0],xmm1[1],xmm9[1],xmm1[2],xmm9[2],xmm1[3],xmm9[3],xmm1[4],xmm9[4],xmm1[5],xmm9[5],xmm1[6],xmm9[6],xmm1[7],xmm9[7]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,3,1,1]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[0,1,1,3,4,5,6,7]
; SSE-NEXT:    punpckhbw {{.*#+}} xmm12 = xmm12[8],xmm9[8],xmm12[9],xmm9[9],xmm12[10],xmm9[10],xmm12[11],xmm9[11],xmm12[12],xmm9[12],xmm12[13],xmm9[13],xmm12[14],xmm9[14],xmm12[15],xmm9[15]
; SSE-NEXT:    movdqa {{.*#+}} xmm2 = [65535,65535,65535,65535,0,65535,0,0]
; SSE-NEXT:    pand %xmm2, %xmm1
; SSE-NEXT:    pshufhw {{.*#+}} xmm3 = xmm12[0,1,2,3,7,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[0,1,2,0]
; SSE-NEXT:    pshufhw {{.*#+}} xmm3 = xmm3[0,1,2,3,5,5,7,4]
; SSE-NEXT:    pandn %xmm3, %xmm2
; SSE-NEXT:    por %xmm1, %xmm2
; SSE-NEXT:    pand %xmm0, %xmm6
; SSE-NEXT:    packuswb %xmm2, %xmm1
; SSE-NEXT:    pandn %xmm1, %xmm0
; SSE-NEXT:    por %xmm6, %xmm0
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movaps %xmm1, (%rsi)
; SSE-NEXT:    movdqa %xmm11, (%rdx)
; SSE-NEXT:    movdqa %xmm8, (%rcx)
; SSE-NEXT:    movdqa %xmm4, (%r8)
; SSE-NEXT:    movdqa %xmm7, (%r9)
; SSE-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; SSE-NEXT:    movdqa %xmm0, (%rax)
; SSE-NEXT:    retq
;
; AVX1-LABEL: load_i8_stride6_vf16:
; AVX1:       # %bb.0:
; AVX1-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX1-NEXT:    vmovdqa (%rdi), %xmm1
; AVX1-NEXT:    vmovdqa 16(%rdi), %xmm2
; AVX1-NEXT:    vmovdqa 32(%rdi), %xmm0
; AVX1-NEXT:    vmovdqa 48(%rdi), %xmm3
; AVX1-NEXT:    vpshufb {{.*#+}} xmm4 = xmm0[u,u,4,10,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX1-NEXT:    vpshufb {{.*#+}} xmm5 = xmm3[u,u,u,u,0,6,12,u,u,u,u,u,u,u,u,u]
; AVX1-NEXT:    vpunpckldq {{.*#+}} xmm4 = xmm5[0],xmm4[0],xmm5[1],xmm4[1]
; AVX1-NEXT:    vpshufb {{.*#+}} xmm5 = zero,zero,zero,xmm2[2,8,14,u,u,u,u,u,u,u,u,u,u]
; AVX1-NEXT:    vpshufb {{.*#+}} xmm6 = xmm1[0,6,12],zero,zero,zero,xmm1[u,u,u,u,u,u,u,u,u,u]
; AVX1-NEXT:    vpor %xmm5, %xmm6, %xmm5
; AVX1-NEXT:    vpblendw {{.*#+}} xmm6 = xmm5[0,1,2],xmm4[3,4,5],xmm5[6,7]
; AVX1-NEXT:    vmovdqa 80(%rdi), %xmm4
; AVX1-NEXT:    vpshufb {{.*#+}} xmm7 = xmm4[u,u,u,u,u,u,u,u,u,u,u],zero,zero,zero,xmm4[4,10]
; AVX1-NEXT:    vmovdqa 64(%rdi), %xmm5
; AVX1-NEXT:    vpshufb {{.*#+}} xmm8 = xmm5[u,u,u,u,u,u,u,u,u,u,u,2,8,14],zero,zero
; AVX1-NEXT:    vpor %xmm7, %xmm8, %xmm7
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm9 = [255,255,255,255,255,255,255,255,255,255,255,0,0,0,0,0]
; AVX1-NEXT:    vpblendvb %xmm9, %xmm6, %xmm7, %xmm6
; AVX1-NEXT:    vpshufb {{.*#+}} xmm7 = xmm0[u,u,5,11,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX1-NEXT:    vpshufb {{.*#+}} xmm8 = xmm3[u,u,u,u,1,7,13,u,u,u,u,u,u,u,u,u]
; AVX1-NEXT:    vpunpckldq {{.*#+}} xmm7 = xmm8[0],xmm7[0],xmm8[1],xmm7[1]
; AVX1-NEXT:    vpshufb {{.*#+}} xmm8 = zero,zero,zero,xmm2[3,9,15,u,u,u,u,u,u,u,u,u,u]
; AVX1-NEXT:    vpshufb {{.*#+}} xmm10 = xmm1[1,7,13],zero,zero,zero,xmm1[u,u,u,u,u,u,u,u,u,u]
; AVX1-NEXT:    vpor %xmm8, %xmm10, %xmm8
; AVX1-NEXT:    vpblendw {{.*#+}} xmm7 = xmm8[0,1,2],xmm7[3,4,5],xmm8[6,7]
; AVX1-NEXT:    vpshufb {{.*#+}} xmm8 = xmm4[u,u,u,u,u,u,u,u,u,u,u],zero,zero,zero,xmm4[5,11]
; AVX1-NEXT:    vpshufb {{.*#+}} xmm10 = xmm5[u,u,u,u,u,u,u,u,u,u,u,3,9,15],zero,zero
; AVX1-NEXT:    vpor %xmm8, %xmm10, %xmm8
; AVX1-NEXT:    vpblendvb %xmm9, %xmm7, %xmm8, %xmm7
; AVX1-NEXT:    vpshufb {{.*#+}} xmm8 = xmm3[2,8,14,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX1-NEXT:    vpshufb {{.*#+}} xmm10 = xmm0[u,u,u,u,u,0,6,12,u,u,u,u,u,u,u,u]
; AVX1-NEXT:    vpunpcklqdq {{.*#+}} xmm8 = xmm10[0],xmm8[0]
; AVX1-NEXT:    vpshufb {{.*#+}} xmm10 = zero,zero,zero,xmm2[4,10,u,u,u,u,u,u,u,u,u,u,u]
; AVX1-NEXT:    vpshufb {{.*#+}} xmm11 = xmm1[2,8,14],zero,zero,xmm1[u,u,u,u,u,u,u,u,u,u,u]
; AVX1-NEXT:    vpor %xmm10, %xmm11, %xmm10
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm11 = <0,0,0,0,0,255,255,255,255,255,255,u,u,u,u,u>
; AVX1-NEXT:    vpblendvb %xmm11, %xmm8, %xmm10, %xmm8
; AVX1-NEXT:    vpshufb {{.*#+}} xmm10 = xmm5[u,u,u,u,u,u,u,u,u,u,u,4,10],zero,zero,zero
; AVX1-NEXT:    vpshufb {{.*#+}} xmm12 = xmm4[u,u,u,u,u,u,u,u,u,u,u],zero,zero,xmm4[0,6,12]
; AVX1-NEXT:    vpor %xmm10, %xmm12, %xmm10
; AVX1-NEXT:    vpblendvb %xmm9, %xmm8, %xmm10, %xmm8
; AVX1-NEXT:    vpshufb {{.*#+}} xmm10 = xmm3[3,9,15,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX1-NEXT:    vpshufb {{.*#+}} xmm12 = xmm0[u,u,u,u,u,1,7,13,u,u,u,u,u,u,u,u]
; AVX1-NEXT:    vpunpcklqdq {{.*#+}} xmm10 = xmm12[0],xmm10[0]
; AVX1-NEXT:    vpshufb {{.*#+}} xmm12 = zero,zero,zero,xmm2[5,11,u,u,u,u,u,u,u,u,u,u,u]
; AVX1-NEXT:    vpshufb {{.*#+}} xmm13 = xmm1[3,9,15],zero,zero,xmm1[u,u,u,u,u,u,u,u,u,u,u]
; AVX1-NEXT:    vpor %xmm12, %xmm13, %xmm12
; AVX1-NEXT:    vpblendvb %xmm11, %xmm10, %xmm12, %xmm10
; AVX1-NEXT:    vpshufb {{.*#+}} xmm11 = xmm5[u,u,u,u,u,u,u,u,u,u,u,5,11],zero,zero,zero
; AVX1-NEXT:    vpshufb {{.*#+}} xmm12 = xmm4[u,u,u,u,u,u,u,u,u,u,u],zero,zero,xmm4[1,7,13]
; AVX1-NEXT:    vpor %xmm11, %xmm12, %xmm11
; AVX1-NEXT:    vpblendvb %xmm9, %xmm10, %xmm11, %xmm9
; AVX1-NEXT:    vpshufb {{.*#+}} xmm10 = xmm1[4,10],zero,zero,zero,xmm1[u,u,u,u,u,u,u,u,u,u,u]
; AVX1-NEXT:    vpshufb {{.*#+}} xmm11 = zero,zero,xmm2[0,6,12,u,u,u,u,u,u,u,u,u,u,u]
; AVX1-NEXT:    vpor %xmm10, %xmm11, %xmm10
; AVX1-NEXT:    vpshufb {{.*#+}} xmm11 = xmm3[u,u,u,u,u,u,u,u,4,10,u,u,u,u,u,u]
; AVX1-NEXT:    vpshufb {{.*#+}} xmm12 = xmm0[u,u,u,u,u,u,u,u,u,u,u,u,u,2,8,14]
; AVX1-NEXT:    vpunpckhqdq {{.*#+}} xmm11 = xmm12[1],xmm11[1]
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm12 = <255,255,255,255,255,0,0,0,0,0,u,u,u,u,u,u>
; AVX1-NEXT:    vpblendvb %xmm12, %xmm10, %xmm11, %xmm10
; AVX1-NEXT:    vpshufb {{.*#+}} xmm11 = xmm4[u,u,u,u,u,u,u,u,u,u],zero,zero,zero,xmm4[2,8,14]
; AVX1-NEXT:    vpshufb {{.*#+}} xmm13 = xmm5[u,u,u,u,u,u,u,u,u,u,0,6,12],zero,zero,zero
; AVX1-NEXT:    vpor %xmm11, %xmm13, %xmm11
; AVX1-NEXT:    vpblendw {{.*#+}} xmm10 = xmm10[0,1,2,3,4],xmm11[5,6,7]
; AVX1-NEXT:    vpshufb {{.*#+}} xmm1 = xmm1[5,11],zero,zero,zero,xmm1[u,u,u,u,u,u,u,u,u,u,u]
; AVX1-NEXT:    vpshufb {{.*#+}} xmm2 = zero,zero,xmm2[1,7,13,u,u,u,u,u,u,u,u,u,u,u]
; AVX1-NEXT:    vpor %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vpshufb {{.*#+}} xmm2 = xmm3[u,u,u,u,u,u,u,u,5,11,u,u,u,u,u,u]
; AVX1-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[u,u,u,u,u,u,u,u,u,u,u,u,u,3,9,15]
; AVX1-NEXT:    vpunpckhqdq {{.*#+}} xmm0 = xmm0[1],xmm2[1]
; AVX1-NEXT:    vpblendvb %xmm12, %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb {{.*#+}} xmm1 = xmm4[u,u,u,u,u,u,u,u,u,u],zero,zero,zero,xmm4[3,9,15]
; AVX1-NEXT:    vpshufb {{.*#+}} xmm2 = xmm5[u,u,u,u,u,u,u,u,u,u,1,7,13],zero,zero,zero
; AVX1-NEXT:    vpor %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0,1,2,3,4],xmm1[5,6,7]
; AVX1-NEXT:    vmovdqa %xmm6, (%rsi)
; AVX1-NEXT:    vmovdqa %xmm7, (%rdx)
; AVX1-NEXT:    vmovdqa %xmm8, (%rcx)
; AVX1-NEXT:    vmovdqa %xmm9, (%r8)
; AVX1-NEXT:    vmovdqa %xmm10, (%r9)
; AVX1-NEXT:    vmovdqa %xmm0, (%rax)
; AVX1-NEXT:    retq
;
; AVX2-LABEL: load_i8_stride6_vf16:
; AVX2:       # %bb.0:
; AVX2-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-NEXT:    vmovdqa (%rdi), %ymm3
; AVX2-NEXT:    vmovdqa 32(%rdi), %ymm4
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm0 = <255,255,u,u,0,0,255,255,u,u,0,0,255,255,u,u,0,0,255,255,u,u,0,0,255,255,u,u,0,0,255,255>
; AVX2-NEXT:    vpblendvb %ymm0, %ymm3, %ymm4, %ymm5
; AVX2-NEXT:    vpshufb {{.*#+}} xmm0 = xmm5[0,6,12],zero,zero,zero,xmm5[4,10],zero,zero,zero,xmm5[u,u,u,u,u]
; AVX2-NEXT:    vextracti128 $1, %ymm5, %xmm6
; AVX2-NEXT:    vpshufb {{.*#+}} xmm1 = zero,zero,zero,xmm6[2,8,14],zero,zero,xmm6[0,6,12,u,u,u,u,u]
; AVX2-NEXT:    vpor %xmm0, %xmm1, %xmm2
; AVX2-NEXT:    vmovdqa 80(%rdi), %xmm0
; AVX2-NEXT:    vpshufb {{.*#+}} xmm7 = xmm0[u,u,u,u,u,u,u,u,u,u,u],zero,zero,zero,xmm0[4,10]
; AVX2-NEXT:    vmovdqa 64(%rdi), %xmm1
; AVX2-NEXT:    vpshufb {{.*#+}} xmm8 = xmm1[u,u,u,u,u,u,u,u,u,u,u,2,8,14],zero,zero
; AVX2-NEXT:    vpor %xmm7, %xmm8, %xmm7
; AVX2-NEXT:    vmovdqa {{.*#+}} xmm8 = [255,255,255,255,255,255,255,255,255,255,255,0,0,0,0,0]
; AVX2-NEXT:    vpblendvb %xmm8, %xmm2, %xmm7, %xmm2
; AVX2-NEXT:    vpshufb {{.*#+}} xmm5 = xmm5[1,7,13],zero,zero,zero,xmm5[5,11],zero,zero,zero,xmm5[u,u,u,u,u]
; AVX2-NEXT:    vpshufb {{.*#+}} xmm6 = zero,zero,zero,xmm6[3,9,15],zero,zero,xmm6[1,7,13,u,u,u,u,u]
; AVX2-NEXT:    vpor %xmm5, %xmm6, %xmm5
; AVX2-NEXT:    vpshufb {{.*#+}} xmm6 = xmm0[u,u,u,u,u,u,u,u,u,u,u],zero,zero,zero,xmm0[5,11]
; AVX2-NEXT:    vpshufb {{.*#+}} xmm7 = xmm1[u,u,u,u,u,u,u,u,u,u,u,3,9,15],zero,zero
; AVX2-NEXT:    vpor %xmm6, %xmm7, %xmm6
; AVX2-NEXT:    vpblendvb %xmm8, %xmm5, %xmm6, %xmm5
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm6 = <255,255,0,0,u,u,255,255,0,0,u,u,255,255,0,0,u,u,255,255,0,0,u,u,255,255,0,0,u,u,255,255>
; AVX2-NEXT:    vpblendvb %ymm6, %ymm4, %ymm3, %ymm6
; AVX2-NEXT:    vextracti128 $1, %ymm6, %xmm7
; AVX2-NEXT:    vpshufb {{.*#+}} xmm9 = zero,zero,zero,xmm7[4,10],zero,zero,zero,xmm7[2,8,14,u,u,u,u,u]
; AVX2-NEXT:    vpshufb {{.*#+}} xmm10 = xmm6[2,8,14],zero,zero,xmm6[0,6,12],zero,zero,zero,xmm6[u,u,u,u,u]
; AVX2-NEXT:    vpor %xmm9, %xmm10, %xmm9
; AVX2-NEXT:    vpshufb {{.*#+}} xmm10 = xmm1[u,u,u,u,u,u,u,u,u,u,u,4,10],zero,zero,zero
; AVX2-NEXT:    vpshufb {{.*#+}} xmm11 = xmm0[u,u,u,u,u,u,u,u,u,u,u],zero,zero,xmm0[0,6,12]
; AVX2-NEXT:    vpor %xmm10, %xmm11, %xmm10
; AVX2-NEXT:    vpblendvb %xmm8, %xmm9, %xmm10, %xmm9
; AVX2-NEXT:    vpshufb {{.*#+}} xmm7 = zero,zero,zero,xmm7[5,11],zero,zero,zero,xmm7[3,9,15,u,u,u,u,u]
; AVX2-NEXT:    vpshufb {{.*#+}} xmm6 = xmm6[3,9,15],zero,zero,xmm6[1,7,13],zero,zero,zero,xmm6[u,u,u,u,u]
; AVX2-NEXT:    vpor %xmm7, %xmm6, %xmm6
; AVX2-NEXT:    vpshufb {{.*#+}} xmm7 = xmm1[u,u,u,u,u,u,u,u,u,u,u,5,11],zero,zero,zero
; AVX2-NEXT:    vpshufb {{.*#+}} xmm10 = xmm0[u,u,u,u,u,u,u,u,u,u,u],zero,zero,xmm0[1,7,13]
; AVX2-NEXT:    vpor %xmm7, %xmm10, %xmm7
; AVX2-NEXT:    vpblendvb %xmm8, %xmm6, %xmm7, %xmm6
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm7 = <u,u,255,255,0,0,u,u,255,255,0,0,u,u,255,255,0,0,u,u,255,255,0,0,u,u,255,255,0,0,u,u>
; AVX2-NEXT:    vpblendvb %ymm7, %ymm4, %ymm3, %ymm3
; AVX2-NEXT:    vextracti128 $1, %ymm3, %xmm4
; AVX2-NEXT:    vpshufb {{.*#+}} xmm7 = zero,zero,xmm4[0,6,12],zero,zero,zero,xmm4[4,10,u,u,u,u,u,u]
; AVX2-NEXT:    vpshufb {{.*#+}} xmm8 = xmm3[4,10],zero,zero,zero,xmm3[2,8,14],zero,zero,xmm3[u,u,u,u,u,u]
; AVX2-NEXT:    vpor %xmm7, %xmm8, %xmm7
; AVX2-NEXT:    vpshufb {{.*#+}} xmm8 = xmm0[u,u,u,u,u,u,u,u,u,u],zero,zero,zero,xmm0[2,8,14]
; AVX2-NEXT:    vpshufb {{.*#+}} xmm10 = xmm1[u,u,u,u,u,u,u,u,u,u,0,6,12],zero,zero,zero
; AVX2-NEXT:    vpor %xmm8, %xmm10, %xmm8
; AVX2-NEXT:    vpblendw {{.*#+}} xmm7 = xmm7[0,1,2,3,4],xmm8[5,6,7]
; AVX2-NEXT:    vpshufb {{.*#+}} xmm4 = zero,zero,xmm4[1,7,13],zero,zero,zero,xmm4[5,11,u,u,u,u,u,u]
; AVX2-NEXT:    vpshufb {{.*#+}} xmm3 = xmm3[5,11],zero,zero,zero,xmm3[3,9,15],zero,zero,xmm3[u,u,u,u,u,u]
; AVX2-NEXT:    vpor %xmm4, %xmm3, %xmm3
; AVX2-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[u,u,u,u,u,u,u,u,u,u],zero,zero,zero,xmm0[3,9,15]
; AVX2-NEXT:    vpshufb {{.*#+}} xmm1 = xmm1[u,u,u,u,u,u,u,u,u,u,1,7,13],zero,zero,zero
; AVX2-NEXT:    vpor %xmm0, %xmm1, %xmm0
; AVX2-NEXT:    vpblendw {{.*#+}} xmm0 = xmm3[0,1,2,3,4],xmm0[5,6,7]
; AVX2-NEXT:    vmovdqa %xmm2, (%rsi)
; AVX2-NEXT:    vmovdqa %xmm5, (%rdx)
; AVX2-NEXT:    vmovdqa %xmm9, (%rcx)
; AVX2-NEXT:    vmovdqa %xmm6, (%r8)
; AVX2-NEXT:    vmovdqa %xmm7, (%r9)
; AVX2-NEXT:    vmovdqa %xmm0, (%rax)
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: load_i8_stride6_vf16:
; AVX512:       # %bb.0:
; AVX512-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512-NEXT:    vmovdqa (%rdi), %xmm5
; AVX512-NEXT:    vmovdqa 16(%rdi), %xmm2
; AVX512-NEXT:    vmovdqa 32(%rdi), %xmm1
; AVX512-NEXT:    vmovdqa 48(%rdi), %xmm0
; AVX512-NEXT:    vpextrb $2, %xmm2, %r10d
; AVX512-NEXT:    vpshufb {{.*#+}} xmm3 = xmm5[0,6,12],zero,xmm5[u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512-NEXT:    vpinsrb $3, %r10d, %xmm3, %xmm3
; AVX512-NEXT:    vpextrb $8, %xmm2, %r10d
; AVX512-NEXT:    vpinsrb $4, %r10d, %xmm3, %xmm3
; AVX512-NEXT:    vpextrb $14, %xmm2, %r10d
; AVX512-NEXT:    vpinsrb $5, %r10d, %xmm3, %xmm3
; AVX512-NEXT:    vpextrb $4, %xmm1, %r10d
; AVX512-NEXT:    vpinsrb $6, %r10d, %xmm3, %xmm3
; AVX512-NEXT:    vpextrb $10, %xmm1, %r10d
; AVX512-NEXT:    vpinsrb $7, %r10d, %xmm3, %xmm3
; AVX512-NEXT:    vmovd %xmm0, %r10d
; AVX512-NEXT:    vpinsrb $8, %r10d, %xmm3, %xmm3
; AVX512-NEXT:    vpextrb $6, %xmm0, %r10d
; AVX512-NEXT:    vpinsrb $9, %r10d, %xmm3, %xmm3
; AVX512-NEXT:    vpextrb $12, %xmm0, %r10d
; AVX512-NEXT:    vpinsrb $10, %r10d, %xmm3, %xmm4
; AVX512-NEXT:    vmovdqa 64(%rdi), %xmm3
; AVX512-NEXT:    vpextrb $2, %xmm3, %r10d
; AVX512-NEXT:    vpinsrb $11, %r10d, %xmm4, %xmm4
; AVX512-NEXT:    vpextrb $8, %xmm3, %r10d
; AVX512-NEXT:    vpinsrb $12, %r10d, %xmm4, %xmm4
; AVX512-NEXT:    vpextrb $14, %xmm3, %r10d
; AVX512-NEXT:    vpinsrb $13, %r10d, %xmm4, %xmm6
; AVX512-NEXT:    vmovdqa 80(%rdi), %xmm4
; AVX512-NEXT:    vpextrb $4, %xmm4, %edi
; AVX512-NEXT:    vpinsrb $14, %edi, %xmm6, %xmm6
; AVX512-NEXT:    vpextrb $10, %xmm4, %edi
; AVX512-NEXT:    vpinsrb $15, %edi, %xmm6, %xmm6
; AVX512-NEXT:    vpextrb $3, %xmm2, %edi
; AVX512-NEXT:    vpshufb {{.*#+}} xmm7 = xmm5[1,7,13],zero,xmm5[u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512-NEXT:    vpinsrb $3, %edi, %xmm7, %xmm7
; AVX512-NEXT:    vpextrb $9, %xmm2, %edi
; AVX512-NEXT:    vpinsrb $4, %edi, %xmm7, %xmm7
; AVX512-NEXT:    vpextrb $15, %xmm2, %edi
; AVX512-NEXT:    vpinsrb $5, %edi, %xmm7, %xmm7
; AVX512-NEXT:    vpextrb $5, %xmm1, %edi
; AVX512-NEXT:    vpinsrb $6, %edi, %xmm7, %xmm7
; AVX512-NEXT:    vpextrb $11, %xmm1, %edi
; AVX512-NEXT:    vpinsrb $7, %edi, %xmm7, %xmm7
; AVX512-NEXT:    vpextrb $1, %xmm0, %edi
; AVX512-NEXT:    vpinsrb $8, %edi, %xmm7, %xmm7
; AVX512-NEXT:    vpextrb $7, %xmm0, %edi
; AVX512-NEXT:    vpinsrb $9, %edi, %xmm7, %xmm7
; AVX512-NEXT:    vpextrb $13, %xmm0, %edi
; AVX512-NEXT:    vpinsrb $10, %edi, %xmm7, %xmm7
; AVX512-NEXT:    vpextrb $3, %xmm3, %edi
; AVX512-NEXT:    vpinsrb $11, %edi, %xmm7, %xmm7
; AVX512-NEXT:    vpextrb $9, %xmm3, %edi
; AVX512-NEXT:    vpinsrb $12, %edi, %xmm7, %xmm7
; AVX512-NEXT:    vpextrb $15, %xmm3, %edi
; AVX512-NEXT:    vpinsrb $13, %edi, %xmm7, %xmm7
; AVX512-NEXT:    vpextrb $5, %xmm4, %edi
; AVX512-NEXT:    vpinsrb $14, %edi, %xmm7, %xmm7
; AVX512-NEXT:    vpextrb $11, %xmm4, %edi
; AVX512-NEXT:    vpinsrb $15, %edi, %xmm7, %xmm7
; AVX512-NEXT:    vpextrb $4, %xmm2, %edi
; AVX512-NEXT:    vpshufb {{.*#+}} xmm8 = xmm5[2,8,14],zero,xmm5[u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512-NEXT:    vpinsrb $3, %edi, %xmm8, %xmm8
; AVX512-NEXT:    vpextrb $10, %xmm2, %edi
; AVX512-NEXT:    vpinsrb $4, %edi, %xmm8, %xmm8
; AVX512-NEXT:    vmovd %xmm1, %edi
; AVX512-NEXT:    vpinsrb $5, %edi, %xmm8, %xmm8
; AVX512-NEXT:    vpextrb $6, %xmm1, %edi
; AVX512-NEXT:    vpinsrb $6, %edi, %xmm8, %xmm8
; AVX512-NEXT:    vpextrb $12, %xmm1, %edi
; AVX512-NEXT:    vpinsrb $7, %edi, %xmm8, %xmm8
; AVX512-NEXT:    vpextrb $2, %xmm0, %edi
; AVX512-NEXT:    vpinsrb $8, %edi, %xmm8, %xmm8
; AVX512-NEXT:    vpextrb $8, %xmm0, %edi
; AVX512-NEXT:    vpinsrb $9, %edi, %xmm8, %xmm8
; AVX512-NEXT:    vpextrb $14, %xmm0, %edi
; AVX512-NEXT:    vpinsrb $10, %edi, %xmm8, %xmm8
; AVX512-NEXT:    vpextrb $4, %xmm3, %edi
; AVX512-NEXT:    vpinsrb $11, %edi, %xmm8, %xmm8
; AVX512-NEXT:    vpextrb $10, %xmm3, %edi
; AVX512-NEXT:    vpinsrb $12, %edi, %xmm8, %xmm8
; AVX512-NEXT:    vmovd %xmm4, %edi
; AVX512-NEXT:    vpinsrb $13, %edi, %xmm8, %xmm8
; AVX512-NEXT:    vpextrb $6, %xmm4, %edi
; AVX512-NEXT:    vpinsrb $14, %edi, %xmm8, %xmm8
; AVX512-NEXT:    vpextrb $12, %xmm4, %edi
; AVX512-NEXT:    vpinsrb $15, %edi, %xmm8, %xmm8
; AVX512-NEXT:    vpextrb $5, %xmm2, %edi
; AVX512-NEXT:    vpshufb {{.*#+}} xmm9 = xmm5[3,9,15],zero,xmm5[u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512-NEXT:    vpinsrb $3, %edi, %xmm9, %xmm9
; AVX512-NEXT:    vpextrb $11, %xmm2, %edi
; AVX512-NEXT:    vpinsrb $4, %edi, %xmm9, %xmm9
; AVX512-NEXT:    vpextrb $1, %xmm1, %edi
; AVX512-NEXT:    vpinsrb $5, %edi, %xmm9, %xmm9
; AVX512-NEXT:    vpextrb $7, %xmm1, %edi
; AVX512-NEXT:    vpinsrb $6, %edi, %xmm9, %xmm9
; AVX512-NEXT:    vpextrb $13, %xmm1, %edi
; AVX512-NEXT:    vpinsrb $7, %edi, %xmm9, %xmm9
; AVX512-NEXT:    vpextrb $3, %xmm0, %edi
; AVX512-NEXT:    vpinsrb $8, %edi, %xmm9, %xmm9
; AVX512-NEXT:    vpextrb $9, %xmm0, %edi
; AVX512-NEXT:    vpinsrb $9, %edi, %xmm9, %xmm9
; AVX512-NEXT:    vpextrb $15, %xmm0, %edi
; AVX512-NEXT:    vpinsrb $10, %edi, %xmm9, %xmm9
; AVX512-NEXT:    vpextrb $5, %xmm3, %edi
; AVX512-NEXT:    vpinsrb $11, %edi, %xmm9, %xmm9
; AVX512-NEXT:    vpextrb $11, %xmm3, %edi
; AVX512-NEXT:    vpinsrb $12, %edi, %xmm9, %xmm9
; AVX512-NEXT:    vpextrb $1, %xmm4, %edi
; AVX512-NEXT:    vpinsrb $13, %edi, %xmm9, %xmm9
; AVX512-NEXT:    vpextrb $7, %xmm4, %edi
; AVX512-NEXT:    vpinsrb $14, %edi, %xmm9, %xmm9
; AVX512-NEXT:    vpextrb $13, %xmm4, %edi
; AVX512-NEXT:    vpinsrb $15, %edi, %xmm9, %xmm9
; AVX512-NEXT:    vpextrb $10, %xmm5, %edi
; AVX512-NEXT:    vpextrb $4, %xmm5, %r10d
; AVX512-NEXT:    vmovd %r10d, %xmm10
; AVX512-NEXT:    vpinsrb $1, %edi, %xmm10, %xmm10
; AVX512-NEXT:    vmovd %xmm2, %edi
; AVX512-NEXT:    vpinsrb $2, %edi, %xmm10, %xmm10
; AVX512-NEXT:    vpextrb $6, %xmm2, %edi
; AVX512-NEXT:    vpinsrb $3, %edi, %xmm10, %xmm10
; AVX512-NEXT:    vpextrb $12, %xmm2, %edi
; AVX512-NEXT:    vpinsrb $4, %edi, %xmm10, %xmm10
; AVX512-NEXT:    vpextrb $2, %xmm1, %edi
; AVX512-NEXT:    vpinsrb $5, %edi, %xmm10, %xmm10
; AVX512-NEXT:    vpextrb $8, %xmm1, %edi
; AVX512-NEXT:    vpinsrb $6, %edi, %xmm10, %xmm10
; AVX512-NEXT:    vpextrb $14, %xmm1, %edi
; AVX512-NEXT:    vpinsrb $7, %edi, %xmm10, %xmm10
; AVX512-NEXT:    vpextrb $4, %xmm0, %edi
; AVX512-NEXT:    vpinsrb $8, %edi, %xmm10, %xmm10
; AVX512-NEXT:    vpextrb $10, %xmm0, %edi
; AVX512-NEXT:    vpinsrb $9, %edi, %xmm10, %xmm10
; AVX512-NEXT:    vmovd %xmm3, %edi
; AVX512-NEXT:    vpinsrb $10, %edi, %xmm10, %xmm10
; AVX512-NEXT:    vpextrb $6, %xmm3, %edi
; AVX512-NEXT:    vpinsrb $11, %edi, %xmm10, %xmm10
; AVX512-NEXT:    vpextrb $12, %xmm3, %edi
; AVX512-NEXT:    vpinsrb $12, %edi, %xmm10, %xmm10
; AVX512-NEXT:    vpextrb $2, %xmm4, %edi
; AVX512-NEXT:    vpinsrb $13, %edi, %xmm10, %xmm10
; AVX512-NEXT:    vpextrb $8, %xmm4, %edi
; AVX512-NEXT:    vpinsrb $14, %edi, %xmm10, %xmm10
; AVX512-NEXT:    vpextrb $14, %xmm4, %edi
; AVX512-NEXT:    vpinsrb $15, %edi, %xmm10, %xmm10
; AVX512-NEXT:    vpextrb $11, %xmm5, %edi
; AVX512-NEXT:    vpextrb $5, %xmm5, %r10d
; AVX512-NEXT:    vmovd %r10d, %xmm5
; AVX512-NEXT:    vpinsrb $1, %edi, %xmm5, %xmm5
; AVX512-NEXT:    vpextrb $1, %xmm2, %edi
; AVX512-NEXT:    vpinsrb $2, %edi, %xmm5, %xmm5
; AVX512-NEXT:    vpextrb $7, %xmm2, %edi
; AVX512-NEXT:    vpinsrb $3, %edi, %xmm5, %xmm5
; AVX512-NEXT:    vpextrb $13, %xmm2, %edi
; AVX512-NEXT:    vpinsrb $4, %edi, %xmm5, %xmm2
; AVX512-NEXT:    vpextrb $3, %xmm1, %edi
; AVX512-NEXT:    vpinsrb $5, %edi, %xmm2, %xmm2
; AVX512-NEXT:    vpextrb $9, %xmm1, %edi
; AVX512-NEXT:    vpinsrb $6, %edi, %xmm2, %xmm2
; AVX512-NEXT:    vpextrb $15, %xmm1, %edi
; AVX512-NEXT:    vpinsrb $7, %edi, %xmm2, %xmm1
; AVX512-NEXT:    vpextrb $5, %xmm0, %edi
; AVX512-NEXT:    vpinsrb $8, %edi, %xmm1, %xmm1
; AVX512-NEXT:    vpextrb $11, %xmm0, %edi
; AVX512-NEXT:    vpinsrb $9, %edi, %xmm1, %xmm0
; AVX512-NEXT:    vpextrb $1, %xmm3, %edi
; AVX512-NEXT:    vpinsrb $10, %edi, %xmm0, %xmm0
; AVX512-NEXT:    vpextrb $7, %xmm3, %edi
; AVX512-NEXT:    vpinsrb $11, %edi, %xmm0, %xmm0
; AVX512-NEXT:    vpextrb $13, %xmm3, %edi
; AVX512-NEXT:    vpinsrb $12, %edi, %xmm0, %xmm0
; AVX512-NEXT:    vpextrb $3, %xmm4, %edi
; AVX512-NEXT:    vpinsrb $13, %edi, %xmm0, %xmm0
; AVX512-NEXT:    vpextrb $9, %xmm4, %edi
; AVX512-NEXT:    vpinsrb $14, %edi, %xmm0, %xmm0
; AVX512-NEXT:    vpextrb $15, %xmm4, %edi
; AVX512-NEXT:    vpinsrb $15, %edi, %xmm0, %xmm0
; AVX512-NEXT:    vmovdqa %xmm6, (%rsi)
; AVX512-NEXT:    vmovdqa %xmm7, (%rdx)
; AVX512-NEXT:    vmovdqa %xmm8, (%rcx)
; AVX512-NEXT:    vmovdqa %xmm9, (%r8)
; AVX512-NEXT:    vmovdqa %xmm10, (%r9)
; AVX512-NEXT:    vmovdqa %xmm0, (%rax)
; AVX512-NEXT:    retq
  %wide.vec = load <96 x i8>, ptr %in.vec, align 32

  %strided.vec0 = shufflevector <96 x i8> %wide.vec, <96 x i8> poison, <16 x i32> <i32 0, i32 6, i32 12, i32 18, i32 24, i32 30, i32 36, i32 42, i32 48, i32 54, i32 60, i32 66, i32 72, i32 78, i32 84, i32 90>
  %strided.vec1 = shufflevector <96 x i8> %wide.vec, <96 x i8> poison, <16 x i32> <i32 1, i32 7, i32 13, i32 19, i32 25, i32 31, i32 37, i32 43, i32 49, i32 55, i32 61, i32 67, i32 73, i32 79, i32 85, i32 91>
  %strided.vec2 = shufflevector <96 x i8> %wide.vec, <96 x i8> poison, <16 x i32> <i32 2, i32 8, i32 14, i32 20, i32 26, i32 32, i32 38, i32 44, i32 50, i32 56, i32 62, i32 68, i32 74, i32 80, i32 86, i32 92>
  %strided.vec3 = shufflevector <96 x i8> %wide.vec, <96 x i8> poison, <16 x i32> <i32 3, i32 9, i32 15, i32 21, i32 27, i32 33, i32 39, i32 45, i32 51, i32 57, i32 63, i32 69, i32 75, i32 81, i32 87, i32 93>
  %strided.vec4 = shufflevector <96 x i8> %wide.vec, <96 x i8> poison, <16 x i32> <i32 4, i32 10, i32 16, i32 22, i32 28, i32 34, i32 40, i32 46, i32 52, i32 58, i32 64, i32 70, i32 76, i32 82, i32 88, i32 94>
  %strided.vec5 = shufflevector <96 x i8> %wide.vec, <96 x i8> poison, <16 x i32> <i32 5, i32 11, i32 17, i32 23, i32 29, i32 35, i32 41, i32 47, i32 53, i32 59, i32 65, i32 71, i32 77, i32 83, i32 89, i32 95>

  store <16 x i8> %strided.vec0, ptr %out.vec0, align 32
  store <16 x i8> %strided.vec1, ptr %out.vec1, align 32
  store <16 x i8> %strided.vec2, ptr %out.vec2, align 32
  store <16 x i8> %strided.vec3, ptr %out.vec3, align 32
  store <16 x i8> %strided.vec4, ptr %out.vec4, align 32
  store <16 x i8> %strided.vec5, ptr %out.vec5, align 32

  ret void
}

define void @load_i8_stride6_vf32(ptr %in.vec, ptr %out.vec0, ptr %out.vec1, ptr %out.vec2, ptr %out.vec3, ptr %out.vec4, ptr %out.vec5) nounwind {
; SSE-LABEL: load_i8_stride6_vf32:
; SSE:       # %bb.0:
; SSE-NEXT:    subq $280, %rsp # imm = 0x118
; SSE-NEXT:    movdqa 64(%rdi), %xmm8
; SSE-NEXT:    movdqa %xmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 80(%rdi), %xmm6
; SSE-NEXT:    movdqa (%rdi), %xmm15
; SSE-NEXT:    movdqa 16(%rdi), %xmm13
; SSE-NEXT:    movdqa 32(%rdi), %xmm1
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 48(%rdi), %xmm7
; SSE-NEXT:    movdqa {{.*#+}} xmm5 = [65535,65535,0,65535,65535,0,65535,65535]
; SSE-NEXT:    movdqa %xmm5, %xmm0
; SSE-NEXT:    pandn %xmm1, %xmm0
; SSE-NEXT:    movdqa {{.*#+}} xmm10 = [65535,0,65535,65535,0,65535,65535,0]
; SSE-NEXT:    movdqa %xmm10, %xmm1
; SSE-NEXT:    pandn %xmm7, %xmm1
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm5, %xmm1
; SSE-NEXT:    pandn %xmm7, %xmm1
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm7, %xmm14
; SSE-NEXT:    pand %xmm5, %xmm14
; SSE-NEXT:    por %xmm0, %xmm14
; SSE-NEXT:    movdqa {{.*#+}} xmm11 = [255,255,255,255,255,255,255,255]
; SSE-NEXT:    movdqa %xmm14, %xmm0
; SSE-NEXT:    pand %xmm11, %xmm0
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm0[0,3,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,3,2,3]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,1,2,1]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,4,5,6,5]
; SSE-NEXT:    packuswb %xmm1, %xmm0
; SSE-NEXT:    movdqa {{.*#+}} xmm9 = [65535,65535,65535,0,0,0,65535,65535]
; SSE-NEXT:    movdqa %xmm10, %xmm1
; SSE-NEXT:    pandn %xmm13, %xmm1
; SSE-NEXT:    movdqa %xmm15, %xmm12
; SSE-NEXT:    pand %xmm10, %xmm12
; SSE-NEXT:    por %xmm1, %xmm12
; SSE-NEXT:    movdqa %xmm12, %xmm1
; SSE-NEXT:    pand %xmm11, %xmm1
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,2,1,3]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,6,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,2,1,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[0,3,2,1,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,4,7,6,7]
; SSE-NEXT:    packuswb %xmm1, %xmm1
; SSE-NEXT:    pand %xmm9, %xmm1
; SSE-NEXT:    movdqa %xmm9, %xmm2
; SSE-NEXT:    pandn %xmm0, %xmm2
; SSE-NEXT:    por %xmm2, %xmm1
; SSE-NEXT:    movdqa %xmm5, %xmm0
; SSE-NEXT:    pandn %xmm6, %xmm0
; SSE-NEXT:    pand %xmm5, %xmm8
; SSE-NEXT:    por %xmm0, %xmm8
; SSE-NEXT:    movdqa %xmm8, %xmm0
; SSE-NEXT:    pand %xmm11, %xmm0
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[3,1,2,0]
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[2,1,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,3,2,0]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,4,7,6,5]
; SSE-NEXT:    packuswb %xmm0, %xmm0
; SSE-NEXT:    movdqa {{.*#+}} xmm3 = [255,255,255,255,255,255,255,255,255,255,255,0,0,0,0,0]
; SSE-NEXT:    movdqa %xmm3, %xmm2
; SSE-NEXT:    pandn %xmm0, %xmm2
; SSE-NEXT:    pand %xmm3, %xmm1
; SSE-NEXT:    por %xmm1, %xmm2
; SSE-NEXT:    movdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 128(%rdi), %xmm1
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm5, %xmm0
; SSE-NEXT:    pandn %xmm1, %xmm0
; SSE-NEXT:    movdqa 144(%rdi), %xmm3
; SSE-NEXT:    movdqa %xmm10, %xmm2
; SSE-NEXT:    pandn %xmm3, %xmm2
; SSE-NEXT:    movdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm5, %xmm2
; SSE-NEXT:    pandn %xmm3, %xmm2
; SSE-NEXT:    movdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pand %xmm5, %xmm3
; SSE-NEXT:    por %xmm0, %xmm3
; SSE-NEXT:    movdqa %xmm3, %xmm0
; SSE-NEXT:    pand %xmm11, %xmm0
; SSE-NEXT:    pshuflw {{.*#+}} xmm2 = xmm0[0,3,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,3,2,3]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,1,2,1]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,4,5,6,5]
; SSE-NEXT:    packuswb %xmm2, %xmm0
; SSE-NEXT:    pandn %xmm0, %xmm9
; SSE-NEXT:    movdqa %xmm5, %xmm1
; SSE-NEXT:    movdqa %xmm5, %xmm0
; SSE-NEXT:    pandn %xmm15, %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 112(%rdi), %xmm0
; SSE-NEXT:    movdqa %xmm10, %xmm7
; SSE-NEXT:    pandn %xmm0, %xmm7
; SSE-NEXT:    movdqa 160(%rdi), %xmm4
; SSE-NEXT:    movdqa %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pand %xmm5, %xmm4
; SSE-NEXT:    movdqa %xmm13, %xmm2
; SSE-NEXT:    pandn %xmm13, %xmm5
; SSE-NEXT:    movdqa %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pand %xmm1, %xmm15
; SSE-NEXT:    movdqa %xmm10, %xmm5
; SSE-NEXT:    pandn %xmm6, %xmm5
; SSE-NEXT:    movdqa %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pand %xmm1, %xmm6
; SSE-NEXT:    movdqa %xmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm1, %xmm5
; SSE-NEXT:    pandn %xmm0, %xmm5
; SSE-NEXT:    movdqa %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm0, %xmm5
; SSE-NEXT:    movdqa 96(%rdi), %xmm0
; SSE-NEXT:    movdqa %xmm0, %xmm6
; SSE-NEXT:    pand %xmm1, %xmm6
; SSE-NEXT:    movdqa %xmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 176(%rdi), %xmm13
; SSE-NEXT:    movdqa %xmm13, %xmm10
; SSE-NEXT:    movdqa %xmm13, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pand %xmm1, %xmm10
; SSE-NEXT:    movdqa %xmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm10 # 16-byte Reload
; SSE-NEXT:    movdqa %xmm10, %xmm6
; SSE-NEXT:    pand %xmm1, %xmm10
; SSE-NEXT:    movdqa %xmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pand %xmm1, %xmm2
; SSE-NEXT:    movdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    movdqa %xmm2, %xmm10
; SSE-NEXT:    pand %xmm1, %xmm2
; SSE-NEXT:    movdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pand %xmm1, %xmm5
; SSE-NEXT:    movdqa %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm1, %xmm2
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm1, (%rsp) # 16-byte Spill
; SSE-NEXT:    pandn %xmm0, %xmm1
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; SSE-NEXT:    por %xmm7, %xmm0
; SSE-NEXT:    movdqa %xmm0, %xmm5
; SSE-NEXT:    pand %xmm11, %xmm5
; SSE-NEXT:    pshufd {{.*#+}} xmm5 = xmm5[0,2,1,3]
; SSE-NEXT:    pshufhw {{.*#+}} xmm5 = xmm5[0,1,2,3,6,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm5 = xmm5[0,2,1,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm5 = xmm5[0,3,2,1,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm5 = xmm5[0,1,2,3,4,7,6,7]
; SSE-NEXT:    packuswb %xmm5, %xmm5
; SSE-NEXT:    pand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm5
; SSE-NEXT:    por %xmm9, %xmm5
; SSE-NEXT:    pandn %xmm13, %xmm2
; SSE-NEXT:    por %xmm2, %xmm4
; SSE-NEXT:    movdqa %xmm4, %xmm2
; SSE-NEXT:    pand %xmm11, %xmm2
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[3,1,2,0]
; SSE-NEXT:    pshuflw {{.*#+}} xmm2 = xmm2[2,1,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,3,2,0]
; SSE-NEXT:    pshufhw {{.*#+}} xmm2 = xmm2[0,1,2,3,4,7,6,5]
; SSE-NEXT:    packuswb %xmm2, %xmm2
; SSE-NEXT:    movdqa {{.*#+}} xmm9 = [255,255,255,255,255,255,255,255,255,255,255,0,0,0,0,0]
; SSE-NEXT:    movdqa %xmm9, %xmm1
; SSE-NEXT:    pandn %xmm2, %xmm1
; SSE-NEXT:    pand %xmm9, %xmm5
; SSE-NEXT:    por %xmm5, %xmm1
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pxor %xmm2, %xmm2
; SSE-NEXT:    movdqa %xmm14, %xmm5
; SSE-NEXT:    punpckhbw {{.*#+}} xmm5 = xmm5[8],xmm2[8],xmm5[9],xmm2[9],xmm5[10],xmm2[10],xmm5[11],xmm2[11],xmm5[12],xmm2[12],xmm5[13],xmm2[13],xmm5[14],xmm2[14],xmm5[15],xmm2[15]
; SSE-NEXT:    punpcklbw {{.*#+}} xmm14 = xmm14[0],xmm2[0],xmm14[1],xmm2[1],xmm14[2],xmm2[2],xmm14[3],xmm2[3],xmm14[4],xmm2[4],xmm14[5],xmm2[5],xmm14[6],xmm2[6],xmm14[7],xmm2[7]
; SSE-NEXT:    pshufd {{.*#+}} xmm7 = xmm14[2,2,3,3]
; SSE-NEXT:    punpcklwd {{.*#+}} xmm7 = xmm7[0],xmm5[0],xmm7[1],xmm5[1],xmm7[2],xmm5[2],xmm7[3],xmm5[3]
; SSE-NEXT:    psrld $16, %xmm5
; SSE-NEXT:    pshufd {{.*#+}} xmm14 = xmm14[0,1,0,3]
; SSE-NEXT:    pshufhw {{.*#+}} xmm14 = xmm14[0,1,2,3,5,7,6,7]
; SSE-NEXT:    punpckhdq {{.*#+}} xmm14 = xmm14[2],xmm5[2],xmm14[3],xmm5[3]
; SSE-NEXT:    packuswb %xmm14, %xmm7
; SSE-NEXT:    movdqa {{.*#+}} xmm13 = [65535,65535,65535,0,0,0,65535,65535]
; SSE-NEXT:    movdqa %xmm13, %xmm5
; SSE-NEXT:    pandn %xmm7, %xmm5
; SSE-NEXT:    movdqa %xmm12, %xmm7
; SSE-NEXT:    punpckhbw {{.*#+}} xmm7 = xmm7[8],xmm2[8],xmm7[9],xmm2[9],xmm7[10],xmm2[10],xmm7[11],xmm2[11],xmm7[12],xmm2[12],xmm7[13],xmm2[13],xmm7[14],xmm2[14],xmm7[15],xmm2[15]
; SSE-NEXT:    pshufd {{.*#+}} xmm7 = xmm7[2,1,0,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm7 = xmm7[1,1,1,1,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm7 = xmm7[0,1,2,3,5,7,6,7]
; SSE-NEXT:    movdqa {{.*#+}} xmm14 = [65535,65535,0,65535,0,0,65535,65535]
; SSE-NEXT:    movdqa %xmm14, %xmm1
; SSE-NEXT:    pandn %xmm7, %xmm1
; SSE-NEXT:    punpcklbw {{.*#+}} xmm12 = xmm12[0],xmm2[0],xmm12[1],xmm2[1],xmm12[2],xmm2[2],xmm12[3],xmm2[3],xmm12[4],xmm2[4],xmm12[5],xmm2[5],xmm12[6],xmm2[6],xmm12[7],xmm2[7]
; SSE-NEXT:    pshuflw {{.*#+}} xmm7 = xmm12[3,1,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm7 = xmm7[0,3,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm7 = xmm7[1,3,2,0,4,5,6,7]
; SSE-NEXT:    pand %xmm14, %xmm7
; SSE-NEXT:    por %xmm1, %xmm7
; SSE-NEXT:    packuswb %xmm7, %xmm7
; SSE-NEXT:    pand %xmm13, %xmm7
; SSE-NEXT:    por %xmm5, %xmm7
; SSE-NEXT:    movdqa %xmm8, %xmm1
; SSE-NEXT:    punpcklbw {{.*#+}} xmm1 = xmm1[0],xmm2[0],xmm1[1],xmm2[1],xmm1[2],xmm2[2],xmm1[3],xmm2[3],xmm1[4],xmm2[4],xmm1[5],xmm2[5],xmm1[6],xmm2[6],xmm1[7],xmm2[7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,5,5,5,5]
; SSE-NEXT:    movdqa {{.*#+}} xmm5 = [65535,65535,65535,0,65535,65535,0,65535]
; SSE-NEXT:    movdqa %xmm5, %xmm12
; SSE-NEXT:    pandn %xmm1, %xmm12
; SSE-NEXT:    punpckhbw {{.*#+}} xmm8 = xmm8[8],xmm2[8],xmm8[9],xmm2[9],xmm8[10],xmm2[10],xmm8[11],xmm2[11],xmm8[12],xmm2[12],xmm8[13],xmm2[13],xmm8[14],xmm2[14],xmm8[15],xmm2[15]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm8[3,1,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,1,0,3]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,5,7,6,4]
; SSE-NEXT:    pand %xmm5, %xmm1
; SSE-NEXT:    por %xmm12, %xmm1
; SSE-NEXT:    packuswb %xmm1, %xmm1
; SSE-NEXT:    movdqa %xmm9, %xmm8
; SSE-NEXT:    pandn %xmm1, %xmm8
; SSE-NEXT:    pand %xmm9, %xmm7
; SSE-NEXT:    por %xmm7, %xmm8
; SSE-NEXT:    movdqa %xmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm3, %xmm1
; SSE-NEXT:    punpckhbw {{.*#+}} xmm1 = xmm1[8],xmm2[8],xmm1[9],xmm2[9],xmm1[10],xmm2[10],xmm1[11],xmm2[11],xmm1[12],xmm2[12],xmm1[13],xmm2[13],xmm1[14],xmm2[14],xmm1[15],xmm2[15]
; SSE-NEXT:    punpcklbw {{.*#+}} xmm3 = xmm3[0],xmm2[0],xmm3[1],xmm2[1],xmm3[2],xmm2[2],xmm3[3],xmm2[3],xmm3[4],xmm2[4],xmm3[5],xmm2[5],xmm3[6],xmm2[6],xmm3[7],xmm2[7]
; SSE-NEXT:    pshufd {{.*#+}} xmm7 = xmm3[2,2,3,3]
; SSE-NEXT:    punpcklwd {{.*#+}} xmm7 = xmm7[0],xmm1[0],xmm7[1],xmm1[1],xmm7[2],xmm1[2],xmm7[3],xmm1[3]
; SSE-NEXT:    psrld $16, %xmm1
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[0,1,0,3]
; SSE-NEXT:    pshufhw {{.*#+}} xmm3 = xmm3[0,1,2,3,5,7,6,7]
; SSE-NEXT:    punpckhdq {{.*#+}} xmm3 = xmm3[2],xmm1[2],xmm3[3],xmm1[3]
; SSE-NEXT:    packuswb %xmm3, %xmm7
; SSE-NEXT:    movdqa %xmm0, %xmm1
; SSE-NEXT:    punpckhbw {{.*#+}} xmm1 = xmm1[8],xmm2[8],xmm1[9],xmm2[9],xmm1[10],xmm2[10],xmm1[11],xmm2[11],xmm1[12],xmm2[12],xmm1[13],xmm2[13],xmm1[14],xmm2[14],xmm1[15],xmm2[15]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[2,1,0,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[1,1,1,1,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,5,7,6,7]
; SSE-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0],xmm2[0],xmm0[1],xmm2[1],xmm0[2],xmm2[2],xmm0[3],xmm2[3],xmm0[4],xmm2[4],xmm0[5],xmm2[5],xmm0[6],xmm2[6],xmm0[7],xmm2[7]
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[3,1,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,3,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[1,3,2,0,4,5,6,7]
; SSE-NEXT:    pand %xmm14, %xmm0
; SSE-NEXT:    pandn %xmm1, %xmm14
; SSE-NEXT:    por %xmm0, %xmm14
; SSE-NEXT:    packuswb %xmm14, %xmm14
; SSE-NEXT:    movdqa %xmm13, %xmm0
; SSE-NEXT:    pand %xmm13, %xmm14
; SSE-NEXT:    pandn %xmm7, %xmm0
; SSE-NEXT:    por %xmm0, %xmm14
; SSE-NEXT:    movdqa %xmm4, %xmm0
; SSE-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0],xmm2[0],xmm0[1],xmm2[1],xmm0[2],xmm2[2],xmm0[3],xmm2[3],xmm0[4],xmm2[4],xmm0[5],xmm2[5],xmm0[6],xmm2[6],xmm0[7],xmm2[7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,5,5,5,5]
; SSE-NEXT:    punpckhbw {{.*#+}} xmm4 = xmm4[8],xmm2[8],xmm4[9],xmm2[9],xmm4[10],xmm2[10],xmm4[11],xmm2[11],xmm4[12],xmm2[12],xmm4[13],xmm2[13],xmm4[14],xmm2[14],xmm4[15],xmm2[15]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm4[3,1,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,1,0,3]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,5,7,6,4]
; SSE-NEXT:    pand %xmm5, %xmm1
; SSE-NEXT:    pandn %xmm0, %xmm5
; SSE-NEXT:    por %xmm1, %xmm5
; SSE-NEXT:    packuswb %xmm5, %xmm0
; SSE-NEXT:    movdqa %xmm9, %xmm1
; SSE-NEXT:    pandn %xmm0, %xmm1
; SSE-NEXT:    pand %xmm9, %xmm14
; SSE-NEXT:    por %xmm14, %xmm1
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa {{.*#+}} xmm4 = [65535,0,65535,65535,0,65535,65535,0]
; SSE-NEXT:    pand %xmm4, %xmm6
; SSE-NEXT:    por {{[-0-9]+}}(%r{{[sb]}}p), %xmm6 # 16-byte Folded Reload
; SSE-NEXT:    movdqa %xmm6, %xmm0
; SSE-NEXT:    pand %xmm11, %xmm0
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm0[0,1,2,3,4,7,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,2,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[1,2,3,3,4,5,6,7]
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[0,3,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,1,0,3]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,4,4,5,6]
; SSE-NEXT:    packuswb %xmm1, %xmm0
; SSE-NEXT:    por {{[-0-9]+}}(%r{{[sb]}}p), %xmm15 # 16-byte Folded Reload
; SSE-NEXT:    movdqa %xmm15, %xmm1
; SSE-NEXT:    pand %xmm11, %xmm1
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[2,1,2,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,4,5,4,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,3,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[1,2,3,0,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,5,5,5,5]
; SSE-NEXT:    packuswb %xmm1, %xmm1
; SSE-NEXT:    movdqa {{.*#+}} xmm13 = [0,0,0,0,0,255,255,255,255,255,255,255,255,255,255,255]
; SSE-NEXT:    movdqa %xmm13, %xmm3
; SSE-NEXT:    pandn %xmm1, %xmm3
; SSE-NEXT:    pand %xmm13, %xmm0
; SSE-NEXT:    por %xmm0, %xmm3
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    pandn {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm12 # 16-byte Reload
; SSE-NEXT:    por %xmm0, %xmm12
; SSE-NEXT:    movdqa %xmm12, %xmm0
; SSE-NEXT:    pand %xmm11, %xmm0
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[0,3,2,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,6,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,1,2,0]
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[2,2,2,2,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,5,6,7,4]
; SSE-NEXT:    packuswb %xmm0, %xmm0
; SSE-NEXT:    movdqa %xmm9, %xmm1
; SSE-NEXT:    pandn %xmm0, %xmm1
; SSE-NEXT:    pand %xmm9, %xmm3
; SSE-NEXT:    por %xmm3, %xmm1
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pand %xmm4, %xmm10
; SSE-NEXT:    por {{[-0-9]+}}(%r{{[sb]}}p), %xmm10 # 16-byte Folded Reload
; SSE-NEXT:    movdqa %xmm10, %xmm0
; SSE-NEXT:    pand %xmm11, %xmm0
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm0[0,1,2,3,4,7,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,2,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[1,2,3,3,4,5,6,7]
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[0,3,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,1,0,3]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,4,4,5,6]
; SSE-NEXT:    packuswb %xmm1, %xmm0
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm7 # 16-byte Reload
; SSE-NEXT:    por {{[-0-9]+}}(%r{{[sb]}}p), %xmm7 # 16-byte Folded Reload
; SSE-NEXT:    movdqa %xmm7, %xmm1
; SSE-NEXT:    pand %xmm11, %xmm1
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[2,1,2,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,4,5,4,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,3,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[1,2,3,0,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,5,5,5,5]
; SSE-NEXT:    packuswb %xmm1, %xmm1
; SSE-NEXT:    movdqa %xmm13, %xmm3
; SSE-NEXT:    pandn %xmm1, %xmm3
; SSE-NEXT:    pand %xmm13, %xmm0
; SSE-NEXT:    por %xmm0, %xmm3
; SSE-NEXT:    movdqa (%rsp), %xmm0 # 16-byte Reload
; SSE-NEXT:    pandn {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm8 # 16-byte Reload
; SSE-NEXT:    por %xmm0, %xmm8
; SSE-NEXT:    movdqa %xmm8, %xmm0
; SSE-NEXT:    pand %xmm11, %xmm0
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[0,3,2,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,6,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,1,2,0]
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[2,2,2,2,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,5,6,7,4]
; SSE-NEXT:    packuswb %xmm0, %xmm0
; SSE-NEXT:    movdqa %xmm9, %xmm14
; SSE-NEXT:    pandn %xmm0, %xmm14
; SSE-NEXT:    pand %xmm9, %xmm3
; SSE-NEXT:    por %xmm3, %xmm14
; SSE-NEXT:    movdqa %xmm6, %xmm0
; SSE-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0],xmm2[0],xmm0[1],xmm2[1],xmm0[2],xmm2[2],xmm0[3],xmm2[3],xmm0[4],xmm2[4],xmm0[5],xmm2[5],xmm0[6],xmm2[6],xmm0[7],xmm2[7]
; SSE-NEXT:    punpckhbw {{.*#+}} xmm6 = xmm6[8],xmm2[8],xmm6[9],xmm2[9],xmm6[10],xmm2[10],xmm6[11],xmm2[11],xmm6[12],xmm2[12],xmm6[13],xmm2[13],xmm6[14],xmm2[14],xmm6[15],xmm2[15]
; SSE-NEXT:    movdqa %xmm6, %xmm1
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[2,0],xmm0[3,0]
; SSE-NEXT:    movaps %xmm0, %xmm3
; SSE-NEXT:    shufps {{.*#+}} xmm3 = xmm3[0,1],xmm1[0,2]
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,0],xmm6[0,0]
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[2,0],xmm6[2,3]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm3[0,1,2,3,7,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,1,0,2]
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[3,1,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,3,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[0,1,3,3,4,5,6,7]
; SSE-NEXT:    packuswb %xmm0, %xmm1
; SSE-NEXT:    movdqa %xmm15, %xmm0
; SSE-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0],xmm2[0],xmm0[1],xmm2[1],xmm0[2],xmm2[2],xmm0[3],xmm2[3],xmm0[4],xmm2[4],xmm0[5],xmm2[5],xmm0[6],xmm2[6],xmm0[7],xmm2[7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[2,1,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[3,1,2,1,4,5,6,7]
; SSE-NEXT:    movdqa {{.*#+}} xmm3 = [0,65535,65535,0,65535,65535,65535,65535]
; SSE-NEXT:    movdqa %xmm3, %xmm4
; SSE-NEXT:    pandn %xmm0, %xmm4
; SSE-NEXT:    punpckhbw {{.*#+}} xmm15 = xmm15[8],xmm2[8],xmm15[9],xmm2[9],xmm15[10],xmm2[10],xmm15[11],xmm2[11],xmm15[12],xmm2[12],xmm15[13],xmm2[13],xmm15[14],xmm2[14],xmm15[15],xmm2[15]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm15[0,3,2,1]
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[0,1,3,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,7,7,7,7]
; SSE-NEXT:    pand %xmm3, %xmm0
; SSE-NEXT:    por %xmm4, %xmm0
; SSE-NEXT:    packuswb %xmm0, %xmm0
; SSE-NEXT:    movdqa %xmm13, %xmm4
; SSE-NEXT:    pandn %xmm0, %xmm4
; SSE-NEXT:    pand %xmm13, %xmm1
; SSE-NEXT:    por %xmm1, %xmm4
; SSE-NEXT:    movdqa %xmm12, %xmm0
; SSE-NEXT:    punpckhbw {{.*#+}} xmm0 = xmm0[8],xmm2[8],xmm0[9],xmm2[9],xmm0[10],xmm2[10],xmm0[11],xmm2[11],xmm0[12],xmm2[12],xmm0[13],xmm2[13],xmm0[14],xmm2[14],xmm0[15],xmm2[15]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,1,2,1]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,7,5,6,5]
; SSE-NEXT:    movdqa {{.*#+}} xmm5 = [65535,65535,65535,65535,0,65535,65535,0]
; SSE-NEXT:    movdqa %xmm5, %xmm1
; SSE-NEXT:    pandn %xmm0, %xmm1
; SSE-NEXT:    punpcklbw {{.*#+}} xmm12 = xmm12[0],xmm2[0],xmm12[1],xmm2[1],xmm12[2],xmm2[2],xmm12[3],xmm2[3],xmm12[4],xmm2[4],xmm12[5],xmm2[5],xmm12[6],xmm2[6],xmm12[7],xmm2[7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm12[0,2,0,3]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,4,5,7,7]
; SSE-NEXT:    pand %xmm5, %xmm0
; SSE-NEXT:    por %xmm1, %xmm0
; SSE-NEXT:    packuswb %xmm0, %xmm0
; SSE-NEXT:    movdqa %xmm9, %xmm12
; SSE-NEXT:    pandn %xmm0, %xmm12
; SSE-NEXT:    pand %xmm9, %xmm4
; SSE-NEXT:    por %xmm4, %xmm12
; SSE-NEXT:    movdqa %xmm10, %xmm0
; SSE-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0],xmm2[0],xmm0[1],xmm2[1],xmm0[2],xmm2[2],xmm0[3],xmm2[3],xmm0[4],xmm2[4],xmm0[5],xmm2[5],xmm0[6],xmm2[6],xmm0[7],xmm2[7]
; SSE-NEXT:    punpckhbw {{.*#+}} xmm10 = xmm10[8],xmm2[8],xmm10[9],xmm2[9],xmm10[10],xmm2[10],xmm10[11],xmm2[11],xmm10[12],xmm2[12],xmm10[13],xmm2[13],xmm10[14],xmm2[14],xmm10[15],xmm2[15]
; SSE-NEXT:    movdqa %xmm10, %xmm4
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[2,0],xmm0[3,0]
; SSE-NEXT:    movaps %xmm0, %xmm6
; SSE-NEXT:    shufps {{.*#+}} xmm6 = xmm6[0,1],xmm4[0,2]
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,0],xmm10[0,0]
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[2,0],xmm10[2,3]
; SSE-NEXT:    pshufhw {{.*#+}} xmm4 = xmm6[0,1,2,3,7,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[0,1,0,2]
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[3,1,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,3,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[0,1,3,3,4,5,6,7]
; SSE-NEXT:    packuswb %xmm0, %xmm4
; SSE-NEXT:    movdqa %xmm7, %xmm0
; SSE-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0],xmm2[0],xmm0[1],xmm2[1],xmm0[2],xmm2[2],xmm0[3],xmm2[3],xmm0[4],xmm2[4],xmm0[5],xmm2[5],xmm0[6],xmm2[6],xmm0[7],xmm2[7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[2,1,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[3,1,2,1,4,5,6,7]
; SSE-NEXT:    punpckhbw {{.*#+}} xmm7 = xmm7[8],xmm2[8],xmm7[9],xmm2[9],xmm7[10],xmm2[10],xmm7[11],xmm2[11],xmm7[12],xmm2[12],xmm7[13],xmm2[13],xmm7[14],xmm2[14],xmm7[15],xmm2[15]
; SSE-NEXT:    pshufd {{.*#+}} xmm6 = xmm7[0,3,2,1]
; SSE-NEXT:    pshuflw {{.*#+}} xmm6 = xmm6[0,1,3,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm6 = xmm6[0,1,2,3,7,7,7,7]
; SSE-NEXT:    pand %xmm3, %xmm6
; SSE-NEXT:    pandn %xmm0, %xmm3
; SSE-NEXT:    por %xmm6, %xmm3
; SSE-NEXT:    pand %xmm13, %xmm4
; SSE-NEXT:    packuswb %xmm3, %xmm3
; SSE-NEXT:    pandn %xmm3, %xmm13
; SSE-NEXT:    por %xmm4, %xmm13
; SSE-NEXT:    movdqa %xmm8, %xmm0
; SSE-NEXT:    punpckhbw {{.*#+}} xmm0 = xmm0[8],xmm2[8],xmm0[9],xmm2[9],xmm0[10],xmm2[10],xmm0[11],xmm2[11],xmm0[12],xmm2[12],xmm0[13],xmm2[13],xmm0[14],xmm2[14],xmm0[15],xmm2[15]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,1,2,1]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,7,5,6,5]
; SSE-NEXT:    punpcklbw {{.*#+}} xmm8 = xmm8[0],xmm2[0],xmm8[1],xmm2[1],xmm8[2],xmm2[2],xmm8[3],xmm2[3],xmm8[4],xmm2[4],xmm8[5],xmm2[5],xmm8[6],xmm2[6],xmm8[7],xmm2[7]
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm8[0,2,0,3]
; SSE-NEXT:    pshufhw {{.*#+}} xmm3 = xmm3[0,1,2,3,4,5,7,7]
; SSE-NEXT:    pand %xmm5, %xmm3
; SSE-NEXT:    pandn %xmm0, %xmm5
; SSE-NEXT:    por %xmm3, %xmm5
; SSE-NEXT:    pand %xmm9, %xmm13
; SSE-NEXT:    packuswb %xmm5, %xmm0
; SSE-NEXT:    pandn %xmm0, %xmm9
; SSE-NEXT:    por %xmm13, %xmm9
; SSE-NEXT:    movdqa %xmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm8 # 16-byte Reload
; SSE-NEXT:    por {{[-0-9]+}}(%r{{[sb]}}p), %xmm8 # 16-byte Folded Reload
; SSE-NEXT:    movdqa %xmm8, %xmm0
; SSE-NEXT:    pand %xmm11, %xmm0
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm0[2,1,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm3 = xmm3[2,1,2,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,4,7,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,1,0,2]
; SSE-NEXT:    packuswb %xmm3, %xmm0
; SSE-NEXT:    movdqa {{.*#+}} xmm3 = [255,255,255,255,255,0,0,0,0,0,255,255,255,255,255,255]
; SSE-NEXT:    movdqa %xmm3, %xmm4
; SSE-NEXT:    pandn %xmm0, %xmm4
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm10 # 16-byte Reload
; SSE-NEXT:    por {{[-0-9]+}}(%r{{[sb]}}p), %xmm10 # 16-byte Folded Reload
; SSE-NEXT:    movdqa %xmm10, %xmm0
; SSE-NEXT:    pand %xmm11, %xmm0
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[3,1,2,0]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,6,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[2,1,0,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm5 = xmm0[2,1,0,3,4,5,6,7]
; SSE-NEXT:    packuswb %xmm5, %xmm5
; SSE-NEXT:    pand %xmm3, %xmm5
; SSE-NEXT:    por %xmm4, %xmm5
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm15 # 16-byte Reload
; SSE-NEXT:    movdqa {{.*#+}} xmm13 = [65535,0,65535,65535,0,65535,65535,0]
; SSE-NEXT:    pand %xmm13, %xmm15
; SSE-NEXT:    por {{[-0-9]+}}(%r{{[sb]}}p), %xmm15 # 16-byte Folded Reload
; SSE-NEXT:    movdqa %xmm15, %xmm0
; SSE-NEXT:    pand %xmm11, %xmm0
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,2,1,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[0,1,2,1,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,2,1,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[0,1,0,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,6,5,4,7]
; SSE-NEXT:    packuswb %xmm0, %xmm4
; SSE-NEXT:    movdqa {{.*#+}} xmm0 = [65535,65535,65535,65535,65535,0,0,0]
; SSE-NEXT:    movdqa %xmm0, %xmm6
; SSE-NEXT:    pandn %xmm4, %xmm6
; SSE-NEXT:    pand %xmm0, %xmm5
; SSE-NEXT:    por %xmm5, %xmm6
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm4 # 16-byte Reload
; SSE-NEXT:    por {{[-0-9]+}}(%r{{[sb]}}p), %xmm4 # 16-byte Folded Reload
; SSE-NEXT:    movdqa %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pand %xmm11, %xmm4
; SSE-NEXT:    pshufd {{.*#+}} xmm5 = xmm4[2,1,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm5 = xmm5[2,1,2,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm4 = xmm4[0,1,2,3,4,7,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[0,1,0,2]
; SSE-NEXT:    packuswb %xmm5, %xmm4
; SSE-NEXT:    movdqa %xmm3, %xmm5
; SSE-NEXT:    pandn %xmm4, %xmm5
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    por {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Folded Reload
; SSE-NEXT:    movdqa %xmm1, %xmm4
; SSE-NEXT:    pand %xmm11, %xmm4
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[3,1,2,0]
; SSE-NEXT:    pshufhw {{.*#+}} xmm4 = xmm4[0,1,2,3,6,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[2,1,0,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm7 = xmm4[2,1,0,3,4,5,6,7]
; SSE-NEXT:    packuswb %xmm7, %xmm7
; SSE-NEXT:    pand %xmm3, %xmm7
; SSE-NEXT:    por %xmm5, %xmm7
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm4 # 16-byte Reload
; SSE-NEXT:    pand %xmm13, %xmm4
; SSE-NEXT:    pandn {{[-0-9]+}}(%r{{[sb]}}p), %xmm13 # 16-byte Folded Reload
; SSE-NEXT:    por %xmm4, %xmm13
; SSE-NEXT:    pand %xmm13, %xmm11
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm11[0,2,1,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm4 = xmm4[0,1,2,1,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[0,2,1,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm4 = xmm4[0,1,0,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm4 = xmm4[0,1,2,3,6,5,4,7]
; SSE-NEXT:    packuswb %xmm4, %xmm5
; SSE-NEXT:    movdqa %xmm0, %xmm4
; SSE-NEXT:    pandn %xmm5, %xmm4
; SSE-NEXT:    pand %xmm0, %xmm7
; SSE-NEXT:    por %xmm7, %xmm4
; SSE-NEXT:    movdqa %xmm8, %xmm5
; SSE-NEXT:    punpckhbw {{.*#+}} xmm5 = xmm5[8],xmm2[8],xmm5[9],xmm2[9],xmm5[10],xmm2[10],xmm5[11],xmm2[11],xmm5[12],xmm2[12],xmm5[13],xmm2[13],xmm5[14],xmm2[14],xmm5[15],xmm2[15]
; SSE-NEXT:    punpcklbw {{.*#+}} xmm8 = xmm8[0],xmm2[0],xmm8[1],xmm2[1],xmm8[2],xmm2[2],xmm8[3],xmm2[3],xmm8[4],xmm2[4],xmm8[5],xmm2[5],xmm8[6],xmm2[6],xmm8[7],xmm2[7]
; SSE-NEXT:    movdqa %xmm8, %xmm7
; SSE-NEXT:    shufps {{.*#+}} xmm8 = xmm8[1,0],xmm5[0,0]
; SSE-NEXT:    shufps {{.*#+}} xmm8 = xmm8[2,0],xmm5[2,3]
; SSE-NEXT:    psrlq $48, %xmm5
; SSE-NEXT:    psrldq {{.*#+}} xmm7 = xmm7[10,11,12,13,14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; SSE-NEXT:    punpcklwd {{.*#+}} xmm7 = xmm7[0],xmm5[0],xmm7[1],xmm5[1],xmm7[2],xmm5[2],xmm7[3],xmm5[3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm5 = xmm8[3,1,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm5 = xmm5[0,1,0,3]
; SSE-NEXT:    pshufhw {{.*#+}} xmm5 = xmm5[0,1,2,3,4,4,5,7]
; SSE-NEXT:    packuswb %xmm7, %xmm5
; SSE-NEXT:    movdqa %xmm3, %xmm7
; SSE-NEXT:    pandn %xmm5, %xmm7
; SSE-NEXT:    movdqa %xmm10, %xmm5
; SSE-NEXT:    punpckhbw {{.*#+}} xmm5 = xmm5[8],xmm2[8],xmm5[9],xmm2[9],xmm5[10],xmm2[10],xmm5[11],xmm2[11],xmm5[12],xmm2[12],xmm5[13],xmm2[13],xmm5[14],xmm2[14],xmm5[15],xmm2[15]
; SSE-NEXT:    pshufd {{.*#+}} xmm5 = xmm5[1,1,2,3]
; SSE-NEXT:    pshufhw {{.*#+}} xmm8 = xmm5[0,1,2,3,5,5,5,5]
; SSE-NEXT:    movdqa {{.*#+}} xmm5 = [65535,0,65535,65535,0,65535,65535,65535]
; SSE-NEXT:    movdqa %xmm5, %xmm9
; SSE-NEXT:    pandn %xmm8, %xmm9
; SSE-NEXT:    punpcklbw {{.*#+}} xmm10 = xmm10[0],xmm2[0],xmm10[1],xmm2[1],xmm10[2],xmm2[2],xmm10[3],xmm2[3],xmm10[4],xmm2[4],xmm10[5],xmm2[5],xmm10[6],xmm2[6],xmm10[7],xmm2[7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm8 = xmm10[0,1,2,3,7,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm8 = xmm8[0,2,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm10 = xmm8[3,1,1,2,4,5,6,7]
; SSE-NEXT:    pand %xmm5, %xmm10
; SSE-NEXT:    por %xmm9, %xmm10
; SSE-NEXT:    packuswb %xmm10, %xmm10
; SSE-NEXT:    pand %xmm3, %xmm10
; SSE-NEXT:    por %xmm7, %xmm10
; SSE-NEXT:    movdqa %xmm15, %xmm8
; SSE-NEXT:    punpckhbw {{.*#+}} xmm15 = xmm15[8],xmm2[8],xmm15[9],xmm2[9],xmm15[10],xmm2[10],xmm15[11],xmm2[11],xmm15[12],xmm2[12],xmm15[13],xmm2[13],xmm15[14],xmm2[14],xmm15[15],xmm2[15]
; SSE-NEXT:    pshufhw {{.*#+}} xmm7 = xmm15[0,1,2,3,7,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm7 = xmm7[0,1,2,0]
; SSE-NEXT:    pshufhw {{.*#+}} xmm9 = xmm7[0,1,2,3,5,5,7,4]
; SSE-NEXT:    movdqa {{.*#+}} xmm7 = [65535,65535,65535,65535,0,65535,0,0]
; SSE-NEXT:    movdqa %xmm7, %xmm11
; SSE-NEXT:    pandn %xmm9, %xmm11
; SSE-NEXT:    punpcklbw {{.*#+}} xmm8 = xmm8[0],xmm2[0],xmm8[1],xmm2[1],xmm8[2],xmm2[2],xmm8[3],xmm2[3],xmm8[4],xmm2[4],xmm8[5],xmm2[5],xmm8[6],xmm2[6],xmm8[7],xmm2[7]
; SSE-NEXT:    pshufd {{.*#+}} xmm8 = xmm8[0,3,1,1]
; SSE-NEXT:    pshuflw {{.*#+}} xmm8 = xmm8[0,1,1,3,4,5,6,7]
; SSE-NEXT:    pand %xmm7, %xmm8
; SSE-NEXT:    por %xmm8, %xmm11
; SSE-NEXT:    packuswb %xmm11, %xmm9
; SSE-NEXT:    movdqa %xmm0, %xmm8
; SSE-NEXT:    pandn %xmm9, %xmm8
; SSE-NEXT:    pand %xmm0, %xmm10
; SSE-NEXT:    por %xmm10, %xmm8
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm11 # 16-byte Reload
; SSE-NEXT:    movdqa %xmm11, %xmm9
; SSE-NEXT:    punpckhbw {{.*#+}} xmm9 = xmm9[8],xmm2[8],xmm9[9],xmm2[9],xmm9[10],xmm2[10],xmm9[11],xmm2[11],xmm9[12],xmm2[12],xmm9[13],xmm2[13],xmm9[14],xmm2[14],xmm9[15],xmm2[15]
; SSE-NEXT:    punpcklbw {{.*#+}} xmm11 = xmm11[0],xmm2[0],xmm11[1],xmm2[1],xmm11[2],xmm2[2],xmm11[3],xmm2[3],xmm11[4],xmm2[4],xmm11[5],xmm2[5],xmm11[6],xmm2[6],xmm11[7],xmm2[7]
; SSE-NEXT:    movdqa %xmm11, %xmm10
; SSE-NEXT:    shufps {{.*#+}} xmm11 = xmm11[1,0],xmm9[0,0]
; SSE-NEXT:    shufps {{.*#+}} xmm11 = xmm11[2,0],xmm9[2,3]
; SSE-NEXT:    psrlq $48, %xmm9
; SSE-NEXT:    psrldq {{.*#+}} xmm10 = xmm10[10,11,12,13,14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; SSE-NEXT:    punpcklwd {{.*#+}} xmm10 = xmm10[0],xmm9[0],xmm10[1],xmm9[1],xmm10[2],xmm9[2],xmm10[3],xmm9[3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm9 = xmm11[3,1,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm9 = xmm9[0,1,0,3]
; SSE-NEXT:    pshufhw {{.*#+}} xmm9 = xmm9[0,1,2,3,4,4,5,7]
; SSE-NEXT:    packuswb %xmm10, %xmm9
; SSE-NEXT:    movdqa %xmm1, %xmm10
; SSE-NEXT:    punpckhbw {{.*#+}} xmm10 = xmm10[8],xmm2[8],xmm10[9],xmm2[9],xmm10[10],xmm2[10],xmm10[11],xmm2[11],xmm10[12],xmm2[12],xmm10[13],xmm2[13],xmm10[14],xmm2[14],xmm10[15],xmm2[15]
; SSE-NEXT:    pshufd {{.*#+}} xmm10 = xmm10[1,1,2,3]
; SSE-NEXT:    pshufhw {{.*#+}} xmm10 = xmm10[0,1,2,3,5,5,5,5]
; SSE-NEXT:    punpcklbw {{.*#+}} xmm1 = xmm1[0],xmm2[0],xmm1[1],xmm2[1],xmm1[2],xmm2[2],xmm1[3],xmm2[3],xmm1[4],xmm2[4],xmm1[5],xmm2[5],xmm1[6],xmm2[6],xmm1[7],xmm2[7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm11 = xmm1[0,1,2,3,7,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm11 = xmm11[0,2,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm11 = xmm11[3,1,1,2,4,5,6,7]
; SSE-NEXT:    pand %xmm5, %xmm11
; SSE-NEXT:    pandn %xmm10, %xmm5
; SSE-NEXT:    por %xmm11, %xmm5
; SSE-NEXT:    packuswb %xmm5, %xmm5
; SSE-NEXT:    pand %xmm3, %xmm5
; SSE-NEXT:    pandn %xmm9, %xmm3
; SSE-NEXT:    por %xmm3, %xmm5
; SSE-NEXT:    movdqa %xmm13, %xmm3
; SSE-NEXT:    punpcklbw {{.*#+}} xmm3 = xmm3[0],xmm2[0],xmm3[1],xmm2[1],xmm3[2],xmm2[2],xmm3[3],xmm2[3],xmm3[4],xmm2[4],xmm3[5],xmm2[5],xmm3[6],xmm2[6],xmm3[7],xmm2[7]
; SSE-NEXT:    punpckhbw {{.*#+}} xmm13 = xmm13[8],xmm2[8],xmm13[9],xmm2[9],xmm13[10],xmm2[10],xmm13[11],xmm2[11],xmm13[12],xmm2[12],xmm13[13],xmm2[13],xmm13[14],xmm2[14],xmm13[15],xmm2[15]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm3[0,3,1,1]
; SSE-NEXT:    pshuflw {{.*#+}} xmm2 = xmm2[0,1,1,3,4,5,6,7]
; SSE-NEXT:    pand %xmm7, %xmm2
; SSE-NEXT:    pshufhw {{.*#+}} xmm3 = xmm13[0,1,2,3,7,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[0,1,2,0]
; SSE-NEXT:    pshufhw {{.*#+}} xmm3 = xmm3[0,1,2,3,5,5,7,4]
; SSE-NEXT:    pandn %xmm3, %xmm7
; SSE-NEXT:    por %xmm2, %xmm7
; SSE-NEXT:    pand %xmm0, %xmm5
; SSE-NEXT:    packuswb %xmm7, %xmm2
; SSE-NEXT:    pandn %xmm2, %xmm0
; SSE-NEXT:    por %xmm5, %xmm0
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    movaps %xmm2, 16(%rsi)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    movaps %xmm2, (%rsi)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movaps %xmm1, 16(%rdx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movaps %xmm1, (%rdx)
; SSE-NEXT:    movdqa %xmm14, 16(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movaps %xmm1, (%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movaps %xmm1, 16(%r8)
; SSE-NEXT:    movdqa %xmm12, (%r8)
; SSE-NEXT:    movdqa %xmm4, 16(%r9)
; SSE-NEXT:    movdqa %xmm6, (%r9)
; SSE-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; SSE-NEXT:    movdqa %xmm0, 16(%rax)
; SSE-NEXT:    movdqa %xmm8, (%rax)
; SSE-NEXT:    addq $280, %rsp # imm = 0x118
; SSE-NEXT:    retq
;
; AVX1-LABEL: load_i8_stride6_vf32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    subq $168, %rsp
; AVX1-NEXT:    vmovdqa 128(%rdi), %xmm4
; AVX1-NEXT:    vpshufb {{.*#+}} xmm0 = xmm4[u,u,4,10,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX1-NEXT:    vmovdqa 144(%rdi), %xmm5
; AVX1-NEXT:    vpshufb {{.*#+}} xmm1 = xmm5[u,u,u,u,0,6,12,u,u,u,u,u,u,u,u,u]
; AVX1-NEXT:    vpunpckldq {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; AVX1-NEXT:    vmovdqa 176(%rdi), %xmm6
; AVX1-NEXT:    vpshufb {{.*#+}} xmm0 = xmm6[u,u,u,u,u,u,u,u,u,u,u],zero,zero,zero,xmm6[4,10]
; AVX1-NEXT:    vmovdqa 160(%rdi), %xmm7
; AVX1-NEXT:    vpshufb {{.*#+}} xmm2 = xmm7[u,u,u,u,u,u,u,u,u,u,u,2,8,14],zero,zero
; AVX1-NEXT:    vpor %xmm0, %xmm2, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm0 = <u,u,u,u,u,u,255,255,255,255,255,0,0,0,0,0>
; AVX1-NEXT:    vpblendvb %xmm0, %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vmovdqa %xmm1, (%rsp) # 16-byte Spill
; AVX1-NEXT:    vpshufb {{.*#+}} xmm1 = xmm4[u,u,5,11,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX1-NEXT:    vpshufb {{.*#+}} xmm2 = xmm5[u,u,u,u,1,7,13,u,u,u,u,u,u,u,u,u]
; AVX1-NEXT:    vpunpckldq {{.*#+}} xmm1 = xmm2[0],xmm1[0],xmm2[1],xmm1[1]
; AVX1-NEXT:    vpshufb {{.*#+}} xmm2 = xmm6[u,u,u,u,u,u,u,u,u,u,u],zero,zero,zero,xmm6[5,11]
; AVX1-NEXT:    vpshufb {{.*#+}} xmm3 = xmm7[u,u,u,u,u,u,u,u,u,u,u,3,9,15],zero,zero
; AVX1-NEXT:    vpor %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpblendvb %xmm0, %xmm1, %xmm2, %xmm0
; AVX1-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-NEXT:    vmovdqa 32(%rdi), %xmm15
; AVX1-NEXT:    vmovdqa 48(%rdi), %xmm14
; AVX1-NEXT:    vpshufb {{.*#+}} xmm2 = xmm14[2,8,14,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm1 = <u,u,u,u,u,0,6,12,u,u,u,u,u,u,u,u>
; AVX1-NEXT:    vpshufb %xmm1, %xmm15, %xmm3
; AVX1-NEXT:    vpunpcklqdq {{.*#+}} xmm3 = xmm3[0],xmm2[0]
; AVX1-NEXT:    vmovdqa (%rdi), %xmm9
; AVX1-NEXT:    vmovdqa 16(%rdi), %xmm8
; AVX1-NEXT:    vpshufb {{.*#+}} xmm2 = zero,zero,zero,xmm8[4,10,u,u,u,u,u,u,u,u,u,u,u]
; AVX1-NEXT:    vpshufb {{.*#+}} xmm10 = xmm9[2,8,14],zero,zero,xmm9[u,u,u,u,u,u,u,u,u,u,u]
; AVX1-NEXT:    vpor %xmm2, %xmm10, %xmm10
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm2 = <0,0,0,0,0,255,255,255,255,255,255,u,u,u,u,u>
; AVX1-NEXT:    vpblendvb %xmm2, %xmm3, %xmm10, %xmm3
; AVX1-NEXT:    vmovdqu %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = <3,9,15,u,u,u,u,u,u,u,u,u,u,u,u,u>
; AVX1-NEXT:    vpshufb %xmm3, %xmm14, %xmm10
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm11 = <u,u,u,u,u,1,7,13,u,u,u,u,u,u,u,u>
; AVX1-NEXT:    vpshufb %xmm11, %xmm15, %xmm12
; AVX1-NEXT:    vpunpcklqdq {{.*#+}} xmm10 = xmm12[0],xmm10[0]
; AVX1-NEXT:    vpshufb {{.*#+}} xmm12 = zero,zero,zero,xmm8[5,11,u,u,u,u,u,u,u,u,u,u,u]
; AVX1-NEXT:    vpshufb {{.*#+}} xmm13 = xmm9[3,9,15],zero,zero,xmm9[u,u,u,u,u,u,u,u,u,u,u]
; AVX1-NEXT:    vpor %xmm12, %xmm13, %xmm12
; AVX1-NEXT:    vpblendvb %xmm2, %xmm10, %xmm12, %xmm0
; AVX1-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-NEXT:    vmovdqa %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-NEXT:    vpshufb {{.*#+}} xmm0 = xmm5[2,8,14,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX1-NEXT:    vmovdqa %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-NEXT:    vpshufb %xmm1, %xmm4, %xmm1
; AVX1-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm1[0],xmm0[0]
; AVX1-NEXT:    vmovdqa %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-NEXT:    vpshufb {{.*#+}} xmm1 = xmm7[u,u,u,u,u,u,u,u,u,u,u,4,10],zero,zero,zero
; AVX1-NEXT:    vmovdqa %xmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-NEXT:    vpshufb {{.*#+}} xmm2 = xmm6[u,u,u,u,u,u,u,u,u,u,u],zero,zero,xmm6[0,6,12]
; AVX1-NEXT:    vpor %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm2 = <u,u,u,u,u,255,255,255,255,255,255,0,0,0,0,0>
; AVX1-NEXT:    vpblendvb %xmm2, %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-NEXT:    vpshufb %xmm3, %xmm5, %xmm0
; AVX1-NEXT:    vpshufb %xmm11, %xmm4, %xmm1
; AVX1-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm1[0],xmm0[0]
; AVX1-NEXT:    vpshufb {{.*#+}} xmm1 = xmm7[u,u,u,u,u,u,u,u,u,u,u,5,11],zero,zero,zero
; AVX1-NEXT:    vpshufb {{.*#+}} xmm3 = xmm6[u,u,u,u,u,u,u,u,u,u,u],zero,zero,xmm6[1,7,13]
; AVX1-NEXT:    vpor %xmm1, %xmm3, %xmm1
; AVX1-NEXT:    vpblendvb %xmm2, %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-NEXT:    vpshufb {{.*#+}} xmm0 = xmm9[4,10],zero,zero,zero,xmm9[u,u,u,u,u,u,u,u,u,u,u]
; AVX1-NEXT:    vpshufb {{.*#+}} xmm1 = zero,zero,xmm8[0,6,12,u,u,u,u,u,u,u,u,u,u,u]
; AVX1-NEXT:    vpor %xmm0, %xmm1, %xmm1
; AVX1-NEXT:    vpshufb {{.*#+}} xmm0 = xmm14[u,u,u,u,u,u,u,u,4,10,u,u,u,u,u,u]
; AVX1-NEXT:    vpshufb {{.*#+}} xmm2 = xmm15[u,u,u,u,u,u,u,u,u,u,u,u,u,2,8,14]
; AVX1-NEXT:    vpunpckhqdq {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm0 = <255,255,255,255,255,0,0,0,0,0,u,u,u,u,u,u>
; AVX1-NEXT:    vpblendvb %xmm0, %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-NEXT:    vpshufb {{.*#+}} xmm1 = xmm9[5,11],zero,zero,zero,xmm9[u,u,u,u,u,u,u,u,u,u,u]
; AVX1-NEXT:    vpshufb {{.*#+}} xmm2 = zero,zero,xmm8[1,7,13,u,u,u,u,u,u,u,u,u,u,u]
; AVX1-NEXT:    vpor %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vpshufb {{.*#+}} xmm2 = xmm14[u,u,u,u,u,u,u,u,5,11,u,u,u,u,u,u]
; AVX1-NEXT:    vpshufb {{.*#+}} xmm3 = xmm15[u,u,u,u,u,u,u,u,u,u,u,u,u,3,9,15]
; AVX1-NEXT:    vpunpckhqdq {{.*#+}} xmm2 = xmm3[1],xmm2[1]
; AVX1-NEXT:    vpblendvb %xmm0, %xmm1, %xmm2, %xmm0
; AVX1-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm10 = <128,128,128,2,8,14,u,u,u,u,u,u,u,u,u,u>
; AVX1-NEXT:    vmovdqa 112(%rdi), %xmm3
; AVX1-NEXT:    vpshufb %xmm10, %xmm3, %xmm1
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm6 = <0,6,12,128,128,128,u,u,u,u,u,u,u,u,u,u>
; AVX1-NEXT:    vmovdqa 96(%rdi), %xmm0
; AVX1-NEXT:    vpshufb %xmm6, %xmm0, %xmm2
; AVX1-NEXT:    vpor %xmm1, %xmm2, %xmm5
; AVX1-NEXT:    vmovdqa 80(%rdi), %xmm2
; AVX1-NEXT:    vpshufb {{.*#+}} xmm4 = xmm2[u,u,u,u,u,u,u,u,u,u,u],zero,zero,zero,xmm2[4,10]
; AVX1-NEXT:    vmovdqa 64(%rdi), %xmm1
; AVX1-NEXT:    vpshufb {{.*#+}} xmm13 = xmm1[u,u,u,u,u,u,u,u,u,u,u,2,8,14],zero,zero
; AVX1-NEXT:    vpor %xmm4, %xmm13, %xmm4
; AVX1-NEXT:    vinsertf128 $1, %xmm5, %ymm4, %ymm4
; AVX1-NEXT:    vpshufb {{.*#+}} xmm5 = xmm15[u,u,4,10,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX1-NEXT:    vpshufb {{.*#+}} xmm13 = xmm14[u,u,u,u,0,6,12,u,u,u,u,u,u,u,u,u]
; AVX1-NEXT:    vpunpckldq {{.*#+}} xmm5 = xmm13[0],xmm5[0],xmm13[1],xmm5[1]
; AVX1-NEXT:    vpshufb %xmm10, %xmm8, %xmm10
; AVX1-NEXT:    vpshufb %xmm6, %xmm9, %xmm6
; AVX1-NEXT:    vpor %xmm6, %xmm10, %xmm6
; AVX1-NEXT:    vpblendw {{.*#+}} xmm5 = xmm6[0,1,2],xmm5[3,4,5],xmm6[6,7]
; AVX1-NEXT:    vmovaps {{.*#+}} ymm6 = [255,255,255,255,255,255,255,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,255,255,255,255]
; AVX1-NEXT:    vandnps %ymm4, %ymm6, %ymm4
; AVX1-NEXT:    vandps %ymm6, %ymm5, %ymm5
; AVX1-NEXT:    vorps %ymm4, %ymm5, %ymm4
; AVX1-NEXT:    vmovaps {{.*#+}} ymm5 = [65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,0,0,0,0,0]
; AVX1-NEXT:    vandps %ymm5, %ymm4, %ymm4
; AVX1-NEXT:    vinsertf128 $1, (%rsp), %ymm0, %ymm10 # 16-byte Folded Reload
; AVX1-NEXT:    vandnps %ymm10, %ymm5, %ymm10
; AVX1-NEXT:    vorps %ymm4, %ymm10, %ymm4
; AVX1-NEXT:    vmovups %ymm4, (%rsp) # 32-byte Spill
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm7 = <128,128,128,3,9,15,u,u,u,u,u,u,u,u,u,u>
; AVX1-NEXT:    vpshufb %xmm7, %xmm3, %xmm13
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm4 = <1,7,13,128,128,128,u,u,u,u,u,u,u,u,u,u>
; AVX1-NEXT:    vpshufb %xmm4, %xmm0, %xmm12
; AVX1-NEXT:    vpor %xmm13, %xmm12, %xmm12
; AVX1-NEXT:    vpshufb {{.*#+}} xmm13 = xmm2[u,u,u,u,u,u,u,u,u,u,u],zero,zero,zero,xmm2[5,11]
; AVX1-NEXT:    vpshufb {{.*#+}} xmm11 = xmm1[u,u,u,u,u,u,u,u,u,u,u,3,9,15],zero,zero
; AVX1-NEXT:    vpor %xmm13, %xmm11, %xmm11
; AVX1-NEXT:    vinsertf128 $1, %xmm12, %ymm11, %ymm11
; AVX1-NEXT:    vpshufb {{.*#+}} xmm12 = xmm15[u,u,5,11,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX1-NEXT:    vpshufb {{.*#+}} xmm13 = xmm14[u,u,u,u,1,7,13,u,u,u,u,u,u,u,u,u]
; AVX1-NEXT:    vpunpckldq {{.*#+}} xmm12 = xmm13[0],xmm12[0],xmm13[1],xmm12[1]
; AVX1-NEXT:    vpshufb %xmm7, %xmm8, %xmm7
; AVX1-NEXT:    vpshufb %xmm4, %xmm9, %xmm4
; AVX1-NEXT:    vpor %xmm7, %xmm4, %xmm4
; AVX1-NEXT:    vpblendw {{.*#+}} xmm4 = xmm4[0,1,2],xmm12[3,4,5],xmm4[6,7]
; AVX1-NEXT:    vandnps %ymm11, %ymm6, %ymm7
; AVX1-NEXT:    vandps %ymm6, %ymm4, %ymm4
; AVX1-NEXT:    vorps %ymm7, %ymm4, %ymm4
; AVX1-NEXT:    vandps %ymm5, %ymm4, %ymm4
; AVX1-NEXT:    vinsertf128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm6 # 16-byte Folded Reload
; AVX1-NEXT:    vandnps %ymm6, %ymm5, %ymm5
; AVX1-NEXT:    vorps %ymm5, %ymm4, %ymm4
; AVX1-NEXT:    vmovups %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-NEXT:    vpshufb {{.*#+}} xmm5 = zero,zero,zero,xmm3[4,10,u,u,u,u,u,u,u,u,u,u,u]
; AVX1-NEXT:    vpshufb {{.*#+}} xmm6 = xmm0[2,8,14],zero,zero,xmm0[u,u,u,u,u,u,u,u,u,u,u]
; AVX1-NEXT:    vpor %xmm5, %xmm6, %xmm5
; AVX1-NEXT:    vpshufb {{.*#+}} xmm6 = xmm1[u,u,u,u,u,u,u,u,u,u,u,4,10],zero,zero,zero
; AVX1-NEXT:    vpshufb {{.*#+}} xmm7 = xmm2[u,u,u,u,u,u,u,u,u,u,u],zero,zero,xmm2[0,6,12]
; AVX1-NEXT:    vpor %xmm6, %xmm7, %xmm6
; AVX1-NEXT:    vinsertf128 $1, %xmm5, %ymm6, %ymm5
; AVX1-NEXT:    vmovaps {{.*#+}} ymm6 = [255,255,255,255,255,255,255,255,255,255,255,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,255,255,255,255,255]
; AVX1-NEXT:    vandnps %ymm5, %ymm6, %ymm5
; AVX1-NEXT:    vandps {{[-0-9]+}}(%r{{[sb]}}p), %ymm6, %ymm7 # 32-byte Folded Reload
; AVX1-NEXT:    vorps %ymm5, %ymm7, %ymm7
; AVX1-NEXT:    vmovaps {{.*#+}} ymm10 = [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0]
; AVX1-NEXT:    vandps %ymm7, %ymm10, %ymm7
; AVX1-NEXT:    vinsertf128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm8 # 16-byte Folded Reload
; AVX1-NEXT:    vandnps %ymm8, %ymm10, %ymm8
; AVX1-NEXT:    vorps %ymm7, %ymm8, %ymm13
; AVX1-NEXT:    vpshufb {{.*#+}} xmm7 = zero,zero,zero,xmm3[5,11,u,u,u,u,u,u,u,u,u,u,u]
; AVX1-NEXT:    vpshufb {{.*#+}} xmm8 = xmm0[3,9,15],zero,zero,xmm0[u,u,u,u,u,u,u,u,u,u,u]
; AVX1-NEXT:    vpor %xmm7, %xmm8, %xmm7
; AVX1-NEXT:    vpshufb {{.*#+}} xmm8 = xmm1[u,u,u,u,u,u,u,u,u,u,u,5,11],zero,zero,zero
; AVX1-NEXT:    vpshufb {{.*#+}} xmm9 = xmm2[u,u,u,u,u,u,u,u,u,u,u],zero,zero,xmm2[1,7,13]
; AVX1-NEXT:    vpor %xmm8, %xmm9, %xmm8
; AVX1-NEXT:    vinsertf128 $1, %xmm7, %ymm8, %ymm7
; AVX1-NEXT:    vandnps %ymm7, %ymm6, %ymm7
; AVX1-NEXT:    vandps {{[-0-9]+}}(%r{{[sb]}}p), %ymm6, %ymm6 # 32-byte Folded Reload
; AVX1-NEXT:    vorps %ymm7, %ymm6, %ymm6
; AVX1-NEXT:    vandps %ymm6, %ymm10, %ymm6
; AVX1-NEXT:    vinsertf128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm7 # 16-byte Folded Reload
; AVX1-NEXT:    vandnps %ymm7, %ymm10, %ymm7
; AVX1-NEXT:    vorps %ymm7, %ymm6, %ymm6
; AVX1-NEXT:    vpshufb {{.*#+}} xmm7 = xmm0[4,10],zero,zero,zero,xmm0[u,u,u,u,u,u,u,u,u,u,u]
; AVX1-NEXT:    vpshufb {{.*#+}} xmm8 = zero,zero,xmm3[0,6,12,u,u,u,u,u,u,u,u,u,u,u]
; AVX1-NEXT:    vpor %xmm7, %xmm8, %xmm7
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm8 = <u,u,u,u,u,u,u,u,u,u,128,128,128,2,8,14>
; AVX1-NEXT:    vpshufb %xmm8, %xmm2, %xmm9
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm11 = <u,u,u,u,u,u,u,u,u,u,0,6,12,128,128,128>
; AVX1-NEXT:    vpshufb %xmm11, %xmm1, %xmm12
; AVX1-NEXT:    vpor %xmm9, %xmm12, %xmm9
; AVX1-NEXT:    vinsertf128 $1, %xmm7, %ymm9, %ymm7
; AVX1-NEXT:    vmovaps {{.*#+}} ymm9 = [0,0,0,0,0,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535]
; AVX1-NEXT:    vandnps {{[-0-9]+}}(%r{{[sb]}}p), %ymm9, %ymm12 # 32-byte Folded Reload
; AVX1-NEXT:    vandps %ymm7, %ymm9, %ymm7
; AVX1-NEXT:    vorps %ymm7, %ymm12, %ymm7
; AVX1-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm5 # 16-byte Reload
; AVX1-NEXT:    vpshufb %xmm8, %xmm5, %xmm8
; AVX1-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm4 # 16-byte Reload
; AVX1-NEXT:    vpshufb %xmm11, %xmm4, %xmm11
; AVX1-NEXT:    vpor %xmm8, %xmm11, %xmm8
; AVX1-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm15 # 16-byte Reload
; AVX1-NEXT:    vpshufb {{.*#+}} xmm11 = xmm15[u,u,u,u,u,u,u,u,4,10,u,u,u,u,u,u]
; AVX1-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm14 # 16-byte Reload
; AVX1-NEXT:    vpshufb {{.*#+}} xmm12 = xmm14[u,u,u,u,u,u,u,u,u,u,u,u,u,2,8,14]
; AVX1-NEXT:    vpunpckhqdq {{.*#+}} xmm11 = xmm12[1],xmm11[1]
; AVX1-NEXT:    vpblendw {{.*#+}} xmm8 = xmm11[0,1,2,3,4],xmm8[5,6,7]
; AVX1-NEXT:    vandps %ymm7, %ymm10, %ymm7
; AVX1-NEXT:    vinsertf128 $1, %xmm8, %ymm0, %ymm8
; AVX1-NEXT:    vandnps %ymm8, %ymm10, %ymm8
; AVX1-NEXT:    vorps %ymm7, %ymm8, %ymm7
; AVX1-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[5,11],zero,zero,zero,xmm0[u,u,u,u,u,u,u,u,u,u,u]
; AVX1-NEXT:    vpshufb {{.*#+}} xmm3 = zero,zero,xmm3[1,7,13,u,u,u,u,u,u,u,u,u,u,u]
; AVX1-NEXT:    vpor %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = <u,u,u,u,u,u,u,u,u,u,128,128,128,3,9,15>
; AVX1-NEXT:    vpshufb %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm8 = <u,u,u,u,u,u,u,u,u,u,1,7,13,128,128,128>
; AVX1-NEXT:    vpshufb %xmm8, %xmm1, %xmm1
; AVX1-NEXT:    vpor %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    vandnps {{[-0-9]+}}(%r{{[sb]}}p), %ymm9, %ymm1 # 32-byte Folded Reload
; AVX1-NEXT:    vandps %ymm0, %ymm9, %ymm0
; AVX1-NEXT:    vorps %ymm1, %ymm0, %ymm0
; AVX1-NEXT:    vpshufb %xmm3, %xmm5, %xmm1
; AVX1-NEXT:    vpshufb %xmm8, %xmm4, %xmm2
; AVX1-NEXT:    vpor %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vpshufb {{.*#+}} xmm2 = xmm15[u,u,u,u,u,u,u,u,5,11,u,u,u,u,u,u]
; AVX1-NEXT:    vpshufb {{.*#+}} xmm3 = xmm14[u,u,u,u,u,u,u,u,u,u,u,u,u,3,9,15]
; AVX1-NEXT:    vpunpckhqdq {{.*#+}} xmm2 = xmm3[1],xmm2[1]
; AVX1-NEXT:    vpblendw {{.*#+}} xmm1 = xmm2[0,1,2,3,4],xmm1[5,6,7]
; AVX1-NEXT:    vandps %ymm0, %ymm10, %ymm0
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX1-NEXT:    vandnps %ymm1, %ymm10, %ymm1
; AVX1-NEXT:    vorps %ymm1, %ymm0, %ymm0
; AVX1-NEXT:    vmovups (%rsp), %ymm1 # 32-byte Reload
; AVX1-NEXT:    vmovaps %ymm1, (%rsi)
; AVX1-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX1-NEXT:    vmovaps %ymm1, (%rdx)
; AVX1-NEXT:    vmovaps %ymm13, (%rcx)
; AVX1-NEXT:    vmovaps %ymm6, (%r8)
; AVX1-NEXT:    vmovaps %ymm7, (%r9)
; AVX1-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX1-NEXT:    vmovaps %ymm0, (%rax)
; AVX1-NEXT:    addq $168, %rsp
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: load_i8_stride6_vf32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovdqa (%rdi), %ymm1
; AVX2-NEXT:    vmovdqa 32(%rdi), %ymm2
; AVX2-NEXT:    vmovdqa 64(%rdi), %ymm0
; AVX2-NEXT:    vmovdqa 96(%rdi), %ymm4
; AVX2-NEXT:    vmovdqa 160(%rdi), %ymm5
; AVX2-NEXT:    vmovdqa 128(%rdi), %ymm6
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm9 = <255,255,u,u,0,0,255,255,u,u,0,0,255,255,u,u,0,0,255,255,u,u,0,0,255,255,u,u,0,0,255,255>
; AVX2-NEXT:    vpblendvb %ymm9, %ymm1, %ymm2, %ymm7
; AVX2-NEXT:    vpshufb {{.*#+}} xmm3 = xmm7[0,6,12],zero,zero,zero,xmm7[4,10],zero,zero,zero,xmm7[u,u,u,u,u]
; AVX2-NEXT:    vextracti128 $1, %ymm7, %xmm10
; AVX2-NEXT:    vpshufb {{.*#+}} xmm8 = zero,zero,zero,xmm10[2,8,14],zero,zero,xmm10[0,6,12,u,u,u,u,u]
; AVX2-NEXT:    vpor %xmm3, %xmm8, %xmm11
; AVX2-NEXT:    vperm2i128 {{.*#+}} ymm3 = ymm0[2,3],ymm4[2,3]
; AVX2-NEXT:    vpshufb {{.*#+}} ymm8 = zero,zero,zero,ymm3[2,8,14],zero,zero,zero,zero,zero,zero,zero,zero,ymm3[4,10],zero,zero,zero,ymm3[18,24,30],zero,zero,zero,zero,zero,zero,zero,zero,ymm3[20,26]
; AVX2-NEXT:    vperm2i128 {{.*#+}} ymm4 = ymm0[0,1],ymm4[0,1]
; AVX2-NEXT:    vpshufb {{.*#+}} ymm0 = ymm4[0,6,12],zero,zero,zero,zero,zero,zero,zero,zero,ymm4[2,8,14],zero,zero,ymm4[16,22,28],zero,zero,zero,zero,zero,zero,zero,zero,ymm4[18,24,30],zero,zero
; AVX2-NEXT:    vpor %ymm0, %ymm8, %ymm0
; AVX2-NEXT:    vmovdqa {{.*#+}} xmm8 = [255,255,255,255,255,255,255,255,255,255,255,0,0,0,0,0]
; AVX2-NEXT:    vpblendvb %ymm8, %ymm11, %ymm0, %ymm0
; AVX2-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vpshufb {{.*#+}} xmm7 = xmm7[1,7,13],zero,zero,zero,xmm7[5,11],zero,zero,zero,xmm7[u,u,u,u,u]
; AVX2-NEXT:    vpshufb {{.*#+}} xmm10 = zero,zero,zero,xmm10[3,9,15],zero,zero,xmm10[1,7,13,u,u,u,u,u]
; AVX2-NEXT:    vpor %xmm7, %xmm10, %xmm7
; AVX2-NEXT:    vpshufb {{.*#+}} ymm10 = zero,zero,zero,ymm3[3,9,15],zero,zero,zero,zero,zero,zero,zero,zero,ymm3[5,11],zero,zero,zero,ymm3[19,25,31],zero,zero,zero,zero,zero,zero,zero,zero,ymm3[21,27]
; AVX2-NEXT:    vpshufb {{.*#+}} ymm11 = ymm4[1,7,13],zero,zero,zero,zero,zero,zero,zero,zero,ymm4[3,9,15],zero,zero,ymm4[17,23,29],zero,zero,zero,zero,zero,zero,zero,zero,ymm4[19,25,31],zero,zero
; AVX2-NEXT:    vpor %ymm10, %ymm11, %ymm10
; AVX2-NEXT:    vpblendvb %ymm8, %ymm7, %ymm10, %ymm7
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm12 = <255,255,0,0,u,u,255,255,0,0,u,u,255,255,0,0,u,u,255,255,0,0,u,u,255,255,0,0,u,u,255,255>
; AVX2-NEXT:    vpblendvb %ymm12, %ymm2, %ymm1, %ymm10
; AVX2-NEXT:    vextracti128 $1, %ymm10, %xmm11
; AVX2-NEXT:    vpshufb {{.*#+}} xmm13 = zero,zero,zero,xmm11[4,10],zero,zero,zero,xmm11[2,8,14,u,u,u,u,u]
; AVX2-NEXT:    vpshufb {{.*#+}} xmm14 = xmm10[2,8,14],zero,zero,xmm10[0,6,12],zero,zero,zero,xmm10[u,u,u,u,u]
; AVX2-NEXT:    vpor %xmm13, %xmm14, %xmm13
; AVX2-NEXT:    vpshufb {{.*#+}} ymm14 = zero,zero,zero,ymm3[4,10],zero,zero,zero,zero,zero,zero,zero,zero,ymm3[0,6,12],zero,zero,zero,ymm3[20,26],zero,zero,zero,zero,zero,zero,zero,zero,ymm3[16,22,28]
; AVX2-NEXT:    vpshufb {{.*#+}} ymm15 = ymm4[2,8,14],zero,zero,zero,zero,zero,zero,zero,zero,ymm4[4,10],zero,zero,zero,ymm4[18,24,30],zero,zero,zero,zero,zero,zero,zero,zero,ymm4[20,26],zero,zero,zero
; AVX2-NEXT:    vpor %ymm14, %ymm15, %ymm14
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm15 = <u,u,255,255,0,0,u,u,255,255,0,0,u,u,255,255,0,0,u,u,255,255,0,0,u,u,255,255,0,0,u,u>
; AVX2-NEXT:    vpblendvb %ymm9, %ymm6, %ymm5, %ymm9
; AVX2-NEXT:    vpblendvb %ymm8, %ymm13, %ymm14, %ymm13
; AVX2-NEXT:    vpshufb {{.*#+}} xmm11 = zero,zero,zero,xmm11[5,11],zero,zero,zero,xmm11[3,9,15,u,u,u,u,u]
; AVX2-NEXT:    vpshufb {{.*#+}} xmm10 = xmm10[3,9,15],zero,zero,xmm10[1,7,13],zero,zero,zero,xmm10[u,u,u,u,u]
; AVX2-NEXT:    vpor %xmm11, %xmm10, %xmm10
; AVX2-NEXT:    vpshufb {{.*#+}} ymm11 = zero,zero,zero,ymm3[5,11],zero,zero,zero,zero,zero,zero,zero,zero,ymm3[1,7,13],zero,zero,zero,ymm3[21,27],zero,zero,zero,zero,zero,zero,zero,zero,ymm3[17,23,29]
; AVX2-NEXT:    vpshufb {{.*#+}} ymm14 = ymm4[3,9,15],zero,zero,zero,zero,zero,zero,zero,zero,ymm4[5,11],zero,zero,zero,ymm4[19,25,31],zero,zero,zero,zero,zero,zero,zero,zero,ymm4[21,27],zero,zero,zero
; AVX2-NEXT:    vpor %ymm11, %ymm14, %ymm11
; AVX2-NEXT:    vpshufb {{.*#+}} xmm14 = xmm9[u,u,u,u,u,0,6,12],zero,zero,zero,xmm9[4,10],zero,zero,zero
; AVX2-NEXT:    vpblendvb %ymm8, %ymm10, %ymm11, %ymm0
; AVX2-NEXT:    vextracti128 $1, %ymm9, %xmm8
; AVX2-NEXT:    vpshufb {{.*#+}} xmm10 = xmm8[u,u,u,u,u],zero,zero,zero,xmm8[2,8,14],zero,zero,xmm8[0,6,12]
; AVX2-NEXT:    vpor %xmm14, %xmm10, %xmm10
; AVX2-NEXT:    vinserti128 $1, %xmm10, %ymm0, %ymm10
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm11 = [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0]
; AVX2-NEXT:    vpblendvb %ymm11, %ymm13, %ymm10, %ymm13
; AVX2-NEXT:    vpblendvb %ymm15, %ymm5, %ymm6, %ymm10
; AVX2-NEXT:    vpshufb {{.*#+}} xmm9 = xmm9[u,u,u,u,u,1,7,13],zero,zero,zero,xmm9[5,11],zero,zero,zero
; AVX2-NEXT:    vpshufb {{.*#+}} xmm8 = xmm8[u,u,u,u,u],zero,zero,zero,xmm8[3,9,15],zero,zero,xmm8[1,7,13]
; AVX2-NEXT:    vpor %xmm9, %xmm8, %xmm8
; AVX2-NEXT:    vinserti128 $1, %xmm8, %ymm0, %ymm8
; AVX2-NEXT:    vpblendvb %ymm11, %ymm0, %ymm8, %ymm9
; AVX2-NEXT:    vpblendvb %ymm12, %ymm5, %ymm6, %ymm0
; AVX2-NEXT:    vextracti128 $1, %ymm0, %xmm5
; AVX2-NEXT:    vpshufb {{.*#+}} xmm6 = xmm5[u,u,u,u,u],zero,zero,zero,xmm5[4,10],zero,zero,zero,xmm5[2,8,14]
; AVX2-NEXT:    vpshufb {{.*#+}} xmm8 = xmm0[u,u,u,u,u,2,8,14],zero,zero,xmm0[0,6,12],zero,zero,zero
; AVX2-NEXT:    vpor %xmm6, %xmm8, %xmm6
; AVX2-NEXT:    vpblendvb %ymm15, %ymm2, %ymm1, %ymm1
; AVX2-NEXT:    vextracti128 $1, %ymm1, %xmm2
; AVX2-NEXT:    vpshufb {{.*#+}} xmm8 = zero,zero,xmm2[0,6,12],zero,zero,zero,xmm2[4,10,u,u,u,u,u,u]
; AVX2-NEXT:    vpshufb {{.*#+}} xmm12 = xmm1[4,10],zero,zero,zero,xmm1[2,8,14],zero,zero,xmm1[u,u,u,u,u,u]
; AVX2-NEXT:    vpor %xmm8, %xmm12, %xmm8
; AVX2-NEXT:    vpshufb {{.*#+}} ymm12 = ymm4[4,10],zero,zero,zero,zero,zero,zero,zero,zero,ymm4[0,6,12],zero,zero,zero,ymm4[20,26],zero,zero,zero,zero,zero,zero,zero,zero,ymm4[16,22,28],zero,zero,zero
; AVX2-NEXT:    vpshufb {{.*#+}} ymm14 = zero,zero,ymm3[0,6,12],zero,zero,zero,zero,zero,zero,zero,zero,ymm3[2,8,14],zero,zero,ymm3[16,22,28],zero,zero,zero,zero,zero,zero,zero,zero,ymm3[18,24,30]
; AVX2-NEXT:    vpor %ymm12, %ymm14, %ymm12
; AVX2-NEXT:    vpblendw {{.*#+}} xmm8 = xmm8[0,1,2,3,4],xmm12[5,6,7]
; AVX2-NEXT:    vpblendd {{.*#+}} ymm8 = ymm8[0,1,2,3],ymm12[4,5,6,7]
; AVX2-NEXT:    vinserti128 $1, %xmm6, %ymm0, %ymm6
; AVX2-NEXT:    vpblendvb %ymm11, %ymm8, %ymm6, %ymm6
; AVX2-NEXT:    vpshufb {{.*#+}} xmm5 = xmm5[u,u,u,u,u],zero,zero,zero,xmm5[5,11],zero,zero,zero,xmm5[3,9,15]
; AVX2-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[u,u,u,u,u,3,9,15],zero,zero,xmm0[1,7,13],zero,zero,zero
; AVX2-NEXT:    vpor %xmm5, %xmm0, %xmm0
; AVX2-NEXT:    vpshufb {{.*#+}} xmm2 = zero,zero,xmm2[1,7,13],zero,zero,zero,xmm2[5,11,u,u,u,u,u,u]
; AVX2-NEXT:    vpshufb {{.*#+}} xmm1 = xmm1[5,11],zero,zero,zero,xmm1[3,9,15],zero,zero,xmm1[u,u,u,u,u,u]
; AVX2-NEXT:    vpor %xmm2, %xmm1, %xmm1
; AVX2-NEXT:    vpshufb {{.*#+}} ymm2 = ymm4[5,11],zero,zero,zero,zero,zero,zero,zero,zero,ymm4[1,7,13],zero,zero,zero,ymm4[21,27],zero,zero,zero,zero,zero,zero,zero,zero,ymm4[17,23,29],zero,zero,zero
; AVX2-NEXT:    vpshufb {{.*#+}} ymm3 = zero,zero,ymm3[1,7,13],zero,zero,zero,zero,zero,zero,zero,zero,ymm3[3,9,15],zero,zero,ymm3[17,23,29],zero,zero,zero,zero,zero,zero,zero,zero,ymm3[19,25,31]
; AVX2-NEXT:    vpor %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpblendw {{.*#+}} xmm1 = xmm1[0,1,2,3,4],xmm2[5,6,7]
; AVX2-NEXT:    vpblendd {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm2[4,5,6,7]
; AVX2-NEXT:    vextracti128 $1, %ymm10, %xmm2
; AVX2-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm0
; AVX2-NEXT:    vpblendvb %ymm11, %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb {{.*#+}} xmm1 = xmm2[u,u,u,u,u,u],zero,zero,xmm2[0,6,12],zero,zero,zero,xmm2[4,10]
; AVX2-NEXT:    vpshufb {{.*#+}} xmm3 = xmm10[u,u,u,u,u,u,4,10],zero,zero,zero,xmm10[2,8,14],zero,zero
; AVX2-NEXT:    vpor %xmm1, %xmm3, %xmm1
; AVX2-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm1
; AVX2-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Reload
; AVX2-NEXT:    vpblendw {{.*#+}} ymm1 = ymm3[0,1,2],ymm1[3,4,5,6,7],ymm3[8,9,10],ymm1[11,12,13,14,15]
; AVX2-NEXT:    vpblendd {{.*#+}} ymm1 = ymm3[0,1,2,3],ymm1[4,5,6,7]
; AVX2-NEXT:    vpshufb {{.*#+}} xmm2 = xmm2[u,u,u,u,u,u],zero,zero,xmm2[1,7,13],zero,zero,zero,xmm2[5,11]
; AVX2-NEXT:    vpshufb {{.*#+}} xmm3 = xmm10[u,u,u,u,u,u,5,11],zero,zero,zero,xmm10[3,9,15],zero,zero
; AVX2-NEXT:    vpor %xmm2, %xmm3, %xmm2
; AVX2-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm2
; AVX2-NEXT:    vpblendw {{.*#+}} ymm2 = ymm7[0,1,2],ymm2[3,4,5,6,7],ymm7[8,9,10],ymm2[11,12,13,14,15]
; AVX2-NEXT:    vpblendd {{.*#+}} ymm2 = ymm7[0,1,2,3],ymm2[4,5,6,7]
; AVX2-NEXT:    vmovdqa %ymm1, (%rsi)
; AVX2-NEXT:    vmovdqa %ymm2, (%rdx)
; AVX2-NEXT:    vmovdqa %ymm13, (%rcx)
; AVX2-NEXT:    vmovdqa %ymm9, (%r8)
; AVX2-NEXT:    vmovdqa %ymm6, (%r9)
; AVX2-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-NEXT:    vmovdqa %ymm0, (%rax)
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: load_i8_stride6_vf32:
; AVX512:       # %bb.0:
; AVX512-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512-NEXT:    vmovdqa (%rdi), %ymm6
; AVX512-NEXT:    vmovdqa 32(%rdi), %ymm1
; AVX512-NEXT:    vmovdqa 64(%rdi), %ymm2
; AVX512-NEXT:    vmovdqa 128(%rdi), %ymm3
; AVX512-NEXT:    vinserti128 $1, 96(%rdi), %ymm2, %ymm0
; AVX512-NEXT:    vpshufb {{.*#+}} ymm4 = ymm0[0,6,12],zero,zero,zero,zero,zero,zero,zero,zero,ymm0[2,8,14],zero,zero,ymm0[16,22,28],zero,zero,zero,zero,zero,zero,zero,zero,ymm0[18,24,30],zero,zero
; AVX512-NEXT:    vperm2i128 {{.*#+}} ymm2 = ymm2[2,3],mem[2,3]
; AVX512-NEXT:    vpshufb {{.*#+}} ymm5 = zero,zero,zero,ymm2[2,8,14],zero,zero,zero,zero,zero,zero,zero,zero,ymm2[4,10],zero,zero,zero,ymm2[18,24,30],zero,zero,zero,zero,zero,zero,zero,zero,ymm2[20,26]
; AVX512-NEXT:    vpor %ymm4, %ymm5, %ymm4
; AVX512-NEXT:    movw $18724, %r10w # imm = 0x4924
; AVX512-NEXT:    kmovd %r10d, %k1
; AVX512-NEXT:    vpblendmw %ymm1, %ymm6, %ymm7 {%k1}
; AVX512-NEXT:    vpshufb {{.*#+}} xmm5 = xmm7[0,6,12],zero,zero,zero,xmm7[4,10],zero,zero,zero,xmm7[u,u,u,u,u]
; AVX512-NEXT:    vextracti128 $1, %ymm7, %xmm8
; AVX512-NEXT:    vpshufb {{.*#+}} xmm9 = zero,zero,zero,xmm8[2,8,14],zero,zero,xmm8[0,6,12,u,u,u,u,u]
; AVX512-NEXT:    vpor %xmm5, %xmm9, %xmm5
; AVX512-NEXT:    movl $4192256, %r10d # imm = 0x3FF800
; AVX512-NEXT:    kmovd %r10d, %k2
; AVX512-NEXT:    vmovdqu8 %ymm4, %ymm5 {%k2}
; AVX512-NEXT:    vmovdqa 160(%rdi), %ymm4
; AVX512-NEXT:    vpblendmw %ymm3, %ymm4, %ymm9 {%k1}
; AVX512-NEXT:    vextracti128 $1, %ymm9, %xmm10
; AVX512-NEXT:    vpshufb {{.*#+}} xmm11 = xmm10[u,u,u,u,u,u],zero,zero,xmm10[0,6,12],zero,zero,zero,xmm10[4,10]
; AVX512-NEXT:    vpshufb {{.*#+}} xmm12 = xmm9[u,u,u,u,u,u,4,10],zero,zero,zero,xmm9[2,8,14],zero,zero
; AVX512-NEXT:    vpor %xmm11, %xmm12, %xmm11
; AVX512-NEXT:    vinserti128 $1, %xmm11, %ymm0, %ymm11
; AVX512-NEXT:    vpblendw {{.*#+}} ymm11 = ymm5[0,1,2],ymm11[3,4,5,6,7],ymm5[8,9,10],ymm11[11,12,13,14,15]
; AVX512-NEXT:    vpblendd {{.*#+}} ymm5 = ymm5[0,1,2,3],ymm11[4,5,6,7]
; AVX512-NEXT:    vpshufb {{.*#+}} ymm11 = ymm0[1,7,13],zero,zero,zero,zero,zero,zero,zero,zero,ymm0[3,9,15],zero,zero,ymm0[17,23,29],zero,zero,zero,zero,zero,zero,zero,zero,ymm0[19,25,31],zero,zero
; AVX512-NEXT:    vpshufb {{.*#+}} ymm12 = zero,zero,zero,ymm2[3,9,15],zero,zero,zero,zero,zero,zero,zero,zero,ymm2[5,11],zero,zero,zero,ymm2[19,25,31],zero,zero,zero,zero,zero,zero,zero,zero,ymm2[21,27]
; AVX512-NEXT:    vpor %ymm11, %ymm12, %ymm11
; AVX512-NEXT:    vpshufb {{.*#+}} xmm7 = xmm7[1,7,13],zero,zero,zero,xmm7[5,11],zero,zero,zero,xmm7[u,u,u,u,u]
; AVX512-NEXT:    vpshufb {{.*#+}} xmm8 = zero,zero,zero,xmm8[3,9,15],zero,zero,xmm8[1,7,13,u,u,u,u,u]
; AVX512-NEXT:    vpor %xmm7, %xmm8, %xmm7
; AVX512-NEXT:    vmovdqu8 %ymm11, %ymm7 {%k2}
; AVX512-NEXT:    vpshufb {{.*#+}} xmm8 = xmm10[u,u,u,u,u,u],zero,zero,xmm10[1,7,13],zero,zero,zero,xmm10[5,11]
; AVX512-NEXT:    vpshufb {{.*#+}} xmm9 = xmm9[u,u,u,u,u,u,5,11],zero,zero,zero,xmm9[3,9,15],zero,zero
; AVX512-NEXT:    vpor %xmm8, %xmm9, %xmm8
; AVX512-NEXT:    vinserti128 $1, %xmm8, %ymm0, %ymm8
; AVX512-NEXT:    vpblendw {{.*#+}} ymm8 = ymm7[0,1,2],ymm8[3,4,5,6,7],ymm7[8,9,10],ymm8[11,12,13,14,15]
; AVX512-NEXT:    vpblendd {{.*#+}} ymm7 = ymm7[0,1,2,3],ymm8[4,5,6,7]
; AVX512-NEXT:    vpshufb {{.*#+}} ymm8 = ymm0[2,8,14],zero,zero,zero,zero,zero,zero,zero,zero,ymm0[4,10],zero,zero,zero,ymm0[18,24,30],zero,zero,zero,zero,zero,zero,zero,zero,ymm0[20,26],zero,zero,zero
; AVX512-NEXT:    vpshufb {{.*#+}} ymm9 = zero,zero,zero,ymm2[4,10],zero,zero,zero,zero,zero,zero,zero,zero,ymm2[0,6,12],zero,zero,zero,ymm2[20,26],zero,zero,zero,zero,zero,zero,zero,zero,ymm2[16,22,28]
; AVX512-NEXT:    vpor %ymm8, %ymm9, %ymm9
; AVX512-NEXT:    movw $9362, %di # imm = 0x2492
; AVX512-NEXT:    kmovd %edi, %k3
; AVX512-NEXT:    vpblendmw %ymm6, %ymm1, %ymm10 {%k3}
; AVX512-NEXT:    vextracti128 $1, %ymm10, %xmm11
; AVX512-NEXT:    vpshufb {{.*#+}} xmm8 = zero,zero,zero,xmm11[4,10],zero,zero,zero,xmm11[2,8,14,u,u,u,u,u]
; AVX512-NEXT:    vpshufb {{.*#+}} xmm12 = xmm10[2,8,14],zero,zero,xmm10[0,6,12],zero,zero,zero,xmm10[u,u,u,u,u]
; AVX512-NEXT:    vpor %xmm8, %xmm12, %xmm8
; AVX512-NEXT:    movl $2095104, %edi # imm = 0x1FF800
; AVX512-NEXT:    kmovd %edi, %k4
; AVX512-NEXT:    vmovdqu8 %ymm9, %ymm8 {%k4}
; AVX512-NEXT:    vpblendmw %ymm4, %ymm3, %ymm9 {%k1}
; AVX512-NEXT:    vpshufb {{.*#+}} xmm12 = xmm9[u,u,u,u,u,0,6,12],zero,zero,zero,xmm9[4,10],zero,zero,zero
; AVX512-NEXT:    vextracti128 $1, %ymm9, %xmm13
; AVX512-NEXT:    vpshufb {{.*#+}} xmm14 = xmm13[u,u,u,u,u],zero,zero,zero,xmm13[2,8,14],zero,zero,xmm13[0,6,12]
; AVX512-NEXT:    vpor %xmm12, %xmm14, %xmm12
; AVX512-NEXT:    vinserti128 $1, %xmm12, %ymm0, %ymm12
; AVX512-NEXT:    movl $-2097152, %edi # imm = 0xFFE00000
; AVX512-NEXT:    kmovd %edi, %k2
; AVX512-NEXT:    vmovdqu8 %ymm12, %ymm8 {%k2}
; AVX512-NEXT:    vpshufb {{.*#+}} ymm12 = ymm0[3,9,15],zero,zero,zero,zero,zero,zero,zero,zero,ymm0[5,11],zero,zero,zero,ymm0[19,25,31],zero,zero,zero,zero,zero,zero,zero,zero,ymm0[21,27],zero,zero,zero
; AVX512-NEXT:    vpshufb {{.*#+}} ymm14 = zero,zero,zero,ymm2[5,11],zero,zero,zero,zero,zero,zero,zero,zero,ymm2[1,7,13],zero,zero,zero,ymm2[21,27],zero,zero,zero,zero,zero,zero,zero,zero,ymm2[17,23,29]
; AVX512-NEXT:    vpor %ymm12, %ymm14, %ymm12
; AVX512-NEXT:    vpshufb {{.*#+}} xmm11 = zero,zero,zero,xmm11[5,11],zero,zero,zero,xmm11[3,9,15,u,u,u,u,u]
; AVX512-NEXT:    vpshufb {{.*#+}} xmm10 = xmm10[3,9,15],zero,zero,xmm10[1,7,13],zero,zero,zero,xmm10[u,u,u,u,u]
; AVX512-NEXT:    vpor %xmm11, %xmm10, %xmm10
; AVX512-NEXT:    vmovdqu8 %ymm12, %ymm10 {%k4}
; AVX512-NEXT:    vpshufb {{.*#+}} xmm9 = xmm9[u,u,u,u,u,1,7,13],zero,zero,zero,xmm9[5,11],zero,zero,zero
; AVX512-NEXT:    vpshufb {{.*#+}} xmm11 = xmm13[u,u,u,u,u],zero,zero,zero,xmm13[3,9,15],zero,zero,xmm13[1,7,13]
; AVX512-NEXT:    vpor %xmm9, %xmm11, %xmm9
; AVX512-NEXT:    vinserti128 $1, %xmm9, %ymm0, %ymm9
; AVX512-NEXT:    vmovdqu8 %ymm9, %ymm10 {%k2}
; AVX512-NEXT:    vmovdqu16 %ymm6, %ymm1 {%k1}
; AVX512-NEXT:    vextracti128 $1, %ymm1, %xmm6
; AVX512-NEXT:    vpshufb {{.*#+}} xmm9 = zero,zero,xmm6[0,6,12],zero,zero,zero,xmm6[4,10,u,u,u,u,u,u]
; AVX512-NEXT:    vpshufb {{.*#+}} xmm11 = xmm1[4,10],zero,zero,zero,xmm1[2,8,14],zero,zero,xmm1[u,u,u,u,u,u]
; AVX512-NEXT:    vpor %xmm9, %xmm11, %xmm9
; AVX512-NEXT:    vpshufb {{.*#+}} ymm11 = zero,zero,ymm2[0,6,12],zero,zero,zero,zero,zero,zero,zero,zero,ymm2[2,8,14],zero,zero,ymm2[16,22,28],zero,zero,zero,zero,zero,zero,zero,zero,ymm2[18,24,30]
; AVX512-NEXT:    vpshufb {{.*#+}} ymm12 = ymm0[4,10],zero,zero,zero,zero,zero,zero,zero,zero,ymm0[0,6,12],zero,zero,zero,ymm0[20,26],zero,zero,zero,zero,zero,zero,zero,zero,ymm0[16,22,28],zero,zero,zero
; AVX512-NEXT:    vpor %ymm11, %ymm12, %ymm11
; AVX512-NEXT:    vpblendw {{.*#+}} xmm9 = xmm9[0,1,2,3,4],xmm11[5,6,7]
; AVX512-NEXT:    vpblendd {{.*#+}} ymm9 = ymm9[0,1,2,3],ymm11[4,5,6,7]
; AVX512-NEXT:    vmovdqu16 %ymm3, %ymm4 {%k3}
; AVX512-NEXT:    vextracti128 $1, %ymm4, %xmm3
; AVX512-NEXT:    vpshufb {{.*#+}} xmm11 = xmm3[u,u,u,u,u],zero,zero,zero,xmm3[4,10],zero,zero,zero,xmm3[2,8,14]
; AVX512-NEXT:    vpshufb {{.*#+}} xmm12 = xmm4[u,u,u,u,u,2,8,14],zero,zero,xmm4[0,6,12],zero,zero,zero
; AVX512-NEXT:    vpor %xmm11, %xmm12, %xmm11
; AVX512-NEXT:    vinserti128 $1, %xmm11, %ymm0, %ymm11
; AVX512-NEXT:    vmovdqu8 %ymm11, %ymm9 {%k2}
; AVX512-NEXT:    vpshufb {{.*#+}} xmm6 = zero,zero,xmm6[1,7,13],zero,zero,zero,xmm6[5,11,u,u,u,u,u,u]
; AVX512-NEXT:    vpshufb {{.*#+}} xmm1 = xmm1[5,11],zero,zero,zero,xmm1[3,9,15],zero,zero,xmm1[u,u,u,u,u,u]
; AVX512-NEXT:    vpor %xmm6, %xmm1, %xmm1
; AVX512-NEXT:    vpshufb {{.*#+}} ymm2 = zero,zero,ymm2[1,7,13],zero,zero,zero,zero,zero,zero,zero,zero,ymm2[3,9,15],zero,zero,ymm2[17,23,29],zero,zero,zero,zero,zero,zero,zero,zero,ymm2[19,25,31]
; AVX512-NEXT:    vpshufb {{.*#+}} ymm0 = ymm0[5,11],zero,zero,zero,zero,zero,zero,zero,zero,ymm0[1,7,13],zero,zero,zero,ymm0[21,27],zero,zero,zero,zero,zero,zero,zero,zero,ymm0[17,23,29],zero,zero,zero
; AVX512-NEXT:    vpor %ymm2, %ymm0, %ymm0
; AVX512-NEXT:    vpblendw {{.*#+}} xmm1 = xmm1[0,1,2,3,4],xmm0[5,6,7]
; AVX512-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX512-NEXT:    vpshufb {{.*#+}} xmm1 = xmm3[u,u,u,u,u],zero,zero,zero,xmm3[5,11],zero,zero,zero,xmm3[3,9,15]
; AVX512-NEXT:    vpshufb {{.*#+}} xmm2 = xmm4[u,u,u,u,u,3,9,15],zero,zero,xmm4[1,7,13],zero,zero,zero
; AVX512-NEXT:    vpor %xmm1, %xmm2, %xmm1
; AVX512-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm1
; AVX512-NEXT:    vmovdqu8 %ymm1, %ymm0 {%k2}
; AVX512-NEXT:    vmovdqa %ymm5, (%rsi)
; AVX512-NEXT:    vmovdqa %ymm7, (%rdx)
; AVX512-NEXT:    vmovdqa %ymm8, (%rcx)
; AVX512-NEXT:    vmovdqa %ymm10, (%r8)
; AVX512-NEXT:    vmovdqa %ymm9, (%r9)
; AVX512-NEXT:    vmovdqa %ymm0, (%rax)
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %wide.vec = load <192 x i8>, ptr %in.vec, align 32

  %strided.vec0 = shufflevector <192 x i8> %wide.vec, <192 x i8> poison, <32 x i32> <i32 0, i32 6, i32 12, i32 18, i32 24, i32 30, i32 36, i32 42, i32 48, i32 54, i32 60, i32 66, i32 72, i32 78, i32 84, i32 90, i32 96, i32 102, i32 108, i32 114, i32 120, i32 126, i32 132, i32 138, i32 144, i32 150, i32 156, i32 162, i32 168, i32 174, i32 180, i32 186>
  %strided.vec1 = shufflevector <192 x i8> %wide.vec, <192 x i8> poison, <32 x i32> <i32 1, i32 7, i32 13, i32 19, i32 25, i32 31, i32 37, i32 43, i32 49, i32 55, i32 61, i32 67, i32 73, i32 79, i32 85, i32 91, i32 97, i32 103, i32 109, i32 115, i32 121, i32 127, i32 133, i32 139, i32 145, i32 151, i32 157, i32 163, i32 169, i32 175, i32 181, i32 187>
  %strided.vec2 = shufflevector <192 x i8> %wide.vec, <192 x i8> poison, <32 x i32> <i32 2, i32 8, i32 14, i32 20, i32 26, i32 32, i32 38, i32 44, i32 50, i32 56, i32 62, i32 68, i32 74, i32 80, i32 86, i32 92, i32 98, i32 104, i32 110, i32 116, i32 122, i32 128, i32 134, i32 140, i32 146, i32 152, i32 158, i32 164, i32 170, i32 176, i32 182, i32 188>
  %strided.vec3 = shufflevector <192 x i8> %wide.vec, <192 x i8> poison, <32 x i32> <i32 3, i32 9, i32 15, i32 21, i32 27, i32 33, i32 39, i32 45, i32 51, i32 57, i32 63, i32 69, i32 75, i32 81, i32 87, i32 93, i32 99, i32 105, i32 111, i32 117, i32 123, i32 129, i32 135, i32 141, i32 147, i32 153, i32 159, i32 165, i32 171, i32 177, i32 183, i32 189>
  %strided.vec4 = shufflevector <192 x i8> %wide.vec, <192 x i8> poison, <32 x i32> <i32 4, i32 10, i32 16, i32 22, i32 28, i32 34, i32 40, i32 46, i32 52, i32 58, i32 64, i32 70, i32 76, i32 82, i32 88, i32 94, i32 100, i32 106, i32 112, i32 118, i32 124, i32 130, i32 136, i32 142, i32 148, i32 154, i32 160, i32 166, i32 172, i32 178, i32 184, i32 190>
  %strided.vec5 = shufflevector <192 x i8> %wide.vec, <192 x i8> poison, <32 x i32> <i32 5, i32 11, i32 17, i32 23, i32 29, i32 35, i32 41, i32 47, i32 53, i32 59, i32 65, i32 71, i32 77, i32 83, i32 89, i32 95, i32 101, i32 107, i32 113, i32 119, i32 125, i32 131, i32 137, i32 143, i32 149, i32 155, i32 161, i32 167, i32 173, i32 179, i32 185, i32 191>

  store <32 x i8> %strided.vec0, ptr %out.vec0, align 32
  store <32 x i8> %strided.vec1, ptr %out.vec1, align 32
  store <32 x i8> %strided.vec2, ptr %out.vec2, align 32
  store <32 x i8> %strided.vec3, ptr %out.vec3, align 32
  store <32 x i8> %strided.vec4, ptr %out.vec4, align 32
  store <32 x i8> %strided.vec5, ptr %out.vec5, align 32

  ret void
}
