/*
 * ====================================================================
 * Copyright (c) 2000-2006 CollabNet.  All rights reserved.
 *
 * This software is licensed as described in the file COPYING, which
 * you should have received as part of this distribution.  The terms
 * are also available at http://subversion.tigris.org/license-1.html.
 * If newer versions of this license are posted there, you may use a
 * newer version instead, at your option.
 *
 * This software consists of voluntary contributions made by many
 * individuals.  For exact contribution history, see the revision
 * history and logs, available at http://subversion.tigris.org/.
 * ====================================================================
 */

#ifndef SVN_REPOS_DIFF_SUMMARIZE_H
#define SVN_REPOS_DIFF_SUMMARIZE_H

// skip with subversion 1.4 and up
#include <svn_version.h>
#if SVN_VER_MAJOR == 1 && SVN_VER_MINOR < 4

#include "svn_diff_summarize.h"

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */
 
/**
 * Produce a diff summary which lists the changed items between
 * @a path1/@a revision1 and @a path2/@a revision2 without creating text
 * deltas. @a path1 and @a path2 can be either working-copy paths or URLs.
 *
 * The function may report false positives if @a ignore_ancestry is false,
 * since a file might have been modified between two revisions, but still
 * have the same contents.
 *
 * Calls @a summarize_func with @a summarize_baton for each difference
 * with a @c svn_client_diff_summarize_t structure describing the difference.
 *
 * See svn_client_diff3() for a description of the other parameters.
 *
 * @since New in 1.4.
 */
svn_error_t *
svn_client_diff_summarize(const char *path1,
                          const svn_opt_revision_t *revision1,
                          const char *path2,
                          const svn_opt_revision_t *revision2,
                          svn_boolean_t recurse,
                          svn_boolean_t ignore_ancestry,
                          svn_client_diff_summarize_func_t summarize_func,
                          void *summarize_baton,
                          svn_client_ctx_t *ctx,
                          apr_pool_t *pool);

/**
 * Produce a diff summary which lists the changed items between the
 * filesystem object @a path in peg revision @a peg_revision, as it
 * changed between @a start_revision and @a end_revision. @a path can
 * be either a working-copy path or URL.
 *
 * If @a peg_revision is @c svn_opt_revision_unspecified, behave
 * identically to svn_client_diff_summarize(), using @a path for both
 * of that function's @a path1 and @a path2 argments.
 *
 * The function may report false positives if @a ignore_ancestry is false,
 * as described in the documentation for svn_client_diff_summarize().
 *
 * Call @a summarize_func with @a summarize_baton for each difference
 * with a @c svn_client_diff_summarize_t structure describing the difference.
 *
 * See svn_client_diff_peg3() for a description of the other parameters.
 *
 * @since New in 1.4.
 */
svn_error_t *
svn_client_diff_summarize_peg(const char *path,
                              const svn_opt_revision_t *peg_revision,
                              const svn_opt_revision_t *start_revision,
                              const svn_opt_revision_t *end_revision,
                              svn_boolean_t recurse,
                              svn_boolean_t ignore_ancestry,
                              svn_client_diff_summarize_func_t summarize_func,
                              void *summarize_baton,
                              svn_client_ctx_t *ctx,
                              apr_pool_t *pool);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif // SVN_VER_MAJOR == 1 && SVN_VER_MINOR < 4

#endif // SVN_REPOS_DIFF_SUMMARIZE_H
