/* sqlheavy-backup.c generated by valac 0.16.0, the Vala compiler
 * generated from sqlheavy-backup.vala, do not modify */


#include <glib.h>
#include <glib-object.h>
#include "SQLHeavy.h"
#include <stdlib.h>
#include <string.h>
#include <sqlite3.h>
#include <gio/gio.h>

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _sqlite3_backup_finish0(var) ((var == NULL) ? NULL : (var = (sqlite3_backup_finish (var), NULL)))
typedef struct _Block1Data Block1Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _SqlHeavyBackupExecuteAsyncData SqlHeavyBackupExecuteAsyncData;

struct _SQLHeavyBackupPrivate {
	SQLHeavyDatabase* _source_db;
	SQLHeavyDatabase* _destination_db;
	gchar* _source_db_name;
	gchar* _destination_db_name;
	sqlite3_backup* backup;
};

struct _Block1Data {
	int _ref_count_;
	SQLHeavyBackup * self;
	GError* err;
	GCancellable* cancellable;
	gpointer _async_data_;
};

struct _SqlHeavyBackupExecuteAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	SQLHeavyBackup* self;
	GCancellable* cancellable;
	Block1Data* _data1_;
	GCancellable* _tmp0_;
	GCancellable* _tmp1_;
	GError* _tmp2_;
	GError* _tmp3_;
	GError* _tmp4_;
	GError * _inner_error_;
};


static gpointer sql_heavy_backup_parent_class = NULL;

#define SQL_HEAVY_BACKUP_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SQL_HEAVY_TYPE_BACKUP, SQLHeavyBackupPrivate))
enum  {
	SQL_HEAVY_BACKUP_DUMMY_PROPERTY,
	SQL_HEAVY_BACKUP_SOURCE_DB,
	SQL_HEAVY_BACKUP_DESTINATION_DB,
	SQL_HEAVY_BACKUP_SOURCE_DB_NAME,
	SQL_HEAVY_BACKUP_DESTINATION_DB_NAME,
	SQL_HEAVY_BACKUP_REMAINING_PAGES,
	SQL_HEAVY_BACKUP_TOTAL_PAGES
};
gboolean sql_heavy_error_if_not_ok (gint ec, SQLHeavyQueryable* queryable, GError** error);
static void sql_heavy_backup_execute_async_data_free (gpointer _data);
static gboolean sql_heavy_backup_execute_async_co (SqlHeavyBackupExecuteAsyncData* _data_);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static gboolean __lambda10_ (Block1Data* _data1_);
const gchar* sql_heavy_sqlite_errstr (gint ec);
static gboolean ___lambda10__gsource_func (gpointer self);
sqlite3* sql_heavy_database_get_sqlite_db (SQLHeavyDatabase* self);
static GObject * sql_heavy_backup_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void sql_heavy_backup_finalize (GObject* obj);
static void _vala_sql_heavy_backup_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_sql_heavy_backup_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


/**
     * Backup 1 page of data
     *
     * See [[http://sqlite.org/c3ref/backup_finish.html|sqlite3_backup_step]]
     * for more details.
     *
     * @return true if there is more data, false if backup is complete
     * @see execute
     */
gboolean sql_heavy_backup_step (SQLHeavyBackup* self, GError** error) {
	gboolean result = FALSE;
	sqlite3_backup* _tmp0_;
	gint _tmp1_ = 0;
	gint ec;
	gint _tmp2_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->backup;
	_tmp1_ = sqlite3_backup_step (_tmp0_, 1);
	ec = _tmp1_;
	_tmp2_ = ec;
	switch (_tmp2_) {
		case SQLITE_OK:
		{
			g_signal_emit_by_name (self, "stepped");
			result = TRUE;
			return result;
		}
		case SQLITE_DONE:
		{
			g_signal_emit_by_name (self, "stepped");
			result = FALSE;
			return result;
		}
		default:
		{
			gint _tmp3_;
			_tmp3_ = ec;
			sql_heavy_error_if_not_ok (_tmp3_, NULL, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == SQL_HEAVY_ERROR) {
					g_propagate_error (error, _inner_error_);
					return FALSE;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return FALSE;
				}
			}
			g_assert_not_reached ();
		}
	}
}


/**
     * Complete backup
     *
     * @see execute_async
     * @see step
     */
void sql_heavy_backup_execute (SQLHeavyBackup* self, GError** error) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		gboolean _tmp1_;
		_tmp0_ = sql_heavy_backup_step (self, &_inner_error_);
		_tmp1_ = _tmp0_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == SQL_HEAVY_ERROR) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		if (!_tmp1_) {
			break;
		}
	}
}


static void sql_heavy_backup_execute_async_data_free (gpointer _data) {
	SqlHeavyBackupExecuteAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (SqlHeavyBackupExecuteAsyncData, _data_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void sql_heavy_backup_execute_async (SQLHeavyBackup* self, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	SqlHeavyBackupExecuteAsyncData* _data_;
	SQLHeavyBackup* _tmp0_;
	GCancellable* _tmp1_;
	GCancellable* _tmp2_;
	_data_ = g_slice_new0 (SqlHeavyBackupExecuteAsyncData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, sql_heavy_backup_execute_async);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, sql_heavy_backup_execute_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = cancellable;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_data_->cancellable = _tmp2_;
	sql_heavy_backup_execute_async_co (_data_);
}


void sql_heavy_backup_execute_finish (SQLHeavyBackup* self, GAsyncResult* _res_, GError** error) {
	SqlHeavyBackupExecuteAsyncData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
     * Complete backup asynchronously
     *
     * @param cancellable a GCancellable, or null
     */
static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		SQLHeavyBackup * self;
		self = _data1_->self;
		_g_error_free0 (_data1_->err);
		_g_object_unref0 (_data1_->cancellable);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}


static gpointer _g_error_copy0 (gpointer self) {
	return self ? g_error_copy (self) : NULL;
}


static gboolean __lambda10_ (Block1Data* _data1_) {
	SQLHeavyBackup * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	GCancellable* _tmp1_;
	gboolean _tmp4_;
	GError * _inner_error_ = NULL;
	self = _data1_->self;
	_tmp1_ = _data1_->cancellable;
	if (_tmp1_ != NULL) {
		GCancellable* _tmp2_;
		gboolean _tmp3_ = FALSE;
		_tmp2_ = _data1_->cancellable;
		_tmp3_ = g_cancellable_is_cancelled (_tmp2_);
		_tmp0_ = _tmp3_;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp4_ = _tmp0_;
	if (_tmp4_) {
		const gchar* _tmp5_ = NULL;
		GError* _tmp6_;
		_tmp5_ = sql_heavy_sqlite_errstr (SQLITE_INTERRUPT);
		_tmp6_ = g_error_new_literal (SQL_HEAVY_ERROR, SQL_HEAVY_ERROR_INTERRUPTED, _tmp5_);
		_g_error_free0 (_data1_->err);
		_data1_->err = _tmp6_;
		sql_heavy_backup_execute_async_co (_data1_->_async_data_);
		result = FALSE;
		return result;
	} else {
		{
			gboolean _tmp7_ = FALSE;
			gboolean _tmp8_;
			_tmp7_ = sql_heavy_backup_step (self, &_inner_error_);
			_tmp8_ = _tmp7_;
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == SQL_HEAVY_ERROR) {
					goto __catch0_sql_heavy_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
			if (_tmp8_) {
				result = TRUE;
				return result;
			} else {
				sql_heavy_backup_execute_async_co (_data1_->_async_data_);
				result = FALSE;
				return result;
			}
		}
		goto __finally0;
		__catch0_sql_heavy_error:
		{
			GError* e = NULL;
			GError* _tmp9_;
			GError* _tmp10_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp9_ = e;
			_tmp10_ = _g_error_copy0 (_tmp9_);
			_g_error_free0 (_data1_->err);
			_data1_->err = _tmp10_;
			result = FALSE;
			_g_error_free0 (e);
			return result;
		}
		__finally0:
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
}


static gboolean ___lambda10__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda10_ (self);
	return result;
}


static gboolean sql_heavy_backup_execute_async_co (SqlHeavyBackupExecuteAsyncData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data1_ = g_slice_new0 (Block1Data);
	_data_->_data1_->_ref_count_ = 1;
	_data_->_data1_->self = g_object_ref (_data_->self);
	_data_->_tmp0_ = _data_->cancellable;
	_data_->_tmp1_ = _g_object_ref0 (_data_->_tmp0_);
	_data_->_data1_->cancellable = _data_->_tmp1_;
	_data_->_data1_->_async_data_ = _data_;
	_data_->_data1_->err = NULL;
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda10__gsource_func, block1_data_ref (_data_->_data1_), block1_data_unref);
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	_data_->_tmp2_ = _data_->_data1_->err;
	if (_data_->_tmp2_ != NULL) {
		_data_->_tmp3_ = _data_->_data1_->err;
		_data_->_tmp4_ = _g_error_copy0 (_data_->_tmp3_);
		_data_->_inner_error_ = _data_->_tmp4_;
		if (_data_->_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			block1_data_unref (_data_->_data1_);
			_data_->_data1_ = NULL;
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			block1_data_unref (_data_->_data1_);
			_data_->_data1_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	block1_data_unref (_data_->_data1_);
	_data_->_data1_ = NULL;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


/**
     * Create a backup object, with named source and destination databases
     *
     * @param source source database
     * @param source_name source database name
     * @param destination destination database
     * @param destination_name destination database name
     */
SQLHeavyBackup* sql_heavy_backup_construct_with_db_names (GType object_type, SQLHeavyDatabase* source, const gchar* source_name, SQLHeavyDatabase* destination, const gchar* destination_name, GError** error) {
	SQLHeavyBackup * self = NULL;
	SQLHeavyDatabase* _tmp0_;
	SQLHeavyDatabase* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	sqlite3_backup* _tmp4_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (source != NULL, NULL);
	g_return_val_if_fail (destination != NULL, NULL);
	_tmp0_ = source;
	_tmp1_ = destination;
	_tmp2_ = source_name;
	_tmp3_ = destination_name;
	self = (SQLHeavyBackup*) g_object_new (object_type, "source-db", _tmp0_, "destination-db", _tmp1_, "source-db-name", _tmp2_, "destination-db-name", _tmp3_, NULL);
	_tmp4_ = self->priv->backup;
	if (_tmp4_ == NULL) {
		SQLHeavyDatabase* _tmp5_;
		sqlite3* _tmp6_ = NULL;
		gint _tmp7_ = 0;
		SQLHeavyDatabase* _tmp8_;
		_tmp5_ = self->priv->_destination_db;
		_tmp6_ = sql_heavy_database_get_sqlite_db (_tmp5_);
		_tmp7_ = sqlite3_errcode (_tmp6_);
		_tmp8_ = self->priv->_destination_db;
		sql_heavy_error_if_not_ok (_tmp7_, (SQLHeavyQueryable*) _tmp8_, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == SQL_HEAVY_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (self);
				return NULL;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
	}
	return self;
}


SQLHeavyBackup* sql_heavy_backup_new_with_db_names (SQLHeavyDatabase* source, const gchar* source_name, SQLHeavyDatabase* destination, const gchar* destination_name, GError** error) {
	return sql_heavy_backup_construct_with_db_names (SQL_HEAVY_TYPE_BACKUP, source, source_name, destination, destination_name, error);
}


/**
     * Create a backup object
     *
     * @param source source database
     * @param destination destination database
     */
SQLHeavyBackup* sql_heavy_backup_construct (GType object_type, SQLHeavyDatabase* source, SQLHeavyDatabase* destination, GError** error) {
	SQLHeavyBackup * self = NULL;
	SQLHeavyDatabase* _tmp0_;
	SQLHeavyDatabase* _tmp1_;
	sqlite3_backup* _tmp2_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (source != NULL, NULL);
	g_return_val_if_fail (destination != NULL, NULL);
	_tmp0_ = source;
	_tmp1_ = destination;
	self = (SQLHeavyBackup*) g_object_new (object_type, "source-db", _tmp0_, "destination-db", _tmp1_, NULL);
	_tmp2_ = self->priv->backup;
	if (_tmp2_ == NULL) {
		SQLHeavyDatabase* _tmp3_;
		sqlite3* _tmp4_ = NULL;
		gint _tmp5_ = 0;
		SQLHeavyDatabase* _tmp6_;
		_tmp3_ = self->priv->_destination_db;
		_tmp4_ = sql_heavy_database_get_sqlite_db (_tmp3_);
		_tmp5_ = sqlite3_errcode (_tmp4_);
		_tmp6_ = self->priv->_destination_db;
		sql_heavy_error_if_not_ok (_tmp5_, (SQLHeavyQueryable*) _tmp6_, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == SQL_HEAVY_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (self);
				return NULL;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
	}
	return self;
}


SQLHeavyBackup* sql_heavy_backup_new (SQLHeavyDatabase* source, SQLHeavyDatabase* destination, GError** error) {
	return sql_heavy_backup_construct (SQL_HEAVY_TYPE_BACKUP, source, destination, error);
}


SQLHeavyDatabase* sql_heavy_backup_get_source_db (SQLHeavyBackup* self) {
	SQLHeavyDatabase* result;
	SQLHeavyDatabase* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_source_db;
	result = _tmp0_;
	return result;
}


static void sql_heavy_backup_set_source_db (SQLHeavyBackup* self, SQLHeavyDatabase* value) {
	SQLHeavyDatabase* _tmp0_;
	SQLHeavyDatabase* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_source_db);
	self->priv->_source_db = _tmp1_;
	g_object_notify ((GObject *) self, "source-db");
}


SQLHeavyDatabase* sql_heavy_backup_get_destination_db (SQLHeavyBackup* self) {
	SQLHeavyDatabase* result;
	SQLHeavyDatabase* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_destination_db;
	result = _tmp0_;
	return result;
}


static void sql_heavy_backup_set_destination_db (SQLHeavyBackup* self, SQLHeavyDatabase* value) {
	SQLHeavyDatabase* _tmp0_;
	SQLHeavyDatabase* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_destination_db);
	self->priv->_destination_db = _tmp1_;
	g_object_notify ((GObject *) self, "destination-db");
}


const gchar* sql_heavy_backup_get_source_db_name (SQLHeavyBackup* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_source_db_name;
	result = _tmp0_;
	return result;
}


static void sql_heavy_backup_set_source_db_name (SQLHeavyBackup* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_source_db_name);
	self->priv->_source_db_name = _tmp1_;
	g_object_notify ((GObject *) self, "source-db-name");
}


const gchar* sql_heavy_backup_get_destination_db_name (SQLHeavyBackup* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_destination_db_name;
	result = _tmp0_;
	return result;
}


static void sql_heavy_backup_set_destination_db_name (SQLHeavyBackup* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_destination_db_name);
	self->priv->_destination_db_name = _tmp1_;
	g_object_notify ((GObject *) self, "destination-db-name");
}


gint sql_heavy_backup_get_remaining_pages (SQLHeavyBackup* self) {
	gint result;
	sqlite3_backup* _tmp0_;
	gint _tmp1_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->backup;
	_tmp1_ = sqlite3_backup_remaining (_tmp0_);
	result = _tmp1_;
	return result;
}


gint sql_heavy_backup_get_total_pages (SQLHeavyBackup* self) {
	gint result;
	sqlite3_backup* _tmp0_;
	gint _tmp1_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->backup;
	_tmp1_ = sqlite3_backup_pagecount (_tmp0_);
	result = _tmp1_;
	return result;
}


static GObject * sql_heavy_backup_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	SQLHeavyBackup * self;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	const gchar* _tmp8_;
	SQLHeavyDatabase* _tmp10_;
	sqlite3* _tmp11_ = NULL;
	const gchar* _tmp12_;
	SQLHeavyDatabase* _tmp13_;
	sqlite3* _tmp14_ = NULL;
	const gchar* _tmp15_;
	sqlite3_backup* _tmp16_;
	parent_class = G_OBJECT_CLASS (sql_heavy_backup_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = SQL_HEAVY_BACKUP (obj);
	_tmp0_ = self->priv->_destination_db_name;
	_tmp1_ = g_strdup (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		gchar* _tmp4_;
		_tmp4_ = g_strdup ("main");
		_g_free0 (_tmp2_);
		_tmp2_ = _tmp4_;
	}
	_tmp5_ = self->priv->_source_db_name;
	_tmp6_ = g_strdup (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = _tmp7_;
	if (_tmp8_ == NULL) {
		gchar* _tmp9_;
		_tmp9_ = g_strdup ("main");
		_g_free0 (_tmp7_);
		_tmp7_ = _tmp9_;
	}
	_tmp10_ = self->priv->_destination_db;
	_tmp11_ = sql_heavy_database_get_sqlite_db (_tmp10_);
	_tmp12_ = _tmp2_;
	_tmp13_ = self->priv->_source_db;
	_tmp14_ = sql_heavy_database_get_sqlite_db (_tmp13_);
	_tmp15_ = _tmp7_;
	_tmp16_ = sqlite3_backup_init (_tmp11_, _tmp12_, _tmp14_, _tmp15_);
	_sqlite3_backup_finish0 (self->priv->backup);
	self->priv->backup = _tmp16_;
	_g_free0 (_tmp7_);
	_g_free0 (_tmp2_);
	return obj;
}


static void sql_heavy_backup_class_init (SQLHeavyBackupClass * klass) {
	sql_heavy_backup_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SQLHeavyBackupPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_sql_heavy_backup_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_sql_heavy_backup_set_property;
	G_OBJECT_CLASS (klass)->constructor = sql_heavy_backup_constructor;
	G_OBJECT_CLASS (klass)->finalize = sql_heavy_backup_finalize;
	/**
	     * The database to backup
	     *
	     * @see source_db_name
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SQL_HEAVY_BACKUP_SOURCE_DB, g_param_spec_object ("source-db", "source-db", "source-db", SQL_HEAVY_TYPE_DATABASE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	/**
	     * The database to backup to
	     *
	     * @see destination_db_name
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SQL_HEAVY_BACKUP_DESTINATION_DB, g_param_spec_object ("destination-db", "destination-db", "destination-db", SQL_HEAVY_TYPE_DATABASE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	/**
	     * Name of the database to backup
	     *
	     * @see source_db
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SQL_HEAVY_BACKUP_SOURCE_DB_NAME, g_param_spec_string ("source-db-name", "source-db-name", "source-db-name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	/**
	     * Name of the database to backup to
	     *
	     * @see destination_db
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SQL_HEAVY_BACKUP_DESTINATION_DB_NAME, g_param_spec_string ("destination-db-name", "destination-db-name", "destination-db-name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	/**
	     * Number of pages left to be backed up
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SQL_HEAVY_BACKUP_REMAINING_PAGES, g_param_spec_int ("remaining-pages", "remaining-pages", "remaining-pages", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	     * Total number of pages
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SQL_HEAVY_BACKUP_TOTAL_PAGES, g_param_spec_int ("total-pages", "total-pages", "total-pages", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	     * Signal which is emitted each time {@link step} is called
	     */
	g_signal_new ("stepped", SQL_HEAVY_TYPE_BACKUP, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void sql_heavy_backup_instance_init (SQLHeavyBackup * self) {
	self->priv = SQL_HEAVY_BACKUP_GET_PRIVATE (self);
	self->priv->_source_db_name = NULL;
	self->priv->_destination_db_name = NULL;
}


static void sql_heavy_backup_finalize (GObject* obj) {
	SQLHeavyBackup * self;
	self = SQL_HEAVY_BACKUP (obj);
	_g_object_unref0 (self->priv->_source_db);
	_g_object_unref0 (self->priv->_destination_db);
	_g_free0 (self->priv->_source_db_name);
	_g_free0 (self->priv->_destination_db_name);
	_sqlite3_backup_finish0 (self->priv->backup);
	G_OBJECT_CLASS (sql_heavy_backup_parent_class)->finalize (obj);
}


/**
   * Backup manager
   */
GType sql_heavy_backup_get_type (void) {
	static volatile gsize sql_heavy_backup_type_id__volatile = 0;
	if (g_once_init_enter (&sql_heavy_backup_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SQLHeavyBackupClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sql_heavy_backup_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SQLHeavyBackup), 0, (GInstanceInitFunc) sql_heavy_backup_instance_init, NULL };
		GType sql_heavy_backup_type_id;
		sql_heavy_backup_type_id = g_type_register_static (G_TYPE_OBJECT, "SQLHeavyBackup", &g_define_type_info, 0);
		g_once_init_leave (&sql_heavy_backup_type_id__volatile, sql_heavy_backup_type_id);
	}
	return sql_heavy_backup_type_id__volatile;
}


static void _vala_sql_heavy_backup_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SQLHeavyBackup * self;
	self = SQL_HEAVY_BACKUP (object);
	switch (property_id) {
		case SQL_HEAVY_BACKUP_SOURCE_DB:
		g_value_set_object (value, sql_heavy_backup_get_source_db (self));
		break;
		case SQL_HEAVY_BACKUP_DESTINATION_DB:
		g_value_set_object (value, sql_heavy_backup_get_destination_db (self));
		break;
		case SQL_HEAVY_BACKUP_SOURCE_DB_NAME:
		g_value_set_string (value, sql_heavy_backup_get_source_db_name (self));
		break;
		case SQL_HEAVY_BACKUP_DESTINATION_DB_NAME:
		g_value_set_string (value, sql_heavy_backup_get_destination_db_name (self));
		break;
		case SQL_HEAVY_BACKUP_REMAINING_PAGES:
		g_value_set_int (value, sql_heavy_backup_get_remaining_pages (self));
		break;
		case SQL_HEAVY_BACKUP_TOTAL_PAGES:
		g_value_set_int (value, sql_heavy_backup_get_total_pages (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_sql_heavy_backup_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	SQLHeavyBackup * self;
	self = SQL_HEAVY_BACKUP (object);
	switch (property_id) {
		case SQL_HEAVY_BACKUP_SOURCE_DB:
		sql_heavy_backup_set_source_db (self, g_value_get_object (value));
		break;
		case SQL_HEAVY_BACKUP_DESTINATION_DB:
		sql_heavy_backup_set_destination_db (self, g_value_get_object (value));
		break;
		case SQL_HEAVY_BACKUP_SOURCE_DB_NAME:
		sql_heavy_backup_set_source_db_name (self, g_value_get_string (value));
		break;
		case SQL_HEAVY_BACKUP_DESTINATION_DB_NAME:
		sql_heavy_backup_set_destination_db_name (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



