-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

-- packed version of SPLeftCorner.
separate (SP_Relations)
function SP_Left_Corner (Parent : SP_Symbols.SP_Symbol;
                         Child  : SP_Symbols.SP_Symbol) return Boolean is
   Low_Index, High_Index : Left_Corner_Range;
   Found                 : Boolean;
begin
   if Parent in SP_Symbols.SP_Terminal then
      Found := False;
   else
      Low_Index  := Left_Corner_Range ((Rel_Tab (Parent) / Low) mod Low_Lim);
      High_Index := Left_Corner_Range ((Rel_Tab (Parent) / High) mod High_Lim);
      loop
         Found := Left_Corner (Low_Index) = Child;
         exit when Found or else Low_Index = High_Index;
         Low_Index := Low_Index + 1;
      end loop;
   end if;
   return Found;
end SP_Left_Corner;
