// $Id: XSLTProc.cpp,v 1.4 2003/01/30 12:38:31 spabsurd Exp $

// STDC++
#include <iostream>
#include <cassert>

// C libraries
#include <libexslt/exslt.h>  // Needed to enable exslt

// Local
#include <sp-gxmlcpp/XMLTree.hpp>
#include <sp-gxmlcpp/XMLDump.hpp>
#include <sp-gxmlcpp/XSLTrans.hpp>

int main(int argc, char** argv)
{
	// Support for exslt
	exsltRegisterAll();

	if (argc < 3)
	{
		std::cerr << "Usage: " << argv[0] << " XSL-FILE XML-FILE" << std::endl;
		exit(1);
	}

	std::ifstream xslFile(argv[1], std::ios::in);
	assert(xslFile.is_open());
	std::ifstream xmlFile(argv[2], std::ios::in);
	assert(xmlFile.is_open());

	SP::GXML::XSLTrans trans(xslFile);
	SP::GXML::XMLTree tree(xmlFile);

	std::auto_ptr<SP::GXML::XMLDump> dump(trans.trans(&tree));
	std::cout << dump.get()->get() << std::flush;
}
