## sgmldocs.make
# $Id: sgmldocs.make 4830 2003-04-13 14:16:29Z voss $

## Usage:
## 
##   appname = <name of application>
##   lang = <language token, eg. C or de>
##   SGMLFILES = <all of your files, the master file first>
##
##   include $(top_srcdir)/doc/sgmldocs.make

EXTRA_DIST = $(appname)-$(lang).omf topic.dat $(SGMLFILES) stamp.html

helpdir = $(datadir)/gnome/help/$(appname)/$(lang)
help_DATA = topic.dat $(SGMLFILES)

omfdir = @OMF_DIR@/$(appname)
omf_DATA = $(appname)-$(lang).omf

noinst_DATA = stamp.html
stamp.html: $(SGMLFILES)
	cd $(srcdir) && db2html $$(basename $<)
	-rm -rf $(appname).junk
	touch $(srcdir)/$@

install-data-local:
	$(mkinstalldirs) $(DESTDIR)$(helpdir)
	$(INSTALL_DATA) $(srcdir)/$(appname)/*.html $(DESTDIR)$(helpdir)
	-$(INSTALL_DATA) $(srcdir)/$(appname)/*.css $(DESTDIR)$(helpdir)

dist-hook:
	mkdir $(distdir)/$(appname)
	cp -p $(srcdir)/$(appname)/*.html $(distdir)/$(appname)/
	-cp -p $(srcdir)/$(appname)/*.css $(distdir)/$(appname)/

$(appname).ps: $(SGMLFILES)
	db2ps $<

CLEANFILES = $(appname).aux $(appname).log
DISTCLEANFILES = $(appname).tex $(appname).dvi $(appname).ps
