/* rygel-gst-data-source.c generated by valac 0.20.1, the Vala compiler
 * generated from rygel-gst-data-source.vala, do not modify */

/*
 * Copyright (C) 2012 Intel Corporation.
 *
 * Author: Jens Georg <jensg@openismus.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <rygel-server.h>
#include <gst/gst.h>
#include <gst/base/gstadapter.h>
#include <gst/base/gstbaseparse.h>
#include <gst/base/gstbasesink.h>
#include <gst/base/gstbasesrc.h>
#include <gst/base/gstbasetransform.h>
#include <gst/base/gstbitreader.h>
#include <gst/base/gstbytereader.h>
#include <gst/base/gstbytewriter.h>
#include <gst/base/gstcollectpads.h>
#include <gst/base/gstpushsrc.h>
#include <gst/base/gsttypefindhelper.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>


#define RYGEL_TYPE_GST_DATA_SOURCE (rygel_gst_data_source_get_type ())
#define RYGEL_GST_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_GST_DATA_SOURCE, RygelGstDataSource))
#define RYGEL_GST_DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_GST_DATA_SOURCE, RygelGstDataSourceClass))
#define RYGEL_IS_GST_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_GST_DATA_SOURCE))
#define RYGEL_IS_GST_DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_GST_DATA_SOURCE))
#define RYGEL_GST_DATA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_GST_DATA_SOURCE, RygelGstDataSourceClass))

typedef struct _RygelGstDataSource RygelGstDataSource;
typedef struct _RygelGstDataSourceClass RygelGstDataSourceClass;
typedef struct _RygelGstDataSourcePrivate RygelGstDataSourcePrivate;

#define RYGEL_TYPE_GST_SINK (rygel_gst_sink_get_type ())
#define RYGEL_GST_SINK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_GST_SINK, RygelGstSink))
#define RYGEL_GST_SINK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_GST_SINK, RygelGstSinkClass))
#define RYGEL_IS_GST_SINK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_GST_SINK))
#define RYGEL_IS_GST_SINK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_GST_SINK))
#define RYGEL_GST_SINK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_GST_SINK, RygelGstSinkClass))

typedef struct _RygelGstSink RygelGstSink;
typedef struct _RygelGstSinkClass RygelGstSinkClass;
typedef struct _RygelGstSinkPrivate RygelGstSinkPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _gst_mini_object_unref0(var) ((var == NULL) ? NULL : (var = (gst_mini_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

typedef enum  {
	RYGEL_GST_DATA_SOURCE_ERROR_NOT_COMPATIBLE
} RygelGstDataSourceError;
#define RYGEL_GST_DATA_SOURCE_ERROR rygel_gst_data_source_error_quark ()
struct _RygelGstDataSource {
	GObject parent_instance;
	RygelGstDataSourcePrivate * priv;
	GstElement* src;
};

struct _RygelGstDataSourceClass {
	GObjectClass parent_class;
};

struct _RygelGstDataSourcePrivate {
	GstPipeline* pipeline;
	RygelHTTPSeek* seek;
	RygelGstSink* sink;
	guint bus_watch_id;
};

struct _RygelGstSink {
	GstBaseSink parent_instance;
	RygelGstSinkPrivate * priv;
	GCancellable* cancellable;
};

struct _RygelGstSinkClass {
	GstBaseSinkClass parent_class;
};

typedef enum  {
	RYGEL_GST_ERROR_MISSING_PLUGIN,
	RYGEL_GST_ERROR_LINK
} RygelGstError;
#define RYGEL_GST_ERROR rygel_gst_error_quark ()

static gpointer rygel_gst_data_source_parent_class = NULL;
static RygelDataSourceIface* rygel_gst_data_source_rygel_data_source_parent_iface = NULL;

GQuark rygel_gst_data_source_error_quark (void);
GType rygel_gst_data_source_get_type (void) G_GNUC_CONST;
GType rygel_gst_sink_get_type (void) G_GNUC_CONST;
#define RYGEL_GST_DATA_SOURCE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_GST_DATA_SOURCE, RygelGstDataSourcePrivate))
enum  {
	RYGEL_GST_DATA_SOURCE_DUMMY_PROPERTY
};
RygelGstDataSource* rygel_gst_data_source_new (const gchar* uri, GError** error);
RygelGstDataSource* rygel_gst_data_source_construct (GType object_type, const gchar* uri, GError** error);
GstElement* rygel_gst_utils_create_source_for_uri (const gchar* uri);
RygelGstDataSource* rygel_gst_data_source_new_from_element (GstElement* element);
RygelGstDataSource* rygel_gst_data_source_construct_from_element (GType object_type, GstElement* element);
static void rygel_gst_data_source_real_start (RygelDataSource* base, RygelHTTPSeek* offsets, GError** error);
static void rygel_gst_data_source_prepare_pipeline (RygelGstDataSource* self, const gchar* name, GstElement* src, GError** error);
static void rygel_gst_data_source_real_freeze (RygelDataSource* base);
void rygel_gst_sink_freeze (RygelGstSink* self);
static void rygel_gst_data_source_real_thaw (RygelDataSource* base);
void rygel_gst_sink_thaw (RygelGstSink* self);
static void rygel_gst_data_source_real_stop (RygelDataSource* base);
static gboolean __lambda4_ (RygelGstDataSource* self);
static gboolean ___lambda4__gsource_func (gpointer self);
RygelGstSink* rygel_gst_sink_new (RygelDataSource* source, RygelHTTPSeek* offsets);
RygelGstSink* rygel_gst_sink_construct (GType object_type, RygelDataSource* source, RygelHTTPSeek* offsets);
static void rygel_gst_data_source_src_pad_added (RygelGstDataSource* self, GstElement* src, GstPad* src_pad);
static void _rygel_gst_data_source_src_pad_added_gst_element_pad_added (GstElement* _sender, GstPad* pad, gpointer self);
GQuark rygel_gst_error_quark (void);
static gboolean rygel_gst_data_source_bus_handler (RygelGstDataSource* self, GstBus* bus, GstMessage* message);
static gboolean _rygel_gst_data_source_bus_handler_gst_bus_func (GstBus* bus, GstMessage* message, gpointer self);
#define RYGEL_GST_SINK_NAME "http-gst-sink"
GstElement* rygel_gst_utils_get_rtp_depayloader (GstCaps* caps);
static inline void _dynamic_set_streamable0 (GstElement* obj, gboolean value);
static inline void _dynamic_set_fragment_duration1 (GstElement* obj, gint value);
static gboolean rygel_gst_data_source_perform_seek (RygelGstDataSource* self);
static gboolean ___lambda3_ (RygelGstDataSource* self);
static gboolean ____lambda3__gsource_func (gpointer self);
static void rygel_gst_data_source_finalize (GObject* obj);


GQuark rygel_gst_data_source_error_quark (void) {
	return g_quark_from_static_string ("rygel_gst_data_source_error-quark");
}


RygelGstDataSource* rygel_gst_data_source_construct (GType object_type, const gchar* uri, GError** error) {
	RygelGstDataSource * self = NULL;
	const gchar* _tmp0_;
	GstElement* _tmp1_ = NULL;
	GstElement* _tmp2_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (uri != NULL, NULL);
	self = (RygelGstDataSource*) g_object_new (object_type, NULL);
	_tmp0_ = uri;
	_tmp1_ = rygel_gst_utils_create_source_for_uri (_tmp0_);
	_g_object_unref0 (self->src);
	self->src = _tmp1_;
	_tmp2_ = self->src;
	if (_tmp2_ == NULL) {
		const gchar* _tmp3_ = NULL;
		gchar* _tmp4_;
		gchar* msg;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		GError* _tmp7_;
		_tmp3_ = _ ("Could not create GstElement for URI %s");
		_tmp4_ = g_strdup (_tmp3_);
		msg = _tmp4_;
		_tmp5_ = msg;
		_tmp6_ = uri;
		_tmp7_ = g_error_new (RYGEL_GST_DATA_SOURCE_ERROR, RYGEL_GST_DATA_SOURCE_ERROR_NOT_COMPATIBLE, _tmp5_, _tmp6_);
		_inner_error_ = _tmp7_;
		g_propagate_error (error, _inner_error_);
		_g_free0 (msg);
		_g_object_unref0 (self);
		return NULL;
	}
	return self;
}


RygelGstDataSource* rygel_gst_data_source_new (const gchar* uri, GError** error) {
	return rygel_gst_data_source_construct (RYGEL_TYPE_GST_DATA_SOURCE, uri, error);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


RygelGstDataSource* rygel_gst_data_source_construct_from_element (GType object_type, GstElement* element) {
	RygelGstDataSource * self = NULL;
	GstElement* _tmp0_;
	GstElement* _tmp1_;
	g_return_val_if_fail (element != NULL, NULL);
	self = (RygelGstDataSource*) g_object_new (object_type, NULL);
	_tmp0_ = element;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->src);
	self->src = _tmp1_;
	return self;
}


RygelGstDataSource* rygel_gst_data_source_new_from_element (GstElement* element) {
	return rygel_gst_data_source_construct_from_element (RYGEL_TYPE_GST_DATA_SOURCE, element);
}


static void rygel_gst_data_source_real_start (RygelDataSource* base, RygelHTTPSeek* offsets, GError** error) {
	RygelGstDataSource * self;
	RygelHTTPSeek* _tmp0_;
	RygelHTTPSeek* _tmp1_;
	GstElement* _tmp2_;
	RygelHTTPSeek* _tmp3_;
	GError * _inner_error_ = NULL;
	self = (RygelGstDataSource*) base;
	_tmp0_ = offsets;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->seek);
	self->priv->seek = _tmp1_;
	_tmp2_ = self->src;
	rygel_gst_data_source_prepare_pipeline (self, "RygelGstDataSource", _tmp2_, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp3_ = self->priv->seek;
	if (_tmp3_ != NULL) {
		GstPipeline* _tmp4_;
		_tmp4_ = self->priv->pipeline;
		gst_element_set_state ((GstElement*) _tmp4_, GST_STATE_PAUSED);
	} else {
		GstPipeline* _tmp5_;
		_tmp5_ = self->priv->pipeline;
		gst_element_set_state ((GstElement*) _tmp5_, GST_STATE_PLAYING);
	}
}


static void rygel_gst_data_source_real_freeze (RygelDataSource* base) {
	RygelGstDataSource * self;
	RygelGstSink* _tmp0_;
	self = (RygelGstDataSource*) base;
	_tmp0_ = self->priv->sink;
	rygel_gst_sink_freeze (_tmp0_);
}


static void rygel_gst_data_source_real_thaw (RygelDataSource* base) {
	RygelGstDataSource * self;
	RygelGstSink* _tmp0_;
	self = (RygelGstDataSource*) base;
	_tmp0_ = self->priv->sink;
	rygel_gst_sink_thaw (_tmp0_);
}


static gboolean __lambda4_ (RygelGstDataSource* self) {
	gboolean result = FALSE;
	g_signal_emit_by_name ((RygelDataSource*) self, "done");
	result = FALSE;
	return result;
}


static gboolean ___lambda4__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda4_ (self);
	return result;
}


static void rygel_gst_data_source_real_stop (RygelDataSource* base) {
	RygelGstDataSource * self;
	RygelGstSink* _tmp0_;
	GCancellable* _tmp1_;
	GstPipeline* _tmp2_;
	guint _tmp3_;
	self = (RygelGstDataSource*) base;
	_tmp0_ = self->priv->sink;
	_tmp1_ = _tmp0_->cancellable;
	g_cancellable_cancel (_tmp1_);
	_tmp2_ = self->priv->pipeline;
	gst_element_set_state ((GstElement*) _tmp2_, GST_STATE_NULL);
	_tmp3_ = self->priv->bus_watch_id;
	g_source_remove (_tmp3_);
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda4__gsource_func, g_object_ref (self), g_object_unref);
}


static void _rygel_gst_data_source_src_pad_added_gst_element_pad_added (GstElement* _sender, GstPad* pad, gpointer self) {
	rygel_gst_data_source_src_pad_added (self, _sender, pad);
}


static gboolean _rygel_gst_data_source_bus_handler_gst_bus_func (GstBus* bus, GstMessage* message, gpointer self) {
	gboolean result;
	result = rygel_gst_data_source_bus_handler (self, bus, message);
	return result;
}


static void rygel_gst_data_source_prepare_pipeline (RygelGstDataSource* self, const gchar* name, GstElement* src, GError** error) {
	RygelHTTPSeek* _tmp0_;
	RygelGstSink* _tmp1_;
	const gchar* _tmp2_;
	GstPipeline* _tmp3_;
	GstPipeline* _tmp4_;
	GstPipeline* _tmp7_;
	GstElement* _tmp8_;
	GstElement* _tmp9_;
	RygelGstSink* _tmp10_;
	GstElement* _tmp11_;
	guint16 _tmp12_;
	GstPipeline* _tmp28_;
	GstBus* _tmp29_ = NULL;
	GstBus* bus;
	GstBus* _tmp30_;
	guint _tmp31_ = 0U;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	g_return_if_fail (src != NULL);
	_tmp0_ = self->priv->seek;
	_tmp1_ = rygel_gst_sink_new ((RygelDataSource*) self, _tmp0_);
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->sink);
	self->priv->sink = _tmp1_;
	_tmp2_ = name;
	_tmp3_ = (GstPipeline*) gst_pipeline_new (_tmp2_);
	g_object_ref_sink (_tmp3_);
	_g_object_unref0 (self->priv->pipeline);
	self->priv->pipeline = _tmp3_;
	_tmp4_ = self->priv->pipeline;
	if (_tmp4_ == NULL) {
		const gchar* _tmp5_ = NULL;
		GError* _tmp6_;
		_tmp5_ = _ ("Failed to create pipeline");
		_tmp6_ = g_error_new_literal (RYGEL_DATA_SOURCE_ERROR, RYGEL_DATA_SOURCE_ERROR_GENERAL, _tmp5_);
		_inner_error_ = _tmp6_;
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp7_ = self->priv->pipeline;
	_tmp8_ = src;
	_tmp9_ = _g_object_ref0 (_tmp8_);
	_tmp10_ = self->priv->sink;
	gst_bin_add_many ((GstBin*) _tmp7_, _tmp9_, _tmp10_, NULL);
	_tmp11_ = src;
	_tmp12_ = _tmp11_->numsrcpads;
	if (((gint) _tmp12_) == 0) {
		GstElement* _tmp13_;
		_tmp13_ = src;
		g_signal_connect_object (_tmp13_, "pad-added", (GCallback) _rygel_gst_data_source_src_pad_added_gst_element_pad_added, self, 0);
	} else {
		GstElement* _tmp14_;
		RygelGstSink* _tmp15_;
		gboolean _tmp16_ = FALSE;
		_tmp14_ = src;
		_tmp15_ = self->priv->sink;
		_tmp16_ = gst_element_link (_tmp14_, (GstElement*) _tmp15_);
		if (!_tmp16_) {
			const gchar* _tmp17_ = NULL;
			GstElement* _tmp18_;
			gchar* _tmp19_ = NULL;
			gchar* _tmp20_;
			gchar* _tmp21_;
			RygelGstSink* _tmp22_;
			gchar* _tmp23_ = NULL;
			gchar* _tmp24_;
			gchar* _tmp25_;
			GError* _tmp26_;
			GError* _tmp27_;
			_tmp17_ = _ ("Failed to link %s to %s");
			_tmp18_ = src;
			g_object_get ((GstObject*) _tmp18_, "name", &_tmp19_, NULL);
			_tmp20_ = _tmp19_;
			_tmp21_ = _tmp20_;
			_tmp22_ = self->priv->sink;
			g_object_get ((GstObject*) _tmp22_, "name", &_tmp23_, NULL);
			_tmp24_ = _tmp23_;
			_tmp25_ = _tmp24_;
			_tmp26_ = g_error_new (RYGEL_GST_ERROR, RYGEL_GST_ERROR_LINK, _tmp17_, _tmp21_, _tmp25_);
			_tmp27_ = _tmp26_;
			_g_free0 (_tmp25_);
			_g_free0 (_tmp21_);
			_inner_error_ = _tmp27_;
			g_propagate_error (error, _inner_error_);
			return;
		}
	}
	_tmp28_ = self->priv->pipeline;
	_tmp29_ = gst_pipeline_get_bus (_tmp28_);
	bus = _tmp29_;
	_tmp30_ = bus;
	_tmp31_ = gst_bus_add_watch_full (_tmp30_, G_PRIORITY_DEFAULT, _rygel_gst_data_source_bus_handler_gst_bus_func, g_object_ref (self), g_object_unref);
	self->priv->bus_watch_id = _tmp31_;
	_g_object_unref0 (bus);
}


static void rygel_gst_data_source_src_pad_added (RygelGstDataSource* self, GstElement* src, GstPad* src_pad) {
	GstPad* _tmp0_;
	GstCaps* _tmp1_ = NULL;
	GstCaps* caps;
	GstPipeline* _tmp2_;
	GstElement* _tmp3_ = NULL;
	GstElement* sink;
	GstPad* sink_pad = NULL;
	GstCaps* _tmp4_;
	GstElement* _tmp5_ = NULL;
	GstElement* depay;
	GstElement* _tmp6_;
	GstPad* _tmp30_;
	GstPad* _tmp31_;
	GstPadLinkReturn _tmp32_ = 0;
	GstElement* _tmp42_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (src != NULL);
	g_return_if_fail (src_pad != NULL);
	_tmp0_ = src_pad;
	_tmp1_ = gst_pad_query_caps (_tmp0_, NULL);
	caps = _tmp1_;
	_tmp2_ = self->priv->pipeline;
	_tmp3_ = gst_bin_get_by_name ((GstBin*) _tmp2_, RYGEL_GST_SINK_NAME);
	sink = _tmp3_;
	_tmp4_ = caps;
	_tmp5_ = rygel_gst_utils_get_rtp_depayloader (_tmp4_);
	depay = _tmp5_;
	_tmp6_ = depay;
	if (_tmp6_ != NULL) {
		GstPipeline* _tmp7_;
		GstElement* _tmp8_;
		GstElement* _tmp9_;
		GstElement* _tmp10_;
		GstElement* _tmp11_;
		gboolean _tmp12_ = FALSE;
		GstElement* _tmp22_;
		GstPad* _tmp23_;
		GstCaps* _tmp24_;
		GstPad* _tmp25_ = NULL;
		_tmp7_ = self->priv->pipeline;
		_tmp8_ = depay;
		_tmp9_ = _g_object_ref0 (_tmp8_);
		gst_bin_add ((GstBin*) _tmp7_, _tmp9_);
		_tmp10_ = depay;
		_tmp11_ = sink;
		_tmp12_ = gst_element_link (_tmp10_, _tmp11_);
		if (!_tmp12_) {
			const gchar* _tmp13_ = NULL;
			GstElement* _tmp14_;
			gchar* _tmp15_ = NULL;
			gchar* _tmp16_;
			gchar* _tmp17_;
			GstElement* _tmp18_;
			gchar* _tmp19_ = NULL;
			gchar* _tmp20_;
			gchar* _tmp21_;
			_tmp13_ = _ ("Failed to link %s to %s");
			_tmp14_ = depay;
			g_object_get ((GstObject*) _tmp14_, "name", &_tmp15_, NULL);
			_tmp16_ = _tmp15_;
			_tmp17_ = _tmp16_;
			_tmp18_ = sink;
			g_object_get ((GstObject*) _tmp18_, "name", &_tmp19_, NULL);
			_tmp20_ = _tmp19_;
			_tmp21_ = _tmp20_;
			g_critical (_tmp13_, _tmp17_, _tmp21_);
			_g_free0 (_tmp21_);
			_g_free0 (_tmp17_);
			g_signal_emit_by_name ((RygelDataSource*) self, "done");
			_g_object_unref0 (depay);
			_g_object_unref0 (sink_pad);
			_g_object_unref0 (sink);
			_gst_mini_object_unref0 (caps);
			return;
		}
		_tmp22_ = depay;
		_tmp23_ = src_pad;
		_tmp24_ = caps;
		_tmp25_ = gst_element_get_compatible_pad (_tmp22_, _tmp23_, _tmp24_);
		_g_object_unref0 (sink_pad);
		sink_pad = _tmp25_;
	} else {
		GstElement* _tmp26_;
		GstPad* _tmp27_;
		GstCaps* _tmp28_;
		GstPad* _tmp29_ = NULL;
		_tmp26_ = sink;
		_tmp27_ = src_pad;
		_tmp28_ = caps;
		_tmp29_ = gst_element_get_compatible_pad (_tmp26_, _tmp27_, _tmp28_);
		_g_object_unref0 (sink_pad);
		sink_pad = _tmp29_;
	}
	_tmp30_ = src_pad;
	_tmp31_ = sink_pad;
	_tmp32_ = gst_pad_link_full (_tmp30_, _tmp31_, GST_PAD_LINK_CHECK_DEFAULT);
	if (_tmp32_ != GST_PAD_LINK_OK) {
		const gchar* _tmp33_ = NULL;
		GstPad* _tmp34_;
		gchar* _tmp35_ = NULL;
		gchar* _tmp36_;
		gchar* _tmp37_;
		GstPad* _tmp38_;
		gchar* _tmp39_ = NULL;
		gchar* _tmp40_;
		gchar* _tmp41_;
		_tmp33_ = _ ("Failed to link pad %s to %s");
		_tmp34_ = src_pad;
		g_object_get ((GstObject*) _tmp34_, "name", &_tmp35_, NULL);
		_tmp36_ = _tmp35_;
		_tmp37_ = _tmp36_;
		_tmp38_ = sink_pad;
		g_object_get ((GstObject*) _tmp38_, "name", &_tmp39_, NULL);
		_tmp40_ = _tmp39_;
		_tmp41_ = _tmp40_;
		g_critical (_tmp33_, _tmp37_, _tmp41_);
		_g_free0 (_tmp41_);
		_g_free0 (_tmp37_);
		g_signal_emit_by_name ((RygelDataSource*) self, "done");
		_g_object_unref0 (depay);
		_g_object_unref0 (sink_pad);
		_g_object_unref0 (sink);
		_gst_mini_object_unref0 (caps);
		return;
	}
	_tmp42_ = depay;
	if (_tmp42_ != NULL) {
		GstElement* _tmp43_;
		_tmp43_ = depay;
		gst_element_sync_state_with_parent (_tmp43_);
	}
	_g_object_unref0 (depay);
	_g_object_unref0 (sink_pad);
	_g_object_unref0 (sink);
	_gst_mini_object_unref0 (caps);
}


static inline void _dynamic_set_streamable0 (GstElement* obj, gboolean value) {
	g_object_set (obj, "streamable", value, NULL);
}


static inline void _dynamic_set_fragment_duration1 (GstElement* obj, gint value) {
	g_object_set (obj, "fragment-duration", value, NULL);
}


static gboolean ___lambda3_ (RygelGstDataSource* self) {
	gboolean result = FALSE;
	g_signal_emit_by_name ((RygelDataSource*) self, "done");
	result = FALSE;
	return result;
}


static gboolean ____lambda3__gsource_func (gpointer self) {
	gboolean result;
	result = ___lambda3_ (self);
	return result;
}


static gboolean rygel_gst_data_source_bus_handler (RygelGstDataSource* self, GstBus* bus, GstMessage* message) {
	gboolean result = FALSE;
	gboolean ret;
	GstMessage* _tmp0_;
	GstMessageType _tmp1_;
	gboolean _tmp52_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (bus != NULL, FALSE);
	g_return_val_if_fail (message != NULL, FALSE);
	ret = TRUE;
	_tmp0_ = message;
	_tmp1_ = _tmp0_->type;
	if (_tmp1_ == GST_MESSAGE_EOS) {
		ret = FALSE;
	} else {
		GstMessage* _tmp2_;
		GstMessageType _tmp3_;
		_tmp2_ = message;
		_tmp3_ = _tmp2_->type;
		if (_tmp3_ == GST_MESSAGE_STATE_CHANGED) {
			GstMessage* _tmp4_;
			GstObject* _tmp5_;
			GstPipeline* _tmp6_;
			GstState old_state = 0;
			GstState new_state = 0;
			GstMessage* _tmp7_;
			GstState _tmp8_ = 0;
			GstState _tmp9_ = 0;
			gboolean _tmp10_ = FALSE;
			GstState _tmp11_;
			gboolean _tmp13_;
			RygelHTTPSeek* _tmp23_;
			_tmp4_ = message;
			_tmp5_ = _tmp4_->src;
			_tmp6_ = self->priv->pipeline;
			if (_tmp5_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, gst_object_get_type (), GstObject)) {
				result = TRUE;
				return result;
			}
			_tmp7_ = message;
			gst_message_parse_state_changed (_tmp7_, &_tmp8_, &_tmp9_, NULL);
			old_state = _tmp8_;
			new_state = _tmp9_;
			_tmp11_ = old_state;
			if (_tmp11_ == GST_STATE_NULL) {
				GstState _tmp12_;
				_tmp12_ = new_state;
				_tmp10_ = _tmp12_ == GST_STATE_READY;
			} else {
				_tmp10_ = FALSE;
			}
			_tmp13_ = _tmp10_;
			if (_tmp13_) {
				GstPipeline* _tmp14_;
				GstElement* _tmp15_ = NULL;
				GstElement* element;
				GstElement* _tmp16_;
				_tmp14_ = self->priv->pipeline;
				_tmp15_ = gst_bin_get_by_name ((GstBin*) _tmp14_, "muxer");
				element = _tmp15_;
				_tmp16_ = element;
				if (_tmp16_ != NULL) {
					GstElement* _tmp17_;
					GstElementFactory* _tmp18_ = NULL;
					gchar* _tmp19_ = NULL;
					gchar* name;
					const gchar* _tmp20_;
					_tmp17_ = element;
					_tmp18_ = gst_element_get_factory (_tmp17_);
					_tmp19_ = gst_object_get_name ((GstObject*) _tmp18_);
					name = _tmp19_;
					_tmp20_ = name;
					if (g_strcmp0 (_tmp20_, "mp4mux") == 0) {
						GstElement* _tmp21_;
						GstElement* _tmp22_;
						_tmp21_ = element;
						_dynamic_set_streamable0 (_tmp21_, TRUE);
						_tmp22_ = element;
						_dynamic_set_fragment_duration1 (_tmp22_, 1000);
					}
					_g_free0 (name);
				}
				_g_object_unref0 (element);
			}
			_tmp23_ = self->priv->seek;
			if (_tmp23_ != NULL) {
				gboolean _tmp24_ = FALSE;
				GstState _tmp25_;
				gboolean _tmp27_;
				_tmp25_ = old_state;
				if (_tmp25_ == GST_STATE_READY) {
					GstState _tmp26_;
					_tmp26_ = new_state;
					_tmp24_ = _tmp26_ == GST_STATE_PAUSED;
				} else {
					_tmp24_ = FALSE;
				}
				_tmp27_ = _tmp24_;
				if (_tmp27_) {
					gboolean _tmp28_ = FALSE;
					_tmp28_ = rygel_gst_data_source_perform_seek (self);
					if (_tmp28_) {
						GstPipeline* _tmp29_;
						_tmp29_ = self->priv->pipeline;
						gst_element_set_state ((GstElement*) _tmp29_, GST_STATE_PLAYING);
					}
				}
			}
		} else {
			GError* err = NULL;
			gchar* err_msg = NULL;
			GstMessage* _tmp30_;
			GstMessageType _tmp31_;
			_tmp30_ = message;
			_tmp31_ = _tmp30_->type;
			if (_tmp31_ == GST_MESSAGE_ERROR) {
				GstMessage* _tmp32_;
				GError* _tmp33_ = NULL;
				gchar* _tmp34_ = NULL;
				const gchar* _tmp35_ = NULL;
				GstPipeline* _tmp36_;
				gchar* _tmp37_ = NULL;
				gchar* _tmp38_;
				gchar* _tmp39_;
				const gchar* _tmp40_;
				_tmp32_ = message;
				gst_message_parse_error (_tmp32_, &_tmp33_, &_tmp34_);
				_g_error_free0 (err);
				err = _tmp33_;
				_g_free0 (err_msg);
				err_msg = _tmp34_;
				_tmp35_ = _ ("Error from pipeline %s: %s");
				_tmp36_ = self->priv->pipeline;
				g_object_get ((GstObject*) _tmp36_, "name", &_tmp37_, NULL);
				_tmp38_ = _tmp37_;
				_tmp39_ = _tmp38_;
				_tmp40_ = err_msg;
				g_critical (_tmp35_, _tmp39_, _tmp40_);
				_g_free0 (_tmp39_);
				ret = FALSE;
			} else {
				GstMessage* _tmp41_;
				GstMessageType _tmp42_;
				_tmp41_ = message;
				_tmp42_ = _tmp41_->type;
				if (_tmp42_ == GST_MESSAGE_WARNING) {
					GstMessage* _tmp43_;
					GError* _tmp44_ = NULL;
					gchar* _tmp45_ = NULL;
					const gchar* _tmp46_ = NULL;
					GstPipeline* _tmp47_;
					gchar* _tmp48_ = NULL;
					gchar* _tmp49_;
					gchar* _tmp50_;
					const gchar* _tmp51_;
					_tmp43_ = message;
					gst_message_parse_warning (_tmp43_, &_tmp44_, &_tmp45_);
					_g_error_free0 (err);
					err = _tmp44_;
					_g_free0 (err_msg);
					err_msg = _tmp45_;
					_tmp46_ = _ ("Warning from pipeline %s: %s");
					_tmp47_ = self->priv->pipeline;
					g_object_get ((GstObject*) _tmp47_, "name", &_tmp48_, NULL);
					_tmp49_ = _tmp48_;
					_tmp50_ = _tmp49_;
					_tmp51_ = err_msg;
					g_warning (_tmp46_, _tmp50_, _tmp51_);
					_g_free0 (_tmp50_);
				}
			}
			_g_free0 (err_msg);
			_g_error_free0 (err);
		}
	}
	_tmp52_ = ret;
	if (!_tmp52_) {
		g_idle_add_full (G_PRIORITY_DEFAULT, ____lambda3__gsource_func, g_object_ref (self), g_object_unref);
	}
	result = ret;
	return result;
}


static gboolean rygel_gst_data_source_perform_seek (RygelGstDataSource* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	RygelHTTPSeek* _tmp1_;
	gboolean _tmp8_;
	GstSeekType stop_type;
	GstFormat format = 0;
	GstSeekFlags flags;
	gint64 start = 0LL;
	gint64 stop = 0LL;
	RygelHTTPSeek* _tmp9_;
	RygelHTTPSeekType _tmp10_;
	RygelHTTPSeekType _tmp11_;
	RygelHTTPSeek* _tmp26_;
	gint64 _tmp27_;
	gint64 _tmp28_;
	GstPipeline* _tmp29_;
	GstFormat _tmp30_;
	GstSeekFlags _tmp31_;
	gint64 _tmp32_;
	GstSeekType _tmp33_;
	gint64 _tmp34_;
	gboolean _tmp35_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->priv->seek;
	if (_tmp1_ != NULL) {
		RygelHTTPSeek* _tmp2_;
		gint64 _tmp3_;
		gint64 _tmp4_;
		RygelHTTPSeek* _tmp5_;
		gint64 _tmp6_;
		gint64 _tmp7_;
		_tmp2_ = self->priv->seek;
		_tmp3_ = rygel_http_seek_get_length (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = self->priv->seek;
		_tmp6_ = rygel_http_seek_get_total_length (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp0_ = _tmp4_ >= _tmp7_;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp8_ = _tmp0_;
	if (_tmp8_) {
		result = TRUE;
		return result;
	}
	stop_type = GST_SEEK_TYPE_NONE;
	flags = GST_SEEK_FLAG_FLUSH;
	_tmp9_ = self->priv->seek;
	_tmp10_ = rygel_http_seek_get_seek_type (_tmp9_);
	_tmp11_ = _tmp10_;
	if (_tmp11_ == RYGEL_HTTP_SEEK_TYPE_TIME) {
		GstSeekFlags _tmp12_;
		RygelHTTPSeek* _tmp13_;
		gint64 _tmp14_;
		gint64 _tmp15_;
		RygelHTTPSeek* _tmp16_;
		gint64 _tmp17_;
		gint64 _tmp18_;
		format = GST_FORMAT_TIME;
		_tmp12_ = flags;
		flags = _tmp12_ | GST_SEEK_FLAG_KEY_UNIT;
		_tmp13_ = self->priv->seek;
		_tmp14_ = rygel_http_seek_get_start (_tmp13_);
		_tmp15_ = _tmp14_;
		start = _tmp15_ * GST_USECOND;
		_tmp16_ = self->priv->seek;
		_tmp17_ = rygel_http_seek_get_stop (_tmp16_);
		_tmp18_ = _tmp17_;
		stop = _tmp18_ * GST_USECOND;
	} else {
		GstSeekFlags _tmp19_;
		RygelHTTPSeek* _tmp20_;
		gint64 _tmp21_;
		gint64 _tmp22_;
		RygelHTTPSeek* _tmp23_;
		gint64 _tmp24_;
		gint64 _tmp25_;
		format = GST_FORMAT_BYTES;
		_tmp19_ = flags;
		flags = _tmp19_ | GST_SEEK_FLAG_ACCURATE;
		_tmp20_ = self->priv->seek;
		_tmp21_ = rygel_http_seek_get_start (_tmp20_);
		_tmp22_ = _tmp21_;
		start = _tmp22_;
		_tmp23_ = self->priv->seek;
		_tmp24_ = rygel_http_seek_get_stop (_tmp23_);
		_tmp25_ = _tmp24_;
		stop = _tmp25_;
	}
	_tmp26_ = self->priv->seek;
	_tmp27_ = rygel_http_seek_get_stop (_tmp26_);
	_tmp28_ = _tmp27_;
	if (_tmp28_ > ((gint64) 0)) {
		stop_type = GST_SEEK_TYPE_SET;
	}
	_tmp29_ = self->priv->pipeline;
	_tmp30_ = format;
	_tmp31_ = flags;
	_tmp32_ = start;
	_tmp33_ = stop_type;
	_tmp34_ = stop;
	_tmp35_ = gst_element_seek ((GstElement*) _tmp29_, 1.0, _tmp30_, _tmp31_, GST_SEEK_TYPE_SET, _tmp32_, _tmp33_, _tmp34_ + 1);
	if (!_tmp35_) {
		const gchar* _tmp36_ = NULL;
		RygelHTTPSeek* _tmp37_;
		gint64 _tmp38_;
		gint64 _tmp39_;
		RygelHTTPSeek* _tmp40_;
		gint64 _tmp41_;
		gint64 _tmp42_;
		const gchar* _tmp43_ = NULL;
		GError* _tmp44_;
		GError* _tmp45_;
		_tmp36_ = _ ("Failed to seek to offsets %lld:%lld");
		_tmp37_ = self->priv->seek;
		_tmp38_ = rygel_http_seek_get_start (_tmp37_);
		_tmp39_ = _tmp38_;
		_tmp40_ = self->priv->seek;
		_tmp41_ = rygel_http_seek_get_stop (_tmp40_);
		_tmp42_ = _tmp41_;
		g_warning (_tmp36_, _tmp39_, _tmp42_);
		_tmp43_ = _ ("Failed to seek");
		_tmp44_ = g_error_new_literal (RYGEL_DATA_SOURCE_ERROR, RYGEL_DATA_SOURCE_ERROR_SEEK_FAILED, _tmp43_);
		_tmp45_ = _tmp44_;
		g_signal_emit_by_name ((RygelDataSource*) self, "error", _tmp45_);
		_g_error_free0 (_tmp45_);
		result = FALSE;
		return result;
	}
	result = TRUE;
	return result;
}


static void rygel_gst_data_source_class_init (RygelGstDataSourceClass * klass) {
	rygel_gst_data_source_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelGstDataSourcePrivate));
	G_OBJECT_CLASS (klass)->finalize = rygel_gst_data_source_finalize;
}


static void rygel_gst_data_source_rygel_data_source_interface_init (RygelDataSourceIface * iface) {
	rygel_gst_data_source_rygel_data_source_parent_iface = g_type_interface_peek_parent (iface);
	iface->start = (void (*)(RygelDataSource*, RygelHTTPSeek*, GError**)) rygel_gst_data_source_real_start;
	iface->freeze = (void (*)(RygelDataSource*)) rygel_gst_data_source_real_freeze;
	iface->thaw = (void (*)(RygelDataSource*)) rygel_gst_data_source_real_thaw;
	iface->stop = (void (*)(RygelDataSource*)) rygel_gst_data_source_real_stop;
}


static void rygel_gst_data_source_instance_init (RygelGstDataSource * self) {
	self->priv = RYGEL_GST_DATA_SOURCE_GET_PRIVATE (self);
	self->priv->seek = NULL;
}


static void rygel_gst_data_source_finalize (GObject* obj) {
	RygelGstDataSource * self;
	RygelGstSink* _tmp0_;
	GstPipeline* _tmp3_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_GST_DATA_SOURCE, RygelGstDataSource);
	_tmp0_ = self->priv->sink;
	if (_tmp0_ != NULL) {
		RygelGstSink* _tmp1_;
		GCancellable* _tmp2_;
		_tmp1_ = self->priv->sink;
		_tmp2_ = _tmp1_->cancellable;
		g_cancellable_cancel (_tmp2_);
	}
	_tmp3_ = self->priv->pipeline;
	if (_tmp3_ != NULL) {
		GstPipeline* _tmp4_;
		_tmp4_ = self->priv->pipeline;
		gst_element_set_state ((GstElement*) _tmp4_, GST_STATE_NULL);
	}
	_g_object_unref0 (self->src);
	_g_object_unref0 (self->priv->pipeline);
	_g_object_unref0 (self->priv->seek);
	_g_object_unref0 (self->priv->sink);
	G_OBJECT_CLASS (rygel_gst_data_source_parent_class)->finalize (obj);
}


GType rygel_gst_data_source_get_type (void) {
	static volatile gsize rygel_gst_data_source_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_gst_data_source_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelGstDataSourceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_gst_data_source_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelGstDataSource), 0, (GInstanceInitFunc) rygel_gst_data_source_instance_init, NULL };
		static const GInterfaceInfo rygel_data_source_info = { (GInterfaceInitFunc) rygel_gst_data_source_rygel_data_source_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType rygel_gst_data_source_type_id;
		rygel_gst_data_source_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelGstDataSource", &g_define_type_info, 0);
		g_type_add_interface_static (rygel_gst_data_source_type_id, RYGEL_TYPE_DATA_SOURCE, &rygel_data_source_info);
		g_once_init_leave (&rygel_gst_data_source_type_id__volatile, rygel_gst_data_source_type_id);
	}
	return rygel_gst_data_source_type_id__volatile;
}



