An implementation cannot be chosen unambiguously because of lack of information.

Erroneous code example:

```compile_fail,E0283
struct Foo;

impl Into<u32> for Foo {
    fn into(self) -> u32 { 1 }
}

let foo = Foo;
let bar: u32 = foo.into() * 1u32;
```

This error can be solved by adding type annotations that provide the missing
information to the compiler. In this case, the solution is to specify the
trait's type parameter:

```
struct Foo;

impl Into<u32> for Foo {
    fn into(self) -> u32 { 1 }
}

let foo = Foo;
let bar: u32 = Into::<u32>::into(foo) * 1u32;
```
