% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wikipages.R
\name{wt_wiki_url_parse}
\alias{wt_wiki_url_parse}
\title{Parse MediaWiki Page URL}
\usage{
wt_wiki_url_parse(url)
}
\arguments{
\item{url}{(character) MediaWiki page url.}
}
\value{
a list with elements:
\itemize{
\item wiki - wiki language
\item type - wikipedia type
\item page - page name
}
}
\description{
Parse a MediaWiki page url into its component parts (wiki name, wiki type,
and page title). Supports both static page urls and their equivalent API
calls.
}
\examples{
wt_wiki_url_parse(url="https://en.wikipedia.org/wiki/Malus_domestica")
wt_wiki_url_parse("https://en.wikipedia.org/w/api.php?page=Malus_domestica")
}
\seealso{
Other MediaWiki functions: \code{\link{wt_wiki_page_parse}},
  \code{\link{wt_wiki_page}},
  \code{\link{wt_wiki_url_build}}
}
\concept{MediaWiki functions}
