% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mw-log.R
\name{mw_log}
\alias{mw_log}
\title{Log requests to the standard output or other connection}
\usage{
mw_log(format = "dev", stream = "stdout")
}
\arguments{
\item{format}{Log format. Not implemented currently.}

\item{stream}{R connection to log to. \code{"stdout"} means the standard
output, \code{"stderr"} is the standard error. You can also supply a
connection object, but then you need to be sure that it will be
valid when the app is actually running.}
}
\value{
Handler function.
}
\description{
A one line log entry for every request. The output looks like this:\preformatted{GET http://127.0.0.1:3000/image 200 3 ms - 4742
}

and contains
\itemize{
\item the HTTP method,
\item the full request URL,
\item the HTTP status code of the response,
\item how long it took to process the response, in ms,
\item and the size of the response body, in bytes.
}
}
\examples{
app <- new_app()
app$use(mw_log())
app
}
\seealso{
Other middleware: 
\code{\link{mw_etag}()},
\code{\link{mw_json}()},
\code{\link{mw_multipart}()},
\code{\link{mw_raw}()},
\code{\link{mw_static}()},
\code{\link{mw_text}()},
\code{\link{mw_urlencoded}()}
}
\concept{middleware}
