\name{Johnson}
\alias{dJohnson}
\alias{pJohnson}
\alias{qJohnson}
\alias{rJohnson}
\alias{sJohnson}
\alias{moments}
\alias{JohnsonFit}
\title{The Johnson distributions}
\description{
  Density, distribution function, quantile function, random generator and summary function for the Johnson distributions.
}
\usage{
dJohnson(x, parms, log=FALSE)
pJohnson(q, parms, lower.tail=TRUE, log.p=FALSE)
qJohnson(p, parms, lower.tail=TRUE, log.p=FALSE)
rJohnson(n, parms)
sJohnson(parms)
JohnsonFit(t,moment="quant") 
moments(x)
}
\arguments{
	\item{x,q}{vector of quantities}
	\item{t}{observation vector, t=x, or moment vector, t=[mean,m2,m3,m4]}
	\item{p}{vector of probabilities}
	\item{n}{vector of numbers of observations}
	\item{parms}{list or list of lists each containing output of JohnsonFit()}
	\item{moment}{character scalar specifying t: "quant" (default), or "use," or "find"}
	\item{log, log.p}{logical vector; if TRUE, probabilities p are given as log(p)}
	\item{lower.tail}{logical vector; if TRUE (default), probabilities are \eqn{P[X <= x]}, otherwise, \eqn{P[X > x]}}
}
\value{
  The output values conform to the output from other such functions in \R. \code{dJohnson()} gives the density, \code{pJohnson()} the distribution function and \code{qJohnson()} its inverse. \code{rJohnson()} generates random numbers. \code{sJohnson()} produces a list containing parameters corresponding to the arguments -- mean, median, mode, variance, sd, third cental moment, fourth central moment, Pearson's skewness, skewness, and kurtosis.
\cr
\code{moments()} calculates the moment statistics of x as a vector with elements (mu, sigma, skew, kurt), where mu is the mean of x, sigma the SD of x with divisor \code{length(x)}, skew is the skewness and kurt the kurtosis. 
\cr
	\code{JohnsonFit()} outputs a list containing the Johnson parameters (gamma, delta, xi, lambda, type), where type is one of the Johnson types: "SN", "SL", "SB", or "SU". \code{JohnsonFit()} does this using 5 order statistics when moment="quant", when moment="find" it does this by using the first four moments of t calculated by the function \code{moments()}, when moment="use" it assumes that the vector t is [mean,m2,m3,m4], where mi is the ith moment about the mean. 
\cr
Fitting by moments is difficult numerically and often \code{JohnsonFit()} will report an error.
}

\details{
	The Johnson system (Johnson 1949) is a very flexible system for describing statistical distributions. It is defined by

\deqn{z=\gamma+\delta \log{f(u)}, u=(x-\xi)/\lambda}{z=gamma+delta log(f(u)), with u=(x-xi)/lambda}

and where \eqn{f( )} has four possible forms:

\tabular{ll}{
	SL:\tab \eqn{f(u)=u} the log normal \cr
	SU:\tab \eqn{f(u)=u+\sqrt{1+u^2}}{f(u)=u+sqrt(1+u^2)} an unbounded distribution\cr
	SB:\tab \eqn{f(u)=u/(1-u)} a bounded distribution\cr
	SN:\tab \eqn{\exp(u)} the normal
}

Estimation of the Johnson parameters may be done from quantiles. The procedure of Wheeler (1980) is used.

They may also be estimated from the moments.  Applied Statistics algorithm 99, due to Hill, Hill, and Holder (1976) has been translated into C for this implementation.  
}

\references{

Hill, I.D., Hill, R., and Holder, R.L. (1976). Fitting Johnson curves by moments. \emph{Applied Statistics.} AS99.

Johnson, N.L. (1949). Systems of frequency curves generated by methods of translation. \emph{Biometrika,} \bold{36.} 149-176.

Wheeler, R.E. (1980). Quantile estimators of Johnson curve parameters. \emph{Biometrika.} \bold{67-3} 725-728

}

\author{
	Bob Wheeler 
}
\examples{

xx<-rnorm(500)
parms<-JohnsonFit(xx)
sJohnson(parms)
plot(function(xx)dJohnson(xx,parms),-2,2)
pJohnson(1,parms)
parms2<-JohnsonFit(rexp(50))
qJohnson(p=0.5,list(parms,parms2))

## JohnsonFit with moment="find" and moment="use" is not always possible,
## and even when possible, may produce odd results.
## parms<-JohnsonFit(x,moment="find")

parms<-JohnsonFit(c(0,1,-.5,4),moment="use")

sJohnson(parms) 

# Fit illustration
data(cars)
xx<-cars$speed
parms<-JohnsonFit(xx)
hist(xx,freq=FALSE)
plot(function(x)dJohnson(x,parms),0,25,add=TRUE)


}
\keyword{distribution}