% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boot_ci.R
\name{boot_ci}
\alias{boot_ci}
\alias{boot_se}
\alias{boot_p}
\alias{boot_est}
\title{Standard error and confidence intervals for bootstrapped estimates}
\usage{
boot_ci(data, select = NULL, method = c("dist", "quantile"), ci.lvl = 0.95)

boot_se(data, select = NULL)

boot_p(data, select = NULL)

boot_est(data, select = NULL)
}
\arguments{
\item{data}{A data frame that containts the vector with bootstrapped
estimates, or directly the vector (see 'Examples').}

\item{select}{Optional, unquoted names of variables (as character vector)
with bootstrapped estimates. Required, if either \code{data} is a data frame
(and no vector), and only selected variables from \code{data} should be processed.}

\item{method}{Character vector, indicating if confidence intervals should be
based on bootstrap standard error, multiplied by the value of the quantile
function of the t-distribution (default), or on sample quantiles of the
bootstrapped values. See 'Details' in \code{boot_ci()}. May be abbreviated.}

\item{ci.lvl}{Numeric, the level of the confidence intervals.}
}
\value{
A data frame with either bootstrap estimate, standard error, the
lower and upper confidence intervals or the p-value for all bootstrapped
estimates.
}
\description{
Compute nonparametric bootstrap estimate, standard error,
confidence intervals and p-value for a vector of bootstrap
replicate estimates.
}
\details{
The methods require one or more vectors of bootstrap replicate
estimates as input.
\itemize{
\item \code{boot_est()}: returns the bootstrapped estimate, simply by computing
the mean value of all bootstrap estimates.
\item \code{boot_se()}: computes the nonparametric bootstrap standard error by
calculating the standard deviation of the input vector.
\item The mean value of the input vector and its standard error is used by
\code{boot_ci()} to calculate the lower and upper confidence interval,
assuming a t-distribution of bootstrap estimate replicates (for
\code{method = "dist"}, the default, which is
\verb{mean(x) +/- qt(.975, df = length(x) - 1) * sd(x)}); for
\code{method = "quantile"}, 95\\% sample quantiles are used to compute the
confidence intervals (\code{quantile(x, probs = c(0.025, 0.975))}). Use
\code{ci.lvl} to change the level for the confidence interval.
\item P-values from \code{boot_p()} are also based on t-statistics, assuming normal
distribution.
}
}
\examples{
data(efc)
bs <- bootstrap(efc, 100)

# now run models for each bootstrapped sample
bs$models <- lapply(
  bs$strap,
  function(.x) lm(neg_c_7 ~ e42dep + c161sex, data = .x)
)

# extract coefficient "dependency" and "gender" from each model
bs$dependency <- vapply(bs$models, function(x) coef(x)[2], numeric(1))
bs$gender <- vapply(bs$models, function(x) coef(x)[3], numeric(1))

# get bootstrapped confidence intervals
boot_ci(bs$dependency)

# compare with model fit
fit <- lm(neg_c_7 ~ e42dep + c161sex, data = efc)
confint(fit)[2, ]

# alternative function calls.
boot_ci(bs$dependency)
boot_ci(bs, "dependency")
boot_ci(bs, c("dependency", "gender"))
boot_ci(bs, c("dependency", "gender"), method = "q")


# compare coefficients
mean(bs$dependency)
boot_est(bs$dependency)
coef(fit)[2]
}
\references{
Carpenter J, Bithell J. Bootstrap confdence intervals: when, which, what? A practical guide for medical statisticians. Statist. Med. 2000; 19:1141-1164
}
\seealso{
[]\code{bootstrap()}] to generate nonparametric bootstrap samples.
}
