% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pluck.R
\name{attr_getter}
\alias{attr_getter}
\title{Create an attribute getter function}
\usage{
attr_getter(attr)
}
\arguments{
\item{attr}{An attribute name as string.}
}
\description{
\code{attr_getter()} generates an attribute accessor function; i.e., it
generates a function for extracting an attribute with a given
name. Unlike the base R \code{attr()} function with default options, it
doesn't use partial matching.
}
\examples{
# attr_getter() takes an attribute name and returns a function to
# access the attribute:
get_rownames <- attr_getter("row.names")
get_rownames(mtcars)

# These getter functions are handy in conjunction with pluck() for
# extracting deeply into a data structure. Here we'll first
# extract by position, then by attribute:
obj1 <- structure("obj", obj_attr = "foo")
obj2 <- structure("obj", obj_attr = "bar")
x <- list(obj1, obj2)

pluck(x, 1, attr_getter("obj_attr"))  # From first object
pluck(x, 2, attr_getter("obj_attr"))  # From second object
}
\seealso{
\code{\link[=pluck]{pluck()}}
}
