% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gumbel-distribution.R
\name{Gumbel}
\alias{Gumbel}
\alias{dgumbel}
\alias{pgumbel}
\alias{qgumbel}
\alias{rgumbel}
\title{Gumbel distribution}
\usage{
dgumbel(x, mu = 0, sigma = 1, log = FALSE)

pgumbel(q, mu = 0, sigma = 1, lower.tail = TRUE, log.p = FALSE)

qgumbel(p, mu = 0, sigma = 1, lower.tail = TRUE, log.p = FALSE)

rgumbel(n, mu = 0, sigma = 1)
}
\arguments{
\item{x, q}{vector of quantiles.}

\item{mu, sigma}{location and scale parameters. Scale must be positive.}

\item{log, log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{lower.tail}{logical; if TRUE (default), probabilities are \eqn{P[X \le x]}
otherwise, \eqn{P[X > x]}.}

\item{p}{vector of probabilities.}

\item{n}{number of observations. If \code{length(n) > 1},
the length is taken to be the number required.}
}
\description{
Density, distribution function, quantile function and random generation
for the Gumbel distribution.
}
\details{
Probability density function
\deqn{
f(x) = \frac{1}{\sigma} \exp\left(-\left(\frac{x-\mu}{\sigma} + \exp\left(-\frac{x-\mu}{\sigma}\right)\right)\right)
}{
f(x) = 1/\sigma * exp(-((x-\mu)/\sigma + exp(-(x-\mu)/\sigma)))
}

Cumulative distribution function
\deqn{
F(x) = \exp\left(-\exp\left(-\frac{x-\mu}{\sigma}\right)\right)
}{
F(x) = exp(-exp(-(x-\mu)/\sigma))
}

Quantile function
\deqn{
F^{-1}(p) = \mu - \sigma \log(-\log(p))
}{
F^-1(p) = \mu - \sigma * log(-log(p))
}
}
\examples{

x <- rgumbel(1e5, 5, 2)
hist(x, 100, freq = FALSE)
curve(dgumbel(x, 5, 2), 0, 25, col = "red", add = TRUE)
hist(pgumbel(x, 5, 2))
plot(ecdf(x))
curve(pgumbel(x, 5, 2), 0, 25, col = "red", lwd = 2, add = TRUE)

}
\references{
Bury, K. (1999). Statistical Distributions in Engineering.
Cambridge University Press.
}
\concept{Continuous}
\concept{Univariate}
\keyword{distribution}
